/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.AdviceSignature;
import org.aspectj.lang.reflect.ConstructorSignature;
import org.aspectj.lang.reflect.FieldSignature;
import org.aspectj.lang.reflect.MethodSignature;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.World;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.ModifiersPattern;
import org.aspectj.weaver.patterns.NamePattern;
import org.aspectj.weaver.patterns.PatternNode;
import org.aspectj.weaver.patterns.ThrowsPattern;
import org.aspectj.weaver.patterns.TypePattern;
import org.aspectj.weaver.patterns.TypePatternList;

public class SignaturePattern
extends PatternNode {
    private Member.Kind kind;
    private ModifiersPattern modifiers;
    private TypePattern returnType;
    private TypePattern declaringType;
    private NamePattern name;
    private TypePatternList parameterTypes;
    private ThrowsPattern throwsPattern;

    public SignaturePattern(Member.Kind kind, ModifiersPattern modifiers, TypePattern returnType, TypePattern declaringType, NamePattern name, TypePatternList parameterTypes, ThrowsPattern throwsPattern) {
        this.kind = kind;
        this.modifiers = modifiers;
        this.returnType = returnType;
        this.name = name;
        this.declaringType = declaringType;
        this.parameterTypes = parameterTypes;
        this.throwsPattern = throwsPattern;
    }

    public SignaturePattern resolveBindings(IScope scope, Bindings bindings) {
        if (this.returnType != null) {
            this.returnType = this.returnType.resolveBindings(scope, bindings, false, false);
        }
        if (this.declaringType != null) {
            this.declaringType = this.declaringType.resolveBindings(scope, bindings, false, false);
        }
        if (this.parameterTypes != null) {
            this.parameterTypes = this.parameterTypes.resolveBindings(scope, bindings, false, false);
        }
        if (this.throwsPattern != null) {
            this.throwsPattern = this.throwsPattern.resolveBindings(scope, bindings);
        }
        return this;
    }

    public SignaturePattern resolveBindingsFromRTTI() {
        if (this.returnType != null) {
            this.returnType = this.returnType.resolveBindingsFromRTTI(false, false);
        }
        if (this.declaringType != null) {
            this.declaringType = this.declaringType.resolveBindingsFromRTTI(false, false);
        }
        if (this.parameterTypes != null) {
            this.parameterTypes = this.parameterTypes.resolveBindingsFromRTTI(false, false);
        }
        if (this.throwsPattern != null) {
            this.throwsPattern = this.throwsPattern.resolveBindingsFromRTTI();
        }
        return this;
    }

    public void postRead(ResolvedTypeX enclosingType) {
        if (this.returnType != null) {
            this.returnType.postRead(enclosingType);
        }
        if (this.declaringType != null) {
            this.declaringType.postRead(enclosingType);
        }
        if (this.parameterTypes != null) {
            this.parameterTypes.postRead(enclosingType);
        }
    }

    public boolean matches(Member member, World world) {
        ResolvedMember sig = member.resolve(world);
        if (sig == null) {
            if (member.getName().startsWith("ajc$")) {
                return false;
            }
            world.getLint().unresolvableMember.signal(member.toString(), this.getSourceLocation());
            return false;
        }
        if (this.kind != member.getKind()) {
            return false;
        }
        if (this.kind == Member.ADVICE) {
            return true;
        }
        if (!this.modifiers.matches(sig.getModifiers())) {
            return false;
        }
        if (this.kind == Member.STATIC_INITIALIZATION) {
            return this.declaringType.matchesStatically(sig.getDeclaringType().resolve(world));
        }
        if (this.kind == Member.FIELD) {
            if (!this.returnType.matchesStatically(sig.getReturnType().resolve(world))) {
                return false;
            }
            if (!this.name.matches(sig.getName())) {
                return false;
            }
            boolean ret = this.declaringTypeMatch(member.getDeclaringType(), member, world);
            return ret;
        }
        if (this.kind == Member.METHOD) {
            if (!this.returnType.matchesStatically(sig.getReturnType().resolve(world))) {
                return false;
            }
            if (!this.name.matches(sig.getName())) {
                return false;
            }
            if (!this.parameterTypes.matches(world.resolve(sig.getParameterTypes()), TypePattern.STATIC).alwaysTrue()) {
                return false;
            }
            if (!this.throwsPattern.matches(sig.getExceptions(), world)) {
                return false;
            }
            return this.declaringTypeMatch(member.getDeclaringType(), member, world);
        }
        if (this.kind == Member.CONSTRUCTOR) {
            if (!this.parameterTypes.matches(world.resolve(sig.getParameterTypes()), TypePattern.STATIC).alwaysTrue()) {
                return false;
            }
            if (!this.throwsPattern.matches(sig.getExceptions(), world)) {
                return false;
            }
            return this.declaringType.matchesStatically(member.getDeclaringType().resolve(world));
        }
        return false;
    }

    public boolean matches(JoinPoint.StaticPart jpsp) {
        Signature sig = jpsp.getSignature();
        if (this.kind == Member.ADVICE && !(sig instanceof AdviceSignature)) {
            return false;
        }
        if (this.kind == Member.CONSTRUCTOR && !(sig instanceof ConstructorSignature)) {
            return false;
        }
        if (this.kind == Member.FIELD && !(sig instanceof FieldSignature)) {
            return false;
        }
        if (this.kind == Member.METHOD && !(sig instanceof MethodSignature)) {
            return false;
        }
        if (this.kind == Member.STATIC_INITIALIZATION && !jpsp.getKind().equals("staticinitialization")) {
            return false;
        }
        if (this.kind == Member.POINTCUT) {
            return false;
        }
        if (this.kind == Member.ADVICE) {
            return true;
        }
        if (!this.modifiers.matches(sig.getModifiers())) {
            return false;
        }
        if (this.kind == Member.STATIC_INITIALIZATION) {
            return this.declaringType.matchesStatically(sig.getDeclaringType());
        }
        if (this.kind == Member.FIELD) {
            Class returnTypeClass = ((FieldSignature)sig).getFieldType();
            if (!this.returnType.matchesStatically(returnTypeClass)) {
                return false;
            }
            if (!this.name.matches(sig.getName())) {
                return false;
            }
            boolean ret = this.declaringTypeMatch(sig);
            return ret;
        }
        if (this.kind == Member.METHOD) {
            MethodSignature msig = (MethodSignature)sig;
            Class returnTypeClass = msig.getReturnType();
            Class[] params = msig.getParameterTypes();
            Class[] exceptionTypes = msig.getExceptionTypes();
            if (!this.returnType.matchesStatically(returnTypeClass)) {
                return false;
            }
            if (!this.name.matches(sig.getName())) {
                return false;
            }
            if (!this.parameterTypes.matches(params, TypePattern.STATIC).alwaysTrue()) {
                return false;
            }
            if (!this.throwsPattern.matches(exceptionTypes)) {
                return false;
            }
            return this.declaringTypeMatch(sig);
        }
        if (this.kind == Member.CONSTRUCTOR) {
            ConstructorSignature csig = (ConstructorSignature)sig;
            Class[] params = csig.getParameterTypes();
            Class[] exceptionTypes = csig.getExceptionTypes();
            if (!this.parameterTypes.matches(params, TypePattern.STATIC).alwaysTrue()) {
                return false;
            }
            if (!this.throwsPattern.matches(exceptionTypes)) {
                return false;
            }
            return this.declaringType.matchesStatically(sig.getDeclaringType());
        }
        return false;
    }

    private boolean declaringTypeMatch(TypeX onTypeUnresolved, Member member, World world) {
        ResolvedTypeX onType = onTypeUnresolved.resolve(world);
        if (this.declaringType.matchesStatically(onType)) {
            return true;
        }
        Collection declaringTypes = member.getDeclaringTypes(world);
        Iterator i = declaringTypes.iterator();
        while (i.hasNext()) {
            ResolvedTypeX type = (ResolvedTypeX)i.next();
            if (!this.declaringType.matchesStatically(type)) continue;
            return true;
        }
        return false;
    }

    private boolean declaringTypeMatch(Signature sig) {
        Class onType = sig.getDeclaringType();
        if (this.declaringType.matchesStatically(onType)) {
            return true;
        }
        Collection declaringTypes = this.getDeclaringTypes(sig);
        Iterator it = declaringTypes.iterator();
        while (it.hasNext()) {
            Class pClass = (Class)it.next();
            if (!this.declaringType.matchesStatically(pClass)) continue;
            return true;
        }
        return false;
    }

    private Collection getDeclaringTypes(Signature sig) {
        ArrayList l;
        block8: {
            String memberName;
            Class onType;
            block7: {
                l = new ArrayList();
                onType = sig.getDeclaringType();
                memberName = sig.getName();
                if (!(sig instanceof FieldSignature)) break block7;
                Class fieldType = ((FieldSignature)sig).getFieldType();
                Class superType = onType;
                while (superType != null) {
                    try {
                        Field f = superType.getDeclaredField(memberName);
                        if (f.getType() == fieldType) {
                            l.add(superType);
                        }
                    }
                    catch (NoSuchFieldException nsf) {
                        // empty catch block
                    }
                    superType = superType.getSuperclass();
                }
                break block8;
            }
            if (!(sig instanceof MethodSignature)) break block8;
            Class[] paramTypes = ((MethodSignature)sig).getParameterTypes();
            Class superType = onType;
            while (superType != null) {
                try {
                    Method m = superType.getDeclaredMethod(memberName, paramTypes);
                    l.add(superType);
                }
                catch (NoSuchMethodException nsm) {
                    // empty catch block
                }
                superType = superType.getSuperclass();
            }
        }
        return l;
    }

    public NamePattern getName() {
        return this.name;
    }

    public TypePattern getDeclaringType() {
        return this.declaringType;
    }

    public Member.Kind getKind() {
        return this.kind;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.modifiers != ModifiersPattern.ANY) {
            buf.append(this.modifiers.toString());
            buf.append(' ');
        }
        if (this.kind == Member.STATIC_INITIALIZATION) {
            buf.append(this.declaringType.toString());
            buf.append(".<clinit>()");
        } else if (this.kind == Member.HANDLER) {
            buf.append("handler(");
            buf.append(this.parameterTypes.get(0));
            buf.append(")");
        } else {
            if (this.kind != Member.CONSTRUCTOR) {
                buf.append(this.returnType.toString());
                buf.append(' ');
            }
            if (this.declaringType != TypePattern.ANY) {
                buf.append(this.declaringType.toString());
                buf.append('.');
            }
            if (this.kind == Member.CONSTRUCTOR) {
                buf.append("new");
            } else {
                buf.append(this.name.toString());
            }
            if (this.kind == Member.METHOD || this.kind == Member.CONSTRUCTOR) {
                buf.append(this.parameterTypes.toString());
            }
        }
        return buf.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof SignaturePattern)) {
            return false;
        }
        SignaturePattern o = (SignaturePattern)other;
        return o.kind.equals(this.kind) && o.modifiers.equals(this.modifiers) && o.returnType.equals(this.returnType) && o.declaringType.equals(this.declaringType) && o.name.equals(this.name) && o.parameterTypes.equals(this.parameterTypes);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.kind.hashCode();
        result = 37 * result + this.modifiers.hashCode();
        result = 37 * result + this.returnType.hashCode();
        result = 37 * result + this.declaringType.hashCode();
        result = 37 * result + this.name.hashCode();
        result = 37 * result + this.parameterTypes.hashCode();
        return result;
    }

    public void write(DataOutputStream s) throws IOException {
        this.kind.write(s);
        this.modifiers.write(s);
        this.returnType.write(s);
        this.declaringType.write(s);
        this.name.write(s);
        this.parameterTypes.write(s);
        this.throwsPattern.write(s);
        this.writeLocation(s);
    }

    public static SignaturePattern read(DataInputStream s, ISourceContext context) throws IOException {
        Member.Kind kind = Member.Kind.read(s);
        ModifiersPattern modifiers = ModifiersPattern.read(s);
        TypePattern returnType = TypePattern.read(s, context);
        TypePattern declaringType = TypePattern.read(s, context);
        NamePattern name = NamePattern.read(s);
        TypePatternList parameterTypes = TypePatternList.read(s, context);
        ThrowsPattern throwsPattern = ThrowsPattern.read(s, context);
        SignaturePattern ret = new SignaturePattern(kind, modifiers, returnType, declaringType, name, parameterTypes, throwsPattern);
        ret.readLocation(context, s);
        return ret;
    }

    public ModifiersPattern getModifiers() {
        return this.modifiers;
    }

    public TypePatternList getParameterTypes() {
        return this.parameterTypes;
    }

    public TypePattern getReturnType() {
        return this.returnType;
    }

    public ThrowsPattern getThrowsPattern() {
        return this.throwsPattern;
    }
}

