/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.localstore;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.internal.localstore.CoreFileSystemLibrary;
import org.eclipse.core.internal.localstore.ILocalStoreConstants;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;

public class FileSystemStore
implements ILocalStoreConstants {
    private final byte[] buffer = new byte[8192];

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void copy(File source, File destination, int depth, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            monitor.beginTask(Policy.bind("localstore.copying", source.getAbsolutePath()), 1);
            Policy.checkCanceled(monitor);
            if (source.isDirectory()) {
                this.copyDirectory(source, destination, depth, Policy.subMonitorFor(monitor, 1));
            } else {
                this.copyFile(source, destination, Policy.subMonitorFor(monitor, 1));
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var5_7 = null;
            monitor.done();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void copyDirectory(File source, File destination, int depth, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            String[] children = source.list();
            if (children == null) {
                children = new String[]{};
            }
            monitor.beginTask(Policy.bind("localstore.copying", source.getAbsolutePath()), children.length);
            this.writeFolder(destination);
            if (depth == 0) {
                Object var7_6 = null;
                monitor.done();
                return;
            }
            if (depth == 1) {
                depth = 0;
            }
            int i = 0;
            while (i < children.length) {
                this.copy(new File(source, children[i]), new File(destination, children[i]), depth, Policy.subMonitorFor(monitor, 1));
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var7_8 = null;
            monitor.done();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void copyFile(File target, File destination, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            int totalWork = 1 + (int)target.length() / 8192;
            monitor.beginTask(Policy.bind("localstore.copying", target.getAbsolutePath()), totalWork);
            try {
                this.write(destination, this.read(target), false, monitor);
            }
            catch (CoreException e) {
                if (destination.isDirectory()) throw e;
                destination.delete();
                throw e;
            }
            long stat = CoreFileSystemLibrary.getStat(target.getAbsolutePath());
            long lastModified = CoreFileSystemLibrary.getLastModified(stat);
            destination.setLastModified(lastModified);
            CoreFileSystemLibrary.copyAttributes(target.getAbsolutePath(), destination.getAbsolutePath(), false);
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var9_10 = null;
            monitor.done();
            return;
        }
    }

    protected OutputStream createStream(File target, boolean append) throws CoreException {
        String path = target.getAbsolutePath();
        try {
            return new FileOutputStream(path, append);
        }
        catch (FileNotFoundException e) {
            String message;
            int code = 272;
            String parent = target.getParent();
            if (parent != null && CoreFileSystemLibrary.isReadOnly(parent)) {
                message = Policy.bind("localstore.readOnlyParent", path);
                code = 277;
            } else {
                message = target.isDirectory() ? Policy.bind("localstore.notAFile", path) : Policy.bind("localstore.couldNotWrite", path);
            }
            throw new ResourceException(code, new Path(path), message, e);
        }
    }

    public void delete(File target) throws CoreException {
        if (!Workspace.clear(target)) {
            String message = Policy.bind("localstore.couldnotDelete", target.getAbsolutePath());
            throw new ResourceException(273, new Path(target.getAbsolutePath()), message, null);
        }
    }

    public boolean delete(File root, MultiStatus status) {
        return this.delete(root, root.getAbsolutePath(), status);
    }

    protected boolean delete(File root, String filePath, MultiStatus status) {
        String[] list;
        boolean failedRecursive = false;
        if (root.isDirectory() && (list = root.list()) != null) {
            int parentLength = filePath.length();
            int i = 0;
            int imax = list.length;
            while (i < imax) {
                StringBuffer childBuffer = new StringBuffer(parentLength + list[i].length() + 1);
                childBuffer.append(filePath);
                childBuffer.append(File.separatorChar);
                childBuffer.append(list[i]);
                String childName = childBuffer.toString();
                failedRecursive = !this.delete(new File(childName), childName, status) || failedRecursive;
                ++i;
            }
        }
        boolean failedThis = false;
        try {
            if (!failedRecursive && root.exists()) {
                failedThis = !root.delete();
            }
        }
        catch (Exception e) {
            String message = Policy.bind("localstore.couldnotDelete", root.getAbsolutePath());
            status.add(new ResourceStatus(273, new Path(root.getAbsolutePath()), message, e));
            return false;
        }
        if (failedThis) {
            String message = null;
            message = CoreFileSystemLibrary.isReadOnly(root.getAbsolutePath()) ? Policy.bind("localstore.couldnotDeleteReadOnly", root.getAbsolutePath()) : Policy.bind("localstore.couldnotDelete", root.getAbsolutePath());
            status.add(new ResourceStatus(273, new Path(root.getAbsolutePath()), message, null));
        }
        return !failedRecursive && !failedThis;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getEncoding(File target) throws CoreException {
        InputStream input;
        block21: {
            block22: {
                block20: {
                    block19: {
                        block18: {
                            block17: {
                                input = null;
                                try {
                                    try {
                                        int second;
                                        int first;
                                        block24: {
                                            block23: {
                                                input = this.read(target);
                                                first = input.read() & 0xFF;
                                                second = input.read() & 0xFF;
                                                if (first == -1) break block23;
                                                if (second != -1) break block24;
                                            }
                                            Object var6_7 = null;
                                            if (input == null) return 0;
                                            break block17;
                                        }
                                        if (first == 254 && second == 255) {
                                            break block18;
                                        }
                                        if (first == 255 && second == 254) {
                                            break block19;
                                        }
                                        int third = input.read() & 0xFF;
                                        if (third == -1) {
                                            break block20;
                                        }
                                        if (first != 239 || second != 187 || third != 191) break block21;
                                        break block22;
                                    }
                                    catch (IOException e) {
                                        String message = Policy.bind("localstore.couldNotRead", target.getAbsolutePath());
                                        throw new ResourceException(271, new Path(target.getAbsolutePath()), message, e);
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var6_13 = null;
                                    if (input == null) throw throwable;
                                    try {
                                        input.close();
                                        throw throwable;
                                    }
                                    catch (IOException iOException) {
                                        throw throwable;
                                    }
                                }
                            }
                            try {}
                            catch (IOException iOException) {}
                            input.close();
                            return 0;
                        }
                        Object var6_8 = null;
                        if (input == null) return 4;
                        try {}
                        catch (IOException iOException) {}
                        input.close();
                        return 4;
                    }
                    Object var6_9 = null;
                    if (input == null) return 5;
                    try {}
                    catch (IOException iOException) {}
                    input.close();
                    return 5;
                }
                Object var6_10 = null;
                if (input == null) return 0;
                try {}
                catch (IOException iOException) {}
                input.close();
                return 0;
            }
            Object var6_11 = null;
            if (input == null) return 3;
            try {}
            catch (IOException iOException) {}
            input.close();
            return 3;
        }
        Object var6_12 = null;
        if (input == null) return 0;
        try {}
        catch (IOException iOException) {}
        input.close();
        return 0;
    }

    /*
     * Exception decompiling
     */
    public void move(File source, File destination, boolean force, IProgressMonitor monitor) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [3 : 478->481)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public InputStream read(File target) throws CoreException {
        try {
            return new FileInputStream(target);
        }
        catch (FileNotFoundException e) {
            String message = !target.exists() ? Policy.bind("localstore.fileNotFound", target.getAbsolutePath()) : (target.isDirectory() ? Policy.bind("localstore.notAFile", target.getAbsolutePath()) : Policy.bind("localstore.couldNotRead", target.getAbsolutePath()));
            throw new ResourceException(271, new Path(target.getAbsolutePath()), message, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void transferStreams(InputStream source, OutputStream destination, String path, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            byte[] byArray = this.buffer;
            // MONITORENTER : this.buffer
            while (true) {
                int bytesRead = -1;
                try {
                    bytesRead = source.read(this.buffer);
                }
                catch (IOException e) {
                    String msg = Policy.bind("localstore.failedReadDuringWrite", new String[]{path});
                    Path p = path == null ? null : new Path(path);
                    throw new ResourceException(271, p, msg, e);
                }
                if (bytesRead == -1) {
                    // MONITOREXIT : byArray
                    break;
                }
                try {
                    destination.write(this.buffer, 0, bytesRead);
                }
                catch (IOException e) {
                    String msg = Policy.bind("localstore.couldNotWrite", new String[]{path});
                    Path p = path == null ? null : new Path(path);
                    throw new ResourceException(272, p, msg, e);
                }
                monitor.worked(1);
            }
            Object var10_15 = null;
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            try {
                try {
                    source.close();
                }
                catch (IOException iOException) {}
                Object var12_19 = null;
            }
            catch (Throwable throwable2) {
                Object var12_18 = null;
                try {
                    destination.close();
                    throw throwable2;
                }
                catch (IOException iOException) {}
                throw throwable2;
            }
            try {}
            catch (IOException iOException) {}
            destination.close();
            throw throwable;
            throw throwable;
        }
        try {}
        catch (Throwable throwable) {
            Object var12_20 = null;
            try {}
            catch (IOException iOException) {}
            destination.close();
            throw throwable;
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        source.close();
        Object var12_21 = null;
        try {}
        catch (IOException iOException) {
            return;
        }
        destination.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(File target, InputStream content, boolean append, IProgressMonitor monitor) throws CoreException {
        try {
            String path = target.getAbsolutePath();
            this.writeFolder(target.getParentFile());
            this.transferStreams(content, this.createStream(target, append), path, monitor);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                content.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        content.close();
    }

    public void writeFolder(File target) throws CoreException {
        if (!target.exists()) {
            target.mkdirs();
        }
        if (!target.isDirectory()) {
            String path = target.getAbsolutePath();
            int code = 272;
            String message = Policy.bind("localstore.couldNotCreateFolder", path);
            String parent = target.getParent();
            if (parent != null && CoreFileSystemLibrary.isReadOnly(parent)) {
                message = Policy.bind("localstore.readOnlyParent", path);
                code = 277;
            }
            throw new ResourceException(code, new Path(path), message, null);
        }
    }
}

