/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.plugins;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.internal.plugins.PluginDescriptor;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class PluginRegistry
implements IPluginRegistry {
    private IExtensionRegistry extRegistry;
    private HashMap descriptors = new HashMap();

    public PluginRegistry() {
        this.extRegistry = InternalPlatform.getDefault().getRegistry();
        InternalPlatform.getDefault().getBundleContext().addBundleListener(new RegistryListener());
    }

    public IConfigurationElement[] getConfigurationElementsFor(String uniqueId) {
        return this.extRegistry.getConfigurationElementsFor(uniqueId);
    }

    public IConfigurationElement[] getConfigurationElementsFor(String pluginId, String pointId) {
        return this.extRegistry.getConfigurationElementsFor(pluginId, pointId);
    }

    public IConfigurationElement[] getConfigurationElementsFor(String pluginId, String pointId, String extensionId) {
        return this.extRegistry.getConfigurationElementsFor(pluginId, pointId, extensionId);
    }

    public IExtension getExtension(String xptUniqueId, String extUniqueId) {
        return this.extRegistry.getExtension(xptUniqueId, extUniqueId);
    }

    public IExtension getExtension(String pluginId, String xptSimpleId, String extId) {
        return this.extRegistry.getExtension(pluginId, xptSimpleId, extId);
    }

    public IExtensionPoint getExtensionPoint(String xptUniqueId) {
        return this.extRegistry.getExtensionPoint(xptUniqueId);
    }

    public IExtensionPoint getExtensionPoint(String plugin, String xpt) {
        return this.extRegistry.getExtensionPoint(plugin, xpt);
    }

    public IExtensionPoint[] getExtensionPoints() {
        return this.extRegistry.getExtensionPoints();
    }

    public IPluginDescriptor getPluginDescriptor(String plugin) {
        Bundle correspondingBundle = InternalPlatform.getDefault().getBundle(plugin);
        if (correspondingBundle == null) {
            return null;
        }
        return this.getPluginDescriptor(correspondingBundle);
    }

    private PluginDescriptor getPluginDescriptor(Bundle bundle) {
        if (InternalPlatform.getDefault().isFragment(bundle)) {
            return null;
        }
        HashMap hashMap = this.descriptors;
        synchronized (hashMap) {
            PluginDescriptor correspondingDescriptor = (PluginDescriptor)this.descriptors.get(bundle);
            if (bundle != null) {
                if (correspondingDescriptor == null || correspondingDescriptor.getBundle() != bundle) {
                    correspondingDescriptor = new PluginDescriptor(bundle);
                    this.descriptors.put(bundle, correspondingDescriptor);
                }
                return correspondingDescriptor;
            }
            if (correspondingDescriptor != null) {
                this.descriptors.remove(bundle);
            }
        }
        return null;
    }

    public IPluginDescriptor[] getPluginDescriptors(String plugin) {
        Bundle[] bundles = InternalPlatform.getDefault().getBundles(plugin, null);
        IPluginDescriptor[] results = new IPluginDescriptor[bundles.length];
        int added = 0;
        int i = 0;
        while (i < bundles.length) {
            PluginDescriptor desc = this.getPluginDescriptor(bundles[i]);
            if (desc != null) {
                results[added++] = desc;
            }
            ++i;
        }
        if (added == bundles.length) {
            return results;
        }
        if (added == 0) {
            return new IPluginDescriptor[0];
        }
        IPluginDescriptor[] toReturn = new IPluginDescriptor[added];
        System.arraycopy(results, 0, toReturn, 0, added);
        return toReturn;
    }

    public IPluginDescriptor getPluginDescriptor(String pluginId, PluginVersionIdentifier version) {
        Bundle[] bundles = InternalPlatform.getDefault().getBundles(pluginId, version.toString());
        if (bundles == null) {
            return null;
        }
        return this.getPluginDescriptor(bundles[0]);
    }

    public IPluginDescriptor[] getPluginDescriptors() {
        Bundle[] bundles = InternalPlatform.getDefault().getBundleContext().getBundles();
        ArrayList<PluginDescriptor> pds = new ArrayList<PluginDescriptor>(bundles.length);
        int i = 0;
        while (i < bundles.length) {
            boolean isFragment = InternalPlatform.getDefault().isFragment(bundles[i]);
            if (!(isFragment || bundles[i].getSymbolicName() == null || bundles[i].getState() != 4 && bundles[i].getState() != 8 && bundles[i].getState() != 32)) {
                pds.add(this.getPluginDescriptor(bundles[i]));
            }
            ++i;
        }
        IPluginDescriptor[] result = new IPluginDescriptor[pds.size()];
        return pds.toArray(result);
    }

    void logError(IStatus status) {
        InternalPlatform.getDefault().log(status);
        if (InternalPlatform.DEBUG) {
            System.out.println(status.getMessage());
        }
    }

    public class RegistryListener
    implements BundleListener {
        public void bundleChanged(BundleEvent event) {
            HashMap hashMap = PluginRegistry.this.descriptors;
            synchronized (hashMap) {
                if (event.getType() == 16 || event.getType() == 64) {
                    PluginRegistry.this.descriptors.remove(event.getBundle());
                }
            }
        }
    }
}

