/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.properties;

import java.io.File;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.core.internal.events.ILifecycleListener;
import org.eclipse.core.internal.events.LifecycleEvent;
import org.eclipse.core.internal.properties.PropertyStore;
import org.eclipse.core.internal.properties.QueryResults;
import org.eclipse.core.internal.properties.ResourceName;
import org.eclipse.core.internal.properties.StoredProperty;
import org.eclipse.core.internal.resources.IManager;
import org.eclipse.core.internal.resources.ProjectInfo;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.RootInfo;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Assert;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;

public class PropertyManager
implements IManager,
ILifecycleListener {
    protected Workspace workspace;

    public PropertyManager(Workspace workspace) {
        this.workspace = workspace;
    }

    public void closePropertyStore(IResource target) throws CoreException {
        PropertyStore store = this.getPropertyStoreOrNull(target);
        if (store == null) {
            return;
        }
        PropertyStore propertyStore = store;
        synchronized (propertyStore) {
            store.shutdown(null);
            this.setPropertyStore(target, null);
        }
    }

    public void copy(IResource source, IResource destination, int depth) throws CoreException {
        PropertyStore sourceStore = this.getPropertyStore(source);
        PropertyStore destinationStore = this.getPropertyStore(destination);
        PropertyStore propertyStore = sourceStore;
        synchronized (propertyStore) {
            this.assertRunning(source, sourceStore);
            PropertyStore propertyStore2 = destinationStore;
            synchronized (propertyStore2) {
                this.assertRunning(destination, destinationStore);
                this.copyProperties(source, destination, depth);
                sourceStore.commit();
                destinationStore.commit();
            }
        }
    }

    private void assertRunning(IResource target, PropertyStore store) throws CoreException {
        if (!store.isRunning()) {
            String message = Policy.bind("resources.mustExist", target.getFullPath().toString());
            throw new ResourceException(368, target.getFullPath(), message, null);
        }
    }

    protected void copyProperties(IResource source, IResource destination, int depth) throws CoreException {
        PropertyStore sourceStore = this.getPropertyStore(source);
        PropertyStore destStore = this.getPropertyStore(destination);
        ResourceName sourceName = this.getPropertyKey(source);
        ResourceName destName = this.getPropertyKey(destination);
        QueryResults results = sourceStore.getAll(sourceName, depth);
        Enumeration resources = results.getResourceNames();
        while (resources.hasMoreElements()) {
            ResourceName resourceName = (ResourceName)resources.nextElement();
            List properties = results.getResults(resourceName);
            if (properties.isEmpty()) continue;
            StoredProperty[] propsArray = new StoredProperty[properties.size()];
            propsArray = properties.toArray(propsArray);
            int segmentsToDrop = source.getProjectRelativePath().matchingFirstSegments(resourceName.getPath());
            IPath path = destName.getPath().append(resourceName.getPath().removeFirstSegments(segmentsToDrop));
            resourceName = new ResourceName(resourceName.getQualifier(), path);
            destStore.set(resourceName, propsArray, 0, 2);
        }
    }

    public void deleteProperties(IResource target, int depth) throws CoreException {
        switch (target.getType()) {
            case 1: 
            case 2: {
                PropertyStore store;
                PropertyStore propertyStore = store = this.getPropertyStore(target);
                synchronized (propertyStore) {
                    this.assertRunning(target, store);
                    store.removeAll(this.getPropertyKey(target), depth);
                    store.commit();
                    break;
                }
            }
            case 4: 
            case 8: {
                this.deletePropertyStore(target, true);
            }
        }
    }

    public void deleteResource(IResource target) throws CoreException {
        switch (target.getType()) {
            case 1: 
            case 2: 
            case 8: {
                this.deleteProperties(target, 2);
                break;
            }
            case 4: {
                this.deletePropertyStore(target, false);
            }
        }
    }

    protected void deletePropertyStore(IResource target, boolean restart) throws CoreException {
        PropertyStore store = this.getPropertyStoreOrNull(target);
        if (store == null) {
            return;
        }
        PropertyStore propertyStore = store;
        synchronized (propertyStore) {
            ResourceInfo info;
            store.shutdown(null);
            this.workspace.getMetaArea().getPropertyStoreLocation(target).toFile().delete();
            if (restart && (info = this.getPropertyHost(target).getResourceInfo(false, false)) != null) {
                info.setPropertyStore(null);
            }
        }
    }

    public String getProperty(IResource target, QualifiedName name) throws CoreException {
        PropertyStore store;
        PropertyStore propertyStore = store = this.getPropertyStore(target);
        synchronized (propertyStore) {
            this.assertRunning(target, store);
            StoredProperty result = store.get(this.getPropertyKey(target), name);
            return result == null ? null : result.getStringValue();
        }
    }

    protected Resource getPropertyHost(IResource target) {
        return (Resource)(target.getType() == 8 ? target : target.getProject());
    }

    protected ResourceName getPropertyKey(IResource target) {
        return new ResourceName("", target.getProjectRelativePath());
    }

    protected PropertyStore getPropertyStore(IResource target) throws CoreException {
        try {
            Resource host = this.getPropertyHost(target);
            ResourceInfo info = host.getResourceInfo(false, false);
            if (info == null) {
                String message = Policy.bind("properties.storeNotAvailable", target.getFullPath().toString());
                throw new ResourceException(271, target.getFullPath(), message, null);
            }
            PropertyStore store = info.getPropertyStore();
            if (store == null) {
                store = this.openPropertyStore(host);
            }
            return store;
        }
        catch (Exception e) {
            if (e instanceof CoreException) {
                throw (CoreException)e;
            }
            String message = Policy.bind("properties.storeNotAvailable", target.getFullPath().toString());
            throw new ResourceException(271, target.getFullPath(), message, e);
        }
    }

    protected PropertyStore getPropertyStoreOrNull(IResource target) {
        PropertyStore store;
        Resource host = this.getPropertyHost(target);
        ResourceInfo info = host.getResourceInfo(false, false);
        if (info != null && (store = info.getPropertyStore()) != null) {
            PropertyStore propertyStore = store;
            synchronized (propertyStore) {
                if (store.isRunning()) {
                    return store;
                }
            }
        }
        return null;
    }

    public void handleEvent(LifecycleEvent event) throws CoreException {
        if (event.kind == 1) {
            this.closePropertyStore(event.resource);
        }
    }

    protected PropertyStore openPropertyStore(IResource target) {
        int type = target.getType();
        Assert.isTrue(type != 1 && type != 2);
        IPath location = this.workspace.getMetaArea().getPropertyStoreLocation(target);
        File storeFile = location.toFile();
        storeFile.getParentFile().mkdirs();
        PropertyStore store = new PropertyStore(location);
        this.setPropertyStore(target, store);
        return store;
    }

    public void setProperty(IResource target, QualifiedName key, String value) throws CoreException {
        PropertyStore store;
        PropertyStore propertyStore = store = this.getPropertyStore(target);
        synchronized (propertyStore) {
            this.assertRunning(target, store);
            if (value == null) {
                store.remove(this.getPropertyKey(target), key);
            } else {
                StoredProperty prop = new StoredProperty(key, value);
                store.set(this.getPropertyKey(target), prop);
            }
            store.commit();
        }
    }

    protected void setPropertyStore(IResource target, PropertyStore value) {
        ResourceInfo info = this.getPropertyHost(target).getResourceInfo(false, false);
        if (info.getType() == 4) {
            ((ProjectInfo)info).setPropertyStore(value);
        } else {
            ((RootInfo)info).setPropertyStore(value);
        }
    }

    public void shutdown(IProgressMonitor monitor) throws CoreException {
        this.closePropertyStore(this.workspace.getRoot());
    }

    public void startup(IProgressMonitor monitor) throws CoreException {
        this.workspace.addLifecycleListener(this);
    }
}

