/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.internal.localstore.CoreFileSystemLibrary;
import org.eclipse.core.internal.resources.Container;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Assert;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class File
extends Resource
implements IFile {
    protected File(IPath path, Workspace container) {
        super(path, container);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void appendContents(InputStream content, int updateFlags, IProgressMonitor monitor) throws CoreException {
        boolean force = (updateFlags & 1) != 0;
        boolean keepHistory = (updateFlags & 2) != 0;
        monitor = Policy.monitorFor(monitor);
        try {
            String message = Policy.bind("resources.settingContents", this.getFullPath().toString());
            monitor.beginTask(message, Policy.totalWork);
            Assert.isNotNull(content, "Content cannot be null.");
            if (this.workspace.shouldValidate) {
                this.workspace.validateSave(this);
            }
            ISchedulingRule rule = this.workspace.getRuleFactory().modifyRule(this);
            try {
                try {
                    this.workspace.prepareOperation(rule, monitor);
                    ResourceInfo info = this.getResourceInfo(false, false);
                    this.checkAccessible(this.getFlags(info));
                    this.workspace.beginOperation(true);
                    this.internalSetContents(content, this.getLocalManager().locationFor(this), force, keepHistory, true, Policy.subMonitorFor(monitor, Policy.opWork));
                }
                catch (OperationCanceledException e) {
                    this.workspace.getWorkManager().operationCanceled();
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.buildWork));
                throw throwable;
            }
            {
                Object var9_12 = null;
                this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.buildWork));
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var11_15 = null;
            monitor.done();
            return;
        }
    }

    public void appendContents(InputStream content, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        int updateFlags = force ? 1 : 0;
        this.appendContents(content, updateFlags |= keepHistory ? 2 : 0, monitor);
    }

    public IFolder changeToFolder() throws CoreException {
        this.getPropertyManager().deleteProperties(this, 0);
        IFolder result = this.workspace.getRoot().getFolder(this.path);
        if (this.isLinked()) {
            IPath location = this.getRawLocation();
            this.delete(0, null);
            result.createLink(location, 16, null);
        } else {
            this.workspace.deleteResource(this);
            this.workspace.createResource(result, false);
        }
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void create(InputStream content, int updateFlags, IProgressMonitor monitor) throws CoreException {
        boolean force = (updateFlags & 1) != 0;
        boolean monitorNull = monitor == null;
        monitor = Policy.monitorFor(monitor);
        try {
            String message = monitorNull ? "" : Policy.bind("resources.creating", this.getFullPath().toString());
            monitor.beginTask(message, Policy.totalWork);
            this.checkValidPath(this.path, 1, true);
            ISchedulingRule rule = this.workspace.getRuleFactory().createRule(this);
            try {
                try {
                    boolean local;
                    this.workspace.prepareOperation(rule, monitor);
                    this.checkDoesNotExist();
                    Container parent = (Container)this.getParent();
                    ResourceInfo info = parent.getResourceInfo(false, false);
                    parent.checkAccessible(this.getFlags(info));
                    this.workspace.beginOperation(true);
                    IPath location = this.getLocalManager().locationFor(this);
                    if (location == null) {
                        message = Policy.bind("localstore.locationUndefined", this.getFullPath().toString());
                        throw new ResourceException(271, this.getFullPath(), message, null);
                    }
                    java.io.File localFile = location.toFile();
                    if (force) {
                        if (!CoreFileSystemLibrary.isCaseSensitive() && localFile.exists()) {
                            String name = this.getLocalManager().getLocalName(localFile);
                            if (name != null && !localFile.getName().equals(name)) {
                                message = Policy.bind("resources.existsLocalDifferentCase", location.removeLastSegments(1).append(name).toOSString());
                                throw new ResourceException(275, this.getFullPath(), message, null);
                            }
                            this.delete(true, null);
                        }
                    } else if (localFile.exists()) {
                        String name;
                        if (!CoreFileSystemLibrary.isCaseSensitive() && (name = this.getLocalManager().getLocalName(localFile)) != null && !localFile.getName().equals(name)) {
                            message = Policy.bind("resources.existsLocalDifferentCase", location.removeLastSegments(1).append(name).toOSString());
                            throw new ResourceException(275, this.getFullPath(), message, null);
                        }
                        message = Policy.bind("resources.fileExists", localFile.getAbsolutePath());
                        throw new ResourceException(272, this.getFullPath(), message, null);
                    }
                    monitor.worked(Policy.opWork * 40 / 100);
                    this.workspace.createResource(this, false);
                    boolean bl = local = content != null;
                    if (local) {
                        try {
                            this.internalSetContents(content, location, force, false, false, Policy.subMonitorFor(monitor, Policy.opWork * 60 / 100));
                        }
                        catch (CoreException e) {
                            this.workspace.deleteResource(this);
                            localFile.delete();
                            throw e;
                        }
                    }
                    this.internalSetLocal(local, 0);
                    if (!local) {
                        this.getResourceInfo(true, true).setModificationStamp(-1L);
                    }
                }
                catch (OperationCanceledException e) {
                    this.workspace.getWorkManager().operationCanceled();
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var14_18 = null;
                this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.buildWork));
                throw throwable;
            }
            {
                Object var14_19 = null;
                this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.buildWork));
            }
        }
        catch (Throwable throwable) {
            Object var16_21 = null;
            monitor.done();
            this.ensureClosed(content);
            throw throwable;
        }
        {
            Object var16_22 = null;
            monitor.done();
            this.ensureClosed(content);
            return;
        }
    }

    public void create(InputStream content, boolean force, IProgressMonitor monitor) throws CoreException {
        this.create(content, force ? 1 : 0, monitor);
    }

    protected void ensureClosed(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public String getCharset() throws CoreException {
        return this.getCharset(true);
    }

    public String getCharset(boolean checkImplicit) throws CoreException {
        String contentCharset;
        ResourceInfo info = this.getResourceInfo(false, false);
        int flags = this.getFlags(info);
        if (!this.exists(flags, false)) {
            return checkImplicit ? this.workspace.getCharsetManager().getCharsetFor(this.getFullPath().removeLastSegments(1), true) : null;
        }
        String charset = this.workspace.getCharsetManager().getCharsetFor(this.getFullPath(), false);
        if (charset != null || !checkImplicit) {
            return charset;
        }
        IContentDescription description = this.workspace.getContentDescriptionManager().getDescriptionFor(this, info);
        if (description != null && (contentCharset = description.getCharset()) != null) {
            return contentCharset;
        }
        return this.workspace.getCharsetManager().getCharsetFor(this.getFullPath().removeLastSegments(1), true);
    }

    public IContentDescription getContentDescription() throws CoreException {
        ResourceInfo info = this.getResourceInfo(false, false);
        int flags = this.getFlags(info);
        this.checkAccessible(flags);
        this.checkLocal(flags, 0);
        return this.workspace.getContentDescriptionManager().getDescriptionFor(this, info);
    }

    public InputStream getContents() throws CoreException {
        return this.getContents(false);
    }

    public InputStream getContents(boolean force) throws CoreException {
        ResourceInfo info = this.getResourceInfo(false, false);
        int flags = this.getFlags(info);
        this.checkAccessible(flags);
        this.checkLocal(flags, 0);
        return this.getLocalManager().read(this, force, null);
    }

    public int getEncoding() throws CoreException {
        ResourceInfo info = this.getResourceInfo(false, false);
        int flags = this.getFlags(info);
        this.checkAccessible(flags);
        this.checkLocal(flags, 0);
        return this.getLocalManager().getEncoding(this);
    }

    public IFileState[] getHistory(IProgressMonitor monitor) throws CoreException {
        return this.getLocalManager().getHistoryStore().getStates(this.getFullPath());
    }

    public int getType() {
        return 1;
    }

    protected void internalSetContents(InputStream content, IPath location, boolean force, boolean keepHistory, boolean append, IProgressMonitor monitor) throws CoreException {
        if (content == null) {
            content = new ByteArrayInputStream(new byte[0]);
        }
        this.getLocalManager().write(this, location, content, force, keepHistory, append, monitor);
        ResourceInfo info = this.getResourceInfo(false, true);
        info.incrementContentId();
        info.clear(393216);
        this.workspace.updateModificationStamp(info);
        this.updateProjectDescription();
        this.workspace.getAliasManager().updateAliases(this, location, 0, monitor);
    }

    public void refreshLocal(int depth, IProgressMonitor monitor) throws CoreException {
        if (!this.getLocalManager().fastIsSynchronized(this)) {
            super.refreshLocal(0, monitor);
        }
    }

    public void setContents(IFileState content, int updateFlags, IProgressMonitor monitor) throws CoreException {
        this.setContents(content.getContents(), updateFlags, monitor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setContents(InputStream content, int updateFlags, IProgressMonitor monitor) throws CoreException {
        boolean force = (updateFlags & 1) != 0;
        boolean keepHistory = (updateFlags & 2) != 0;
        monitor = Policy.monitorFor(monitor);
        try {
            String message = Policy.bind("resources.settingContents", this.getFullPath().toString());
            monitor.beginTask(message, Policy.totalWork);
            if (this.workspace.shouldValidate) {
                this.workspace.validateSave(this);
            }
            ISchedulingRule rule = this.workspace.getRuleFactory().modifyRule(this);
            try {
                try {
                    this.workspace.prepareOperation(rule, monitor);
                    ResourceInfo info = this.getResourceInfo(false, false);
                    this.checkAccessible(this.getFlags(info));
                    this.workspace.beginOperation(true);
                    this.internalSetContents(content, this.getLocalManager().locationFor(this), force, keepHistory, false, Policy.subMonitorFor(monitor, Policy.opWork));
                }
                catch (OperationCanceledException e) {
                    this.workspace.getWorkManager().operationCanceled();
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.buildWork));
                throw throwable;
            }
            {
                Object var9_12 = null;
                this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.buildWork));
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            monitor.done();
            this.ensureClosed(content);
            throw throwable;
        }
        {
            Object var11_15 = null;
            monitor.done();
            this.ensureClosed(content);
            return;
        }
    }

    public long setLocalTimeStamp(long value) throws CoreException {
        ResourceInfo projectInfo;
        long result = super.setLocalTimeStamp(value);
        if (this.path.segmentCount() == 2 && this.path.segment(1).equals(".project") && (projectInfo = ((Project)this.getProject()).getResourceInfo(false, false)) != null) {
            this.getLocalManager().updateLocalSync(projectInfo, result);
        }
        return result;
    }

    public void updateProjectDescription() throws CoreException {
        if (this.path.segmentCount() == 2 && this.path.segment(1).equals(".project")) {
            ((Project)this.getProject()).updateDescription();
        }
    }

    public void setCharset(String newCharset) throws CoreException {
        ResourceInfo info = this.getResourceInfo(false, false);
        this.checkAccessible(this.getFlags(info));
        this.workspace.getCharsetManager().setCharsetFor(this.getFullPath(), newCharset);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setCharset(String newCharset, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            String message = Policy.bind("resources.settingCharset", this.getFullPath().toString());
            monitor.beginTask(message, Policy.totalWork);
            ISchedulingRule rule = this.workspace.getRuleFactory().modifyRule(this.getProject());
            try {
                try {
                    this.workspace.prepareOperation(rule, monitor);
                    ResourceInfo info = this.getResourceInfo(false, false);
                    this.checkAccessible(this.getFlags(info));
                    this.workspace.beginOperation(true);
                    this.workspace.getCharsetManager().setCharsetFor(this.getFullPath(), newCharset);
                    monitor.worked(Policy.opWork);
                }
                catch (OperationCanceledException e) {
                    this.workspace.getWorkManager().operationCanceled();
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.buildWork));
                throw throwable;
            }
            {
                Object var6_9 = null;
                this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.buildWork));
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var8_12 = null;
            monitor.done();
            return;
        }
    }

    public void setContents(InputStream content, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        int updateFlags = force ? 1 : 0;
        this.setContents(content, updateFlags |= keepHistory ? 2 : 0, monitor);
    }

    public void setContents(IFileState source, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        int updateFlags = force ? 1 : 0;
        this.setContents(source.getContents(), updateFlags |= keepHistory ? 2 : 0, monitor);
    }
}

