/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.tools;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.aspectj.bridge.AbortException;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.util.FileUtil;
import org.aspectj.weaver.IClassFileProvider;
import org.aspectj.weaver.IWeaveRequestor;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.bcel.BcelWeaver;
import org.aspectj.weaver.bcel.BcelWorld;
import org.aspectj.weaver.bcel.UnwovenClassFile;
import org.aspectj.weaver.tools.GeneratedClassHandler;
import org.aspectj.weaver.tools.WeavingClassLoader;

public class WeavingAdaptor {
    public static final String WEAVING_ADAPTOR_VERBOSE = "aj.weaving.verbose";
    private boolean enabled = true;
    private boolean verbose = WeavingAdaptor.getVerbose();
    private BcelWorld bcelWorld = null;
    private BcelWeaver weaver = null;
    private IMessageHandler messageHandler = null;
    private GeneratedClassHandler generatedClassHandler;
    private Map generatedClasses = new HashMap();

    public WeavingAdaptor(WeavingClassLoader loader) {
        this.generatedClassHandler = loader;
        this.init(this.getFullClassPath((ClassLoader)((Object)loader)), this.getFullAspectPath((ClassLoader)((Object)loader)));
    }

    public WeavingAdaptor(GeneratedClassHandler handler, URL[] classURLs, URL[] aspectURLs) {
        this.generatedClassHandler = handler;
        this.init(FileUtil.makeClasspath(classURLs), FileUtil.makeClasspath(aspectURLs));
    }

    private List getFullClassPath(ClassLoader loader) {
        LinkedList list = new LinkedList();
        while (loader != null) {
            if (loader instanceof URLClassLoader) {
                URL[] urls = ((URLClassLoader)loader).getURLs();
                list.addAll(0, FileUtil.makeClasspath(urls));
            } else if (this.verbose) {
                System.err.println("WeavingAdaptor: Warning - could not determine classpath for " + loader);
            }
            loader = loader.getParent();
        }
        list.addAll(0, WeavingAdaptor.makeClasspath(System.getProperty("sun.boot.class.path")));
        return list;
    }

    private List getFullAspectPath(ClassLoader loader) {
        LinkedList list = new LinkedList();
        while (loader != null) {
            if (loader instanceof WeavingClassLoader) {
                URL[] urls = ((WeavingClassLoader)((Object)loader)).getAspectURLs();
                list.addAll(0, FileUtil.makeClasspath(urls));
            }
            loader = loader.getParent();
        }
        return list;
    }

    private static boolean getVerbose() {
        return Boolean.getBoolean(WEAVING_ADAPTOR_VERBOSE);
    }

    private void init(List classPath, List aspectPath) {
        if (this.verbose) {
            System.out.println("WeavingAdaptor: classPath='" + classPath + "'");
        }
        this.messageHandler = new MessageHandler();
        this.bcelWorld = new BcelWorld(classPath, this.messageHandler, null);
        this.bcelWorld.setXnoInline(false);
        this.bcelWorld.getLint().loadDefaultProperties();
        this.weaver = new BcelWeaver(this.bcelWorld);
        this.registerAspectLibraries(aspectPath);
    }

    public void addURL(URL url) {
        try {
            this.weaver.addLibraryJarFile(new File(url.getPath()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public byte[] weaveClass(String name, byte[] bytes) throws IOException {
        if (this.shouldWeave(name)) {
            bytes = this.getWovenBytes(name, bytes);
        }
        return bytes;
    }

    private boolean shouldWeave(String name) {
        boolean b;
        name = name.replace('/', '.');
        boolean bl = b = this.enabled && !this.generatedClasses.containsKey(name) && this.shouldWeaveName(name) && this.shouldWeaveAspect(name);
        if (this.verbose) {
            System.out.println("WeavingAdaptor: shouldWeave('" + name + "') " + b);
        }
        return b;
    }

    private boolean shouldWeaveName(String name) {
        return !name.startsWith("org.apache.bcel.") && !name.startsWith("org.aspectj.") && !name.startsWith("java.") && !name.startsWith("javax.");
    }

    private boolean shouldWeaveAspect(String name) {
        ResolvedTypeX type = this.bcelWorld.resolve(name);
        return type == null || !type.isAspect();
    }

    private byte[] getWovenBytes(String name, byte[] bytes) throws IOException {
        WeavingClassFileProvider wcp = new WeavingClassFileProvider(name, bytes);
        this.weaver.weave(wcp);
        return wcp.getBytes();
    }

    private void registerAspectLibraries(List aspectPath) {
        Iterator i = aspectPath.iterator();
        while (i.hasNext()) {
            String lib = (String)i.next();
            File libFile = new File(lib);
            if (libFile.isFile() && lib.endsWith(".jar")) {
                try {
                    if (this.verbose) {
                        System.out.println("WeavingAdaptor: adding aspect '" + lib + "' to weaver");
                    }
                    this.addAspectLibrary(new File(lib));
                }
                catch (IOException ioEx) {
                    if (!this.verbose) continue;
                    System.err.println("WeavingAdaptor: Warning - could not load aspect path entry " + lib + " : " + ioEx);
                }
                continue;
            }
            if (!this.verbose) continue;
            System.err.println("WeavingAdaptor: Warning - ignoring aspect path entry: " + lib);
        }
        this.weaver.prepareForWeave();
    }

    private void addAspectLibrary(File aspectLibraryJarFile) throws IOException {
        this.weaver.addLibraryJarFile(aspectLibraryJarFile);
    }

    private static List makeClasspath(String cp) {
        ArrayList<String> ret = new ArrayList<String>();
        if (cp != null) {
            StringTokenizer tok = new StringTokenizer(cp, File.pathSeparator);
            while (tok.hasMoreTokens()) {
                ret.add(tok.nextToken());
            }
        }
        return ret;
    }

    private class WeavingClassFileProvider
    implements IClassFileProvider {
        private List unwovenClasses = new ArrayList();
        private UnwovenClassFile wovenClass;

        public WeavingClassFileProvider(String name, byte[] bytes) {
            UnwovenClassFile unwoven = new UnwovenClassFile(name, bytes);
            this.unwovenClasses.add(unwoven);
            WeavingAdaptor.this.bcelWorld.addSourceObjectType(unwoven.getJavaClass());
        }

        public byte[] getBytes() {
            return this.wovenClass.getBytes();
        }

        public Iterator getClassFileIterator() {
            return this.unwovenClasses.iterator();
        }

        public IWeaveRequestor getRequestor() {
            return new IWeaveRequestor(){

                public void acceptResult(UnwovenClassFile result) {
                    if (wovenClass == null) {
                        wovenClass = result;
                    } else {
                        String className = result.getClassName();
                        WeavingAdaptor.this.generatedClasses.put(className, result);
                        WeavingAdaptor.this.generatedClassHandler.acceptClass(className, result.getBytes());
                    }
                }

                public void processingReweavableState() {
                }

                public void addingTypeMungers() {
                }

                public void weavingAspects() {
                }

                public void weavingClasses() {
                }

                public void weaveCompleted() {
                }
            };
        }
    }

    private class MessageHandler
    implements IMessageHandler {
        private MessageHandler() {
        }

        public boolean handleMessage(IMessage message) throws AbortException {
            if (!this.isIgnoring(message.getKind())) {
                if (WeavingAdaptor.this.verbose) {
                    System.err.println(message.getMessage());
                }
                throw new AbortException(message);
            }
            return true;
        }

        public boolean isIgnoring(IMessage.Kind kind) {
            return kind == IMessage.INFO || kind == IMessage.DEBUG;
        }
    }
}

