/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.plugins;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.internal.plugins.PluginDescriptor;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.osgi.framework.Bundle;

public class PluginRegistry
implements IPluginRegistry {
    private IExtensionRegistry extRegistry;
    private HashMap descriptors = new HashMap();

    public PluginRegistry() {
        this.extRegistry = InternalPlatform.getDefault().getRegistry();
    }

    public IConfigurationElement[] getConfigurationElementsFor(String uniqueId) {
        return this.extRegistry.getConfigurationElementsFor(uniqueId);
    }

    public IConfigurationElement[] getConfigurationElementsFor(String pluginId, String pointId) {
        return this.extRegistry.getConfigurationElementsFor(pluginId, pointId);
    }

    public IConfigurationElement[] getConfigurationElementsFor(String pluginId, String pointId, String extensionId) {
        return this.extRegistry.getConfigurationElementsFor(pluginId, pointId, extensionId);
    }

    public IExtension getExtension(String xptUniqueId, String extUniqueId) {
        return this.extRegistry.getExtension(xptUniqueId, extUniqueId);
    }

    public IExtension getExtension(String pluginId, String xptSimpleId, String extId) {
        return this.extRegistry.getExtension(pluginId, xptSimpleId, extId);
    }

    public IExtensionPoint getExtensionPoint(String xptUniqueId) {
        return this.extRegistry.getExtensionPoint(xptUniqueId);
    }

    public IExtensionPoint getExtensionPoint(String plugin, String xpt) {
        return this.extRegistry.getExtensionPoint(plugin, xpt);
    }

    public IExtensionPoint[] getExtensionPoints() {
        return this.extRegistry.getExtensionPoints();
    }

    public synchronized IPluginDescriptor getPluginDescriptor(String plugin) {
        Bundle b = InternalPlatform.getDefault().getBundle(plugin);
        PluginDescriptor pd = (PluginDescriptor)this.descriptors.get(plugin);
        if (b != null) {
            if (pd == null || pd.getBundle() != b) {
                pd = new PluginDescriptor(b);
                this.descriptors.put(plugin, pd);
            }
            return pd;
        }
        if (pd != null) {
            this.descriptors.remove(plugin);
        }
        return null;
    }

    public IPluginDescriptor[] getPluginDescriptors(String plugin) {
        IPluginDescriptor pd = this.getPluginDescriptor(plugin);
        if (pd == null) {
            return new IPluginDescriptor[0];
        }
        return new IPluginDescriptor[]{pd};
    }

    public IPluginDescriptor getPluginDescriptor(String pluginId, PluginVersionIdentifier version) {
        return this.getPluginDescriptor(pluginId);
    }

    public IPluginDescriptor[] getPluginDescriptors() {
        Bundle[] bundles = InternalPlatform.getDefault().getBundleContext().getBundles();
        ArrayList<IPluginDescriptor> pds = new ArrayList<IPluginDescriptor>(bundles.length);
        int i = 0;
        while (i < bundles.length) {
            if (!bundles[i].isFragment() && bundles[i].getGlobalName() != null) {
                pds.add(this.getPluginDescriptor(bundles[i].getGlobalName()));
            }
            ++i;
        }
        IPluginDescriptor[] result = new IPluginDescriptor[pds.size()];
        return pds.toArray(result);
    }

    void logError(IStatus status) {
        InternalPlatform.getDefault().log(status);
        if (InternalPlatform.DEBUG) {
            System.out.println(status.getMessage());
        }
    }
}

