/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.aspectj.apache.bcel.classfile.ClassParser;
import org.aspectj.apache.bcel.classfile.JavaClass;
import org.aspectj.apache.bcel.util.Repository;

public class ClassLoaderRepository
implements Repository {
    private ClassLoader loader;
    private HashMap loadedClasses = new HashMap();

    public ClassLoaderRepository(ClassLoader loader) {
        this.loader = loader;
    }

    public void storeClass(JavaClass clazz) {
        this.loadedClasses.put(clazz.getClassName(), clazz);
        clazz.setRepository(this);
    }

    public void removeClass(JavaClass clazz) {
        this.loadedClasses.remove(clazz.getClassName());
    }

    public JavaClass findClass(String className) {
        if (this.loadedClasses.containsKey(className)) {
            return (JavaClass)this.loadedClasses.get(className);
        }
        return null;
    }

    public JavaClass loadClass(String className) throws ClassNotFoundException {
        String classFile = className.replace('.', '/');
        JavaClass RC = this.findClass(className);
        if (RC != null) {
            return RC;
        }
        try {
            InputStream is = this.loader.getResourceAsStream(String.valueOf(classFile) + ".class");
            if (is == null) {
                throw new ClassNotFoundException(String.valueOf(className) + " not found.");
            }
            ClassParser parser = new ClassParser(is, className);
            RC = parser.parse();
            this.storeClass(RC);
            return RC;
        }
        catch (IOException e) {
            throw new ClassNotFoundException(e.toString());
        }
    }

    public JavaClass loadClass(Class clazz) throws ClassNotFoundException {
        return this.loadClass(clazz.getName());
    }

    public void clear() {
        this.loadedClasses.clear();
    }
}

