/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.ResolvedTypeMunger;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.patterns.PerTypeWithin;
import org.aspectj.weaver.patterns.Pointcut;

public class PerTypeWithinTargetTypeMunger
extends ResolvedTypeMunger {
    private UnresolvedType aspectType;
    private PerTypeWithin testPointcut;

    public PerTypeWithinTargetTypeMunger(UnresolvedType aspectType, PerTypeWithin testPointcut) {
        super(ResolvedTypeMunger.PerTypeWithinInterface, null);
        this.aspectType = aspectType;
        this.testPointcut = testPointcut;
    }

    public void write(DataOutputStream s) throws IOException {
        throw new RuntimeException("shouldn't be serialized");
    }

    public UnresolvedType getAspectType() {
        return this.aspectType;
    }

    public Pointcut getTestPointcut() {
        return this.testPointcut;
    }

    public boolean matches(ResolvedType matchType, ResolvedType aspectType) {
        return this.isWithinType(matchType).alwaysTrue() && !matchType.isInterface();
    }

    private FuzzyBoolean isWithinType(ResolvedType type) {
        while (type != null) {
            if (this.testPointcut.getTypePattern().matchesStatically(type)) {
                return FuzzyBoolean.YES;
            }
            type = type.getDeclaringType();
        }
        return FuzzyBoolean.NO;
    }
}

