/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile.annotation;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.ConstantUtf8;
import org.aspectj.apache.bcel.classfile.Utility;
import org.aspectj.apache.bcel.classfile.annotation.ElementNameValuePair;
import org.aspectj.apache.bcel.classfile.annotation.ElementValue;

public class Annotation {
    private int typeIndex;
    private List evs = new ArrayList();
    private ConstantPool cpool;
    private boolean isRuntimeVisible;

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ANNOTATION [" + this.getTypeSignature() + "] [" + (this.isRuntimeVisible ? "runtimeVisible" : "runtimeInvisible") + "] [");
        Iterator iter = this.evs.iterator();
        while (iter.hasNext()) {
            ElementNameValuePair element = (ElementNameValuePair)iter.next();
            sb.append(element.toString());
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    private Annotation(ConstantPool cpool) {
        this.cpool = cpool;
    }

    public Annotation(int index, ConstantPool cpool, boolean visible) {
        this.cpool = cpool;
        this.typeIndex = index;
        this.isRuntimeVisible = visible;
    }

    protected static Annotation read(DataInputStream dis, ConstantPool cpool, boolean isRuntimeVisible) throws IOException {
        Annotation a = new Annotation(cpool);
        a.typeIndex = dis.readUnsignedShort();
        int elemValuePairCount = dis.readUnsignedShort();
        for (int i = 0; i < elemValuePairCount; ++i) {
            int nidx = dis.readUnsignedShort();
            a.addElementNameValuePair(new ElementNameValuePair(nidx, ElementValue.readElementValue(dis, cpool), cpool));
        }
        a.isRuntimeVisible(isRuntimeVisible);
        return a;
    }

    protected void dump(DataOutputStream dos) throws IOException {
        dos.writeShort(this.typeIndex);
        dos.writeShort(this.evs.size());
        for (int i = 0; i < this.evs.size(); ++i) {
            ElementNameValuePair envp = (ElementNameValuePair)this.evs.get(i);
            envp.dump(dos);
        }
    }

    public void addElementNameValuePair(ElementNameValuePair evp) {
        this.evs.add(evp);
    }

    public int getTypeIndex() {
        return this.typeIndex;
    }

    public final String getTypeSignature() {
        ConstantUtf8 c = (ConstantUtf8)this.cpool.getConstant(this.typeIndex, (byte)1);
        return c.getBytes();
    }

    public final String getTypeName() {
        ConstantUtf8 c = (ConstantUtf8)this.cpool.getConstant(this.typeIndex, (byte)1);
        return Utility.signatureToString(c.getBytes());
    }

    public List getValues() {
        return this.evs;
    }

    protected void isRuntimeVisible(boolean b) {
        this.isRuntimeVisible = b;
    }

    public boolean isRuntimeVisible() {
        return this.isRuntimeVisible;
    }

    public String toShortString() {
        StringBuffer result = new StringBuffer();
        result.append("@");
        result.append(this.getTypeName());
        if (this.getValues().size() > 0) {
            result.append("(");
            Iterator iter = this.getValues().iterator();
            while (iter.hasNext()) {
                ElementNameValuePair element = (ElementNameValuePair)iter.next();
                result.append(element.toShortString());
            }
            result.append(")");
        }
        return result.toString();
    }
}

