/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.generic;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.aspectj.apache.bcel.classfile.ClassFormatException;
import org.aspectj.apache.bcel.classfile.Utility;
import org.aspectj.apache.bcel.generic.ArrayType;
import org.aspectj.apache.bcel.generic.BasicType;
import org.aspectj.apache.bcel.generic.ObjectType;
import org.aspectj.apache.bcel.generic.ReferenceType;

public abstract class Type
implements Serializable {
    protected byte type;
    protected String signature;
    public static final BasicType VOID = new BasicType(12);
    public static final BasicType BOOLEAN = new BasicType(4);
    public static final BasicType INT = new BasicType(10);
    public static final BasicType SHORT = new BasicType(9);
    public static final BasicType BYTE = new BasicType(8);
    public static final BasicType LONG = new BasicType(11);
    public static final BasicType DOUBLE = new BasicType(7);
    public static final BasicType FLOAT = new BasicType(6);
    public static final BasicType CHAR = new BasicType(5);
    public static final ObjectType OBJECT = new ObjectType("java.lang.Object");
    public static final ObjectType STRING = new ObjectType("java.lang.String");
    public static final ObjectType STRINGBUFFER = new ObjectType("java.lang.StringBuffer");
    public static final ObjectType THROWABLE = new ObjectType("java.lang.Throwable");
    public static final Type[] NO_ARGS = new Type[0];
    public static final ReferenceType NULL = new ReferenceType(){};
    public static final Type UNKNOWN = new Type(15, "<unknown object>"){};

    protected Type(byte t, String s) {
        this.type = t;
        this.signature = s;
    }

    public String getSignature() {
        return this.signature;
    }

    public byte getType() {
        return this.type;
    }

    public int getSize() {
        switch (this.type) {
            case 7: 
            case 11: {
                return 2;
            }
            case 12: {
                return 0;
            }
        }
        return 1;
    }

    public String toString() {
        return this.equals(NULL) || this.type >= 15 ? this.signature : Utility.signatureToString(this.signature, false);
    }

    public static String getMethodSignature(Type return_type, Type[] arg_types) {
        StringBuffer buf = new StringBuffer("(");
        int length = arg_types == null ? 0 : arg_types.length;
        for (int i = 0; i < length; ++i) {
            buf.append(arg_types[i].getSignature());
        }
        buf.append(')');
        buf.append(return_type.getSignature());
        return buf.toString();
    }

    public static final Type getType(String signature) {
        TypeHolder th = Type.getTypeInternal(signature);
        return th.getType();
    }

    public static final TypeHolder getTypeInternal(String signature) throws StringIndexOutOfBoundsException {
        byte type = Utility.typeOfSignature(signature);
        if (type <= 12) {
            return new TypeHolder(BasicType.getType(type), 1);
        }
        if (type == 13) {
            int dim = 0;
            while (signature.charAt(++dim) == '[') {
            }
            TypeHolder th = Type.getTypeInternal(signature.substring(dim));
            return new TypeHolder(new ArrayType(th.getType(), dim), dim + th.getConsumed());
        }
        int index = signature.indexOf(59);
        if (index < 0) {
            throw new ClassFormatException("Invalid signature: " + signature);
        }
        int nextAngly = signature.indexOf(60);
        String typeString = null;
        if (nextAngly == -1 || nextAngly > index) {
            typeString = signature.substring(1, index).replace('/', '.');
        } else {
            boolean endOfSigReached = false;
            int posn = nextAngly;
            int genericDepth = 0;
            block6: while (!endOfSigReached) {
                switch (signature.charAt(posn++)) {
                    case '<': {
                        ++genericDepth;
                        continue block6;
                    }
                    case '>': {
                        --genericDepth;
                        continue block6;
                    }
                    case ';': {
                        if (genericDepth != 0) continue block6;
                        endOfSigReached = true;
                        continue block6;
                    }
                }
            }
            index = posn - 1;
            typeString = signature.substring(1, nextAngly).replace('/', '.');
        }
        return new TypeHolder(new ObjectType(typeString), index + 1);
    }

    public static Type getReturnType(String signature) {
        try {
            int index = signature.lastIndexOf(41) + 1;
            return Type.getType(signature.substring(index));
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ClassFormatException("Invalid method signature: " + signature);
        }
    }

    public static Type[] getArgumentTypes(String signature) {
        ArrayList<Type> vec = new ArrayList<Type>();
        try {
            if (signature.charAt(0) != '(') {
                throw new ClassFormatException("Invalid method signature: " + signature);
            }
            int index = 1;
            while (signature.charAt(index) != ')') {
                TypeHolder th = Type.getTypeInternal(signature.substring(index));
                vec.add(th.getType());
                index += th.getConsumed();
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ClassFormatException("Invalid method signature: " + signature);
        }
        Type[] types = new Type[vec.size()];
        vec.toArray(types);
        return types;
    }

    public static Type getType(Class cl) {
        if (cl == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        if (cl.isArray()) {
            return Type.getType(cl.getName());
        }
        if (cl.isPrimitive()) {
            if (cl == Integer.TYPE) {
                return INT;
            }
            if (cl == Void.TYPE) {
                return VOID;
            }
            if (cl == Double.TYPE) {
                return DOUBLE;
            }
            if (cl == Float.TYPE) {
                return FLOAT;
            }
            if (cl == Boolean.TYPE) {
                return BOOLEAN;
            }
            if (cl == Byte.TYPE) {
                return BYTE;
            }
            if (cl == Short.TYPE) {
                return SHORT;
            }
            if (cl == Byte.TYPE) {
                return BYTE;
            }
            if (cl == Long.TYPE) {
                return LONG;
            }
            if (cl == Character.TYPE) {
                return CHAR;
            }
            throw new IllegalStateException("Ooops, what primitive type is " + cl);
        }
        return new ObjectType(cl.getName());
    }

    public static String getSignature(Method meth) {
        StringBuffer sb = new StringBuffer("(");
        Class<?>[] params = meth.getParameterTypes();
        for (int j = 0; j < params.length; ++j) {
            sb.append(Type.getType(params[j]).getSignature());
        }
        sb.append(")");
        sb.append(Type.getType(meth.getReturnType()).getSignature());
        return sb.toString();
    }

    public static String getSignature(Constructor cons) {
        StringBuffer sb = new StringBuffer("(");
        Class<?>[] params = cons.getParameterTypes();
        for (int j = 0; j < params.length; ++j) {
            sb.append(Type.getType(params[j]).getSignature());
        }
        sb.append(")V");
        return sb.toString();
    }

    public static class TypeHolder {
        private Type t;
        private int consumed;

        public Type getType() {
            return this.t;
        }

        public int getConsumed() {
            return this.consumed;
        }

        public TypeHolder(Type t, int i) {
            this.t = t;
            this.consumed = i;
        }
    }
}

