/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.bcel;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.Field;
import org.aspectj.apache.bcel.classfile.JavaClass;
import org.aspectj.apache.bcel.classfile.Method;
import org.aspectj.apache.bcel.classfile.Signature;
import org.aspectj.apache.bcel.classfile.annotation.Annotation;
import org.aspectj.apache.bcel.classfile.annotation.ElementNameValuePair;
import org.aspectj.apache.bcel.classfile.annotation.ElementValue;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.weaver.AbstractReferenceTypeDelegate;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.AjcMemberMaker;
import org.aspectj.weaver.AnnotationX;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.ReferenceType;
import org.aspectj.weaver.ReferenceTypeDelegate;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedPointcutDefinition;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.TypeVariable;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.WeaverStateInfo;
import org.aspectj.weaver.bcel.AtAjAttributes;
import org.aspectj.weaver.bcel.BcelAttributes;
import org.aspectj.weaver.bcel.BcelField;
import org.aspectj.weaver.bcel.BcelGenericSignatureToTypeXConverter;
import org.aspectj.weaver.bcel.BcelMethod;
import org.aspectj.weaver.bcel.BcelSourceContext;
import org.aspectj.weaver.bcel.LazyClassGen;
import org.aspectj.weaver.patterns.PerClause;

public class BcelObjectType
extends AbstractReferenceTypeDelegate {
    private JavaClass javaClass;
    private boolean isObject = false;
    private LazyClassGen lazyClassGen = null;
    private ResolvedType[] interfaces = null;
    private ResolvedType superClass = null;
    private ResolvedMember[] fields = null;
    private ResolvedMember[] methods = null;
    private ResolvedType[] annotationTypes = null;
    private AnnotationX[] annotations = null;
    private TypeVariable[] typeVars = null;
    private boolean isUnpacked = false;
    private ResolvedPointcutDefinition[] pointcuts = null;
    private PerClause perClause = null;
    private WeaverStateInfo weaverState = null;
    private AjAttribute.WeaverVersionInfo wvInfo = AjAttribute.WeaverVersionInfo.UNKNOWN;
    private List typeMungers = Collections.EMPTY_LIST;
    private List declares = Collections.EMPTY_LIST;
    private ResolvedMember[] privilegedAccess = null;
    private boolean discoveredWhetherAnnotationStyle = false;
    private boolean isAnnotationStyleAspect = false;
    private boolean isCodeStyleAspect = false;
    private boolean haveLookedForDeclaredSignature = false;
    private String declaredSignature = null;
    private boolean isGenericType = false;
    private boolean discoveredRetentionPolicy = false;
    private String retentionPolicy;
    private boolean damaged = false;
    private boolean genericSignatureUnpacked = false;
    private Signature.FormalTypeParameter[] formalsForResolution = null;

    public Collection getTypeMungers() {
        return this.typeMungers;
    }

    public Collection getDeclares() {
        return this.declares;
    }

    public Collection getPrivilegedAccesses() {
        if (this.privilegedAccess == null) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(this.privilegedAccess);
    }

    BcelObjectType(ReferenceType resolvedTypeX, JavaClass javaClass, boolean exposedToWeaver) {
        super(resolvedTypeX, exposedToWeaver);
        this.javaClass = javaClass;
        resolvedTypeX.setDelegate(this);
        if (resolvedTypeX.getSourceContext() == null) {
            resolvedTypeX.setSourceContext(new BcelSourceContext(this));
        }
        this.isObject = javaClass.getSuperclassNameIndex() == 0;
        this.unpackAspectAttributes();
    }

    public void setJavaClass(JavaClass newclass) {
        this.javaClass = newclass;
        this.resetState();
    }

    public TypeVariable[] getTypeVariables() {
        if (!this.isGeneric()) {
            return new TypeVariable[0];
        }
        if (this.typeVars == null) {
            Signature.ClassSignature classSig = this.javaClass.getGenericClassTypeSignature();
            this.typeVars = new TypeVariable[classSig.formalTypeParameters.length];
            for (int i = 0; i < this.typeVars.length; ++i) {
                Signature.FormalTypeParameter ftp = classSig.formalTypeParameters[i];
                try {
                    this.typeVars[i] = BcelGenericSignatureToTypeXConverter.formalTypeParameter2TypeVariable(ftp, classSig.formalTypeParameters, this.getResolvedTypeX().getWorld());
                    continue;
                }
                catch (BcelGenericSignatureToTypeXConverter.GenericSignatureFormatException e) {
                    throw new IllegalStateException("While getting the type variables for type " + this.toString() + " with generic signature " + classSig + " the following error condition was detected: " + e.getMessage());
                }
            }
        }
        return this.typeVars;
    }

    public int getModifiers() {
        return this.javaClass.getAccessFlags();
    }

    public ResolvedType getSuperclass() {
        if (this.isObject) {
            return null;
        }
        this.unpackGenericSignature();
        if (this.superClass == null) {
            this.superClass = this.getResolvedTypeX().getWorld().resolve(UnresolvedType.forName(this.javaClass.getSuperclassName()));
        }
        return this.superClass;
    }

    public ResolvedType[] getDeclaredInterfaces() {
        this.unpackGenericSignature();
        if (this.interfaces == null) {
            String[] ifaceNames = this.javaClass.getInterfaceNames();
            this.interfaces = new ResolvedType[ifaceNames.length];
            int len = ifaceNames.length;
            for (int i = 0; i < len; ++i) {
                this.interfaces[i] = this.getResolvedTypeX().getWorld().resolve(UnresolvedType.forName(ifaceNames[i]));
            }
        }
        return this.interfaces;
    }

    public ResolvedMember[] getDeclaredMethods() {
        this.unpackGenericSignature();
        if (this.methods == null) {
            Method[] ms = this.javaClass.getMethods();
            ResolvedMember[] ret = new ResolvedMember[ms.length];
            for (int i = ms.length - 1; i >= 0; --i) {
                ret[i] = new BcelMethod(this, ms[i]);
            }
            this.methods = ret;
        }
        return this.methods;
    }

    public ResolvedMember[] getDeclaredFields() {
        this.unpackGenericSignature();
        if (this.fields == null) {
            Field[] fs = this.javaClass.getFields();
            ResolvedMember[] ret = new ResolvedMember[fs.length];
            int len = fs.length;
            for (int i = 0; i < len; ++i) {
                ret[i] = new BcelField(this, fs[i]);
            }
            this.fields = ret;
        }
        return this.fields;
    }

    public ResolvedMember[] getDeclaredPointcuts() {
        return this.pointcuts;
    }

    public void addPointcutDefinition(ResolvedPointcutDefinition d) {
        this.damaged = true;
        int len = this.pointcuts.length;
        ResolvedPointcutDefinition[] ret = new ResolvedPointcutDefinition[len + 1];
        System.arraycopy(this.pointcuts, 0, ret, 0, len);
        ret[len] = d;
        this.pointcuts = ret;
    }

    public boolean isAspect() {
        return this.perClause != null;
    }

    public boolean isAnnotationStyleAspect() {
        if (!this.discoveredWhetherAnnotationStyle) {
            this.discoveredWhetherAnnotationStyle = true;
            this.isAnnotationStyleAspect = !this.isCodeStyleAspect && this.hasAnnotation(AjcMemberMaker.ASPECT_ANNOTATION);
        }
        return this.isAnnotationStyleAspect;
    }

    private void unpackAspectAttributes() {
        this.isUnpacked = true;
        ArrayList pointcuts = new ArrayList();
        this.typeMungers = new ArrayList();
        this.declares = new ArrayList();
        List l = BcelAttributes.readAjAttributes(this.javaClass.getClassName(), this.javaClass.getAttributes(), this.getResolvedTypeX().getSourceContext(), this.getResolvedTypeX().getWorld().getMessageHandler(), AjAttribute.WeaverVersionInfo.UNKNOWN);
        this.processAttributes(l, pointcuts, false);
        l = AtAjAttributes.readAj5ClassAttributes(this.javaClass, this.getResolvedTypeX(), this.getResolvedTypeX().getSourceContext(), this.getResolvedTypeX().getWorld().getMessageHandler(), this.isCodeStyleAspect);
        this.processAttributes(l, pointcuts, true);
        this.pointcuts = pointcuts.toArray(new ResolvedPointcutDefinition[pointcuts.size()]);
    }

    private void processAttributes(List attributeList, List pointcuts, boolean fromAnnotations) {
        Iterator iter = attributeList.iterator();
        while (iter.hasNext()) {
            AjAttribute a = (AjAttribute)iter.next();
            if (a instanceof AjAttribute.Aspect) {
                this.perClause = ((AjAttribute.Aspect)a).reify(this.getResolvedTypeX());
                if (fromAnnotations) continue;
                this.isCodeStyleAspect = true;
                continue;
            }
            if (a instanceof AjAttribute.PointcutDeclarationAttribute) {
                pointcuts.add(((AjAttribute.PointcutDeclarationAttribute)a).reify());
                continue;
            }
            if (a instanceof AjAttribute.WeaverState) {
                this.weaverState = ((AjAttribute.WeaverState)a).reify();
                continue;
            }
            if (a instanceof AjAttribute.TypeMunger) {
                this.typeMungers.add(((AjAttribute.TypeMunger)a).reify(this.getResolvedTypeX().getWorld(), this.getResolvedTypeX()));
                continue;
            }
            if (a instanceof AjAttribute.DeclareAttribute) {
                this.declares.add(((AjAttribute.DeclareAttribute)a).getDeclare());
                continue;
            }
            if (a instanceof AjAttribute.PrivilegedAttribute) {
                this.privilegedAccess = ((AjAttribute.PrivilegedAttribute)a).getAccessedMembers();
                continue;
            }
            if (a instanceof AjAttribute.SourceContextAttribute) {
                if (!(this.getResolvedTypeX().getSourceContext() instanceof BcelSourceContext)) continue;
                ((BcelSourceContext)this.getResolvedTypeX().getSourceContext()).addAttributeInfo((AjAttribute.SourceContextAttribute)a);
                continue;
            }
            if (a instanceof AjAttribute.WeaverVersionInfo) {
                this.wvInfo = (AjAttribute.WeaverVersionInfo)a;
                continue;
            }
            throw new BCException("bad attribute " + a);
        }
    }

    public PerClause getPerClause() {
        if (!this.isUnpacked) {
            this.unpackAspectAttributes();
        }
        return this.perClause;
    }

    JavaClass getJavaClass() {
        return this.javaClass;
    }

    public void ensureDelegateConsistent() {
        if (this.damaged) {
            this.resetState();
            this.damaged = false;
        }
    }

    public void resetState() {
        this.interfaces = null;
        this.superClass = null;
        this.fields = null;
        this.methods = null;
        this.pointcuts = null;
        this.perClause = null;
        this.weaverState = null;
        this.lazyClassGen = null;
        this.annotations = null;
        this.annotationTypes = null;
        this.isObject = this.javaClass.getSuperclassNameIndex() == 0;
        this.unpackAspectAttributes();
        this.discoveredWhetherAnnotationStyle = false;
        this.isAnnotationStyleAspect = false;
    }

    public void finishedWith() {
    }

    public WeaverStateInfo getWeaverState() {
        return this.weaverState;
    }

    void setWeaverState(WeaverStateInfo weaverState) {
        this.weaverState = weaverState;
    }

    public void printWackyStuff(PrintStream out) {
        if (this.typeMungers.size() > 0) {
            out.println("  TypeMungers: " + this.typeMungers);
        }
        if (this.declares.size() > 0) {
            out.println("     declares: " + this.declares);
        }
    }

    public LazyClassGen getLazyClassGen() {
        LazyClassGen ret = this.lazyClassGen;
        if (ret == null) {
            ret = new LazyClassGen(this);
            if (this.isAspect()) {
                this.lazyClassGen = ret;
            }
        }
        return ret;
    }

    public boolean isInterface() {
        return this.javaClass.isInterface();
    }

    public boolean isEnum() {
        return this.javaClass.isEnum();
    }

    public boolean isAnnotation() {
        return this.javaClass.isAnnotation();
    }

    public boolean isAnonymous() {
        return this.javaClass.isAnonymous();
    }

    public void addAnnotation(AnnotationX annotation) {
        this.damaged = true;
        int len = this.annotations.length;
        AnnotationX[] ret = new AnnotationX[len + 1];
        System.arraycopy(this.annotations, 0, ret, 0, len);
        ret[len] = annotation;
        this.annotations = ret;
        len = this.annotationTypes.length;
        ResolvedType[] ret2 = new ResolvedType[len + 1];
        System.arraycopy(this.annotationTypes, 0, ret2, 0, len);
        ret2[len] = this.getResolvedTypeX().getWorld().resolve(UnresolvedType.forName(annotation.getTypeName()));
        this.annotationTypes = ret2;
    }

    public boolean isAnnotationWithRuntimeRetention() {
        return this.getRetentionPolicy().equals("RUNTIME");
    }

    public String getRetentionPolicy() {
        if (this.discoveredRetentionPolicy) {
            return this.retentionPolicy;
        }
        this.discoveredRetentionPolicy = true;
        this.retentionPolicy = null;
        if (this.isAnnotation()) {
            Annotation[] annotationsOnThisType = this.javaClass.getAnnotations();
            for (int i = 0; i < annotationsOnThisType.length; ++i) {
                Annotation a = annotationsOnThisType[i];
                if (!a.getTypeName().equals(UnresolvedType.AT_RETENTION.getName())) continue;
                List values = a.getValues();
                boolean isRuntime = false;
                Iterator it = values.iterator();
                if (!it.hasNext()) continue;
                ElementNameValuePair element = (ElementNameValuePair)it.next();
                ElementValue v = element.getValue();
                this.retentionPolicy = v.stringifyValue();
                return this.retentionPolicy;
            }
        }
        return this.retentionPolicy;
    }

    public boolean isSynthetic() {
        return this.getResolvedTypeX().isSynthetic();
    }

    public ISourceLocation getSourceLocation() {
        return this.getResolvedTypeX().getSourceContext().makeSourceLocation(0, 0);
    }

    public AjAttribute.WeaverVersionInfo getWeaverVersionAttribute() {
        return this.wvInfo;
    }

    public void addParent(ResolvedType newParent) {
        this.damaged = true;
        if (newParent.isClass()) {
            this.superClass = newParent;
        } else {
            ResolvedType[] oldInterfaceNames = this.getDeclaredInterfaces();
            int len = oldInterfaceNames.length;
            ResolvedType[] newInterfaceNames = new ResolvedType[len + 1];
            System.arraycopy(oldInterfaceNames, 0, newInterfaceNames, 0, len);
            newInterfaceNames[len] = newParent;
            this.interfaces = newInterfaceNames;
        }
    }

    public boolean hasAnnotation(UnresolvedType ofType) {
        this.ensureAnnotationTypesRetrieved();
        for (int i = 0; i < this.annotationTypes.length; ++i) {
            ResolvedType annX = this.annotationTypes[i];
            if (!annX.equals(ofType)) continue;
            return true;
        }
        return false;
    }

    private void ensureAnnotationTypesRetrieved() {
        if (this.annotationTypes == null) {
            Annotation[] annos = this.javaClass.getAnnotations();
            this.annotationTypes = new ResolvedType[annos.length];
            this.annotations = new AnnotationX[annos.length];
            for (int i = 0; i < annos.length; ++i) {
                ResolvedType rtx;
                Annotation annotation = annos[i];
                this.annotationTypes[i] = rtx = this.getResolvedTypeX().getWorld().resolve(UnresolvedType.forName(annotation.getTypeName()));
                this.annotations[i] = new AnnotationX(annotation, this.getResolvedTypeX().getWorld());
            }
        }
    }

    public ResolvedType[] getAnnotationTypes() {
        this.ensureAnnotationTypesRetrieved();
        return this.annotationTypes;
    }

    public AnnotationX[] getAnnotations() {
        this.ensureAnnotationTypesRetrieved();
        return this.annotations;
    }

    public String getDeclaredGenericSignature() {
        if (!this.haveLookedForDeclaredSignature) {
            this.haveLookedForDeclaredSignature = true;
            Attribute[] as = this.javaClass.getAttributes();
            for (int i = 0; i < as.length && this.declaredSignature == null; ++i) {
                Attribute attribute = as[i];
                if (!(attribute instanceof Signature)) continue;
                this.declaredSignature = ((Signature)attribute).getSignature();
            }
            if (this.declaredSignature != null) {
                this.isGenericType = this.declaredSignature.charAt(0) == '<';
            }
        }
        return this.declaredSignature;
    }

    Signature.ClassSignature getGenericClassTypeSignature() {
        return this.javaClass.getGenericClassTypeSignature();
    }

    private void unpackGenericSignature() {
        if (this.genericSignatureUnpacked) {
            return;
        }
        this.genericSignatureUnpacked = true;
        Signature.ClassSignature cSig = this.getGenericClassTypeSignature();
        if (cSig != null) {
            Signature.FormalTypeParameter[] extraFormals;
            this.formalsForResolution = cSig.formalTypeParameters;
            if (this.isNestedClass() && (extraFormals = this.getFormalTypeParametersFromOuterClass()).length > 0) {
                int i;
                ArrayList<Signature.FormalTypeParameter> allFormals = new ArrayList<Signature.FormalTypeParameter>();
                for (i = 0; i < this.formalsForResolution.length; ++i) {
                    allFormals.add(this.formalsForResolution[i]);
                }
                for (i = 0; i < extraFormals.length; ++i) {
                    allFormals.add(extraFormals[i]);
                }
                this.formalsForResolution = new Signature.FormalTypeParameter[allFormals.size()];
                allFormals.toArray(this.formalsForResolution);
            }
            Signature.ClassTypeSignature superSig = cSig.superclassSignature;
            try {
                this.superClass = BcelGenericSignatureToTypeXConverter.classTypeSignature2TypeX(superSig, this.formalsForResolution, this.getResolvedTypeX().getWorld());
            }
            catch (BcelGenericSignatureToTypeXConverter.GenericSignatureFormatException e) {
                throw new IllegalStateException("While determing the generic superclass of " + this.javaClass.getClassName() + " with generic signature " + this.javaClass.getGenericSignature() + " the following error was detected: " + e.getMessage());
            }
            this.interfaces = new ResolvedType[cSig.superInterfaceSignatures.length];
            for (int i = 0; i < cSig.superInterfaceSignatures.length; ++i) {
                try {
                    this.interfaces[i] = BcelGenericSignatureToTypeXConverter.classTypeSignature2TypeX(cSig.superInterfaceSignatures[i], this.formalsForResolution, this.getResolvedTypeX().getWorld());
                    continue;
                }
                catch (BcelGenericSignatureToTypeXConverter.GenericSignatureFormatException e) {
                    throw new IllegalStateException("While determing the generic superinterfaces of " + this.javaClass.getClassName() + " with generic signature " + this.javaClass.getGenericSignature() + " the following error was detected: " + e.getMessage());
                }
            }
        }
        if (this.isGeneric()) {
            ReferenceType genericType = (ReferenceType)this.resolvedTypeX.getGenericType();
            genericType.setSourceContext(this.resolvedTypeX.getSourceContext());
            genericType.setStartPos(this.resolvedTypeX.getStartPos());
            this.resolvedTypeX = genericType;
        }
    }

    public Signature.FormalTypeParameter[] getAllFormals() {
        this.unpackGenericSignature();
        if (this.formalsForResolution == null) {
            return new Signature.FormalTypeParameter[0];
        }
        return this.formalsForResolution;
    }

    private boolean isNestedClass() {
        return this.javaClass.getClassName().indexOf(36) != -1;
    }

    private ReferenceType getOuterClass() {
        if (!this.isNestedClass()) {
            throw new IllegalStateException("Can't get the outer class of a non-nested type");
        }
        int lastDollar = this.javaClass.getClassName().lastIndexOf(36);
        String superClassName = this.javaClass.getClassName().substring(0, lastDollar);
        UnresolvedType outer = UnresolvedType.forName(superClassName);
        return (ReferenceType)outer.resolve(this.getResolvedTypeX().getWorld());
    }

    private Signature.FormalTypeParameter[] getFormalTypeParametersFromOuterClass() {
        Signature.ClassSignature outerSig;
        int i;
        ArrayList<Signature.FormalTypeParameter> typeParameters = new ArrayList<Signature.FormalTypeParameter>();
        ReferenceType outer = this.getOuterClass();
        ReferenceTypeDelegate outerDelegate = outer.getDelegate();
        if (!(outerDelegate instanceof BcelObjectType)) {
            throw new IllegalStateException("How come we're in BcelObjectType resolving an inner type of something that is NOT a BcelObjectType??");
        }
        BcelObjectType outerObjectType = (BcelObjectType)outerDelegate;
        if (outerObjectType.isNestedClass()) {
            Signature.FormalTypeParameter[] parentParams = outerObjectType.getFormalTypeParametersFromOuterClass();
            for (i = 0; i < parentParams.length; ++i) {
                typeParameters.add(parentParams[i]);
            }
        }
        if ((outerSig = outerObjectType.getGenericClassTypeSignature()) != null) {
            for (i = 0; i < outerSig.formalTypeParameters.length; ++i) {
                typeParameters.add(outerSig.formalTypeParameters[i]);
            }
        }
        Signature.FormalTypeParameter[] ret = new Signature.FormalTypeParameter[typeParameters.size()];
        typeParameters.toArray(ret);
        return ret;
    }

    private void ensureGenericInfoProcessed() {
        this.getDeclaredGenericSignature();
    }

    public boolean isGeneric() {
        this.ensureGenericInfoProcessed();
        return this.isGenericType;
    }

    public String toString() {
        return this.javaClass == null ? "BcelObjectType" : "BcelObjectTypeFor:" + this.javaClass.getClassName();
    }
}

