/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.loadtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.aspectj.apache.bcel.classfile.JavaClass;
import org.aspectj.apache.bcel.generic.InstructionConstants;
import org.aspectj.apache.bcel.generic.InstructionList;
import org.aspectj.apache.bcel.generic.ObjectType;
import org.aspectj.apache.bcel.generic.Type;
import org.aspectj.apache.bcel.generic.annotation.AnnotationGen;
import org.aspectj.apache.bcel.generic.annotation.ElementNameValuePairGen;
import org.aspectj.apache.bcel.generic.annotation.ElementValueGen;
import org.aspectj.apache.bcel.generic.annotation.SimpleElementValueGen;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.Message;
import org.aspectj.weaver.AnnotationX;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.World;
import org.aspectj.weaver.bcel.BcelPerClauseAspectAdder;
import org.aspectj.weaver.bcel.BcelWorld;
import org.aspectj.weaver.bcel.LazyClassGen;
import org.aspectj.weaver.bcel.LazyMethodGen;
import org.aspectj.weaver.loadtime.definition.Definition;
import org.aspectj.weaver.patterns.PerClause;
import org.aspectj.weaver.patterns.PerSingleton;

public class ConcreteAspectCodeGen {
    private static final String[] EMPTY_STRINGS = new String[0];
    private static final Type[] EMPTY_TYPES = new Type[0];
    private final Definition.ConcreteAspect m_concreteAspect;
    private final World m_world;
    private boolean m_isValid = false;
    private ResolvedType m_parent;
    private PerClause m_perClause;

    ConcreteAspectCodeGen(Definition.ConcreteAspect concreteAspect, World world) {
        this.m_concreteAspect = concreteAspect;
        this.m_world = world;
    }

    public boolean validate() {
        if (!(this.m_world instanceof BcelWorld)) {
            this.reportError("Internal error: world must be of type BcelWorld");
            return false;
        }
        ResolvedType current = this.m_world.resolve(this.m_concreteAspect.name, true);
        if (!current.isMissing()) {
            this.reportError("Attempt to concretize but choosen aspect name already defined: " + this.stringify());
            return false;
        }
        if (this.m_concreteAspect.extend == null && this.m_concreteAspect.precedence != null) {
            if (this.m_concreteAspect.pointcuts.isEmpty()) {
                this.m_isValid = true;
                this.m_perClause = new PerSingleton();
                this.m_parent = null;
                return true;
            }
            this.reportError("Attempt to use nested pointcuts without extends clause: " + this.stringify());
            return false;
        }
        this.m_parent = this.m_world.resolve(this.m_concreteAspect.extend, true);
        if (this.m_parent.equals(ResolvedType.MISSING)) {
            String fixedName = this.m_concreteAspect.extend;
            int hasDot = fixedName.lastIndexOf(46);
            while (hasDot > 0) {
                char[] fixedNameChars = fixedName.toCharArray();
                fixedNameChars[hasDot] = 36;
                fixedName = new String(fixedNameChars);
                hasDot = fixedName.lastIndexOf(46);
                this.m_parent = this.m_world.resolve(UnresolvedType.forName(fixedName), true);
                if (this.m_parent.equals(ResolvedType.MISSING)) continue;
                break;
            }
        }
        if (this.m_parent.isMissing()) {
            this.reportError("Cannot find m_parent aspect for: " + this.stringify());
            return false;
        }
        if (!this.m_parent.isAbstract()) {
            this.reportError("Attempt to concretize a non-abstract aspect: " + this.stringify());
            return false;
        }
        if (!this.m_parent.isAspect()) {
            this.reportError("Attempt to concretize a non aspect: " + this.stringify());
            return false;
        }
        ArrayList<String> elligibleAbstractions = new ArrayList<String>();
        Iterator methods = this.m_parent.getMethods();
        while (methods.hasNext()) {
            ResolvedMember method = (ResolvedMember)methods.next();
            if (!method.isAbstract()) continue;
            if ("()V".equals(method.getSignature())) {
                elligibleAbstractions.add(method.getName());
                continue;
            }
            this.reportError("Abstract method '" + method.getName() + "' cannot be concretized as a pointcut (illegal signature, must have no arguments, must return void): " + this.stringify());
            return false;
        }
        ArrayList<String> pointcutNames = new ArrayList<String>();
        Iterator it = this.m_concreteAspect.pointcuts.iterator();
        while (it.hasNext()) {
            Definition.Pointcut abstractPc = (Definition.Pointcut)it.next();
            pointcutNames.add(abstractPc.name);
        }
        it = elligibleAbstractions.iterator();
        while (it.hasNext()) {
            String elligiblePc = (String)it.next();
            if (pointcutNames.contains(elligiblePc)) continue;
            this.reportError("Abstract pointcut '" + elligiblePc + "' not configured: " + this.stringify());
            return false;
        }
        this.m_perClause = this.m_parent.getPerClause();
        this.m_isValid = true;
        return this.m_isValid;
    }

    private String stringify() {
        StringBuffer sb = new StringBuffer("<concrete-aspect name='");
        sb.append(this.m_concreteAspect.name);
        sb.append("' extends='");
        sb.append(this.m_concreteAspect.extend);
        sb.append("'/> in aop.xml");
        return sb.toString();
    }

    public byte[] getBytes() {
        if (!this.m_isValid) {
            throw new RuntimeException("Must validate first");
        }
        LazyClassGen cg = new LazyClassGen(this.m_concreteAspect.name.replace('.', '/'), this.m_parent == null ? "java/lang/Object" : this.m_parent.getName().replace('.', '/'), null, 33, EMPTY_STRINGS, this.m_world);
        AnnotationGen ag = new AnnotationGen(new ObjectType("org/aspectj/lang/annotation/Aspect"), Collections.EMPTY_LIST, true, cg.getConstantPoolGen());
        cg.addAnnotation(ag.getAnnotation());
        if (this.m_concreteAspect.precedence != null) {
            SimpleElementValueGen svg = new SimpleElementValueGen(115, cg.getConstantPoolGen(), this.m_concreteAspect.precedence);
            ArrayList<ElementNameValuePairGen> elems = new ArrayList<ElementNameValuePairGen>();
            elems.add(new ElementNameValuePairGen("value", (ElementValueGen)svg, cg.getConstantPoolGen()));
            AnnotationGen agprec = new AnnotationGen(new ObjectType("org/aspectj/lang/annotation/DeclarePrecedence"), elems, true, cg.getConstantPoolGen());
            cg.addAnnotation(agprec.getAnnotation());
        }
        LazyMethodGen init = new LazyMethodGen(1, Type.VOID, "<init>", EMPTY_TYPES, EMPTY_STRINGS, cg);
        InstructionList cbody = init.getBody();
        cbody.append(InstructionConstants.ALOAD_0);
        cbody.append(cg.getFactory().createInvoke(this.m_parent == null ? "java/lang/Object" : this.m_parent.getName().replace('.', '/'), "<init>", Type.VOID, EMPTY_TYPES, (short)183));
        cbody.append(InstructionConstants.RETURN);
        cg.addMethodGen(init);
        Iterator it = this.m_concreteAspect.pointcuts.iterator();
        while (it.hasNext()) {
            Definition.Pointcut abstractPc = (Definition.Pointcut)it.next();
            LazyMethodGen mg = new LazyMethodGen(1, Type.VOID, abstractPc.name, EMPTY_TYPES, EMPTY_STRINGS, cg);
            SimpleElementValueGen svg = new SimpleElementValueGen(115, cg.getConstantPoolGen(), abstractPc.expression);
            ArrayList<ElementNameValuePairGen> elems = new ArrayList<ElementNameValuePairGen>();
            elems.add(new ElementNameValuePairGen("value", (ElementValueGen)svg, cg.getConstantPoolGen()));
            AnnotationGen mag = new AnnotationGen(new ObjectType("org/aspectj/lang/annotation/Pointcut"), elems, true, cg.getConstantPoolGen());
            AnnotationX max = new AnnotationX(mag.getAnnotation(), this.m_world);
            mg.addAnnotation(max);
            InstructionList body = mg.getBody();
            body.append(InstructionConstants.RETURN);
            cg.addMethodGen(mg);
        }
        BcelPerClauseAspectAdder perClauseMunger = new BcelPerClauseAspectAdder(UnresolvedType.forName(this.m_concreteAspect.name).resolve(this.m_world), this.m_perClause.getKind());
        perClauseMunger.forceMunge(cg, false);
        JavaClass jc = cg.getJavaClass((BcelWorld)this.m_world);
        ((BcelWorld)this.m_world).addSourceObjectType(jc);
        return jc.getBytes();
    }

    private void reportError(String message) {
        this.m_world.getMessageHandler().handleMessage(new Message(message, IMessage.ERROR, null, null));
    }
}

