/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.patterns.AndPointcut;
import org.aspectj.weaver.patterns.IfPointcut;
import org.aspectj.weaver.patterns.KindedPointcut;
import org.aspectj.weaver.patterns.NotPointcut;
import org.aspectj.weaver.patterns.OrPointcut;
import org.aspectj.weaver.patterns.Pointcut;
import org.aspectj.weaver.patterns.PointcutEvaluationExpenseComparator;
import org.aspectj.weaver.patterns.SignaturePattern;
import org.aspectj.weaver.patterns.TypePattern;
import org.aspectj.weaver.patterns.WithincodePointcut;

public class PointcutRewriter {
    private static final boolean WATCH_PROGRESS = false;

    public Pointcut rewrite(Pointcut pc) {
        Pointcut result = this.distributeNot(pc);
        result = this.pullUpDisjunctions(result);
        result = this.simplifyAnds(result);
        result = this.sortOrs(result);
        return result;
    }

    private Pointcut distributeNot(Pointcut pc) {
        if (this.isNot(pc)) {
            NotPointcut npc = (NotPointcut)pc;
            Pointcut notBody = this.distributeNot(npc.getNegatedPointcut());
            if (this.isNot(notBody)) {
                return ((NotPointcut)notBody).getNegatedPointcut();
            }
            if (this.isAnd(notBody)) {
                AndPointcut apc = (AndPointcut)notBody;
                Pointcut newLeft = this.distributeNot(new NotPointcut(apc.getLeft()));
                Pointcut newRight = this.distributeNot(new NotPointcut(apc.getRight()));
                return new OrPointcut(newLeft, newRight);
            }
            if (this.isOr(notBody)) {
                OrPointcut opc = (OrPointcut)notBody;
                Pointcut newLeft = this.distributeNot(new NotPointcut(opc.getLeft()));
                Pointcut newRight = this.distributeNot(new NotPointcut(opc.getRight()));
                return new AndPointcut(newLeft, newRight);
            }
            return new NotPointcut(notBody);
        }
        if (this.isAnd(pc)) {
            AndPointcut apc = (AndPointcut)pc;
            Pointcut left = this.distributeNot(apc.getLeft());
            Pointcut right = this.distributeNot(apc.getRight());
            return new AndPointcut(left, right);
        }
        if (this.isOr(pc)) {
            OrPointcut opc = (OrPointcut)pc;
            Pointcut left = this.distributeNot(opc.getLeft());
            Pointcut right = this.distributeNot(opc.getRight());
            return new OrPointcut(left, right);
        }
        return pc;
    }

    private Pointcut pullUpDisjunctions(Pointcut pc) {
        if (this.isNot(pc)) {
            NotPointcut npc = (NotPointcut)pc;
            return new NotPointcut(this.pullUpDisjunctions(npc.getNegatedPointcut()));
        }
        if (this.isAnd(pc)) {
            AndPointcut apc = (AndPointcut)pc;
            Pointcut left = this.pullUpDisjunctions(apc.getLeft());
            Pointcut right = this.pullUpDisjunctions(apc.getRight());
            if (this.isOr(left) && !this.isOr(right)) {
                Pointcut leftLeft = ((OrPointcut)left).getLeft();
                Pointcut leftRight = ((OrPointcut)left).getRight();
                return this.pullUpDisjunctions(new OrPointcut(new AndPointcut(leftLeft, right), new AndPointcut(leftRight, right)));
            }
            if (this.isOr(right) && !this.isOr(left)) {
                Pointcut rightLeft = ((OrPointcut)right).getLeft();
                Pointcut rightRight = ((OrPointcut)right).getRight();
                return this.pullUpDisjunctions(new OrPointcut(new AndPointcut(left, rightLeft), new AndPointcut(left, rightRight)));
            }
            return new AndPointcut(left, right);
        }
        if (this.isOr(pc)) {
            OrPointcut opc = (OrPointcut)pc;
            return new OrPointcut(this.pullUpDisjunctions(opc.getLeft()), this.pullUpDisjunctions(opc.getRight()));
        }
        return pc;
    }

    private SignaturePattern removeDeclaringTypePattern(SignaturePattern sp) {
        return new SignaturePattern(sp.getKind(), sp.getModifiers(), sp.getReturnType(), TypePattern.ANY, sp.getName(), sp.getParameterTypes(), sp.getThrowsPattern(), sp.getAnnotationPattern());
    }

    private Pointcut simplifyAnds(Pointcut pc) {
        if (this.isNot(pc)) {
            NotPointcut npc = (NotPointcut)pc;
            return new NotPointcut(this.simplifyAnds(npc.getNegatedPointcut()));
        }
        if (this.isOr(pc)) {
            OrPointcut opc = (OrPointcut)pc;
            return new OrPointcut(this.simplifyAnds(opc.getLeft()), this.simplifyAnds(opc.getRight()));
        }
        if (this.isAnd(pc)) {
            return this.simplifyAnd((AndPointcut)pc);
        }
        return pc;
    }

    private Pointcut simplifyAnd(AndPointcut apc) {
        TreeSet nodes = new TreeSet(new PointcutEvaluationExpenseComparator());
        this.collectAndNodes(apc, nodes);
        Iterator iter = nodes.iterator();
        while (iter.hasNext()) {
            Pointcut body;
            Pointcut element = (Pointcut)iter.next();
            if (element instanceof NotPointcut && nodes.contains(body = ((NotPointcut)element).getNegatedPointcut())) {
                return Pointcut.makeMatchesNothing(body.state);
            }
            if (element instanceof IfPointcut && ((IfPointcut)element).alwaysFalse()) {
                return Pointcut.makeMatchesNothing(element.state);
            }
            if (!element.couldMatchKinds().isEmpty()) continue;
            return element;
        }
        if (apc.couldMatchKinds().isEmpty()) {
            return Pointcut.makeMatchesNothing(apc.state);
        }
        iter = nodes.iterator();
        Pointcut result = (Pointcut)iter.next();
        while (iter.hasNext()) {
            Pointcut right = (Pointcut)iter.next();
            result = new AndPointcut(result, right);
        }
        return result;
    }

    private Pointcut sortOrs(Pointcut pc) {
        TreeSet nodes = new TreeSet(new PointcutEvaluationExpenseComparator());
        this.collectOrNodes(pc, nodes);
        Iterator iter = nodes.iterator();
        Pointcut result = (Pointcut)iter.next();
        while (iter.hasNext()) {
            Pointcut right = (Pointcut)iter.next();
            result = new OrPointcut(result, right);
        }
        return result;
    }

    private void collectAndNodes(AndPointcut apc, Set nodesSoFar) {
        Pointcut left = apc.getLeft();
        Pointcut right = apc.getRight();
        if (this.isAnd(left)) {
            this.collectAndNodes((AndPointcut)left, nodesSoFar);
        } else {
            nodesSoFar.add(left);
        }
        if (this.isAnd(right)) {
            this.collectAndNodes((AndPointcut)right, nodesSoFar);
        } else {
            nodesSoFar.add(right);
        }
    }

    private void collectOrNodes(Pointcut pc, Set nodesSoFar) {
        if (this.isOr(pc)) {
            OrPointcut opc = (OrPointcut)pc;
            this.collectOrNodes(opc.getLeft(), nodesSoFar);
            this.collectOrNodes(opc.getRight(), nodesSoFar);
        } else {
            nodesSoFar.add(pc);
        }
    }

    private boolean isNot(Pointcut pc) {
        return pc instanceof NotPointcut;
    }

    private boolean isAnd(Pointcut pc) {
        return pc instanceof AndPointcut;
    }

    private boolean isOr(Pointcut pc) {
        return pc instanceof OrPointcut;
    }

    private boolean isExecution(Pointcut pc) {
        if (pc instanceof KindedPointcut) {
            KindedPointcut kp = (KindedPointcut)pc;
            if (kp.kind == Shadow.MethodExecution) {
                return true;
            }
            if (kp.kind == Shadow.ConstructorExecution) {
                return true;
            }
        }
        return false;
    }

    private boolean isWithinCode(Pointcut pc) {
        return pc instanceof WithincodePointcut;
    }

    private boolean isAnyType(TypePattern tp) {
        if (tp == TypePattern.ANY) {
            return true;
        }
        return tp.toString().equals("*");
    }
}

