/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.reflect;

import java.lang.reflect.Member;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.World;
import org.aspectj.weaver.ast.And;
import org.aspectj.weaver.ast.Call;
import org.aspectj.weaver.ast.FieldGetCall;
import org.aspectj.weaver.ast.HasAnnotation;
import org.aspectj.weaver.ast.ITestVisitor;
import org.aspectj.weaver.ast.Instanceof;
import org.aspectj.weaver.ast.Literal;
import org.aspectj.weaver.ast.Not;
import org.aspectj.weaver.ast.Or;
import org.aspectj.weaver.ast.Test;
import org.aspectj.weaver.ast.Var;
import org.aspectj.weaver.patterns.ExposedState;
import org.aspectj.weaver.reflect.JoinPointMatchImpl;
import org.aspectj.weaver.reflect.PointcutParameterImpl;
import org.aspectj.weaver.reflect.ReflectionVar;
import org.aspectj.weaver.tools.JoinPointMatch;
import org.aspectj.weaver.tools.PointcutParameter;
import org.aspectj.weaver.tools.ShadowMatch;

public class ShadowMatchImpl
implements ShadowMatch {
    private FuzzyBoolean match;
    private ExposedState state;
    private Test residualTest;
    private PointcutParameter[] params;
    private Member withinCode;
    private Member subject;
    private Class withinType;

    public ShadowMatchImpl(FuzzyBoolean match, Test test, ExposedState state, PointcutParameter[] params) {
        this.match = match;
        this.residualTest = test;
        this.state = state;
        this.params = params;
    }

    public void setWithinCode(Member aMember) {
        this.withinCode = aMember;
    }

    public void setSubject(Member aMember) {
        this.subject = aMember;
    }

    public void setWithinType(Class aClass) {
        this.withinType = aClass;
    }

    public boolean alwaysMatches() {
        return this.match.alwaysTrue();
    }

    public boolean maybeMatches() {
        return this.match.maybeTrue();
    }

    public boolean neverMatches() {
        return this.match.alwaysFalse();
    }

    public JoinPointMatch matchesJoinPoint(Object thisObject, Object targetObject, Object[] args) {
        if (this.neverMatches()) {
            return JoinPointMatchImpl.NO_MATCH;
        }
        if (new RuntimeTestEvaluator(this.residualTest, thisObject, targetObject, args).matches()) {
            return new JoinPointMatchImpl(this.getPointcutParameters(thisObject, targetObject, args));
        }
        return JoinPointMatchImpl.NO_MATCH;
    }

    private PointcutParameter[] getPointcutParameters(Object thisObject, Object targetObject, Object[] args) {
        Var[] vars = this.state.vars;
        PointcutParameter[] bindings = new PointcutParameterImpl[this.params.length];
        for (int i = 0; i < bindings.length; ++i) {
            bindings[i] = new PointcutParameterImpl(this.params[i].getName(), this.params[i].getType());
            ((PointcutParameterImpl)bindings[i]).setBinding(((ReflectionVar)vars[i]).getBindingAtJoinPoint(thisObject, targetObject, args, this.subject, this.withinCode, this.withinType));
        }
        return bindings;
    }

    private static class RuntimeTestEvaluator
    implements ITestVisitor {
        private boolean matches = true;
        private Test test;
        private Object thisObject;
        private Object targetObject;
        private Object[] args;

        public RuntimeTestEvaluator(Test aTest, Object thisObject, Object targetObject, Object[] args) {
            this.test = aTest;
            this.thisObject = thisObject;
            this.targetObject = targetObject;
            this.args = args;
        }

        public boolean matches() {
            this.test.accept(this);
            return this.matches;
        }

        public void visit(And e) {
            boolean leftMatches = new RuntimeTestEvaluator(e.getLeft(), this.thisObject, this.targetObject, this.args).matches();
            this.matches = !leftMatches ? false : new RuntimeTestEvaluator(e.getRight(), this.thisObject, this.targetObject, this.args).matches();
        }

        public void visit(Instanceof i) {
            ReflectionVar v = (ReflectionVar)i.getVar();
            Object value = v.getBindingAtJoinPoint(this.thisObject, this.targetObject, this.args);
            World world = v.getType().getWorld();
            ResolvedType desiredType = i.getType().resolve(world);
            ResolvedType actualType = world.resolve(value.getClass().getName());
            this.matches = desiredType.isAssignableFrom(actualType);
        }

        public void visit(Not not) {
            this.matches = !new RuntimeTestEvaluator(not.getBody(), this.thisObject, this.targetObject, this.args).matches();
        }

        public void visit(Or or) {
            boolean leftMatches = new RuntimeTestEvaluator(or.getLeft(), this.thisObject, this.targetObject, this.args).matches();
            this.matches = leftMatches ? true : new RuntimeTestEvaluator(or.getRight(), this.thisObject, this.targetObject, this.args).matches();
        }

        public void visit(Literal literal) {
            this.matches = literal != Literal.FALSE;
        }

        public void visit(Call call) {
            throw new UnsupportedOperationException("Can't evaluate call test at runtime");
        }

        public void visit(FieldGetCall fieldGetCall) {
            throw new UnsupportedOperationException("Can't evaluate fieldGetCall test at runtime");
        }

        public void visit(HasAnnotation hasAnnotation) {
            ReflectionVar v = (ReflectionVar)hasAnnotation.getVar();
            Object value = v.getBindingAtJoinPoint(this.thisObject, this.targetObject, this.args);
            World world = v.getType().getWorld();
            ResolvedType actualVarType = world.resolve(value.getClass().getName());
            ResolvedType requiredAnnotationType = hasAnnotation.getAnnotationType().resolve(world);
            this.matches = actualVarType.hasAnnotation(requiredAnnotationType);
        }
    }
}

