/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.hook;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import org.codehaus.aspectwerkz.hook.ClassLoaderPatcher;

public class Plug {
    private static final String TRANSPORT_JDWP = "transport";
    private static final String ADDRESS_JDWP = "address";
    static /* synthetic */ Class class$org$codehaus$aspectwerkz$hook$impl$ClassLoaderPreProcessorImpl;

    public void target(String destJar) throws Exception {
        File dest = new File(destJar);
        if (dest.exists() && !dest.canWrite()) {
            throw new Exception(destJar + " exists and is not writable");
        }
        byte[] patched = ClassLoaderPatcher.getPatchedClassLoader(System.getProperty("aspectwerkz.classloader.clpreprocessor", (class$org$codehaus$aspectwerkz$hook$impl$ClassLoaderPreProcessorImpl == null ? (class$org$codehaus$aspectwerkz$hook$impl$ClassLoaderPreProcessorImpl = Plug.class$("org.codehaus.aspectwerkz.hook.impl.ClassLoaderPreProcessorImpl")) : class$org$codehaus$aspectwerkz$hook$impl$ClassLoaderPreProcessorImpl).getName()));
        Manifest mf = new Manifest();
        Attributes at = mf.getMainAttributes();
        at.putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
        at.putValue("Created-By", "AspectWerkz (c) Plug [java " + System.getProperty("java.version") + ']');
        ZipEntry entry = new ZipEntry("java/lang/ClassLoader.class");
        entry.setSize(patched.length);
        CRC32 crc = new CRC32();
        crc.update(patched);
        entry.setCrc(crc.getValue());
        JarOutputStream jar = new JarOutputStream((OutputStream)new FileOutputStream(dest), mf);
        jar.putNextEntry(entry);
        jar.write(patched);
        jar.closeEntry();
        jar.close();
    }

    private VirtualMachine connect(Map jdwp) throws Exception {
        String transport = (String)jdwp.get(TRANSPORT_JDWP);
        String address = (String)jdwp.get(ADDRESS_JDWP);
        String name = null;
        if ("dt_socket".equals(transport)) {
            name = "com.sun.jdi.SocketAttach";
        } else if ("dt_shmem".equals(transport)) {
            name = "com.sun.jdi.SharedMemoryAttach";
        }
        Connector connector = null;
        Iterator<AttachingConnector> i = Bootstrap.virtualMachineManager().attachingConnectors().iterator();
        while (i.hasNext()) {
            AttachingConnector aConnector = i.next();
            if (!aConnector.name().equals(name)) continue;
            connector = aConnector;
            break;
        }
        if (connector == null) {
            throw new Exception("no AttachingConnector for transport: " + transport);
        }
        Map<String, Connector.Argument> args = connector.defaultArguments();
        if ("dt_socket".equals(transport)) {
            args.get("port").setValue(address);
        } else if ("dt_shmem".equals(transport)) {
            args.get("name").setValue(address);
        }
        try {
            VirtualMachine vm = connector.attach(args);
            return vm;
        }
        catch (IllegalConnectorArgumentsException e) {
            System.err.println("failed to attach to VM (" + transport + ", " + address + "):");
            e.printStackTrace();
            Iterator<String> i2 = e.argumentNames().iterator();
            while (i2.hasNext()) {
                System.err.println("wrong or missing argument - " + i2.next());
            }
            return null;
        }
        catch (IOException e) {
            System.err.println("failed to attach to VM (" + transport + ", " + address + "):");
            e.printStackTrace();
            return null;
        }
    }

    public void resume(Map jdwp) throws Exception {
        VirtualMachine vm = this.connect(jdwp);
        if (vm != null) {
            vm.resume();
            vm.dispose();
        }
    }

    public void info(Map jdwp) throws Exception {
        VirtualMachine vm = this.connect(jdwp);
        if (vm != null) {
            System.out.println("java.vm.name = " + vm.name());
            System.out.println("java.version = " + vm.version());
            System.out.println(vm.description());
            vm.resume();
            vm.dispose();
        }
    }

    public void hotswap(Map jdwp) throws Exception {
        VirtualMachine vm = ClassLoaderPatcher.hotswapClassLoader(System.getProperty("aspectwerkz.classloader.clpreprocessor", (class$org$codehaus$aspectwerkz$hook$impl$ClassLoaderPreProcessorImpl == null ? (class$org$codehaus$aspectwerkz$hook$impl$ClassLoaderPreProcessorImpl = Plug.class$("org.codehaus.aspectwerkz.hook.impl.ClassLoaderPreProcessorImpl")) : class$org$codehaus$aspectwerkz$hook$impl$ClassLoaderPreProcessorImpl).getName()), (String)jdwp.get(TRANSPORT_JDWP), (String)jdwp.get(ADDRESS_JDWP));
        if (vm != null) {
            vm.resume();
            vm.dispose();
        }
    }

    public static void usage() {
        System.out.println("AspectWerkz (c) Plug");
        System.out.println("Usage: -target <targetJar.jar>");
        System.out.println("       -hotswap <jdwp options>");
        System.out.println("       -resume <jdwp options>");
        System.out.println("       -info <jdwp options>");
    }

    public static Map parseArgs(String args) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        StringTokenizer st = new StringTokenizer(args, ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int index = token.indexOf("=");
            if (index < 0) {
                throw new Exception("invalid jdwp string: " + args);
            }
            map.put(token.substring(0, index), token.substring(index + 1));
        }
        return map;
    }

    public static void main(String[] args) {
        Plug plug = new Plug();
        if (args.length != 2) {
            Plug.usage();
            System.exit(1);
        }
        if ("-target".equals(args[0])) {
            try {
                plug.target(args[1]);
                System.out.println("done: " + args[1]);
            }
            catch (Exception e) {
                System.err.println("-target failed: " + e.getMessage());
                e.printStackTrace();
            }
        } else {
            try {
                Map jdwp = Plug.parseArgs(args[1]);
                if ("-hotswap".equals(args[0])) {
                    plug.hotswap(jdwp);
                } else if ("-resume".equals(args[0])) {
                    plug.resume(jdwp);
                } else if ("-info".equals(args[0])) {
                    plug.info(jdwp);
                } else {
                    Plug.usage();
                    System.exit(1);
                }
            }
            catch (Exception e) {
                System.err.println(args[0] + " failed: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

