/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.hook;

import com.sun.jdi.VirtualMachine;
import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import org.codehaus.aspectwerkz.hook.BootClasspathStarter;
import org.codehaus.aspectwerkz.hook.ClassLoaderPatcher;
import org.codehaus.aspectwerkz.hook.JDWPStarter;
import org.codehaus.aspectwerkz.hook.StreamRedirectThread;

public class ProcessStarter {
    static final String CL_PRE_PROCESSOR_CLASSNAME_PROPERTY = "aspectwerkz.classloader.clpreprocessor";
    private static final String CL_BOOTCLASSPATH_FORCE_DEFAULT = "." + File.separatorChar + "boot";
    private static final String CL_BOOTCLASSPATH_FORCE_PROPERTY = "aspectwerkz.classloader.clbootclasspath";
    private Process process = null;
    private boolean executeShutdownHook = true;
    private Thread inThread;
    private Thread outThread;
    private Thread errThread;
    static /* synthetic */ Class class$com$sun$jdi$VirtualMachine;

    private static boolean hasCanRedefineClass() {
        try {
            (class$com$sun$jdi$VirtualMachine == null ? (class$com$sun$jdi$VirtualMachine = ProcessStarter.class$("com.sun.jdi.VirtualMachine")) : class$com$sun$jdi$VirtualMachine).getMethod("canRedefineClasses", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        return true;
    }

    private int run(String[] args) {
        StringBuffer optionsArgB = new StringBuffer();
        StringBuffer cpOptionsArgB = new StringBuffer();
        StringBuffer mainArgB = new StringBuffer();
        String previous = null;
        boolean foundMain = false;
        int i = 0;
        while (i < args.length) {
            if (args[i].startsWith("-") && !foundMain) {
                if (!"-cp".equals(args[i]) && !"-classpath".equals(args[i])) {
                    optionsArgB.append(args[i]).append(" ");
                }
            } else if (!foundMain && ("-cp".equals(previous) || "-classpath".equals(previous))) {
                if (cpOptionsArgB.length() > 0) {
                    cpOptionsArgB.append(System.getProperty("os.name", "").toLowerCase().indexOf("windows") >= 0 ? ";" : ":");
                }
                cpOptionsArgB.append(args[i]);
            } else {
                foundMain = true;
                mainArgB.append(args[i]).append(" ");
            }
            previous = args[i];
            ++i;
        }
        String opt = null;
        opt = System.getProperty("os.name", "").toLowerCase().indexOf("windows") >= 0 ? optionsArgB.append(" -cp \"").append(cpOptionsArgB.toString()).append("\"").toString() : optionsArgB.append("-cp ").append(ProcessStarter.escapeWhiteSpace(cpOptionsArgB.toString())).toString();
        String main = mainArgB.toString();
        String clp = System.getProperty(CL_PRE_PROCESSOR_CLASSNAME_PROPERTY, "org.codehaus.aspectwerkz.hook.impl.ClassLoaderPreProcessorImpl");
        if (!ProcessStarter.hasCanRedefineClass() || System.getProperty(CL_BOOTCLASSPATH_FORCE_PROPERTY) != null) {
            String bootDir = System.getProperty(CL_BOOTCLASSPATH_FORCE_PROPERTY, CL_BOOTCLASSPATH_FORCE_DEFAULT);
            if (System.getProperty(CL_BOOTCLASSPATH_FORCE_PROPERTY) != null) {
                System.out.println("HotSwap deactivated, using bootclasspath: " + bootDir);
            } else {
                System.out.println("HotSwap not supported by this java version, using bootclasspath: " + bootDir);
            }
            ClassLoaderPatcher.patchClassLoader(clp, bootDir);
            BootClasspathStarter starter = new BootClasspathStarter(opt, main, bootDir);
            try {
                this.process = starter.launchVM();
            }
            catch (IOException e) {
                System.err.println("failed to launch process :" + starter.getCommandLine());
                e.printStackTrace();
                return -1;
            }
        }
        JDWPStarter starter = new JDWPStarter(opt, main, "dt_socket", "9300");
        try {
            this.process = starter.launchVM();
        }
        catch (IOException e) {
            System.err.println("failed to launch process :" + starter.getCommandLine());
            e.printStackTrace();
            return -1;
        }
        VirtualMachine vm = ClassLoaderPatcher.hotswapClassLoader(clp, starter.getTransport(), starter.getAddress());
        if (vm == null) {
            this.process.destroy();
        } else {
            vm.resume();
            vm.dispose();
        }
        this.redirectStreams();
        Thread shutdownHook = new Thread(){

            public void run() {
                ProcessStarter.this.shutdown();
            }
        };
        try {
            Runtime.getRuntime().addShutdownHook(shutdownHook);
            int exitCode = this.process.waitFor();
            this.executeShutdownHook = false;
            return exitCode;
        }
        catch (Exception e) {
            this.executeShutdownHook = false;
            e.printStackTrace();
            return -1;
        }
    }

    private void shutdown() {
        if (this.executeShutdownHook) {
            this.process.destroy();
        }
        try {
            this.outThread.join();
            this.errThread.join();
        }
        catch (InterruptedException e) {}
    }

    private void redirectStreams() {
        this.inThread = new StreamRedirectThread("in.redirect", System.in, this.process.getOutputStream());
        this.inThread.setDaemon(true);
        this.outThread = new StreamRedirectThread("out.redirect", this.process.getInputStream(), System.out);
        this.errThread = new StreamRedirectThread("err.redirect", this.process.getErrorStream(), System.err);
        this.inThread.start();
        this.outThread.start();
        this.errThread.start();
    }

    public static void main(String[] args) {
        System.exit(new ProcessStarter().run(args));
    }

    private static String escapeWhiteSpace(String s) {
        if (s.indexOf(32) > 0) {
            StringBuffer sb = new StringBuffer();
            StringTokenizer st = new StringTokenizer(s, " ", true);
            String current = null;
            while (st.hasMoreTokens()) {
                current = st.nextToken();
                if (" ".equals(current)) {
                    sb.append("\\ ");
                    continue;
                }
                sb.append(current);
            }
            return sb.toString();
        }
        return s;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

