/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.hook.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.Type;
import org.codehaus.aspectwerkz.hook.ClassLoaderPatcher;
import org.codehaus.aspectwerkz.hook.ClassLoaderPreProcessor;

public class ClassLoaderPreProcessorImpl
implements ClassLoaderPreProcessor {
    public byte[] preProcess(byte[] b) {
        try {
            ClassGen cg = new ClassGen(new ClassParser((InputStream)new ByteArrayInputStream(b), "<generated>").parse());
            String className = cg.getClassName();
            Method[] methods = cg.getMethods();
            ConstantPoolGen cpg = cg.getConstantPool();
            InstructionFactory factory = new InstructionFactory(cg);
            int i = 0;
            while (i < methods.length) {
                MethodGen mg = new MethodGen(methods[i], className, cpg);
                InstructionList il = mg.getInstructionList();
                if (il != null) {
                    InstructionHandle ih = il.getStart();
                    while (ih != null) {
                        Instruction ins = ih.getInstruction();
                        if (ins instanceof INVOKESPECIAL || ins instanceof INVOKESTATIC || ins instanceof INVOKEVIRTUAL) {
                            InvokeInstruction invokeInst = (InvokeInstruction)ins;
                            String callerSideMethodClassName = invokeInst.getClassName(cpg);
                            String callerSideMethodName = invokeInst.getMethodName(cpg);
                            if ("java.lang.ClassLoader".equals(callerSideMethodClassName) && "defineClass0".equals(callerSideMethodName)) {
                                InstructionHandle ihc = il.insert(ih, (Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)16));
                                ihc = il.append(ihc, (Instruction)InstructionFactory.createStore((Type)Type.INT, (int)15));
                                ihc = il.append(ihc, (Instruction)InstructionFactory.createStore((Type)Type.INT, (int)14));
                                ihc = il.append(ihc, (Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)13));
                                ihc = il.append(ihc, (Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)12));
                                ihc = il.append(ihc, (Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)11));
                                ihc = il.append(ihc, (Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)11));
                                ihc = il.append(ihc, (Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)12));
                                ihc = il.append(ihc, (Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)13));
                                ihc = il.append(ihc, (Instruction)InstructionFactory.createLoad((Type)Type.INT, (int)14));
                                ihc = il.append(ihc, (Instruction)InstructionFactory.createLoad((Type)Type.INT, (int)15));
                                ihc = il.append(ihc, (Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)16));
                                ihc = il.append(ihc, (Instruction)factory.createInvoke("org.codehaus.aspectwerkz.hook.impl.ClassPreProcessorHelper", "defineClass0Pre", (Type)new ArrayType((Type)Type.BYTE, 1), new Type[]{new ObjectType("java.lang.ClassLoader"), Type.STRING, new ArrayType((Type)Type.BYTE, 1), Type.INT, Type.INT, new ObjectType("java.security.ProtectionDomain")}, (short)184));
                                ihc = il.append(ihc, (Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)18));
                                ihc = il.append(ihc, (Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)11));
                                ihc = il.append(ihc, (Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)12));
                                ihc = il.append(ihc, (Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)18));
                                ihc = il.append(ihc, (CompoundInstruction)new PUSH(cpg, 0));
                                ihc = il.append(ihc, (Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)18));
                                ihc = il.append(ihc, InstructionConstants.ARRAYLENGTH);
                                ihc = il.append(ihc, (Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)16));
                                ihc = il.append(ihc.getNext(), (Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)17));
                                ihc = il.append(ihc, (Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)17));
                            }
                        }
                        ih = ih.getNext();
                    }
                    mg.setInstructionList(il);
                    mg.setMaxLocals();
                    mg.setMaxStack();
                    methods[i] = mg.getMethod();
                }
                ++i;
            }
            cg.setMethods(methods);
            return cg.getJavaClass().getBytes();
        }
        catch (Exception e) {
            System.err.println("failed to patch ClassLoader:");
            e.printStackTrace();
            return b;
        }
    }

    public static void main(String[] args) throws Exception {
        ClassLoaderPreProcessorImpl me = new ClassLoaderPreProcessorImpl();
        InputStream is = ClassLoader.getSystemClassLoader().getParent().getResourceAsStream("java/lang/ClassLoader.class");
        me.preProcess(ClassLoaderPatcher.inputStreamToByteArray(is));
        is.close();
    }
}

