/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.hook.impl;

import java.security.ProtectionDomain;
import org.codehaus.aspectwerkz.hook.ClassPreProcessor;

public class ClassPreProcessorHelper {
    private static ClassPreProcessor preProcessor;
    private static boolean preProcessorInitialized;
    private static String PRE_PROCESSOR_CLASSNAME_PROPERTY;
    private static String PRE_PROCESSOR_CLASSNAME_DEFAULT;

    public static synchronized void initializePreProcessor() {
        block5: {
            if (preProcessorInitialized) {
                return;
            }
            preProcessorInitialized = true;
            Class<?> klass = null;
            String s = System.getProperty(PRE_PROCESSOR_CLASSNAME_PROPERTY, PRE_PROCESSOR_CLASSNAME_DEFAULT);
            try {
                klass = Class.forName(s, true, ClassLoader.getSystemClassLoader());
            }
            catch (ClassNotFoundException _ex) {
                System.err.println("AspectWerkz - WARN - Pre-processor class '" + s + "' not found");
            }
            if (klass == null) break block5;
            try {
                preProcessor = (ClassPreProcessor)klass.newInstance();
                preProcessor.initialize(null);
                System.out.println("AspectWerkz - INFO - Pre-processor " + s + " loaded and initialized");
            }
            catch (Throwable throwable) {
                System.err.println("AspectWerkz - WARN - Error initializing pre-processor class " + s + ":");
                throwable.printStackTrace();
            }
        }
    }

    public static byte[] defineClass0Pre(ClassLoader caller, String name, byte[] b, int off, int len, ProtectionDomain pd) {
        if (!preProcessorInitialized) {
            ClassPreProcessorHelper.initializePreProcessor();
        }
        if (preProcessor == null) {
            byte[] obyte = new byte[len];
            System.arraycopy(b, off, obyte, 0, len);
            return obyte;
        }
        try {
            byte[] ibyte = new byte[len];
            byte[] obyte = new byte[]{};
            System.arraycopy(b, off, ibyte, 0, len);
            obyte = preProcessor.preProcess(name, ibyte, caller);
            return obyte;
        }
        catch (Throwable throwable) {
            System.err.println("AspectWerkz - WARN - Error pre-processing class " + name + " in " + Thread.currentThread());
            throwable.printStackTrace();
            byte[] obyte = new byte[len];
            System.arraycopy(b, off, obyte, 0, len);
            return obyte;
        }
    }

    static {
        PRE_PROCESSOR_CLASSNAME_PROPERTY = "aspectwerkz.classloader.preprocessor";
        PRE_PROCESSOR_CLASSNAME_DEFAULT = "org.codehaus.aspectwerkz.transform.AspectWerkzPreProcessor";
    }
}

