/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.hook.impl;

import java.io.InputStream;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.expr.ExprEditor;
import javassist.expr.MethodCall;
import org.codehaus.aspectwerkz.hook.ClassLoaderPatcher;
import org.codehaus.aspectwerkz.hook.ClassLoaderPreProcessor;

public class ClassLoaderPreProcessorImpl
implements ClassLoaderPreProcessor {
    public byte[] preProcess(byte[] b) {
        try {
            ClassPool pool = ClassPool.getDefault();
            CtClass klass = pool.get("java.lang.ClassLoader");
            ExprEditor defineClass0Pre = new ExprEditor(){

                public void edit(MethodCall m) throws CannotCompileException {
                    if ("defineClass0".equals(m.getMethodName())) {
                        int argsCount = 5;
                        try {
                            argsCount = m.getMethod().getParameterTypes().length;
                        }
                        catch (Throwable t) {
                            new RuntimeException(t.toString());
                        }
                        if (argsCount == 5) {
                            m.replace("{  byte[] newBytes = org.codehaus.aspectwerkz.hook.impl.ClassPreProcessorHelper.defineClass0Pre($0, $$);  $_ = $proceed($1, newBytes, 0, newBytes.length, $5);}");
                        } else if (argsCount == 7) {
                            m.replace("{  byte[] newBytes = org.codehaus.aspectwerkz.hook.impl.ClassPreProcessorHelper.defineClass0Pre($0, $1, $2, $3, $4, $5);  $_ = $proceed($1, newBytes, 0, newBytes.length, $5, $6, $7);}");
                        }
                    }
                }
            };
            klass.instrument(defineClass0Pre);
            return klass.toBytecode();
        }
        catch (Exception e) {
            System.err.println("failed to patch ClassLoader:");
            e.printStackTrace();
            return b;
        }
    }

    public static void main(String[] args) throws Exception {
        ClassLoaderPreProcessorImpl me = new ClassLoaderPreProcessorImpl();
        InputStream is = ClassLoader.getSystemClassLoader().getParent().getResourceAsStream("java/lang/ClassLoader.class");
        me.preProcess(ClassLoaderPatcher.inputStreamToByteArray(is));
        is.close();
    }
}

