/*
 * Decompiled with CFR 0.152.
 */
package eworld.service;

import java.util.HashMap;
import java.util.Map;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;
import org.codehaus.aspectwerkz.extension.hotswap.EWorldUtil;
import org.codehaus.aspectwerkz.joinpoint.JoinPoint;
import org.codehaus.aspectwerkz.joinpoint.MemberSignature;
import org.codehaus.aspectwerkz.joinpoint.MethodRtti;

public class ComputationStandalone {
    private static final int WEAVING_FREQUENCY = new Integer(System.getProperty("weaving.frequency"));
    private static final boolean USE_CACHE = System.getProperty("cache").equals("true");
    private static final boolean USE_TRACE = System.getProperty("trace").equals("true");
    private static final String EXPRESSION = "execution(int eworld.service.ComputationStandalone.fib(int))";
    private static final String SYSTEM_ID = "eworld/wlw/aop";
    private static final String CACHE_POINTCUT = "cache";
    private static final String TRACE_POINTCUT = "trace";
    private static final String CACHE_ADVICE = "cache";
    private static final String TRACE_ADVICE = "trace";
    static /* synthetic */ Class class$eworld$service$ComputationStandalone$CacheAspect;
    static /* synthetic */ Class class$eworld$service$ComputationStandalone$TraceAspect;

    public static int fib(int n) {
        if (n < 2) {
            System.err.println(n + ".");
            return 1;
        }
        System.err.print(n + ",");
        return ComputationStandalone.fib(n - 1) + ComputationStandalone.fib(n - 2);
    }

    private static void weave() {
        if (USE_CACHE) {
            System.err.println("weaving in cache support");
            EWorldUtil.activate((String)SYSTEM_ID, (String)(class$eworld$service$ComputationStandalone$CacheAspect == null ? (class$eworld$service$ComputationStandalone$CacheAspect = ComputationStandalone.class$("eworld.service.ComputationStandalone$CacheAspect")) : class$eworld$service$ComputationStandalone$CacheAspect).getName(), (String)"cache", (String)EXPRESSION, (String)"cache");
        }
        if (USE_TRACE) {
            System.err.println("weaving in trace support");
            EWorldUtil.activate((String)SYSTEM_ID, (String)(class$eworld$service$ComputationStandalone$TraceAspect == null ? (class$eworld$service$ComputationStandalone$TraceAspect = ComputationStandalone.class$("eworld.service.ComputationStandalone$TraceAspect")) : class$eworld$service$ComputationStandalone$TraceAspect).getName(), (String)"trace", (String)EXPRESSION, (String)"trace");
        }
    }

    private static void unWeave() {
        if (USE_CACHE) {
            System.err.println("un-weaving cache support");
            EWorldUtil.deactivate((String)SYSTEM_ID, (String)(class$eworld$service$ComputationStandalone$CacheAspect == null ? (class$eworld$service$ComputationStandalone$CacheAspect = ComputationStandalone.class$("eworld.service.ComputationStandalone$CacheAspect")) : class$eworld$service$ComputationStandalone$CacheAspect).getName(), (String)"cache", (String)"cache");
        }
        if (USE_TRACE) {
            System.err.println("un-weaving trace support");
            EWorldUtil.deactivate((String)SYSTEM_ID, (String)(class$eworld$service$ComputationStandalone$TraceAspect == null ? (class$eworld$service$ComputationStandalone$TraceAspect = ComputationStandalone.class$("eworld.service.ComputationStandalone$TraceAspect")) : class$eworld$service$ComputationStandalone$TraceAspect).getName(), (String)"trace", (String)"trace");
        }
    }

    public static void main(String[] args) {
        try {
            int iterations = new Integer(args[0]);
            long sleep = new Long(args[1]);
            int counter = 0;
            boolean isWeaved = false;
            while (true) {
                System.out.println("TraceAspect weave status = " + EWorldUtil.isWeaved((String)SYSTEM_ID, (String)(class$eworld$service$ComputationStandalone$TraceAspect == null ? ComputationStandalone.class$("eworld.service.ComputationStandalone$TraceAspect") : class$eworld$service$ComputationStandalone$TraceAspect).getName()));
                System.out.println("CacheAspect weave status = " + EWorldUtil.isWeaved((String)SYSTEM_ID, (String)(class$eworld$service$ComputationStandalone$CacheAspect == null ? ComputationStandalone.class$("eworld.service.ComputationStandalone$CacheAspect") : class$eworld$service$ComputationStandalone$CacheAspect).getName()));
                ++counter;
                Thread.sleep(sleep);
                System.err.println("fib(" + iterations + ") = " + ComputationStandalone.fib(iterations));
                if (!USE_CACHE && !USE_TRACE || (counter %= WEAVING_FREQUENCY) != 0) continue;
                if (isWeaved) {
                    ComputationStandalone.unWeave();
                    isWeaved = false;
                } else {
                    ComputationStandalone.weave();
                    isWeaved = true;
                }
                EWorldUtil.hotswap((String)"eworld.service");
            }
        }
        catch (InterruptedException e) {
            throw new WrappedRuntimeException((Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class TraceAspect {
        private int m_level = 0;

        public Object trace(JoinPoint joinPoint) throws Throwable {
            MemberSignature signature = (MemberSignature)joinPoint.getSignature();
            this.indent();
            System.out.println("--> " + signature.getDeclaringType().getName() + "::" + signature.getName());
            ++this.m_level;
            Object result = joinPoint.proceed();
            --this.m_level;
            this.indent();
            System.out.println("<-- " + signature.getDeclaringType().getName() + "::" + signature.getName());
            return result;
        }

        private void indent() {
            for (int i = 0; i < this.m_level; ++i) {
                System.out.print("  ");
            }
        }
    }

    public static class CacheAspect {
        private Map m_cache = new HashMap();

        public Object cache(JoinPoint joinPoint) throws Throwable {
            MethodRtti rtti = (MethodRtti)joinPoint.getRtti();
            Integer parameter = (Integer)rtti.getParameterValues()[0];
            Integer cachedValue = (Integer)this.m_cache.get(parameter);
            if (cachedValue == null) {
                System.err.println("not in cache");
                Object newValue = joinPoint.proceed();
                this.m_cache.put(parameter, newValue);
                return newValue;
            }
            System.err.println("using cache: " + cachedValue);
            return cachedValue;
        }
    }
}

