/*
 * Decompiled with CFR 0.152.
 */
package examples.caching;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CacheStatistics {
    private static Map s_methodInvocations = Collections.synchronizedMap(new HashMap());
    private static Map s_cacheInvocations = Collections.synchronizedMap(new HashMap());

    public static void addMethodInvocation(String methodName, Class[] parameterTypes) {
        Long hash = CacheStatistics.calculateHash(methodName, parameterTypes);
        if (!s_methodInvocations.containsKey(hash)) {
            s_methodInvocations.put(hash, new Integer(0));
        }
        int counter = (Integer)s_methodInvocations.get(hash);
        s_methodInvocations.put(hash, new Integer(++counter));
    }

    public static void addCacheInvocation(String methodName, Class[] parameterTypes) {
        Long hash = CacheStatistics.calculateHash(methodName, parameterTypes);
        if (!s_cacheInvocations.containsKey(hash)) {
            s_cacheInvocations.put(hash, new Integer(0));
        }
        int counter = (Integer)s_cacheInvocations.get(hash);
        s_cacheInvocations.put(hash, new Integer(++counter));
    }

    public static int getNrOfMethodInvocationsFor(String methodName, Class[] parameterTypes) {
        Integer number = (Integer)s_methodInvocations.get(CacheStatistics.calculateHash(methodName, parameterTypes));
        if (number != null) {
            return number;
        }
        return 0;
    }

    public static int getNrOfCacheInvocationsFor(String methodName, Class[] parameterTypes) {
        Integer number = (Integer)s_cacheInvocations.get(CacheStatistics.calculateHash(methodName, parameterTypes));
        if (number != null) {
            return number;
        }
        return 0;
    }

    private static Long calculateHash(String methodName, Class[] parameterTypes) {
        int result = 17;
        result = 37 * result + methodName.hashCode();
        int j = parameterTypes.length;
        for (int i = 0; i < j; ++i) {
            result = 37 * result + parameterTypes[i].hashCode();
        }
        return new Long(result);
    }
}

