/*
 * Decompiled with CFR 0.152.
 */
package examples.logging;

import org.codehaus.aspectwerkz.CrossCuttingInfo;
import org.codehaus.aspectwerkz.joinpoint.JoinPoint;
import org.codehaus.aspectwerkz.joinpoint.MemberSignature;

public abstract class AbstractLoggingAspect {
    private int m_level = 0;
    private CrossCuttingInfo m_info;

    public AbstractLoggingAspect(CrossCuttingInfo info) {
        this.m_info = info;
    }

    public Object logMethod(JoinPoint joinPoint) throws Throwable {
        MemberSignature signature = (MemberSignature)joinPoint.getSignature();
        this.indent();
        System.out.println("--> " + joinPoint.getTargetClass().getName() + "::" + signature.getName());
        ++this.m_level;
        Object result = joinPoint.proceed();
        --this.m_level;
        this.indent();
        System.out.println("<-- " + joinPoint.getTargetClass().getName() + "::" + signature.getName());
        return result;
    }

    public void logEntry(JoinPoint joinPoint) throws Throwable {
        MemberSignature signature = (MemberSignature)joinPoint.getSignature();
        System.out.println("ENTER: " + joinPoint.getTargetClass().getName() + "::" + signature.getName());
    }

    public void logExit(JoinPoint joinPoint) throws Throwable {
        MemberSignature signature = (MemberSignature)joinPoint.getSignature();
        System.out.println("EXIT: " + joinPoint.getTargetClass().getName() + "::" + signature.getName());
    }

    private void indent() {
        for (int i = 0; i < this.m_level; ++i) {
            System.out.print("  ");
        }
    }
}

