/*
 * Decompiled with CFR 0.152.
 */
package at.asitplus.attestation;

import at.asitplus.attestation.AttestationException;
import at.asitplus.attestation.BuildNumber;
import at.asitplus.attestation.ExtensionsKt;
import ch.veehait.devicecheck.appattest.assertion.Assertion;
import ch.veehait.devicecheck.appattest.attestation.ValidatedAttestation;
import com.google.android.attestation.AttestationApplicationId;
import com.google.android.attestation.ParsedAttestationRecord;
import com.google.common.collect.ImmutableList;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import net.swiftzer.semver.SemVer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\t\n\u000bB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016R\u0012\u0010\u0006\u001a\u00020\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u0082\u0001\u0003\f\r\u000e\u00a8\u0006\u000f"}, d2={"Lat/asitplus/attestation/AttestationResult;", "", "<init>", "()V", "toString", "", "details", "getDetails", "()Ljava/lang/String;", "Android", "IOS", "Error", "Lat/asitplus/attestation/AttestationResult$Android;", "Lat/asitplus/attestation/AttestationResult$Error;", "Lat/asitplus/attestation/AttestationResult$IOS;", "attestation-service"})
public abstract class AttestationResult {
    private AttestationResult() {
    }

    @NotNull
    public String toString() {
        return "AttestationResult::" + this.getDetails() + ")";
    }

    @NotNull
    protected abstract String getDetails();

    public /* synthetic */ AttestationResult(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u00002\u00020\u0001:\u0002\u0019\u001aB\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\nX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\r\u001a\u00020\n8TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u000e\u0010\fR\u0012\u0010\u0011\u001a\u00020\u0012X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001b\u0010\u0015\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0010\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001b"}, d2={"Lat/asitplus/attestation/AttestationResult$Android;", "Lat/asitplus/attestation/AttestationResult;", "attestationCertificateChain", "", "Ljava/security/cert/X509Certificate;", "<init>", "(Ljava/util/List;)V", "getAttestationCertificateChain", "()Ljava/util/List;", "androidDetails", "", "getAndroidDetails", "()Ljava/lang/String;", "details", "getDetails", "details$delegate", "Lkotlin/Lazy;", "attestationRecord", "Lcom/google/android/attestation/ParsedAttestationRecord;", "getAttestationRecord", "()Lcom/google/android/attestation/ParsedAttestationRecord;", "attestationCertificate", "getAttestationCertificate", "()Ljava/security/cert/X509Certificate;", "attestationCertificate$delegate", "NOOP", "Verified", "attestation-service"})
    public static abstract class Android
    extends AttestationResult {
        @NotNull
        private final List<X509Certificate> attestationCertificateChain;
        @NotNull
        private final Lazy details$delegate;
        @NotNull
        private final Lazy attestationCertificate$delegate;

        public Android(@NotNull List<? extends X509Certificate> attestationCertificateChain) {
            Intrinsics.checkNotNullParameter(attestationCertificateChain, (String)"attestationCertificateChain");
            super(null);
            this.attestationCertificateChain = attestationCertificateChain;
            this.details$delegate = LazyKt.lazy(() -> Android.details_delegate$lambda$0(this));
            this.attestationCertificate$delegate = LazyKt.lazy(() -> Android.attestationCertificate_delegate$lambda$1(this));
        }

        @NotNull
        public final List<X509Certificate> getAttestationCertificateChain() {
            return this.attestationCertificateChain;
        }

        @NotNull
        protected abstract String getAndroidDetails();

        @Override
        @NotNull
        protected String getDetails() {
            Lazy lazy = this.details$delegate;
            return (String)lazy.getValue();
        }

        @NotNull
        public abstract ParsedAttestationRecord getAttestationRecord();

        @NotNull
        public final X509Certificate getAttestationCertificate() {
            Lazy lazy = this.attestationCertificate$delegate;
            return (X509Certificate)lazy.getValue();
        }

        private static final String details_delegate$lambda$0(Android this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            return "Android::" + this$0.getAndroidDetails();
        }

        private static final X509Certificate attestationCertificate_delegate$lambda$1(Android this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            return (X509Certificate)CollectionsKt.first(this$0.attestationCertificateChain);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001b\u0010\u000b\u001a\u00020\f8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lat/asitplus/attestation/AttestationResult$Android$NOOP;", "Lat/asitplus/attestation/AttestationResult$Android;", "attestationCertificateChain", "", "", "<init>", "(Ljava/util/List;)V", "androidDetails", "", "getAndroidDetails", "()Ljava/lang/String;", "attestationRecord", "Lcom/google/android/attestation/ParsedAttestationRecord;", "getAttestationRecord", "()Lcom/google/android/attestation/ParsedAttestationRecord;", "attestationRecord$delegate", "Lkotlin/Lazy;", "attestation-service"})
        @SourceDebugExtension(value={"SMAP\nAttestationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AttestationService.kt\nat/asitplus/attestation/AttestationResult$Android$NOOP\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1018:1\n1611#2,9:1019\n1863#2:1028\n1864#2:1030\n1620#2:1031\n1611#2,9:1032\n1863#2:1041\n1864#2:1043\n1620#2:1044\n1#3:1029\n1#3:1042\n*S KotlinDebug\n*F\n+ 1 AttestationService.kt\nat/asitplus/attestation/AttestationResult$Android$NOOP\n*L\n433#1:1019,9\n433#1:1028\n433#1:1030\n433#1:1031\n437#1:1032,9\n437#1:1041\n437#1:1043\n437#1:1044\n433#1:1029\n437#1:1042\n*E\n"})
        public static final class NOOP
        extends Android {
            @NotNull
            private final String androidDetails;
            @NotNull
            private final Lazy attestationRecord$delegate;

            /*
             * WARNING - void declaration
             */
            public NOOP(@NotNull List<byte[]> attestationCertificateChain) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Intrinsics.checkNotNullParameter(attestationCertificateChain, (String)"attestationCertificateChain");
                Iterable iterable = attestationCertificateChain;
                NOOP nOOP = this;
                boolean $i$f$mapNotNull = false;
                void var4_5 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    X509Certificate it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    byte[] it = (byte[])element$iv$iv;
                    boolean bl2 = false;
                    if (ExtensionsKt.parseToCertificate(it) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                super((List)destination$iv$iv);
                this.androidDetails = "NOOP";
                this.attestationRecord$delegate = LazyKt.lazy(() -> NOOP.attestationRecord_delegate$lambda$2(attestationCertificateChain));
            }

            @Override
            @NotNull
            protected String getAndroidDetails() {
                return this.androidDetails;
            }

            @Override
            @NotNull
            public ParsedAttestationRecord getAttestationRecord() {
                Lazy lazy = this.attestationRecord$delegate;
                Object object = lazy.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
                return (ParsedAttestationRecord)object;
            }

            /*
             * WARNING - void declaration
             */
            private static final ParsedAttestationRecord attestationRecord_delegate$lambda$2(List $attestationCertificateChain) {
                void $this$mapNotNullTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)$attestationCertificateChain, (String)"$attestationCertificateChain");
                Iterable $this$mapNotNull$iv = $attestationCertificateChain;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    X509Certificate it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    byte[] it = (byte[])element$iv$iv;
                    boolean bl2 = false;
                    if (ExtensionsKt.parseToCertificate(it) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                return ParsedAttestationRecord.createParsedAttestationRecord((List)((List)destination$iv$iv));
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lat/asitplus/attestation/AttestationResult$Android$Verified;", "Lat/asitplus/attestation/AttestationResult$Android;", "attestationCertificateChain", "", "Ljava/security/cert/X509Certificate;", "<init>", "(Ljava/util/List;)V", "attestationRecord", "Lcom/google/android/attestation/ParsedAttestationRecord;", "getAttestationRecord", "()Lcom/google/android/attestation/ParsedAttestationRecord;", "androidDetails", "", "getAndroidDetails", "()Ljava/lang/String;", "attestation-service"})
        public static final class Verified
        extends Android {
            @NotNull
            private final ParsedAttestationRecord attestationRecord;
            @NotNull
            private final String androidDetails;

            /*
             * WARNING - void declaration
             */
            public Verified(@NotNull List<? extends X509Certificate> attestationCertificateChain) {
                String string;
                Intrinsics.checkNotNullParameter(attestationCertificateChain, (String)"attestationCertificateChain");
                super(attestationCertificateChain);
                ParsedAttestationRecord parsedAttestationRecord = ParsedAttestationRecord.createParsedAttestationRecord(attestationCertificateChain);
                Intrinsics.checkNotNullExpressionValue((Object)parsedAttestationRecord, (String)"createParsedAttestationRecord(...)");
                this.attestationRecord = parsedAttestationRecord;
                Verified verified = this;
                String string2 = this.getAttestationRecord().keymasterSecurityLevel().name();
                String string3 = this.getAttestationRecord().attestationSecurityLevel().name();
                String string4 = this.getAttestationRecord().attestedKey().getAlgorithm();
                byte[] byArray = this.getAttestationRecord().attestedKey().getEncoded();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
                String string5 = ExtensionsKt.encodeBase64(byArray);
                Optional optional = this.getAttestationRecord().softwareEnforced().attestationApplicationId();
                Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"attestationApplicationId(...)");
                AttestationApplicationId attestationApplicationId = (AttestationApplicationId)OptionalsKt.getOrNull((Optional)optional);
                if (attestationApplicationId != null) {
                    void app;
                    AttestationApplicationId attestationApplicationId2 = attestationApplicationId;
                    String string6 = string5;
                    String string7 = string4;
                    String string8 = string3;
                    String string9 = string2;
                    Verified verified2 = verified;
                    boolean bl = false;
                    ImmutableList immutableList = app.packageInfos();
                    Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"packageInfos(...)");
                    String string10 = ", packageInfos: " + CollectionsKt.joinToString$default((Iterable)((Iterable)immutableList), null, (CharSequence)"[", (CharSequence)"]", (int)0, null, Verified::androidDetails$lambda$1$lambda$0, (int)25, null);
                    verified = verified2;
                    string2 = string9;
                    string3 = string8;
                    string4 = string7;
                    string5 = string6;
                    string = string10;
                } else {
                    string = null;
                }
                verified.androidDetails = "Verified(keyMaster security level: " + string2 + ", attestation security level: " + string3 + ", " + string4 + " public key: " + string5 + string;
            }

            @Override
            @NotNull
            public ParsedAttestationRecord getAttestationRecord() {
                return this.attestationRecord;
            }

            @Override
            @NotNull
            protected String getAndroidDetails() {
                return this.androidDetails;
            }

            private static final CharSequence androidDetails$lambda$1$lambda$0(AttestationApplicationId.AttestationPackageInfo info) {
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                return info.packageName() + ":" + info.version();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\t\u00a8\u0006\u000e"}, d2={"Lat/asitplus/attestation/AttestationResult$Error;", "Lat/asitplus/attestation/AttestationResult;", "explanation", "", "cause", "Lat/asitplus/attestation/AttestationException;", "<init>", "(Ljava/lang/String;Lat/asitplus/attestation/AttestationException;)V", "getExplanation", "()Ljava/lang/String;", "getCause", "()Lat/asitplus/attestation/AttestationException;", "details", "getDetails", "attestation-service"})
    @SourceDebugExtension(value={"SMAP\nAttestationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AttestationService.kt\nat/asitplus/attestation/AttestationResult$Error\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1018:1\n1#2:1019\n*E\n"})
    public static final class Error
    extends AttestationResult {
        @NotNull
        private final String explanation;
        @Nullable
        private final AttestationException cause;
        @NotNull
        private final String details;

        public Error(@NotNull String explanation, @Nullable AttestationException cause) {
            String string;
            Intrinsics.checkNotNullParameter((Object)explanation, (String)"explanation");
            super(null);
            this.explanation = explanation;
            this.cause = cause;
            Error error = this;
            String string2 = this.explanation;
            AttestationException attestationException = this.cause;
            if (attestationException != null) {
                AttestationException attestationException2 = attestationException;
                String string3 = string2;
                Error error2 = error;
                boolean bl = false;
                String string4 = ", Cause: " + Reflection.getOrCreateKotlinClass(this.cause.getClass()).getQualifiedName();
                error = error2;
                string2 = string3;
                string = string4;
            } else {
                string = null;
            }
            error.details = "Error(" + string2 + string;
        }

        public /* synthetic */ Error(String string, AttestationException attestationException, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                attestationException = null;
            }
            this(string, attestationException);
        }

        @NotNull
        public final String getExplanation() {
            return this.explanation;
        }

        @Nullable
        public final AttestationException getCause() {
            return this.cause;
        }

        @Override
        @NotNull
        protected String getDetails() {
            return this.details;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\t\b&\u0018\u00002\u00020\u0001:\u0002\u0010\u0011B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\f\u001a\u00020\t8TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lat/asitplus/attestation/AttestationResult$IOS;", "Lat/asitplus/attestation/AttestationResult;", "clientData", "", "<init>", "([B)V", "getClientData", "()[B", "iosDetails", "", "getIosDetails", "()Ljava/lang/String;", "details", "getDetails", "details$delegate", "Lkotlin/Lazy;", "Verified", "NOOP", "attestation-service"})
    public static abstract class IOS
    extends AttestationResult {
        @Nullable
        private final byte[] clientData;
        @NotNull
        private final Lazy details$delegate;

        public IOS(@Nullable byte[] clientData) {
            super(null);
            this.clientData = clientData;
            this.details$delegate = LazyKt.lazy(() -> IOS.details_delegate$lambda$0(this));
        }

        @Nullable
        public final byte[] getClientData() {
            return this.clientData;
        }

        @NotNull
        public abstract String getIosDetails();

        @Override
        @NotNull
        protected String getDetails() {
            Lazy lazy = this.details$delegate;
            return (String)lazy.getValue();
        }

        private static final String details_delegate$lambda$0(IOS this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            return "iOS::" + this$0.getIosDetails();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lat/asitplus/attestation/AttestationResult$IOS$NOOP;", "Lat/asitplus/attestation/AttestationResult$IOS;", "clientData", "", "<init>", "([B)V", "iosDetails", "", "getIosDetails", "()Ljava/lang/String;", "attestation-service"})
        public static final class NOOP
        extends IOS {
            @NotNull
            private final String iosDetails;

            public NOOP(@Nullable byte[] clientData) {
                super(clientData);
                this.iosDetails = "NOOP";
            }

            @Override
            @NotNull
            public String getIosDetails() {
                return this.iosDetails;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u001a\u0010\u0004\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006j\u0002`\u0005\u0012\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0006\u00a2\u0006\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR'\u0010\u0004\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006j\u0002`\u0005\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u001f\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lat/asitplus/attestation/AttestationResult$IOS$Verified;", "Lat/asitplus/attestation/AttestationResult$IOS;", "attestation", "Lch/veehait/devicecheck/appattest/attestation/ValidatedAttestation;", "iosVersion", "Lat/asitplus/attestation/ParsedVersions;", "Lkotlin/Pair;", "Lnet/swiftzer/semver/SemVer;", "Lat/asitplus/attestation/BuildNumber;", "assertedClientData", "", "Lch/veehait/devicecheck/appattest/assertion/Assertion;", "<init>", "(Lch/veehait/devicecheck/appattest/attestation/ValidatedAttestation;Lkotlin/Pair;Lkotlin/Pair;)V", "getAttestation", "()Lch/veehait/devicecheck/appattest/attestation/ValidatedAttestation;", "getIosVersion", "()Lkotlin/Pair;", "Lkotlin/Pair;", "getAssertedClientData", "iosDetails", "", "getIosDetails", "()Ljava/lang/String;", "attestation-service"})
        public static final class Verified
        extends IOS {
            @NotNull
            private final ValidatedAttestation attestation;
            @NotNull
            private final Pair<SemVer, BuildNumber> iosVersion;
            @Nullable
            private final Pair<byte[], Assertion> assertedClientData;
            @NotNull
            private final String iosDetails;

            public Verified(@NotNull ValidatedAttestation attestation, @NotNull Pair<SemVer, BuildNumber> iosVersion, @Nullable Pair<byte[], Assertion> assertedClientData) {
                Intrinsics.checkNotNullParameter((Object)attestation, (String)"attestation");
                Intrinsics.checkNotNullParameter(iosVersion, (String)"iosVersion");
                Pair<byte[], Assertion> pair = assertedClientData;
                super((byte[])(pair != null ? (byte[])pair.getFirst() : null));
                this.attestation = attestation;
                this.iosVersion = iosVersion;
                this.assertedClientData = assertedClientData;
                String string = this.attestation.getCertificate().getPublicKey().getAlgorithm();
                byte[] byArray = this.attestation.getCertificate().getPublicKey().getEncoded();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
                this.iosDetails = "Verified(" + string + " public key: " + ExtensionsKt.encodeBase64(byArray) + ", iOS version: (semVer=" + this.iosVersion.getFirst() + ", buildNumber=[" + this.iosVersion.getSecond() + "]), app: " + this.attestation.getReceipt().getPayload().getAppId();
            }

            @NotNull
            public final ValidatedAttestation getAttestation() {
                return this.attestation;
            }

            @NotNull
            public final Pair<SemVer, BuildNumber> getIosVersion() {
                return this.iosVersion;
            }

            @Nullable
            public final Pair<byte[], Assertion> getAssertedClientData() {
                return this.assertedClientData;
            }

            @Override
            @NotNull
            public String getIosDetails() {
                return this.iosDetails;
            }
        }
    }
}

