/*
 * Decompiled with CFR 0.152.
 */
package at.asitplus.attestation;

import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Date;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlinx.datetime.ConvertersKt;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.provider.JCEECPublicKey;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.encoders.Base64;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u001a\f\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\n\u001a\u0019\u0010\u000b\u001a\n \u0002*\u0004\u0018\u00010\n0\n*\u00020\fH\u0000\u00a2\u0006\u0002\u0010\r\u001a\u0019\u0010\u000e\u001a\n \u0002*\u0004\u0018\u00010\f0\f*\u00020\nH\u0000\u00a2\u0006\u0002\u0010\u000f\u001a\f\u0010\u0010\u001a\u00020\u0011*\u00020\u0012H\u0000\u001a\u0019\u0010\u0013\u001a\n \u0002*\u0004\u0018\u00010\u00140\u0014*\u00020\u0015H\u0000\u00a2\u0006\u0002\u0010\u0016\u001a\n\u0010\u0017\u001a\u00020\n*\u00020\u0018\u001a\n\u0010\u0019\u001a\u00020\u001a*\u00020\n\u001a\u0014\u0010\u001b\u001a\u00020\n*\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u001a\n\u0010\u001e\u001a\u00020\u0012*\u00020\u0011\"\u0018\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0003\"\u0018\u0010\u0004\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0003\"\u0018\u0010\u0005\u001a\n \u0002*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u001f"}, d2={"ecKeyFactory", "Ljava/security/KeyFactory;", "kotlin.jvm.PlatformType", "Ljava/security/KeyFactory;", "rsaKeyFactory", "certificateFactory", "Ljava/security/cert/CertificateFactory;", "Ljava/security/cert/CertificateFactory;", "parseToCertificate", "Ljava/security/cert/X509Certificate;", "", "decodeBase64ToArray", "", "(Ljava/lang/String;)[B", "encodeBase64", "([B)Ljava/lang/String;", "toJavaClock", "Ljava/time/Clock;", "Lkotlinx/datetime/Clock;", "toJavaDate", "Ljava/util/Date;", "Lkotlinx/datetime/Instant;", "(Lkotlinx/datetime/Instant;)Ljava/util/Date;", "toAnsi", "Ljava/security/interfaces/ECPublicKey;", "parseToPublicKey", "Ljava/security/PublicKey;", "ensureSize", "size", "", "toKotlinClock", "attestation-service"})
public final class ExtensionsKt {
    private static final KeyFactory ecKeyFactory = KeyFactory.getInstance("EC");
    private static final KeyFactory rsaKeyFactory = KeyFactory.getInstance("RSA");
    private static final CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");

    @Nullable
    public static final X509Certificate parseToCertificate(@NotNull byte[] $this$parseToCertificate) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$parseToCertificate, (String)"<this>");
        try {
            boolean bl = false;
            Certificate certificate = certificateFactory.generateCertificate(new ByteArrayInputStream($this$parseToCertificate));
            Intrinsics.checkNotNull((Object)certificate, (String)"null cannot be cast to non-null type java.security.cert.X509Certificate");
            object = Result.constructor-impl((Object)((X509Certificate)certificate));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return (X509Certificate)(Result.isFailure-impl((Object)object) ? null : object);
    }

    public static final byte[] decodeBase64ToArray(@NotNull String $this$decodeBase64ToArray) {
        Intrinsics.checkNotNullParameter((Object)$this$decodeBase64ToArray, (String)"<this>");
        return Base64.decode((String)$this$decodeBase64ToArray);
    }

    public static final String encodeBase64(@NotNull byte[] $this$encodeBase64) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeBase64, (String)"<this>");
        return Base64.toBase64String((byte[])$this$encodeBase64);
    }

    @NotNull
    public static final Clock toJavaClock(@NotNull kotlinx.datetime.Clock $this$toJavaClock) {
        Intrinsics.checkNotNullParameter((Object)$this$toJavaClock, (String)"<this>");
        return new Clock($this$toJavaClock){
            final /* synthetic */ kotlinx.datetime.Clock $this_toJavaClock;
            {
                this.$this_toJavaClock = $receiver;
            }

            public ZoneId getZone() {
                ZoneId zoneId = Clock.systemDefaultZone().getZone();
                Intrinsics.checkNotNullExpressionValue((Object)zoneId, (String)"getZone(...)");
                return zoneId;
            }

            public Clock withZone(ZoneId zone) {
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }

            public Instant instant() {
                return ConvertersKt.toJavaInstant((kotlinx.datetime.Instant)this.$this_toJavaClock.now());
            }
        };
    }

    public static final Date toJavaDate(@NotNull kotlinx.datetime.Instant $this$toJavaDate) {
        Intrinsics.checkNotNullParameter((Object)$this$toJavaDate, (String)"<this>");
        return Date.from(ConvertersKt.toJavaInstant((kotlinx.datetime.Instant)$this$toJavaDate));
    }

    @NotNull
    public static final byte[] toAnsi(@NotNull ECPublicKey $this$toAnsi) {
        Intrinsics.checkNotNullParameter((Object)$this$toAnsi, (String)"<this>");
        ECPublicKey it = $this$toAnsi;
        boolean bl = false;
        byte[] byArray = it.getW().getAffineX().toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        byte[] xFromBc = ExtensionsKt.ensureSize(byArray, 32);
        byte[] byArray2 = it.getW().getAffineY().toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"toByteArray(...)");
        byte[] yFromBc = ExtensionsKt.ensureSize(byArray2, 32);
        byte[] byArray3 = new byte[]{4};
        return ArraysKt.plus((byte[])ArraysKt.plus((byte[])byArray3, (byte[])xFromBc), (byte[])yFromBc);
    }

    @NotNull
    public static final PublicKey parseToPublicKey(@NotNull byte[] $this$parseToPublicKey) {
        PublicKey publicKey;
        Intrinsics.checkNotNullParameter((Object)$this$parseToPublicKey, (String)"<this>");
        try {
            publicKey = ($this$parseToPublicKey.length < 1024 ? ecKeyFactory : rsaKeyFactory).generatePublic(new X509EncodedKeySpec($this$parseToPublicKey));
        }
        catch (Throwable e) {
            if (ArraysKt.first((byte[])$this$parseToPublicKey) != 4) {
                throw new InvalidKeySpecException("Encoded public key does not start with 0x04");
            }
            ECNamedCurveParameterSpec parameterSpec = ECNamedCurveTable.getParameterSpec((String)"P-256");
            ECPoint ecPoint = parameterSpec.getCurve().createPoint(new BigInteger(1, ArraysKt.sliceArray((byte[])$this$parseToPublicKey, (IntRange)RangesKt.until((int)1, (int)33))), new BigInteger(1, CollectionsKt.toByteArray((Collection)ArraysKt.takeLast((byte[])$this$parseToPublicKey, (int)32))));
            ECPublicKeySpec ecPublicKeySpec = new ECPublicKeySpec(ecPoint, (ECParameterSpec)parameterSpec);
            publicKey = (PublicKey)new JCEECPublicKey("EC", ecPublicKeySpec);
        }
        return publicKey;
    }

    private static final byte[] ensureSize(byte[] $this$ensureSize, int size) {
        byte[] byArray;
        if ($this$ensureSize.length > size) {
            byArray = ExtensionsKt.ensureSize(CollectionsKt.toByteArray((Collection)ArraysKt.drop((byte[])$this$ensureSize, (int)1)), size);
        } else if ($this$ensureSize.length < size) {
            byte[] byArray2 = new byte[]{0};
            byArray = ExtensionsKt.ensureSize(ArraysKt.plus((byte[])byArray2, (byte[])$this$ensureSize), size);
        } else {
            byArray = $this$ensureSize;
        }
        return byArray;
    }

    @NotNull
    public static final kotlinx.datetime.Clock toKotlinClock(@NotNull Clock $this$toKotlinClock) {
        Intrinsics.checkNotNullParameter((Object)$this$toKotlinClock, (String)"<this>");
        Clock it = $this$toKotlinClock;
        boolean bl = false;
        return new kotlinx.datetime.Clock(it){
            final /* synthetic */ Clock $it;
            {
                this.$it = $it;
            }

            public kotlinx.datetime.Instant now() {
                Instant instant = this.$it.instant();
                Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"instant(...)");
                return ConvertersKt.toKotlinInstant((Instant)instant);
            }
        };
    }
}

