/*
 * Decompiled with CFR 0.152.
 */
package at.asitplus.attestation;

import at.asitplus.attestation.AttestationException;
import at.asitplus.attestation.BuildNumber;
import at.asitplus.attestation.Platform;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import net.swiftzer.semver.SemVer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0002\u0019\u001aB#\b\u0007\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u001d\b\u0017\u0012\u0006\u0010\t\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\nJ\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J%\u0010\u0011\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lat/asitplus/attestation/IOSAttestationConfiguration;", "", "applications", "", "Lat/asitplus/attestation/IOSAttestationConfiguration$AppData;", "iosVersion", "Lat/asitplus/attestation/IOSAttestationConfiguration$OsVersions;", "<init>", "(Ljava/util/List;Lat/asitplus/attestation/IOSAttestationConfiguration$OsVersions;)V", "singleApp", "(Lat/asitplus/attestation/IOSAttestationConfiguration$AppData;Lat/asitplus/attestation/IOSAttestationConfiguration$OsVersions;)V", "getApplications", "()Ljava/util/List;", "getIosVersion", "()Lat/asitplus/attestation/IOSAttestationConfiguration$OsVersions;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "OsVersions", "AppData", "attestation-service"})
public final class IOSAttestationConfiguration {
    @NotNull
    private final List<AppData> applications;
    @Nullable
    private final OsVersions iosVersion;

    @JvmOverloads
    public IOSAttestationConfiguration(@NotNull List<AppData> applications, @Nullable OsVersions iosVersion) {
        Intrinsics.checkNotNullParameter(applications, (String)"applications");
        this.applications = applications;
        this.iosVersion = iosVersion;
        if (this.applications.isEmpty()) {
            throw new AttestationException.Configuration(Platform.IOS, "No apps configured", new IllegalArgumentException());
        }
    }

    public /* synthetic */ IOSAttestationConfiguration(List list, OsVersions osVersions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            osVersions = null;
        }
        this(list, osVersions);
    }

    @NotNull
    public final List<AppData> getApplications() {
        return this.applications;
    }

    @Nullable
    public final OsVersions getIosVersion() {
        return this.iosVersion;
    }

    @JvmOverloads
    public IOSAttestationConfiguration(@NotNull AppData singleApp, @Nullable OsVersions iosVersion) {
        Intrinsics.checkNotNullParameter((Object)singleApp, (String)"singleApp");
        this(CollectionsKt.listOf((Object)singleApp), iosVersion);
    }

    public /* synthetic */ IOSAttestationConfiguration(AppData appData, OsVersions osVersions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            osVersions = null;
        }
        this(appData, osVersions);
    }

    @NotNull
    public final List<AppData> component1() {
        return this.applications;
    }

    @Nullable
    public final OsVersions component2() {
        return this.iosVersion;
    }

    @NotNull
    public final IOSAttestationConfiguration copy(@NotNull List<AppData> applications, @Nullable OsVersions iosVersion) {
        Intrinsics.checkNotNullParameter(applications, (String)"applications");
        return new IOSAttestationConfiguration(applications, iosVersion);
    }

    public static /* synthetic */ IOSAttestationConfiguration copy$default(IOSAttestationConfiguration iOSAttestationConfiguration, List list, OsVersions osVersions, int n, Object object) {
        if ((n & 1) != 0) {
            list = iOSAttestationConfiguration.applications;
        }
        if ((n & 2) != 0) {
            osVersions = iOSAttestationConfiguration.iosVersion;
        }
        return iOSAttestationConfiguration.copy(list, osVersions);
    }

    @NotNull
    public String toString() {
        return "IOSAttestationConfiguration(applications=" + this.applications + ", iosVersion=" + this.iosVersion + ")";
    }

    public int hashCode() {
        int result = ((Object)this.applications).hashCode();
        result = result * 31 + (this.iosVersion == null ? 0 : this.iosVersion.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IOSAttestationConfiguration)) {
            return false;
        }
        IOSAttestationConfiguration iOSAttestationConfiguration = (IOSAttestationConfiguration)other;
        if (!Intrinsics.areEqual(this.applications, iOSAttestationConfiguration.applications)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.iosVersion, (Object)iOSAttestationConfiguration.iosVersion);
    }

    @JvmOverloads
    public IOSAttestationConfiguration(@NotNull List<AppData> applications) {
        Intrinsics.checkNotNullParameter(applications, (String)"applications");
        this(applications, null, 2, null);
    }

    @JvmOverloads
    public IOSAttestationConfiguration(@NotNull AppData singleApp) {
        Intrinsics.checkNotNullParameter((Object)singleApp, (String)"singleApp");
        this(singleApp, null, 2, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0001\u001cB/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\bH\u00c6\u0003J3\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lat/asitplus/attestation/IOSAttestationConfiguration$AppData;", "", "teamIdentifier", "", "bundleIdentifier", "sandbox", "", "iosVersionOverride", "Lat/asitplus/attestation/IOSAttestationConfiguration$OsVersions;", "<init>", "(Ljava/lang/String;Ljava/lang/String;ZLat/asitplus/attestation/IOSAttestationConfiguration$OsVersions;)V", "getTeamIdentifier", "()Ljava/lang/String;", "getBundleIdentifier", "getSandbox", "()Z", "getIosVersionOverride", "()Lat/asitplus/attestation/IOSAttestationConfiguration$OsVersions;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "Builder", "attestation-service"})
    public static final class AppData {
        @NotNull
        private final String teamIdentifier;
        @NotNull
        private final String bundleIdentifier;
        private final boolean sandbox;
        @Nullable
        private final OsVersions iosVersionOverride;

        @JvmOverloads
        public AppData(@NotNull String teamIdentifier, @NotNull String bundleIdentifier, boolean sandbox, @Nullable OsVersions iosVersionOverride) {
            Intrinsics.checkNotNullParameter((Object)teamIdentifier, (String)"teamIdentifier");
            Intrinsics.checkNotNullParameter((Object)bundleIdentifier, (String)"bundleIdentifier");
            this.teamIdentifier = teamIdentifier;
            this.bundleIdentifier = bundleIdentifier;
            this.sandbox = sandbox;
            this.iosVersionOverride = iosVersionOverride;
        }

        public /* synthetic */ AppData(String string, String string2, boolean bl, OsVersions osVersions, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = false;
            }
            if ((n & 8) != 0) {
                osVersions = null;
            }
            this(string, string2, bl, osVersions);
        }

        @NotNull
        public final String getTeamIdentifier() {
            return this.teamIdentifier;
        }

        @NotNull
        public final String getBundleIdentifier() {
            return this.bundleIdentifier;
        }

        public final boolean getSandbox() {
            return this.sandbox;
        }

        @Nullable
        public final OsVersions getIosVersionOverride() {
            return this.iosVersionOverride;
        }

        @NotNull
        public final String component1() {
            return this.teamIdentifier;
        }

        @NotNull
        public final String component2() {
            return this.bundleIdentifier;
        }

        public final boolean component3() {
            return this.sandbox;
        }

        @Nullable
        public final OsVersions component4() {
            return this.iosVersionOverride;
        }

        @NotNull
        public final AppData copy(@NotNull String teamIdentifier, @NotNull String bundleIdentifier, boolean sandbox, @Nullable OsVersions iosVersionOverride) {
            Intrinsics.checkNotNullParameter((Object)teamIdentifier, (String)"teamIdentifier");
            Intrinsics.checkNotNullParameter((Object)bundleIdentifier, (String)"bundleIdentifier");
            return new AppData(teamIdentifier, bundleIdentifier, sandbox, iosVersionOverride);
        }

        public static /* synthetic */ AppData copy$default(AppData appData, String string, String string2, boolean bl, OsVersions osVersions, int n, Object object) {
            if ((n & 1) != 0) {
                string = appData.teamIdentifier;
            }
            if ((n & 2) != 0) {
                string2 = appData.bundleIdentifier;
            }
            if ((n & 4) != 0) {
                bl = appData.sandbox;
            }
            if ((n & 8) != 0) {
                osVersions = appData.iosVersionOverride;
            }
            return appData.copy(string, string2, bl, osVersions);
        }

        @NotNull
        public String toString() {
            return "AppData(teamIdentifier=" + this.teamIdentifier + ", bundleIdentifier=" + this.bundleIdentifier + ", sandbox=" + this.sandbox + ", iosVersionOverride=" + this.iosVersionOverride + ")";
        }

        public int hashCode() {
            int result = this.teamIdentifier.hashCode();
            result = result * 31 + this.bundleIdentifier.hashCode();
            result = result * 31 + Boolean.hashCode(this.sandbox);
            result = result * 31 + (this.iosVersionOverride == null ? 0 : this.iosVersionOverride.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AppData)) {
                return false;
            }
            AppData appData = (AppData)other;
            if (!Intrinsics.areEqual((Object)this.teamIdentifier, (Object)appData.teamIdentifier)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.bundleIdentifier, (Object)appData.bundleIdentifier)) {
                return false;
            }
            if (this.sandbox != appData.sandbox) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.iosVersionOverride, (Object)appData.iosVersionOverride);
        }

        @JvmOverloads
        public AppData(@NotNull String teamIdentifier, @NotNull String bundleIdentifier, boolean sandbox) {
            Intrinsics.checkNotNullParameter((Object)teamIdentifier, (String)"teamIdentifier");
            Intrinsics.checkNotNullParameter((Object)bundleIdentifier, (String)"bundleIdentifier");
            this(teamIdentifier, bundleIdentifier, sandbox, null, 8, null);
        }

        @JvmOverloads
        public AppData(@NotNull String teamIdentifier, @NotNull String bundleIdentifier) {
            Intrinsics.checkNotNullParameter((Object)teamIdentifier, (String)"teamIdentifier");
            Intrinsics.checkNotNullParameter((Object)bundleIdentifier, (String)"bundleIdentifier");
            this(teamIdentifier, bundleIdentifier, false, null, 12, null);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\nJ\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lat/asitplus/attestation/IOSAttestationConfiguration$AppData$Builder;", "", "teamIdentifier", "", "bundleIdentifier", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "sandbox", "", "iosVersionOverride", "Lat/asitplus/attestation/IOSAttestationConfiguration$OsVersions;", "overrideIosVersion", "version", "build", "Lat/asitplus/attestation/IOSAttestationConfiguration$AppData;", "attestation-service"})
        @SourceDebugExtension(value={"SMAP\nAttestationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AttestationService.kt\nat/asitplus/attestation/IOSAttestationConfiguration$AppData$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1018:1\n1#2:1019\n*E\n"})
        public static final class Builder {
            @NotNull
            private final String teamIdentifier;
            @NotNull
            private final String bundleIdentifier;
            private boolean sandbox;
            @Nullable
            private OsVersions iosVersionOverride;

            public Builder(@NotNull String teamIdentifier, @NotNull String bundleIdentifier) {
                Intrinsics.checkNotNullParameter((Object)teamIdentifier, (String)"teamIdentifier");
                Intrinsics.checkNotNullParameter((Object)bundleIdentifier, (String)"bundleIdentifier");
                this.teamIdentifier = teamIdentifier;
                this.bundleIdentifier = bundleIdentifier;
            }

            @NotNull
            public final Builder sandbox(boolean sandbox) {
                Builder builder;
                Builder $this$sandbox_u24lambda_u240 = builder = this;
                boolean bl = false;
                $this$sandbox_u24lambda_u240.sandbox = sandbox;
                return builder;
            }

            @NotNull
            public final Builder overrideIosVersion(@NotNull OsVersions version) {
                Builder builder;
                Intrinsics.checkNotNullParameter((Object)version, (String)"version");
                Builder $this$overrideIosVersion_u24lambda_u241 = builder = this;
                boolean bl = false;
                $this$overrideIosVersion_u24lambda_u241.iosVersionOverride = version;
                return builder;
            }

            @NotNull
            public final AppData build() {
                return new AppData(this.teamIdentifier, this.bundleIdentifier, this.sandbox, this.iosVersionOverride);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0004H\u0016J\u0011\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0096\u0002J\t\u0010\u0014\u001a\u00020\u0004H\u00c2\u0003J\t\u0010\u0015\u001a\u00020\u0004H\u00c2\u0003J\u001d\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0013\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0012H\u00d6\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lat/asitplus/attestation/IOSAttestationConfiguration$OsVersions;", "", "", "semVer", "", "buildNumber", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "normalisedBuildNumber", "Lat/asitplus/attestation/BuildNumber;", "getNormalisedBuildNumber", "()Lat/asitplus/attestation/BuildNumber;", "semVerParsed", "Lnet/swiftzer/semver/SemVer;", "getSemVerParsed", "()Lnet/swiftzer/semver/SemVer;", "toString", "compareTo", "", "other", "component1", "component2", "copy", "equals", "", "hashCode", "attestation-service"})
    @SourceDebugExtension(value={"SMAP\nAttestationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AttestationService.kt\nat/asitplus/attestation/IOSAttestationConfiguration$OsVersions\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1018:1\n1#2:1019\n*E\n"})
    public static final class OsVersions
    implements Comparable<Object> {
        @NotNull
        private final String semVer;
        @NotNull
        private final String buildNumber;
        @NotNull
        private final BuildNumber normalisedBuildNumber;
        @NotNull
        private final SemVer semVerParsed;

        /*
         * WARNING - void declaration
         */
        public OsVersions(@NotNull String semVer, @NotNull String buildNumber) {
            Object $this$semVerParsed_u24lambda_u242;
            void ex;
            Object $this$normalisedBuildNumber_u24lambda_u240;
            Intrinsics.checkNotNullParameter((Object)semVer, (String)"semVer");
            Intrinsics.checkNotNullParameter((Object)buildNumber, (String)"buildNumber");
            this.semVer = semVer;
            this.buildNumber = buildNumber;
            Object object = this;
            OsVersions osVersions = this;
            try {
                $this$normalisedBuildNumber_u24lambda_u240 = object;
                boolean bl = false;
                $this$normalisedBuildNumber_u24lambda_u240 = Result.constructor-impl((Object)new BuildNumber(((OsVersions)$this$normalisedBuildNumber_u24lambda_u240).buildNumber));
            }
            catch (Throwable bl) {
                $this$normalisedBuildNumber_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = $this$normalisedBuildNumber_u24lambda_u240;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                $this$normalisedBuildNumber_u24lambda_u240 = throwable;
                boolean bl = false;
                throw new AttestationException.Configuration(Platform.IOS, "Illegal iOS build number " + this.buildNumber, (Throwable)ex);
            }
            osVersions.normalisedBuildNumber = (BuildNumber)object;
            object = this;
            osVersions = this;
            try {
                $this$semVerParsed_u24lambda_u242 = (OsVersions)object;
                boolean bl = false;
                $this$semVerParsed_u24lambda_u242 = Result.constructor-impl((Object)SemVer.Companion.parse(((OsVersions)$this$semVerParsed_u24lambda_u242).semVer));
            }
            catch (Throwable bl) {
                $this$semVerParsed_u24lambda_u242 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = $this$semVerParsed_u24lambda_u242;
            Throwable throwable2 = Result.exceptionOrNull-impl((Object)object);
            if (throwable2 != null) {
                $this$semVerParsed_u24lambda_u242 = throwable2;
                boolean bl = false;
                throw new AttestationException.Configuration(Platform.IOS, "Illegal iOS version number " + this.semVer, (Throwable)ex);
            }
            osVersions.semVerParsed = (SemVer)object;
        }

        @NotNull
        public final BuildNumber getNormalisedBuildNumber() {
            return this.normalisedBuildNumber;
        }

        @NotNull
        public final SemVer getSemVerParsed() {
            return this.semVerParsed;
        }

        @NotNull
        public String toString() {
            return "iOS Versions (semVer=" + this.semVerParsed + ", buildNumber: " + this.normalisedBuildNumber + ")";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int compareTo(@NotNull Object other) {
            int n;
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            Object object = other;
            if (object instanceof BuildNumber) {
                n = this.normalisedBuildNumber.compareTo((BuildNumber)other);
                return n;
            } else if (object instanceof SemVer) {
                n = this.semVerParsed.compareTo((SemVer)other);
                return n;
            } else {
                Object object2;
                if (!(object instanceof Pair)) throw new UnsupportedOperationException("Cannot compare OsVersions to " + Reflection.getOrCreateKotlinClass(other.getClass()).getSimpleName());
                if (!(((Pair)other).getFirst() instanceof SemVer)) {
                    Object object3 = ((Pair)other).getFirst();
                    if (!(object3 == null ? true : object3 instanceof SemVer)) throw new UnsupportedOperationException("Cannot compare OsVersions to " + Reflection.getOrCreateKotlinClass(other.getClass()).getSimpleName());
                }
                if (!(((Pair)other).getSecond() instanceof BuildNumber)) {
                    Object object4 = ((Pair)other).getSecond();
                    if (!(object4 == null ? true : object4 instanceof BuildNumber)) throw new UnsupportedOperationException("Cannot compare OsVersions to " + Reflection.getOrCreateKotlinClass(other.getClass()).getSimpleName());
                }
                if ((object2 = ((Pair)other).getFirst()) != null) {
                    Object it = object2;
                    return this.semVerParsed.compareTo((SemVer)it);
                }
                Object object5 = ((Pair)other).getSecond();
                if (object5 == null) throw new UnsupportedOperationException("No Parsed iOS Version present.");
                Object it = object5;
                boolean bl = false;
                n = this.normalisedBuildNumber.compareTo((BuildNumber)it);
            }
            return n;
        }

        private final String component1() {
            return this.semVer;
        }

        private final String component2() {
            return this.buildNumber;
        }

        @NotNull
        public final OsVersions copy(@NotNull String semVer, @NotNull String buildNumber) {
            Intrinsics.checkNotNullParameter((Object)semVer, (String)"semVer");
            Intrinsics.checkNotNullParameter((Object)buildNumber, (String)"buildNumber");
            return new OsVersions(semVer, buildNumber);
        }

        public static /* synthetic */ OsVersions copy$default(OsVersions osVersions, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = osVersions.semVer;
            }
            if ((n & 2) != 0) {
                string2 = osVersions.buildNumber;
            }
            return osVersions.copy(string, string2);
        }

        public int hashCode() {
            int result = this.semVer.hashCode();
            result = result * 31 + this.buildNumber.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OsVersions)) {
                return false;
            }
            OsVersions osVersions = (OsVersions)other;
            if (!Intrinsics.areEqual((Object)this.semVer, (Object)osVersions.semVer)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.buildNumber, (Object)osVersions.buildNumber);
        }
    }
}

