/*
 * Decompiled with CFR 0.152.
 */
package at.asitplus.io;

import com.ionspin.kotlin.bignum.NarrowingOperations;
import com.ionspin.kotlin.bignum.integer.BigInteger;
import com.ionspin.kotlin.bignum.integer.Sign;
import io.matthewnelson.encoding.core.EncodingException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007J\u001e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J\u001e\u0010\f\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007\u00a8\u0006\r"}, d2={"Lat/asitplus/io/BaseN;", "", "<init>", "()V", "decode", "", "alphabet", "", "base", "Lcom/ionspin/kotlin/bignum/integer/BigInteger;", "input", "encode", "decodeToBigInteger", "multibase"})
public final class BaseN {
    @NotNull
    public static final BaseN INSTANCE = new BaseN();

    private BaseN() {
    }

    @NotNull
    public final byte[] decode(@NotNull String alphabet, @NotNull BigInteger base, @NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)alphabet, (String)"alphabet");
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        byte[] bytes = this.decodeToBigInteger(alphabet, base, input).toByteArray();
        boolean stripSignByte = bytes.length > 1 && Intrinsics.compare((int)bytes[0], (int)0) == 0 && bytes[1] < 0;
        int leadingZeros = 0;
        int i = 0;
        while (input.charAt(i) == alphabet.charAt(0)) {
            ++leadingZeros;
            ++i;
        }
        byte[] tmp = new byte[bytes.length - (stripSignByte ? 1 : 0) + leadingZeros];
        int n = stripSignByte ? 1 : 0;
        int n2 = leadingZeros;
        int n3 = tmp.length - leadingZeros;
        ArraysKt.copyInto((byte[])bytes, (byte[])tmp, (int)n2, (int)n, (int)n3);
        return tmp;
    }

    @NotNull
    public final String encode(@NotNull String alphabet, @NotNull BigInteger base, @NotNull byte[] input) {
        Intrinsics.checkNotNullParameter((Object)alphabet, (String)"alphabet");
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        BigInteger bi = BigInteger.Companion.fromByteArray(input, Sign.POSITIVE);
        StringBuilder sb = new StringBuilder();
        while (bi.compareTo((Object)base) >= 0) {
            BigInteger mod = bi.mod(base);
            sb.insert(0, alphabet.charAt(NarrowingOperations.DefaultImpls.intValue$default((NarrowingOperations)((NarrowingOperations)mod), (boolean)false, (int)1, null)));
            bi = bi.subtract(mod).divide(base);
        }
        sb.insert(0, alphabet.charAt(NarrowingOperations.DefaultImpls.intValue$default((NarrowingOperations)((NarrowingOperations)bi), (boolean)false, (int)1, null)));
        for (byte b : input) {
            if (Intrinsics.compare((int)b, (int)0) != 0) break;
            sb.insert(0, alphabet.charAt(0));
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final BigInteger decodeToBigInteger(@NotNull String alphabet, @NotNull BigInteger base, @NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)alphabet, (String)"alphabet");
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        BigInteger bi = BigInteger.Companion.getZERO();
        for (int i = input.length() - 1; -1 < i; --i) {
            int alphaIndex = StringsKt.indexOf$default((CharSequence)alphabet, (char)input.charAt(i), (int)0, (boolean)false, (int)6, null);
            if (alphaIndex == -1) {
                throw new EncodingException("Illegal character " + input.charAt(i) + " at " + i);
            }
            bi = bi.add(BigInteger.Companion.fromLong((long)alphaIndex).multiply(base.pow(input.length() - 1 - i)));
        }
        return bi;
    }
}

