package at.asitplus.signum.indispensable.asn1

import kotlin.js.JsName

public object KnownOIDs {
  /**
   * `1.2.840.10065.2.2`: ASTM 31.20
   */
  @JsName("_1_2_840_10065_2_2")
  public val `1_2_840_10065_2_2`: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10065 2 2"
      )

  /**
   * `1.2.840.113549.1.9.16.3.3`: S/MIME Algorithms. Obsolete
   */
  @JsName("_3desWrap")
  public val `3desWrap`: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 3 3"
      )

  /**
   * `1.2.40.0.17.1.22`: A-Trust CA Root
   */
  public val A_Trust_EV_policy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 40 0 17 1 22"
      )

  /**
   * `1.3.6.1.4.1.34697.2.1`: AffirmTrust Commercial
   */
  public val AffirmTrust_EV_policy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 34697 2 1"
      )

  /**
   * `1.3.6.1.4.1.34697.2.2`: AffirmTrust Networking
   */
  public val AffirmTrust_EV_policy_1_3_6_1_4_1_34697_2_2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 34697 2 2"
      )

  /**
   * `1.3.6.1.4.1.34697.2.3`: AffirmTrust Premium
   */
  public val AffirmTrust_EV_policy_1_3_6_1_4_1_34697_2_3: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 34697 2 3"
      )

  /**
   * `1.3.6.1.4.1.34697.2.4`: AffirmTrust Premium ECC
   */
  public val AffirmTrust_EV_policy_1_3_6_1_4_1_34697_2_4: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 34697 2 4"
      )

  /**
   * `2.23.42.8.34`: SET brand
   */
  public val AmericanExpress: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 8 34"
      )

  /**
   * `2.23.42.9.14`: SET vendor
   */
  public val Antares: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 9 14"
      )

  /**
   * `2.23.42.9.7`: SET vendor
   */
  public val BankGate: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 9 7"
      )

  /**
   * `2.23.42.9.19`: SET vendor
   */
  public val BlueMoney: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 9 19"
      )

  /**
   * `1.3.6.1.4.1.17326.10.14.2.1.2`: Camerfirma CA Root
   */
  public val Camerfirma_EV_policy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 17326 10 14 2 1 2"
      )

  /**
   * `1.3.6.1.4.1.17326.10.8.12.1.2`: Camerfirma CA Root
   */
  public val Camerfirma_EV_policy_1_3_6_1_4_1_17326_10_8_12_1_2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 17326 10 8 12 1 2"
      )

  /**
   * `1.3.6.1.4.1.22234.2.5.2.3.1`: CertPlus Class 2 Primary CA (formerly Keynectis)
   */
  public val CertPlus_EV_policy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 22234 2 5 2 3 1"
      )

  /**
   * `2.23.42.9.11`: SET vendor
   */
  public val Certicom: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 9 11"
      )

  /**
   * `1.3.6.1.4.1.6449.1.2.1.5.1`: COMODO Certification Authority
   */
  public val Comodo_EV_policy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 6449 1 2 1 5 1"
      )

  /**
   * `2.23.42.9.9`: SET vendor
   */
  public val CompuSource: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 9 9"
      )

  /**
   * `2.23.42.9.2`: SET vendor
   */
  public val CyberCash: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 9 2"
      )

  /**
   * `1.3.6.1.4.1.6334.1.100.1`: Cybertrust Global Root (now Verizon Business)
   */
  public val Cybertrust_EV_policy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 6334 1 100 1"
      )

  /**
   * `1.3.6.1.4.1.4788.2.202.1`: D-TRUST Root Class 3 CA 2 EV 2009
   */
  public val D_TRUST_EV_policy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 4788 2 202 1"
      )

  /**
   * `2.16.840.1.114412.2.1`: DigiCert High Assurance EV Root CA
   */
  public val DigiCert_EV_policy: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 114412 2 1"
      )

  /**
   * `2.16.528.1.1001.1.1.1.12.6.1.1.1`: DigiNotar Root CA
   */
  public val DigiNotar_EV_policy: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 528 1 1001 1 1 1 12 6 1 1 1"
      )

  /**
   * `2.23.42.8.30`: SET brand
   */
  public val Diners: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 8 30"
      )

  /**
   * `2.23.42.9.15`: SET vendor
   */
  public val ECC: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 9 15"
      )

  /**
   * `1.3.14.7.2.1.1`: Unsure about this OID
   */
  public val ElGamal: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 14 7 2 1 1"
      )

  /**
   * `2.16.840.1.113730.1.10`: Netscape certificate extension
   */
  public val EntityLogo: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113730 1 10"
      )

  /**
   * `2.23.42.9.23`: SET vendor
   */
  public val Entrust: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 9 23"
      )

  /**
   * `2.16.840.1.114028.10.1.2`: Entrust Root Certification Authority
   */
  public val Entrust_EV_policy: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 114028 10 1 2"
      )

  /**
   * `2.23.42.9.21`: SET vendor
   */
  public val Fujitsu: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 9 21"
      )

  /**
   * `2.23.42.9.8`: SET vendor
   */
  public val GTE: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 9 8"
      )

  /**
   * `2.23.42.9.38`: SET vendor
   */
  public val Gemplus: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 9 38"
      )

  /**
   * `1.3.6.1.4.1.14370.1.6`: GeoTrust Primary Certification Authority (formerly Equifax)
   */
  public val GeoTrust_EV_policy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 14370 1 6"
      )

  /**
   * `1.3.6.1.4.1.4146.1.1`: GlobalSign
   */
  public val GlobalSign_EV_policy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 4146 1 1"
      )

  /**
   * `1.3.6.1.4.1.4146`: Globalsign
   */
  public val Globalsign: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 4146"
      )

  /**
   * `2.23.42.9.0`: SET vendor
   */
  public val GlobeSet: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 9 0"
      )

  /**
   * `2.16.840.1.114413.1.7.23.3`: GoDaddy Class 2 Certification Authority (formerly ValiCert)
   */
  public val GoDaddy_EV_policy: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 114413 1 7 23 3"
      )

  /**
   * `2.23.42.9.10`: SET vendor
   */
  public val Griffin: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 9 10"
      )

  /**
   * `2.23.42.9.32`: SET vendor
   */
  public val Hitachi: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 9 32"
      )

  /**
   * `2.16.840.1.113730.1.9`: Netscape certificate extension
   */
  public val HomePage_url: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113730 1 9"
      )

  /**
   * `2.23.42.8.1`: SET brand
   */
  public val IATA_ATA: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 8 1"
      )

  /**
   * `2.23.42.9.1`: SET vendor
   */
  public val IBM: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 9 1"
      )

  /**
   * `1.3.6.1.4.1.2786.1.1.1`: ICE-TEL CA policy
   */
  public val ICE_TEL_Italian_policyIdentifier: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 2786 1 1 1"
      )

  /**
   * `1.3.6.1.4.1.2712.10`: ICE-TEL CA
   */
  public val ICE_TEL_policyIdentifier: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 2712 10"
      )

  /**
   * `2.23.42.9.25`: SET vendor
   */
  public val III: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 9 25"
      )

  /**
   * `1.2.840.114021.1.6.1`: Identrus
   */
  public val Identrus_unknown_policyIdentifier: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 114021 1 6 1"
      )

  /**
   * `2.23.42.9.28`: SET vendor
   */
  public val Intertrader: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 9 28"
      )

  /**
   * `1.3.6.1.4.1.14777.6.1.1`: Certificado de Servidor Seguro SSL EV
   */
  public val Izenpe_EV_policy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 14777 6 1 1"
      )

  /**
   * `1.3.6.1.4.1.14777.6.1.2`: Certificado de Sede Electronica EV
   */
  public val Izenpe_EV_policy_1_3_6_1_4_1_14777_6_1_2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 14777 6 1 2"
      )

  /**
   * `2.23.42.10.392`: SET national
   */
  public val Japan: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 10 392"
      )

  /**
   * `2.23.42.9.20`: SET vendor
   */
  public val Lacerte: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 9 20"
      )

  /**
   * `2.23.42.9.27`: SET vendor
   */
  public val Lexem: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 9 27"
      )

  /**
   * `2.23.42.9.16`: SET vendor
   */
  public val Maithean: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 9 16"
      )

  /**
   * `2.23.42.8.5`: SET brand
   */
  public val MasterCard: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 8 5"
      )

  /**
   * `2.23.42.9.33`: SET vendor
   */
  public val Microsoft: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 9 33"
      )

  /**
   * `2.23.42.9.35`: SET vendor
   */
  public val Mitsubishi: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 9 35"
      )

  /**
   * `2.23.42.9.30`: SET vendor
   */
  public val NABLE: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 9 30"
      )

  /**
   * `2.23.42.9.36`: SET vendor
   */
  public val NCR: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 9 36"
      )

  /**
   * `2.23.42.9.34`: SET vendor
   */
  public val NEC: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 9 34"
      )

  /**
   * `2.16.840.1.101.3.2.1`: NIST policies
   */
  public val NIST_policyIdentifier: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 2 1"
      )

  /**
   * `2.23.42.9.17`: SET vendor
   */
  public val Netscape: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 9 17"
      )

  /**
   * `1.3.6.1.4.1.782.1.2.1.8.1`: Network Solutions Certificate Authority
   */
  public val Network_Solutions_EV_policy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 782 1 2 1 8 1"
      )

  /**
   * `1.3.6.1.4.1.16334.509.1.1`: Northrop Grumman extended key usage
   */
  public val Northrop_Grumman_extKeyUsage: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 16334 509 1 1"
      )

  /**
   * `2.23.42.8.6011`: SET brand
   */
  public val Novus: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 8 6011"
      )

  /**
   * `2.23.42.9.12`: SET vendor
   */
  public val OSS: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 9 12"
      )

  /**
   * `2.23.42.9.26`: SET vendor
   */
  public val OpenMarket: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 9 26"
      )

  /**
   * `2.23.42.9.29`: SET vendor
   */
  public val Persimmon: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 9 29"
      )

  /**
   * `1.3.6.1.4.1.8024.0.2.100.1.2`: QuoVadis Root CA 2
   */
  public val QuoVadis_EV_policy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 8024 0 2 100 1 2"
      )

  /**
   * `2.23.42.9.4`: SET vendor
   */
  public val RSADSI: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 9 4"
      )

  /**
   * `1.2.752.34.1.2`: SEIS Project certificate policies
   */
  public val SEIS_GAK_policyIdentifier: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 752 34 1 2"
      )

  /**
   * `1.2.752.34.3`: SEIS Project
   */
  public val SEIS_at: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 752 34 3"
      )

  /**
   * `1.2.752.34.3.1`: SEIS Project attribute
   */
  public val SEIS_at_personalIdentifier: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 752 34 3 1"
      )

  /**
   * `1.2.752.34.1.1`: SEIS Project certificate policies
   */
  public val SEIS_high_assurance_policyIdentifier: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 752 34 1 1"
      )

  /**
   * `1.2.752.34.2`: SEIS Project
   */
  public val SEIS_pe: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 752 34 2"
      )

  /**
   * `1.3.6.1.5.5.7.8.6`: PKIX other name
   */
  public val SIM: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 8 6"
      )

  /**
   * `1.2.392.200091.100.721.1`: Security Communication RootCA1
   */
  public val Security_Communication_SECOM_EV_policy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 392 200091 100 721 1"
      )

  /**
   * `2.16.840.1.114414.1.7.23.3`: Starfield Class 2 Certification Authority
   */
  public val Starfield_EV_policy: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 114414 1 7 23 3"
      )

  /**
   * `1.3.6.1.4.1.23223.1.1.1`: StartCom Certification Authority
   */
  public val StartCom_EV_policy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 23223 1 1 1"
      )

  /**
   * `2.16.756.1.89.1.2.1.1`: SwissSign Gold CA - G2
   */
  public val SwissSign_EV_policy: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 756 1 89 1 2 1 1"
      )

  /**
   * `1.3.6.1.4.1.3029.54.11940.54`: cryptlib TSA policy
   */
  public val TSA_policy_Anything_that_arrives_we_sign: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 3029 54 11940 54"
      )

  /**
   * `1.3.6.1.4.1.40869.1.1.22.3`: TWCA Root Certification Authority
   */
  public val TWCA_EV_policy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 40869 1 1 22 3"
      )

  /**
   * `1.3.6.1.4.1.7879.13.24.1`: T-TeleSec GlobalRoot Class 3
   */
  public val T_TeleSec_EV_policy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 7879 13 24 1"
      )

  /**
   * `0.2.262.1.10`: Deutsche Telekom
   */
  public val Telesec: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10"
      )

  /**
   * `0.2.262.1.10.12.2`: Telesec cert/CRL extension
   */
  public val Telesec_policyIdentifier: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 12 2"
      )

  /**
   * `1.3.36.8.1.1`: Teletrust policy
   */
  public val Teletrust_SigGConform_policyIdentifier: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 1 1"
      )

  /**
   * `2.23.42.9.13`: SET vendor
   */
  public val TenthMountain: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 9 13"
      )

  /**
   * `2.23.42.9.3`: SET vendor
   */
  public val Terisa: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 9 3"
      )

  /**
   * `2.16.840.1.113733.1.7.48.1`: Thawte Premium Server CA
   */
  public val Thawte_EV_policy: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113733 1 7 48 1"
      )

  /**
   * `2.23.42.9.6`: SET vendor
   */
  public val TrinTech: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 9 6"
      )

  /**
   * `2.16.840.1.114404.1.1.2.4.1`: TrustWave CA, formerly SecureTrust, before that XRamp
   */
  public val TrustWave_EV_policy: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 114404 1 1 2 4 1"
      )

  /**
   * `1.3.6.1.4.1.2428.10.1.1`: UNINETT PCA
   */
  public val UNINETT_policyIdentifier: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 2428 10 1 1"
      )

  /**
   * `2.16.840.1.113733.1.6.13`: Verisign extension
   */
  public val Unknown_Verisign_VPN_extension: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113733 1 6 13"
      )

  /**
   * `2.16.840.1.113730.1.11`: Netscape certificate extension
   */
  public val UserPicture: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113730 1 11"
      )

  /**
   * `2.23.42.9.24`: SET vendor
   */
  public val VIAnet: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 9 24"
      )

  /**
   * `2.23.42.8.4`: SET brand
   */
  public val VISA: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 8 4"
      )

  /**
   * `2.23.42.9.5`: SET vendor
   */
  public val VeriFone: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 9 5"
      )

  /**
   * `2.16.840.1.113733.1.7.23.6`: VeriSign Class 3 Public Primary Certification Authority
   */
  public val VeriSign_EV_policy: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113733 1 7 23 6"
      )

  /**
   * `2.23.42.9.18`: SET vendor
   */
  public val Verisign: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 9 18"
      )

  /**
   * `2.5.4.61`: X.520 DN component
   */
  public val aACertificate: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 61"
      )

  /**
   * `2.5.29.63`: X.509 extension
   */
  public val aAissuingDistributionPoint: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 63"
      )

  /**
   * `1.3.6.1.5.5.7.1.6`: PKIX private extension
   */
  public val acAaControls: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 1 6"
      )

  /**
   * `1.3.6.1.5.5.7.1.4`: PKIX private extension
   */
  public val acAuditIdentity: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 1 4"
      )

  /**
   * `1.3.6.1.5.5.7.1.15`: PKIX private extension
   */
  public val acPolicies: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 1 15"
      )

  /**
   * `1.3.6.1.5.5.7.1.10`: PKIX private extension
   */
  public val acProxying: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 1 10"
      )

  /**
   * `1.3.6.1.5.5.7.1.5`: PKIX private extension
   */
  public val acTargeting: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 1 5"
      )

  /**
   * `2.5.29.52`: X.509 extension
   */
  public val acceptableCertPolicies: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 52"
      )

  /**
   * `2.5.29.57`: X.509 extension
   */
  public val acceptablePrivilegePolicies: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 57"
      )

  /**
   * `1.3.6.1.5.5.7.10.2`: PKIX attribute certificate extension
   */
  public val accessIdentity: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 10 2"
      )

  /**
   * `2.23.42.2.11`: SET field
   */
  public val accountNumber: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 2 11"
      )

  /**
   * `1.3.6.1.5.5.7.1.31`: PKIX private extension
   */
  public val acmeIdentifier: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 1 31"
      )

  /**
   * `1.3.6.1.5.5.7.8.10`: PKIX other name
   */
  public val acpNodeName: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 8 10"
      )

  /**
   * `1.3.6.1.5.5.7.2.4`: PKIX policy qualifier
   */
  public val acps: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 2 4"
      )

  /**
   * `1.2.840.113583.1.2`: Adobe Acrobat CPS
   */
  public val acrobatCPS: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113583 1 2"
      )

  /**
   * `1.2.840.113583.1.9`: Adobe Acrobat X.509 extension
   */
  public val acrobatExtension: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113583 1 9"
      )

  /**
   * `1.2.840.113583.1.1`: Adobe Acrobat security
   */
  public val acrobatSecurity: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113583 1 1"
      )

  /**
   * `1.2.840.113583.1.7`: Adobe Acrobat ubiquity
   */
  public val acrobatUbiquity: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113583 1 7"
      )

  /**
   * `0.2.262.1.10.9`: Telesec
   */
  public val action: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 9"
      )

  /**
   * `1.3.6.1.5.5.7.2.5`: PKIX policy qualifier
   */
  public val acunotice: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 2 5"
      )

  /**
   * `1.2.840.113549.1.9.16.9.3`: S/MIME Signature Type Identifier
   */
  public val additionalAttributesSig: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 9 3"
      )

  /**
   * `1.3.36.8.3.15`: Teletrust attribute
   */
  public val additionalInformation: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 3 15"
      )

  /**
   * `2.23.42.3.0.1`: SET cert attribute
   */
  public val additionalPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 3 0 1"
      )

  /**
   * `2.23.42.2.8`: SET field
   */
  public val address: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 2 8"
      )

  /**
   * `1.3.36.8.3.3`: Teletrust attribute
   */
  public val admission: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 3 3"
      )

  /**
   * `1.2.840.113583.1`: Adobe Acrobat
   */
  public val adobeAcrobat: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113583 1"
      )

  /**
   * `1.2.840.113628.114.1.7`: Adobe
   */
  public val adobePKCS7: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113628 114 1 7"
      )

  /**
   * `2.16.840.1.101.3.4.1`: NIST Algorithm
   */
  public val aes: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 4 1"
      )

  /**
   * `2.16.840.1.101.3.4.1.2`: NIST Algorithm
   */
  public val aes128_CBC: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 4 1 2"
      )

  /**
   * `2.16.840.1.101.3.4.1.7`: NIST Algorithm
   */
  public val aes128_CCM: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 4 1 7"
      )

  /**
   * `2.16.840.1.101.3.4.1.4`: NIST Algorithm
   */
  public val aes128_CFB: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 4 1 4"
      )

  /**
   * `2.16.840.1.101.3.4.1.1`: NIST Algorithm
   */
  public val aes128_ECB: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 4 1 1"
      )

  /**
   * `2.16.840.1.101.3.4.1.6`: NIST Algorithm
   */
  public val aes128_GCM: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 4 1 6"
      )

  /**
   * `2.16.840.1.101.3.4.1.9`: NIST Algorithm
   */
  public val aes128_GMAC: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 4 1 9"
      )

  /**
   * `2.16.840.1.101.3.4.1.3`: NIST Algorithm
   */
  public val aes128_OFB: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 4 1 3"
      )

  /**
   * `2.16.840.1.101.3.4.1.5`: NIST Algorithm
   */
  public val aes128_wrap: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 4 1 5"
      )

  /**
   * `2.16.840.1.101.3.4.1.8`: NIST Algorithm
   */
  public val aes128_wrap_pad: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 4 1 8"
      )

  /**
   * `2.16.840.1.101.3.4.1.22`: NIST Algorithm
   */
  public val aes192_CBC: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 4 1 22"
      )

  /**
   * `2.16.840.1.101.3.4.1.27`: NIST Algorithm
   */
  public val aes192_CCM: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 4 1 27"
      )

  /**
   * `2.16.840.1.101.3.4.1.24`: NIST Algorithm
   */
  public val aes192_CFB: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 4 1 24"
      )

  /**
   * `2.16.840.1.101.3.4.1.21`: NIST Algorithm
   */
  public val aes192_ECB: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 4 1 21"
      )

  /**
   * `2.16.840.1.101.3.4.1.26`: NIST Algorithm
   */
  public val aes192_GCM: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 4 1 26"
      )

  /**
   * `2.16.840.1.101.3.4.1.29`: NIST Algorithm
   */
  public val aes192_GMAC: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 4 1 29"
      )

  /**
   * `2.16.840.1.101.3.4.1.23`: NIST Algorithm
   */
  public val aes192_OFB: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 4 1 23"
      )

  /**
   * `2.16.840.1.101.3.4.1.25`: NIST Algorithm
   */
  public val aes192_wrap: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 4 1 25"
      )

  /**
   * `2.16.840.1.101.3.4.1.28`: NIST Algorithm
   */
  public val aes192_wrap_pad: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 4 1 28"
      )

  /**
   * `2.16.840.1.101.3.4.1.42`: NIST Algorithm
   */
  public val aes256_CBC: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 4 1 42"
      )

  /**
   * `2.16.840.1.101.3.4.1.47`: NIST Algorithm
   */
  public val aes256_CCM: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 4 1 47"
      )

  /**
   * `2.16.840.1.101.3.4.1.44`: NIST Algorithm
   */
  public val aes256_CFB: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 4 1 44"
      )

  /**
   * `2.16.840.1.101.3.4.1.41`: NIST Algorithm
   */
  public val aes256_ECB: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 4 1 41"
      )

  /**
   * `2.16.840.1.101.3.4.1.46`: NIST Algorithm
   */
  public val aes256_GCM: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 4 1 46"
      )

  /**
   * `2.16.840.1.101.3.4.1.49`: NIST Algorithm
   */
  public val aes256_GMAC: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 4 1 49"
      )

  /**
   * `2.16.840.1.101.3.4.1.43`: NIST Algorithm
   */
  public val aes256_OFB: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 4 1 43"
      )

  /**
   * `2.16.840.1.101.3.4.1.45`: NIST Algorithm
   */
  public val aes256_wrap: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 4 1 45"
      )

  /**
   * `2.16.840.1.101.3.4.1.48`: NIST Algorithm
   */
  public val aes256_wrap_pad: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 4 1 48"
      )

  /**
   * `1.2.840.113549.1.9.16.3.22`: S/MIME Algorithms
   */
  public val aesSIV_CMAC_256: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 3 22"
      )

  /**
   * `1.2.840.113549.1.9.16.3.23`: S/MIME Algorithms
   */
  public val aesSIV_CMAC_384: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 3 23"
      )

  /**
   * `1.2.840.113549.1.9.16.3.24`: S/MIME Algorithms
   */
  public val aesSIV_CMAC_512: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 3 24"
      )

  /**
   * `1.2.840.113549.1.9.16.3.25`: S/MIME Algorithms
   */
  public val aesSIV_CMAC_wrap256: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 3 25"
      )

  /**
   * `1.2.840.113549.1.9.16.3.26`: S/MIME Algorithms
   */
  public val aesSIV_CMAC_wrap384: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 3 26"
      )

  /**
   * `1.2.840.113549.1.9.16.3.27`: S/MIME Algorithms
   */
  public val aesSIV_CMAC_wrap512: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 3 27"
      )

  /**
   * `2.16.840.1.101.2.1.5.47`: SDN.700 INFOSEC attributes
   */
  public val alExemptedAddressProcessor: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 5 47"
      )

  /**
   * `1.2.840.10040.4`: ANSI X9.57
   */
  public val algorithm: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10040 4"
      )

  /**
   * `1.3.36.3`: Teletrust algorithm
   */
  public val algorithm_1_3_36_3: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3"
      )

  /**
   * `2.23.42.4`: SET
   */
  public val algorithm_2_23_42_4: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 4"
      )

  /**
   * `0.2.262.1.10.2.0`: Telesec module
   */
  public val algorithms: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 2 0"
      )

  /**
   * `2.16.840.1.101.2.1.5.49`: SDN.700 INFOSEC attributes (obsolete)
   */
  public val algorithmsSupported: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 5 49"
      )

  /**
   * `1.3.6.1.5.5.7.6`: PKIX
   */
  public val algorithms_1_3_6_1_5_5_7_6: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 6"
      )

  /**
   * `2.5.6.1`: X.520 objectClass
   */
  public val alias: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 6 1"
      )

  /**
   * `2.5.4.1`: X.520 DN component
   */
  public val aliasedEntryName: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 1"
      )

  /**
   * `2.16.840.1.101.2.1.5.14`: SDN.700 INFOSEC attributes
   */
  public val alid: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 5 14"
      )

  /**
   * `2.5.29.67`: X.509 extension
   */
  public val allowedAttAss: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 67"
      )

  /**
   * `1.3.6.1.5.5.7.5.1.7`: PKIX CRMF registration control
   */
  public val altCertTemplate: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 5 1 7"
      )

  /**
   * `2.23.42.2.10`: SET field
   */
  public val amount: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 2 10"
      )

  /**
   * `1.2.840.113549.1.9.16.1.46`: S/MIME Content Types
   */
  public val animaCBORVoucher: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 1 46"
      )

  /**
   * `1.2.840.113549.1.9.16.1.40`: S/MIME Content Types
   */
  public val animaJSONVoucher: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 1 40"
      )

  /**
   * `0.2.262.1.10.7.16`: Telesec attribute
   */
  public val anonymizedPublicKeyDirectory: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 7 16"
      )

  /**
   * `1.3.6.1.4.1.311.10.12.1`: Microsoft attribute
   */
  public val anyApplicationPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 10 12 1"
      )

  /**
   * `1.2.840.113549.1.9.16.1.0`: S/MIME Content Types
   */
  public val anyContentType: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 1 0"
      )

  /**
   * `2.5.29.37.0`: X.509 extended key usage
   */
  public val anyExtendedKeyUsage: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 37 0"
      )

  /**
   * `2.5.29.32.0`: X.509 certificate policy
   */
  public val anyPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 32 0"
      )

  /**
   * `1.3.36.6`: Teletrust API
   */
  public val api: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 6"
      )

  /**
   * `1.2.840.113635.100.5.3`: Apple
   */
  public val appleADCCertificatePolicyID: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 5 3"
      )

  /**
   * `1.2.840.113635.100.2.2`: Apple security algorithm
   */
  public val appleASC: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 2 2"
      )

  /**
   * `1.2.840.113635.100.1.6`: Apple trust policy
   */
  public val appleCRLPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 1 6"
      )

  /**
   * `1.2.840.113635.100.1.5`: Apple trust policy
   */
  public val appleCSRGenPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 1 5"
      )

  /**
   * `1.2.840.113635.100.6.1.3`: Apple certificate extension
   */
  public val appleCertificateExtensionADCAppleSigning: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 6 1 3"
      )

  /**
   * `1.2.840.113635.100.6.1.2`: Apple certificate extension
   */
  public val appleCertificateExtensionADCDeveloperSigning: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 6 1 2"
      )

  /**
   * `1.2.840.113635.100.6.1.1`: Apple certificate extension
   */
  public val appleCertificateExtensionAppleSigning: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 6 1 1"
      )

  /**
   * `1.2.840.113635.100.6.1`: Apple certificate extension
   */
  public val appleCertificateExtensionCodeSigning: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 6 1"
      )

  /**
   * `1.2.840.113635.100.6`: Apple
   */
  public val appleCertificateExtensions: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 6"
      )

  /**
   * `1.2.840.113635.100.5`: Apple
   */
  public val appleCertificatePolicies: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 5"
      )

  /**
   * `1.2.840.113635.100.5.1`: Apple
   */
  public val appleCertificatePolicyID: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 5 1"
      )

  /**
   * `1.2.840.113635.100.4.1`: Apple extended key usage
   */
  public val appleCodeSigning: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 4 1"
      )

  /**
   * `1.2.840.113635.100.4.1.1`: Apple extended key usage
   */
  public val appleCodeSigningDevelopment: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 4 1 1"
      )

  /**
   * `1.2.840.113635.100.1.16`: Apple trust policy
   */
  public val appleCodeSigningPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 1 16"
      )

  /**
   * `1.2.840.113635.100.4.1.3`: Apple extended key usage
   */
  public val appleCodeSigningThirdParty: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 4 1 3"
      )

  /**
   * `1.2.840.113635.100.4.5.4`: Apple extended key usage
   */
  public val appleCryptoDevelopmentEnv: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 4 5 4"
      )

  /**
   * `1.2.840.113635.100.4.5`: Apple extended key usage
   */
  public val appleCryptoEnv: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 4 5"
      )

  /**
   * `1.2.840.113635.100.4.5.2`: Apple extended key usage
   */
  public val appleCryptoMaintenanceEnv: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 4 5 2"
      )

  /**
   * `1.2.840.113635.100.4.5.1`: Apple extended key usage
   */
  public val appleCryptoProductionEnv: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 4 5 1"
      )

  /**
   * `1.2.840.113635.100.4.6`: Apple extended key usage
   */
  public val appleCryptoQoS: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 4 6"
      )

  /**
   * `1.2.840.113635.100.4.5.3`: Apple extended key usage
   */
  public val appleCryptoTestEnv: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 4 5 3"
      )

  /**
   * `1.2.840.113635.100.4.6.1`: Apple extended key usage
   */
  public val appleCryptoTier0QoS: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 4 6 1"
      )

  /**
   * `1.2.840.113635.100.4.6.2`: Apple extended key usage
   */
  public val appleCryptoTier1QoS: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 4 6 2"
      )

  /**
   * `1.2.840.113635.100.4.6.3`: Apple extended key usage
   */
  public val appleCryptoTier2QoS: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 4 6 3"
      )

  /**
   * `1.2.840.113635.100.4.6.4`: Apple extended key usage
   */
  public val appleCryptoTier3QoS: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 4 6 4"
      )

  /**
   * `1.2.840.113635.100.15.1`: Apple custom certificate extension
   */
  public val appleCustomCertificateExtension1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 15 1"
      )

  /**
   * `1.2.840.113635.100.15.2`: Apple custom certificate extension
   */
  public val appleCustomCertificateExtension2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 15 2"
      )

  /**
   * `1.2.840.113635.100.15.3`: Apple custom certificate extension
   */
  public val appleCustomCertificateExtension3: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 15 3"
      )

  /**
   * `1.2.840.113635.100`: Apple
   */
  public val appleDataSecurity: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100"
      )

  /**
   * `1.2.840.113635.100.3`: Apple
   */
  public val appleDotMacCertificate: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 3"
      )

  /**
   * `1.2.840.113635.100.3.2`: Apple dotMac certificate
   */
  public val appleDotMacCertificateExtension: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 3 2"
      )

  /**
   * `1.2.840.113635.100.5.2`: Apple
   */
  public val appleDotMacCertificatePolicyID: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 5 2"
      )

  /**
   * `1.2.840.113635.100.3.1`: Apple dotMac certificate
   */
  public val appleDotMacCertificateRequest: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 3 1"
      )

  /**
   * `1.2.840.113635.100.3.3`: Apple dotMac certificate
   */
  public val appleDotMacCertificateRequestValues: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 3 3"
      )

  /**
   * `1.2.840.113635.100.1.9`: Apple trust policy
   */
  public val appleEAPPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 1 9"
      )

  /**
   * `1.2.840.113635.100.2.7`: Apple security algorithm
   */
  public val appleECDSA: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 2 7"
      )

  /**
   * `1.2.840.113635.100.4`: Apple
   */
  public val appleExtendedKeyUsage: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 4"
      )

  /**
   * `1.2.840.113635.100.2.1`: Apple security algorithm
   */
  public val appleFEE: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 2 1"
      )

  /**
   * `1.2.840.113635.100.2.5`: Apple security algorithm
   */
  public val appleFEED: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 2 5"
      )

  /**
   * `1.2.840.113635.100.2.6`: Apple security algorithm
   */
  public val appleFEEDEXP: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 2 6"
      )

  /**
   * `1.2.840.113635.100.2.3`: Apple security algorithm
   */
  public val appleFEE_MD5: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 2 3"
      )

  /**
   * `1.2.840.113635.100.2.4`: Apple security algorithm
   */
  public val appleFEE_SHA1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 2 4"
      )

  /**
   * `1.2.840.113635.100.4.3`: Apple extended key usage
   */
  public val appleIChatEncryption: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 4 3"
      )

  /**
   * `1.2.840.113635.100.1.12`: Apple trust policy
   */
  public val appleIChatPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 1 12"
      )

  /**
   * `1.2.840.113635.100.4.2`: Apple extended key usage
   */
  public val appleIChatSigning: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 4 2"
      )

  /**
   * `1.2.840.113635.100.1.11`: Apple trust policy
   */
  public val appleIPSecPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 1 11"
      )

  /**
   * `1.2.840.113635.100.1.1`: Apple trust policy
   */
  public val appleISignTP: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 1 1"
      )

  /**
   * `1.2.840.113635.100.1.4`: Apple trust policy
   */
  public val appleLocalCertGenPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 1 4"
      )

  /**
   * `1.2.840.113635.100.1.7`: Apple trust policy
   */
  public val appleOCSPPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 1 7"
      )

  /**
   * `1.2.840.113635.100.1.14`: Apple trust policy
   */
  public val applePKINITClientPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 1 14"
      )

  /**
   * `1.2.840.113635.100.1.15`: Apple trust policy
   */
  public val applePKINITServerPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 1 15"
      )

  /**
   * `1.2.840.113635.100.1.17`: Apple trust policy
   */
  public val applePackageSigningPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 1 17"
      )

  /**
   * `1.2.840.113635.100.1.13`: Apple trust policy
   */
  public val appleResourceSignPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 1 13"
      )

  /**
   * `1.2.840.113635.100.4.1.4`: Apple extended key usage
   */
  public val appleResourceSigning: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 4 1 4"
      )

  /**
   * `1.2.840.113635.100.1.8`: Apple trust policy
   */
  public val appleSMIMEPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 1 8"
      )

  /**
   * `1.2.840.113635.100.1.3`: Apple trust policy
   */
  public val appleSSLPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 1 3"
      )

  /**
   * `1.2.840.113635.100.1.10`: Apple trust policy
   */
  public val appleSWUpdateSigningPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 1 10"
      )

  /**
   * `1.2.840.113635.100.2`: Apple
   */
  public val appleSecurityAlgorithm: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 2"
      )

  /**
   * `1.2.840.113635.100.4.1.2`: Apple extended key usage
   */
  public val appleSoftwareUpdateSigning: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 4 1 2"
      )

  /**
   * `1.2.840.113635.100.4.4`: Apple extended key usage
   */
  public val appleSystemIdentity: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 4 4"
      )

  /**
   * `1.2.840.113635.100.1`: Apple
   */
  public val appleTrustPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 1"
      )

  /**
   * `1.2.840.113635.100.1.2`: Apple trust policy
   */
  public val appleX509Basic: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113635 100 1 2"
      )

  /**
   * `1.3.6.1.4.1.311.21.10`: Microsoft
   */
  public val applicationCertPolicies: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 21 10"
      )

  /**
   * `2.5.6.12`: X.520 objectClass
   */
  public val applicationEntity: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 6 12"
      )

  /**
   * `0.2.262.1.10.7.0`: Telesec attribute
   */
  public val applicationGroupIdentifier: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 7 0"
      )

  /**
   * `1.3.6.1.4.1.311.21.12`: Microsoft
   */
  public val applicationPolicyConstraints: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 21 12"
      )

  /**
   * `1.3.6.1.4.1.311.21.11`: Microsoft
   */
  public val applicationPolicyMappings: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 21 11"
      )

  /**
   * `2.5.6.11`: X.520 objectClass
   */
  public val applicationProcess: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 6 11"
      )

  /**
   * `2.16.840.1.101.2.1.5.23`: SDN.700 INFOSEC attributes
   */
  public val aprUKMs: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 5 23"
      )

  /**
   * `1.2.840.113549.1.9.16.2.27`: S/MIME Authenticated Attributes
   */
  public val archiveTimeStamp: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 27"
      )

  /**
   * `1.3.6.1.4.1.311.21.13`: Microsoft attribute
   */
  public val archivedKey: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 21 13"
      )

  /**
   * `1.3.6.1.4.1.311.21.16`: Microsoft
   */
  public val archivedKeyCertHash: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 21 16"
      )

  /**
   * `1.2.410.200046.1.1.2`: ARIA algorithm modes
   */
  public val aria128_cbc: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200046 1 1 2"
      )

  /**
   * `1.2.410.200046.1.1.37`: ARIA algorithm modes
   */
  public val aria128_ccm: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200046 1 1 37"
      )

  /**
   * `1.2.410.200046.1.1.3`: ARIA algorithm modes
   */
  public val aria128_cfb: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200046 1 1 3"
      )

  /**
   * `1.2.410.200046.1.1.21`: ARIA algorithm modes
   */
  public val aria128_cmac: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200046 1 1 21"
      )

  /**
   * `1.2.410.200046.1.1.5`: ARIA algorithm modes
   */
  public val aria128_ctr: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200046 1 1 5"
      )

  /**
   * `1.2.410.200046.1.1.1`: ARIA algorithm modes
   */
  public val aria128_ecb: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200046 1 1 1"
      )

  /**
   * `1.2.410.200046.1.1.34`: ARIA algorithm modes
   */
  public val aria128_gcm: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200046 1 1 34"
      )

  /**
   * `1.2.410.200046.1.1.40`: ARIA algorithm modes
   */
  public val aria128_keywrap: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200046 1 1 40"
      )

  /**
   * `1.2.410.200046.1.1.43`: ARIA algorithm modes
   */
  public val aria128_keywrapWithPad: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200046 1 1 43"
      )

  /**
   * `1.2.410.200046.1.1.31`: ARIA algorithm modes
   */
  public val aria128_ocb2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200046 1 1 31"
      )

  /**
   * `1.2.410.200046.1.1.4`: ARIA algorithm modes
   */
  public val aria128_ofb: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200046 1 1 4"
      )

  /**
   * `1.2.410.200046.1.1.7`: ARIA algorithm modes
   */
  public val aria192_cbc: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200046 1 1 7"
      )

  /**
   * `1.2.410.200046.1.1.38`: ARIA algorithm modes
   */
  public val aria192_ccm: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200046 1 1 38"
      )

  /**
   * `1.2.410.200046.1.1.8`: ARIA algorithm modes
   */
  public val aria192_cfb: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200046 1 1 8"
      )

  /**
   * `1.2.410.200046.1.1.22`: ARIA algorithm modes
   */
  public val aria192_cmac: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200046 1 1 22"
      )

  /**
   * `1.2.410.200046.1.1.10`: ARIA algorithm modes
   */
  public val aria192_ctr: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200046 1 1 10"
      )

  /**
   * `1.2.410.200046.1.1.6`: ARIA algorithm modes
   */
  public val aria192_ecb: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200046 1 1 6"
      )

  /**
   * `1.2.410.200046.1.1.35`: ARIA algorithm modes
   */
  public val aria192_gcm: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200046 1 1 35"
      )

  /**
   * `1.2.410.200046.1.1.41`: ARIA algorithm modes
   */
  public val aria192_keywrap: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200046 1 1 41"
      )

  /**
   * `1.2.410.200046.1.1.44`: ARIA algorithm modes
   */
  public val aria192_keywrapWithPad: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200046 1 1 44"
      )

  /**
   * `1.2.410.200046.1.1.32`: ARIA algorithm modes
   */
  public val aria192_ocb2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200046 1 1 32"
      )

  /**
   * `1.2.410.200046.1.1.9`: ARIA algorithm modes
   */
  public val aria192_ofb: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200046 1 1 9"
      )

  /**
   * `1.2.410.200046.1.1`: ARIA algorithm modes
   */
  public val aria1AlgorithmModes: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200046 1 1"
      )

  /**
   * `1.2.410.200046.1.1.12`: ARIA algorithm modes
   */
  public val aria256_cbc: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200046 1 1 12"
      )

  /**
   * `1.2.410.200046.1.1.39`: ARIA algorithm modes
   */
  public val aria256_ccm: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200046 1 1 39"
      )

  /**
   * `1.2.410.200046.1.1.13`: ARIA algorithm modes
   */
  public val aria256_cfb: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200046 1 1 13"
      )

  /**
   * `1.2.410.200046.1.1.23`: ARIA algorithm modes
   */
  public val aria256_cmac: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200046 1 1 23"
      )

  /**
   * `1.2.410.200046.1.1.15`: ARIA algorithm modes
   */
  public val aria256_ctr: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200046 1 1 15"
      )

  /**
   * `1.2.410.200046.1.1.11`: ARIA algorithm modes
   */
  public val aria256_ecb: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200046 1 1 11"
      )

  /**
   * `1.2.410.200046.1.1.36`: ARIA algorithm modes
   */
  public val aria256_gcm: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200046 1 1 36"
      )

  /**
   * `1.2.410.200046.1.1.42`: ARIA algorithm modes
   */
  public val aria256_keywrap: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200046 1 1 42"
      )

  /**
   * `1.2.410.200046.1.1.45`: ARIA algorithm modes
   */
  public val aria256_keywrapWithPad: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200046 1 1 45"
      )

  /**
   * `1.2.410.200046.1.1.33`: ARIA algorithm modes
   */
  public val aria256_ocb2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200046 1 1 33"
      )

  /**
   * `1.2.410.200046.1.1.14`: ARIA algorithm modes
   */
  public val aria256_ofb: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200046 1 1 14"
      )

  /**
   * `2.16.840.1.101.3.3`: CSOR GAK
   */
  public val arpa: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 3"
      )

  /**
   * `1.2.840.113549.1.9.16.1.32`: S/MIME Content Types
   */
  public val asAdjacencyAttest: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 1 32"
      )

  /**
   * `1.2.840.113549.1.9.16.1.27`: S/MIME Content Types
   */
  public val asciiTextWithCRLF: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 1 27"
      )

  /**
   * `1.3.6.1.4.1.188.7.1.1`: Ascom Systech
   */
  public val ascom: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 188 7 1 1"
      )

  /**
   * `1.2.840.113549.1.9.16.2.54`: S/MIME Authenticated Attributes
   */
  public val asymmDecryptKeyID: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 54"
      )

  /**
   * `1.3.36.8.6.3`: Teletrust signature attributes
   */
  public val attrCert: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 6 3"
      )

  /**
   * `1.2.840.113549.1.9.16.1.14`: S/MIME Content Types
   */
  public val attrCertEncAttrs: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 1 14"
      )

  /**
   * `1.3.36.8.6.4`: Teletrust signature attributes
   */
  public val attrRef: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 6 4"
      )

  /**
   * `0.2.262.1.10.7`: Telesec
   */
  public val attribute: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 7"
      )

  /**
   * `2.5.4.63`: X.520 DN component
   */
  public val attributeAuthorityRevocationList: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 63"
      )

  /**
   * `1.3.6.1.5.5.7.0.12`: PKIX
   */
  public val attributeCert: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 0 12"
      )

  /**
   * `1.2.840.113533.7.68.10`: Nortel Secure Networks at
   */
  public val attributeCertificate: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113533 7 68 10"
      )

  /**
   * `2.5.4.59`: X.520 DN component
   */
  public val attributeCertificateRevocationList: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 59"
      )

  /**
   * `1.3.6.1.5.5.7.10`: PKIX
   */
  public val attributeCertificate_1_3_6_1_5_5_7_10: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 10"
      )

  /**
   * `2.5.4.58`: X.520 DN component
   */
  public val attributeCertificate_2_5_4_58: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 58"
      )

  /**
   * `2.5.29.48`: X.509 extension
   */
  public val attributeDescriptor: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 48"
      )

  /**
   * `2.5.4.62`: X.520 DN component
   */
  public val attributeDescriptorCertificate: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 62"
      )

  /**
   * `0.2.262.1.10.8`: Telesec
   */
  public val attributeGroup: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 8"
      )

  /**
   * `2.5.4.57`: X.520 DN component
   */
  public val attributeIntegrityInfo: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 57"
      )

  /**
   * `2.5.29.68`: X.509 extension
   */
  public val attributeMappings: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 68"
      )

  /**
   * `1.2.840.113556.1.3.14`: Microsoft Exchange Server - object class
   */
  public val attributeSchema: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113556 1 3 14"
      )

  /**
   * `0.2.262.1.10.2.1`: Telesec module
   */
  public val attributeTypes: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 2 1"
      )

  /**
   * `1.2.840.10040.3`: ANSI X9.57
   */
  public val attribute_1_2_840_10040_3: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10040 3"
      )

  /**
   * `1.3.36.4`: Teletrust attribute
   */
  public val attribute_1_3_36_4: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 4"
      )

  /**
   * `2.23.42.3`: SET
   */
  public val attribute_2_23_42_3: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 3"
      )

  /**
   * `1.2.840.10040.3.2`: ANSI X9.57 attribute
   */
  public val attribute_cert: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10040 3 2"
      )

  /**
   * `2.16.840.1.101.2.1.5.27`: SDN.700 INFOSEC attributes
   */
  public val augUKMs: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 5 27"
      )

  /**
   * `1.2.36.1.333.1`: Australian Government corporate taxpayer ID
   */
  public val australianBusinessNumber: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 333 1"
      )

  /**
   * `1.2.840.113549.1.9.16.1.2`: S/MIME Content Types
   */
  public val authData: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 1 2"
      )

  /**
   * `1.3.6.1.5.2.3.1`: Kerberos
   */
  public val authData_1_3_6_1_5_2_3_1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 2 3 1"
      )

  /**
   * `1.2.840.113549.1.9.16.3.15`: S/MIME Algorithms
   */
  public val authEnc128: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 3 15"
      )

  /**
   * `1.2.840.113549.1.9.16.3.16`: S/MIME Algorithms
   */
  public val authEnc256: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 3 16"
      )

  /**
   * `1.2.840.113549.1.9.16.1.23`: S/MIME Content Types
   */
  public val authEnvelopedData: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 1 23"
      )

  /**
   * `1.2.840.113549.1.9.16.2`: S/MIME
   */
  public val authenticatedAttributes: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2"
      )

  /**
   * `0.2.262.1.10.1.0`: Telesec mechanism
   */
  public val authentication: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 1 0"
      )

  /**
   * `1.3.6.1.5.5.7.10.1`: PKIX attribute certificate extension
   */
  public val authenticationInfo: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 10 1"
      )

  /**
   * `1.3.6.1.5.5.7.5.1.2`: PKIX CRMF registration control
   */
  public val authenticator: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 5 1 2"
      )

  /**
   * `2.5.29.38`: X.509 extension
   */
  public val authorityAttributeIdentifier: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 38"
      )

  /**
   * `1.3.6.1.5.5.7.1.1`: PKIX private extension
   */
  public val authorityInfoAccess: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 1 1"
      )

  /**
   * `2.5.29.1`: X.509 extension.  Deprecated, use 2 5 29 35 instead
   */
  public val authorityKeyIdentifier: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 1"
      )

  /**
   * `2.5.29.35`: X.509 extension
   */
  public val authorityKeyIdentifier_2_5_29_35: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 35"
      )

  /**
   * `2.5.4.38`: X.520 DN component
   */
  public val authorityRevocationList: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 38"
      )

  /**
   * `1.3.6.1.4.1.311.20.1`: Microsoft
   */
  public val autoEnrollCtlUsage: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 20 1"
      )

  /**
   * `1.3.36.8.6.10`: Teletrust signature attributes
   */
  public val autoGen: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 6 10"
      )

  /**
   * `1.3.6.1.5.5.7.1.8`: PKIX private extension
   */
  public val autonomousSysIds: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 1 8"
      )

  /**
   * `1.3.6.1.5.5.7.1.29`: PKIX private extension
   */
  public val autonomousSysIdsV2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 1 29"
      )

  /**
   * `2.16.840.1.101.2.1.5.10`: SDN.700 INFOSEC attributes (superseded)
   */
  public val auxiliaryVector: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 5 10"
      )

  /**
   * `2.5.29.51`: X.509 extension
   */
  public val baseUpdateTime: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 51"
      )

  /**
   * `2.5.29.41`: X.509 extension
   */
  public val basicAttConstraints: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 41"
      )

  /**
   * `2.5.29.10`: X.509 extension.  Deprecated, use 2 5 29 19 instead
   */
  public val basicConstraints: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 10"
      )

  /**
   * `2.5.29.13`: X.509 extension.  Deprecated, use 2 5 29 19 instead
   */
  public val basicConstraints_2_5_29_13: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 13"
      )

  /**
   * `2.5.29.19`: X.509 extension
   */
  public val basicConstraints_2_5_29_19: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 19"
      )

  /**
   * `1.3.6.1.5.5.7.3.30`: PKIX key purpose
   */
  public val bgpsecRouter: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 3 30"
      )

  /**
   * `1.2.112.0.2.0.34.101.45.3.1`: Belarus STB 34.101.45
   */
  public val bignParamB1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 112 0 2 0 34 101 45 3 1"
      )

  /**
   * `1.2.112.0.2.0.34.101.45.3.2`: Belarus STB 34.101.45
   */
  public val bignParamB2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 112 0 2 0 34 101 45 3 2"
      )

  /**
   * `1.2.112.0.2.0.34.101.45.3.3`: Belarus STB 34.101.45
   */
  public val bignParamB3: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 112 0 2 0 34 101 45 3 3"
      )

  /**
   * `1.2.112.0.2.0.34.101.45.2.1`: Belarus STB 34.101.45
   */
  public val bignPubkey: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 112 0 2 0 34 101 45 2 1"
      )

  /**
   * `1.2.112.0.2.0.34.101.45.12`: Belarus STB 34.101.45
   */
  public val bignWithHBelt: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 112 0 2 0 34 101 45 12"
      )

  /**
   * `1.2.112.0.2.0.34.101.45.11`: Belarus STB 34.101.45
   */
  public val bignWithHSpec: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 112 0 2 0 34 101 45 11"
      )

  /**
   * `1.3.6.1.5.5.7.3.31`: PKIX key purpose
   */
  public val bimi: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 3 31"
      )

  /**
   * `1.2.840.113549.1.9.16.2.46`: S/MIME Authenticated Attributes
   */
  public val binarySigningTime: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 46"
      )

  /**
   * `1.3.133.16.840.9.84.1.1`: X9.84 Biometric
   */
  public val biometricBodyOdor: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 133 16 840 9 84 1 1"
      )

  /**
   * `1.3.133.16.840.9.84.1.2`: X9.84 Biometric
   */
  public val biometricDNA: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 133 16 840 9 84 1 2"
      )

  /**
   * `1.3.133.16.840.9.84.1.3`: X9.84 Biometric
   */
  public val biometricEarShape: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 133 16 840 9 84 1 3"
      )

  /**
   * `1.3.133.16.840.9.84.1.4`: X9.84 Biometric
   */
  public val biometricFacialFeatures: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 133 16 840 9 84 1 4"
      )

  /**
   * `1.3.133.16.840.9.84.1.6`: X9.84 Biometric
   */
  public val biometricFingerGeometry: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 133 16 840 9 84 1 6"
      )

  /**
   * `1.3.133.16.840.9.84.1.5`: X9.84 Biometric
   */
  public val biometricFingerImage: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 133 16 840 9 84 1 5"
      )

  /**
   * `1.3.133.16.840.9.84.1.19`: X9.84 Biometric
   */
  public val biometricGait: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 133 16 840 9 84 1 19"
      )

  /**
   * `1.3.133.16.840.9.84.1.7`: X9.84 Biometric
   */
  public val biometricHandGeometry: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 133 16 840 9 84 1 7"
      )

  /**
   * `1.3.6.1.5.5.7.1.2`: PKIX private extension
   */
  public val biometricInfo: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 1 2"
      )

  /**
   * `1.3.133.16.840.9.84.1.8`: X9.84 Biometric
   */
  public val biometricIrisFeatures: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 133 16 840 9 84 1 8"
      )

  /**
   * `1.3.133.16.840.9.84.1.9`: X9.84 Biometric
   */
  public val biometricKeystrokeDynamics: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 133 16 840 9 84 1 9"
      )

  /**
   * `1.3.133.16.840.9.84.1.18`: X9.84 Biometric
   */
  public val biometricLipMovement: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 133 16 840 9 84 1 18"
      )

  /**
   * `1.3.133.16.840.9.84.1.10`: X9.84 Biometric
   */
  public val biometricPalm: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 133 16 840 9 84 1 10"
      )

  /**
   * `1.3.133.16.840.9.84.1.11`: X9.84 Biometric
   */
  public val biometricRetina: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 133 16 840 9 84 1 11"
      )

  /**
   * `1.3.133.16.840.9.84.1.12`: X9.84 Biometric
   */
  public val biometricSignature: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 133 16 840 9 84 1 12"
      )

  /**
   * `1.3.133.16.840.9.84.1.13`: X9.84 Biometric
   */
  public val biometricSpeechPattern: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 133 16 840 9 84 1 13"
      )

  /**
   * `1.3.133.16.840.9.84.1.16`: X9.84 Biometric
   */
  public val biometricThermalFaceImage: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 133 16 840 9 84 1 16"
      )

  /**
   * `1.3.133.16.840.9.84.1.17`: X9.84 Biometric
   */
  public val biometricThermalHandImage: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 133 16 840 9 84 1 17"
      )

  /**
   * `1.3.133.16.840.9.84.1.14`: X9.84 Biometric
   */
  public val biometricThermalImage: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 133 16 840 9 84 1 14"
      )

  /**
   * `1.3.133.16.840.9.84.1.0`: X9.84 Biometric
   */
  public val biometricUnknownType: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 133 16 840 9 84 1 0"
      )

  /**
   * `1.3.133.16.840.9.84.1.15`: X9.84 Biometric
   */
  public val biometricVeinPattern: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 133 16 840 9 84 1 15"
      )

  /**
   * `2.23.42.2.3`: SET field
   */
  public val birthFamilyName: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 2 3"
      )

  /**
   * `1.3.6.1.4.1.3029.1.1.2`: cryptlib encryption algorithm
   */
  public val blowfishCBC: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 3029 1 1 2"
      )

  /**
   * `1.3.6.1.4.1.3029.1.1.3`: cryptlib encryption algorithm
   */
  public val blowfishCFB: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 3029 1 1 3"
      )

  /**
   * `1.3.6.1.4.1.3029.1.1.1`: cryptlib encryption algorithm
   */
  public val blowfishECB: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 3029 1 1 1"
      )

  /**
   * `1.3.6.1.4.1.3029.1.1.4`: cryptlib encryption algorithm
   */
  public val blowfishOFB: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 3029 1 1 4"
      )

  /**
   * `1.3.36.3.3.2.8.1.1.1`: ECC Brainpool Standard Curves and Curve Generation
   */
  public val brainpoolP160r1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 2 8 1 1 1"
      )

  /**
   * `1.3.36.3.3.2.8.1.1.2`: ECC Brainpool Standard Curves and Curve Generation
   */
  public val brainpoolP160t1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 2 8 1 1 2"
      )

  /**
   * `1.3.36.3.3.2.8.1.1.3`: ECC Brainpool Standard Curves and Curve Generation
   */
  public val brainpoolP192r1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 2 8 1 1 3"
      )

  /**
   * `1.3.36.3.3.2.8.1.1.4`: ECC Brainpool Standard Curves and Curve Generation
   */
  public val brainpoolP192t1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 2 8 1 1 4"
      )

  /**
   * `1.3.36.3.3.2.8.1.1.5`: ECC Brainpool Standard Curves and Curve Generation
   */
  public val brainpoolP224r1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 2 8 1 1 5"
      )

  /**
   * `1.3.36.3.3.2.8.1.1.6`: ECC Brainpool Standard Curves and Curve Generation
   */
  public val brainpoolP224t1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 2 8 1 1 6"
      )

  /**
   * `1.3.36.3.3.2.8.1.1.7`: ECC Brainpool Standard Curves and Curve Generation
   */
  public val brainpoolP256r1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 2 8 1 1 7"
      )

  /**
   * `1.3.36.3.3.2.8.1.1.8`: ECC Brainpool Standard Curves and Curve Generation
   */
  public val brainpoolP256t1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 2 8 1 1 8"
      )

  /**
   * `1.3.36.3.3.2.8.1.1.9`: ECC Brainpool Standard Curves and Curve Generation
   */
  public val brainpoolP320r1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 2 8 1 1 9"
      )

  /**
   * `1.3.36.3.3.2.8.1.1.10`: ECC Brainpool Standard Curves and Curve Generation
   */
  public val brainpoolP320t1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 2 8 1 1 10"
      )

  /**
   * `1.3.36.3.3.2.8.1.1.11`: ECC Brainpool Standard Curves and Curve Generation
   */
  public val brainpoolP384r1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 2 8 1 1 11"
      )

  /**
   * `1.3.36.3.3.2.8.1.1.12`: ECC Brainpool Standard Curves and Curve Generation
   */
  public val brainpoolP384t1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 2 8 1 1 12"
      )

  /**
   * `1.3.36.3.3.2.8.1.1.13`: ECC Brainpool Standard Curves and Curve Generation
   */
  public val brainpoolP512r1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 2 8 1 1 13"
      )

  /**
   * `1.3.36.3.3.2.8.1.1.14`: ECC Brainpool Standard Curves and Curve Generation
   */
  public val brainpoolP512t1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 2 8 1 1 14"
      )

  /**
   * `2.23.42.8`: SET
   */
  public val brand: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 8"
      )

  /**
   * `1.2.840.113549.1.2`: Obsolete BSAFE OID
   */
  public val bsafeRsaEncr: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 2"
      )

  /**
   * `0.4.0.127.0.7`: BSI TR-03110/TR-03111
   */
  public val bsi: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7"
      )

  /**
   * `0.4.0.127.0.7.4.1.1.3`: BSI TR-03109
   */
  public val bsiAuthorizedCertReqMsgs: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 4 1 1 3"
      )

  /**
   * `0.4.0.127.0.7.3.1.4`: BSI TR-03110
   */
  public val bsiAuxData: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 3 1 4"
      )

  /**
   * `0.4.0.127.0.7.3.1.4.1`: BSI TR-03110
   */
  public val bsiAuxDataBirthday: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 3 1 4 1"
      )

  /**
   * `0.4.0.127.0.7.3.1.4.3`: BSI TR-03110
   */
  public val bsiAuxDataCommunityID: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 3 1 4 3"
      )

  /**
   * `0.4.0.127.0.7.3.1.4.2`: BSI TR-03110
   */
  public val bsiAuxDataExpireDate: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 3 1 4 2"
      )

  /**
   * `0.4.0.127.0.7.3.2.2`: BSI TR-03110
   */
  public val bsiBlackList: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 3 2 2"
      )

  /**
   * `0.4.0.127.0.7.2.2.3`: BSI TR-03110
   */
  public val bsiCA: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 3"
      )

  /**
   * `0.4.0.127.0.7.2.2.3.1`: BSI TR-03110
   */
  public val bsiCA_DH: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 3 1"
      )

  /**
   * `0.4.0.127.0.7.2.2.3.1.1`: BSI TR-03110
   */
  public val bsiCA_DH_3DES_CBC_CBC: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 3 1 1"
      )

  /**
   * `0.4.0.127.0.7.2.2.3.1.2`: BSI TR-03110
   */
  public val bsiCA_DH_AES_CBC_CMAC_128: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 3 1 2"
      )

  /**
   * `0.4.0.127.0.7.2.2.3.1.3`: BSI TR-03110
   */
  public val bsiCA_DH_AES_CBC_CMAC_192: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 3 1 3"
      )

  /**
   * `0.4.0.127.0.7.2.2.3.1.4`: BSI TR-03110
   */
  public val bsiCA_DH_AES_CBC_CMAC_256: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 3 1 4"
      )

  /**
   * `0.4.0.127.0.7.2.2.3.2`: BSI TR-03110
   */
  public val bsiCA_ECDH: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 3 2"
      )

  /**
   * `0.4.0.127.0.7.2.2.3.2.1`: BSI TR-03110
   */
  public val bsiCA_ECDH_3DES_CBC_CBC: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 3 2 1"
      )

  /**
   * `0.4.0.127.0.7.2.2.3.2.2`: BSI TR-03110
   */
  public val bsiCA_ECDH_AES_CBC_CMAC_128: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 3 2 2"
      )

  /**
   * `0.4.0.127.0.7.2.2.3.2.3`: BSI TR-03110
   */
  public val bsiCA_ECDH_AES_CBC_CMAC_192: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 3 2 3"
      )

  /**
   * `0.4.0.127.0.7.2.2.3.2.4`: BSI TR-03110
   */
  public val bsiCA_ECDH_AES_CBC_CMAC_256: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 3 2 4"
      )

  /**
   * `0.4.0.127.0.7.2.2.6`: BSI TR-03110
   */
  public val bsiCardInfo: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 6"
      )

  /**
   * `0.4.0.127.0.7.4.1.1.1`: BSI TR-03109
   */
  public val bsiCertReqMsgs: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 4 1 1 1"
      )

  /**
   * `0.4.0.127.0.7.4.1.1.2`: BSI TR-03109
   */
  public val bsiCertReqMsgswithOuterSignature: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 4 1 1 2"
      )

  /**
   * `0.4.0.127.0.7.1.1.2.3`: BSI TR-03111
   */
  public val bsiCharacteristicTwoBasis: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 1 1 2 3"
      )

  /**
   * `0.4.0.127.0.7.1.1.2`: BSI TR-03111
   */
  public val bsiCharacteristicTwoField: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 1 1 2"
      )

  /**
   * `0.4.0.127.0.7.3.1.5.1.4`: BSI TR-03110
   */
  public val bsiDefectActiveAuthKeyRevoked: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 3 1 5 1 4"
      )

  /**
   * `0.4.0.127.0.7.3.1.5.1`: BSI TR-03110
   */
  public val bsiDefectAuthDefect: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 3 1 5 1"
      )

  /**
   * `0.4.0.127.0.7.3.1.5.4.1`: BSI TR-03110
   */
  public val bsiDefectCardSecurityMalformed: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 3 1 5 4 1"
      )

  /**
   * `0.4.0.127.0.7.3.1.5.1.2`: BSI TR-03110
   */
  public val bsiDefectCertReplaced: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 3 1 5 1 2"
      )

  /**
   * `0.4.0.127.0.7.3.1.5.1.1`: BSI TR-03110
   */
  public val bsiDefectCertRevoked: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 3 1 5 1 1"
      )

  /**
   * `0.4.0.127.0.7.3.1.5.1.3`: BSI TR-03110
   */
  public val bsiDefectChipAuthKeyRevoked: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 3 1 5 1 3"
      )

  /**
   * `0.4.0.127.0.7.3.1.5.4.2`: BSI TR-03110
   */
  public val bsiDefectChipSecurityMalformed: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 3 1 5 4 2"
      )

  /**
   * `0.4.0.127.0.7.3.1.5.4`: BSI TR-03110
   */
  public val bsiDefectDocumentDefect: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 3 1 5 4"
      )

  /**
   * `0.4.0.127.0.7.3.1.5.3.1`: BSI TR-03110
   */
  public val bsiDefectEIDDGMalformed: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 3 1 5 3 1"
      )

  /**
   * `0.4.0.127.0.7.3.1.5.3`: BSI TR-03110
   */
  public val bsiDefectEIDDefect: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 3 1 5 3"
      )

  /**
   * `0.4.0.127.0.7.3.1.5.3.2`: BSI TR-03110
   */
  public val bsiDefectEIDIntegrity: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 3 1 5 3 2"
      )

  /**
   * `0.4.0.127.0.7.3.1.5.2.1`: BSI TR-03110
   */
  public val bsiDefectEPassportDGMalformed: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 3 1 5 2 1"
      )

  /**
   * `0.4.0.127.0.7.3.1.5.2`: BSI TR-03110
   */
  public val bsiDefectEPassportDefect: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 3 1 5 2"
      )

  /**
   * `0.4.0.127.0.7.3.1.5`: BSI TR-03110
   */
  public val bsiDefectList: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 3 1 5"
      )

  /**
   * `0.4.0.127.0.7.3.1.5.4.3`: BSI TR-03110
   */
  public val bsiDefectPowerDownReq: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 3 1 5 4 3"
      )

  /**
   * `0.4.0.127.0.7.3.1.5.2.2`: BSI TR-03110
   */
  public val bsiDefectSODInvalid: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 3 1 5 2 2"
      )

  /**
   * `0.4.0.127.0.7.3.1.2`: BSI TR-03110
   */
  public val bsiEACRoles: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 3 1 2"
      )

  /**
   * `0.4.0.127.0.7.3.1.2.2`: BSI TR-03110
   */
  public val bsiEACRolesAT: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 3 1 2 2"
      )

  /**
   * `0.4.0.127.0.7.3.1.2.1`: BSI TR-03110
   */
  public val bsiEACRolesIS: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 3 1 2 1"
      )

  /**
   * `0.4.0.127.0.7.3.1.2.3`: BSI TR-03110
   */
  public val bsiEACRolesST: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 3 1 2 3"
      )

  /**
   * `0.4.0.127.0.7.1.1.2.2`: BSI TR-03111
   */
  public val bsiECTLVKeyFormat: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 1 1 2 2"
      )

  /**
   * `0.4.0.127.0.7.1.1.2.2.1`: BSI TR-03111
   */
  public val bsiECTLVPublicKey: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 1 1 2 2 1"
      )

  /**
   * `0.4.0.127.0.7.1.2`: BSI TR-03111
   */
  public val bsiEcKeyType: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 1 2"
      )

  /**
   * `0.4.0.127.0.7.1.2.1`: BSI TR-03111
   */
  public val bsiEcPublicKey: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 1 2 1"
      )

  /**
   * `0.4.0.127.0.7.1`: BSI TR-03111
   */
  public val bsiEcc: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 1"
      )

  /**
   * `0.4.0.127.0.7.1.1.4.1`: BSI TR-03111
   */
  public val bsiEcdsaSignatures: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 1 1 4 1"
      )

  /**
   * `0.4.0.127.0.7.1.1.4.1.6`: BSI TR-03111
   */
  public val bsiEcdsaWithRIPEMD160: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 1 1 4 1 6"
      )

  /**
   * `0.4.0.127.0.7.1.1.4.1.1`: BSI TR-03111
   */
  public val bsiEcdsaWithSHA1: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 1 1 4 1 1"
      )

  /**
   * `0.4.0.127.0.7.1.1.4.1.2`: BSI TR-03111
   */
  public val bsiEcdsaWithSHA224: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 1 1 4 1 2"
      )

  /**
   * `0.4.0.127.0.7.1.1.4.1.3`: BSI TR-03111
   */
  public val bsiEcdsaWithSHA256: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 1 1 4 1 3"
      )

  /**
   * `0.4.0.127.0.7.1.1.4.1.4`: BSI TR-03111
   */
  public val bsiEcdsaWithSHA384: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 1 1 4 1 4"
      )

  /**
   * `0.4.0.127.0.7.1.1.4.1.5`: BSI TR-03111
   */
  public val bsiEcdsaWithSHA512: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 1 1 4 1 5"
      )

  /**
   * `0.4.0.127.0.7.1.1.5.2`: BSI TR-03111
   */
  public val bsiEckaDH: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 1 1 5 2"
      )

  /**
   * `0.4.0.127.0.7.1.1.5.2.2`: BSI TR-03111
   */
  public val bsiEckaDHSessionKDF: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 1 1 5 2 2"
      )

  /**
   * `0.4.0.127.0.7.1.1.5.2.2.1`: BSI TR-03111
   */
  public val bsiEckaDHSessionKDFWith3DES: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 1 1 5 2 2 1"
      )

  /**
   * `0.4.0.127.0.7.1.1.5.2.2.2`: BSI TR-03111
   */
  public val bsiEckaDHSessionKDFWithAES128: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 1 1 5 2 2 2"
      )

  /**
   * `0.4.0.127.0.7.1.1.5.2.2.3`: BSI TR-03111
   */
  public val bsiEckaDHSessionKDFWithAES192: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 1 1 5 2 2 3"
      )

  /**
   * `0.4.0.127.0.7.1.1.5.2.2.4`: BSI TR-03111
   */
  public val bsiEckaDHSessionKDFWithAES256: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 1 1 5 2 2 4"
      )

  /**
   * `0.4.0.127.0.7.1.1.5.2.1`: BSI TR-03111
   */
  public val bsiEckaDHX963KDF: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 1 1 5 2 1"
      )

  /**
   * `0.4.0.127.0.7.1.1.5.2.1.6`: BSI TR-03111
   */
  public val bsiEckaDHX963KDFWithRIPEMD160: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 1 1 5 2 1 6"
      )

  /**
   * `0.4.0.127.0.7.1.1.5.2.1.1`: BSI TR-03111
   */
  public val bsiEckaDHX963KDFWithSHA1: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 1 1 5 2 1 1"
      )

  /**
   * `0.4.0.127.0.7.1.1.5.2.1.2`: BSI TR-03111
   */
  public val bsiEckaDHX963KDFWithSHA224: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 1 1 5 2 1 2"
      )

  /**
   * `0.4.0.127.0.7.1.1.5.2.1.3`: BSI TR-03111
   */
  public val bsiEckaDHX963KDFWithSHA256: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 1 1 5 2 1 3"
      )

  /**
   * `0.4.0.127.0.7.1.1.5.2.1.4`: BSI TR-03111
   */
  public val bsiEckaDHX963KDFWithSHA384: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 1 1 5 2 1 4"
      )

  /**
   * `0.4.0.127.0.7.1.1.5.2.1.5`: BSI TR-03111
   */
  public val bsiEckaDHX963KDFWithSHA512: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 1 1 5 2 1 5"
      )

  /**
   * `0.4.0.127.0.7.1.1.5.1.2`: BSI TR-03111
   */
  public val bsiEckaEgSessionKDF: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 1 1 5 1 2"
      )

  /**
   * `0.4.0.127.0.7.1.1.5.1.2.1`: BSI TR-03111
   */
  public val bsiEckaEgSessionKDFWith3DES: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 1 1 5 1 2 1"
      )

  /**
   * `0.4.0.127.0.7.1.1.5.1.2.2`: BSI TR-03111
   */
  public val bsiEckaEgSessionKDFWithAES128: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 1 1 5 1 2 2"
      )

  /**
   * `0.4.0.127.0.7.1.1.5.1.2.3`: BSI TR-03111
   */
  public val bsiEckaEgSessionKDFWithAES192: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 1 1 5 1 2 3"
      )

  /**
   * `0.4.0.127.0.7.1.1.5.1.2.4`: BSI TR-03111
   */
  public val bsiEckaEgSessionKDFWithAES256: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 1 1 5 1 2 4"
      )

  /**
   * `0.4.0.127.0.7.1.1.5.1.1`: BSI TR-03111
   */
  public val bsiEckaEgX963KDF: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 1 1 5 1 1"
      )

  /**
   * `0.4.0.127.0.7.1.1.5.1.1.6`: BSI TR-03111
   */
  public val bsiEckaEgX963KDFWithRIPEMD160: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 1 1 5 1 1 6"
      )

  /**
   * `0.4.0.127.0.7.1.1.5.1.1.1`: BSI TR-03111
   */
  public val bsiEckaEgX963KDFWithSHA1: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 1 1 5 1 1 1"
      )

  /**
   * `0.4.0.127.0.7.1.1.5.1.1.2`: BSI TR-03111
   */
  public val bsiEckaEgX963KDFWithSHA224: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 1 1 5 1 1 2"
      )

  /**
   * `0.4.0.127.0.7.1.1.5.1.1.3`: BSI TR-03111
   */
  public val bsiEckaEgX963KDFWithSHA256: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 1 1 5 1 1 3"
      )

  /**
   * `0.4.0.127.0.7.1.1.5.1.1.4`: BSI TR-03111
   */
  public val bsiEckaEgX963KDFWithSHA384: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 1 1 5 1 1 4"
      )

  /**
   * `0.4.0.127.0.7.1.1.5.1.1.5`: BSI TR-03111
   */
  public val bsiEckaEgX963KDFWithSHA512: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 1 1 5 1 1 5"
      )

  /**
   * `0.4.0.127.0.7.2.2.7`: BSI TR-03110
   */
  public val bsiEidSecurity: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 7"
      )

  /**
   * `0.4.0.127.0.7.1.1.2.3.1`: BSI TR-03111
   */
  public val bsiGnBasis: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 1 1 2 3 1"
      )

  /**
   * `0.4.0.127.0.7.1.5.1`: BSI TR-03111
   */
  public val bsiKaeg: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 1 5 1"
      )

  /**
   * `0.4.0.127.0.7.1.5.1.2`: BSI TR-03111
   */
  public val bsiKaegWith3DESKDF: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 1 5 1 2"
      )

  /**
   * `0.4.0.127.0.7.1.5.1.1`: BSI TR-03111
   */
  public val bsiKaegWithX963KDF: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 1 5 1 1"
      )

  /**
   * `0.4.0.127.0.7.3.1.6`: BSI TR-03110
   */
  public val bsiListContentDescription: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 3 1 6"
      )

  /**
   * `0.4.0.127.0.7.2.2.4`: BSI TR-03110
   */
  public val bsiPACE: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 4"
      )

  /**
   * `0.4.0.127.0.7.2.2.4.1`: BSI TR-03110
   */
  public val bsiPACE_DH_GM: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 4 1"
      )

  /**
   * `0.4.0.127.0.7.2.2.4.1.1`: BSI TR-03110
   */
  public val bsiPACE_DH_GM_3DES_CBC_CBC: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 4 1 1"
      )

  /**
   * `0.4.0.127.0.7.2.2.4.1.2`: BSI TR-03110
   */
  public val bsiPACE_DH_GM_AES_CBC_CMAC_128: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 4 1 2"
      )

  /**
   * `0.4.0.127.0.7.2.2.4.1.3`: BSI TR-03110
   */
  public val bsiPACE_DH_GM_AES_CBC_CMAC_192: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 4 1 3"
      )

  /**
   * `0.4.0.127.0.7.2.2.4.1.4`: BSI TR-03110
   */
  public val bsiPACE_DH_GM_AES_CBC_CMAC_256: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 4 1 4"
      )

  /**
   * `0.4.0.127.0.7.2.2.4.3`: BSI TR-03110
   */
  public val bsiPACE_DH_IM: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 4 3"
      )

  /**
   * `0.4.0.127.0.7.2.2.4.3.1`: BSI TR-03110
   */
  public val bsiPACE_DH_IM_3DES_CBC_CBC: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 4 3 1"
      )

  /**
   * `0.4.0.127.0.7.2.2.4.3.2`: BSI TR-03110
   */
  public val bsiPACE_DH_IM_AES_CBC_CMAC_128: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 4 3 2"
      )

  /**
   * `0.4.0.127.0.7.2.2.4.3.3`: BSI TR-03110
   */
  public val bsiPACE_DH_IM_AES_CBC_CMAC_192: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 4 3 3"
      )

  /**
   * `0.4.0.127.0.7.2.2.4.3.4`: BSI TR-03110
   */
  public val bsiPACE_DH_IM_AES_CBC_CMAC_256: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 4 3 4"
      )

  /**
   * `0.4.0.127.0.7.2.2.4.2`: BSI TR-03110
   */
  public val bsiPACE_ECDH_GM: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 4 2"
      )

  /**
   * `0.4.0.127.0.7.2.2.4.2.1`: BSI TR-03110
   */
  public val bsiPACE_ECDH_GM_3DES_CBC_CBC: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 4 2 1"
      )

  /**
   * `0.4.0.127.0.7.2.2.4.2.2`: BSI TR-03110
   */
  public val bsiPACE_ECDH_GM_AES_CBC_CMAC_128: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 4 2 2"
      )

  /**
   * `0.4.0.127.0.7.2.2.4.2.3`: BSI TR-03110
   */
  public val bsiPACE_ECDH_GM_AES_CBC_CMAC_192: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 4 2 3"
      )

  /**
   * `0.4.0.127.0.7.2.2.4.2.4`: BSI TR-03110
   */
  public val bsiPACE_ECDH_GM_AES_CBC_CMAC_256: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 4 2 4"
      )

  /**
   * `0.4.0.127.0.7.2.2.4.4`: BSI TR-03110
   */
  public val bsiPACE_ECDH_IM: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 4 4"
      )

  /**
   * `0.4.0.127.0.7.2.2.4.4.1`: BSI TR-03110
   */
  public val bsiPACE_ECDH_IM_3DES_CBC_CBC: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 4 4 1"
      )

  /**
   * `0.4.0.127.0.7.2.2.4.4.2`: BSI TR-03110
   */
  public val bsiPACE_ECDH_IM_AES_CBC_CMAC_128: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 4 4 2"
      )

  /**
   * `0.4.0.127.0.7.2.2.4.4.3`: BSI TR-03110
   */
  public val bsiPACE_ECDH_IM_AES_CBC_CMAC_192: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 4 4 3"
      )

  /**
   * `0.4.0.127.0.7.2.2.4.4.4`: BSI TR-03110
   */
  public val bsiPACE_ECDH_IM_AES_CBC_CMAC_256: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 4 4 4"
      )

  /**
   * `0.4.0.127.0.7.2.2.1`: BSI TR-03110. Formerly known as bsiCA, now moved to ...2.2.3.x
   */
  public val bsiPK: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 1"
      )

  /**
   * `1.3.36.7.1.1`: Teletrust key management
   */
  public val bsiPKE: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 7 1 1"
      )

  /**
   * `0.4.0.127.0.7.2.2.1.1`: BSI TR-03110. Formerly known as bsiCA_DH, now moved to ...2.2.3.x
   */
  public val bsiPK_DH: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 1 1"
      )

  /**
   * `0.4.0.127.0.7.2.2.1.2`: BSI TR-03110. Formerly known as bsiCA_ECDH, now moved to ...2.2.3.x
   */
  public val bsiPK_ECDH: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 1 2"
      )

  /**
   * `0.4.0.127.0.7.2.2.8`: BSI TR-03110
   */
  public val bsiPT: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 8"
      )

  /**
   * `0.4.0.127.0.7.1.1.2.3.3`: BSI TR-03111
   */
  public val bsiPpBasis: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 1 1 2 3 3"
      )

  /**
   * `0.4.0.127.0.7.1.1.1`: BSI TR-03111
   */
  public val bsiPrimeField: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 1 1 1"
      )

  /**
   * `0.4.0.127.0.7.2.2.5`: BSI TR-03110
   */
  public val bsiRI: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 5"
      )

  /**
   * `0.4.0.127.0.7.2.2.5.1`: BSI TR-03110
   */
  public val bsiRI_DH: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 5 1"
      )

  /**
   * `0.4.0.127.0.7.2.2.5.1.1`: BSI TR-03110
   */
  public val bsiRI_DH_SHA1: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 5 1 1"
      )

  /**
   * `0.4.0.127.0.7.2.2.5.1.2`: BSI TR-03110
   */
  public val bsiRI_DH_SHA224: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 5 1 2"
      )

  /**
   * `0.4.0.127.0.7.2.2.5.1.3`: BSI TR-03110
   */
  public val bsiRI_DH_SHA256: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 5 1 3"
      )

  /**
   * `0.4.0.127.0.7.2.2.5.1.4`: BSI TR-03110
   */
  public val bsiRI_DH_SHA384: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 5 1 4"
      )

  /**
   * `0.4.0.127.0.7.2.2.5.1.5`: BSI TR-03110
   */
  public val bsiRI_DH_SHA512: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 5 1 5"
      )

  /**
   * `0.4.0.127.0.7.2.2.5.2`: BSI TR-03110
   */
  public val bsiRI_ECDH: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 5 2"
      )

  /**
   * `0.4.0.127.0.7.2.2.5.2.1`: BSI TR-03110
   */
  public val bsiRI_ECDH_SHA1: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 5 2 1"
      )

  /**
   * `0.4.0.127.0.7.2.2.5.2.2`: BSI TR-03110
   */
  public val bsiRI_ECDH_SHA224: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 5 2 2"
      )

  /**
   * `0.4.0.127.0.7.2.2.5.2.3`: BSI TR-03110
   */
  public val bsiRI_ECDH_SHA256: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 5 2 3"
      )

  /**
   * `0.4.0.127.0.7.2.2.5.2.4`: BSI TR-03110
   */
  public val bsiRI_ECDH_SHA384: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 5 2 4"
      )

  /**
   * `0.4.0.127.0.7.2.2.5.2.5`: BSI TR-03110
   */
  public val bsiRI_ECDH_SHA512: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 5 2 5"
      )

  /**
   * `0.4.0.127.0.7.3.2.1`: BSI TR-03110
   */
  public val bsiSecurityObject: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 3 2 1"
      )

  /**
   * `0.4.0.127.0.7.4.1.2.2`: BSI TR-03109
   */
  public val bsiSignedRevReqs: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 4 1 2 2"
      )

  /**
   * `0.4.0.127.0.7.3.4.2.2`: BSI TR-03109
   */
  public val bsiSignedUpdateDeviceAdmin: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 3 4 2 2"
      )

  /**
   * `0.4.0.127.0.7.2.2.2`: BSI TR-03110
   */
  public val bsiTA: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 2"
      )

  /**
   * `0.4.0.127.0.7.2.2.2.2`: BSI TR-03110
   */
  public val bsiTA_ECDSA: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 2 2"
      )

  /**
   * `0.4.0.127.0.7.2.2.2.2.1`: BSI TR-03110
   */
  public val bsiTA_ECDSA_SHA1: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 2 2 1"
      )

  /**
   * `0.4.0.127.0.7.2.2.2.2.2`: BSI TR-03110
   */
  public val bsiTA_ECDSA_SHA224: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 2 2 2"
      )

  /**
   * `0.4.0.127.0.7.2.2.2.2.3`: BSI TR-03110
   */
  public val bsiTA_ECDSA_SHA256: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 2 2 3"
      )

  /**
   * `0.4.0.127.0.7.2.2.2.2.4`: BSI TR-03110
   */
  public val bsiTA_ECDSA_SHA384: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 2 2 4"
      )

  /**
   * `0.4.0.127.0.7.2.2.2.2.5`: BSI TR-03110
   */
  public val bsiTA_ECDSA_SHA512: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 2 2 5"
      )

  /**
   * `0.4.0.127.0.7.2.2.2.1`: BSI TR-03110
   */
  public val bsiTA_RSA: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 2 1"
      )

  /**
   * `0.4.0.127.0.7.2.2.2.1.3`: BSI TR-03110
   */
  public val bsiTA_RSAPSS_SHA1: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 2 1 3"
      )

  /**
   * `0.4.0.127.0.7.2.2.2.1.4`: BSI TR-03110
   */
  public val bsiTA_RSAPSS_SHA256: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 2 1 4"
      )

  /**
   * `0.4.0.127.0.7.2.2.2.1.6`: BSI TR-03110
   */
  public val bsiTA_RSAPSS_SHA512: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 2 1 6"
      )

  /**
   * `0.4.0.127.0.7.2.2.2.1.1`: BSI TR-03110
   */
  public val bsiTA_RSAv1_5_SHA1: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 2 1 1"
      )

  /**
   * `0.4.0.127.0.7.2.2.2.1.2`: BSI TR-03110
   */
  public val bsiTA_RSAv1_5_SHA256: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 2 1 2"
      )

  /**
   * `0.4.0.127.0.7.2.2.2.1.5`: BSI TR-03110
   */
  public val bsiTA_RSAv1_5_SHA512: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 2 2 2 1 5"
      )

  /**
   * `0.4.0.127.0.7.3.1.3`: BSI TR-03110
   */
  public val bsiTAv2ce: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 3 1 3"
      )

  /**
   * `0.4.0.127.0.7.3.1.3.1`: BSI TR-03110
   */
  public val bsiTAv2ceDescription: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 3 1 3 1"
      )

  /**
   * `0.4.0.127.0.7.3.1.3.1.2`: BSI TR-03110
   */
  public val bsiTAv2ceDescriptionIA5String: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 3 1 3 1 2"
      )

  /**
   * `0.4.0.127.0.7.3.1.3.1.3`: BSI TR-03110
   */
  public val bsiTAv2ceDescriptionOctetString: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 3 1 3 1 3"
      )

  /**
   * `0.4.0.127.0.7.3.1.3.1.1`: BSI TR-03110
   */
  public val bsiTAv2ceDescriptionPlainText: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 3 1 3 1 1"
      )

  /**
   * `0.4.0.127.0.7.3.1.3.2`: BSI TR-03110
   */
  public val bsiTAv2ceTerminalSector: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 3 1 3 2"
      )

  /**
   * `0.4.0.127.0.7.1.1.2.3.2`: BSI TR-03111
   */
  public val bsiTpBasis: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 1 1 2 3 2"
      )

  /**
   * `1.3.36.3.1.5`: Teletrust encryption algorithm
   */
  public val bsi_1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 1 5"
      )

  /**
   * `1.3.36.3.1.5.2.1`: Teletrust encryption algorithm
   */
  public val bsi_1CBC_PEMpad: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 1 5 2 1"
      )

  /**
   * `1.3.36.3.1.5.2`: Teletrust encryption algorithm
   */
  public val bsi_1CBC_pad: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 1 5 2"
      )

  /**
   * `1.3.36.3.1.5.1`: Teletrust encryption algorithm
   */
  public val bsi_1ECB_pad: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 1 5 1"
      )

  /**
   * `0.4.0.127.0.7.1.1`: BSI TR-03111
   */
  public val bsifieldType: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 127 0 7 1 1"
      )

  /**
   * `1.3.6.1.5.5.7.8.11`: PKIX other name
   */
  public val bundleEID: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 8 11"
      )

  /**
   * `1.3.6.1.5.5.7.3.35`: PKIX key purpose
   */
  public val bundleSecurity: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 3 35"
      )

  /**
   * `2.5.4.15`: X.520 DN component
   */
  public val businessCategory: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 15"
      )

  /**
   * `1.2.840.10045.3.0.1`: ANSI X9.62 named elliptic curve
   */
  public val c2pnb163v1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10045 3 0 1"
      )

  /**
   * `1.2.840.10045.3.0.2`: ANSI X9.62 named elliptic curve
   */
  public val c2pnb163v2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10045 3 0 2"
      )

  /**
   * `1.2.840.10045.3.0.3`: ANSI X9.62 named elliptic curve
   */
  public val c2pnb163v3: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10045 3 0 3"
      )

  /**
   * `1.2.840.10045.3.0.10`: ANSI X9.62 named elliptic curve
   */
  public val c2pnb208w1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10045 3 0 10"
      )

  /**
   * `1.2.840.10045.3.0.16`: ANSI X9.62 named elliptic curve
   */
  public val c2pnb272w1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10045 3 0 16"
      )

  /**
   * `1.2.840.10045.3.0.19`: ANSI X9.62 named elliptic curve
   */
  public val c2pnb368w1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10045 3 0 19"
      )

  /**
   * `1.2.840.10045.3.0.5`: ANSI X9.62 named elliptic curve
   */
  public val c2tnb191v1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10045 3 0 5"
      )

  /**
   * `1.2.840.10045.3.0.6`: ANSI X9.62 named elliptic curve
   */
  public val c2tnb191v2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10045 3 0 6"
      )

  /**
   * `1.2.840.10045.3.0.7`: ANSI X9.62 named elliptic curve
   */
  public val c2tnb191v3: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10045 3 0 7"
      )

  /**
   * `1.2.840.10045.3.0.11`: ANSI X9.62 named elliptic curve
   */
  public val c2tnb239v1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10045 3 0 11"
      )

  /**
   * `1.2.840.10045.3.0.12`: ANSI X9.62 named elliptic curve
   */
  public val c2tnb239v2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10045 3 0 12"
      )

  /**
   * `1.2.840.10045.3.0.13`: ANSI X9.62 named elliptic curve
   */
  public val c2tnb239v3: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10045 3 0 13"
      )

  /**
   * `1.2.840.10045.3.0.18`: ANSI X9.62 named elliptic curve
   */
  public val c2tnb359v1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10045 3 0 18"
      )

  /**
   * `1.2.840.10045.3.0.20`: ANSI X9.62 named elliptic curve
   */
  public val c2tnb431r1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10045 3 0 20"
      )

  /**
   * `2.16.840.1.101.2.1.5.60`: SDN.700 INFOSEC attributes
   */
  public val cAClearanceConstraint: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 5 60"
      )

  /**
   * `1.3.6.1.4.1.311.21.1`: Microsoft attribute.  Also assigned as certsrvCaVersion
   */
  public val cAKeyCertIndexPair: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 21 1"
      )

  /**
   * `2.5.29.25`: X.509 extension.  Deprecated, use 2 5 29 31 instead
   */
  public val cRLDistributionPoints: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 25"
      )

  /**
   * `2.5.29.31`: X.509 extension
   */
  public val cRLDistributionPoints_2_5_29_31: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 31"
      )

  /**
   * `2.5.29.20`: X.509 extension
   */
  public val cRLNumber: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 20"
      )

  /**
   * `2.5.29.21`: X.509 extension
   */
  public val cRLReason: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 21"
      )

  /**
   * `2.5.29.44`: X.509 extension
   */
  public val cRLScope: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 44"
      )

  /**
   * `2.5.29.40`: X.509 extension
   */
  public val cRLStreamIdentifier: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 40"
      )

  /**
   * `2.5.4.37`: X.520 DN component
   */
  public val caCertificate: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 37"
      )

  /**
   * `1.3.6.1.4.1.311.21.5`: Microsoft extended key usage
   */
  public val caExchange: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 21 5"
      )

  /**
   * `1.3.6.1.5.5.7.48.2`: PKIX subject/authority info access descriptor
   */
  public val caIssuers: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 48 2"
      )

  /**
   * `1.3.6.1.5.5.7.4.5`: PKIX CMP information
   */
  public val caKeyUpdateInfo: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 4 5"
      )

  /**
   * `1.3.6.1.5.5.7.4.1`: PKIX CMP information
   */
  public val caProtEncCert: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 4 1"
      )

  /**
   * `1.3.6.1.5.5.7.48.5`: PKIX subject/authority info access descriptor
   */
  public val caRepository: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 48 5"
      )

  /**
   * `1.2.840.10040.2.2`: ANSI X9.57 hold instruction
   */
  public val callissuer: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10040 2 2"
      )

  /**
   * `1.2.840.113549.1.9.15.2`: sMIMECapabilities
   */
  public val canNotDecryptAny: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 15 2"
      )

  /**
   * `1.2.840.113549.1.9.16.11`: S/MIME
   */
  public val capabilities: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 11"
      )

  /**
   * `2.16.840.1.101.2.1.3.13`: SDN.700 INFOSEC policy
   */
  public val capcoMarkings: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 3 13"
      )

  /**
   * `2.16.840.1.101.2.1.3.13.0`: SDN.700 INFOSEC policy CAPCO markings
   */
  public val capcoSecurityCategories: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 3 13 0"
      )

  /**
   * `2.16.840.1.101.2.1.3.13.0.1`: SDN.700 INFOSEC policy CAPCO markings
   */
  public val capcoTagSetName1: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 3 13 0 1"
      )

  /**
   * `2.16.840.1.101.2.1.3.13.0.2`: SDN.700 INFOSEC policy CAPCO markings
   */
  public val capcoTagSetName2: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 3 13 0 2"
      )

  /**
   * `2.16.840.1.101.2.1.3.13.0.3`: SDN.700 INFOSEC policy CAPCO markings
   */
  public val capcoTagSetName3: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 3 13 0 3"
      )

  /**
   * `2.16.840.1.101.2.1.3.13.0.4`: SDN.700 INFOSEC policy CAPCO markings
   */
  public val capcoTagSetName4: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 3 13 0 4"
      )

  /**
   * `1.3.6.1.4.1.311.88`: Microsoft attribute
   */
  public val capiCom: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 88"
      )

  /**
   * `1.3.6.1.4.1.311.88.2`: Microsoft attribute
   */
  public val capiComAttribute: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 88 2"
      )

  /**
   * `1.3.6.1.4.1.311.88.2.2`: Microsoft attribute
   */
  public val capiComDocumentDescription: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 88 2 2"
      )

  /**
   * `1.3.6.1.4.1.311.88.2.1`: Microsoft attribute
   */
  public val capiComDocumentName: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 88 2 1"
      )

  /**
   * `1.3.6.1.4.1.311.88.3.1`: Microsoft attribute
   */
  public val capiComEncryptedContent: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 88 3 1"
      )

  /**
   * `1.3.6.1.4.1.311.88.3`: Microsoft attribute
   */
  public val capiComEncryptedData: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 88 3"
      )

  /**
   * `1.3.6.1.4.1.311.88.1`: Microsoft attribute
   */
  public val capiComVersion: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 88 1"
      )

  /**
   * `1.3.6.1.5.5.7.3.18`: PKIX key purpose
   */
  public val capwapAC: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 3 18"
      )

  /**
   * `1.3.6.1.5.5.7.3.19`: PKIX key purpose
   */
  public val capwapWTP: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 3 19"
      )

  /**
   * `2.16.840.1.113730.3.1.1`: Netscape LDAP definitions
   */
  public val carLicense: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113730 3 1 1"
      )

  /**
   * `2.23.42.7.3`: SET cert extension
   */
  public val cardCertRequired: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 7 3"
      )

  /**
   * `1.3.6.1.4.1.25054.3.6`: Carillon security
   */
  public val carillonCommercialCE: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 25054 3 6"
      )

  /**
   * `1.3.6.1.4.1.25054.3.4`: Carillon security
   */
  public val carillonCommercialCMS: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 25054 3 4"
      )

  /**
   * `1.3.6.1.4.1.25054.3.5`: Carillon security
   */
  public val carillonCommercialLSAP: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 25054 3 5"
      )

  /**
   * `1.3.6.1.4.1.25054.3.7`: Carillon security
   */
  public val carillonCommercialLicense: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 25054 3 7"
      )

  /**
   * `1.3.6.1.4.1.25054.3.1`: Carillon security
   */
  public val carillonCommercialPKI: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 25054 3 1"
      )

  /**
   * `1.3.6.1.4.1.25054.3.3`: Carillon security
   */
  public val carillonCommercialSCVP: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 25054 3 3"
      )

  /**
   * `1.3.6.1.4.1.25054.3.8`: Carillon security
   */
  public val carillonCommercialSecret: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 25054 3 8"
      )

  /**
   * `1.3.6.1.4.1.25054.3.2`: Carillon security
   */
  public val carillonCommercialTSA: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 25054 3 2"
      )

  /**
   * `1.3.6.1.4.1.25054.3.4.1`: Carillon security
   */
  public val carillonExtKeyUsageCIVCardAuth: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 25054 3 4 1"
      )

  /**
   * `1.3.6.1.4.1.25054.3.4.2`: Carillon security
   */
  public val carillonExtKeyUsageCIVContentSigning: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 25054 3 4 2"
      )

  /**
   * `1.3.6.1.4.1.25054.3.5.1`: Carillon security
   */
  public val carillonExtKeyUsageLSAPCodeSigning: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 25054 3 5 1"
      )

  /**
   * `1.3.6.1.4.1.25054.3.7.1`: Carillon security
   */
  public val carillonExtKeyUsageLicenseSigning: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 25054 3 7 1"
      )

  /**
   * `1.3.6.1.4.1.25054.3.3.1`: Carillon security
   */
  public val carillonSCVPExtendedStatusInfo: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 25054 3 3 1"
      )

  /**
   * `1.3.6.1.4.1.25054.3`: Carillon security
   */
  public val carillonSecurity: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 25054 3"
      )

  /**
   * `1.2.840.113533.7.66.3`: Nortel Secure Networks alg
   */
  public val cast3CBC: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113533 7 66 3"
      )

  /**
   * `1.2.840.113533.7.66.10`: Nortel Secure Networks alg
   */
  public val cast5CBC: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113533 7 66 10"
      )

  /**
   * `1.2.840.113533.7.66.11`: Nortel Secure Networks alg
   */
  public val cast5MAC: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113533 7 66 11"
      )

  /**
   * `1.3.6.1.4.1.311.12`: Microsoft attribute
   */
  public val catalog: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 12"
      )

  /**
   * `1.3.6.1.4.1.311.12.1.1`: Microsoft attribute
   */
  public val catalogList: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 12 1 1"
      )

  /**
   * `1.3.6.1.4.1.311.12.1.2`: Microsoft attribute
   */
  public val catalogListMember: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 12 1 2"
      )

  /**
   * `1.3.6.1.4.1.311.12.2.2`: Microsoft attribute
   */
  public val catalogMemberInfoObjID: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 12 2 2"
      )

  /**
   * `1.3.6.1.4.1.311.12.2.1`: Microsoft attribute
   */
  public val catalogNameValueObjID: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 12 2 1"
      )

  /**
   * `1.2.840.113549.1.9.16.1.44`: S/MIME Content Types
   */
  public val cbor: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 1 44"
      )

  /**
   * `1.2.840.113549.1.9.16.1.45`: S/MIME Content Types
   */
  public val cborSequence: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 1 45"
      )

  /**
   * `1.2.840.113549.1.9.16.2.30`: S/MIME Authenticated Attributes
   */
  public val cekReference: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 30"
      )

  /**
   * `1.3.36.8.6.1`: Teletrust signature attributes
   */
  public val cert: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 6 1"
      )

  /**
   * `0.2.262.1.10.12`: Telesec
   */
  public val certAndCrlExtensionDefinitions: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 12"
      )

  /**
   * `1.2.840.113549.1.9.16.2.26`: S/MIME Authenticated Attributes
   */
  public val certCRLTimestamp: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 26"
      )

  /**
   * `1.2.840.113549.1.9.16.4.1`: S/MIME Certificate Distribution
   */
  public val certDist_ldap: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 4 1"
      )

  /**
   * `2.23.42.7`: SET
   */
  public val certExt: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 7"
      )

  /**
   * `1.3.36.8.3.13`: Teletrust OCSP attribute
   */
  public val certHash: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 3 13"
      )

  /**
   * `1.3.36.8.3.12`: Teletrust OCSP attribute (obsolete)
   */
  public val certInDirSince: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 3 12"
      )

  /**
   * `1.3.6.1.4.1.311.10.11.28`: Microsoft
   */
  public val certIssuerSerialNumberMd5HashPropId: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 10 11 28"
      )

  /**
   * `1.3.6.1.4.1.311.10.11.20`: Microsoft
   */
  public val certKeyIdentifierPropId: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 10 11 20"
      )

  /**
   * `1.3.6.1.4.1.311.20.3`: Microsoft
   */
  public val certManifold: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 20 3"
      )

  /**
   * `1.3.6.1.4.1.311.10.11.4`: Microsoft
   */
  public val certMd5HashPropId: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 10 11 4"
      )

  /**
   * `1.3.6.1.4.1.311.10.11`: Microsoft
   */
  public val certPropIdPrefix: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 10 11"
      )

  /**
   * `1.3.36.8.6.2`: Teletrust signature attributes
   */
  public val certRef: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 6 2"
      )

  /**
   * `1.3.6.1.5.5.7.5.2.2`: PKIX CRMF registration control
   */
  public val certReq: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 5 2 2"
      )

  /**
   * `1.3.6.1.4.1.311.2.1.14`: Microsoft
   */
  public val certReqExtensions: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 2 1 14"
      )

  /**
   * `2.16.840.1.113730.2.5`: Netscape data type
   */
  public val certSequence: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113730 2 5"
      )

  /**
   * `1.3.6.1.4.1.311.21.2`: Microsoft
   */
  public val certSrvPreviousCertHash: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 21 2"
      )

  /**
   * `1.3.6.1.4.1.311.10.11.29`: Microsoft
   */
  public val certSubjectNameMd5HashPropId: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 10 11 29"
      )

  /**
   * `1.3.6.1.4.1.311.10.1`: Microsoft contentType
   */
  public val certTrustList: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 10 1"
      )

  /**
   * `1.3.6.1.4.1.311.10.3.1`: Microsoft extended key usage
   */
  public val certTrustListSigning: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 10 3 1"
      )

  /**
   * `1.2.840.113549.1.9.22`: PKCS #9 via PKCS #12
   */
  public val certTypes_for_PKCS_12: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 22"
      )

  /**
   * `2.16.840.1.113730.2.6`: Netscape certificate extension
   */
  public val certURL: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113730 2 6"
      )

  /**
   * `1.2.840.113549.1.9.16.2.23`: S/MIME Authenticated Attributes
   */
  public val certValues: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 23"
      )

  /**
   * `2.23.42.3.0`: SET attribute
   */
  public val cert_2_23_42_3_0: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 3 0"
      )

  /**
   * `2.16.840.1.113730.1`: Netscape
   */
  public val cert_extension: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113730 1"
      )

  /**
   * `2.5.6.16`: X.520 objectClass
   */
  public val certificateAuthority: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 6 16"
      )

  /**
   * `2.5.29.29`: X.509 extension
   */
  public val certificateIssuer: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 29"
      )

  /**
   * `0.2.262.1.10.7.3`: Telesec attribute
   */
  public val certificateNumber: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 7 3"
      )

  /**
   * `2.5.29.3`: X.509 extension.  Deprecated, use 2 5 29 32 instead
   */
  public val certificatePolicies: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 3"
      )

  /**
   * `2.5.29.32`: X.509 extension
   */
  public val certificatePolicies_2_5_29_32: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 32"
      )

  /**
   * `2.5.4.69`: X.520 DN component
   */
  public val certificatePolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 69"
      )

  /**
   * `1.2.840.113549.1.9.16.2.21`: S/MIME Authenticated Attributes
   */
  public val certificateRefs: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 21"
      )

  /**
   * `0.2.262.1.10.7.4`: Telesec attribute
   */
  public val certificateRevocationList: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 7 4"
      )

  /**
   * `2.5.4.39`: X.520 DN component
   */
  public val certificateRevocationList_2_5_4_39: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 39"
      )

  /**
   * `1.3.6.1.4.1.311.21.7`: Microsoft CAPICOM certificate template, V2
   */
  public val certificateTemplate: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 21 7"
      )

  /**
   * `0.2.262.1.10.7.29`: Telesec attribute
   */
  public val certificateTemplateList: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 7 29"
      )

  /**
   * `0.2.262.1.10.7.1`: Telesec attribute
   */
  public val certificateType: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 7 1"
      )

  /**
   * `2.23.42.7.1`: SET cert extension
   */
  public val certificateType_2_23_42_7_1: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 7 1"
      )

  /**
   * `0.2.262.1.10.2.2`: Telesec module
   */
  public val certificateTypes: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 2 2"
      )

  /**
   * `1.3.6.1.5.5.7.1.16`: PKIX private extension
   */
  public val certificateWarranty: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 1 16"
      )

  /**
   * `1.2.36.75878867.1.100.1.1`: Certificates Australia CA
   */
  public val certificatesAustraliaPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 75878867 1 100 1 1"
      )

  /**
   * `2.5.4.68`: X.520 DN component
   */
  public val certificationPracticeStmt: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 68"
      )

  /**
   * `1.2.840.113549.1.9.16.10.3`: S/MIME X.400 Encoded Information Types
   */
  public val certsOnly: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 10 3"
      )

  /**
   * `1.3.6.1.4.1.311.21.22`: Microsoft
   */
  public val certsrvCrossCaVersion: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 21 22"
      )

  /**
   * `1.2.840.113549.1.9.16.3.18`: S/MIME Algorithms
   */
  public val chaCha20Poly1305: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 3 18"
      )

  /**
   * `1.2.840.113549.1.9.7`: PKCS #9
   */
  public val challengePassword: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 7"
      )

  /**
   * `1.2.840.10045.1.2.3`: ANSI X9.62 field type
   */
  public val characteristic_two_basis: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10045 1 2 3"
      )

  /**
   * `1.2.840.10045.1.2`: ANSI X9.62 field type
   */
  public val characteristic_two_field: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10045 1 2"
      )

  /**
   * `1.3.6.1.5.5.7.10.3`: PKIX attribute certificate extension
   */
  public val chargingIdentity: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 10 3"
      )

  /**
   * `1.2.840.113556.1.3.13`: Microsoft Exchange Server - object class
   */
  public val classSchema: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113556 1 3 13"
      )

  /**
   * `2.5.4.55`: X.520 DN component
   */
  public val clearance: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 55"
      )

  /**
   * `1.3.6.1.5.5.7.1.21`: PKIX private extension
   */
  public val clearanceConstraints: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 1 21"
      )

  /**
   * `1.3.6.1.5.5.7.3.2`: PKIX key purpose
   */
  public val clientAuth: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 3 2"
      )

  /**
   * `1.3.6.1.5.5.7.3.32`: PKIX key purpose
   */
  public val cmKGA: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 3 32"
      )

  /**
   * `1.3.6.1.4.1.311.10.10.1`: Microsoft
   */
  public val cmcAddAttributes: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 10 10 1"
      )

  /**
   * `1.3.6.1.5.5.7.3.29`: PKIX key purpose
   */
  public val cmcArchive: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 3 29"
      )

  /**
   * `1.3.6.1.5.5.7.3.27`: PKIX key purpose
   */
  public val cmcCA: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 3 27"
      )

  /**
   * `1.3.6.1.5.5.7.7`: PKIX
   */
  public val cmcControls: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 7"
      )

  /**
   * `1.3.6.1.5.5.7.3.28`: PKIX key purpose
   */
  public val cmcRA: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 3 28"
      )

  /**
   * `1.2.840.113549.1.9.16.2.34`: S/MIME Authenticated Attributes
   */
  public val cmcUnsignedData: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 34"
      )

  /**
   * `1.3.6.1.5.5.7.4`: PKIX
   */
  public val cmpInformationTypes: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 4"
      )

  /**
   * `1.2.840.113549.1.9.16.3.6`: S/MIME Algorithms
   */
  public val cms3DESwrap: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 3 6"
      )

  /**
   * `1.2.840.113549.1.9.16.2.52`: S/MIME Authenticated Attributes
   */
  public val cmsAlgorithmProtect: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 52"
      )

  /**
   * `1.2.840.113549.1.9.52`: RFC 6211
   */
  public val cmsAlgorithmProtection: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 52"
      )

  /**
   * `1.3.6.1.5.5.7.1.18`: PKIX private extension
   */
  public val cmsContentConstraints: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 1 18"
      )

  /**
   * `1.2.840.113549.1.9.16.3.7`: S/MIME Algorithms
   */
  public val cmsRC2wrap: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 3 7"
      )

  /**
   * `1.3.6.1.5.5.7.3.3`: PKIX key purpose
   */
  public val codeSigning: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 3 3"
      )

  /**
   * `2.23.140.1.4.1`: CAB Certificate Policies
   */
  public val codeSigningRequirements: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 140 1 4 1"
      )

  /**
   * `2.5.4.23.1`: X.520 DN component
   */
  public val collectiveFacsimileTelephoneNumber: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 23 1"
      )

  /**
   * `2.5.4.25.1`: X.520 DN component
   */
  public val collectiveInternationalISDNNumber: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 25 1"
      )

  /**
   * `2.5.4.7.1`: X.520 DN component
   */
  public val collectiveLocalityName: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 7 1"
      )

  /**
   * `2.5.4.10.1`: X.520 DN component
   */
  public val collectiveOrganizationName: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 10 1"
      )

  /**
   * `2.5.4.11.1`: X.520 DN component
   */
  public val collectiveOrganizationalUnitName: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 11 1"
      )

  /**
   * `2.5.4.19.1`: X.520 DN component
   */
  public val collectivePhysicalDeliveryOfficeName: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 19 1"
      )

  /**
   * `2.5.4.18.1`: X.520 DN component
   */
  public val collectivePostOfficeBox: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 18 1"
      )

  /**
   * `2.5.4.16.1`: X.520 DN component
   */
  public val collectivePostalAddress: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 16 1"
      )

  /**
   * `2.5.4.17.1`: X.520 DN component
   */
  public val collectivePostalCode: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 17 1"
      )

  /**
   * `2.5.4.8.1`: X.520 DN component
   */
  public val collectiveStateOrProvinceName: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 8 1"
      )

  /**
   * `2.5.4.9.1`: X.520 DN component
   */
  public val collectiveStreetAddress: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 9 1"
      )

  /**
   * `2.5.4.20.1`: X.520 DN component
   */
  public val collectiveTelephoneNumber: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 20 1"
      )

  /**
   * `2.5.4.22.1`: X.520 DN component
   */
  public val collectiveTeletexTerminalIdentifier: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 22 1"
      )

  /**
   * `2.5.4.21.1`: X.520 DN component
   */
  public val collectiveTelexNumber: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 21 1"
      )

  /**
   * `2.16.840.1.101.2.1.5.56`: SDN.700 INFOSEC attributes
   */
  public val commPrivileges: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 5 56"
      )

  /**
   * `1.3.6.1.4.1.311.2.1.22`: Microsoft
   */
  public val commercialCodeSigning: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 2 1 22"
      )

  /**
   * `1.2.840.113549.1.9.16.2.16`: S/MIME Authenticated Attributes
   */
  public val commitmentType: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 16"
      )

  /**
   * `2.5.4.3`: X.520 DN component
   */
  public val commonName: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 3"
      )

  /**
   * `2.5.4.67`: X.520 DN component
   */
  public val communicationsNetwork: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 67"
      )

  /**
   * `2.5.4.66`: X.520 DN component
   */
  public val communicationsService: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 66"
      )

  /**
   * `1.3.6.1.4.1.6449.1.3.5.2`: Comodo CA
   */
  public val comodoCertifiedDeliveryService: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 6449 1 3 5 2"
      )

  /**
   * `1.3.6.1.4.1.6449.1.2.1.3.1`: Comodo CA
   */
  public val comodoPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 6449 1 2 1 3 1"
      )

  /**
   * `1.3.6.1.4.1.6449.2.1.1`: Comodo CA
   */
  public val comodoTimestampingPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 6449 2 1 1"
      )

  /**
   * `1.2.840.113549.1.9.16.1.9`: S/MIME Content Types
   */
  public val compressedData: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 1 9"
      )

  /**
   * `1.2.840.113549.1.9.16.10.7`: S/MIME X.400 Encoded Information Types
   */
  public val compressedData_1_2_840_113549_1_9_16_10_7: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 10 7"
      )

  /**
   * `2.5.4.60`: X.520 DN component
   */
  public val confKeyInfo: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 60"
      )

  /**
   * `1.3.6.1.5.5.7.4.14`: PKIX CMP information
   */
  public val confirmWaitTime: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 4 14"
      )

  /**
   * `1.2.840.113556.1.3.23`: Microsoft Exchange Server - object class
   */
  public val container: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113556 1 3 23"
      )

  /**
   * `1.2.840.113549.1.9.16.1.19`: S/MIME Content Types
   */
  public val contentCollection: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 1 19"
      )

  /**
   * `2.16.840.1.101.2.1.5.66`: SDN.700 INFOSEC attributes and RFC 6032
   */
  public val contentDecryptKeyID: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 5 66"
      )

  /**
   * `1.2.840.113549.1.9.16.2.4`: S/MIME Authenticated Attributes
   */
  public val contentHint: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 4"
      )

  /**
   * `1.2.840.113549.1.9.15.5`: sMIMECapabilities. Deprecated, use (1 2 840 113549 1 9 16 2 4)
   * instead
   */
  public val contentHints: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 15 5"
      )

  /**
   * `1.2.840.113549.1.9.16.2.7`: S/MIME Authenticated Attributes
   */
  public val contentIdentifier: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 7"
      )

  /**
   * `1.2.840.113549.1.9.16.1.6`: S/MIME Content Types
   */
  public val contentInfo: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 1 6"
      )

  /**
   * `1.2.840.113549.1.9.16.2.10`: S/MIME Authenticated Attributes
   */
  public val contentReference: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 10"
      )

  /**
   * `1.2.840.113549.1.9.16.2.20`: S/MIME Authenticated Attributes
   */
  public val contentTimestamp: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 20"
      )

  /**
   * `1.2.840.113549.1.9.3`: PKCS #9
   */
  public val contentType: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 3"
      )

  /**
   * `1.2.840.113549.1.9.16.1`: S/MIME
   */
  public val contentType_1_2_840_113549_1_9_16_1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 1"
      )

  /**
   * `2.23.42.0`: SET
   */
  public val contentType_2_23_42_0: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 0"
      )

  /**
   * `2.5.4.81`: X.520 DN component
   */
  public val contentUrl: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 81"
      )

  /**
   * `1.2.840.113549.1.9.16.1.20`: S/MIME Content Types
   */
  public val contentWithAttrs: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 1 20"
      )

  /**
   * `1.2.840.10040.3.1`: ANSI X9.57 attribute
   */
  public val countersignature: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10040 3 1"
      )

  /**
   * `1.2.840.113549.1.9.6`: PKCS #9
   */
  public val countersignature_1_2_840_113549_1_9_6: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 6"
      )

  /**
   * `2.5.6.2`: X.520 objectClass
   */
  public val country: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 6 2"
      )

  /**
   * `2.5.4.98`: X.520 DN component
   */
  public val countryCode3c: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 98"
      )

  /**
   * `2.5.4.99`: X.520 DN component
   */
  public val countryCode3n: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 99"
      )

  /**
   * `2.5.4.6`: X.520 DN component
   */
  public val countryName: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 6"
      )

  /**
   * `1.3.6.1.5.5.7.9.4`: PKIX personal data
   */
  public val countryOfCitizenship: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 9 4"
      )

  /**
   * `1.3.6.1.5.5.7.9.5`: PKIX personal data
   */
  public val countryOfResidence: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 9 5"
      )

  /**
   * `1.3.6.1.5.5.7.2.1`: PKIX policy qualifier
   */
  public val cps: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 2 1"
      )

  /**
   * `0.2.262.1.10.7.5`: Telesec attribute
   */
  public val creationDate: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 7 5"
      )

  /**
   * `1.3.6.1.4.1.3029.3.1.4`: cryptlib attribute type
   */
  public val crlExtReason: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 3029 3 1 4"
      )

  /**
   * `1.3.6.1.4.1.311.21.4`: Microsoft
   */
  public val crlNextPublish: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 21 4"
      )

  /**
   * `1.3.6.1.4.1.311.21.14`: Microsoft
   */
  public val crlSelfCDP: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 21 14"
      )

  /**
   * `1.2.840.113549.1.9.23`: PKCS #9 via PKCS #12
   */
  public val crlTypes_for_PKCS_12: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 23"
      )

  /**
   * `1.3.6.1.4.1.311.21.3`: Microsoft
   */
  public val crlVirtualBase: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 21 3"
      )

  /**
   * `1.3.6.1.5.5.7.5`: PKIX
   */
  public val crmfRegistration: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 5"
      )

  /**
   * `1.3.6.1.4.1.311.10.9.1`: Microsoft attribute
   */
  public val crossCertDistPoints: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 10 9 1"
      )

  /**
   * `2.5.4.40`: X.520 DN component
   */
  public val crossCertificatePair: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 40"
      )

  /**
   * `1.3.6.1.4.1.3029.4.1.1`: cryptlib content type
   */
  public val cryptlibConfigData: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 3029 4 1 1"
      )

  /**
   * `1.3.6.1.4.1.3029.4.1`: cryptlib
   */
  public val cryptlibContent: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 3029 4 1"
      )

  /**
   * `1.3.6.1.4.1.3029.3.1.1`: cryptlib attribute type
   */
  public val cryptlibPresenceCheck: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 3029 3 1 1"
      )

  /**
   * `1.3.6.1.4.1.3029.4.1.2`: cryptlib content type
   */
  public val cryptlibUserIndex: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 3029 4 1 2"
      )

  /**
   * `1.3.6.1.4.1.3029.4.1.3`: cryptlib content type
   */
  public val cryptlibUserInfo: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 3029 4 1 3"
      )

  /**
   * `1.2.643.7.1.2.1.1.1`: CryptoPro ell.curve A for GOST R 34.10-2012 256 bit
   */
  public val cryptoPro2012Sign256A: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 7 1 2 1 1 1"
      )

  /**
   * `1.2.643.7.1.2.1.2.1`: CryptoPro ell.curve A (default) for GOST R 34.10-2012 512 bit
   */
  public val cryptoPro2012Sign512A: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 7 1 2 1 2 1"
      )

  /**
   * `1.2.643.7.1.2.1.2.2`: CryptoPro ell.curve B for GOST R 34.10-2012 512 bit
   */
  public val cryptoPro2012Sign512B: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 7 1 2 1 2 2"
      )

  /**
   * `1.2.643.7.1.2.1.2.3`: CryptoPro ell.curve C for GOST R 34.10-2012 512 bit
   */
  public val cryptoPro2012Sign512C: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 7 1 2 1 2 3"
      )

  /**
   * `1.2.643.2.2.32.2`: CryptoPro sign params A (default, variant 'Verba-O') for GOST R 34.10-94
   */
  public val cryptoPro94SignA: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 2 2 32 2"
      )

  /**
   * `1.2.643.2.2.32.3`: CryptoPro sign params B (variant 1) for GOST R 34.10-94
   */
  public val cryptoPro94SignB: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 2 2 32 3"
      )

  /**
   * `1.2.643.2.2.32.4`: CryptoPro sign params C (variant 2) for GOST R 34.10-94
   */
  public val cryptoPro94SignC: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 2 2 32 4"
      )

  /**
   * `1.2.643.2.2.32.5`: CryptoPro sign params D (variant 3) for GOST R 34.10-94
   */
  public val cryptoPro94SignD: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 2 2 32 5"
      )

  /**
   * `1.2.643.2.2.33.1`: CryptoPro sign params XA (variant 1) for GOST R 34.10-94
   */
  public val cryptoPro94SignXA: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 2 2 33 1"
      )

  /**
   * `1.2.643.2.2.33.2`: CryptoPro sign params XB (variant 2) for GOST R 34.10-94
   */
  public val cryptoPro94SignXB: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 2 2 33 2"
      )

  /**
   * `1.2.643.2.2.33.3`: CryptoPro sign params XC (variant 3) for GOST R 34.10-94
   */
  public val cryptoPro94SignXC: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 2 2 33 3"
      )

  /**
   * `1.2.643.2.2.31.1`: CryptoPro params A (default, variant 'Verba-O') for GOST 28147-89
   */
  public val cryptoProCipherA: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 2 2 31 1"
      )

  /**
   * `1.2.643.2.2.31.2`: CryptoPro params B (variant 1) for GOST 28147-89
   */
  public val cryptoProCipherB: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 2 2 31 2"
      )

  /**
   * `1.2.643.2.2.31.3`: CryptoPro params C (variant 2) for GOST 28147-89
   */
  public val cryptoProCipherC: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 2 2 31 3"
      )

  /**
   * `1.2.643.2.2.31.4`: CryptoPro params D (variant 3) for GOST 28147-89
   */
  public val cryptoProCipherD: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 2 2 31 4"
      )

  /**
   * `1.2.643.100.113.6`: CryptoPro GOST
   */
  public val cryptoProClassSignToolKA1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 100 113 6"
      )

  /**
   * `1.2.643.100.113.4`: CryptoPro GOST
   */
  public val cryptoProClassSignToolKB1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 100 113 4"
      )

  /**
   * `1.2.643.100.113.5`: CryptoPro GOST
   */
  public val cryptoProClassSignToolKB2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 100 113 5"
      )

  /**
   * `1.2.643.100.113.1`: CryptoPro GOST
   */
  public val cryptoProClassSignToolKC1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 100 113 1"
      )

  /**
   * `1.2.643.100.113.2`: CryptoPro GOST
   */
  public val cryptoProClassSignToolKC2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 100 113 2"
      )

  /**
   * `1.2.643.100.113.3`: CryptoPro GOST
   */
  public val cryptoProClassSignToolKC3: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 100 113 3"
      )

  /**
   * `1.2.643.2.2.30.1`: CryptoPro digest params A (default, variant 'Verba-O') for GOST R 34.11-94
   */
  public val cryptoProDigestA: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 2 2 30 1"
      )

  /**
   * `1.2.643.2.2.30.2`: CryptoPro digest params B (variant 1) for GOST R 34.11-94
   */
  public val cryptoProDigestB: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 2 2 30 2"
      )

  /**
   * `1.2.643.2.2.30.3`: CryptoPro digest params C (variant 2) for GOST R 34.11-94
   */
  public val cryptoProDigestC: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 2 2 30 3"
      )

  /**
   * `1.2.643.2.2.30.4`: CryptoPro digest params D (variant 3) for GOST R 34.11-94
   */
  public val cryptoProDigestD: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 2 2 30 4"
      )

  /**
   * `1.2.643.7.1.1.6.1`: CryptoPro ECC DH algorithm for GOST R 34.10-2012 256 bit key
   */
  public val cryptoProECDH256: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 7 1 1 6 1"
      )

  /**
   * `1.2.643.7.1.1.6.2`: CryptoPro ECC DH algorithm for GOST R 34.10-2012 512 bit key
   */
  public val cryptoProECDH512: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 7 1 1 6 2"
      )

  /**
   * `1.2.643.2.2.96`: Wrap key using ECC DH on GOST R 34.10-2001 keys (VKO)
   */
  public val cryptoProECDHWrap: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 2 2 96"
      )

  /**
   * `1.2.643.2.2.14.1`: CryptoPro meshing of state of GOST 28147-89 cipher
   */
  public val cryptoProMeshing: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 2 2 14 1"
      )

  /**
   * `1.2.643.2.2.35.1`: CryptoPro ell.curve A for GOST R 34.10-2001
   */
  public val cryptoProSignA: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 2 2 35 1"
      )

  /**
   * `1.2.643.2.2.35.2`: CryptoPro ell.curve B for GOST R 34.10-2001
   */
  public val cryptoProSignB: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 2 2 35 2"
      )

  /**
   * `1.2.643.2.2.35.3`: CryptoPro ell.curve C for GOST R 34.10-2001
   */
  public val cryptoProSignC: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 2 2 35 3"
      )

  /**
   * `1.2.643.2.2.36.0`: CryptoPro ell.curve XA for GOST R 34.10-2001
   */
  public val cryptoProSignXA: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 2 2 36 0"
      )

  /**
   * `1.2.643.2.2.36.1`: CryptoPro ell.curve XB for GOST R 34.10-2001
   */
  public val cryptoProSignXB: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 2 2 36 1"
      )

  /**
   * `1.2.643.2.2.13.1`: Wrap key using diversified GOST 28147-89 key
   */
  public val cryptoProWrap: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 2 2 13 1"
      )

  /**
   * `2.16.840.1.101.2.1.2.3`: SDN.700 INFOSEC format
   */
  public val cspContentType: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 2 3"
      )

  /**
   * `2.16.840.1.101.2.1.7.1.0`: SDN.700 INFOSEC extensions
   */
  public val cspCsExtn: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 7 1 0"
      )

  /**
   * `2.16.840.1.101.2.1.7.1`: SDN.700 INFOSEC extensions
   */
  public val cspExtns: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 7 1"
      )

  /**
   * `2.16.840.1.101.2.1.2.75`: SDN.700 INFOSEC format
   */
  public val cspForwardedMessageParameters: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 2 75"
      )

  /**
   * `1.3.6.1.4.1.311.10.3.16`: Microsoft extended key usage
   */
  public val cspSignature: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 10 3 16"
      )

  /**
   * `1.3.6.1.4.1.311.2.2`: Microsoft CTL
   */
  public val ctl: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 2 2"
      )

  /**
   * `0.2.262.1.10.7.27`: Telesec attribute
   */
  public val ctlFileIsArchive: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 7 27"
      )

  /**
   * `1.3.6.1.4.1.311.2.2.2`: Microsoft CTL
   */
  public val ctlTrustedClientAuthCAList: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 2 2 2"
      )

  /**
   * `1.3.6.1.4.1.311.2.2.1`: Microsoft CTL
   */
  public val ctlTrustedCodesigningCAList: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 2 2 1"
      )

  /**
   * `1.3.6.1.4.1.311.2.2.3`: Microsoft CTL
   */
  public val ctlTrustedServerAuthCAList: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 2 2 3"
      )

  /**
   * `1.3.6.1.5.5.7.4.6`: PKIX CMP information
   */
  public val currentCRL: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 4 6"
      )

  /**
   * `1.3.6.1.4.1.11591.15.1`: GNU encryption algorithm
   */
  public val curve25519: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 11591 15 1"
      )

  /**
   * `1.3.6.1.4.1.11591.15.3`: GNU encryption algorithm
   */
  public val curve25519ph: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 11591 15 3"
      )

  /**
   * `1.3.6.1.4.1.11591.15.2`: GNU encryption algorithm
   */
  public val curve448: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 11591 15 2"
      )

  /**
   * `1.3.6.1.4.1.11591.15.4`: GNU encryption algorithm
   */
  public val curve448ph: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 11591 15 4"
      )

  /**
   * `1.3.101.112`: EdDSA 25519 signature algorithm
   */
  public val curveEd25519: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 101 112"
      )

  /**
   * `1.3.101.114`: EdDSA 25519 pre-hash signature algorithm
   */
  public val curveEd25519ph: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 101 114"
      )

  /**
   * `1.3.101.113`: EdDSA 448 signature algorithm
   */
  public val curveEd448: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 101 113"
      )

  /**
   * `1.3.101.115`: EdDSA 448 pre-hash signature algorithm
   */
  public val curveEd448ph: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 101 115"
      )

  /**
   * `1.3.101.110`: ECDH 25519 key agreement algorithm
   */
  public val curveX25519: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 101 110"
      )

  /**
   * `1.3.101.111`: ECDH 448 key agreement algorithm
   */
  public val curveX448: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 101 111"
      )

  /**
   * `1.3.6.1.5.2.3.2`: Kerberos
   */
  public val dHKeyData: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 2 3 2"
      )

  /**
   * `2.5.6.13`: X.520 objectClass
   */
  public val dSA: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 6 13"
      )

  /**
   * `1.2.840.113549.1.9.16.1.7`: S/MIME Content Types
   */
  public val dVCSRequestData: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 1 7"
      )

  /**
   * `1.2.840.113549.1.9.16.1.8`: S/MIME Content Types
   */
  public val dVCSResponseData: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 1 8"
      )

  /**
   * `1.2.840.113549.1.7.1`: PKCS #7
   */
  public val `data`: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 7 1"
      )

  /**
   * `2.16.840.1.113730.2.1`: Netscape data type
   */
  public val dataGIF: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113730 2 1"
      )

  /**
   * `2.16.840.1.113730.2.4`: Netscape data type
   */
  public val dataHTML: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113730 2 4"
      )

  /**
   * `2.16.840.1.113730.2.2`: Netscape data type
   */
  public val dataJPEG: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113730 2 2"
      )

  /**
   * `2.16.840.1.113730.2.3`: Netscape data type
   */
  public val dataURL: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113730 2 3"
      )

  /**
   * `1.2.840.113549.1.7.7`: PKCS #7 experimental
   */
  public val dataWithAttributes: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 7 7"
      )

  /**
   * `2.16.840.1.113730.2`: Netscape
   */
  public val data_type: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113730 2"
      )

  /**
   * `2.23.42.2.7`: SET field
   */
  public val date: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 2 7"
      )

  /**
   * `1.3.6.1.5.5.7.9.1`: PKIX personal data
   */
  public val dateOfBirth: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 9 1"
      )

  /**
   * `1.3.36.8.3.1`: Teletrust attribute
   */
  public val dateOfCertGen: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 3 1"
      )

  /**
   * `1.3.12.2.1011.7.1.2`: DASS encryption algorithm
   */
  public val decDEA: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 12 2 1011 7 1 2"
      )

  /**
   * `1.3.12.2.1011.7.3.3`: DASS signature algorithm
   */
  public val decDEAMAC: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 12 2 1011 7 3 3"
      )

  /**
   * `1.3.12.2.1011.7.1`: DASS algorithm
   */
  public val decEncryptionAlgorithm: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 12 2 1011 7 1"
      )

  /**
   * `1.3.12.2.1011.7.2`: DASS algorithm
   */
  public val decHashAlgorithm: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 12 2 1011 7 2"
      )

  /**
   * `1.3.12.2.1011.7.2.1`: DASS hash algorithm
   */
  public val decMD2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 12 2 1011 7 2 1"
      )

  /**
   * `1.3.12.2.1011.7.3.1`: DASS signature algorithm
   */
  public val decMD2withRSA: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 12 2 1011 7 3 1"
      )

  /**
   * `1.3.12.2.1011.7.2.2`: DASS hash algorithm
   */
  public val decMD4: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 12 2 1011 7 2 2"
      )

  /**
   * `1.3.12.2.1011.7.3.2`: DASS signature algorithm
   */
  public val decMD4withRSA: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 12 2 1011 7 3 2"
      )

  /**
   * `1.3.12.2.1011.7.3`: DASS algorithm
   */
  public val decSignatureAlgorithm: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 12 2 1011 7 3"
      )

  /**
   * `2.16.840.1.101.2.1.5.31`: SDN.700 INFOSEC attributes
   */
  public val decUKMs: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 5 31"
      )

  /**
   * `1.3.36.8.3.5`: Teletrust attribute
   */
  public val declarationOfMajority: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 3 5"
      )

  /**
   * `2.5.4.56`: X.520 DN component
   */
  public val defaultDirQop: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 56"
      )

  /**
   * `2.16.840.1.101.2.1.3.12`: SDN.700 INFOSEC policy
   */
  public val defaultSecurityPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 3 12"
      )

  /**
   * `2.5.29.42`: X.509 extension
   */
  public val delegatedNameConstraints: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 42"
      )

  /**
   * `2.5.4.73`: X.520 DN component
   */
  public val delegationPath: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 73"
      )

  /**
   * `1.2.840.113556.1.2.241`: Microsoft Exchange Server - attribute
   */
  public val deliveryMechanism: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113556 1 2 241"
      )

  /**
   * `2.5.29.27`: X.509 extension
   */
  public val deltaCRLIndicator: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 27"
      )

  /**
   * `2.5.29.53`: X.509 extension
   */
  public val deltaInfo: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 53"
      )

  /**
   * `2.5.4.53`: X.520 DN component
   */
  public val deltaRevocationList: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 53"
      )

  /**
   * `2.16.840.1.113730.3.1.2`: Netscape LDAP definitions
   */
  public val departmentNumber: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113730 3 1 2"
      )

  /**
   * `0.2.262.1.10.1.2.2`: Telesec encryption
   */
  public val des: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 1 2 2"
      )

  /**
   * `0.2.262.1.10.1.2.3`: Telesec encryption
   */
  public val des3: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 1 2 3"
      )

  /**
   * `0.2.262.1.10.1.2.3.2`: Telesec encryption
   */
  public val des3CBC: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 1 2 3 2"
      )

  /**
   * `0.2.262.1.10.1.2.3.5`: Telesec encryption
   */
  public val des3CFB64: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 1 2 3 5"
      )

  /**
   * `0.2.262.1.10.1.2.3.4`: Telesec encryption
   */
  public val des3CFB8: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 1 2 3 4"
      )

  /**
   * `0.2.262.1.10.1.2.3.1`: Telesec encryption
   */
  public val des3ECB: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 1 2 3 1"
      )

  /**
   * `0.2.262.1.10.1.2.3.3`: Telesec encryption
   */
  public val des3OFB: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 1 2 3 3"
      )

  /**
   * `1.3.6.1.5.5.7.6.1`: PKIX algorithm
   */
  public val des40: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 6 1"
      )

  /**
   * `0.2.262.1.10.1.2.2.2`: Telesec encryption
   */
  public val desCBC: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 1 2 2 2"
      )

  /**
   * `1.3.14.3.2.7`: null
   */
  public val desCBC_1_3_14_3_2_7: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 14 3 2 7"
      )

  /**
   * `1.3.36.3.1.1.2.1.1`: Teletrust encryption algorithm
   */
  public val desCBC_ISOpad: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 1 1 2 1 1"
      )

  /**
   * `1.3.36.3.1.1.2.1`: Teletrust encryption algorithm
   */
  public val desCBC_pad: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 1 1 2 1"
      )

  /**
   * `1.2.840.113549.3.10`: RSADSI encryptionAlgorithm. Formerly called CDMFCBCPad
   */
  public val desCDMF: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 3 10"
      )

  /**
   * `1.3.14.3.2.9`: null
   */
  public val desCFB: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 14 3 2 9"
      )

  /**
   * `0.2.262.1.10.1.2.2.5`: Telesec encryption
   */
  public val desCFB64: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 1 2 2 5"
      )

  /**
   * `0.2.262.1.10.1.2.2.4`: Telesec encryption
   */
  public val desCFB8: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 1 2 2 4"
      )

  /**
   * `2.16.840.1.113719.1.2.8.22`: Novell encryption algorithm
   */
  public val desCbcIV8: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113719 1 2 8 22"
      )

  /**
   * `2.16.840.1.113719.1.2.8.23`: Novell encryption algorithm
   */
  public val desCbcPadIV8: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113719 1 2 8 23"
      )

  /**
   * `0.2.262.1.10.1.2.2.1`: Telesec encryption
   */
  public val desECB: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 1 2 2 1"
      )

  /**
   * `1.3.14.3.2.6`: null
   */
  public val desECB_1_3_14_3_2_6: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 14 3 2 6"
      )

  /**
   * `1.3.36.3.1.1.1.1`: Teletrust encryption algorithm
   */
  public val desECB_ISOpad: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 1 1 1 1"
      )

  /**
   * `1.3.36.3.1.1.1`: Teletrust encryption algorithm
   */
  public val desECB_pad: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 1 1 1"
      )

  /**
   * `1.3.14.3.2.17`: Oddball OIW OID. Mode is ECB
   */
  public val desEDE: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 14 3 2 17"
      )

  /**
   * `2.16.840.1.113719.1.2.8.24`: Novell encryption algorithm
   */
  public val desEDE2CbcIV8: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113719 1 2 8 24"
      )

  /**
   * `2.16.840.1.113719.1.2.8.25`: Novell encryption algorithm
   */
  public val desEDE2CbcPadIV8: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113719 1 2 8 25"
      )

  /**
   * `2.16.840.1.113719.1.2.8.26`: Novell encryption algorithm
   */
  public val desEDE3CbcIV8: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113719 1 2 8 26"
      )

  /**
   * `2.16.840.1.113719.1.2.8.27`: Novell encryption algorithm
   */
  public val desEDE3CbcPadIV8: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113719 1 2 8 27"
      )

  /**
   * `1.3.14.3.2.10`: null
   */
  public val desMAC: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 14 3 2 10"
      )

  /**
   * `0.2.262.1.10.1.2.2.3`: Telesec encryption
   */
  public val desOFB: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 1 2 2 3"
      )

  /**
   * `1.3.14.3.2.8`: null
   */
  public val desOFB_1_3_14_3_2_8: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 14 3 2 8"
      )

  /**
   * `1.3.36.3.1.1`: Teletrust encryption algorithm
   */
  public val des_1_3_36_3_1_1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 1 1"
      )

  /**
   * `1.3.36.3.1.3`: Teletrust encryption algorithm
   */
  public val des_3: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 1 3"
      )

  /**
   * `1.3.36.3.1.3.2.1.1`: Teletrust encryption algorithm. EDE triple DES
   */
  public val des_3CBC_ISOpad: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 1 3 2 1 1"
      )

  /**
   * `1.3.36.3.1.3.2.1`: Teletrust encryption algorithm. EDE triple DES
   */
  public val des_3CBC_pad: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 1 3 2 1"
      )

  /**
   * `1.3.36.3.1.3.1.1.1`: Teletrust encryption algorithm. EDE triple DES
   */
  public val des_3ECB_ISOpad: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 1 3 1 1 1"
      )

  /**
   * `1.3.36.3.1.3.1.1`: Teletrust encryption algorithm. EDE triple DES
   */
  public val des_3ECB_pad: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 1 3 1 1"
      )

  /**
   * `1.2.840.113549.3.7`: RSADSI encryptionAlgorithm
   */
  public val des_EDE3_CBC: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 3 7"
      )

  /**
   * `2.5.4.13`: X.520 DN component
   */
  public val description: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 13"
      )

  /**
   * `2.5.4.27`: X.520 DN component
   */
  public val destinationIndicator: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 27"
      )

  /**
   * `1.2.840.113549.3.6`: RSADSI encryptionAlgorithm
   */
  public val desx_CBC: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 3 6"
      )

  /**
   * `2.5.6.14`: X.520 objectClass
   */
  public val device: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 6 14"
      )

  /**
   * `1.2.840.10046.3.2`: ANSI X9.42 scheme
   */
  public val dhEphem: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10046 3 2"
      )

  /**
   * `1.2.840.10046.3.3`: ANSI X9.42 scheme
   */
  public val dhHybrid1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10046 3 3"
      )

  /**
   * `1.2.840.10046.3.4`: ANSI X9.42 scheme
   */
  public val dhHybrid2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10046 3 4"
      )

  /**
   * `1.2.840.113549.1.3.1`: PKCS #3
   */
  public val dhKeyAgreement: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 3 1"
      )

  /**
   * `1.3.6.1.5.5.7.6.4`: PKIX algorithm
   */
  public val dhPop: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 6 4"
      )

  /**
   * `1.3.6.1.5.5.7.6.5`: PKIX algorithm
   */
  public val dhPopSha224: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 6 5"
      )

  /**
   * `1.3.6.1.5.5.7.6.6`: PKIX algorithm
   */
  public val dhPopSha256: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 6 6"
      )

  /**
   * `1.3.6.1.5.5.7.6.7`: PKIX algorithm
   */
  public val dhPopSha384: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 6 7"
      )

  /**
   * `1.3.6.1.5.5.7.6.8`: PKIX algorithm
   */
  public val dhPopSha512: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 6 8"
      )

  /**
   * `1.3.6.1.5.5.7.6.15`: PKIX algorithm
   */
  public val dhPopStaticSha224HmacSha224: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 6 15"
      )

  /**
   * `1.3.6.1.5.5.7.6.16`: PKIX algorithm
   */
  public val dhPopStaticSha256HmacSha256: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 6 16"
      )

  /**
   * `1.3.6.1.5.5.7.6.17`: PKIX algorithm
   */
  public val dhPopStaticSha384HmacSha384: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 6 17"
      )

  /**
   * `1.3.6.1.5.5.7.6.18`: PKIX algorithm
   */
  public val dhPopStaticSha512HmacSha512: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 6 18"
      )

  /**
   * `1.2.840.10046.2.1`: ANSI X9.42 number type
   */
  public val dhPublicKey: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10046 2 1"
      )

  /**
   * `1.3.6.1.5.5.7.6.3`: PKIX algorithm
   */
  public val dhSigHmacSha1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 6 3"
      )

  /**
   * `1.2.840.10046.3.1`: ANSI X9.42 scheme
   */
  public val dhStatic: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10046 3 1"
      )

  /**
   * `1.3.14.3.2.16`: Oddball OIW OID. Deprecated, use a plain DH OID instead
   */
  public val dhWithCommonModulus: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 14 3 2 16"
      )

  /**
   * `1.2.840.113549.2`: null
   */
  public val digestAlgorithm: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 2"
      )

  /**
   * `1.2.840.113549.1.7.5`: PKCS #7
   */
  public val digestedData: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 7 5"
      )

  /**
   * `2.16.840.1.114412.1.3.0.4`: Digicert CA policy
   */
  public val digiCertAssuredIDRootCAPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 114412 1 3 0 4"
      )

  /**
   * `2.16.840.1.114412.2.4`: Digicert CA policy
   */
  public val digiCertClientCert: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 114412 2 4"
      )

  /**
   * `2.16.840.1.114412.2.3.1`: Digicert CA policy
   */
  public val digiCertCodeSigningCert: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 114412 2 3 1"
      )

  /**
   * `2.16.840.1.114412.1.2`: Digicert CA policy
   */
  public val digiCertDVCert: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 114412 1 2"
      )

  /**
   * `2.16.840.1.114412.2.3.21`: Digicert CA policy
   */
  public val digiCertDocumentSigningCert: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 114412 2 3 21"
      )

  /**
   * `2.16.840.1.114412.2.2`: Digicert CA policy
   */
  public val digiCertEVCert: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 114412 2 2"
      )

  /**
   * `2.16.840.1.114412.2.3.2`: Digicert CA policy
   */
  public val digiCertEVCodeSigningCert: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 114412 2 3 2"
      )

  /**
   * `2.16.840.1.114412.1.11`: Digicert CA policy
   */
  public val digiCertFederatedDeviceCert: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 114412 1 11"
      )

  /**
   * `2.16.840.1.114412.1.3.0.1`: Digicert CA policy
   */
  public val digiCertGlobalCAPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 114412 1 3 0 1"
      )

  /**
   * `2.16.840.1.114412.1.3.0.3`: Digicert CA policy
   */
  public val digiCertGlobalRootCAPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 114412 1 3 0 3"
      )

  /**
   * `2.16.840.1.114412.4.31`: Digicert CA policy
   */
  public val digiCertGridClassicCert: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 114412 4 31"
      )

  /**
   * `2.16.840.1.114412.31.4.31.1`: Digicert CA policy
   */
  public val digiCertGridHostCert: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 114412 31 4 31 1"
      )

  /**
   * `2.16.840.1.114412.4.31.5`: Digicert CA policy
   */
  public val digiCertGridIntegratedCert: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 114412 4 31 5"
      )

  /**
   * `2.16.840.1.114412.1.3.0.2`: Digicert CA policy
   */
  public val digiCertHighAssuranceEVCAPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 114412 1 3 0 2"
      )

  /**
   * `2.16.840.1.114412.2.3.11`: Digicert CA policy
   */
  public val digiCertKernelCodeSigningCert: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 114412 2 3 11"
      )

  /**
   * `2.16.840.1.114412.2.4.1.2`: Digicert CA policy
   */
  public val digiCertLevel1EnterpriseClientCert: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 114412 2 4 1 2"
      )

  /**
   * `2.16.840.1.114412.2.4.1.1`: Digicert CA policy
   */
  public val digiCertLevel1PersonalClientCert: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 114412 2 4 1 1"
      )

  /**
   * `2.16.840.1.114412.2.4.2`: Digicert CA policy
   */
  public val digiCertLevel2ClientCert: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 114412 2 4 2"
      )

  /**
   * `2.16.840.1.114412.2.4.3.2`: Digicert CA policy
   */
  public val digiCertLevel3CBPClientCert: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 114412 2 4 3 2"
      )

  /**
   * `2.16.840.1.114412.2.4.3.1`: Digicert CA policy
   */
  public val digiCertLevel3USClientCert: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 114412 2 4 3 1"
      )

  /**
   * `2.16.840.1.114412.2.4.4.2`: Digicert CA policy
   */
  public val digiCertLevel4CBPClientCert: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 114412 2 4 4 2"
      )

  /**
   * `2.16.840.1.114412.2.4.4.1`: Digicert CA policy
   */
  public val digiCertLevel4USClientCert: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 114412 2 4 4 1"
      )

  /**
   * `2.16.840.1.114412.1`: Digicert CA policy
   */
  public val digiCertNonEVCerts: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 114412 1"
      )

  /**
   * `2.16.840.1.114412.1.1`: Digicert CA policy
   */
  public val digiCertOVCert: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 114412 1 1"
      )

  /**
   * `2.16.840.1.114412.2.3`: Digicert CA policy
   */
  public val digiCertObjectSigningCert: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 114412 2 3"
      )

  /**
   * `2.16.840.1.114412.2.4.5.2`: Digicert CA policy
   */
  public val digiCertPIVCardAuthCert: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 114412 2 4 5 2"
      )

  /**
   * `2.16.840.1.114412.2.4.5.3`: Digicert CA policy
   */
  public val digiCertPIVContentSigningCert: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 114412 2 4 5 3"
      )

  /**
   * `2.16.840.1.114412.2.4.5.1`: Digicert CA policy
   */
  public val digiCertPIVHardwareCert: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 114412 2 4 5 1"
      )

  /**
   * `0.2.262.1.10.3.1`: Telesec object class
   */
  public val directory: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 3 1"
      )

  /**
   * `0.2.262.1.10.3.3`: Telesec object class
   */
  public val directoryGroup: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 3 3"
      )

  /**
   * `0.2.262.1.10.7.32`: Telesec attribute
   */
  public val directoryGroupName: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 7 32"
      )

  /**
   * `0.2.262.1.10.7.30`: Telesec attribute
   */
  public val directoryName: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 7 30"
      )

  /**
   * `1.3.36.8.2.1`: Teletrust extended key usage
   */
  public val directoryService: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 2 1"
      )

  /**
   * `0.2.262.1.10.3.2`: Telesec object class
   */
  public val directoryType: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 3 2"
      )

  /**
   * `0.2.262.1.10.7.31`: Telesec attribute
   */
  public val directoryTypeName: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 7 31"
      )

  /**
   * `0.2.262.1.10.3.4`: Telesec object class
   */
  public val directoryUser: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 3 4"
      )

  /**
   * `0.2.262.1.10.7.33`: Telesec attribute
   */
  public val directoryUserName: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 7 33"
      )

  /**
   * `2.16.840.1.113730.3`: Netscape
   */
  public val directory_2_16_840_1_113730_3: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113730 3"
      )

  /**
   * `2.5.4.49`: X.520 DN component
   */
  public val distinguishedName: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 49"
      )

  /**
   * `2.5.4.54`: X.520 DN component
   */
  public val dmdName: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 54"
      )

  /**
   * `2.16.840.1.101.2.1.16.0`: SDN.700 INFOSEC attributes and RFC 7191
   */
  public val dn: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 16 0"
      )

  /**
   * `2.5.4.46`: X.520 DN component
   */
  public val dnQualifier: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 46"
      )

  /**
   * `2.5.4.100`: X.520 DN component
   */
  public val dnsName: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 100"
      )

  /**
   * `1.3.6.1.5.5.7.8.7`: PKIX other name
   */
  public val dnsSRV: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 8 7"
      )

  /**
   * `1.3.36.1`: Teletrust document
   */
  public val document: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 1"
      )

  /**
   * `1.3.6.1.4.1.311.10.3.12`: Microsoft extended key usage
   */
  public val documentSigning: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 10 3 12"
      )

  /**
   * `1.3.6.1.5.5.7.3.36`: PKIX key purpose
   */
  public val documentSigning_1_3_6_1_5_5_7_3_36: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 3 36"
      )

  /**
   * `0.9.2342.19200300.100.1.25`: Men are from Mars, this OID is from Pluto
   */
  public val domainComponent: ObjectIdentifier = 
      ObjectIdentifier(
      "0 9 2342 19200300 100 1 25"
      )

  /**
   * `1.2.840.113549.1.9.16.9.2`: S/MIME Signature Type Identifier
   */
  public val domainSig: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 9 2"
      )

  /**
   * `2.23.140.1.2.1`: CAB Certificate Policies
   */
  public val domainValidated: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 140 1 2 1"
      )

  /**
   * `1.3.36.1.2`: Teletrust document
   */
  public val draft: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 1 2"
      )

  /**
   * `1.3.6.1.4.1.311.10.5.1`: Microsoft extended key usage
   */
  public val drm: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 10 5 1"
      )

  /**
   * `1.3.6.1.4.1.311.10.5.2`: Microsoft extended key usage
   */
  public val drmIndividualization: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 10 5 2"
      )

  /**
   * `1.3.6.1.4.1.311.21.19`: Microsoft
   */
  public val dsEmailReplication: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 21 19"
      )

  /**
   * `1.2.840.10040.4.1`: ANSI X9.57 algorithm
   */
  public val dsa: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10040 4 1"
      )

  /**
   * `1.3.14.3.2.20`: Oddball OIW OID.  Deprecated, use a plain DSA OID instead
   */
  public val dsaCommon: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 14 3 2 20"
      )

  /**
   * `1.3.14.3.2.21`: Oddball OIW OID.  Deprecated, use a plain dsaWithSHA OID instead
   */
  public val dsaCommonWithSHA: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 14 3 2 21"
      )

  /**
   * `1.3.36.8.5.1.2.1`: Teletrust signature algorithm
   */
  public val dsaExtended: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 5 1 2 1"
      )

  /**
   * `1.3.14.3.2.28`: OIW
   */
  public val dsaWithCommonSHA1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 14 3 2 28"
      )

  /**
   * `1.3.36.8.5.1.2.2`: Teletrust signature algorithm
   */
  public val dsaWithRIPEMD160: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 5 1 2 2"
      )

  /**
   * `1.3.14.3.2.13`: Oddball OIW OID.  Incorrectly used by JDK 1.1 in place of (1 3 14 3 2 27)
   */
  public val dsaWithSHA: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 14 3 2 13"
      )

  /**
   * `1.3.14.3.2.27`: OIW. This OID may also be assigned as ripemd-160
   */
  public val dsaWithSHA1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 14 3 2 27"
      )

  /**
   * `1.2.840.10040.4.3`: ANSI X9.57 algorithm
   */
  public val dsaWithSha1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10040 4 3"
      )

  /**
   * `2.16.840.1.101.3.4.3.1`: NIST Algorithm
   */
  public val dsaWithSha224: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 4 3 1"
      )

  /**
   * `2.16.840.1.101.3.4.3.2`: NIST Algorithm
   */
  public val dsaWithSha256: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 4 3 2"
      )

  /**
   * `1.3.14.3.2.12`: OIW?, supposedly from an incomplete version of SDN.701 (doesn't match final
   * SDN.701)
   */
  public val dsa_1_3_14_3_2_12: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 14 3 2 12"
      )

  /**
   * `1.2.840.10040.4.2`: ANSI X9.57 algorithm
   */
  public val dsa_match: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10040 4 2"
      )

  /**
   * `0.4.0.2042.1.6`: ETSI TS 102 042 Certificate Policies
   */
  public val dvCertificatePolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 2042 1 6"
      )

  /**
   * `1.3.6.1.5.5.7.3.10`: PKIX key purpose
   */
  public val dvcs: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 3 10"
      )

  /**
   * `1.2.840.113549.1.9.16.2.29`: S/MIME Authenticated Attributes
   */
  public val dvcsDvc: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 29"
      )

  /**
   * `1.3.6.1.5.5.7.48.4`: PKIX subject/authority info access descriptor
   */
  public val dvcs_1_3_6_1_5_5_7_48_4: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 48 4"
      )

  /**
   * `2.23.42.9.22`: SET vendor
   */
  public val eLab: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 9 22"
      )

  /**
   * `2.23.42.9.37`: SET vendor
   */
  public val e_COMM: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 9 37"
      )

  /**
   * `1.3.6.1.5.5.7.3.14`: PKIX key purpose
   */
  public val eapOverLAN: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 3 14"
      )

  /**
   * `1.3.6.1.5.5.7.3.13`: PKIX key purpose
   */
  public val eapOverPPP: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 3 13"
      )

  /**
   * `1.2.840.10045.2.1`: ANSI X9.62 public key type
   */
  public val ecPublicKey: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10045 2 1"
      )

  /**
   * `1.3.132.1.14.0`: SECG (Certicom) elliptic curve key agreement
   */
  public val eccofactordhX963KDF_SHA224: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 132 1 14 0"
      )

  /**
   * `1.3.132.1.14.1`: SECG (Certicom) elliptic curve key agreement
   */
  public val eccofactordhX963KDF_SHA256: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 132 1 14 1"
      )

  /**
   * `1.3.132.1.14.2`: SECG (Certicom) elliptic curve key agreement
   */
  public val eccofactordhX963KDF_SHA384: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 132 1 14 2"
      )

  /**
   * `1.3.132.1.14.3`: SECG (Certicom) elliptic curve key agreement
   */
  public val eccofactordhX963KDF_SHA512: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 132 1 14 3"
      )

  /**
   * `1.2.840.113549.1.9.16.3.19`: S/MIME Algorithms
   */
  public val ecdhHKDF_SHA256: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 3 19"
      )

  /**
   * `1.2.840.113549.1.9.16.3.20`: S/MIME Algorithms
   */
  public val ecdhHKDF_SHA384: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 3 20"
      )

  /**
   * `1.2.840.113549.1.9.16.3.21`: S/MIME Algorithms
   */
  public val ecdhHKDF_SHA512: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 3 21"
      )

  /**
   * `1.3.6.1.5.5.7.6.25`: PKIX algorithm
   */
  public val ecdhPopStaticSha224HmacSha224: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 6 25"
      )

  /**
   * `1.3.6.1.5.5.7.6.26`: PKIX algorithm
   */
  public val ecdhPopStaticSha256HmacSha256: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 6 26"
      )

  /**
   * `1.3.6.1.5.5.7.6.27`: PKIX algorithm
   */
  public val ecdhPopStaticSha384HmacSha384: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 6 27"
      )

  /**
   * `1.3.6.1.5.5.7.6.28`: PKIX algorithm
   */
  public val ecdhPopStaticSha512HmacSha512: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 6 28"
      )

  /**
   * `1.3.132.1.11.0`: SECG (Certicom) elliptic curve key agreement
   */
  public val ecdhX963KDF_SHA224: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 132 1 11 0"
      )

  /**
   * `1.3.132.1.11.1`: SECG (Certicom) elliptic curve key agreement
   */
  public val ecdhX963KDF_SHA256: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 132 1 11 1"
      )

  /**
   * `1.3.132.1.11.2`: SECG (Certicom) elliptic curve key agreement
   */
  public val ecdhX963KDF_SHA384: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 132 1 11 2"
      )

  /**
   * `1.3.132.1.11.3`: SECG (Certicom) elliptic curve key agreement
   */
  public val ecdhX963KDF_SHA512: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 132 1 11 3"
      )

  /**
   * `1.3.6.1.5.5.7.6.32`: PKIX algorithm
   */
  public val ecdsaShake128: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 6 32"
      )

  /**
   * `1.3.6.1.5.5.7.6.33`: PKIX algorithm
   */
  public val ecdsaShake256: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 6 33"
      )

  /**
   * `1.2.840.10045.4.2`: ANSI X9.62 ECDSA algorithm with Recommended
   */
  public val ecdsaWithRecommended: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10045 4 2"
      )

  /**
   * `1.2.840.10045.4.1`: ANSI X9.62 ECDSA algorithm with SHA1
   */
  public val ecdsaWithSHA1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10045 4 1"
      )

  /**
   * `1.2.840.10045.4.3.1`: ANSI X9.62 ECDSA algorithm with SHA224
   */
  public val ecdsaWithSHA224: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10045 4 3 1"
      )

  /**
   * `1.2.840.10045.4.3.2`: ANSI X9.62 ECDSA algorithm with SHA256
   */
  public val ecdsaWithSHA256: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10045 4 3 2"
      )

  /**
   * `1.2.840.10045.4.3.3`: ANSI X9.62 ECDSA algorithm with SHA384
   */
  public val ecdsaWithSHA384: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10045 4 3 3"
      )

  /**
   * `1.2.840.10045.4.3.4`: ANSI X9.62 ECDSA algorithm with SHA512
   */
  public val ecdsaWithSHA512: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10045 4 3 4"
      )

  /**
   * `1.2.840.10045.4.3`: ANSI X9.62 ECDSA algorithm with Specified
   */
  public val ecdsaWithSpecified: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10045 4 3"
      )

  /**
   * `1.3.6.1.4.1.3576.7`: TMN EDI for Interactive Agents
   */
  public val eciaAscX12Edi: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 3576 7"
      )

  /**
   * `1.3.6.1.4.1.3576.8`: TMN EDI for Interactive Agents
   */
  public val eciaEdifact: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 3576 8"
      )

  /**
   * `1.3.6.1.4.1.3576.9`: TMN EDI for Interactive Agents
   */
  public val eciaNonEdi: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 3576 9"
      )

  /**
   * `1.3.132.1.15.0`: SECG (Certicom) elliptic curve key agreement
   */
  public val ecmqv_X963KDF_SHA224: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 132 1 15 0"
      )

  /**
   * `1.3.132.1.15.1`: SECG (Certicom) elliptic curve key agreement
   */
  public val ecmqv_X963KDF_SHA256: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 132 1 15 1"
      )

  /**
   * `1.3.132.1.15.2`: SECG (Certicom) elliptic curve key agreement
   */
  public val ecmqv_X963KDF_SHA384: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 132 1 15 2"
      )

  /**
   * `1.3.132.1.15.3`: SECG (Certicom) elliptic curve key agreement
   */
  public val ecmqv_X963KDF_SHA512: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 132 1 15 3"
      )

  /**
   * `1.3.36.3.3.2`: Teletrust signature algorithm
   */
  public val ecsieSign: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 2"
      )

  /**
   * `1.3.36.3.3.2.3`: Teletrust signature algorithm
   */
  public val ecsieSignWithmd2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 2 3"
      )

  /**
   * `1.3.36.3.3.2.4`: Teletrust signature algorithm
   */
  public val ecsieSignWithmd5: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 2 4"
      )

  /**
   * `1.3.36.3.3.2.2`: Teletrust signature algorithm
   */
  public val ecsieSignWithripemd160: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 2 2"
      )

  /**
   * `1.3.36.3.3.2.1`: Teletrust signature algorithm
   */
  public val ecsieSignWithsha1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 2 1"
      )

  /**
   * `1.3.6.1.4.1.5309.1.2.1`: EdelWeb policy
   */
  public val edelWebClepsydrePolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 5309 1 2 1"
      )

  /**
   * `1.3.6.1.4.1.5309.1.2`: EdelWeb policy
   */
  public val edelWebCustomerPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 5309 1 2"
      )

  /**
   * `1.3.6.1.4.1.5309.1.2.2`: EdelWeb policy
   */
  public val edelWebExperimentalTSAPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 5309 1 2 2"
      )

  /**
   * `1.3.6.1.4.1.5309.1.2.3`: EdelWeb policy
   */
  public val edelWebOpenEvidenceTSAPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 5309 1 2 3"
      )

  /**
   * `1.3.6.1.4.1.5309.1`: EdelWeb policy
   */
  public val edelWebPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 5309 1"
      )

  /**
   * `2.5.4.102`: X.520 DN component
   */
  public val eeAttrCertificateRevocationList: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 102"
      )

  /**
   * `2.5.4.101`: X.520 DN component
   */
  public val eepkCertificateRevocationList: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 101"
      )

  /**
   * `1.3.6.1.4.1.311.10.3.4.1`: Microsoft extended key usage
   */
  public val efsRecovery: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 10 3 4 1"
      )

  /**
   * `0.2.262.1.10.2.10`: Telesec module
   */
  public val electronicOrder: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 2 10"
      )

  /**
   * `1.3.6.1.4.1.3029.1.2.1`: cryptlib public-key algorithm
   */
  public val elgamal: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 3029 1 2 1"
      )

  /**
   * `1.3.6.1.4.1.3029.1.2.1.2`: cryptlib public-key algorithm
   */
  public val elgamalWithRIPEMD_160: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 3029 1 2 1 2"
      )

  /**
   * `1.3.6.1.4.1.3029.1.2.1.1`: cryptlib public-key algorithm
   */
  public val elgamalWithSHA_1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 3029 1 2 1 1"
      )

  /**
   * `0.2.262.1.10.7.28`: Telesec attribute
   */
  public val emailAddress: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 7 28"
      )

  /**
   * `1.2.840.113549.1.9.1`: PKCS #9. Deprecated, use an altName extension instead
   */
  public val emailAddress_1_2_840_113549_1_9_1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 1"
      )

  /**
   * `1.3.6.1.5.5.7.3.4`: PKIX key purpose
   */
  public val emailProtection: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 3 4"
      )

  /**
   * `1.3.6.1.4.1.311.10.3.8`: Microsoft extended key usage
   */
  public val embeddedNTCrypto: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 10 3 8"
      )

  /**
   * `2.16.840.1.113730.3.1.3`: Netscape LDAP definitions
   */
  public val employeeNumber: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113730 3 1 3"
      )

  /**
   * `2.16.840.1.113730.3.1.4`: Netscape LDAP definitions
   */
  public val employeeType: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113730 3 1 4"
      )

  /**
   * `2.16.840.1.101.2.1.2.2`: SDN.700 INFOSEC format
   */
  public val emptyContent: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 2 2"
      )

  /**
   * `1.3.36.7.2.1`: Teletrust key management. 9796-2 with key stored in hash field
   */
  public val encISO9796_2Withrsa: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 7 2 1"
      )

  /**
   * `1.3.6.1.5.5.7.4.3`: PKIX CMP information
   */
  public val encKeyPairTypes: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 4 3"
      )

  /**
   * `1.2.840.113549.1.9.16.1.21`: S/MIME Content Types
   */
  public val encKeyWithID: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 1 21"
      )

  /**
   * `1.2.840.113549.1.9.16.1.22`: S/MIME Content Types
   */
  public val encPEPSI: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 1 22"
      )

  /**
   * `1.2.840.113549.1.9.16.2.6`: S/MIME Authenticated Attributes.  Obsolete
   */
  public val encapContentType: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 6"
      )

  /**
   * `1.2.840.113549.1.9.16.2.11`: S/MIME Authenticated Attributes
   */
  public val encrypKeyPref: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 11"
      )

  /**
   * `1.2.840.113549.1.7.6`: PKCS #7
   */
  public val encryptedData: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 7 6"
      )

  /**
   * `1.3.6.1.4.1.311.10.3.4`: Microsoft extended key usage
   */
  public val encryptedFileSystem: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 10 3 4"
      )

  /**
   * `1.3.6.1.4.1.311.21.21`: Microsoft attribute
   */
  public val encryptedKeyHash: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 21 21"
      )

  /**
   * `2.16.840.1.101.2.1.2.78.2`: SDN.700 INFOSEC format and RFC 6032
   */
  public val encryptedKeyPackage: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 2 78 2"
      )

  /**
   * `1.2.840.113549.1.7.8`: PKCS #7 experimental
   */
  public val encryptedPrivateKeyInfo: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 7 8"
      )

  /**
   * `1.2.840.113549.1.9.25.2`: PKCS #9/RFC 2985 attribute
   */
  public val encryptedPrivateKeyInfo_1_2_840_113549_1_9_25_2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 25 2"
      )

  /**
   * `0.2.262.1.10.1.2`: Telesec mechanism
   */
  public val encryption: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 1 2"
      )

  /**
   * `1.2.840.113549.3`: null
   */
  public val encryptionAlgorithm: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 3"
      )

  /**
   * `1.3.36.3.1`: Teletrust algorithm
   */
  public val encryptionAlgorithm_1_3_36_3_1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 1"
      )

  /**
   * `1.3.6.1.5.5.7.1.33`: PKIX private extension
   */
  public val enhancedJWTClaimConstraints: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 1 33"
      )

  /**
   * `2.5.4.47`: X.520 DN component
   */
  public val enhancedSearchGuide: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 47"
      )

  /**
   * `1.3.6.1.4.1.311.20.2`: Microsoft CAPICOM certificate template, V1
   */
  public val enrollCerttypeExtension: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 20 2"
      )

  /**
   * `1.3.6.1.4.1.311.20.2.1`: Microsoft extended key usage
   */
  public val enrollmentAgent: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 20 2 1"
      )

  /**
   * `1.3.6.1.4.1.311.13.2.2`: Microsoft attribute
   */
  public val enrolmentCSP: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 13 2 2"
      )

  /**
   * `1.3.6.1.4.1.311.13.2.1`: Microsoft attribute
   */
  public val enrolmentNameValuePair: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 13 2 1"
      )

  /**
   * `1.2.840.113533.7.68.0`: Nortel Secure Networks at
   */
  public val entrustCAInfo: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113533 7 68 0"
      )

  /**
   * `1.2.840.113533.7.67.0`: Nortel Secure Networks oc
   */
  public val entrustUser: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113533 7 67 0"
      )

  /**
   * `1.2.840.113533.7.65.0`: Nortel Secure Networks ce
   */
  public val entrustVersInfo: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113533 7 65 0"
      )

  /**
   * `2.16.840.1.101.2.1.8.3.1`: SDN.700 INFOSEC security category from RFC 7906
   */
  public val enumeratedPermissiveAttrs: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 8 3 1"
      )

  /**
   * `2.16.840.1.101.2.1.8.3.4`: SDN.700 INFOSEC security category from RFC 7906
   */
  public val enumeratedRestrictiveAttrs: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 8 3 4"
      )

  /**
   * `1.2.840.113549.1.7.3`: PKCS #7
   */
  public val envelopedData: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 7 3"
      )

  /**
   * `1.2.840.113549.1.9.16.10.1`: S/MIME X.400 Encoded Information Types
   */
  public val envelopedData_1_2_840_113549_1_9_16_10_1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 10 1"
      )

  /**
   * `1.2.840.113549.1.9.16.10.5`: S/MIME X.400 Encoded Information Types
   */
  public val envelopedX400: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 10 5"
      )

  /**
   * `2.5.4.91`: X.520 DN component
   */
  public val epc: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 91"
      )

  /**
   * `2.5.4.93`: X.520 DN component
   */
  public val epcFormat: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 93"
      )

  /**
   * `2.5.4.94`: X.520 DN component
   */
  public val epcInUrn: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 94"
      )

  /**
   * `1.2.840.113549.1.9.16.1.39`: S/MIME Content Types
   */
  public val epub: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 1 39"
      )

  /**
   * `1.2.840.113549.1.9.16.2.9`: S/MIME Authenticated Attributes
   */
  public val equivalentLabels: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 9"
      )

  /**
   * `1.2.840.113549.1.9.16.2.50`: S/MIME Authenticated Attributes
   */
  public val erExternal: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 50"
      )

  /**
   * `1.2.840.113549.1.9.16.2.49`: S/MIME Authenticated Attributes
   */
  public val erInternal: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 49"
      )

  /**
   * `2.16.840.1.101.2.1.22`: RFC 7906 key attribute error codes
   */
  public val errorCodes: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 22"
      )

  /**
   * `1.2.840.113549.1.9.16.3.5`: S/MIME Algorithms
   */
  public val esDH: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 3 5"
      )

  /**
   * `1.2.840.113549.1.9.16.3.1`: S/MIME Algorithms. Obsolete
   */
  public val esDHwith3DES: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 3 1"
      )

  /**
   * `1.2.840.113549.1.9.16.3.2`: S/MIME Algorithms. Obsolete
   */
  public val esDHwithRC2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 3 2"
      )

  /**
   * `1.2.840.113549.1.9.16.2.25`: S/MIME Authenticated Attributes
   */
  public val escTimeStamp: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 25"
      )

  /**
   * `2.23.42.9.31`: SET vendor
   */
  public val espace_net: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 9 31"
      )

  /**
   * `1.2.840.113549.1.9.16.2.58`: S/MIME Authenticated Attributes
   */
  public val estIdentityLinking: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 58"
      )

  /**
   * `1.2.840.113549.1.9.16.2.48`: S/MIME Authenticated Attributes
   */
  public val etsArchiveTimeStampV2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 48"
      )

  /**
   * `1.2.840.113549.1.9.16.2.44`: S/MIME Authenticated Attributes
   */
  public val etsAttrCertificateRefs: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 44"
      )

  /**
   * `1.2.840.113549.1.9.16.2.45`: S/MIME Authenticated Attributes
   */
  public val etsAttrRevocationRefs: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 45"
      )

  /**
   * `0.4.0.1862.1`: ETSI TS 101 862 Qualified Certificates
   */
  public val etsiQcs: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 1862 1"
      )

  /**
   * `0.4.0.1862.1.1`: ETSI TS 101 862 Qualified Certificates
   */
  public val etsiQcsCompliance: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 1862 1 1"
      )

  /**
   * `0.4.0.1862.1.2`: ETSI TS 101 862 Qualified Certificates
   */
  public val etsiQcsLimitValue: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 1862 1 2"
      )

  /**
   * `0.4.0.1862`: ETSI TS 101 862 Qualified Certificates
   */
  public val etsiQcsProfile: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 1862"
      )

  /**
   * `0.4.0.1862.1.5`: ETSI TS 101 862 Qualified Certificates
   */
  public val etsiQcsQcPDS: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 1862 1 5"
      )

  /**
   * `0.4.0.1862.1.4`: ETSI TS 101 862 Qualified Certificates
   */
  public val etsiQcsQcSSCD: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 1862 1 4"
      )

  /**
   * `0.4.0.1862.1.6`: ETSI TS 101 862 Qualified Certificates
   */
  public val etsiQcsQcType: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 1862 1 6"
      )

  /**
   * `0.4.0.1862.1.6.2`: ETSI TS 101 862 Qualified Certificates
   */
  public val etsiQcsQctEseal: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 1862 1 6 2"
      )

  /**
   * `0.4.0.1862.1.6.1`: ETSI TS 101 862 Qualified Certificates
   */
  public val etsiQcsQctEsign: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 1862 1 6 1"
      )

  /**
   * `0.4.0.1862.1.6.3`: ETSI TS 101 862 Qualified Certificates
   */
  public val etsiQcsQctWeb: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 1862 1 6 3"
      )

  /**
   * `0.4.0.1862.1.3`: ETSI TS 101 862 Qualified Certificates
   */
  public val etsiQcsRetentionPeriod: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 1862 1 3"
      )

  /**
   * `1.3.6.1.4.1.2363.4.3.1`: Eurocontrol certificate policy
   */
  public val euroControlEABridgeCA: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 2363 4 3 1"
      )

  /**
   * `1.3.6.1.4.1.2363.4.3.1.1.1`: Eurocontrol certificate policy
   */
  public val euroControlEAClientCertificate: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 2363 4 3 1 1 1"
      )

  /**
   * `1.3.6.1.4.1.2363.4.3.1.1`: Eurocontrol certificate policy
   */
  public val euroControlEAIssuingCA: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 2363 4 3 1 1"
      )

  /**
   * `1.3.6.1.4.1.2363.4.3`: Eurocontrol certificate policy
   */
  public val euroControlEARootCA: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 2363 4 3"
      )

  /**
   * `1.3.6.1.4.1.2363.4.3.1.1.3`: Eurocontrol certificate policy
   */
  public val euroControlEASWIMSigningCertificate: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 2363 4 3 1 1 3"
      )

  /**
   * `1.3.6.1.4.1.2363.4.3.1.1.2`: Eurocontrol certificate policy
   */
  public val euroControlEAServerCertificate: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 2363 4 3 1 1 2"
      )

  /**
   * `1.3.6.1.4.1.2363.3.2`: Eurocontrol certificate policy
   */
  public val euroControlUntrustedEA: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 2363 3 2"
      )

  /**
   * `0.4.0.2042.1.4`: ETSI TS 102 042 Certificate Policies
   */
  public val evCertificatePolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 2042 1 4"
      )

  /**
   * `0.4.0.2042.1.5`: ETSI TS 102 042 Certificate Policies
   */
  public val evCertificatePolicyPlus: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 2042 1 5"
      )

  /**
   * `2.23.140.1.1`: CAB Certificate Policies
   */
  public val evGuidelines: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 140 1 1"
      )

  /**
   * `2.5.29.22`: X.509 extension.  Deprecated, alternative OID uncertain
   */
  public val expirationDate: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 22"
      )

  /**
   * `2.5.29.60`: X.509 extension
   */
  public val expiredCertsOnCRL: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 60"
      )

  /**
   * `2.5.29.37`: X.509 extension
   */
  public val extKeyUsage: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 37"
      )

  /**
   * `1.2.840.113549.1.9.9`: PKCS #9
   */
  public val extendedCertificateAttributes: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 9"
      )

  /**
   * `0.2.262.1.10.0`: Telesec
   */
  public val extension: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 0"
      )

  /**
   * `2.16.840.1.113733.1.9.8`: Verisign PKCS #7 attribute.  Use PKCS #9 extensionRequest instead
   */
  public val extensionReq: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113733 1 9 8"
      )

  /**
   * `1.2.840.113549.1.9.14`: PKCS #9 via CRMF
   */
  public val extensionRequest: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 14"
      )

  /**
   * `2.16.840.1.101.3.2.3`: CSOR GAK extensions
   */
  public val extensions: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 2 3"
      )

  /**
   * `2.5.4.23`: X.520 DN component
   */
  public val facsimileTelephoneNumber: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 23"
      )

  /**
   * `2.16.840.1.113733.1.9.4`: Verisign PKCS #7 attribute
   */
  public val failInfo: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113733 1 9 4"
      )

  /**
   * `2.5.4.64`: X.520 DN component
   */
  public val familyInformation: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 64"
      )

  /**
   * `2.23.42.2.2`: SET field
   */
  public val familyName: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 2 2"
      )

  /**
   * `2.16.840.1.101.3.2.1.3.2`: Federal Bridge CA Policy
   */
  public val fbcaBasicPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 2 1 3 2"
      )

  /**
   * `2.16.840.1.101.3.2.1.3.4`: Federal Bridge CA Policy
   */
  public val fbcaHighPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 2 1 3 4"
      )

  /**
   * `2.16.840.1.101.3.2.1.3.3`: Federal Bridge CA Policy
   */
  public val fbcaMediumPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 2 1 3 3"
      )

  /**
   * `2.16.840.1.101.3.2.1.3.1`: Federal Bridge CA Policy
   */
  public val fbcaRudimentaryPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 2 1 3 1"
      )

  /**
   * `2.16.840.1.101.2.1.5.21`: SDN.700 INFOSEC attributes
   */
  public val febUKMs: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 5 21"
      )

  /**
   * `0.2.262.1.10.2.6`: Telesec module
   */
  public val fec: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 2 6"
      )

  /**
   * `0.2.262.1.10.1.4`: Telesec mechanism
   */
  public val fecFunction: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 1 4"
      )

  /**
   * `2.23.42.2`: SET
   */
  public val `field`: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 2"
      )

  /**
   * `1.2.840.10045.1`: ANSI X9.62. This OID is also assigned as ecdsa-with-SHA1
   */
  public val fieldType: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10045 1"
      )

  /**
   * `1.2.840.10046.1`: ANSI X9.42
   */
  public val fieldType_1_2_840_10046_1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10046 1"
      )

  /**
   * `1.3.36.8.6.5`: Teletrust signature attributes
   */
  public val fileName: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 6 5"
      )

  /**
   * `1.3.36.8.6.7`: Teletrust signature attributes
   */
  public val fileSize: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 6 7"
      )

  /**
   * `0.2.262.1.10.7.26`: Telesec attribute
   */
  public val fileType: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 7 26"
      )

  /**
   * `1.3.36.1.1`: Teletrust document
   */
  public val finalVersion: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 1 1"
      )

  /**
   * `1.2.840.113549.1.9.16.1.18`: S/MIME Content Types
   */
  public val firmwareLoadError: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 1 18"
      )

  /**
   * `1.2.840.113549.1.9.16.1.17`: S/MIME Content Types
   */
  public val firmwareLoadReceipt: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 1 17"
      )

  /**
   * `1.2.840.113549.1.9.16.1.16`: S/MIME Content Types
   */
  public val firmwarePackage: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 1 16"
      )

  /**
   * `2.16.840.1.101.2.1.5.7`: SDN.700 INFOSEC attributes (superseded)
   */
  public val fortezzaCASignatureCertificate: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 5 7"
      )

  /**
   * `2.16.840.1.101.2.1.5.46`: SDN.700 INFOSEC attributes
   */
  public val fortezzaCKL: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 5 46"
      )

  /**
   * `2.16.840.1.101.2.1.5.45`: SDN.700 INFOSEC attributes (superseded)
   */
  public val fortezzaCertificateRevocationList: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 5 45"
      )

  /**
   * `2.16.840.1.101.2.1.1.4`: SDN.700 INFOSEC algorithms.  Formerly known as
   * mosaicConfidentialityAlgorithm
   */
  public val fortezzaConfidentialityAlgorithm: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 1 4"
      )

  /**
   * `2.16.840.1.101.2.1.1.6`: SDN.700 INFOSEC algorithms.  Formerly known as
   * mosaicIntegrityAlgorithm
   */
  public val fortezzaIntegrityAlgorithm: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 1 6"
      )

  /**
   * `2.16.840.1.101.2.1.1.12`: SDN.700 INFOSEC algorithms.  Formerly known as
   * mosaicKMandSigAlgorithm
   */
  public val fortezzaKMandSigAlgorithm: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 1 12"
      )

  /**
   * `2.16.840.1.101.2.1.5.5`: SDN.700 INFOSEC attributes (superseded)
   */
  public val fortezzaKMandSigCertificate: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 5 5"
      )

  /**
   * `2.16.840.1.101.2.1.1.20`: SDN.700 INFOSEC algorithms.  Formerly known as
   * mosaicKMandUpdSigAlgorithms
   */
  public val fortezzaKMandUpdSigAlgorithms: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 1 20"
      )

  /**
   * `2.16.840.1.101.2.1.1.10`: SDN.700 INFOSEC algorithms.  Formerly known as
   * mosaicKeyManagementAlgorithm
   */
  public val fortezzaKeyManagementAlgorithm: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 1 10"
      )

  /**
   * `2.16.840.1.101.2.1.5.4`: SDN.700 INFOSEC attributes (superseded)
   */
  public val fortezzaKeyManagementCertificate: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 5 4"
      )

  /**
   * `2.16.840.1.101.2.1.1.2`: SDN.700 INFOSEC algorithms.  Formerly known as
   * mosaicSignatureAlgorithm, this OID is better known as dsaWithSHA-1.
   */
  public val fortezzaSignatureAlgorithm: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 1 2"
      )

  /**
   * `2.16.840.1.101.2.1.1.8`: SDN.700 INFOSEC algorithms.  Formerly know as
   * mosaicTokenProtectionAlgorithm
   */
  public val fortezzaTokenProtectionAlgorithm: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 1 8"
      )

  /**
   * `2.16.840.1.101.2.1.1.21`: SDN.700 INFOSEC algorithms.  Formerly known as
   * mosaicUpdatedIntegAlgorithm
   */
  public val fortezzaUpdatedIntegAlgorithm: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 1 21"
      )

  /**
   * `2.16.840.1.101.2.1.1.19`: SDN.700 INFOSEC algorithms.  Formerly known as
   * mosaicUpdatedSigAlgorithm
   */
  public val fortezzaUpdatedSigAlgorithm: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 1 19"
      )

  /**
   * `2.16.840.1.101.2.1.5.6`: SDN.700 INFOSEC attributes (superseded)
   */
  public val fortezzaUserSignatureCertificate: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 5 6"
      )

  /**
   * `2.16.840.1.101.2.1.1.23`: SDN.700 INFOSEC algorithms
   */
  public val fortezzaWrap80Algorithm: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 1 23"
      )

  /**
   * `2.16.840.1.101.2.1.2.74`: SDN.700 INFOSEC format
   */
  public val forwardedCSPMsgBodyPart: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 2 74"
      )

  /**
   * `2.16.840.1.101.2.1.2.72`: SDN.700 INFOSEC format
   */
  public val forwardedMSPMessageBodyPart: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 2 72"
      )

  /**
   * `2.5.29.46`: X.509 extension
   */
  public val freshestCRL: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 46"
      )

  /**
   * `1.2.840.113549.1.9.20`: PKCS #9 via PKCS #12
   */
  public val friendlyName_for_PKCS_12: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 20"
      )

  /**
   * `2.23.42.2.0`: SET field
   */
  public val fullName: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 2 0"
      )

  /**
   * `1.3.36.6.2`: Teletrust API
   */
  public val functionality_specific_api: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 6 2"
      )

  /**
   * `1.2.840.113549.1.9.16.2.40`: S/MIME Authenticated Attributes
   */
  public val fwCommunityIdentifiers: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 40"
      )

  /**
   * `1.2.840.113549.1.9.16.2.37`: S/MIME Authenticated Attributes
   */
  public val fwDecryptKeyID: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 37"
      )

  /**
   * `1.2.840.113549.1.9.16.2.43`: S/MIME Authenticated Attributes
   */
  public val fwImplCompressAlgs: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 43"
      )

  /**
   * `1.2.840.113549.1.9.16.2.38`: S/MIME Authenticated Attributes
   */
  public val fwImplCryptAlgs: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 38"
      )

  /**
   * `1.2.840.113549.1.9.16.2.35`: S/MIME Authenticated Attributes
   */
  public val fwPackageID: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 35"
      )

  /**
   * `1.2.840.113549.1.9.16.2.42`: S/MIME Authenticated Attributes
   */
  public val fwPackageInfo: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 42"
      )

  /**
   * `1.2.840.113549.1.9.16.2.41`: S/MIME Authenticated Attributes
   */
  public val fwPkgMessageDigest: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 41"
      )

  /**
   * `1.2.840.113549.1.9.16.2.36`: S/MIME Authenticated Attributes
   */
  public val fwTargetHardwareIDs: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 36"
      )

  /**
   * `1.2.840.113549.1.9.16.2.39`: S/MIME Authenticated Attributes
   */
  public val fwWrappedFirmwareKey: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 39"
      )

  /**
   * `0.2.262.1.10.7.38`: Telesec attribute
   */
  public val gKeyData: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 7 38"
      )

  /**
   * `2.16.840.1.101.3.2.2`: CSOR GAK extended key usage
   */
  public val gak: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 2 2"
      )

  /**
   * `1.3.6.1.5.5.7.9.3`: PKIX personal data
   */
  public val gender: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 9 3"
      )

  /**
   * `2.5.4.44`: X.520 DN component
   */
  public val generationQualifier: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 44"
      )

  /**
   * `2.16.840.1.101.2.1.3.11`: SDN.700 INFOSEC policy
   */
  public val genser: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 3 11"
      )

  /**
   * `2.16.840.1.101.2.1.3.11.2`: SDN.700 INFOSEC policy (obsolete)
   */
  public val genserAcquisition: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 3 11 2"
      )

  /**
   * `2.16.840.1.101.2.1.3.11.1`: SDN.700 INFOSEC policy (obsolete)
   */
  public val genserComsec: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 3 11 1"
      )

  /**
   * `2.16.840.1.101.2.1.3.11.0`: SDN.700 INFOSEC policy (obsolete)
   */
  public val genserNations: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 3 11 0"
      )

  /**
   * `2.16.840.1.101.2.1.3.11.3`: SDN.700 INFOSEC policy
   */
  public val genserSecurityCategories: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 3 11 3"
      )

  /**
   * `2.16.840.1.101.2.1.3.11.3.0`: SDN.700 INFOSEC GENSER policy
   */
  public val genserTagSetName: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 3 11 3 0"
      )

  /**
   * `1.2.840.113549.1.9.16.1.47`: S/MIME Content Types
   */
  public val geofeedCSVwithCRLF: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 1 47"
      )

  /**
   * `1.2.840.10046.1.1`: ANSI X9.42 field type
   */
  public val gf_prime: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10046 1 1"
      )

  /**
   * `2.5.4.42`: X.520 DN component
   */
  public val givenName: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 42"
      )

  /**
   * `2.23.42.2.1`: SET field
   */
  public val givenName_2_23_42_2_1: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 2 1"
      )

  /**
   * `1.2.840.113549.1.9.16.8.3`: S/MIME Symmetric Key Distribution Attributes
   */
  public val glAddMember: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 8 3"
      )

  /**
   * `1.2.840.113549.1.9.16.8.6`: S/MIME Symmetric Key Distribution Attributes
   */
  public val glAddOwner: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 8 6"
      )

  /**
   * `1.2.840.113549.1.9.16.8.2`: S/MIME Symmetric Key Distribution Attributes
   */
  public val glDelete: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 8 2"
      )

  /**
   * `1.2.840.113549.1.9.16.8.4`: S/MIME Symmetric Key Distribution Attributes
   */
  public val glDeleteMember: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 8 4"
      )

  /**
   * `1.2.840.113549.1.9.16.8.10`: S/MIME Symmetric Key Distribution Attributes.  Obsolete
   */
  public val glFailInfo: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 8 10"
      )

  /**
   * `1.2.840.113549.1.9.16.8.15`: S/MIME Symmetric Key Distribution Attributes
   */
  public val glKey: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 8 15"
      )

  /**
   * `0.2.262.1.10.7.36`: Telesec attribute
   */
  public val glNumber: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 7 36"
      )

  /**
   * `1.2.840.113549.1.9.16.8.13`: S/MIME Symmetric Key Distribution Attributes
   */
  public val glProvideCert: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 8 13"
      )

  /**
   * `1.2.840.113549.1.9.16.8.5`: S/MIME Symmetric Key Distribution Attributes
   */
  public val glRekey: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 8 5"
      )

  /**
   * `1.2.840.113549.1.9.16.8.7`: S/MIME Symmetric Key Distribution Attributes
   */
  public val glRemoveOwner: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 8 7"
      )

  /**
   * `1.2.840.113549.1.9.16.8.14`: S/MIME Symmetric Key Distribution Attributes
   */
  public val glUpdateCert: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 8 14"
      )

  /**
   * `1.2.840.113549.1.9.16.8.1`: S/MIME Symmetric Key Distribution Attributes
   */
  public val glUseKEK: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 8 1"
      )

  /**
   * `1.2.840.113549.1.9.16.8.11`: S/MIME Symmetric Key Distribution Attributes
   */
  public val glaQueryRequest: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 8 11"
      )

  /**
   * `1.2.840.113549.1.9.16.8.12`: S/MIME Symmetric Key Distribution Attributes
   */
  public val glaQueryResponse: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 8 12"
      )

  /**
   * `1.2.840.113549.1.9.16.8.8`: S/MIME Symmetric Key Distribution Attributes
   */
  public val glkCompromise: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 8 8"
      )

  /**
   * `1.2.840.113549.1.9.16.8.9`: S/MIME Symmetric Key Distribution Attributes
   */
  public val glkRefresh: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 8 9"
      )

  /**
   * `1.3.6.1.4.1.4146.1.40`: Globalsign policy
   */
  public val globalsignClientCertPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 4146 1 40"
      )

  /**
   * `1.3.6.1.4.1.4146.1.50`: Globalsign policy
   */
  public val globalsignCodeSignPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 4146 1 50"
      )

  /**
   * `1.3.6.1.4.1.4146.1.10`: Globalsign policy
   */
  public val globalsignDVPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 4146 1 10"
      )

  /**
   * `1.3.6.1.4.1.4146.1.80`: Globalsign policy
   */
  public val globalsignEDIClientPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 4146 1 80"
      )

  /**
   * `1.3.6.1.4.1.4146.1.81`: Globalsign policy
   */
  public val globalsignEDIServerPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 4146 1 81"
      )

  /**
   * `1.3.6.1.4.1.4146.1.95`: Globalsign policy
   */
  public val globalsignOCSPPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 4146 1 95"
      )

  /**
   * `1.3.6.1.4.1.4146.1.20`: Globalsign policy
   */
  public val globalsignOVPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 4146 1 20"
      )

  /**
   * `1.3.6.1.4.1.4146.1`: Globalsign
   */
  public val globalsignPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 4146 1"
      )

  /**
   * `1.3.6.1.4.1.4146.1.60`: Globalsign policy
   */
  public val globalsignRootSignPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 4146 1 60"
      )

  /**
   * `1.3.6.1.4.1.4146.1.90`: Globalsign policy
   */
  public val globalsignTPMRootPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 4146 1 90"
      )

  /**
   * `1.3.6.1.4.1.4146.1.30`: Globalsign policy
   */
  public val globalsignTSAPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 4146 1 30"
      )

  /**
   * `1.3.6.1.4.1.4146.1.70`: Globalsign policy
   */
  public val globalsignTrustedRootPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 4146 1 70"
      )

  /**
   * `1.2.156.10197.6.1.1`: China GM Standards Committee
   */
  public val gmtAlgorithmClass: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 156 10197 6 1 1"
      )

  /**
   * `1.2.156.10197.1.100`: China GM Standards Committee
   */
  public val gmtBlockCipher: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 156 10197 1 100"
      )

  /**
   * `1.2.156.10197.4.3`: China GM Standards Committee
   */
  public val gmtCertificateAuthority: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 156 10197 4 3"
      )

  /**
   * `1.2.156.10197.6.1.2.1`: China GM Standards Committee
   */
  public val gmtCryptoID: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 156 10197 6 1 2 1"
      )

  /**
   * `1.2.156.10197.1`: China GM Standards Committee
   */
  public val gmtCryptographicAlgorithm: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 156 10197 1"
      )

  /**
   * `1.2.156.10197.6.2`: China GM Standards Committee
   */
  public val gmtDeviceClass: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 156 10197 6 2"
      )

  /**
   * `1.2.156.10197.1.500`: China GM Standards Committee
   */
  public val gmtDigestSigning: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 156 10197 1 500"
      )

  /**
   * `1.2.156.10197.6.1`: China GM Standards Committee
   */
  public val gmtFoundationClass: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 156 10197 6 1"
      )

  /**
   * `1.2.156.10197.1.400`: China GM Standards Committee
   */
  public val gmtHashAlgorithm: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 156 10197 1 400"
      )

  /**
   * `1.2.156.10197.6.1.2`: China GM Standards Committee
   */
  public val gmtIDClass: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 156 10197 6 1 2"
      )

  /**
   * `1.2.156.10197.6.4`: China GM Standards Committee
   */
  public val gmtInfrastructure: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 156 10197 6 4"
      )

  /**
   * `1.2.156.10197.6.6`: China GM Standards Committee
   */
  public val gmtManagementClass: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 156 10197 6 6"
      )

  /**
   * `1.2.156.10197.6.1.3`: China GM Standards Committee
   */
  public val gmtOperationModes: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 156 10197 6 1 3"
      )

  /**
   * `1.2.156.10197.1.300`: China GM Standards Committee
   */
  public val gmtPublicKeyCryptography: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 156 10197 1 300"
      )

  /**
   * `1.2.156.10197.6.5.1`: China GM Standards Committee
   */
  public val gmtRandomTestingClass: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 156 10197 6 5 1"
      )

  /**
   * `1.2.156.10197.6.1.4.2`: China GM Standards Committee
   */
  public val gmtSM2CryptographicMessageSyntax: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 156 10197 6 1 4 2"
      )

  /**
   * `1.2.156.10197.6.1.4.1`: China GM Standards Committee
   */
  public val gmtSM2Specification: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 156 10197 6 1 4 1"
      )

  /**
   * `1.2.156.10197.1.302`: China GM Standards Committee
   */
  public val gmtSM9IBE: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 156 10197 1 302"
      )

  /**
   * `1.2.156.10197.6.1.4`: China GM Standards Committee
   */
  public val gmtSecurityMechanism: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 156 10197 6 1 4"
      )

  /**
   * `1.2.156.10197.6.3`: China GM Standards Committee
   */
  public val gmtServiceClass: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 156 10197 6 3"
      )

  /**
   * `1.2.156.10197.6`: China GM Standards Committee
   */
  public val gmtStandardClass: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 156 10197 6"
      )

  /**
   * `1.2.156.10197.1.200`: China GM Standards Committee
   */
  public val gmtStreamCipher: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 156 10197 1 200"
      )

  /**
   * `1.2.156.10197.6.5`: China GM Standards Committee
   */
  public val gmtTestingClass: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 156 10197 6 5"
      )

  /**
   * `1.3.6.1.4.1.11591`: GNU Project (see https://www.gnupg.org/oids.html)
   */
  public val gnu: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 11591"
      )

  /**
   * `1.3.6.1.4.1.11591.12`: GNU digest algorithm
   */
  public val gnuDigestAlgorithm: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 11591 12"
      )

  /**
   * `1.3.6.1.4.1.11591.13`: GNU encryption algorithm
   */
  public val gnuEncryptionAlgorithm: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 11591 13"
      )

  /**
   * `1.3.6.1.4.1.11591.3`: GNU Radar
   */
  public val gnuRadar: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 11591 3"
      )

  /**
   * `1.3.6.1.4.1.11591.1`: GNU Radius
   */
  public val gnuRadius: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 11591 1"
      )

  /**
   * `0.2.262.1.10.7.37`: Telesec attribute
   */
  public val goNumber: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 7 37"
      )

  /**
   * `1.3.6.1.4.1.11129.2.4.5`: Google Certificate Transparency
   */
  public val googleOcspSignedCertificateTimestamp: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 11129 2 4 5"
      )

  /**
   * `1.3.6.1.4.1.11129.2.4.4`: Google Certificate Transparency
   */
  public val googlePrecertificateCA: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 11129 2 4 4"
      )

  /**
   * `1.3.6.1.4.1.11129.2.4.3`: Google Certificate Transparency
   */
  public val googlePrecertificatePoison: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 11129 2 4 3"
      )

  /**
   * `1.3.6.1.4.1.11129.2.4.2`: Google Certificate Transparency
   */
  public val googleSignedCertificateTimestamp: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 11129 2 4 2"
      )

  /**
   * `1.2.643.7.1.1.2.2`: GOST R 34.11-2012 256 bit digest
   */
  public val gost2012Digest256: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 7 1 1 2 2"
      )

  /**
   * `1.2.643.7.1.1.2.3`: GOST R 34.11-2012 512 bit digest
   */
  public val gost2012Digest512: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 7 1 1 2 3"
      )

  /**
   * `1.2.643.7.1.1.1.1`: GOST R 34.10-2012 256 bit public key
   */
  public val gost2012PublicKey256: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 7 1 1 1 1"
      )

  /**
   * `1.2.643.7.1.1.1.2`: GOST R 34.10-2012 512 bit public key
   */
  public val gost2012PublicKey512: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 7 1 1 1 2"
      )

  /**
   * `1.2.643.7.1.1.3.2`: GOST R 34.10-2012 256 bit signature
   */
  public val gost2012Signature256: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 7 1 1 3 2"
      )

  /**
   * `1.2.643.7.1.1.3.3`: GOST R 34.10-2012 512 bit signature
   */
  public val gost2012Signature512: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 7 1 1 3 3"
      )

  /**
   * `1.2.643.2.2.20`: GOST R 34.10-94 public key. Obsoleted by GOST R 34.10-2001
   */
  public val gost94PublicKey: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 2 2 20"
      )

  /**
   * `1.2.643.2.2.4`: GOST R 34.10-94 + GOST R 34.11-94 signature. Obsoleted by GOST R 34.10-2001
   */
  public val gost94Signature: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 2 2 4"
      )

  /**
   * `1.2.643.2.2.21`: GOST 28147-89 (symmetric key block cipher)
   */
  public val gostCipher: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 2 2 21"
      )

  /**
   * `1.2.643.2.2.9`: GOST R 34.11-94 digest
   */
  public val gostDigest: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 2 2 9"
      )

  /**
   * `1.2.643.2.2.19`: GOST R 34.10-2001 (ECC) public key
   */
  public val gostPublicKey: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 2 2 19"
      )

  /**
   * `1.2.643.2.2.3`: GOST R 34.10-2001 + GOST R 34.11-94 signature
   */
  public val gostSignature: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 2 2 3"
      )

  /**
   * `1.2.643.2.2.13.0`: Wrap key using GOST 28147-89 key
   */
  public val gostWrap: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 2 2 13 0"
      )

  /**
   * `1.3.6.1.4.1.11591.2.3.1`: CMS ct for a binary PGP keyblock
   */
  public val gpgCtPgpKeyblock: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 11591 2 3 1"
      )

  /**
   * `1.3.6.1.4.1.11591.2.4.1.1`: LDAP keyserver attribute
   */
  public val gpgFingerprint: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 11591 2 4 1 1"
      )

  /**
   * `1.3.6.1.4.1.11591.2.12242973`: 0xBAD01D to indicate an invalid encoded OID
   */
  public val gpgInvalidOid: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 11591 2 12242973"
      )

  /**
   * `1.3.6.1.4.1.11591.2.4.1.3`: LDAP keyserver attribute
   */
  public val gpgMailbox: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 11591 2 4 1 3"
      )

  /**
   * `1.3.6.1.4.1.11591.2.5.1`: LDAP URL ext, auth with current AD user
   */
  public val gpgNtds: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 11591 2 5 1"
      )

  /**
   * `1.3.6.1.4.1.11591.2.4.1.4`: LDAP keyserver attribute
   */
  public val gpgSubCertID: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 11591 2 4 1 4"
      )

  /**
   * `1.3.6.1.4.1.11591.2.4.1.2`: LDAP keyserver attribute
   */
  public val gpgSubFingerprint: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 11591 2 4 1 2"
      )

  /**
   * `1.3.6.1.4.1.11591.2.2.10`: Description of ECC params
   */
  public val gpgX509PgpKdfKekParm: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 11591 2 2 10"
      )

  /**
   * `1.3.6.1.4.1.11591.2.6.4`: X.509 encoded PGP key usage
   */
  public val gpgX509PgpUseAuth: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 11591 2 6 4"
      )

  /**
   * `1.3.6.1.4.1.11591.2.6.1`: X.509 encoded OpenPGP key usage
   */
  public val gpgX509PgpUseCert: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 11591 2 6 1"
      )

  /**
   * `1.3.6.1.4.1.11591.2.6.3`: X.509 encoded PGP key usage
   */
  public val gpgX509PgpUseEncr: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 11591 2 6 3"
      )

  /**
   * `1.3.6.1.4.1.11591.2.6.2`: X.509 encoded PGP key usage
   */
  public val gpgX509PgpUseSign: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 11591 2 6 2"
      )

  /**
   * `1.3.6.1.4.1.11591.2.2.1`: Cert is intentionally self-signed.
   */
  public val gpgX509StandaloneCert: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 11591 2 2 1"
      )

  /**
   * `1.3.6.1.4.1.11591.2.2.2`: Mark cert as having a well known key
   */
  public val gpgX509WellKnownPrivateKey: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 11591 2 2 2"
      )

  /**
   * `1.3.6.1.5.5.7.10.4`: PKIX attribute certificate extension
   */
  public val group: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 10 4"
      )

  /**
   * `2.5.29.66`: X.509 extension
   */
  public val groupAC: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 66"
      )

  /**
   * `2.5.6.9`: X.520 objectClass
   */
  public val groupOfNames: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 6 9"
      )

  /**
   * `2.5.6.17`: X.520 objectClass
   */
  public val groupOfUniqueNames: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 6 17"
      )

  /**
   * `2.16.840.1.101.2.1.5.48`: SDN.700 INFOSEC attributes (obsolete)
   */
  public val guard: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 5 48"
      )

  /**
   * `1.2.410.200004.1.2`: Korean hash algorithm
   */
  public val has160: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200004 1 2"
      )

  /**
   * `1.3.36.3.2`: Teletrust algorithm
   */
  public val hashAlgorithm: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 2"
      )

  /**
   * `2.16.840.1.101.3.4.2`: NIST Algorithm
   */
  public val hashAlgos: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 4 2"
      )

  /**
   * `1.3.6.1.4.1.51483.2.1`: CTIA
   */
  public val hashOfRootKey: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 51483 2 1"
      )

  /**
   * `0.2.262.1.10.1.3.6`: Telesec one-way function
   */
  public val hashUsingBlockCipher: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 1 3 6"
      )

  /**
   * `2.23.42.7.0`: SET cert extension
   */
  public val hashedRootKey: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 7 0"
      )

  /**
   * `0.2.262.1.10.1.1.9`: Telesec signature
   */
  public val hbciRsaSignature: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 1 1 9"
      )

  /**
   * `1.2.840.10065.2.3`: ASTM 31.20
   */
  public val healthcareLicense: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10065 2 3"
      )

  /**
   * `1.2.840.113549.1.9.16.3.28`: S/MIME Algorithms
   */
  public val hkdfWithSha256: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 3 28"
      )

  /**
   * `1.2.840.113549.1.9.16.3.29`: S/MIME Algorithms
   */
  public val hkdfWithSha384: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 3 29"
      )

  /**
   * `1.2.840.113549.1.9.16.3.30`: S/MIME Algorithms
   */
  public val hkdfWithSha512: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 3 30"
      )

  /**
   * `1.2.643.2.2.10`: HMAC with GOST R 34.11-94
   */
  public val hmacGost: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 2 2 10"
      )

  /**
   * `1.3.6.1.5.5.8.1.1`: ISAKMP HMAC algorithm
   */
  public val hmacMD5: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 8 1 1"
      )

  /**
   * `1.3.6.1.5.5.8.1.2`: ISAKMP HMAC algorithm
   */
  public val hmacSHA: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 8 1 2"
      )

  /**
   * `1.3.6.1.5.5.8.1.3`: ISAKMP HMAC algorithm
   */
  public val hmacTiger: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 8 1 3"
      )

  /**
   * `1.2.840.113549.1.9.16.3.11`: S/MIME Algorithms
   */
  public val hmacWith3DESwrap: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 3 11"
      )

  /**
   * `1.2.840.113549.1.9.16.3.12`: S/MIME Algorithms
   */
  public val hmacWithAESwrap: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 3 12"
      )

  /**
   * `1.2.840.113549.2.7`: RSADSI digestAlgorithm
   */
  public val hmacWithSHA1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 2 7"
      )

  /**
   * `1.2.840.113549.2.8`: RSADSI digestAlgorithm
   */
  public val hmacWithSHA224: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 2 8"
      )

  /**
   * `1.2.840.113549.2.9`: RSADSI digestAlgorithm
   */
  public val hmacWithSHA256: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 2 9"
      )

  /**
   * `1.2.840.113549.2.10`: RSADSI digestAlgorithm
   */
  public val hmacWithSHA384: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 2 10"
      )

  /**
   * `1.2.840.113549.2.11`: RSADSI digestAlgorithm
   */
  public val hmacWithSHA512: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 2 11"
      )

  /**
   * `2.5.29.69`: X.509 extension
   */
  public val holderNameConstraints: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 69"
      )

  /**
   * `1.2.840.10040.2`: ANSI X9.57
   */
  public val holdinstruction: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10040 2"
      )

  /**
   * `1.2.840.10040.2.1`: ANSI X9.57 hold instruction
   */
  public val holdinstruction_none: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10040 2 1"
      )

  /**
   * `1.3.18.0.2.18.1`: IBM RACF ID mapping
   */
  public val hostIDMapping: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 18 0 2 18 1"
      )

  /**
   * `2.5.4.51`: X.520 DN component
   */
  public val houseIdentifier: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 51"
      )

  /**
   * `1.2.840.113549.1.9.16.3.17`: S/MIME Algorithms
   */
  public val hssLmsHashSig: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 3 17"
      )

  /**
   * `1.2.840.113549.1.9.16.1.38`: S/MIME Content Types
   */
  public val htmlWithCRLF: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 1 38"
      )

  /**
   * `1.3.6.1.5.5.8.2.2`: IKE ???
   */
  public val iKEIntermediate: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 8 2 2"
      )

  /**
   * `1.3.6.1.4.1.3576.7.65`: TMN EDI for Interactive Agents
   */
  public val iaReceiptMessage: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 3576 7 65"
      )

  /**
   * `1.3.6.1.4.1.3576.7.97`: TMN EDI for Interactive Agents
   */
  public val iaStatusMessage: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 3576 7 97"
      )

  /**
   * `1.3.133.16.840.9.84.4.1.16`: X9.84 IBIA Format Owner
   */
  public val ibiaOwnerA3Vision: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 133 16 840 9 84 4 1 16"
      )

  /**
   * `1.3.133.16.840.9.84.4.1.2`: X9.84 IBIA Format Owner
   */
  public val ibiaOwnerBioscrypt: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 133 16 840 9 84 4 1 2"
      )

  /**
   * `1.3.133.16.840.9.84.4.1.7`: X9.84 IBIA Format Owner
   */
  public val ibiaOwnerCyberSIGN: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 133 16 840 9 84 4 1 7"
      )

  /**
   * `1.3.133.16.840.9.84.4.1.13`: X9.84 IBIA Format Owner
   */
  public val ibiaOwnerDERMALOG: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 133 16 840 9 84 4 1 13"
      )

  /**
   * `1.3.133.16.840.9.84.4.1.9`: X9.84 IBIA Format Owner
   */
  public val ibiaOwnerFingerprintCardsAB: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 133 16 840 9 84 4 1 9"
      )

  /**
   * `1.3.133.16.840.9.84.4.1.12`: X9.84 IBIA Format Owner
   */
  public val ibiaOwnerIdentix: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 133 16 840 9 84 4 1 12"
      )

  /**
   * `1.3.133.16.840.9.84.4.1.4`: X9.84 IBIA Format Owner
   */
  public val ibiaOwnerInfineonTechnologiesAG: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 133 16 840 9 84 4 1 4"
      )

  /**
   * `1.3.133.16.840.9.84.4.1.5`: X9.84 IBIA Format Owner
   */
  public val ibiaOwnerIridianTechnologies: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 133 16 840 9 84 4 1 5"
      )

  /**
   * `1.3.133.16.840.9.84.4.1.14`: X9.84 IBIA Format Owner
   */
  public val ibiaOwnerLOGICO: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 133 16 840 9 84 4 1 14"
      )

  /**
   * `1.3.133.16.840.9.84.4.1.17`: X9.84 IBIA Format Owner
   */
  public val ibiaOwnerNEC: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 133 16 840 9 84 4 1 17"
      )

  /**
   * `1.3.133.16.840.9.84.4.1.15`: X9.84 IBIA Format Owner
   */
  public val ibiaOwnerNIST: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 133 16 840 9 84 4 1 15"
      )

  /**
   * `1.3.133.16.840.9.84.4.1.11`: X9.84 IBIA Format Owner
   */
  public val ibiaOwnerPreciseBiometric: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 133 16 840 9 84 4 1 11"
      )

  /**
   * `1.3.133.16.840.9.84.4.1.1`: X9.84 IBIA Format Owner
   */
  public val ibiaOwnerSAFLINK: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 133 16 840 9 84 4 1 1"
      )

  /**
   * `1.3.133.16.840.9.84.4.1.18`: X9.84 IBIA Format Owner
   */
  public val ibiaOwnerSTMicroelectronics: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 133 16 840 9 84 4 1 18"
      )

  /**
   * `1.3.133.16.840.9.84.4.1.10`: X9.84 IBIA Format Owner
   */
  public val ibiaOwnerSecuGen: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 133 16 840 9 84 4 1 10"
      )

  /**
   * `1.3.133.16.840.9.84.4.1.6`: X9.84 IBIA Format Owner
   */
  public val ibiaOwnerVeridicom: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 133 16 840 9 84 4 1 6"
      )

  /**
   * `1.3.133.16.840.9.84.4.1.3`: X9.84 IBIA Format Owner
   */
  public val ibiaOwnerVisionics: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 133 16 840 9 84 4 1 3"
      )

  /**
   * `1.3.133.16.840.9.84.4.1.8`: X9.84 IBIA Format Owner
   */
  public val ibiaOwnereCryp: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 133 16 840 9 84 4 1 8"
      )

  /**
   * `1.3.27.16.1.2.1.1`: ICAO certificate policies
   */
  public val icaoCAODBridgeCA: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 27 16 1 2 1 1"
      )

  /**
   * `1.3.27.16.1.2.1.0`: ICAO certificate policies
   */
  public val icaoCAODRootCA: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 27 16 1 2 1 0"
      )

  /**
   * `1.3.27.16.1`: ICAO certificate policies
   */
  public val icaoCertPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 27 16 1"
      )

  /**
   * `1.3.27.16.1.2.1.1.1.1.1.1`: ICAO certificate policies
   */
  public val icaoFAAClientCertificate: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 27 16 1 2 1 1 1 1 1 1"
      )

  /**
   * `1.3.27.16.1.2.1.1.1.1.1`: ICAO certificate policies
   */
  public val icaoFAAIssuingCA: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 27 16 1 2 1 1 1 1 1"
      )

  /**
   * `1.3.27.16.1.2.1.1.1.1`: ICAO certificate policies
   */
  public val icaoFAARootCA: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 27 16 1 2 1 1 1 1"
      )

  /**
   * `1.3.27.16.1.2.1.1.1.1.1.3`: ICAO certificate policies
   */
  public val icaoFAASWIMSigningCertificate: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 27 16 1 2 1 1 1 1 1 3"
      )

  /**
   * `1.3.27.16.1.2.1.1.1.1.1.2`: ICAO certificate policies
   */
  public val icaoFAAServerCertificate: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 27 16 1 2 1 1 1 1 1 2"
      )

  /**
   * `1.3.27.16.1.2.1`: ICAO certificate policies
   */
  public val icaoIATFBridgeCA: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 27 16 1 2 1"
      )

  /**
   * `1.3.27.16.1.2`: ICAO certificate policies
   */
  public val icaoIATFRootCA: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 27 16 1 2"
      )

  /**
   * `1.3.27.16.1.2.0.1`: ICAO certificate policies
   */
  public val icaoIdentityAssurance: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 27 16 1 2 0 1"
      )

  /**
   * `1.3.27.16.1.2.0.1.9`: ICAO certificate policies
   */
  public val icaoIdentityAssuranceHigh: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 27 16 1 2 0 1 9"
      )

  /**
   * `1.3.27.16.1.2.0.1.10`: ICAO certificate policies
   */
  public val icaoIdentityAssuranceHighCardAuth: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 27 16 1 2 0 1 10"
      )

  /**
   * `1.3.27.16.1.2.0.1.11`: ICAO certificate policies
   */
  public val icaoIdentityAssuranceHighContentSigning: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 27 16 1 2 0 1 11"
      )

  /**
   * `1.3.27.16.1.2.0.1.1`: ICAO certificate policies
   */
  public val icaoIdentityAssuranceLow: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 27 16 1 2 0 1 1"
      )

  /**
   * `1.3.27.16.1.2.0.1.2`: ICAO certificate policies
   */
  public val icaoIdentityAssuranceLowDevice: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 27 16 1 2 0 1 2"
      )

  /**
   * `1.3.27.16.1.2.0.1.3`: ICAO certificate policies
   */
  public val icaoIdentityAssuranceLowTSPMediated: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 27 16 1 2 0 1 3"
      )

  /**
   * `1.3.27.16.1.2.0.1.4`: ICAO certificate policies
   */
  public val icaoIdentityAssuranceMedium: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 27 16 1 2 0 1 4"
      )

  /**
   * `1.3.27.16.1.2.0.1.5`: ICAO certificate policies
   */
  public val icaoIdentityAssuranceMediumDevice: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 27 16 1 2 0 1 5"
      )

  /**
   * `1.3.27.16.1.2.0.1.8`: ICAO certificate policies
   */
  public val icaoIdentityAssuranceMediumDeviceHardware: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 27 16 1 2 0 1 8"
      )

  /**
   * `1.3.27.16.1.2.0.1.7`: ICAO certificate policies
   */
  public val icaoIdentityAssuranceMediumHardware: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 27 16 1 2 0 1 7"
      )

  /**
   * `1.3.27.16.1.2.0.1.6`: ICAO certificate policies
   */
  public val icaoIdentityAssuranceMediumTSPMediated: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 27 16 1 2 0 1 6"
      )

  /**
   * `1.3.27.16.1.4.1.1`: ICAO extended key usage
   */
  public val icaoSWIMSigning: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 27 16 1 4 1 1"
      )

  /**
   * `1.3.27.16`: ICAO security
   */
  public val icaoSecurity: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 27 16"
      )

  /**
   * `1.3.27.16.0`: ICAO security test?
   */
  public val icaoSecurity_1_3_27_16_0: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 27 16 0"
      )

  /**
   * `1.3.27.16.0.1.1.1.1.1.1.0`: ICAO security test?
   */
  public val icaoTestValidationPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 27 16 0 1 1 1 1 1 1 0"
      )

  /**
   * `1.3.27.16.1.2.1.1.1`: ICAO certificate policies
   */
  public val icaoUSBridgeCA: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 27 16 1 2 1 1 1"
      )

  /**
   * `1.2.840.113549.1.9.16.0`: id-sMIME
   */
  public val id_mod: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 0"
      )

  /**
   * `1.2.840.113549.1.9.16.0.1`: S/MIME Modules
   */
  public val id_mod_cms: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 0 1"
      )

  /**
   * `1.2.840.113549.1.9.16.0.2`: S/MIME Modules
   */
  public val id_mod_ess: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 0 2"
      )

  /**
   * `1.2.840.113549.1.9.16.0.7`: S/MIME Modules
   */
  public val id_mod_ets_eSigPolicy_88: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 0 7"
      )

  /**
   * `1.2.840.113549.1.9.16.0.8`: S/MIME Modules
   */
  public val id_mod_ets_eSigPolicy_88_1_2_840_113549_1_9_16_0_8: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 0 8"
      )

  /**
   * `1.2.840.113549.1.9.16.0.5`: S/MIME Modules
   */
  public val id_mod_ets_eSignature_88: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 0 5"
      )

  /**
   * `1.2.840.113549.1.9.16.0.6`: S/MIME Modules
   */
  public val id_mod_ets_eSignature_97: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 0 6"
      )

  /**
   * `1.2.840.113549.1.9.16.0.4`: S/MIME Modules
   */
  public val id_mod_msg_v3: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 0 4"
      )

  /**
   * `1.2.840.113549.1.9.16.0.3`: S/MIME Modules
   */
  public val id_mod_oid: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 0 3"
      )

  /**
   * `1.2.840.113549.1.9.16`: PKCS #9
   */
  public val id_sMIME: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16"
      )

  /**
   * `0.2.262.1.10.1.2.5`: Telesec encryption
   */
  public val idea: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 1 2 5"
      )

  /**
   * `0.2.262.1.10.1.2.5.2`: Telesec encryption
   */
  public val ideaCBC: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 1 2 5 2"
      )

  /**
   * `1.3.36.3.1.2.2`: Teletrust encryption algorithm
   */
  public val ideaCBC_1_3_36_3_1_2_2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 1 2 2"
      )

  /**
   * `1.3.6.1.4.1.188.7.1.1.2`: Ascom Systech
   */
  public val ideaCBC_1_3_6_1_4_1_188_7_1_1_2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 188 7 1 1 2"
      )

  /**
   * `1.3.36.3.1.2.2.1.1`: Teletrust encryption algorithm
   */
  public val ideaCBC_ISOpad: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 1 2 2 1 1"
      )

  /**
   * `1.3.36.3.1.2.2.1`: Teletrust encryption algorithm
   */
  public val ideaCBC_pad: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 1 2 2 1"
      )

  /**
   * `1.3.6.1.4.1.188.7.1.1.3`: Ascom Systech
   */
  public val ideaCFB: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 188 7 1 1 3"
      )

  /**
   * `0.2.262.1.10.1.2.5.5`: Telesec encryption
   */
  public val ideaCFB64: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 1 2 5 5"
      )

  /**
   * `0.2.262.1.10.1.2.5.4`: Telesec encryption
   */
  public val ideaCFB8: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 1 2 5 4"
      )

  /**
   * `1.3.36.3.1.2.4`: Teletrust encryption algorithm
   */
  public val ideaCFB_1_3_36_3_1_2_4: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 1 2 4"
      )

  /**
   * `0.2.262.1.10.1.2.5.1`: Telesec encryption
   */
  public val ideaECB: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 1 2 5 1"
      )

  /**
   * `1.3.36.3.1.2.1`: Teletrust encryption algorithm
   */
  public val ideaECB_1_3_36_3_1_2_1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 1 2 1"
      )

  /**
   * `1.3.6.1.4.1.188.7.1.1.1`: Ascom Systech
   */
  public val ideaECB_1_3_6_1_4_1_188_7_1_1_1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 188 7 1 1 1"
      )

  /**
   * `1.3.36.3.1.2.1.1.1`: Teletrust encryption algorithm
   */
  public val ideaECB_ISOpad: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 1 2 1 1 1"
      )

  /**
   * `1.3.36.3.1.2.1.1`: Teletrust encryption algorithm
   */
  public val ideaECB_pad: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 1 2 1 1"
      )

  /**
   * `0.2.262.1.10.1.2.5.3`: Telesec encryption
   */
  public val ideaOFB: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 1 2 5 3"
      )

  /**
   * `1.3.36.3.1.2.3`: Teletrust encryption algorithm
   */
  public val ideaOFB_1_3_36_3_1_2_3: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 1 2 3"
      )

  /**
   * `1.3.6.1.4.1.188.7.1.1.4`: Ascom Systech
   */
  public val ideaOFB_1_3_6_1_4_1_188_7_1_1_4: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 188 7 1 1 4"
      )

  /**
   * `1.3.36.3.1.2`: Teletrust encryption algorithm
   */
  public val idea_1_3_36_3_1_2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 1 2"
      )

  /**
   * `2.23.42.2.5`: SET field
   */
  public val identificationNumber: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 2 5"
      )

  /**
   * `1.2.840.114021.4.1`: Identrus
   */
  public val identrusOCSP: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 114021 4 1"
      )

  /**
   * `1.2.840.10070`: IEC 62351
   */
  public val iec62351: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10070"
      )

  /**
   * `1.2.840.10070.8`: IEC 62351-8
   */
  public val iec62351_8: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10070 8"
      )

  /**
   * `1.2.840.10070.8.1`: IEC 62351-8
   */
  public val iecUserRoles: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10070 8 1"
      )

  /**
   * `2.16.840.1.113719.1.2.8.52`: Novell signature algorithm
   */
  public val ikeHmacWithMD5_RSA: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113719 1 2 8 52"
      )

  /**
   * `2.16.840.1.113719.1.2.8.51`: Novell signature algorithm
   */
  public val ikeHmacWithSHA1_RSA: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113719 1 2 8 51"
      )

  /**
   * `1.3.6.1.5.5.7.4.13`: PKIX CMP information
   */
  public val implicitConfirm: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 4 13"
      )

  /**
   * `2.5.29.61`: X.509 extension
   */
  public val indirectIssuer: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 61"
      )

  /**
   * `1.3.6.1.4.1.311.2.1.21`: Microsoft
   */
  public val individualCodeSigning: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 2 1 21"
      )

  /**
   * `2.16.840.1.113730.3.2.2`: Netscape LDAP definitions
   */
  public val inetOrgPerson: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113730 3 2 2"
      )

  /**
   * `2.16.840.1.101.2.1.8.3.3`: SDN.700 INFOSEC security category from RFC 7906
   */
  public val informativeAttrs: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 8 3 3"
      )

  /**
   * `2.5.29.54`: X.509 extension
   */
  public val inhibitAnyPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 54"
      )

  /**
   * `2.5.4.43`: X.520 DN component
   */
  public val initials: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 43"
      )

  /**
   * `2.5.29.23`: X.509 extension
   */
  public val instructionCode: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 23"
      )

  /**
   * `2.5.4.104`: X.520 DN component
   */
  public val intEmail: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 104"
      )

  /**
   * `1.3.36.8.3.6`: Teletrust attribute
   */
  public val integratedCircuitCardSerialNumber: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 3 6"
      )

  /**
   * `1.3.6.1.4.1.3576.7.5`: TMN EDI for Interactive Agents
   */
  public val integrityEDImessage: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 3576 7 5"
      )

  /**
   * `2.16.840.1.113741.2`: Intel CDSA
   */
  public val intelCDSA: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113741 2"
      )

  /**
   * `1.2.840.113549.1.9.16.2.33`: S/MIME Authenticated Attributes.  Obsolete
   */
  public val intendedRecipients: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 33"
      )

  /**
   * `2.5.4.25`: X.520 DN component
   */
  public val internationalISDNNumber: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 25"
      )

  /**
   * `2.5.29.24`: X.509 extension
   */
  public val invalidityDate: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 24"
      )

  /**
   * `1.3.6.1.5.5.7.1.7`: PKIX private extension
   */
  public val ipAddrBlocks: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 1 7"
      )

  /**
   * `1.3.6.1.5.5.7.1.28`: PKIX private extension
   */
  public val ipAddrBlocksV2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 1 28"
      )

  /**
   * `1.3.6.1.5.5.7.3.5`: PKIX key purpose
   */
  public val ipsecEndSystem: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 3 5"
      )

  /**
   * `1.3.6.1.5.5.7.3.17`: PKIX key purpose
   */
  public val ipsecIKE: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 3 17"
      )

  /**
   * `1.3.6.1.5.5.7.3.6`: PKIX key purpose
   */
  public val ipsecTunnel: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 3 6"
      )

  /**
   * `1.3.6.1.5.5.7.3.7`: PKIX key purpose
   */
  public val ipsecUser: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 3 7"
      )

  /**
   * `1.0.18033.2`: ISO 18033-2
   */
  public val iso18033_2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 0 18033 2"
      )

  /**
   * `1.3.6.1.4.1.311.21.17`: Microsoft
   */
  public val issuedCertHash: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 21 17"
      )

  /**
   * `2.5.29.64`: X.509 extension
   */
  public val issuedOnBehalfOf: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 64"
      )

  /**
   * `0.2.262.1.10.7.6`: Telesec attribute
   */
  public val issuer: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 7 6"
      )

  /**
   * `2.5.29.8`: X.509 extension.  Deprecated, use 2 5 29 18 instead
   */
  public val issuerAltName: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 8"
      )

  /**
   * `2.5.29.18`: X.509 extension
   */
  public val issuerAltName_2_5_29_18: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 18"
      )

  /**
   * `1.2.840.113549.1.9.10`: PKCS #9 experimental
   */
  public val issuerAndSerialNumber: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 10"
      )

  /**
   * `2.5.29.26`: X.509 extension.  Deprecated, use 2 5 29 28 instead
   */
  public val issuingDistributionPoint: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 26"
      )

  /**
   * `2.5.29.28`: X.509 extension
   */
  public val issuingDistributionPoint_2_5_29_28: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 28"
      )

  /**
   * `2.16.840.1.101.2.1.5.20`: SDN.700 INFOSEC attributes
   */
  public val janUKMs: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 5 20"
      )

  /**
   * `2.5.4.105`: X.520 DN component
   */
  public val jid: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 105"
      )

  /**
   * `2.16.840.1.101.2.1.5.26`: SDN.700 INFOSEC attributes
   */
  public val julUKMs: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 5 26"
      )

  /**
   * `2.16.840.1.101.2.1.5.25`: SDN.700 INFOSEC attributes
   */
  public val junUKMs: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 5 25"
      )

  /**
   * `1.3.6.1.4.1.311.60.2.1.3`: Microsoft (???)
   */
  public val jurisdictionOfIncorporationC: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 60 2 1 3"
      )

  /**
   * `1.3.6.1.4.1.311.60.2.1.1`: Microsoft (???)
   */
  public val jurisdictionOfIncorporationL: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 60 2 1 1"
      )

  /**
   * `1.3.6.1.4.1.311.60.2.1.2`: Microsoft (???)
   */
  public val jurisdictionOfIncorporationSP: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 60 2 1 2"
      )

  /**
   * `1.3.6.1.5.5.7.1.27`: PKIX private extension
   */
  public val jwtClaimConstraints: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 1 27"
      )

  /**
   * `2.16.840.1.101.2.1.1.24`: SDN.700 INFOSEC algorithms
   */
  public val kEAKeyEncryptionAlgorithm: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 1 24"
      )

  /**
   * `2.16.840.1.101.3.2.3.3`: CSOR GAK extensions
   */
  public val kR: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 2 3 3"
      )

  /**
   * `2.16.840.1.101.3.2.2.1`: CSOR GAK extended key usage
   */
  public val kRAKey: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 2 2 1"
      )

  /**
   * `2.16.840.1.101.3.2.3.1`: CSOR GAK extensions
   */
  public val kRTechnique: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 2 3 1"
      )

  /**
   * `2.16.840.1.101.3.2.3.2`: CSOR GAK extensions
   */
  public val kRecoveryCapable: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 2 3 2"
      )

  /**
   * `2.16.840.1.101.2.1.12.0.3`: SDN.700 INFOSEC test objects
   */
  public val kafka: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 12 0 3"
      )

  /**
   * `2.16.840.1.101.2.1.12.0.3.0`: SDN.700 INFOSEC test objects
   */
  public val kafkaSecurityCategories: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 12 0 3 0"
      )

  /**
   * `2.16.840.1.101.2.1.12.0.3.0.1`: SDN.700 INFOSEC test objects
   */
  public val kafkaTagSetName1: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 12 0 3 0 1"
      )

  /**
   * `2.16.840.1.101.2.1.12.0.3.0.2`: SDN.700 INFOSEC test objects
   */
  public val kafkaTagSetName2: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 12 0 3 0 2"
      )

  /**
   * `2.16.840.1.101.2.1.12.0.3.0.3`: SDN.700 INFOSEC test objects
   */
  public val kafkaTagSetName3: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 12 0 3 0 3"
      )

  /**
   * `1.2.410.200004.1.1`: Korean DSA
   */
  public val kcdsa: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200004 1 1"
      )

  /**
   * `1.2.410.200004.1.21`: Korean DSA
   */
  public val kcdsa1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200004 1 21"
      )

  /**
   * `1.2.410.200004.1.8`: Korean signature algorithm
   */
  public val kcdsaWithHAS160: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200004 1 8"
      )

  /**
   * `1.2.410.200004.1.9`: Korean signature algorithm
   */
  public val kcdsaWithSHA1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200004 1 9"
      )

  /**
   * `1.3.6.1.5.2.3.6`: Kerberos
   */
  public val kdf: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 2 3 6"
      )

  /**
   * `1.2.840.113549.1.9.16.2.32`: S/MIME Authenticated Attributes
   */
  public val kekDerivationAlg: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 32"
      )

  /**
   * `1.0.18033.2.2`: ISO 18033-2 algorithms
   */
  public val kem: ObjectIdentifier = 
      ObjectIdentifier(
      "1 0 18033 2 2"
      )

  /**
   * `1.0.18033.2.2.4`: ISO 18033-2 KEM algorithms
   */
  public val kemRSA: ObjectIdentifier = 
      ObjectIdentifier(
      "1 0 18033 2 2 4"
      )

  /**
   * `1.3.6.1.4.1.311.61.1.1`: Microsoft extended key usage
   */
  public val kernelModeCodeSigning: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 61 1 1"
      )

  /**
   * `1.2.840.113549.1.9.16.13.2`: S/MIME Other Recipient Info Identifiers
   */
  public val keyAgreePSK: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 13 2"
      )

  /**
   * `2.5.29.2`: X.509 extension.  Obsolete, use keyUsage/extKeyUsage instead
   */
  public val keyAttributes: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 2"
      )

  /**
   * `2.16.840.1.101.2.1.1.22`: SDN.700 INFOSEC algorithms.  Formerly known as
   * mosaicKeyEncryptionAlgorithm
   */
  public val keyExchangeAlgorithm: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 1 22"
      )

  /**
   * `1.3.6.1.4.1.3029.3.1.5`: cryptlib attribute type
   */
  public val keyFeatures: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 3029 3 1 5"
      )

  /**
   * `2.16.840.1.101.2.1.2.78.6`: SDN.700 INFOSEC format and RFC 7191
   */
  public val keyPackageError: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 2 78 6"
      )

  /**
   * `2.16.840.1.101.2.1.2.78.3`: SDN.700 INFOSEC format and RFC 7191
   */
  public val keyPackageReceipt: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 2 78 3"
      )

  /**
   * `1.3.6.1.5.5.7.4.11`: PKIX CMP information
   */
  public val keyPairParamRep: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 4 11"
      )

  /**
   * `1.3.6.1.5.5.7.4.10`: PKIX CMP information
   */
  public val keyPairParamReq: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 4 10"
      )

  /**
   * `2.16.840.1.101.2.1.5.65`: SDN.700 INFOSEC attributes and RFC 7191
   */
  public val keyPkgIdAndReceiptReq: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 5 65"
      )

  /**
   * `1.3.6.1.5.5.7.3`: PKIX
   */
  public val keyPurpose: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 3"
      )

  /**
   * `1.3.6.1.5.2.3.4`: Kerberos
   */
  public val keyPurposeClientAuth: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 2 3 4"
      )

  /**
   * `1.3.6.1.5.2.3.5`: Kerberos
   */
  public val keyPurposeKdc: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 2 3 5"
      )

  /**
   * `1.3.6.1.4.1.311.10.3.11`: Microsoft extended key usage
   */
  public val keyRecovery: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 10 3 11"
      )

  /**
   * `2.16.840.1.101.3.2.4`: CSOR GAK
   */
  public val keyRecoverySchemes: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 2 4"
      )

  /**
   * `1.3.6.1.4.1.311.21.6`: Microsoft extended key usage
   */
  public val keyRecovery_1_3_6_1_4_1_311_21_6: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 21 6"
      )

  /**
   * `1.2.840.113549.1.9.16.13.1`: S/MIME Other Recipient Info Identifiers
   */
  public val keyTransPSK: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 13 1"
      )

  /**
   * `2.5.29.15`: X.509 extension
   */
  public val keyUsage: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 15"
      )

  /**
   * `2.5.29.4`: X.509 extension.  Obsolete, use keyUsage/extKeyUsage instead
   */
  public val keyUsageRestriction: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 4"
      )

  /**
   * `1.3.36.7.1`: Teletrust key management
   */
  public val keyagree: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 7 1"
      )

  /**
   * `1.3.14.3.2.23`: Oddball OIW OID
   */
  public val keyed_hash_seal: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 14 3 2 23"
      )

  /**
   * `1.3.6.1.4.1.311.10.7.1`: Microsoft attribute
   */
  public val keyidRdn: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 10 7 1"
      )

  /**
   * `1.3.36.7`: Teletrust key management
   */
  public val keymgmnt: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 7"
      )

  /**
   * `1.3.36.7.2`: Teletrust key management
   */
  public val keytrans: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 7 2"
      )

  /**
   * `1.2.410.200004.1`: KISA algorithm
   */
  public val kisaAlgorithm: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200004 1"
      )

  /**
   * `2.16.840.1.101.2.1.10.2`: SDN.700 INFOSEC privileges
   */
  public val kmPrivileges: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 10 2"
      )

  /**
   * `2.16.840.1.101.2.1.13.1`: SDN.700 INFOSEC attributes and RFC 7906
   */
  public val kmaKeyAlgorithm: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 13 1"
      )

  /**
   * `2.16.840.1.101.2.1.13.5`: SDN.700 INFOSEC attributes and RFC 7906
   */
  public val kmaKeyDistPeriod: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 13 5"
      )

  /**
   * `2.16.840.1.101.2.1.13.7`: SDN.700 INFOSEC attributes and RFC 7906
   */
  public val kmaKeyDuration: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 13 7"
      )

  /**
   * `2.16.840.1.101.2.1.13.16`: SDN.700 INFOSEC attributes and RFC 7906
   */
  public val kmaKeyPkgReceiversV2: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 13 16"
      )

  /**
   * `2.16.840.1.101.2.1.13.12`: SDN.700 INFOSEC attributes and RFC 7906
   */
  public val kmaKeyPkgType: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 13 12"
      )

  /**
   * `2.16.840.1.101.2.1.13.13`: SDN.700 INFOSEC attributes and RFC 7906
   */
  public val kmaKeyPurpose: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 13 13"
      )

  /**
   * `2.16.840.1.101.2.1.13.14`: SDN.700 INFOSEC attributes and RFC 7906
   */
  public val kmaKeyUse: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 13 14"
      )

  /**
   * `2.16.840.1.101.2.1.13.6`: SDN.700 INFOSEC attributes and RFC 7906
   */
  public val kmaKeyValidityPeriod: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 13 6"
      )

  /**
   * `2.16.840.1.101.2.1.13.21`: SDN.700 INFOSEC attributes and RFC 7906
   */
  public val kmaKeyWrapAlgorithm: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 13 21"
      )

  /**
   * `2.16.840.1.101.2.1.13.19`: SDN.700 INFOSEC attributes and RFC 7906
   */
  public val kmaOtherCertFormats: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 13 19"
      )

  /**
   * `2.16.840.1.101.2.1.13.22`: SDN.700 INFOSEC attributes and RFC 7906
   */
  public val kmaSigUsageV3: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 13 22"
      )

  /**
   * `2.16.840.1.101.2.1.13.11`: SDN.700 INFOSEC attributes and RFC 7906
   */
  public val kmaSplitID: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 13 11"
      )

  /**
   * `2.16.840.1.101.2.1.13.3`: SDN.700 INFOSEC attributes and RFC 7906
   */
  public val kmaTSECNomenclature: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 13 3"
      )

  /**
   * `2.16.840.1.101.2.1.13.15`: SDN.700 INFOSEC attributes and RFC 7906
   */
  public val kmaTransportKey: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 13 15"
      )

  /**
   * `2.16.840.1.101.2.1.13.20`: SDN.700 INFOSEC attributes and RFC 7906
   */
  public val kmaUsefulCerts: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 13 20"
      )

  /**
   * `2.16.840.1.101.3.4.2.19`: NIST Algorithm
   */
  public val kmacShake128: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 4 2 19"
      )

  /**
   * `2.16.840.1.101.3.4.2.20`: NIST Algorithm
   */
  public val kmacShake256: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 4 2 20"
      )

  /**
   * `2.5.4.2`: X.520 DN component
   */
  public val knowledgeInformation: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 2"
      )

  /**
   * `2.16.840.1.101.2.1.5.70`: SDN.700 INFOSEC attributes and RFC 7906
   */
  public val kpCrlPointers: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 5 70"
      )

  /**
   * `2.16.840.1.101.2.1.5.71`: SDN.700 INFOSEC attributes and RFC 7906
   */
  public val kpKeyProvinceV2: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 5 71"
      )

  /**
   * `2.16.840.1.101.2.1.5.72`: SDN.700 INFOSEC attributes and RFC 7906
   */
  public val kpManifest: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 5 72"
      )

  /**
   * `2.16.840.1.101.3.2.5`: CSOR GAK
   */
  public val krapola: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 2 5"
      )

  /**
   * `0.2.262.1.10.7.40`: Telesec attribute
   */
  public val ktKeyData: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 7 40"
      )

  /**
   * `0.2.262.1.10.7.41`: Telesec attribute
   */
  public val ktKeyNumber: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 7 41"
      )

  /**
   * `2.16.840.1.101.2.1.5.57`: SDN.700 INFOSEC attributes
   */
  public val labeledAttribute: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 5 57"
      )

  /**
   * `2.16.840.1.113730.3.1`: Netscape directory
   */
  public val ldapDefinitions: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113730 3 1"
      )

  /**
   * `2.5.4.95`: X.520 DN component
   */
  public val ldapUrl: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 95"
      )

  /**
   * `0.2.262.1.10.12.0`: Telesec cert/CRL extension
   */
  public val liabilityLimitationFlag: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 12 0"
      )

  /**
   * `0.2.262.1.10.7.52`: Telesec attribute
   */
  public val liabilityText: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 7 52"
      )

  /**
   * `1.2.840.10065.2.3.1.1`: ASTM 31.20 healthcare license type
   */
  public val license: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10065 2 3 1 1"
      )

  /**
   * `1.3.6.1.4.1.311.10.6.2`: Microsoft extended key usage
   */
  public val licenseServer: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 10 6 2"
      )

  /**
   * `1.3.6.1.4.1.311.10.6.1`: Microsoft extended key usage
   */
  public val licenses: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 10 6 1"
      )

  /**
   * `1.3.6.1.4.1.311.10.3.13`: Microsoft extended key usage
   */
  public val lifetimeSigning: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 10 3 13"
      )

  /**
   * `0.4.0.2042.1.3`: ETSI TS 102 042 Certificate Policies
   */
  public val lightweightCertificatePolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 2042 1 3"
      )

  /**
   * `2.16.840.1.113719.1.2.8.32`: Novell digest algorithm
   */
  public val lmDigest: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113719 1 2 8 32"
      )

  /**
   * `1.2.840.113549.1.9.21`: PKCS #9 via PKCS #12
   */
  public val localKeyID_for_PKCS_12: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 21"
      )

  /**
   * `1.3.6.1.4.1.311.17.2`: Microsoft attribute
   */
  public val localMachineKeyset: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 17 2"
      )

  /**
   * `2.5.6.3`: X.520 objectClass
   */
  public val locality: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 6 3"
      )

  /**
   * `2.5.4.7`: X.520 DN component
   */
  public val localityName: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 7"
      )

  /**
   * `1.3.36.8.6.8`: Teletrust signature attributes
   */
  public val location: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 6 8"
      )

  /**
   * `1.3.6.1.5.5.7.20`: Qualified Certificate
   */
  public val logo: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 20"
      )

  /**
   * `1.3.6.1.5.5.7.20.2`: Qualified Certificate
   */
  public val logoBackground: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 20 2"
      )

  /**
   * `1.3.6.1.5.5.7.20.1`: Qualified Certificate
   */
  public val logoLoyalty: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 20 1"
      )

  /**
   * `1.3.6.1.5.5.7.1.12`: PKIX private extension
   */
  public val logoType: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 1 12"
      )

  /**
   * `2.16.840.1.101.2.1.8.1`: SDN.700 INFOSEC security category
   */
  public val mISSISecurityCategories: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 8 1"
      )

  /**
   * `2.23.136.1.1.1`: ICAO MRTD
   */
  public val mRTDSignatureData: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 136 1 1 1"
      )

  /**
   * `0.2.262.1.10.1.3.7`: Telesec one-way function
   */
  public val mac: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 1 3 7"
      )

  /**
   * `1.2.840.113549.1.9.16.2.8`: S/MIME Authenticated Attributes.  Obsolete
   */
  public val macValue: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 8"
      )

  /**
   * `0.2.262.1.10.1.2.4`: Telesec encryption
   */
  public val magenta: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 1 2 4"
      )

  /**
   * `1.2.840.113556.1.3.46`: Microsoft Exchange Server - object class
   */
  public val mailRecipient: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113556 1 3 46"
      )

  /**
   * `1.2.840.113556.1.3.22`: Microsoft Exchange Server - object class
   */
  public val mailbox: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113556 1 3 22"
      )

  /**
   * `1.2.840.113556.1.3.17`: Microsoft Exchange Server - object class
   */
  public val mailbox_Agent: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113556 1 3 17"
      )

  /**
   * `1.3.6.1.5.5.7.1.25`: PKIX private extension
   */
  public val manufacturerUsageDescription: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 1 25"
      )

  /**
   * `1.3.6.1.5.5.7.1.30`: PKIX private extension
   */
  public val manufacturerUsageDescriptionSigner: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 1 30"
      )

  /**
   * `1.3.36.6.1`: Teletrust API
   */
  public val manufacturer_specific_api: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 6 1"
      )

  /**
   * `2.16.840.1.101.2.1.5.22`: SDN.700 INFOSEC attributes
   */
  public val marUKMs: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 5 22"
      )

  /**
   * `1.3.6.1.5.5.7.1.32`: PKIX private extension
   */
  public val masaURL: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 1 32"
      )

  /**
   * `1.2.840.113549.1.9.16.2.31`: S/MIME Authenticated Attributes
   */
  public val maxCEKDecrypts: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 31"
      )

  /**
   * `2.16.840.1.101.2.1.5.24`: SDN.700 INFOSEC attributes
   */
  public val mayUKMs: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 5 24"
      )

  /**
   * `1.2.840.113549.2.2`: RSADSI digestAlgorithm
   */
  public val md2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 2 2"
      )

  /**
   * `1.3.14.7.2.3.2`: Unsure about this OID
   */
  public val md2WithElGamal: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 14 7 2 3 2"
      )

  /**
   * `1.3.14.7.2.3.1`: Unsure about this OID
   */
  public val md2WithRSA: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 14 7 2 3 1"
      )

  /**
   * `1.2.840.113549.1.1.2`: PKCS #1
   */
  public val md2WithRSAEncryption: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 1 2"
      )

  /**
   * `2.16.840.1.113719.1.2.8.29`: Novell signature algorithm
   */
  public val md2WithRSAEncryptionBSafe1: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113719 1 2 8 29"
      )

  /**
   * `1.3.14.3.2.24`: Oddball OIW OID using 9796-2 padding rules
   */
  public val md2WithRSASignature: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 14 3 2 24"
      )

  /**
   * `2.16.840.1.113719.1.2.8.40`: Novell digest algorithm
   */
  public val md2_2_16_840_1_113719_1_2_8_40: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113719 1 2 8 40"
      )

  /**
   * `0.2.262.1.10.1.3.1`: Telesec one-way function
   */
  public val md4: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 1 3 1"
      )

  /**
   * `2.16.840.1.113719.1.2.8.130`: Novell keyed hash
   */
  public val md4Packet: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113719 1 2 8 130"
      )

  /**
   * `1.3.14.3.2.2`: Oddball OIW OID
   */
  public val md4WitRSA: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 14 3 2 2"
      )

  /**
   * `0.2.262.1.10.1.1.1`: Telesec mechanism
   */
  public val md4WithRSAAndISO9697: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 1 1 1"
      )

  /**
   * `0.2.262.1.10.1.1.2`: Telesec mechanism
   */
  public val md4WithRSAAndTelesecSignatureStandard: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 1 1 2"
      )

  /**
   * `1.2.840.113549.1.1.3`: PKCS #1
   */
  public val md4WithRSAEncryption: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 1 3"
      )

  /**
   * `1.3.14.3.2.4`: Oddball OIW OID
   */
  public val md4WithRSAEncryption_1_3_14_3_2_4: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 14 3 2 4"
      )

  /**
   * `1.2.840.113549.2.4`: RSADSI digestAlgorithm
   */
  public val md4_1_2_840_113549_2_4: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 2 4"
      )

  /**
   * `2.16.840.1.113719.1.2.8.95`: Novell digest algorithm
   */
  public val md4_2_16_840_1_113719_1_2_8_95: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113719 1 2 8 95"
      )

  /**
   * `0.2.262.1.10.1.3.2`: Telesec one-way function
   */
  public val md5: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 1 3 2"
      )

  /**
   * `1.3.14.3.2.3`: Oddball OIW OID
   */
  public val md5WithRSA: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 14 3 2 3"
      )

  /**
   * `0.2.262.1.10.1.1.3`: Telesec mechanism
   */
  public val md5WithRSAAndISO9697: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 1 1 3"
      )

  /**
   * `0.2.262.1.10.1.1.4`: Telesec mechanism
   */
  public val md5WithRSAAndTelesecSignatureStandard: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 1 1 4"
      )

  /**
   * `1.2.840.113549.1.1.4`: PKCS #1
   */
  public val md5WithRSAEncryption: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 1 4"
      )

  /**
   * `2.16.840.1.113719.1.2.8.30`: Novell signature algorithm
   */
  public val md5WithRSAEncryptionBSafe1: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113719 1 2 8 30"
      )

  /**
   * `1.3.14.3.2.25`: Oddball OIW OID using 9796-2 padding rules
   */
  public val md5WithRSASignature: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 14 3 2 25"
      )

  /**
   * `1.2.840.113549.1.9.16.3.13`: S/MIME Algorithms.  Experimental
   */
  public val md5XorExperiment: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 3 13"
      )

  /**
   * `1.2.840.113549.2.5`: RSADSI digestAlgorithm
   */
  public val md5_1_2_840_113549_2_5: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 2 5"
      )

  /**
   * `2.16.840.1.113719.1.2.8.50`: Novell digest algorithm
   */
  public val md5_2_16_840_1_113719_1_2_8_50: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113719 1 2 8 50"
      )

  /**
   * `1.3.14.3.2.14`: Oddball OIW OID using 9796-2 padding rules
   */
  public val mdc2WithRSASignature: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 14 3 2 14"
      )

  /**
   * `1.3.36.3.2.5`: Teletrust hash algorithm
   */
  public val mdc2doubleLength: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 2 5"
      )

  /**
   * `1.3.36.3.2.4`: Teletrust hash algorithm
   */
  public val mdc2singleLength: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 2 4"
      )

  /**
   * `1.3.14.3.2.19`: Oddball OIW OID, DES-based hash, planned for X9.31 Part 2
   */
  public val mdc_2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 14 3 2 19"
      )

  /**
   * `0.2.262.1.10.1`: Telesec
   */
  public val mechanism: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 1"
      )

  /**
   * `2.5.4.31`: X.520 DN component
   */
  public val member: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 31"
      )

  /**
   * `2.23.42.7.2`: SET cert extension
   */
  public val merchantData: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 7 2"
      )

  /**
   * `1.2.840.113549.1.9.4`: PKCS #9
   */
  public val messageDigest: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 4"
      )

  /**
   * `2.16.840.1.113733.1.9.2`: Verisign PKCS #7 attribute
   */
  public val messageType: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113733 1 9 2"
      )

  /**
   * `0.2.262.1.10.2.3`: Telesec module
   */
  public val messageTypes: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 2 3"
      )

  /**
   * `2.16.840.1.101.2.1.5.40`: SDN.700 INFOSEC attributes
   */
  public val metaSDNSckl: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 5 40"
      )

  /**
   * `2.16.840.1.101.2.1.5.42`: SDN.700 INFOSEC attributes
   */
  public val metaSDNSsignatureCKL: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 5 42"
      )

  /**
   * `1.3.6.1.4.1.311.76.509.1.1`: Microsoft PKI services
   */
  public val microsoftCPS: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 76 509 1 1"
      )

  /**
   * `1.2.840.113556.4.3`: Microsoft
   */
  public val microsoftExcel: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113556 4 3"
      )

  /**
   * `1.2.840.113556.4.5`: Microsoft
   */
  public val microsoftPowerPoint: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113556 4 5"
      )

  /**
   * `1.3.6.1.4.1.311.16.4`: Microsoft attribute
   */
  public val microsoftRecipientInfo: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 16 4"
      )

  /**
   * `2.16.840.1.101.2.1.22.1`: RFC 7906 key attribute error codes
   */
  public val missingKeyType: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 22 1"
      )

  /**
   * `1.2.392.200011.61.1.1.1.1`: Mitsubishi security algorithm
   */
  public val misty1_cbc: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 392 200011 61 1 1 1 1"
      )

  /**
   * `1.2.392.200011.61.1.1.1`: Mitsubishi security algorithm
   */
  public val mitsubishiSecurityAlgorithm: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 392 200011 61 1 1 1"
      )

  /**
   * `2.16.840.1.101.2.1.5.13`: SDN.700 INFOSEC attributes
   */
  public val mlAdministrators: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 5 13"
      )

  /**
   * `1.2.840.113549.1.9.16.2.3`: S/MIME Authenticated Attributes
   */
  public val mlExpandHistory: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 3"
      )

  /**
   * `1.2.840.113549.1.9.15.6`: sMIMECapabilities. Deprecated, use (1 2 840 113549 1 9 16 2 3)
   * instead
   */
  public val mlExpansionHistory: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 15 6"
      )

  /**
   * `2.16.840.1.101.2.1.5.12`: SDN.700 INFOSEC attributes
   */
  public val mlMembership: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 5 12"
      )

  /**
   * `2.16.840.1.101.2.1.5.11`: SDN.700 INFOSEC attributes
   */
  public val mlReceiptPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 5 11"
      )

  /**
   * `1.3.6.1.4.1.311.10.3.14`: Microsoft extended key usage
   */
  public val mobileDeviceSoftware: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 10 3 14"
      )

  /**
   * `0.2.262.1.10.2`: Telesec
   */
  public val module: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 2"
      )

  /**
   * `1.2.840.10040.1`: ANSI X9.57
   */
  public val module_1_2_840_10040_1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10040 1"
      )

  /**
   * `2.23.42.6`: SET
   */
  public val module_2_23_42_6: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 6"
      )

  /**
   * `1.3.36.8.3.4`: Teletrust attribute
   */
  public val monetaryLimit: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 3 4"
      )

  /**
   * `2.23.42.2.6`: SET field
   */
  public val month: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 2 6"
      )

  /**
   * `2.16.840.1.101.2.1.3.3`: SDN.700 INFOSEC policy
   */
  public val mosaicPRBAC: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 3 3"
      )

  /**
   * `1.3.6.1.4.1.3029.42.11172.1`: cryptlib special MPEG-of-cat OID
   */
  public val mpeg_1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 3029 42 11172 1"
      )

  /**
   * `1.2.840.10046.3.6`: ANSI X9.42 scheme
   */
  public val mqv1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10046 3 6"
      )

  /**
   * `1.2.840.10046.3.5`: ANSI X9.42 scheme
   */
  public val mqv2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10046 3 5"
      )

  /**
   * `1.2.840.113556.1.4.1436`: Microsoft Cert Template - attribute
   */
  public val msPKI_Cert_Template_OID: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113556 1 4 1436"
      )

  /**
   * `1.2.840.113556.1.4.1674`: Microsoft Cert Template - attribute
   */
  public val msPKI_Certificate_Application_Policy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113556 1 4 1674"
      )

  /**
   * `1.2.840.113556.1.4.1432`: Microsoft Cert Template - attribute
   */
  public val msPKI_Certificate_Name_Flag: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113556 1 4 1432"
      )

  /**
   * `1.2.840.113556.1.4.1439`: Microsoft Cert Template - attribute
   */
  public val msPKI_Certificate_Policy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113556 1 4 1439"
      )

  /**
   * `1.2.840.113556.1.4.1430`: Microsoft Cert Template - attribute
   */
  public val msPKI_Enrollment_Flag: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113556 1 4 1430"
      )

  /**
   * `1.2.840.113556.1.4.1433`: Microsoft Cert Template - attribute
   */
  public val msPKI_Minimal_Key_Size: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113556 1 4 1433"
      )

  /**
   * `1.2.840.113556.1.4.1431`: Microsoft Cert Template - attribute
   */
  public val msPKI_Private_Key_Flag: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113556 1 4 1431"
      )

  /**
   * `1.2.840.113556.1.4.1675`: Microsoft Cert Template - attribute
   */
  public val msPKI_RA_Application_Policies: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113556 1 4 1675"
      )

  /**
   * `1.2.840.113556.1.4.1438`: Microsoft Cert Template - attribute
   */
  public val msPKI_RA_Policies: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113556 1 4 1438"
      )

  /**
   * `1.2.840.113556.1.4.1429`: Microsoft Cert Template - attribute
   */
  public val msPKI_RA_Signature: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113556 1 4 1429"
      )

  /**
   * `1.2.840.113556.1.4.1437`: Microsoft Cert Template - attribute
   */
  public val msPKI_Supersede_Templates: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113556 1 4 1437"
      )

  /**
   * `1.2.840.113556.1.4.1435`: Microsoft Cert Template - attribute
   */
  public val msPKI_Template_Minor_Revision: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113556 1 4 1435"
      )

  /**
   * `1.2.840.113556.1.4.1434`: Microsoft Cert Template - attribute
   */
  public val msPKI_Template_Schema_Version: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113556 1 4 1434"
      )

  /**
   * `2.23.42.1`: SET
   */
  public val msgExt: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 1"
      )

  /**
   * `1.2.840.113549.1.9.16.2.5`: S/MIME Authenticated Attributes
   */
  public val msgSigDigest: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 5"
      )

  /**
   * `2.16.840.1.101.2.1.2.48`: SDN.700 INFOSEC format
   */
  public val mspContentType: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 2 48"
      )

  /**
   * `2.16.840.1.101.2.1.2.73`: SDN.700 INFOSEC format
   */
  public val mspForwardedMessageParameters: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 2 73"
      )

  /**
   * `2.16.840.1.101.2.1.2.50`: SDN.700 INFOSEC format
   */
  public val mspMMP: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 2 50"
      )

  /**
   * `2.16.840.1.101.2.1.2.76`: SDN.700 INFOSEC format
   */
  public val mspMMP2: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 2 76"
      )

  /**
   * `2.16.840.1.101.2.1.2.49`: SDN.700 INFOSEC format
   */
  public val mspRekeyAgentProtocol: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 2 49"
      )

  /**
   * `2.16.840.1.101.2.1.2.42`: SDN.700 INFOSEC format
   */
  public val mspRev3ContentType: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 2 42"
      )

  /**
   * `2.16.840.1.101.2.1.2.66`: SDN.700 INFOSEC format
   */
  public val mspRev3_1ContentType: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 2 66"
      )

  /**
   * `1.2.840.113549.1.9.16.1.41`: S/MIME Content Types
   */
  public val mudType: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 1 41"
      )

  /**
   * `1.2.840.113549.1.9.16.2.51`: S/MIME Authenticated Attributes
   */
  public val multipleSignatures: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 51"
      )

  /**
   * `1.3.6.1.5.5.7.8.8`: PKIX other name
   */
  public val naiRealm: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 8 8"
      )

  /**
   * `2.5.4.41`: X.520 DN component
   */
  public val name: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 41"
      )

  /**
   * `0.2.262.1.10.7.18`: Telesec attribute
   */
  public val nameAdditions: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 7 18"
      )

  /**
   * `1.3.36.8.3.14`: Teletrust attribute
   */
  public val nameAtBirth: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 3 14"
      )

  /**
   * `0.2.262.1.10.6`: Telesec
   */
  public val nameBinding: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 6"
      )

  /**
   * `2.5.29.11`: X.509 extension.  Deprecated, use 2 5 29 30 instead
   */
  public val nameConstraints: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 11"
      )

  /**
   * `2.5.29.30`: X.509 extension
   */
  public val nameConstraints_2_5_29_30: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 30"
      )

  /**
   * `0.2.262.1.10.7.20`: Telesec attribute
   */
  public val nameDistinguisher: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 7 20"
      )

  /**
   * `2.16.840.1.101.2.1.10.3`: SDN.700 INFOSEC privileges
   */
  public val namedTagSetPrivilege: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 10 3"
      )

  /**
   * `1.3.36.8.3.11`: Teletrust attribute
   */
  public val namingAuthorities: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 3 11"
      )

  /**
   * `0.2.262.1.10.7.7`: Telesec attribute
   */
  public val namingAuthority: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 7 7"
      )

  /**
   * `2.23.42.10`: SET
   */
  public val national: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 10"
      )

  /**
   * `2.16.840.1.113730.1.2`: Netscape certificate extension
   */
  public val netscape_base_url: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113730 1 2"
      )

  /**
   * `2.16.840.1.113730.1.8`: Netscape certificate extension
   */
  public val netscape_ca_policy_url: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113730 1 8"
      )

  /**
   * `2.16.840.1.113730.1.4`: Netscape certificate extension
   */
  public val netscape_ca_revocation_url: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113730 1 4"
      )

  /**
   * `2.16.840.1.113730.1.7`: Netscape certificate extension
   */
  public val netscape_cert_renewal_url: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113730 1 7"
      )

  /**
   * `2.16.840.1.113730.1.1`: Netscape certificate extension
   */
  public val netscape_cert_type: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113730 1 1"
      )

  /**
   * `2.16.840.1.113730.1.13`: Netscape certificate extension
   */
  public val netscape_comment: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113730 1 13"
      )

  /**
   * `2.16.840.1.113730.1.3`: Netscape certificate extension
   */
  public val netscape_revocation_url: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113730 1 3"
      )

  /**
   * `2.16.840.1.113730.1.12`: Netscape certificate extension
   */
  public val netscape_ssl_server_name: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113730 1 12"
      )

  /**
   * `1.3.6.1.4.1.311.10.2`: Microsoft
   */
  public val nextUpdateLocation: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 10 2"
      )

  /**
   * `1.3.6.1.5.5.7.1.34`: PKIX private extension
   */
  public val nfTypes: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 1 34"
      )

  /**
   * `1.3.6.1.4.1.16334.509.2.1`: Northrop Grumman policy
   */
  public val ngcClass1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 16334 509 2 1"
      )

  /**
   * `1.3.6.1.4.1.16334.509.2.2`: Northrop Grumman policy
   */
  public val ngcClass2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 16334 509 2 2"
      )

  /**
   * `1.3.6.1.4.1.16334.509.2.3`: Northrop Grumman policy
   */
  public val ngcClass3: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 16334 509 2 3"
      )

  /**
   * `2.16.840.1.101.3.4`: NIST Algorithm
   */
  public val nistAlgorithm: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 4"
      )

  /**
   * `2.16.840.1.101.3.2.1.48.1`: NIST PKITS policies
   */
  public val nistTestPolicy1: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 2 1 48 1"
      )

  /**
   * `2.16.840.1.101.3.2.1.48.2`: NIST PKITS policies
   */
  public val nistTestPolicy2: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 2 1 48 2"
      )

  /**
   * `2.16.840.1.101.3.2.1.48.3`: NIST PKITS policies
   */
  public val nistTestPolicy3: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 2 1 48 3"
      )

  /**
   * `2.16.840.1.101.3.2.1.48.4`: NIST PKITS policies
   */
  public val nistTestPolicy4: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 2 1 48 4"
      )

  /**
   * `2.16.840.1.101.3.2.1.48.5`: NIST PKITS policies
   */
  public val nistTestPolicy5: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 2 1 48 5"
      )

  /**
   * `2.16.840.1.101.3.2.1.48.6`: NIST PKITS policies
   */
  public val nistTestPolicy6: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 2 1 48 6"
      )

  /**
   * `2.5.29.62`: X.509 extension
   */
  public val noAssertion: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 62"
      )

  /**
   * `2.5.29.56`: X.509 extension
   */
  public val noRevAvail: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 56"
      )

  /**
   * `1.3.6.1.5.5.7.1.23`: PKIX private extension
   */
  public val noSecrecyAfforded: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 1 23"
      )

  /**
   * `1.3.6.1.5.5.7.6.2`: PKIX algorithm
   */
  public val noSignature: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 6 2"
      )

  /**
   * `0.2.262.1.10.1.2.0`: Telesec encryption
   */
  public val none: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 1 2 0"
      )

  /**
   * `0.4.0.2042.1.1`: ETSI TS 102 042 Certificate Policies
   */
  public val normalisedCertificatePolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 2042 1 1"
      )

  /**
   * `0.4.0.2042.1.2`: ETSI TS 102 042 Certificate Policies
   */
  public val normalisedCertificatePolicyPlus: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 2042 1 2"
      )

  /**
   * `1.3.36.8.3.11.1.9`: Teletrust ProfessionInfo
   */
  public val notar: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 3 11 1 9"
      )

  /**
   * `1.3.36.8.3.11.1.11`: Teletrust ProfessionInfo
   */
  public val notarVertreter: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 3 11 1 11"
      )

  /**
   * `1.3.36.8.3.11.1.10`: Teletrust ProfessionInfo
   */
  public val notarVertreterin: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 3 11 1 10"
      )

  /**
   * `1.3.36.8.3.11.1.13`: Teletrust ProfessionInfo
   */
  public val notariatsVerwalter: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 3 11 1 13"
      )

  /**
   * `1.3.36.8.3.11.1.12`: Teletrust ProfessionInfo
   */
  public val notariatsVerwalterin: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 3 11 1 12"
      )

  /**
   * `1.3.36.8.3.11.1.8`: Teletrust ProfessionInfo
   */
  public val notarin: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 3 11 1 8"
      )

  /**
   * `0.2.262.1.10.10`: Telesec
   */
  public val notification: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 10"
      )

  /**
   * `2.16.840.1.101.2.1.5.30`: SDN.700 INFOSEC attributes
   */
  public val novUKMs: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 5 30"
      )

  /**
   * `2.16.840.1.113719.1.2.8`: Novell
   */
  public val novellAlgorithm: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113719 1 2 8"
      )

  /**
   * `2.16.840.1.113719.1.2.8.133`: Novell encryption algorithm
   */
  public val novellObfuscate_1: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113719 1 2 8 133"
      )

  /**
   * `1.2.410.200004.10`: KISA NPKI
   */
  public val npki: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200004 10"
      )

  /**
   * `1.2.410.200004.7`: KISA NPKI application
   */
  public val npkiAPP: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200004 7"
      )

  /**
   * `1.2.410.200004.4`: KISA NPKI attribute
   */
  public val npkiAT: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200004 4"
      )

  /**
   * `1.2.410.200004.10.1`: KISA NPKI attribute
   */
  public val npkiAttribute: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200004 10 1"
      )

  /**
   * `1.2.410.200004.2`: KISA NPKI certificate policies
   */
  public val npkiCP: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200004 2"
      )

  /**
   * `1.2.410.200004.7.1.1.1`: KISA NPKI application
   */
  public val npkiCmsSEEDWrap: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200004 7 1 1 1"
      )

  /**
   * `1.2.410.200004.10.1.1.2`: KISA NPKI attribute
   */
  public val npkiEncryptedVID: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200004 10 1 1 2"
      )

  /**
   * `1.2.410.200004.10.1.1`: KISA NPKI attribute
   */
  public val npkiIdentifyData: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200004 10 1 1"
      )

  /**
   * `1.2.410.200004.3`: KISA NPKI key usage
   */
  public val npkiKP: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200004 3"
      )

  /**
   * `1.2.410.200004.5`: KISA NPKI licensed CA
   */
  public val npkiLCA: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200004 5"
      )

  /**
   * `1.2.410.200004.5.3`: KISA NPKI licensed CA
   */
  public val npkiNcaSign: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200004 5 3"
      )

  /**
   * `1.2.410.200004.6`: KISA NPKI otherName
   */
  public val npkiON: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200004 6"
      )

  /**
   * `1.2.410.200004.10.1.1.3`: KISA NPKI attribute
   */
  public val npkiRandomNum: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200004 10 1 1 3"
      )

  /**
   * `1.2.410.200004.7.1`: KISA NPKI application
   */
  public val npkiSMIME: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200004 7 1"
      )

  /**
   * `1.2.410.200004.7.1.1`: KISA NPKI application
   */
  public val npkiSMIMEAlgo: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200004 7 1 1"
      )

  /**
   * `1.2.410.200004.5.2`: KISA NPKI licensed CA
   */
  public val npkiSignGate: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200004 5 2"
      )

  /**
   * `1.2.410.200004.5.1`: KISA NPKI licensed CA
   */
  public val npkiSignKorea: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200004 5 1"
      )

  /**
   * `1.2.410.200004.2.1`: KISA NPKI certificate policies
   */
  public val npkiSignaturePolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200004 2 1"
      )

  /**
   * `1.2.410.200004.10.1.1.1`: KISA NPKI attribute
   */
  public val npkiVID: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200004 10 1 1 1"
      )

  /**
   * `1.2.410.200004.10.1.1.4`: KISA NPKI attribute
   */
  public val npkiVID_1_2_410_200004_10_1_1_4: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200004 10 1 1 4"
      )

  /**
   * `1.2.840.113533.7`: null
   */
  public val nsn: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113533 7"
      )

  /**
   * `1.2.840.113533.7.66`: null
   */
  public val nsn_alg: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113533 7 66"
      )

  /**
   * `1.2.840.113533.7.68`: null
   */
  public val nsn_at: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113533 7 68"
      )

  /**
   * `1.2.840.113533.7.65`: null
   */
  public val nsn_ce: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113533 7 65"
      )

  /**
   * `1.2.840.113533.7.67`: null
   */
  public val nsn_oc: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113533 7 67"
      )

  /**
   * `1.3.6.1.4.1.311.10.3.6`: Microsoft extended key usage
   */
  public val nt5Crypto: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 10 3 6"
      )

  /**
   * `1.2.840.113556.1.2.281`: Microsoft Cert Template - attribute
   */
  public val ntSecurityDescriptor: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113556 1 2 281"
      )

  /**
   * `1.3.6.1.4.1.311.25.2`: Microsoft
   */
  public val ntdsCASecurityExt: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 25 2"
      )

  /**
   * `1.3.6.1.4.1.311.25.2.1`: Microsoft
   */
  public val ntdsObjectSID: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 25 2 1"
      )

  /**
   * `1.3.6.1.4.1.311.25.1`: Microsoft
   */
  public val ntdsReplication: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 25 1"
      )

  /**
   * `1.2.643.2.2.14.0`: Do not mesh state of GOST 28147-89 cipher
   */
  public val nullMeshing: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 2 2 14 0"
      )

  /**
   * `1.2.840.10046.2`: ANSI X9.42
   */
  public val numberType: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10046 2"
      )

  /**
   * `2.16.840.1.113719.1.2.8.132`: Novell encryption algorithm
   */
  public val nwPassword: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113719 1 2 8 132"
      )

  /**
   * `0.2.262.1.10.3`: Telesec
   */
  public val objectClass: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 3"
      )

  /**
   * `2.5.4.0`: X.520 DN component
   */
  public val objectClass_2_5_4_0: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 0"
      )

  /**
   * `2.5.4.106`: X.520 DN component
   */
  public val objectIdentifier: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 106"
      )

  /**
   * `1.3.6.1.5.5.7.48.1`: PKIX OCSP
   */
  public val ocsp: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 48 1"
      )

  /**
   * `1.3.6.1.5.5.7.48.1.6`: OCSP
   */
  public val ocspArchiveCutoff: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 48 1 6"
      )

  /**
   * `1.3.6.1.5.5.7.48.1.1`: OCSP
   */
  public val ocspBasic: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 48 1 1"
      )

  /**
   * `1.3.6.1.5.5.7.48.1.3`: OCSP
   */
  public val ocspCRL: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 48 1 3"
      )

  /**
   * `1.3.6.1.5.5.7.48.1.5`: OCSP
   */
  public val ocspNoCheck: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 48 1 5"
      )

  /**
   * `1.3.6.1.5.5.7.48.1.2`: OCSP
   */
  public val ocspNonce: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 48 1 2"
      )

  /**
   * `1.3.6.1.5.5.7.48.1.4`: OCSP
   */
  public val ocspResponse: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 48 1 4"
      )

  /**
   * `1.3.6.1.5.5.7.48.1.7`: OCSP
   */
  public val ocspServiceLocator: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 48 1 7"
      )

  /**
   * `1.3.6.1.5.5.7.3.9`: PKIX key purpose
   */
  public val ocspSigning: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 3 9"
      )

  /**
   * `2.16.840.1.101.2.1.5.29`: SDN.700 INFOSEC attributes
   */
  public val octUKMs: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 5 29"
      )

  /**
   * `1.3.6.1.4.1.311.10.3.7`: Microsoft extended key usage
   */
  public val oemWHQLCrypto: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 10 3 7"
      )

  /**
   * `1.3.6.1.5.5.7.5.1.5`: PKIX CRMF registration control
   */
  public val oldCertID: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 5 1 5"
      )

  /**
   * `1.2.840.10045.1.2.3.1`: ANSI X9.62 field basis
   */
  public val onBasis: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10045 1 2 3 1"
      )

  /**
   * `0.2.262.1.10.1.3`: Telesec mechanism
   */
  public val oneWayFunction: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 1 3"
      )

  /**
   * `0.2.262.1.10.1.0.6`: Telesec authentication
   */
  public val oneWayISO9798Authentication: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 1 0 6"
      )

  /**
   * `0.2.262.1.10.1.0.3`: Telesec authentication
   */
  public val oneWayX509Authentication: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 1 0 3"
      )

  /**
   * `2.5.29.47`: X.509 extension
   */
  public val orderedList: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 47"
      )

  /**
   * `2.5.6.4`: X.520 objectClass
   */
  public val organization: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 6 4"
      )

  /**
   * `2.5.4.97`: X.520 DN component
   */
  public val organizationIdentifier: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 97"
      )

  /**
   * `2.5.4.10`: X.520 DN component
   */
  public val organizationName: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 10"
      )

  /**
   * `2.5.6.7`: X.520 objectClass
   */
  public val organizationalPerson: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 6 7"
      )

  /**
   * `2.5.6.8`: X.520 objectClass
   */
  public val organizationalRole: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 6 8"
      )

  /**
   * `2.5.6.5`: X.520 objectClass
   */
  public val organizationalUnit: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 6 5"
      )

  /**
   * `2.5.4.11`: X.520 DN component
   */
  public val organizationalUnitName: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 11"
      )

  /**
   * `1.3.6.1.5.5.7.4.15`: PKIX CMP information
   */
  public val origPKIMessage: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 4 15"
      )

  /**
   * `1.2.840.113549.1.9.16.9.1`: S/MIME Signature Type Identifier
   */
  public val originatorSig: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 9 1"
      )

  /**
   * `1.3.6.1.4.1.311.13.2.3`: Microsoft attribute
   */
  public val osVersion: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 13 2 3"
      )

  /**
   * `1.2.643.2.2.31.6`: Oscar-1.0 params for GOST 28147-89
   */
  public val oscar10Cipher: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 2 2 31 6"
      )

  /**
   * `1.2.643.2.2.31.5`: Oscar-1.1 params for GOST 28147-89
   */
  public val oscar11Cipher: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 2 2 31 5"
      )

  /**
   * `1.3.6.1.5.5.7.1.19`: PKIX private extension
   */
  public val otherCerts: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 1 19"
      )

  /**
   * `1.3.6.1.5.5.7.8`: PKIX
   */
  public val otherNames: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 8"
      )

  /**
   * `1.2.840.113549.1.9.16.13`: S/MIME Other Recipient Info Identifiers
   */
  public val otherRecipientInfoIds: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 13"
      )

  /**
   * `1.2.840.113549.1.9.16.2.19`: S/MIME Authenticated Attributes
   */
  public val otherSigCert: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 19"
      )

  /**
   * `1.2.840.113549.1.9.16.2.56`: S/MIME Authenticated Attributes
   */
  public val otpChallenge: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 56"
      )

  /**
   * `0.4.0.2042.1.7`: ETSI TS 102 042 Certificate Policies
   */
  public val ovCertificatePolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 2042 1 7"
      )

  /**
   * `2.5.4.32`: X.520 DN component
   */
  public val owner: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 32"
      )

  /**
   * `1.2.840.113556.1.4.1330`: Microsoft Cert Template - attribute
   */
  public val pKICriticalExtensions: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113556 1 4 1330"
      )

  /**
   * `1.2.840.113556.1.4.1334`: Microsoft Cert Template - attribute
   */
  public val pKIDefaultCSPs: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113556 1 4 1334"
      )

  /**
   * `1.2.840.113556.1.4.1327`: Microsoft Cert Template - attribute
   */
  public val pKIDefaultKeySpec: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113556 1 4 1327"
      )

  /**
   * `1.2.840.113556.1.4.1335`: Microsoft Cert Template - attribute
   */
  public val pKIEnrollmentAccess: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113556 1 4 1335"
      )

  /**
   * `1.2.840.113556.1.4.1331`: Microsoft Cert Template - attribute
   */
  public val pKIExpirationPeriod: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113556 1 4 1331"
      )

  /**
   * `1.2.840.113556.1.4.1333`: Microsoft Cert Template - attribute
   */
  public val pKIExtendedKeyUsage: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113556 1 4 1333"
      )

  /**
   * `1.2.840.113556.1.4.1328`: Microsoft Cert Template - attribute
   */
  public val pKIKeyUsage: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113556 1 4 1328"
      )

  /**
   * `1.2.840.113556.1.4.1329`: Microsoft Cert Template - attribute
   */
  public val pKIMaxIssuingDepth: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113556 1 4 1329"
      )

  /**
   * `1.2.840.113556.1.4.1332`: Microsoft Cert Template - attribute
   */
  public val pKIOverlapPeriod: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113556 1 4 1332"
      )

  /**
   * `1.3.36.8.3.7`: Teletrust attribute
   */
  public val pKReference: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 3 7"
      )

  /**
   * `0.2.262.1.10.4`: Telesec
   */
  public val `package`: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 4"
      )

  /**
   * `2.23.42.0.0`: SET contentType
   */
  public val panData: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 0 0"
      )

  /**
   * `2.23.42.0.2`: SET contentType
   */
  public val panOnly: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 0 2"
      )

  /**
   * `2.23.42.0.1`: SET contentType
   */
  public val panToken: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 0 1"
      )

  /**
   * `0.2.262.1.10.5`: Telesec
   */
  public val parameter: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 5"
      )

  /**
   * `2.23.42.2.12`: SET field
   */
  public val passPhrase: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 2 12"
      )

  /**
   * `0.2.262.1.10.1.0.1`: Telesec authentication
   */
  public val passwordAuthentication: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 1 0 1"
      )

  /**
   * `1.2.840.113533.7.66.13`: Nortel Secure Networks alg
   */
  public val passwordBasedMac: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113533 7 66 13"
      )

  /**
   * `1.2.840.113549.1.9.11`: PKCS #9 experimental
   */
  public val passwordCheck: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 11"
      )

  /**
   * `1.3.36.8.3.11.1.18`: Teletrust ProfessionInfo
   */
  public val patentAnwaeltin: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 3 11 1 18"
      )

  /**
   * `1.3.36.8.3.11.1.19`: Teletrust ProfessionInfo
   */
  public val patentAnwalt: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 3 11 1 19"
      )

  /**
   * `1.2.410.200004.1.11`: Korean SEED algorithm, PBE key derivation
   */
  public val pbeWithHAS160AndSEED_CBC: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200004 1 11"
      )

  /**
   * `1.2.410.200004.1.12`: Korean SEED algorithm, PBE key derivation
   */
  public val pbeWithHAS160AndSEED_CFB: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200004 1 12"
      )

  /**
   * `1.2.410.200004.1.10`: Korean SEED algorithm, PBE key derivation
   */
  public val pbeWithHAS160AndSEED_ECB: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200004 1 10"
      )

  /**
   * `1.2.410.200004.1.13`: Korean SEED algorithm, PBE key derivation
   */
  public val pbeWithHAS160AndSEED_OFB: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200004 1 13"
      )

  /**
   * `1.2.840.113549.1.5.1`: PKCS #5
   */
  public val pbeWithMD2AndDES_CBC: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 5 1"
      )

  /**
   * `1.2.840.113549.1.5.4`: PKCS #5
   */
  public val pbeWithMD2AndRC2_CBC: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 5 4"
      )

  /**
   * `1.2.840.113533.7.66.12`: Nortel Secure Networks alg
   */
  public val pbeWithMD5AndCAST5_CBC: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113533 7 66 12"
      )

  /**
   * `1.2.840.113549.1.5.3`: PKCS #5
   */
  public val pbeWithMD5AndDES_CBC: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 5 3"
      )

  /**
   * `1.2.840.113549.1.5.6`: PKCS #5
   */
  public val pbeWithMD5AndRC2_CBC: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 5 6"
      )

  /**
   * `1.2.840.113549.1.5.9`: PKCS #5, used in BSAFE only
   */
  public val pbeWithMD5AndXOR: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 5 9"
      )

  /**
   * `1.2.410.200004.1.15`: Korean SEED algorithm, PBE key derivation
   */
  public val pbeWithSHA1AndSEED_CBC: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200004 1 15"
      )

  /**
   * `1.2.410.200004.1.16`: Korean SEED algorithm, PBE key derivation
   */
  public val pbeWithSHA1AndSEED_CFB: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200004 1 16"
      )

  /**
   * `1.2.410.200004.1.14`: Korean SEED algorithm, PBE key derivation
   */
  public val pbeWithSHA1AndSEED_ECB: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200004 1 14"
      )

  /**
   * `1.2.410.200004.1.17`: Korean SEED algorithm, PBE key derivation
   */
  public val pbeWithSHA1AndSEED_OFB: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200004 1 17"
      )

  /**
   * `1.2.840.113549.1.12.1.5`: PKCS #12 PbeIds
   */
  public val pbeWithSHAAnd128BitRC2_CBC: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 12 1 5"
      )

  /**
   * `1.2.840.113549.1.12.1.1`: PKCS #12 PbeIds. This OID was formerly assigned as
   * pkcs-12-OfflineTransportMode
   */
  public val pbeWithSHAAnd128BitRC4: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 12 1 1"
      )

  /**
   * `1.2.840.113549.1.12.1.4`: PKCS #12 PbeIds
   */
  public val pbeWithSHAAnd2_KeyTripleDES_CBC: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 12 1 4"
      )

  /**
   * `1.2.840.113549.1.12.1.3`: PKCS #12 PbeIds
   */
  public val pbeWithSHAAnd3_KeyTripleDES_CBC: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 12 1 3"
      )

  /**
   * `1.2.840.113549.1.12.1.6`: PKCS #12 PbeIds
   */
  public val pbeWithSHAAnd40BitRC2_CBC: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 12 1 6"
      )

  /**
   * `1.2.840.113549.1.12.1.2`: PKCS #12 PbeIds. This OID was formerly assigned as
   * pkcs-12-OnlineTransportMode
   */
  public val pbeWithSHAAnd40BitRC4: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 12 1 2"
      )

  /**
   * `1.2.840.113549.1.5.10`: PKCS #5
   */
  public val pbeWithSHAAndDES_CBC: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 5 10"
      )

  /**
   * `1.2.840.113549.1.9.16.1.29`: S/MIME Content Types
   */
  public val pdf: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 1 29"
      )

  /**
   * `1.2.840.113583.1.2.4`: Adobe Acrobat CPS
   */
  public val pdfAdhocCPS: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113583 1 2 4"
      )

  /**
   * `1.2.840.113583.1.1.9.2`: Adobe Acrobat security
   */
  public val pdfArchiveRevInfo: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113583 1 1 9 2"
      )

  /**
   * `1.2.840.113583.1.2.1`: Adobe Acrobat CPS
   */
  public val pdfAuthenticDocumentsCPS: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113583 1 2 1"
      )

  /**
   * `1.2.840.113583.1.1.5`: Adobe Acrobat security
   */
  public val pdfAuthenticDocumentsTrust: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113583 1 1 5"
      )

  /**
   * `1.2.840.113583.1.1.3`: Adobe Acrobat security
   */
  public val pdfDefaultEncryptionCredential: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113583 1 1 3"
      )

  /**
   * `1.2.840.113583.1.1.2`: Adobe Acrobat security
   */
  public val pdfDefaultSigningCredential: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113583 1 1 2"
      )

  /**
   * `1.2.840.113583.1.1.6`: Adobe Acrobat security
   */
  public val pdfDynamicContentTrust: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113583 1 1 6"
      )

  /**
   * `1.2.840.113583.1.1.10`: Adobe Acrobat security
   */
  public val pdfPPLKLiteCredential: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113583 1 1 10"
      )

  /**
   * `1.2.840.113583.1.1.1`: Adobe Acrobat security
   */
  public val pdfPassword: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113583 1 1 1"
      )

  /**
   * `1.2.840.113583.1.1.4`: Adobe Acrobat security
   */
  public val pdfPasswordTimeout: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113583 1 1 4"
      )

  /**
   * `1.2.840.113583.1.1.8`: Adobe Acrobat security
   */
  public val pdfRevocationInfoArchival: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113583 1 1 8"
      )

  /**
   * `1.2.840.113583.1.2.2`: Adobe Acrobat CPS
   */
  public val pdfTestCPS: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113583 1 2 2"
      )

  /**
   * `1.2.840.113583.1.1.9.1`: Adobe Acrobat security
   */
  public val pdfTimeStamp: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113583 1 1 9 1"
      )

  /**
   * `1.2.840.113583.1.2.3`: Adobe Acrobat CPS
   */
  public val pdfUbiquityCPS: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113583 1 2 3"
      )

  /**
   * `1.2.840.113583.1.7.1`: Adobe Acrobat ubiquity
   */
  public val pdfUbiquitySubRights: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113583 1 7 1"
      )

  /**
   * `1.2.840.113583.1.1.7`: Adobe Acrobat security
   */
  public val pdfUbiquityTrust: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113583 1 1 7"
      )

  /**
   * `1.2.840.113583.1.1.9`: Adobe Acrobat security
   */
  public val pdfX509Extension: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113583 1 1 9"
      )

  /**
   * `1.3.6.1.5.5.7.8.3`: PKIX other name
   */
  public val permanentIdentifier: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 8 3"
      )

  /**
   * `2.5.4.82`: X.520 DN component
   */
  public val permission: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 82"
      )

  /**
   * `2.5.6.6`: X.520 objectClass
   */
  public val person: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 6 6"
      )

  /**
   * `1.3.6.1.5.5.7.8.1`: PKIX other name
   */
  public val personalData: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 8 1"
      )

  /**
   * `2.16.724.1.2.2.4.1`: Spanish Government PKI?
   */
  public val personalDataInfo: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 724 1 2 2 4 1"
      )

  /**
   * `1.3.36.8.4.1`: Teletrust OtherName attribute
   */
  public val personalData_1_3_36_8_4_1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 4 1"
      )

  /**
   * `1.3.6.1.5.5.7.11`: PKIX qualified certificates
   */
  public val personalData_1_3_6_1_5_5_7_11: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 11"
      )

  /**
   * `1.3.6.1.5.5.7.9`: PKIX qualified certificates
   */
  public val personalData_1_3_6_1_5_5_7_9: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 9"
      )

  /**
   * `1.3.6.1.4.1.3401.8.1.1`: PGP key information
   */
  public val pgpExtension: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 3401 8 1 1"
      )

  /**
   * `0.2.262.1.10.7.25`: Telesec attribute
   */
  public val physicalCardNumber: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 7 25"
      )

  /**
   * `2.5.4.19`: X.520 DN component
   */
  public val physicalDeliveryOfficeName: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 19"
      )

  /**
   * `1.3.6.1.4.1.5770.0.4`: MEDePass
   */
  public val physicianIdentifiers: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 5770 0 4"
      )

  /**
   * `1.2.840.10040.2.4`: ANSI X9.57 hold instruction
   */
  public val pickupToken: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10040 2 4"
      )

  /**
   * `1.3.6.1.4.1.311.17.3`: Microsoft attribute
   */
  public val pkcs12ExtendedAttributes: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 17 3"
      )

  /**
   * `1.3.6.1.4.1.311.17.1`: Microsoft attribute
   */
  public val pkcs12KeyProviderNameAttr: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 17 1"
      )

  /**
   * `1.2.840.113549.1.9.25.1`: PKCS #9/RFC 2985 attribute
   */
  public val pkcs15Token: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 25 1"
      )

  /**
   * `1.2.840.113549.1.15.2`: PKCS #15
   */
  public val pkcs15attributes: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 15 2"
      )

  /**
   * `1.2.840.113549.1.15.3.1`: PKCS #15 content type
   */
  public val pkcs15content: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 15 3 1"
      )

  /**
   * `1.2.840.113549.1.15.3`: PKCS #15
   */
  public val pkcs15contentType: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 15 3"
      )

  /**
   * `1.2.840.113549.1.15.1`: PKCS #15
   */
  public val pkcs15modules: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 15 1"
      )

  /**
   * `1.2.840.113549.1.1.8`: PKCS #1
   */
  public val pkcs1_MGF: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 1 8"
      )

  /**
   * `1.2.840.113549.1.5.13`: PKCS #5 v2.0
   */
  public val pkcs5PBES2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 5 13"
      )

  /**
   * `1.2.840.113549.1.5.12`: PKCS #5 v2.0
   */
  public val pkcs5PBKDF2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 5 12"
      )

  /**
   * `1.2.840.113549.1.5.14`: PKCS #5 v2.0
   */
  public val pkcs5PBMAC1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 5 14"
      )

  /**
   * `2.16.840.1.113733.1.9`: Verisign PKI extension
   */
  public val pkcs7Attribute: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113733 1 9"
      )

  /**
   * `1.2.840.113549.1.9.25.5`: PKCS #9/RFC 2985 attribute
   */
  public val pkcs7PDU: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 25 5"
      )

  /**
   * `1.2.840.113549.1.9.25`: PKCS #9/RFC 2985
   */
  public val pkcs9attributes: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 25"
      )

  /**
   * `1.2.840.113549.1.9.27`: PKCS #9/RFC 2985
   */
  public val pkcs9matchingRules: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 27"
      )

  /**
   * `1.2.840.113549.1.9.24`: PKCS #9/RFC 2985
   */
  public val pkcs9objectClass: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 24"
      )

  /**
   * `1.2.840.113549.1.9.26`: PKCS #9/RFC 2985
   */
  public val pkcs9syntax: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 26"
      )

  /**
   * `1.2.840.113549.1.1`: null
   */
  public val pkcs_1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 1"
      )

  /**
   * `1.2.840.113549.1.12`: null
   */
  public val pkcs_12: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 12"
      )

  /**
   * `1.2.840.113549.1.12.10.1`: null
   */
  public val pkcs_12BadIds: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 12 10 1"
      )

  /**
   * `1.2.840.113549.1.12.10`: null
   */
  public val pkcs_12Version1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 12 10"
      )

  /**
   * `1.2.840.113549.1.12.3`: null
   */
  public val pkcs_12_BagIds: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 12 3"
      )

  /**
   * `1.2.840.113549.1.12.4`: Deprecated
   */
  public val pkcs_12_CertBagID: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 12 4"
      )

  /**
   * `1.2.840.113549.1.12.2`: Deprecated
   */
  public val pkcs_12_ESPVKID: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 12 2"
      )

  /**
   * `1.2.840.113549.1.12.5.2`: PKCS #12 OID. Deprecated, use the conventional PKCS #1 OIDs instead
   */
  public val pkcs_12_EnvelopingID: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 12 5 2"
      )

  /**
   * `1.2.840.113549.1.12.5`: null
   */
  public val pkcs_12_OID: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 12 5"
      )

  /**
   * `1.2.840.113549.1.12.5.1`: PKCS #12 OID. Deprecated, use the partially compatible (1 2 840
   * 113549 1 12 1) OIDs instead
   */
  public val pkcs_12_PBEID: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 12 5 1"
      )

  /**
   * `1.2.840.113549.1.12.5.1.4`: PKCS #12 OID PBEID. Deprecated, use (1 2 840 113549 1 12 1 5)
   * instead
   */
  public val pkcs_12_PBEWithSha1And128BitRC2CBC: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 12 5 1 4"
      )

  /**
   * `1.2.840.113549.1.12.5.1.1`: PKCS #12 OID PBEID. Deprecated, use (1 2 840 113549 1 12 1 1)
   * instead
   */
  public val pkcs_12_PBEWithSha1And128BitRC4: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 12 5 1 1"
      )

  /**
   * `1.2.840.113549.1.12.5.1.5`: PKCS #12 OID PBEID. Deprecated, use (1 2 840 113549 1 12 1 6)
   * instead
   */
  public val pkcs_12_PBEWithSha1And40BitRC2CBC: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 12 5 1 5"
      )

  /**
   * `1.2.840.113549.1.12.5.1.2`: PKCS #12 OID PBEID. Deprecated, use (1 2 840 113549 1 12 1 2)
   * instead
   */
  public val pkcs_12_PBEWithSha1And40BitRC4: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 12 5 1 2"
      )

  /**
   * `1.2.840.113549.1.12.5.1.7`: PKCS #12 OID PBEID. Deprecated, use the incompatible but similar
   * (1 2 840 113549 1 12 1 5) or (1 2 840 113549 1 12 1 6) instead
   */
  public val pkcs_12_PBEWithSha1AndRC2CBC: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 12 5 1 7"
      )

  /**
   * `1.2.840.113549.1.12.5.1.6`: PKCS #12 OID PBEID. Deprecated, use the incompatible but similar
   * (1 2 840 113549 1 12 1 1) or (1 2 840 113549 1 12 1 2) instead
   */
  public val pkcs_12_PBEWithSha1AndRC4: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 12 5 1 6"
      )

  /**
   * `1.2.840.113549.1.12.5.1.3`: PKCS #12 OID PBEID. Deprecated, use the incompatible but similar
   * (1 2 840 113549 1 12 1 3) or (1 2 840 113549 1 12 1 4) instead
   */
  public val pkcs_12_PBEWithSha1AndTripleDESCBC: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 12 5 1 3"
      )

  /**
   * `1.2.840.113549.1.12.2.1`: PKCS #12 ESPVKID. Deprecated, use (1 2 840 113549 1 12 3 5) instead
   */
  public val pkcs_12_PKCS8KeyShrouding: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 12 2 1"
      )

  /**
   * `1.2.840.113549.1.12.1`: This OID was formerly assigned as PKCS #12 modeID
   */
  public val pkcs_12_PbeIds: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 12 1"
      )

  /**
   * `1.2.840.113549.1.12.5.2.1`: PKCS #12 OID EnvelopingID. Deprecated, use the conventional PKCS
   * #1 OIDs instead
   */
  public val pkcs_12_RSAEncryptionWith128BitRC4: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 12 5 2 1"
      )

  /**
   * `1.2.840.113549.1.12.5.2.2`: PKCS #12 OID EnvelopingID. Deprecated, use the conventional PKCS
   * #1 OIDs instead
   */
  public val pkcs_12_RSAEncryptionWith40BitRC4: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 12 5 2 2"
      )

  /**
   * `1.2.840.113549.1.12.5.2.3`: PKCS #12 OID EnvelopingID. Deprecated, use the conventional PKCS
   * #1 OIDs instead
   */
  public val pkcs_12_RSAEncryptionWithTripleDES: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 12 5 2 3"
      )

  /**
   * `1.2.840.113549.1.12.5.3.1`: PKCS #12 OID SignatureID. Deprecated, use the conventional PKCS #1
   * OIDs instead
   */
  public val pkcs_12_RSASignatureWithSHA1Digest: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 12 5 3 1"
      )

  /**
   * `1.2.840.113549.1.12.4.2`: PKCS #12 CertBagID. This OID was formerly assigned as
   * pkcs-12-SDSICertBag
   */
  public val pkcs_12_SDSICertBagID: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 12 4 2"
      )

  /**
   * `1.2.840.113549.1.12.5.3`: PKCS #12 OID EnvelopingID. Deprecated, use the conventional PKCS #1
   * OIDs instead
   */
  public val pkcs_12_SignatureID: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 12 5 3"
      )

  /**
   * `1.2.840.113549.1.12.4.1`: PKCS #12 CertBagID. This OID was formerly assigned as
   * pkcs-12-X509CertCRLBag
   */
  public val pkcs_12_X509CertCRLBagID: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 12 4 1"
      )

  /**
   * `1.2.840.113549.1.12.3.2`: PKCS #12 BagIds
   */
  public val pkcs_12_certAndCRLBagId: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 12 3 2"
      )

  /**
   * `1.2.840.113549.1.12.10.1.3`: PKCS #12 BagIds
   */
  public val pkcs_12_certBag: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 12 10 1 3"
      )

  /**
   * `1.2.840.113549.1.12.10.1.4`: PKCS #12 BagIds
   */
  public val pkcs_12_crlBag: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 12 10 1 4"
      )

  /**
   * `1.2.840.113549.1.12.10.1.1`: PKCS #12 BagIds
   */
  public val pkcs_12_keyBag: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 12 10 1 1"
      )

  /**
   * `1.2.840.113549.1.12.3.1`: PKCS #12 BagIds
   */
  public val pkcs_12_keyBagId: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 12 3 1"
      )

  /**
   * `1.2.840.113549.1.12.10.1.2`: PKCS #12 BagIds
   */
  public val pkcs_12_pkcs_8ShroudedKeyBag: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 12 10 1 2"
      )

  /**
   * `1.2.840.113549.1.12.3.5`: PKCS #12 BagIds
   */
  public val pkcs_12_pkcs_8ShroudedKeyBagId: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 12 3 5"
      )

  /**
   * `1.2.840.113549.1.12.10.1.6`: PKCS #12 BagIds
   */
  public val pkcs_12_safeContentsBag: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 12 10 1 6"
      )

  /**
   * `1.2.840.113549.1.12.3.4`: PKCS #12 BagIds
   */
  public val pkcs_12_safeContentsId: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 12 3 4"
      )

  /**
   * `1.2.840.113549.1.12.10.1.5`: PKCS #12 BagIds
   */
  public val pkcs_12_secretBag: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 12 10 1 5"
      )

  /**
   * `1.2.840.113549.1.12.3.3`: PKCS #12 BagIds
   */
  public val pkcs_12_secretBagId: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 12 3 3"
      )

  /**
   * `1.2.840.113549.1.3`: null
   */
  public val pkcs_3: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 3"
      )

  /**
   * `1.2.840.113549.1.5`: null
   */
  public val pkcs_5: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 5"
      )

  /**
   * `1.2.840.113549.1.7`: null
   */
  public val pkcs_7: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 7"
      )

  /**
   * `1.2.840.113549.1.9`: null
   */
  public val pkcs_9: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9"
      )

  /**
   * `2.16.840.1.101.3.2`: NIST
   */
  public val pki: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 2"
      )

  /**
   * `1.3.6.1.5.5.7.5.1.4`: PKIX CRMF registration control
   */
  public val pkiArchiveOptions: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 5 1 4"
      )

  /**
   * `2.16.840.1.113719.1.9.4`: Novell PKI
   */
  public val pkiAttributeType: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113719 1 9 4"
      )

  /**
   * `1.3.6.1.4.1.3029.3.1.2`: cryptlib attribute type
   */
  public val pkiBoot: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 3029 3 1 2"
      )

  /**
   * `2.5.6.22`: X.520 objectClass
   */
  public val pkiCA: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 6 22"
      )

  /**
   * `1.3.6.1.5.5.7.12.2`: PKIX CMC Content Types
   */
  public val pkiData: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 12 2"
      )

  /**
   * `2.5.4.70`: X.520 DN component
   */
  public val pkiPath: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 70"
      )

  /**
   * `1.3.6.1.5.5.7.5.1.3`: PKIX CRMF registration control
   */
  public val pkiPublicationInfo: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 5 1 3"
      )

  /**
   * `1.3.6.1.5.5.7.12.3`: PKIX CMC Content Types
   */
  public val pkiResponse: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 12 3"
      )

  /**
   * `2.16.840.1.113733.1.9.3`: Verisign PKCS #7 attribute
   */
  public val pkiStatus: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113733 1 9 3"
      )

  /**
   * `2.5.6.21`: X.520 objectClass
   */
  public val pkiUser: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 6 21"
      )

  /**
   * `2.16.840.1.113719.1.9`: Novell
   */
  public val pki_2_16_840_1_113719_1_9: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113719 1 9"
      )

  /**
   * `2.16.840.1.113733.1`: Verisign extension
   */
  public val pki_2_16_840_1_113733_1: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113733 1"
      )

  /**
   * `1.3.6.1.5.5.7`: null
   */
  public val pkix: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7"
      )

  /**
   * `1.3.6.1.5.5.7.12`: PKIX CMC Content Types
   */
  public val pkixCCT: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 12"
      )

  /**
   * `1.3.6.1.5.5.7.11.1`: PKIX qualified certificates
   */
  public val pkixQCSyntax_v1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 11 1"
      )

  /**
   * `1.3.6.1.5.5.7.11.2`: PKIX qualified certificates
   */
  public val pkixQCSyntax_v2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 11 2"
      )

  /**
   * `0.2.262.1.10.2.4`: Telesec module
   */
  public val plProtocol: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 2 4"
      )

  /**
   * `2.23.42.2.4`: SET field
   */
  public val placeName: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 2 4"
      )

  /**
   * `1.3.6.1.5.5.7.9.2`: PKIX personal data
   */
  public val placeOfBirth: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 9 2"
      )

  /**
   * `1.3.6.1.4.1.3576.7.1`: TMN EDI for Interactive Agents
   */
  public val plainEDImessage: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 3576 7 1"
      )

  /**
   * `1.3.36.5`: Teletrust policy
   */
  public val policy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 5"
      )

  /**
   * `2.5.29.12`: X.509 extension.  Deprecated, use 2 5 29 36 instead
   */
  public val policyConstraints: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 12"
      )

  /**
   * `2.5.29.34`: X.509 extension.  Deprecated, use 2 5 29 36 instead
   */
  public val policyConstraints_2_5_29_34: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 34"
      )

  /**
   * `2.5.29.36`: X.509 extension
   */
  public val policyConstraints_2_5_29_36: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 36"
      )

  /**
   * `2.16.840.1.101.2.1.5.58`: SDN.700 INFOSEC attributes (obsolete)
   */
  public val policyInformationFile: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 5 58"
      )

  /**
   * `2.5.29.5`: X.509 extension.  Deprecated, use 2 5 29 33 instead
   */
  public val policyMapping: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 5"
      )

  /**
   * `2.5.29.33`: X.509 extension
   */
  public val policyMappings: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 33"
      )

  /**
   * `1.3.6.1.5.5.7.2`: PKIX
   */
  public val policyQualifierIds: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 2"
      )

  /**
   * `2.23.42.5`: SET
   */
  public val policy_2_23_42_5: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 5"
      )

  /**
   * `2.5.4.18`: X.520 DN component
   */
  public val postOfficeBox: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 18"
      )

  /**
   * `2.23.134.1.2.1.8.210`: PostSignum CA
   */
  public val postSignumCommercialServerPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 134 1 2 1 8 210"
      )

  /**
   * `2.23.134.1.2.2.3`: PostSignum CA
   */
  public val postSignumPublicCA: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 134 1 2 2 3"
      )

  /**
   * `2.23.134.1.4.2.1`: PostSignum CA
   */
  public val postSignumRootQCA: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 134 1 4 2 1"
      )

  /**
   * `2.5.4.16`: X.520 DN component
   */
  public val postalAddress: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 16"
      )

  /**
   * `2.5.4.17`: X.520 DN component
   */
  public val postalCode: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 17"
      )

  /**
   * `1.2.840.113549.1.9.16.1.30`: S/MIME Content Types
   */
  public val postscript: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 1 30"
      )

  /**
   * `1.2.840.10045.1.2.3.3`: ANSI X9.62 field basis
   */
  public val ppBasis: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10045 1 2 3 3"
      )

  /**
   * `2.16.840.1.101.2.1.5.54`: SDN.700 INFOSEC attributes
   */
  public val prbacCAConstraints: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 5 54"
      )

  /**
   * `2.16.840.1.101.2.1.5.53`: SDN.700 INFOSEC attributes
   */
  public val prbacInfo: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 5 53"
      )

  /**
   * `1.2.840.113549.1.9.16.11.1`: S/MIME Capability
   */
  public val preferBinaryInside: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 11 1"
      )

  /**
   * `1.2.840.113549.1.9.15.1`: sMIMECapabilities
   */
  public val preferSignedData: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 15 1"
      )

  /**
   * `2.5.4.28`: X.520 DN component
   */
  public val preferredDeliveryMehtod: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 28"
      )

  /**
   * `1.3.6.1.5.5.7.4.4`: PKIX CMP information
   */
  public val preferredSymmAlg: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 4 4"
      )

  /**
   * `2.5.4.29`: X.520 DN component
   */
  public val presentationAddress: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 29"
      )

  /**
   * `1.2.840.10045.3.1.1`: ANSI X9.62 named elliptic curve
   */
  public val prime192v1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10045 3 1 1"
      )

  /**
   * `1.2.840.10045.3.1.2`: ANSI X9.62 named elliptic curve
   */
  public val prime192v2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10045 3 1 2"
      )

  /**
   * `1.2.840.10045.3.1.3`: ANSI X9.62 named elliptic curve
   */
  public val prime192v3: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10045 3 1 3"
      )

  /**
   * `1.2.840.10045.3.1.4`: ANSI X9.62 named elliptic curve
   */
  public val prime239v1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10045 3 1 4"
      )

  /**
   * `1.2.840.10045.3.1.5`: ANSI X9.62 named elliptic curve
   */
  public val prime239v2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10045 3 1 5"
      )

  /**
   * `1.2.840.10045.3.1.6`: ANSI X9.62 named elliptic curve
   */
  public val prime239v3: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10045 3 1 6"
      )

  /**
   * `1.2.840.10045.3.1.7`: ANSI X9.62 named elliptic curve
   */
  public val prime256v1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10045 3 1 7"
      )

  /**
   * `1.2.840.10045.1.1`: ANSI X9.62 field type
   */
  public val prime_field: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10045 1 1"
      )

  /**
   * `2.5.4.71`: X.520 DN component
   */
  public val privPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 71"
      )

  /**
   * `2.16.840.1.101.2.1.22.2`: RFC 7906 key attribute error codes
   */
  public val privacyMarkTooLong: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 22 2"
      )

  /**
   * `1.3.6.1.5.5.7.1`: PKIX
   */
  public val privateExtension: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 1"
      )

  /**
   * `2.16.578.1.26.1.3.6`: Norway Buypass CA policy
   */
  public val privateKeyHSM: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 578 1 26 1 3 6"
      )

  /**
   * `2.16.578.1.26.1.3.5`: Norway Buypass CA policy
   */
  public val privateKeyHardToken: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 578 1 26 1 3 5"
      )

  /**
   * `2.16.578.1.26.1.3.1`: Norway Buypass CA policy
   */
  public val privateKeySmartCard: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 578 1 26 1 3 1"
      )

  /**
   * `2.16.578.1.26.1.3.2`: Norway Buypass CA policy
   */
  public val privateKeySoftToken: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 578 1 26 1 3 2"
      )

  /**
   * `2.5.29.16`: X.509 extension
   */
  public val privateKeyUsagePeriod: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 16"
      )

  /**
   * `1.3.36.8.3.2`: Teletrust attribute
   */
  public val procuration: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 3 2"
      )

  /**
   * `1.3.6.1.4.1.311.31.1`: Microsoft attribute
   */
  public val productUpdate: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 31 1"
      )

  /**
   * `1.2.840.113549.1.9.16.6.5`: S/MIME Commitment Type Identifiers
   */
  public val proofOfApproval: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 6 5"
      )

  /**
   * `1.2.840.113549.1.9.16.6.6`: S/MIME Commitment Type Identifiers
   */
  public val proofOfCreation: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 6 6"
      )

  /**
   * `1.2.840.113549.1.9.16.6.3`: S/MIME Commitment Type Identifiers
   */
  public val proofOfDelivery: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 6 3"
      )

  /**
   * `1.2.840.113549.1.9.16.6.1`: S/MIME Commitment Type Identifiers
   */
  public val proofOfOrigin: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 6 1"
      )

  /**
   * `1.2.840.113549.1.9.16.6.2`: S/MIME Commitment Type Identifiers
   */
  public val proofOfReceipt: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 6 2"
      )

  /**
   * `1.2.840.113549.1.9.16.6.4`: S/MIME Commitment Type Identifiers
   */
  public val proofOfSender: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 6 4"
      )

  /**
   * `2.5.4.74`: X.520 DN component
   */
  public val protPrivPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 74"
      )

  /**
   * `0.2.262.1.10.1.0.2`: Telesec authentication
   */
  public val protectedPasswordAuthentication: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 1 0 2"
      )

  /**
   * `1.3.6.1.5.5.7.5.1.6`: PKIX CRMF registration control
   */
  public val protocolEncrKey: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 5 1 6"
      )

  /**
   * `2.5.4.48`: X.520 DN component
   */
  public val protocolInformation: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 48"
      )

  /**
   * `1.3.6.1.5.5.7.1.14`: PKIX private extension
   */
  public val proxyCertInfo: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 1 14"
      )

  /**
   * `2.5.4.65`: X.520 DN component
   */
  public val pseudonym: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 65"
      )

  /**
   * `1.2.840.113549.1.9.16.12.10`: S/MIME Portable Symmetric Key Container Attributes
   */
  public val pskcAlgorithm: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 12 10"
      )

  /**
   * `1.2.840.113549.1.9.16.12.15`: S/MIME Portable Symmetric Key Container Attributes
   */
  public val pskcAlgorithmparams: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 12 15"
      )

  /**
   * `1.2.840.113549.1.9.16.12`: S/MIME Portable Symmetric Key Container Attributes
   */
  public val pskcAttributes: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 12"
      )

  /**
   * `1.2.840.113549.1.9.16.12.16`: S/MIME Portable Symmetric Key Container Attributes
   */
  public val pskcCounter: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 12 16"
      )

  /**
   * `1.2.840.113549.1.9.16.12.5`: S/MIME Portable Symmetric Key Container Attributes
   */
  public val pskcDevicebinding: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 12 5"
      )

  /**
   * `1.2.840.113549.1.9.16.12.7`: S/MIME Portable Symmetric Key Container Attributes
   */
  public val pskcDeviceexpirydate: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 12 7"
      )

  /**
   * `1.2.840.113549.1.9.16.12.6`: S/MIME Portable Symmetric Key Container Attributes
   */
  public val pskcDevicestartdate: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 12 6"
      )

  /**
   * `1.2.840.113549.1.9.16.12.26`: S/MIME Portable Symmetric Key Container Attributes
   */
  public val pskcDeviceuserid: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 12 26"
      )

  /**
   * `1.2.840.113549.1.9.16.12.14`: S/MIME Portable Symmetric Key Container Attributes
   */
  public val pskcFriendlyname: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 12 14"
      )

  /**
   * `1.2.840.113549.1.9.16.12.4`: S/MIME Portable Symmetric Key Container Attributes
   */
  public val pskcIssueno: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 12 4"
      )

  /**
   * `1.2.840.113549.1.9.16.12.11`: S/MIME Portable Symmetric Key Container Attributes
   */
  public val pskcIssuer: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 12 11"
      )

  /**
   * `1.2.840.113549.1.9.16.12.22`: S/MIME Portable Symmetric Key Container Attributes
   */
  public val pskcKeyexpirydate: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 12 22"
      )

  /**
   * `1.2.840.113549.1.9.16.12.9`: S/MIME Portable Symmetric Key Container Attributes
   */
  public val pskcKeyid: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 12 9"
      )

  /**
   * `1.2.840.113549.1.9.16.12.12`: S/MIME Portable Symmetric Key Container Attributes
   */
  public val pskcKeyprofileid: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 12 12"
      )

  /**
   * `1.2.840.113549.1.9.16.12.13`: S/MIME Portable Symmetric Key Container Attributes
   */
  public val pskcKeyreference: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 12 13"
      )

  /**
   * `1.2.840.113549.1.9.16.12.21`: S/MIME Portable Symmetric Key Container Attributes
   */
  public val pskcKeystartdate: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 12 21"
      )

  /**
   * `1.2.840.113549.1.9.16.12.24`: S/MIME Portable Symmetric Key Container Attributes
   */
  public val pskcKeyusages: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 12 24"
      )

  /**
   * `1.2.840.113549.1.9.16.12.27`: S/MIME Portable Symmetric Key Container Attributes
   */
  public val pskcKeyuserid: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 12 27"
      )

  /**
   * `1.2.840.113549.1.9.16.12.1`: S/MIME Portable Symmetric Key Container Attributes
   */
  public val pskcManufacturer: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 12 1"
      )

  /**
   * `1.2.840.113549.1.9.16.12.3`: S/MIME Portable Symmetric Key Container Attributes
   */
  public val pskcModel: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 12 3"
      )

  /**
   * `1.2.840.113549.1.9.16.12.8`: S/MIME Portable Symmetric Key Container Attributes
   */
  public val pskcModuleid: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 12 8"
      )

  /**
   * `1.2.840.113549.1.9.16.12.23`: S/MIME Portable Symmetric Key Container Attributes
   */
  public val pskcNooftransactions: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 12 23"
      )

  /**
   * `1.2.840.113549.1.9.16.12.25`: S/MIME Portable Symmetric Key Container Attributes
   */
  public val pskcPinpolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 12 25"
      )

  /**
   * `1.2.840.113549.1.9.16.12.2`: S/MIME Portable Symmetric Key Container Attributes
   */
  public val pskcSerialNo: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 12 2"
      )

  /**
   * `1.2.840.113549.1.9.16.12.17`: S/MIME Portable Symmetric Key Container Attributes
   */
  public val pskcTime: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 12 17"
      )

  /**
   * `1.2.840.113549.1.9.16.12.19`: S/MIME Portable Symmetric Key Container Attributes
   */
  public val pskcTimedrift: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 12 19"
      )

  /**
   * `1.2.840.113549.1.9.16.12.18`: S/MIME Portable Symmetric Key Container Attributes
   */
  public val pskcTimeinterval: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 12 18"
      )

  /**
   * `1.2.840.113549.1.9.16.12.20`: S/MIME Portable Symmetric Key Container Attributes
   */
  public val pskcValuemac: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 12 20"
      )

  /**
   * `1.3.36.8.7.1.1`: Teletrust presentation types
   */
  public val ptAdobeILL: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 7 1 1"
      )

  /**
   * `1.3.36.8.7.1.2`: Teletrust presentation types
   */
  public val ptAmiPro: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 7 1 2"
      )

  /**
   * `1.3.36.8.7.1.3`: Teletrust presentation types
   */
  public val ptAutoCAD: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 7 1 3"
      )

  /**
   * `1.3.36.8.7.1.5`: Teletrust presentation types
   */
  public val ptBMP: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 7 1 5"
      )

  /**
   * `1.3.36.8.7.1.4`: Teletrust presentation types
   */
  public val ptBinary: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 7 1 4"
      )

  /**
   * `1.3.36.8.7.1.6`: Teletrust presentation types
   */
  public val ptCGM: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 7 1 6"
      )

  /**
   * `1.3.36.8.7.1.7`: Teletrust presentation types
   */
  public val ptCorelCRT: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 7 1 7"
      )

  /**
   * `1.3.36.8.7.1.8`: Teletrust presentation types
   */
  public val ptCorelDRW: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 7 1 8"
      )

  /**
   * `1.3.36.8.7.1.9`: Teletrust presentation types
   */
  public val ptCorelEXC: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 7 1 9"
      )

  /**
   * `1.3.36.8.7.1.10`: Teletrust presentation types
   */
  public val ptCorelPHT: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 7 1 10"
      )

  /**
   * `1.3.36.8.7.1.12`: Teletrust presentation types
   */
  public val ptDVI: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 7 1 12"
      )

  /**
   * `1.3.36.8.7.1.11`: Teletrust presentation types
   */
  public val ptDraw: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 7 1 11"
      )

  /**
   * `1.3.36.8.7.1.13`: Teletrust presentation types
   */
  public val ptEPS: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 7 1 13"
      )

  /**
   * `1.3.36.8.7.1.14`: Teletrust presentation types
   */
  public val ptExcel: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 7 1 14"
      )

  /**
   * `1.3.36.8.7.1.15`: Teletrust presentation types
   */
  public val ptGEM: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 7 1 15"
      )

  /**
   * `1.3.36.8.7.1.16`: Teletrust presentation types
   */
  public val ptGIF: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 7 1 16"
      )

  /**
   * `1.3.36.8.7.1.17`: Teletrust presentation types
   */
  public val ptHPGL: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 7 1 17"
      )

  /**
   * `1.3.36.8.7.1.18`: Teletrust presentation types
   */
  public val ptJPEG: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 7 1 18"
      )

  /**
   * `1.3.36.8.7.1.19`: Teletrust presentation types
   */
  public val ptKodak: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 7 1 19"
      )

  /**
   * `1.3.36.8.7.1.20`: Teletrust presentation types
   */
  public val ptLaTeX: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 7 1 20"
      )

  /**
   * `1.3.36.8.7.1.21`: Teletrust presentation types
   */
  public val ptLotus: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 7 1 21"
      )

  /**
   * `1.3.36.8.7.1.22`: Teletrust presentation types
   */
  public val ptLotusPIC: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 7 1 22"
      )

  /**
   * `1.3.36.8.7.1.25`: Teletrust presentation types
   */
  public val ptMSWfD: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 7 1 25"
      )

  /**
   * `1.3.36.8.7.1.26`: Teletrust presentation types
   */
  public val ptMSWord: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 7 1 26"
      )

  /**
   * `1.3.36.8.7.1.27`: Teletrust presentation types
   */
  public val ptMSWord2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 7 1 27"
      )

  /**
   * `1.3.36.8.7.1.28`: Teletrust presentation types
   */
  public val ptMSWord6: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 7 1 28"
      )

  /**
   * `1.3.36.8.7.1.29`: Teletrust presentation types
   */
  public val ptMSWord8: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 7 1 29"
      )

  /**
   * `1.3.36.8.7.1.23`: Teletrust presentation types
   */
  public val ptMacPICT: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 7 1 23"
      )

  /**
   * `1.3.36.8.7.1.24`: Teletrust presentation types
   */
  public val ptMacWord: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 7 1 24"
      )

  /**
   * `1.3.36.8.7.1.30`: Teletrust presentation types
   */
  public val ptPDF: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 7 1 30"
      )

  /**
   * `1.3.36.8.7.1.31`: Teletrust presentation types
   */
  public val ptPIF: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 7 1 31"
      )

  /**
   * `1.3.36.8.7.1.32`: Teletrust presentation types
   */
  public val ptPostscript: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 7 1 32"
      )

  /**
   * `1.3.36.8.7.1.33`: Teletrust presentation types
   */
  public val ptRTF: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 7 1 33"
      )

  /**
   * `1.3.36.8.7.1.34`: Teletrust presentation types
   */
  public val ptSCITEX: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 7 1 34"
      )

  /**
   * `1.3.36.8.7.1.35`: Teletrust presentation types
   */
  public val ptTAR: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 7 1 35"
      )

  /**
   * `1.3.36.8.7.1.39`: Teletrust presentation types
   */
  public val ptTIFF: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 7 1 39"
      )

  /**
   * `1.3.36.8.7.1.40`: Teletrust presentation types
   */
  public val ptTIFF_FC: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 7 1 40"
      )

  /**
   * `1.3.36.8.7.1.36`: Teletrust presentation types
   */
  public val ptTarga: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 7 1 36"
      )

  /**
   * `1.3.36.8.7.1.37`: Teletrust presentation types
   */
  public val ptTeX: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 7 1 37"
      )

  /**
   * `1.3.36.8.7.1.38`: Teletrust presentation types
   */
  public val ptText: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 7 1 38"
      )

  /**
   * `1.3.36.8.7.1.41`: Teletrust presentation types
   */
  public val ptUID: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 7 1 41"
      )

  /**
   * `1.3.36.8.7.1.42`: Teletrust presentation types
   */
  public val ptUUEncode: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 7 1 42"
      )

  /**
   * `1.3.36.8.7.1.43`: Teletrust presentation types
   */
  public val ptWMF: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 7 1 43"
      )

  /**
   * `1.3.36.8.7.1.45`: Teletrust presentation types
   */
  public val ptWPGrph: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 7 1 45"
      )

  /**
   * `1.3.36.8.7.1.44`: Teletrust presentation types
   */
  public val ptWordPerfect: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 7 1 44"
      )

  /**
   * `1.2.840.113549.1.9.12`: PKCS #9 experimental
   */
  public val publicKey: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 12"
      )

  /**
   * `0.2.262.1.10.7.8`: Telesec attribute
   */
  public val publicKeyDirectory: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 7 8"
      )

  /**
   * `1.2.840.10045.2`: ANSI X9.62
   */
  public val publicKeyType: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10045 2"
      )

  /**
   * `1.2.840.113549.1.9.16.1.3`: S/MIME Content Types
   */
  public val publishCert: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 1 3"
      )

  /**
   * `2.5.4.84`: X.520 DN component
   */
  public val pwdAttribute: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 84"
      )

  /**
   * `1.2.840.113549.1.9.16.3.9`: S/MIME Algorithms
   */
  public val pwriKEK: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 3 9"
      )

  /**
   * `1.3.6.1.5.5.7.1.3`: PKIX private extension
   */
  public val qcStatements: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 1 3"
      )

  /**
   * `0.4.0.194112.1.1`: EU Qualified Certificate Policy
   */
  public val qcpLegal: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 194112 1 1"
      )

  /**
   * `0.4.0.194112.1.3`: EU Qualified Certificate Policy
   */
  public val qcpLegalQscd: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 194112 1 3"
      )

  /**
   * `0.4.0.194112.1.0`: EU Qualified Certificate Policy
   */
  public val qcpNatural: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 194112 1 0"
      )

  /**
   * `0.4.0.194112.1.2`: EU Qualified Certificate Policy
   */
  public val qcpNaturalQscd: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 194112 1 2"
      )

  /**
   * `1.3.158.36061701.0.0.0.1.2.2`: Slovakia Qualified Electronic Signature policies
   */
  public val qcpSK: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 158 36061701 0 0 0 1 2 2"
      )

  /**
   * `0.4.0.194112.1.4`: EU Qualified Certificate Policy
   */
  public val qcpWeb: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 194112 1 4"
      )

  /**
   * `0.4.0.194121.1.2`: EU Qualified Certificate Identifier
   */
  public val qcsSemanticsIdLegal: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 194121 1 2"
      )

  /**
   * `0.4.0.194121.1.1`: EU Qualified Certificate Identifier
   */
  public val qcsSemanticsIdNatural: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 194121 1 1"
      )

  /**
   * `0.4.0.194121.1.4`: EU Qualified Certificate Identifier
   */
  public val qcsSemanticsIdeIDASLegal: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 194121 1 4"
      )

  /**
   * `0.4.0.194121.1.3`: EU Qualified Certificate Identifier
   */
  public val qcsSemanticsIdeIDASNatural: ObjectIdentifier = 
      ObjectIdentifier(
      "0 4 0 194121 1 3"
      )

  /**
   * `1.2.36.1.3.1.1.1`: Queensland Government PKI
   */
  public val qgpki: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 1 1"
      )

  /**
   * `1.2.36.1.3.1.1.1.2.2`: QGPKI assurance level
   */
  public val qgpkiAssuranceBasic: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 1 1 2 2"
      )

  /**
   * `1.2.36.1.3.1.1.1.2.4`: QGPKI assurance level
   */
  public val qgpkiAssuranceHigh: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 1 1 2 4"
      )

  /**
   * `1.2.36.1.3.1.1.1.2`: QGPKI assurance level
   */
  public val qgpkiAssuranceLevel: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 1 1 2"
      )

  /**
   * `1.2.36.1.3.1.1.1.2.3`: QGPKI assurance level
   */
  public val qgpkiAssuranceMedium: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 1 1 2 3"
      )

  /**
   * `1.2.36.1.3.1.1.1.2.1`: QGPKI assurance level
   */
  public val qgpkiAssuranceRudimentary: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 1 1 2 1"
      )

  /**
   * `1.2.36.1.3.1.1.1.1.3`: QGPKI policy
   */
  public val qgpkiBasicIntermedCA: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 1 1 1 3"
      )

  /**
   * `1.2.36.1.3.1.1.1.1.3.1`: QGPKI policy
   */
  public val qgpkiBasicIntermedDeviceSystem: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 1 1 1 3 1"
      )

  /**
   * `1.2.36.1.3.1.1.1.1.4`: QGPKI policy
   */
  public val qgpkiBasicIssuingCA: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 1 1 1 4"
      )

  /**
   * `1.2.36.1.3.1.1.1.1.4.1`: QGPKI policy
   */
  public val qgpkiBasicIssuingClientAuth: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 1 1 1 4 1"
      )

  /**
   * `1.2.36.1.3.1.1.1.1.4.3`: QGPKI policy
   */
  public val qgpkiBasicIssuingDataSigning: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 1 1 1 4 3"
      )

  /**
   * `1.2.36.1.3.1.1.1.1.4.2`: QGPKI policy
   */
  public val qgpkiBasicIssuingServerAuth: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 1 1 1 4 2"
      )

  /**
   * `1.2.36.1.3.1.1.1.3`: QGPKI policies
   */
  public val qgpkiCertFunction: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 1 1 3"
      )

  /**
   * `1.2.36.1.3.1.1.1.3.3`: QGPKI policies
   */
  public val qgpkiFunctionAuthorisedParty: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 1 1 3 3"
      )

  /**
   * `1.2.36.1.3.1.1.1.3.2`: QGPKI policies
   */
  public val qgpkiFunctionDevice: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 1 1 3 2"
      )

  /**
   * `1.2.36.1.3.1.1.1.3.4`: QGPKI policies
   */
  public val qgpkiFunctionDeviceControl: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 1 1 3 4"
      )

  /**
   * `1.2.36.1.3.1.1.1.3.1`: QGPKI policies
   */
  public val qgpkiFunctionIndividual: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 1 1 3 1"
      )

  /**
   * `1.2.36.1.3.1.1.1.1.1.4`: QGPKI policy
   */
  public val qgpkiMedIntermedAuthorisedParty: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 1 1 1 1 4"
      )

  /**
   * `1.2.36.1.3.1.1.1.1.1`: QGPKI policy
   */
  public val qgpkiMedIntermedCA: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 1 1 1 1"
      )

  /**
   * `1.2.36.1.3.1.1.1.1.1.3`: QGPKI policy
   */
  public val qgpkiMedIntermedDevice: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 1 1 1 1 3"
      )

  /**
   * `1.2.36.1.3.1.1.1.1.1.2`: QGPKI policy
   */
  public val qgpkiMedIntermedDeviceControl: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 1 1 1 1 2"
      )

  /**
   * `1.2.36.1.3.1.1.1.1.1.5`: QGPKI policy
   */
  public val qgpkiMedIntermedDeviceSystem: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 1 1 1 1 5"
      )

  /**
   * `1.2.36.1.3.1.1.1.1.1.1`: QGPKI policy
   */
  public val qgpkiMedIntermedIndividual: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 1 1 1 1 1"
      )

  /**
   * `1.2.36.1.3.1.1.1.1.2.4`: QGPKI policy
   */
  public val qgpkiMedIssuingAuthorisedParty: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 1 1 1 2 4"
      )

  /**
   * `1.2.36.1.3.1.1.1.1.2`: QGPKI policy
   */
  public val qgpkiMedIssuingCA: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 1 1 1 2"
      )

  /**
   * `1.2.36.1.3.1.1.1.1.2.5`: QGPKI policy
   */
  public val qgpkiMedIssuingClientAuth: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 1 1 1 2 5"
      )

  /**
   * `1.2.36.1.3.1.1.1.1.2.7`: QGPKI policy
   */
  public val qgpkiMedIssuingDataProt: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 1 1 1 2 7"
      )

  /**
   * `1.2.36.1.3.1.1.1.1.2.3`: QGPKI policy
   */
  public val qgpkiMedIssuingDevice: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 1 1 1 2 3"
      )

  /**
   * `1.2.36.1.3.1.1.1.1.2.2`: QGPKI policy
   */
  public val qgpkiMedIssuingDeviceControl: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 1 1 1 2 2"
      )

  /**
   * `1.2.36.1.3.1.1.1.1.2.1`: QGPKI policy
   */
  public val qgpkiMedIssuingIndividual: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 1 1 1 2 1"
      )

  /**
   * `1.2.36.1.3.1.1.1.1.2.6`: QGPKI policy
   */
  public val qgpkiMedIssuingServerAuth: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 1 1 1 2 6"
      )

  /**
   * `1.2.36.1.3.1.1.1.1.2.8`: QGPKI policy
   */
  public val qgpkiMedIssuingTokenAuth: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 1 1 1 2 8"
      )

  /**
   * `1.2.36.1.3.1.1.1.1`: QGPKI policies
   */
  public val qgpkiPolicies: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 1 1 1"
      )

  /**
   * `1.2.36.1.3.1.2`: Queensland Police PKI
   */
  public val qpspki: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 2"
      )

  /**
   * `1.2.36.1.3.1.2.1`: Queensland Police PKI
   */
  public val qpspkiPolicies: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 2 1"
      )

  /**
   * `1.2.36.1.3.1.2.1.2`: Queensland Police PKI
   */
  public val qpspkiPolicyBasic: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 2 1 2"
      )

  /**
   * `1.2.36.1.3.1.2.1.4`: Queensland Police PKI
   */
  public val qpspkiPolicyHigh: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 2 1 4"
      )

  /**
   * `1.2.36.1.3.1.2.1.3`: Queensland Police PKI
   */
  public val qpspkiPolicyMedium: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 2 1 3"
      )

  /**
   * `1.2.36.1.3.1.3.2`: Queensland Transport PKI
   */
  public val qtmrpki: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 3 2"
      )

  /**
   * `1.2.36.1.3.1.3.2.3.4`: Queensland Transport PKI device
   */
  public val qtmrpkiAdultProofOfAge: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 3 2 3 4"
      )

  /**
   * `1.2.36.1.3.1.3.2.2.4`: Queensland Transport PKI purpose
   */
  public val qtmrpkiAuthorisedParty: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 3 2 2 4"
      )

  /**
   * `1.2.36.1.3.1.3.2.4`: Queensland Transport PKI
   */
  public val qtmrpkiAuthorisedParty_1_2_36_1_3_1_3_2_4: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 3 2 4"
      )

  /**
   * `1.2.36.1.3.1.3.2.2.3`: Queensland Transport PKI purpose
   */
  public val qtmrpkiDevice: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 3 2 2 3"
      )

  /**
   * `1.2.36.1.3.1.3.2.2.2`: Queensland Transport PKI purpose
   */
  public val qtmrpkiDeviceControl: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 3 2 2 2"
      )

  /**
   * `1.2.36.1.3.1.3.2.2.5`: Queensland Transport PKI purpose
   */
  public val qtmrpkiDeviceSystem: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 3 2 2 5"
      )

  /**
   * `1.2.36.1.3.1.3.2.3`: Queensland Transport PKI
   */
  public val qtmrpkiDevice_1_2_36_1_3_1_3_2_3: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 3 2 3"
      )

  /**
   * `1.2.36.1.3.1.3.2.3.1`: Queensland Transport PKI device
   */
  public val qtmrpkiDriverLicense: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 3 2 3 1"
      )

  /**
   * `1.2.36.1.3.1.3.2.2.1`: Queensland Transport PKI purpose
   */
  public val qtmrpkiIndividual: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 3 2 2 1"
      )

  /**
   * `1.2.36.1.3.1.3.2.3.2`: Queensland Transport PKI device
   */
  public val qtmrpkiIndustryAuthority: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 3 2 3 2"
      )

  /**
   * `1.2.36.1.3.1.3.2.4.4`: Queensland Transport PKI authorised party
   */
  public val qtmrpkiLiquorLicensingInspector: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 3 2 4 4"
      )

  /**
   * `1.2.36.1.3.1.3.2.4.5`: Queensland Transport PKI authorised party
   */
  public val qtmrpkiMarineEnforcementOfficer: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 3 2 4 5"
      )

  /**
   * `1.2.36.1.3.1.3.2.3.3`: Queensland Transport PKI device
   */
  public val qtmrpkiMarineLicense: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 3 2 3 3"
      )

  /**
   * `1.2.36.1.3.1.3.2.4.2`: Queensland Transport PKI authorised party
   */
  public val qtmrpkiPoliceOfficer: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 3 2 4 2"
      )

  /**
   * `1.2.36.1.3.1.3.2.1`: Queensland Transport PKI
   */
  public val qtmrpkiPolicies: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 3 2 1"
      )

  /**
   * `1.2.36.1.3.1.3.2.2`: Queensland Transport PKI
   */
  public val qtmrpkiPurpose: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 3 2 2"
      )

  /**
   * `1.2.36.1.3.1.3.2.3.5`: Queensland Transport PKI device
   */
  public val qtmrpkiSam: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 3 2 3 5"
      )

  /**
   * `1.2.36.1.3.1.3.2.4.3`: Queensland Transport PKI authorised party
   */
  public val qtmrpkiSystem: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 3 2 4 3"
      )

  /**
   * `1.2.36.1.3.1.3.2.4.1`: Queensland Transport PKI authorised party
   */
  public val qtmrpkiTransportInspector: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 1 3 1 3 2 4 1"
      )

  /**
   * `1.3.6.1.4.1.311.10.3.10`: Microsoft extended 3key usage
   */
  public val qualifiedSubordination: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 10 3 10"
      )

  /**
   * `1.2.840.113549.1.9.25.3`: PKCS #9/RFC 2985 attribute
   */
  public val randomNonce: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 25 3"
      )

  /**
   * `2.16.840.1.113719.1.2.8.92`: Novell encryption algorithm
   */
  public val rc2BSafe1Cbc: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113719 1 2 8 92"
      )

  /**
   * `1.2.840.113549.3.2`: RSADSI encryptionAlgorithm
   */
  public val rc2CBC: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 3 2"
      )

  /**
   * `2.16.840.1.113719.1.2.8.69`: Novell encryption algorithm
   */
  public val rc2CbcPad: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113719 1 2 8 69"
      )

  /**
   * `1.2.840.113549.3.3`: RSADSI encryptionAlgorithm
   */
  public val rc2ECB: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 3 3"
      )

  /**
   * `1.2.840.113549.1.9.16.3.4`: S/MIME Algorithms. Obsolete
   */
  public val rc2Wrap: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 3 4"
      )

  /**
   * `1.2.840.113549.3.4`: RSADSI encryptionAlgorithm
   */
  public val rc4: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 3 4"
      )

  /**
   * `1.2.840.113549.3.5`: RSADSI encryptionAlgorithm
   */
  public val rc4WithMAC: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 3 5"
      )

  /**
   * `1.2.840.113549.3.8`: RSADSI encryptionAlgorithm
   */
  public val rc5CBC: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 3 8"
      )

  /**
   * `2.16.840.1.113719.1.2.8.28`: Novell encryption algorithm
   */
  public val rc5CbcPad: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113719 1 2 8 28"
      )

  /**
   * `1.2.840.113549.3.9`: RSADSI encryptionAlgorithm
   */
  public val rc5_CBCPad: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 3 9"
      )

  /**
   * `1.3.6.1.4.1.311.21.9`: Microsoft
   */
  public val rdnDummySigner: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 21 9"
      )

  /**
   * `1.2.840.113549.1.9.15.4`: sMIMECapabilities. Deprecated, use (1 2 840 113549 1 9 16 1 1)
   * instead
   */
  public val receipt: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 15 4"
      )

  /**
   * `1.2.840.113549.1.9.15.3`: sMIMECapabilities. Deprecated, use (1 2 840 113549 1 9 16 2 1)
   * instead
   */
  public val receiptRequest: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 15 3"
      )

  /**
   * `1.2.840.113549.1.9.16.2.1`: S/MIME Authenticated Attributes
   */
  public val receiptRequest_1_2_840_113549_1_9_16_2_1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 1"
      )

  /**
   * `1.2.840.113549.1.9.16.1.1`: S/MIME Content Types
   */
  public val receipt_1_2_840_113549_1_9_16_1_1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 1 1"
      )

  /**
   * `1.3.36.8.3.11.1`: Teletrust naming authorities
   */
  public val rechtWirtschaftSteuern: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 3 11 1"
      )

  /**
   * `1.3.36.8.3.11.1.3`: Teletrust ProfessionInfo
   */
  public val rechtsBeistand: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 3 11 1 3"
      )

  /**
   * `1.3.36.8.3.11.1.1`: Teletrust ProfessionInfo
   */
  public val rechtsanwaeltin: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 3 11 1 1"
      )

  /**
   * `1.3.36.8.3.11.1.2`: Teletrust ProfessionInfo
   */
  public val rechtsanwalt: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 3 11 1 2"
      )

  /**
   * `2.16.840.1.113733.1.9.6`: Verisign PKCS #7 attribute
   */
  public val recipientNonce: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113733 1 9 6"
      )

  /**
   * `0.2.262.1.10.1.4.1`: Telesec mechanism
   */
  public val reedSolomon: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 1 4 1"
      )

  /**
   * `1.3.6.1.5.5.7.5.1`: PKIX CRMF registration
   */
  public val regCtrl: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 5 1"
      )

  /**
   * `1.3.6.1.5.5.7.5.1.1`: PKIX CRMF registration control
   */
  public val regToken: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 5 1 1"
      )

  /**
   * `2.5.4.26`: X.520 DN component
   */
  public val registeredAddress: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 26"
      )

  /**
   * `1.2.840.10040.2.3`: ANSI X9.57 hold instruction
   */
  public val reject: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10040 2 3"
      )

  /**
   * `2.16.840.1.113719.1.9.4.2`: Novell PKI attribute type
   */
  public val relianceLimit: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113719 1 9 4 2"
      )

  /**
   * `1.3.6.1.4.1.311.10.8.1`: Microsoft attribute
   */
  public val removeCertificate: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 10 8 1"
      )

  /**
   * `1.3.6.1.4.1.311.13.1`: Microsoft attribute
   */
  public val renewalCertificate: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 13 1"
      )

  /**
   * `1.3.6.1.4.1.311.21.20`: Microsoft attribute
   */
  public val requestClientInfo: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 21 20"
      )

  /**
   * `1.3.36.8.3.10`: Teletrust attribute
   */
  public val requestedCertificate: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 3 10"
      )

  /**
   * `1.3.6.1.4.1.311.21.15`: Microsoft
   */
  public val requireCertChainPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 21 15"
      )

  /**
   * `2.5.6.10`: X.520 objectClass
   */
  public val residentialPerson: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 6 10"
      )

  /**
   * `1.3.6.1.5.5.7.14.2`: PKIX policies
   */
  public val resourceCertificatePolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 14 2"
      )

  /**
   * `1.2.840.113549.1.9.16.1.36`: S/MIME Content Types
   */
  public val resourceTaggedAttest: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 1 36"
      )

  /**
   * `1.3.36.8.3.8`: Teletrust attribute
   */
  public val restriction: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 3 8"
      )

  /**
   * `1.3.36.8.4.8`: Teletrust attribute certificate attribute
   */
  public val restriction_1_3_36_8_4_8: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 4 8"
      )

  /**
   * `1.3.36.8.3.9`: Teletrust attribute
   */
  public val retrieveIfAllowed: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 3 9"
      )

  /**
   * `1.3.6.1.5.5.7.4.12`: PKIX CMP information
   */
  public val revPassphrase: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 4 12"
      )

  /**
   * `1.2.840.113549.1.9.16.9.4`: S/MIME Signature Type Identifier
   */
  public val reviewSig: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 9 4"
      )

  /**
   * `1.2.840.113556.1.4.145`: Microsoft Cert Template - attribute
   */
  public val revision: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113556 1 4 145"
      )

  /**
   * `1.2.840.113549.1.9.16.2.57`: S/MIME Authenticated Attributes
   */
  public val revocationChallenge: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 57"
      )

  /**
   * `0.2.262.1.10.7.34`: Telesec attribute
   */
  public val revocationFlag: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 7 34"
      )

  /**
   * `1.2.840.113549.1.9.16.2.22`: S/MIME Authenticated Attributes
   */
  public val revocationRefs: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 22"
      )

  /**
   * `1.2.840.113549.1.9.16.2.24`: S/MIME Authenticated Attributes
   */
  public val revocationValues: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 24"
      )

  /**
   * `2.5.29.59`: X.509 extension
   */
  public val revokedGroups: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 59"
      )

  /**
   * `0.9.2342.19200300.100.1.3`: Some oddball X.500 attribute collection
   */
  public val rfc822Mailbox: ObjectIdentifier = 
      ObjectIdentifier(
      "0 9 2342 19200300 100 1 3"
      )

  /**
   * `2.16.840.1.101.2.1.2.1`: SDN.700 INFOSEC format
   */
  public val rfc822MessageFormat: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 2 1"
      )

  /**
   * `1.2.643.2.2.31.7`: RIC-1 params for GOST 28147-89
   */
  public val ric1Cipher: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 2 2 31 7"
      )

  /**
   * `0.2.262.1.10.1.3.5`: Telesec one-way function
   */
  public val ripemd128: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 1 3 5"
      )

  /**
   * `1.0.10118.3.0.50`: ISO 10118-3 hash function
   */
  public val ripemd128_1_0_10118_3_0_50: ObjectIdentifier = 
      ObjectIdentifier(
      "1 0 10118 3 0 50"
      )

  /**
   * `1.3.36.3.2.2`: Teletrust hash algorithm
   */
  public val ripemd128_1_3_36_3_2_2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 2 2"
      )

  /**
   * `0.2.262.1.10.1.3.8`: Telesec one-way function
   */
  public val ripemd160: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 1 3 8"
      )

  /**
   * `0.2.262.1.10.1.1.5`: Telesec mechanism
   */
  public val ripemd160WithRSAAndTelekomSignatureStandard: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 1 1 5"
      )

  /**
   * `1.0.10118.3.0.49`: ISO 10118-3 hash function
   */
  public val ripemd160_1_0_10118_3_0_49: ObjectIdentifier = 
      ObjectIdentifier(
      "1 0 10118 3 0 49"
      )

  /**
   * `1.3.36.3.2.1`: Teletrust hash algorithm
   */
  public val ripemd160_1_3_36_3_2_1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 2 1"
      )

  /**
   * `1.3.36.3.2.3`: Teletrust hash algorithm
   */
  public val ripemd256: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 2 3"
      )

  /**
   * `1.3.6.1.5.2.3.3`: Kerberos
   */
  public val rkeyData: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 2 3 3"
      )

  /**
   * `1.3.6.1.4.1.8231.1`: Chilean Government national unique roll number
   */
  public val rolUnicoNacional: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 8231 1"
      )

  /**
   * `1.3.6.1.5.5.7.10.5`: PKIX attribute certificate extension
   */
  public val role: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 10 5"
      )

  /**
   * `2.5.4.33`: X.520 DN component
   */
  public val roleOccupant: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 33"
      )

  /**
   * `2.5.29.39`: X.509 extension
   */
  public val roleSpecCertIdentifier: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 39"
      )

  /**
   * `2.5.4.72`: X.520 DN component
   */
  public val role_2_5_4_72: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 72"
      )

  /**
   * `2.23.42.5.0`: SET policy
   */
  public val root: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 5 0"
      )

  /**
   * `2.23.42.3.0.0`: SET cert attribute
   */
  public val rootKeyThumb: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 3 0 0"
      )

  /**
   * `1.3.6.1.4.1.311.10.3.9`: Microsoft extended key usage
   */
  public val rootListSigner: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 10 3 9"
      )

  /**
   * `1.3.6.1.4.1.311.60.1.1`: Microsoft policy attribute
   */
  public val rootProgramFlags: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 60 1 1"
      )

  /**
   * `1.2.840.113549.1.9.16.1.24`: S/MIME Content Types
   */
  public val routeOriginAttest: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 1 24"
      )

  /**
   * `1.3.6.1.5.5.7.1.9`: PKIX private extension
   */
  public val routerIdentifier: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 1 9"
      )

  /**
   * `1.3.6.1.5.5.7.3.33`: PKIX key purpose
   */
  public val rpcTLSClient: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 3 33"
      )

  /**
   * `1.3.6.1.5.5.7.3.34`: PKIX key purpose
   */
  public val rpcTLSServer: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 3 34"
      )

  /**
   * `1.2.840.113549.1.9.16.1.49`: S/MIME Content Types
   */
  public val rpkiASPA: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 1 49"
      )

  /**
   * `1.2.840.113549.1.9.16.1.35`: S/MIME Content Types
   */
  public val rpkiGhostbusters: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 1 35"
      )

  /**
   * `1.2.840.113549.1.9.16.1.26`: S/MIME Content Types
   */
  public val rpkiManifest: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 1 26"
      )

  /**
   * `1.3.6.1.5.5.7.48.10`: PKIX subject/authority info access descriptor
   */
  public val rpkiManifest_1_3_6_1_5_5_7_48_10: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 48 10"
      )

  /**
   * `1.2.840.113549.1.9.16.1.48`: S/MIME Content Types
   */
  public val rpkiSignedChecklist: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 1 48"
      )

  /**
   * `1.2.840.113549.1.9.16.1.33`: S/MIME Content Types
   */
  public val rpkiTrustAnchor: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 1 33"
      )

  /**
   * `1.3.14.3.2.1.1`: X.509. Unsure about this OID
   */
  public val rsa: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 14 3 2 1 1"
      )

  /**
   * `1.2.840.113549.1.1.1`: PKCS #1
   */
  public val rsaEncryption: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 1 1"
      )

  /**
   * `2.16.840.1.113719.1.2.8.131`: Novell encryption algorithm
   */
  public val rsaEncryptionBsafe1: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113719 1 2 8 131"
      )

  /**
   * `1.3.36.3.1.4.512.17`: Teletrust encryption algorithm
   */
  public val rsaEncryptionWithlmod512expe17: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 1 4 512 17"
      )

  /**
   * `1.3.36.3.1.4`: Teletrust encryption algorithm
   */
  public val rsaEncryption_1_3_36_3_1_4: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 1 4"
      )

  /**
   * `1.3.36.8.5.1.1.2`: Teletrust signature algorithm
   */
  public val rsaIndicateRIPEMD160: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 5 1 1 2"
      )

  /**
   * `1.3.36.8.5.1.1.1`: Teletrust signature algorithm
   */
  public val rsaIndicateSHA1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 5 1 1 1"
      )

  /**
   * `1.2.840.113549.1.9.16.3.14`: S/MIME Algorithms
   */
  public val rsaKEM: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 3 14"
      )

  /**
   * `1.3.14.3.2.22`: Oddball OIW OID
   */
  public val rsaKeyTransport: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 14 3 2 22"
      )

  /**
   * `1.2.840.113549.1.1.7`: PKCS #1
   */
  public val rsaOAEP: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 1 7"
      )

  /**
   * `1.2.840.113549.1.1.6`: PKCS #1. This OID may also be assigned as ripemd160WithRSAEncryption
   */
  public val rsaOAEPEncryptionSET: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 1 6"
      )

  /**
   * `1.2.840.113549.1.1.9`: PKCS #1
   */
  public val rsaOAEP_pSpecified: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 1 9"
      )

  /**
   * `1.2.840.113549.1.1.10`: PKCS #1
   */
  public val rsaPSS: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 1 10"
      )

  /**
   * `1.3.6.1.5.5.7.6.30`: PKIX algorithm
   */
  public val rsaPssShake128: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 6 30"
      )

  /**
   * `1.3.6.1.5.5.7.6.31`: PKIX algorithm
   */
  public val rsaPssShake256: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 6 31"
      )

  /**
   * `1.3.14.3.2.11`: ISO 9796-2, also X9.31 Part 1
   */
  public val rsaSignature: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 14 3 2 11"
      )

  /**
   * `1.3.36.3.3.1.3`: Teletrust signature algorithm
   */
  public val rsaSignatureWithrimpemd128: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1 3"
      )

  /**
   * `1.3.36.3.3.1.4`: Teletrust signature algorithm
   */
  public val rsaSignatureWithrimpemd256: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1 4"
      )

  /**
   * `1.3.36.3.3.1.2`: Teletrust signature algorithm
   */
  public val rsaSignatureWithripemd160: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1 2"
      )

  /**
   * `1.3.36.3.3.1.2.1024.11`: Teletrust signature algorithm
   */
  public val rsaSignatureWithripemd160_l1024_l11: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1 2 1024 11"
      )

  /**
   * `1.3.36.3.3.1.2.1024.2`: Teletrust signature algorithm
   */
  public val rsaSignatureWithripemd160_l1024_l2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1 2 1024 2"
      )

  /**
   * `1.3.36.3.3.1.2.1024.3`: Teletrust signature algorithm
   */
  public val rsaSignatureWithripemd160_l1024_l3: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1 2 1024 3"
      )

  /**
   * `1.3.36.3.3.1.2.1024.5`: Teletrust signature algorithm
   */
  public val rsaSignatureWithripemd160_l1024_l5: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1 2 1024 5"
      )

  /**
   * `1.3.36.3.3.1.2.1024.9`: Teletrust signature algorithm
   */
  public val rsaSignatureWithripemd160_l1024_l9: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1 2 1024 9"
      )

  /**
   * `1.3.36.3.3.1.2.512.11`: Teletrust signature algorithm
   */
  public val rsaSignatureWithripemd160_l512_l11: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1 2 512 11"
      )

  /**
   * `1.3.36.3.3.1.2.512.2`: Teletrust signature algorithm
   */
  public val rsaSignatureWithripemd160_l512_l2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1 2 512 2"
      )

  /**
   * `1.3.36.3.3.1.2.512.3`: Teletrust signature algorithm
   */
  public val rsaSignatureWithripemd160_l512_l3: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1 2 512 3"
      )

  /**
   * `1.3.36.3.3.1.2.512.5`: Teletrust signature algorithm
   */
  public val rsaSignatureWithripemd160_l512_l5: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1 2 512 5"
      )

  /**
   * `1.3.36.3.3.1.2.512.9`: Teletrust signature algorithm
   */
  public val rsaSignatureWithripemd160_l512_l9: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1 2 512 9"
      )

  /**
   * `1.3.36.3.3.1.2.640.11`: Teletrust signature algorithm
   */
  public val rsaSignatureWithripemd160_l640_l11: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1 2 640 11"
      )

  /**
   * `1.3.36.3.3.1.2.640.2`: Teletrust signature algorithm
   */
  public val rsaSignatureWithripemd160_l640_l2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1 2 640 2"
      )

  /**
   * `1.3.36.3.3.1.2.640.3`: Teletrust signature algorithm
   */
  public val rsaSignatureWithripemd160_l640_l3: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1 2 640 3"
      )

  /**
   * `1.3.36.3.3.1.2.640.5`: Teletrust signature algorithm
   */
  public val rsaSignatureWithripemd160_l640_l5: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1 2 640 5"
      )

  /**
   * `1.3.36.3.3.1.2.640.9`: Teletrust signature algorithm
   */
  public val rsaSignatureWithripemd160_l640_l9: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1 2 640 9"
      )

  /**
   * `1.3.36.3.3.1.2.768.11`: Teletrust signature algorithm
   */
  public val rsaSignatureWithripemd160_l768_l11: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1 2 768 11"
      )

  /**
   * `1.3.36.3.3.1.2.768.2`: Teletrust signature algorithm
   */
  public val rsaSignatureWithripemd160_l768_l2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1 2 768 2"
      )

  /**
   * `1.3.36.3.3.1.2.768.3`: Teletrust signature algorithm
   */
  public val rsaSignatureWithripemd160_l768_l3: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1 2 768 3"
      )

  /**
   * `1.3.36.3.3.1.2.768.5`: Teletrust signature algorithm
   */
  public val rsaSignatureWithripemd160_l768_l5: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1 2 768 5"
      )

  /**
   * `1.3.36.3.3.1.2.768.9`: Teletrust signature algorithm
   */
  public val rsaSignatureWithripemd160_l768_l9: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1 2 768 9"
      )

  /**
   * `1.3.36.3.3.1.2.896.11`: Teletrust signature algorithm
   */
  public val rsaSignatureWithripemd160_l896_l11: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1 2 896 11"
      )

  /**
   * `1.3.36.3.3.1.2.896.2`: Teletrust signature algorithm
   */
  public val rsaSignatureWithripemd160_l896_l2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1 2 896 2"
      )

  /**
   * `1.3.36.3.3.1.2.896.3`: Teletrust signature algorithm
   */
  public val rsaSignatureWithripemd160_l896_l3: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1 2 896 3"
      )

  /**
   * `1.3.36.3.3.1.2.896.5`: Teletrust signature algorithm
   */
  public val rsaSignatureWithripemd160_l896_l5: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1 2 896 5"
      )

  /**
   * `1.3.36.3.3.1.2.896.9`: Teletrust signature algorithm
   */
  public val rsaSignatureWithripemd160_l896_l9: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1 2 896 9"
      )

  /**
   * `1.3.36.3.3.1.1`: Teletrust signature algorithm
   */
  public val rsaSignatureWithsha1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1 1"
      )

  /**
   * `1.3.36.3.3.1.1.1024.11`: Teletrust signature algorithm
   */
  public val rsaSignatureWithsha1_l1024_l11: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1 1 1024 11"
      )

  /**
   * `1.3.36.3.3.1.1.1024.2`: Teletrust signature algorithm
   */
  public val rsaSignatureWithsha1_l1024_l2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1 1 1024 2"
      )

  /**
   * `1.3.36.3.3.1.1.1024.3`: Teletrust signature algorithm
   */
  public val rsaSignatureWithsha1_l1024_l3: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1 1 1024 3"
      )

  /**
   * `1.3.36.3.3.1.1.1024.5`: Teletrust signature algorithm
   */
  public val rsaSignatureWithsha1_l1024_l5: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1 1 1024 5"
      )

  /**
   * `1.3.36.3.3.1.1.1024.9`: Teletrust signature algorithm
   */
  public val rsaSignatureWithsha1_l1024_l9: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1 1 1024 9"
      )

  /**
   * `1.3.36.3.3.1.1.512.11`: Teletrust signature algorithm
   */
  public val rsaSignatureWithsha1_l512_l11: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1 1 512 11"
      )

  /**
   * `1.3.36.3.3.1.1.512.2`: Teletrust signature algorithm
   */
  public val rsaSignatureWithsha1_l512_l2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1 1 512 2"
      )

  /**
   * `1.3.36.3.3.1.1.512.3`: Teletrust signature algorithm
   */
  public val rsaSignatureWithsha1_l512_l3: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1 1 512 3"
      )

  /**
   * `1.3.36.3.3.1.1.512.5`: Teletrust signature algorithm
   */
  public val rsaSignatureWithsha1_l512_l5: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1 1 512 5"
      )

  /**
   * `1.3.36.3.3.1.1.512.9`: Teletrust signature algorithm
   */
  public val rsaSignatureWithsha1_l512_l9: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1 1 512 9"
      )

  /**
   * `1.3.36.3.3.1.1.640.11`: Teletrust signature algorithm
   */
  public val rsaSignatureWithsha1_l640_l11: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1 1 640 11"
      )

  /**
   * `1.3.36.3.3.1.1.640.2`: Teletrust signature algorithm
   */
  public val rsaSignatureWithsha1_l640_l2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1 1 640 2"
      )

  /**
   * `1.3.36.3.3.1.1.640.3`: Teletrust signature algorithm
   */
  public val rsaSignatureWithsha1_l640_l3: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1 1 640 3"
      )

  /**
   * `1.3.36.3.3.1.1.640.5`: Teletrust signature algorithm
   */
  public val rsaSignatureWithsha1_l640_l5: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1 1 640 5"
      )

  /**
   * `1.3.36.3.3.1.1.640.9`: Teletrust signature algorithm
   */
  public val rsaSignatureWithsha1_l640_l9: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1 1 640 9"
      )

  /**
   * `1.3.36.3.3.1.1.768.11`: Teletrust signature algorithm
   */
  public val rsaSignatureWithsha1_l768_l11: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1 1 768 11"
      )

  /**
   * `1.3.36.3.3.1.1.768.2`: Teletrust signature algorithm
   */
  public val rsaSignatureWithsha1_l768_l2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1 1 768 2"
      )

  /**
   * `1.3.36.3.3.1.1.768.3`: Teletrust signature algorithm
   */
  public val rsaSignatureWithsha1_l768_l3: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1 1 768 3"
      )

  /**
   * `1.3.36.3.3.1.1.768.5`: Teletrust signature algorithm
   */
  public val rsaSignatureWithsha1_l768_l5: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1 1 768 5"
      )

  /**
   * `1.3.36.3.3.1.1.768.9`: Teletrust signature algorithm
   */
  public val rsaSignatureWithsha1_l768_l9: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1 1 768 9"
      )

  /**
   * `1.3.36.3.3.1.1.896.11`: Teletrust signature algorithm
   */
  public val rsaSignatureWithsha1_l896_l11: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1 1 896 11"
      )

  /**
   * `1.3.36.3.3.1.1.896.2`: Teletrust signature algorithm
   */
  public val rsaSignatureWithsha1_l896_l2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1 1 896 2"
      )

  /**
   * `1.3.36.3.3.1.1.896.3`: Teletrust signature algorithm
   */
  public val rsaSignatureWithsha1_l896_l3: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1 1 896 3"
      )

  /**
   * `1.3.36.3.3.1.1.896.5`: Teletrust signature algorithm
   */
  public val rsaSignatureWithsha1_l896_l5: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1 1 896 5"
      )

  /**
   * `1.3.36.3.3.1.1.896.9`: Teletrust signature algorithm
   */
  public val rsaSignatureWithsha1_l896_l9: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1 1 896 9"
      )

  /**
   * `1.3.36.3.3.1`: Teletrust signature algorithm
   */
  public val rsaSignature_1_3_36_3_3_1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3 1"
      )

  /**
   * `0.2.262.1.10.1.2.1`: Telesec encryption
   */
  public val rsaTelesec: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 1 2 1"
      )

  /**
   * `1.2.410.200004.1.20`: Korean signature algorithm
   */
  public val rsaWithHAS160: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200004 1 20"
      )

  /**
   * `1.3.36.8.5.1.1.4`: Teletrust signature algorithm
   */
  public val rsaWithRIPEMD160: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 5 1 1 4"
      )

  /**
   * `1.3.36.8.5.1.1.3`: Teletrust signature algorithm
   */
  public val rsaWithSHA1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 5 1 1 3"
      )

  /**
   * `1.2.156.10197.1.504`: China GM Standards Committee
   */
  public val rsaWithSM3: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 156 10197 1 504"
      )

  /**
   * `2.5.8.1.1`: X.500 algorithms.  Ambiguous, since no padding rules specified
   */
  public val rsa_2_5_8_1_1: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 8 1 1"
      )

  /**
   * `1.3.6.1.4.1.3029.4.1.4`: cryptlib content type
   */
  public val rtcsRequest: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 3029 4 1 4"
      )

  /**
   * `1.3.6.1.4.1.3029.4.1.5`: cryptlib content type
   */
  public val rtcsResponse: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 3029 4 1 5"
      )

  /**
   * `1.3.6.1.4.1.3029.4.1.6`: cryptlib content type
   */
  public val rtcsResponseExt: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 3029 4 1 6"
      )

  /**
   * `1.2.840.113549.1.9.15`: PKCS #9. This OID was formerly assigned as symmetricCapabilities, then
   * reassigned as SMIMECapabilities, then renamed to the current name
   */
  public val sMIMECapabilities: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 15"
      )

  /**
   * `2.5.29.50`: X.509 extension
   */
  public val sOAIdentifier: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 50"
      )

  /**
   * `0.2.262.1.10.2.9`: Telesec module
   */
  public val sadmib: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 2 9"
      )

  /**
   * `1.3.6.1.4.1.23629.1.4.2.1.4`: SafeNet
   */
  public val safenetAdminCert: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 23629 1 4 2 1 4"
      )

  /**
   * `1.3.6.1.4.1.23629.1.4.2.1.2`: SafeNet
   */
  public val safenetEndDate: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 23629 1 4 2 1 2"
      )

  /**
   * `1.3.6.1.4.1.23629.1.4.2.2.1`: SafeNet
   */
  public val safenetKeyDigest: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 23629 1 4 2 2 1"
      )

  /**
   * `1.3.6.1.4.1.23629.1.4.2.1.3`: SafeNet
   */
  public val safenetStartDate: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 23629 1 4 2 1 3"
      )

  /**
   * `1.3.6.1.4.1.23629.1.4.2.1.1`: SafeNet
   */
  public val safenetUsageLimit: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 23629 1 4 2 1 1"
      )

  /**
   * `1.3.6.1.5.5.7.3.11`: PKIX key purpose
   */
  public val sbgpCertAAServerAuth: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 3 11"
      )

  /**
   * `1.2.840.10046.3`: ANSI X9.42
   */
  public val scheme: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10046 3"
      )

  /**
   * `1.3.6.1.4.1.11591.4.11`: GNU Generic Security Service
   */
  public val scrypt: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 11591 4 11"
      )

  /**
   * `1.3.6.1.5.5.7.19.3`: SCVP validation policy
   */
  public val scvpBasicValAlg: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 19 3"
      )

  /**
   * `1.2.840.113549.1.9.16.1.10`: S/MIME Content Types
   */
  public val scvpCertValRequest: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 1 10"
      )

  /**
   * `1.2.840.113549.1.9.16.1.11`: S/MIME Content Types
   */
  public val scvpCertValResponse: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 1 11"
      )

  /**
   * `1.3.6.1.5.5.7.17`: PKIX SCVP check
   */
  public val scvpCheck: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 17"
      )

  /**
   * `1.3.6.1.5.5.7.17.4`: SCVP
   */
  public val scvpCheckBuildAaPath: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 17 4"
      )

  /**
   * `1.3.6.1.5.5.7.17.1`: SCVP
   */
  public val scvpCheckBuildPath: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 17 1"
      )

  /**
   * `1.3.6.1.5.5.7.17.6`: SCVP
   */
  public val scvpCheckBuildStatusCheckedAaPath: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 17 6"
      )

  /**
   * `1.3.6.1.5.5.7.17.3`: SCVP
   */
  public val scvpCheckBuildStatusCheckedPath: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 17 3"
      )

  /**
   * `1.3.6.1.5.5.7.17.5`: SCVP
   */
  public val scvpCheckBuildValidAaPath: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 17 5"
      )

  /**
   * `1.3.6.1.5.5.7.17.2`: SCVP
   */
  public val scvpCheckBuildValidPath: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 17 2"
      )

  /**
   * `1.3.6.1.5.5.7.17.7`: SCVP
   */
  public val scvpCheckStatusCheckAcAndBuildStatusCheckedAaPath: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 17 7"
      )

  /**
   * `1.3.6.1.5.5.7.3.16`: PKIX key purpose
   */
  public val scvpClient: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 3 16"
      )

  /**
   * `1.3.6.1.5.5.7.19.1`: SCVP validation policy
   */
  public val scvpDefaultValPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 19 1"
      )

  /**
   * `1.3.6.1.5.5.7.19.2.4`: SCVP validation policy
   */
  public val scvpNameErrorBadName: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 19 2 4"
      )

  /**
   * `1.3.6.1.5.5.7.19.2.5`: SCVP validation policy
   */
  public val scvpNameErrorBadNameType: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 19 2 5"
      )

  /**
   * `1.3.6.1.5.5.7.19.2.6`: SCVP validation policy
   */
  public val scvpNameErrorMixedNames: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 19 2 6"
      )

  /**
   * `1.3.6.1.5.5.7.19.2.1`: SCVP validation policy
   */
  public val scvpNameErrorNameMismatch: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 19 2 1"
      )

  /**
   * `1.3.6.1.5.5.7.19.2.2`: SCVP validation policy
   */
  public val scvpNameErrorNoName: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 19 2 2"
      )

  /**
   * `1.3.6.1.5.5.7.19.2.3`: SCVP validation policy
   */
  public val scvpNameErrorUnknownAlg: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 19 2 3"
      )

  /**
   * `1.3.6.1.5.5.7.19.2`: SCVP validation policy
   */
  public val scvpNameValAlg: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 19 2"
      )

  /**
   * `1.3.6.1.5.5.7.3.12`: PKIX key purpose
   */
  public val scvpResponder: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 3 12"
      )

  /**
   * `1.3.6.1.5.5.7.3.15`: PKIX key purpose
   */
  public val scvpServer: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 3 15"
      )

  /**
   * `1.3.6.1.5.5.7.19.3.1`: SCVP validation policy error
   */
  public val scvpValErrorExpired: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 19 3 1"
      )

  /**
   * `1.3.6.1.5.5.7.19.3.11`: SCVP validation policy error
   */
  public val scvpValErrorInvalidCertPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 19 3 11"
      )

  /**
   * `1.3.6.1.5.5.7.19.3.9`: SCVP validation policy error
   */
  public val scvpValErrorInvalidKeyPurpose: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 19 3 9"
      )

  /**
   * `1.3.6.1.5.5.7.19.3.10`: SCVP validation policy error
   */
  public val scvpValErrorInvalidKeyUsage: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 19 3 10"
      )

  /**
   * `1.3.6.1.5.5.7.19.3.4`: SCVP validation policy error
   */
  public val scvpValErrorNoValidCertPath: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 19 3 4"
      )

  /**
   * `1.3.6.1.5.5.7.19.3.2`: SCVP validation policy error
   */
  public val scvpValErrorNotYetValid: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 19 3 2"
      )

  /**
   * `1.3.6.1.5.5.7.19.3.5`: SCVP validation policy error
   */
  public val scvpValErrorRevoked: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 19 3 5"
      )

  /**
   * `1.3.6.1.5.5.7.19.3.3`: SCVP validation policy error
   */
  public val scvpValErrorWrongTrustAnchor: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 19 3 3"
      )

  /**
   * `1.2.840.113549.1.9.16.1.12`: S/MIME Content Types
   */
  public val scvpValPolRequest: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 1 12"
      )

  /**
   * `1.2.840.113549.1.9.16.1.13`: S/MIME Content Types
   */
  public val scvpValPolResponse: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 1 13"
      )

  /**
   * `1.3.6.1.5.5.7.19`: SCVP validation policy
   */
  public val scvpValPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 19"
      )

  /**
   * `1.3.6.1.5.5.7.18`: PKIX SCVP wantback
   */
  public val scvpWantBack: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 18"
      )

  /**
   * `1.3.6.1.5.5.7.18.5`: SCVP wantback
   */
  public val scvpWantbackAaCertPath: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 18 5"
      )

  /**
   * `1.3.6.1.5.5.7.18.6`: SCVP wantback
   */
  public val scvpWantbackAaRevocationInfo: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 18 6"
      )

  /**
   * `1.3.6.1.5.5.7.18.11`: SCVP wantback
   */
  public val scvpWantbackAcCert: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 18 11"
      )

  /**
   * `1.3.6.1.5.5.7.18.7`: SCVP wantback
   */
  public val scvpWantbackAcRevocationInfo: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 18 7"
      )

  /**
   * `1.3.6.1.5.5.7.18.12`: SCVP wantback
   */
  public val scvpWantbackAllCertPaths: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 18 12"
      )

  /**
   * `1.3.6.1.5.5.7.18.1`: SCVP wantback
   */
  public val scvpWantbackBestCertPath: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 18 1"
      )

  /**
   * `1.3.6.1.5.5.7.18.14`: SCVP wantback
   */
  public val scvpWantbackCAsRevocationInfo: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 18 14"
      )

  /**
   * `1.3.6.1.5.5.7.18.10`: SCVP wantback
   */
  public val scvpWantbackCert: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 18 10"
      )

  /**
   * `1.3.6.1.5.5.7.18.13`: SCVP wantback
   */
  public val scvpWantbackEeRevocationInfo: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 18 13"
      )

  /**
   * `1.3.6.1.5.5.7.18.4`: SCVP wantback
   */
  public val scvpWantbackPublicKeyInfo: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 18 4"
      )

  /**
   * `1.3.6.1.5.5.7.18.9`: SCVP wantback
   */
  public val scvpWantbackRelayedResponses: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 18 9"
      )

  /**
   * `1.3.6.1.5.5.7.18.2`: SCVP wantback
   */
  public val scvpWantbackRevocationInfo: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 18 2"
      )

  /**
   * `2.16.840.1.101.2.1.5.8`: SDN.700 INFOSEC attributes (superseded)
   */
  public val sdnsCASignatureCertificate: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 5 8"
      )

  /**
   * `2.16.840.1.101.2.1.5.41`: SDN.700 INFOSEC attributes
   */
  public val sdnsCKL: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 5 41"
      )

  /**
   * `2.16.840.1.101.2.1.5.44`: SDN.700 INFOSEC attributes
   */
  public val sdnsCertificateRevocationList: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 5 44"
      )

  /**
   * `2.16.840.1.101.2.1.1.3`: SDN.700 INFOSEC algorithms
   */
  public val sdnsConfidentialityAlgorithm: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 1 3"
      )

  /**
   * `2.16.840.1.101.2.1.1.5`: SDN.700 INFOSEC algorithms
   */
  public val sdnsIntegrityAlgorithm: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 1 5"
      )

  /**
   * `2.16.840.1.101.2.1.1.11`: SDN.700 INFOSEC algorithms
   */
  public val sdnsKMandSigAlgorithm: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 1 11"
      )

  /**
   * `2.16.840.1.101.2.1.5.3`: SDN.700 INFOSEC attributes (superseded)
   */
  public val sdnsKMandSigCertificate: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 5 3"
      )

  /**
   * `2.16.840.1.101.2.1.1.9`: SDN.700 INFOSEC algorithms
   */
  public val sdnsKeyManagementAlgorithm: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 1 9"
      )

  /**
   * `2.16.840.1.101.2.1.5.1`: SDN.700 INFOSEC attributes (superseded)
   */
  public val sdnsKeyManagementCertificate: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 5 1"
      )

  /**
   * `2.16.840.1.101.2.1.3.2`: SDN.700 INFOSEC policy
   */
  public val sdnsPRBAC: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 3 2"
      )

  /**
   * `2.16.840.1.101.2.1.3.1`: SDN.700 INFOSEC policy
   */
  public val sdnsSecurityPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 3 1"
      )

  /**
   * `2.16.840.1.101.2.1.1.1`: SDN.700 INFOSEC algorithms
   */
  public val sdnsSignatureAlgorithm: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 1 1"
      )

  /**
   * `2.16.840.1.101.2.1.5.43`: SDN.700 INFOSEC attributes
   */
  public val sdnsSignatureCKL: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 5 43"
      )

  /**
   * `2.16.840.1.101.2.1.1.7`: SDN.700 INFOSEC algorithms
   */
  public val sdnsTokenProtectionAlgorithm: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 1 7"
      )

  /**
   * `2.16.840.1.101.2.1.5.2`: SDN.700 INFOSEC attributes (superseded)
   */
  public val sdnsUserSignatureCertificate: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 5 2"
      )

  /**
   * `1.2.840.113549.1.9.22.2`: PKCS #9 via PKCS #12
   */
  public val sdsiCertificate_for_PKCS_12: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 22 2"
      )

  /**
   * `2.5.4.14`: X.520 DN component
   */
  public val searchGuide: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 14"
      )

  /**
   * `2.16.840.1.101.2.1.5.59`: SDN.700 INFOSEC attributes
   */
  public val secPolicyInformationFile: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 5 59"
      )

  /**
   * `1.3.6.1.4.1.5770.0.3`: MEDePass
   */
  public val secondaryPractices: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 5770 0 3"
      )

  /**
   * `1.3.132.0.6`: SECG (Certicom) named elliptic curve
   */
  public val secp112r1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 132 0 6"
      )

  /**
   * `1.3.132.0.7`: SECG (Certicom) named elliptic curve
   */
  public val secp112r2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 132 0 7"
      )

  /**
   * `1.3.132.0.28`: SECG (Certicom) named elliptic curve
   */
  public val secp128r1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 132 0 28"
      )

  /**
   * `1.3.132.0.29`: SECG (Certicom) named elliptic curve
   */
  public val secp128r2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 132 0 29"
      )

  /**
   * `1.3.132.0.9`: SECG (Certicom) named elliptic curve
   */
  public val secp160k1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 132 0 9"
      )

  /**
   * `1.3.132.0.8`: SECG (Certicom) named elliptic curve
   */
  public val secp160r1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 132 0 8"
      )

  /**
   * `1.3.132.0.30`: SECG (Certicom) named elliptic curve
   */
  public val secp160r2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 132 0 30"
      )

  /**
   * `1.3.132.0.31`: SECG (Certicom) named elliptic curve
   */
  public val secp192k1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 132 0 31"
      )

  /**
   * `1.3.132.0.32`: SECG (Certicom) named elliptic curve
   */
  public val secp224k1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 132 0 32"
      )

  /**
   * `1.3.132.0.33`: SECG (Certicom) named elliptic curve
   */
  public val secp224r1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 132 0 33"
      )

  /**
   * `1.3.132.0.10`: SECG (Certicom) named elliptic curve
   */
  public val secp256k1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 132 0 10"
      )

  /**
   * `1.3.132.0.34`: SECG (Certicom) named elliptic curve
   */
  public val secp384r1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 132 0 34"
      )

  /**
   * `1.3.132.0.35`: SECG (Certicom) named elliptic curve
   */
  public val secp521r1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 132 0 35"
      )

  /**
   * `1.3.132.0.4`: SECG (Certicom) named elliptic curve
   */
  public val sect113r1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 132 0 4"
      )

  /**
   * `1.3.132.0.5`: SECG (Certicom) named elliptic curve
   */
  public val sect113r2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 132 0 5"
      )

  /**
   * `1.3.132.0.22`: SECG (Certicom) named elliptic curve
   */
  public val sect131r1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 132 0 22"
      )

  /**
   * `1.3.132.0.23`: SECG (Certicom) named elliptic curve
   */
  public val sect131r2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 132 0 23"
      )

  /**
   * `1.3.132.0.1`: SECG (Certicom) named elliptic curve
   */
  public val sect163k1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 132 0 1"
      )

  /**
   * `1.3.132.0.2`: SECG (Certicom) named elliptic curve
   */
  public val sect163r1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 132 0 2"
      )

  /**
   * `1.3.132.0.15`: SECG (Certicom) named elliptic curve
   */
  public val sect163r2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 132 0 15"
      )

  /**
   * `1.3.132.0.24`: SECG (Certicom) named elliptic curve
   */
  public val sect193r1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 132 0 24"
      )

  /**
   * `1.3.132.0.25`: SECG (Certicom) named elliptic curve
   */
  public val sect193r2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 132 0 25"
      )

  /**
   * `1.3.132.0.26`: SECG (Certicom) named elliptic curve
   */
  public val sect233k1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 132 0 26"
      )

  /**
   * `1.3.132.0.27`: SECG (Certicom) named elliptic curve
   */
  public val sect233r1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 132 0 27"
      )

  /**
   * `1.3.132.0.3`: SECG (Certicom) named elliptic curve
   */
  public val sect239k1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 132 0 3"
      )

  /**
   * `1.3.132.0.16`: SECG (Certicom) named elliptic curve
   */
  public val sect283k1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 132 0 16"
      )

  /**
   * `1.3.132.0.17`: SECG (Certicom) named elliptic curve
   */
  public val sect283r1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 132 0 17"
      )

  /**
   * `1.3.132.0.36`: SECG (Certicom) named elliptic curve
   */
  public val sect409k1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 132 0 36"
      )

  /**
   * `1.3.132.0.37`: SECG (Certicom) named elliptic curve
   */
  public val sect409r1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 132 0 37"
      )

  /**
   * `1.3.132.0.38`: SECG (Certicom) named elliptic curve
   */
  public val sect571k1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 132 0 38"
      )

  /**
   * `1.3.132.0.39`: SECG (Certicom) named elliptic curve
   */
  public val sect571r1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 132 0 39"
      )

  /**
   * `1.2.840.113549.1.9.16.2.55`: S/MIME Authenticated Attributes
   */
  public val secureHeaderFieldsIdentifier: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 55"
      )

  /**
   * `1.3.6.1.5.5.7.3.21`: PKIX key purpose
   */
  public val secureShellClient: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 3 21"
      )

  /**
   * `1.3.6.1.5.5.7.3.22`: PKIX key purpose
   */
  public val secureShellServer: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 3 22"
      )

  /**
   * `0.2.262.1.10.11.1`: Telesec SNMP MIBs
   */
  public val securityApplication: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 11 1"
      )

  /**
   * `2.16.840.1.113719.1.9.4.1`: Novell PKI attribute type
   */
  public val securityAttributes: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113719 1 9 4 1"
      )

  /**
   * `0.2.262.1.10.7.9`: Telesec attribute
   */
  public val securityDomain: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 7 9"
      )

  /**
   * `1.2.840.113549.1.9.16.2.2`: S/MIME Authenticated Attributes
   */
  public val securityLabel: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 2"
      )

  /**
   * `0.2.262.1.10.7.15`: Telesec attribute
   */
  public val securityMessEnv: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 7 15"
      )

  /**
   * `1.3.36.2.1`: Teletrust sio
   */
  public val sedu: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 2 1"
      )

  /**
   * `2.5.4.34`: X.520 DN component
   */
  public val seeAlso: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 34"
      )

  /**
   * `1.2.410.200004.1.4`: Korean SEED algorithm, CBC mode
   */
  public val seedCBC: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200004 1 4"
      )

  /**
   * `1.2.410.200004.1.6`: Korean SEED algorithm, CFB mode
   */
  public val seedCFB: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200004 1 6"
      )

  /**
   * `1.2.410.200004.1.3`: Korean SEED algorithm, ECB mode
   */
  public val seedECB: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200004 1 3"
      )

  /**
   * `1.2.410.200004.1.7`: Korean SEED algorithm, MAC mode
   */
  public val seedMAC: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200004 1 7"
      )

  /**
   * `1.2.410.200004.1.5`: Korean SEED algorithm, OFB mode
   */
  public val seedOFB: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 410 200004 1 5"
      )

  /**
   * `1.2.752.34.1`: SEIS Project
   */
  public val seis_cp: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 752 34 1"
      )

  /**
   * `1.3.6.1.5.5.7.3.25`: PKIX key purpose
   */
  public val sendOwner: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 3 25"
      )

  /**
   * `1.3.6.1.5.5.7.3.26`: PKIX key purpose
   */
  public val sendProxiedOwner: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 3 26"
      )

  /**
   * `1.3.6.1.5.5.7.3.24`: PKIX key purpose
   */
  public val sendProxiedRouter: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 3 24"
      )

  /**
   * `1.3.6.1.5.5.7.3.23`: PKIX key purpose
   */
  public val sendRouter: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 3 23"
      )

  /**
   * `2.16.840.1.113733.1.9.5`: Verisign PKCS #7 attribute
   */
  public val senderNonce: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113733 1 9 5"
      )

  /**
   * `2.16.840.1.101.2.1.5.28`: SDN.700 INFOSEC attributes
   */
  public val sepUKMs: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 5 28"
      )

  /**
   * `1.2.840.113549.1.9.25.4`: PKCS #9/RFC 2985 attribute
   */
  public val sequenceNumber: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 25 4"
      )

  /**
   * `2.5.4.5`: X.520 DN component
   */
  public val serialNumber: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 5"
      )

  /**
   * `1.3.6.1.4.1.311.10.3.3.1`: Microsoft
   */
  public val serialized: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 10 3 3 1"
      )

  /**
   * `1.3.6.1.4.1.11591.13.2`: GNU encryption algorithm
   */
  public val serpent: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 11591 13 2"
      )

  /**
   * `1.3.6.1.4.1.11591.13.2.2`: GNU encryption algorithm
   */
  public val serpent128_CBC: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 11591 13 2 2"
      )

  /**
   * `1.3.6.1.4.1.11591.13.2.4`: GNU encryption algorithm
   */
  public val serpent128_CFB: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 11591 13 2 4"
      )

  /**
   * `1.3.6.1.4.1.11591.13.2.1`: GNU encryption algorithm
   */
  public val serpent128_ECB: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 11591 13 2 1"
      )

  /**
   * `1.3.6.1.4.1.11591.13.2.3`: GNU encryption algorithm
   */
  public val serpent128_OFB: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 11591 13 2 3"
      )

  /**
   * `1.3.6.1.4.1.11591.13.2.22`: GNU encryption algorithm
   */
  public val serpent192_CBC: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 11591 13 2 22"
      )

  /**
   * `1.3.6.1.4.1.11591.13.2.24`: GNU encryption algorithm
   */
  public val serpent192_CFB: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 11591 13 2 24"
      )

  /**
   * `1.3.6.1.4.1.11591.13.2.21`: GNU encryption algorithm
   */
  public val serpent192_ECB: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 11591 13 2 21"
      )

  /**
   * `1.3.6.1.4.1.11591.13.2.23`: GNU encryption algorithm
   */
  public val serpent192_OFB: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 11591 13 2 23"
      )

  /**
   * `1.3.6.1.4.1.11591.13.2.42`: GNU encryption algorithm
   */
  public val serpent256_CBC: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 11591 13 2 42"
      )

  /**
   * `1.3.6.1.4.1.11591.13.2.44`: GNU encryption algorithm
   */
  public val serpent256_CFB: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 11591 13 2 44"
      )

  /**
   * `1.3.6.1.4.1.11591.13.2.41`: GNU encryption algorithm
   */
  public val serpent256_ECB: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 11591 13 2 41"
      )

  /**
   * `1.3.6.1.4.1.11591.13.2.43`: GNU encryption algorithm
   */
  public val serpent256_OFB: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 11591 13 2 43"
      )

  /**
   * `1.3.6.1.5.5.7.3.1`: PKIX key purpose
   */
  public val serverAuth: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 3 1"
      )

  /**
   * `1.3.6.1.4.1.311.10.3.3`: Microsoft extended key usage
   */
  public val serverGatedCrypto: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 10 3 3"
      )

  /**
   * `2.16.840.1.113730.4.1`: Netscape
   */
  public val serverGatedCrypto_2_16_840_1_113730_4_1: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113730 4 1"
      )

  /**
   * `2.23.42.7.5`: SET cert extension
   */
  public val setExtensions: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 7 5"
      )

  /**
   * `1.2.840.113549.1.9.16.2.53`: S/MIME Authenticated Attributes
   */
  public val setKeyInformation: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 53"
      )

  /**
   * `2.23.42.7.6`: SET cert extension
   */
  public val setQualifier: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 7 6"
      )

  /**
   * `1.3.14.2.26.5`: Unsure about this OID
   */
  public val sha: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 14 2 26 5"
      )

  /**
   * `1.3.14.3.2.26`: OIW
   */
  public val sha1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 14 3 2 26"
      )

  /**
   * `1.2.840.113549.1.1.5`: PKCS #1
   */
  public val sha1WithRSAEncryption: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 1 5"
      )

  /**
   * `2.16.840.1.113719.1.2.8.31`: Novell signature algorithm
   */
  public val sha1WithRSAEncryptionBSafe1: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113719 1 2 8 31"
      )

  /**
   * `1.2.840.113549.1.1.14`: PKCS #1
   */
  public val sha224WithRSAEncryption: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 1 14"
      )

  /**
   * `1.2.840.113549.1.1.11`: PKCS #1
   */
  public val sha256WithRSAEncryption: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 1 11"
      )

  /**
   * `1.2.840.113549.1.1.12`: PKCS #1
   */
  public val sha384WithRSAEncryption: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 1 12"
      )

  /**
   * `2.16.840.1.101.3.4.2.7`: NIST Algorithm
   */
  public val sha3_224: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 4 2 7"
      )

  /**
   * `2.16.840.1.101.3.4.2.8`: NIST Algorithm
   */
  public val sha3_256: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 4 2 8"
      )

  /**
   * `2.16.840.1.101.3.4.2.9`: NIST Algorithm
   */
  public val sha3_384: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 4 2 9"
      )

  /**
   * `2.16.840.1.101.3.4.2.10`: NIST Algorithm
   */
  public val sha3_512: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 4 2 10"
      )

  /**
   * `1.2.840.113549.1.1.13`: PKCS #1
   */
  public val sha512WithRSAEncryption: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 1 13"
      )

  /**
   * `1.3.14.3.2.15`: Oddball OIW OID using 9796-2 padding rules
   */
  public val shaWithRSASignature: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 14 3 2 15"
      )

  /**
   * `2.16.840.1.113719.1.2.8.82`: Novell digest algorithm
   */
  public val sha_1: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113719 1 2 8 82"
      )

  /**
   * `1.3.14.3.2.29`: Oddball OIW OID
   */
  public val sha_1WithRSAEncryption: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 14 3 2 29"
      )

  /**
   * `1.3.14.3.2.18`: Oddball OIW OID
   */
  public val sha_1_3_14_3_2_18: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 14 3 2 18"
      )

  /**
   * `2.16.840.1.101.3.4.2.4`: NIST Algorithm
   */
  public val sha_224: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 4 2 4"
      )

  /**
   * `2.16.840.1.101.3.4.2.1`: NIST Algorithm
   */
  public val sha_256: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 4 2 1"
      )

  /**
   * `2.16.840.1.101.3.4.2.2`: NIST Algorithm
   */
  public val sha_384: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 4 2 2"
      )

  /**
   * `2.16.840.1.101.3.4.2.3`: NIST Algorithm
   */
  public val sha_512: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 4 2 3"
      )

  /**
   * `2.16.840.1.101.3.4.2.11`: NIST Algorithm
   */
  public val shake128: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 4 2 11"
      )

  /**
   * `2.16.840.1.101.3.4.2.17`: NIST Algorithm
   */
  public val shake128len: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 4 2 17"
      )

  /**
   * `2.16.840.1.101.3.4.2.12`: NIST Algorithm
   */
  public val shake256: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 4 2 12"
      )

  /**
   * `2.16.840.1.101.3.4.2.18`: NIST Algorithm
   */
  public val shake256len: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 4 2 18"
      )

  /**
   * `2.16.840.1.101.2.1.3.10.6`: SDN.700 INFOSEC policy (obsolete)
   */
  public val siBYEMAN: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 3 10 6"
      )

  /**
   * `2.16.840.1.101.2.1.3.10.5`: SDN.700 INFOSEC policy (obsolete)
   */
  public val siDNASP: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 3 10 5"
      )

  /**
   * `2.16.840.1.101.2.1.3.10.3`: SDN.700 INFOSEC policy (obsolete)
   */
  public val siDSAP: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 3 10 3"
      )

  /**
   * `2.16.840.1.101.2.1.3.10.1`: SDN.700 INFOSEC policy (obsolete)
   */
  public val siELCO: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 3 10 1"
      )

  /**
   * `2.16.840.1.101.2.1.3.10.12`: SDN.700 INFOSEC policy (obsolete)
   */
  public val siGeneric: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 3 10 12"
      )

  /**
   * `2.16.840.1.101.2.1.3.10.0`: SDN.700 INFOSEC policy (obsolete)
   */
  public val siNASP: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 3 10 0"
      )

  /**
   * `2.16.840.1.101.2.1.3.10.8`: SDN.700 INFOSEC policy (obsolete)
   */
  public val siREL_AUS: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 3 10 8"
      )

  /**
   * `2.16.840.1.101.2.1.3.10.9`: SDN.700 INFOSEC policy (obsolete)
   */
  public val siREL_CAN: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 3 10 9"
      )

  /**
   * `2.16.840.1.101.2.1.3.10.11`: SDN.700 INFOSEC policy (obsolete)
   */
  public val siREL_NZ: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 3 10 11"
      )

  /**
   * `2.16.840.1.101.2.1.3.10.10`: SDN.700 INFOSEC policy (obsolete)
   */
  public val siREL_UK: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 3 10 10"
      )

  /**
   * `2.16.840.1.101.2.1.3.10.7`: SDN.700 INFOSEC policy (obsolete)
   */
  public val siREL_US: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 3 10 7"
      )

  /**
   * `2.16.840.1.101.2.1.3.10.4`: SDN.700 INFOSEC policy (obsolete)
   */
  public val siSSSS: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 3 10 4"
      )

  /**
   * `2.16.840.1.101.2.1.3.10`: SDN.700 INFOSEC policy
   */
  public val siSecurityPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 3 10"
      )

  /**
   * `2.16.840.1.101.2.1.3.10.2`: SDN.700 INFOSEC policy (obsolete)
   */
  public val siTK: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 3 10 2"
      )

  /**
   * `1.3.36.8.6.9`: Teletrust signature attributes
   */
  public val sigNumber: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 6 9"
      )

  /**
   * `2.16.840.1.101.2.1.5.55`: SDN.700 INFOSEC attributes
   */
  public val sigOrKMPrivileges: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 5 55"
      )

  /**
   * `1.2.840.113549.1.9.16.2.15`: S/MIME Authenticated Attributes
   */
  public val sigPolicyId: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 15"
      )

  /**
   * `1.2.840.113549.1.9.16.5.2`: S/MIME Signature Policy Qualifiers
   */
  public val sigPolicyQualifier_spUserNotice: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 5 2"
      )

  /**
   * `1.2.840.113549.1.9.16.5.1`: S/MIME Signature Policy Qualifiers
   */
  public val sigPolicyQualifier_spuri_x: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 5 1"
      )

  /**
   * `2.16.840.1.101.2.1.10.1`: SDN.700 INFOSEC privileges
   */
  public val sigPrivileges: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 10 1"
      )

  /**
   * `1.3.36.3.4.1`: Teletrust signature scheme
   */
  public val sigS_ISO9796_1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 4 1"
      )

  /**
   * `1.3.36.3.4.2`: Teletrust signature scheme
   */
  public val sigS_ISO9796_2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 4 2"
      )

  /**
   * `1.3.36.3.4.2.1`: Teletrust signature scheme. Unsure what this is supposed to be
   */
  public val sigS_ISO9796_2Withred: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 4 2 1"
      )

  /**
   * `1.3.36.3.4.2.3`: Teletrust signature scheme. 9796-2 with random number in padding field
   */
  public val sigS_ISO9796_2Withrnd: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 4 2 3"
      )

  /**
   * `1.3.36.3.4.2.2`: Teletrust signature scheme. Unsure what this is supposed to be
   */
  public val sigS_ISO9796_2Withrsa: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 4 2 2"
      )

  /**
   * `1.3.6.1.5.5.7.4.2`: PKIX CMP information
   */
  public val signKeyPairTypes: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 4 2"
      )

  /**
   * `0.2.262.1.10.1.1`: Telesec mechanism
   */
  public val signature: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 1 1"
      )

  /**
   * `1.3.36.3.3`: Teletrust algorithm
   */
  public val signatureAlgorithm: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 3"
      )

  /**
   * `1.3.36.3.4`: Teletrust algorithm
   */
  public val signatureScheme: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 3 4"
      )

  /**
   * `1.2.840.113549.1.9.16.2.28`: S/MIME Authenticated Attributes
   */
  public val signatureType: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 28"
      )

  /**
   * `1.2.840.113549.1.9.16.9`: S/MIME
   */
  public val signatureTypeIdentifier: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 9"
      )

  /**
   * `1.2.840.113549.1.7.4`: PKCS #7
   */
  public val signedAndEnvelopedData: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 7 4"
      )

  /**
   * `1.2.840.113549.1.7.2`: PKCS #7
   */
  public val signedData: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 7 2"
      )

  /**
   * `1.2.840.113549.1.9.16.10.2`: S/MIME X.400 Encoded Information Types
   */
  public val signedData_1_2_840_113549_1_9_16_10_2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 10 2"
      )

  /**
   * `1.3.6.1.4.1.3576.7.2`: TMN EDI for Interactive Agents
   */
  public val signedEDImessage: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 3576 7 2"
      )

  /**
   * `1.3.6.1.5.5.7.48.11`: PKIX subject/authority info access descriptor
   */
  public val signedObject: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 48 11"
      )

  /**
   * `1.3.6.1.5.5.7.48.7`: PKIX subject/authority info access descriptor
   */
  public val signedObjectRepository: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 48 7"
      )

  /**
   * `1.2.840.113549.1.9.16.10.4`: S/MIME X.400 Encoded Information Types
   */
  public val signedReceipt: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 10 4"
      )

  /**
   * `1.2.840.113549.1.9.16.10.6`: S/MIME X.400 Encoded Information Types
   */
  public val signedX400: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 10 6"
      )

  /**
   * `1.2.840.113549.1.9.16.2.18`: S/MIME Authenticated Attributes
   */
  public val signerAttr: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 18"
      )

  /**
   * `1.2.840.113549.1.9.16.2.17`: S/MIME Authenticated Attributes
   */
  public val signerLocation: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 17"
      )

  /**
   * `1.2.36.68980861.1.1.3`: Signet CA
   */
  public val signetBusiness: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 68980861 1 1 3"
      )

  /**
   * `1.2.36.68980861.1.1.11`: Signet CA
   */
  public val signetIntraNet: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 68980861 1 1 11"
      )

  /**
   * `1.2.36.68980861.1.1.4`: Signet CA
   */
  public val signetLegal: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 68980861 1 1 4"
      )

  /**
   * `1.2.36.68980861.1.1.2`: Signet CA
   */
  public val signetPersonal: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 68980861 1 1 2"
      )

  /**
   * `1.2.36.68980861.1.1.10`: Signet CA
   */
  public val signetPilot: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 68980861 1 1 10"
      )

  /**
   * `1.2.36.68980861.1.1.20`: Signet CA
   */
  public val signetPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 36 68980861 1 1 20"
      )

  /**
   * `1.2.840.113549.1.9.16.2.12`: S/MIME Authenticated Attributes
   */
  public val signingCertificate: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 12"
      )

  /**
   * `1.2.840.113549.1.9.16.2.47`: S/MIME Authenticated Attributes
   */
  public val signingCertificateV2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 47"
      )

  /**
   * `1.2.840.113549.1.9.13`: PKCS #9
   */
  public val signingDescription: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 13"
      )

  /**
   * `1.2.840.113549.1.9.5`: PKCS #9
   */
  public val signingTime: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 5"
      )

  /**
   * `1.3.14.3.3.1`: Oddball OIW OID
   */
  public val simple_strong_auth_mechanism: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 14 3 3 1"
      )

  /**
   * `2.5.29.65`: X.509 extension
   */
  public val singleUse: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 65"
      )

  /**
   * `1.3.36.2`: Teletrust sio
   */
  public val sio: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 2"
      )

  /**
   * `1.3.6.1.5.5.7.3.20`: PKIX key purpose
   */
  public val sipDomain: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 3 20"
      )

  /**
   * `1.2.840.113556.1.3.0`: Microsoft Exchange Server - object class
   */
  public val site_Addressing: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113556 1 3 0"
      )

  /**
   * `1.3.6.1.5.5.7.1.22`: PKIX private extension
   */
  public val skiSemantics: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 1 22"
      )

  /**
   * `2.16.840.1.101.3.1`: CSOR GAK
   */
  public val slabel: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 3 1"
      )

  /**
   * `1.2.156.10197.1.102`: China GM Standards Committee
   */
  public val sm1Cipher: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 156 10197 1 102"
      )

  /**
   * `1.2.156.10197.1.301`: China GM Standards Committee
   */
  public val sm2ECC: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 156 10197 1 301"
      )

  /**
   * `1.2.156.10197.6.1.1.3`: China GM Standards Committee
   */
  public val sm2Standard: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 156 10197 6 1 1 3"
      )

  /**
   * `1.2.156.10197.1.301.1`: China GM Standards Committee
   */
  public val sm2_1DigitalSignature: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 156 10197 1 301 1"
      )

  /**
   * `1.2.156.10197.1.301.2`: China GM Standards Committee
   */
  public val sm2_2KeyExchange: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 156 10197 1 301 2"
      )

  /**
   * `1.2.156.10197.1.301.3`: China GM Standards Committee
   */
  public val sm2_3PublicKeyEncryption: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 156 10197 1 301 3"
      )

  /**
   * `1.2.156.10197.1.501`: China GM Standards Committee
   */
  public val sm2withSM3: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 156 10197 1 501"
      )

  /**
   * `1.2.156.10197.1.401`: China GM Standards Committee
   */
  public val sm3Hash: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 156 10197 1 401"
      )

  /**
   * `1.2.156.10197.1.401.2`: China GM Standards Committee
   */
  public val sm3HashWithKey: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 156 10197 1 401 2"
      )

  /**
   * `1.2.156.10197.1.401.1`: China GM Standards Committee
   */
  public val sm3HashWithoutKey: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 156 10197 1 401 1"
      )

  /**
   * `1.2.156.10197.6.1.1.4`: China GM Standards Committee
   */
  public val sm3Standard: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 156 10197 6 1 1 4"
      )

  /**
   * `1.2.156.10197.1.104`: China GM Standards Committee
   */
  public val sm4Cipher: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 156 10197 1 104"
      )

  /**
   * `1.2.156.10197.6.1.1.2`: China GM Standards Committee
   */
  public val sm4Standard: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 156 10197 6 1 1 2"
      )

  /**
   * `1.2.156.10197.1.302.1`: China GM Standards Committee
   */
  public val sm9_1DigitalSignature: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 156 10197 1 302 1"
      )

  /**
   * `1.2.156.10197.1.302.2`: China GM Standards Committee
   */
  public val sm9_2KeyExchange: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 156 10197 1 302 2"
      )

  /**
   * `1.2.156.10197.1.302.3`: China GM Standards Committee
   */
  public val sm9_3PublicKeyEncryption: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 156 10197 1 302 3"
      )

  /**
   * `1.3.6.1.4.1.311.10.3.15`: Microsoft extended key usage
   */
  public val smartDisplay: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 10 3 15"
      )

  /**
   * `1.3.6.1.4.1.311.20.2.2`: Microsoft extended key usage
   */
  public val smartcardLogon: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 20 2 2"
      )

  /**
   * `0.2.262.1.10.2.5`: Telesec module
   */
  public val smeAndComponentsOfSme: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 2 5"
      )

  /**
   * `1.2.840.113549.1.9.16.2.13`: S/MIME Authenticated Attributes
   */
  public val smimeEncryptCerts: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 13"
      )

  /**
   * `1.3.6.1.5.5.7.8.9`: PKIX other name
   */
  public val smtpUTF8Mailbox: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 8 9"
      )

  /**
   * `0.2.262.1.10.11`: Telesec
   */
  public val snmp_mibs: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 11"
      )

  /**
   * `1.3.6.1.4.1.311.10.1.1`: Microsoft contentType
   */
  public val sortedCtl: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 10 1 1"
      )

  /**
   * `1.3.6.1.4.1.311.2.1.10`: Microsoft code signing. Also assigned as policyLink
   */
  public val spcAgencyInfo: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 2 1 10"
      )

  /**
   * `1.3.6.1.4.1.311.2.1.27`: Microsoft code signing
   */
  public val spcFinancialCriteriaInfo: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 2 1 27"
      )

  /**
   * `1.3.6.1.4.1.311.2.1.29`: Microsoft code signing
   */
  public val spcHashInfoObjID: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 2 1 29"
      )

  /**
   * `1.3.6.1.4.1.311.2.1.4`: Microsoft code signing
   */
  public val spcIndirectDataContext: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 2 1 4"
      )

  /**
   * `1.3.6.1.4.1.311.2.1.20`: Microsoft code signing. Formerly "link extension" aka "glue
   * extension"
   */
  public val spcJavaClassData_type_1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 2 1 20"
      )

  /**
   * `1.3.6.1.4.1.311.2.1.25`: Microsoft code signing. Also assigned as "glue extension"
   */
  public val spcLink_type_2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 2 1 25"
      )

  /**
   * `1.3.6.1.4.1.311.2.1.28`: Microsoft code signing.  Also assigned as "glue extension"
   */
  public val spcLink_type_3: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 2 1 28"
      )

  /**
   * `1.3.6.1.4.1.311.2.1.26`: Microsoft code signing
   */
  public val spcMinimalCriteriaInfo: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 2 1 26"
      )

  /**
   * `1.3.6.1.4.1.311.2.1.15`: Microsoft code signing
   */
  public val spcPEImageData: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 2 1 15"
      )

  /**
   * `1.3.6.1.4.1.311.2.1.18`: Microsoft code signing
   */
  public val spcRawFileData: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 2 1 18"
      )

  /**
   * `1.3.6.1.4.1.311.2.1.30`: Microsoft code signing
   */
  public val spcSipInfoObjID: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 2 1 30"
      )

  /**
   * `1.3.6.1.4.1.311.2.1.12`: Microsoft code signing
   */
  public val spcSpOpusInfo: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 2 1 12"
      )

  /**
   * `1.3.6.1.4.1.311.2.1.11`: Microsoft code signing
   */
  public val spcStatementType: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 2 1 11"
      )

  /**
   * `1.3.6.1.4.1.311.2.1.19`: Microsoft code signing
   */
  public val spcStructuredStorageData: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 2 1 19"
      )

  /**
   * `0.2.262.1.10.1.3.4`: Telesec one-way function
   */
  public val sqModNISO: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 1 3 4"
      )

  /**
   * `0.2.262.1.10.1.3.3`: Telesec one-way function
   */
  public val sqModNX509: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 1 3 3"
      )

  /**
   * `1.3.14.3.2.2.1`: X.509. Deprecated
   */
  public val sqmod_N: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 14 3 2 2 1"
      )

  /**
   * `1.3.14.3.2.3.1`: X.509. Deprecated
   */
  public val sqmod_NwithRSA: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 14 3 2 3 1"
      )

  /**
   * `1.2.840.113549.1.9.16.3.10`: S/MIME Algorithms
   */
  public val ssDH: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 3 10"
      )

  /**
   * `1.2.156.10197.1.103`: China GM Standards Committee
   */
  public val ssf33Cipher: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 156 10197 1 103"
      )

  /**
   * `2.16.578.1.26.1.3.4`: Norway Buypass CA policy
   */
  public val sslBusinessPlus: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 578 1 26 1 3 4"
      )

  /**
   * `2.16.578.1.26.1.3.3`: Norway Buypass CA policy
   */
  public val sslEvident: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 578 1 26 1 3 3"
      )

  /**
   * `2.16.840.1.101.2.1.8.2`: SDN.700 INFOSEC security category
   */
  public val standardSecurityLabelPrivileges: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 8 2"
      )

  /**
   * `2.5.4.8`: X.520 DN component
   */
  public val stateOrProvinceName: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 8"
      )

  /**
   * `2.5.29.45`: X.509 extension
   */
  public val statusReferrals: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 45"
      )

  /**
   * `0.2.262.1.10.2.8`: Telesec module
   */
  public val stefiles: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 2 8"
      )

  /**
   * `1.3.36.8.3.11.1.5`: Teletrust ProfessionInfo
   */
  public val steuerBerater: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 3 11 1 5"
      )

  /**
   * `1.3.36.8.3.11.1.4`: Teletrust ProfessionInfo
   */
  public val steuerBeraterin: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 3 11 1 4"
      )

  /**
   * `1.3.36.8.3.11.1.6`: Teletrust ProfessionInfo
   */
  public val steuerBevollmaechtigte: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 3 11 1 6"
      )

  /**
   * `1.3.36.8.3.11.1.7`: Teletrust ProfessionInfo
   */
  public val steuerBevollmaechtigter: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 3 11 1 7"
      )

  /**
   * `1.3.36.8.6.6`: Teletrust signature attributes
   */
  public val storageTime: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 6 6"
      )

  /**
   * `2.5.4.9`: X.520 DN component
   */
  public val streetAddress: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 9"
      )

  /**
   * `2.5.6.15`: X.520 objectClass
   */
  public val strongAuthenticationUser: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 6 15"
      )

  /**
   * `1.3.101.1.4.1`: Thawte certificate extension
   */
  public val strongExtranet: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 101 1 4 1"
      )

  /**
   * `0.2.262.1.10.7.10`: Telesec attribute
   */
  public val subject: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 7 10"
      )

  /**
   * `2.5.29.7`: X.509 extension.  Deprecated, use 2 5 29 17 instead
   */
  public val subjectAltName: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 7"
      )

  /**
   * `2.5.29.17`: X.509 extension
   */
  public val subjectAltName_2_5_29_17: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 17"
      )

  /**
   * `2.5.29.9`: X.509 extension
   */
  public val subjectDirectoryAttributes: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 9"
      )

  /**
   * `2.23.140.1.2.2`: CAB Certificate Policies
   */
  public val subjectIdentityValidated: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 140 1 2 2"
      )

  /**
   * `1.3.6.1.5.5.7.1.11`: PKIX private extension
   */
  public val subjectInfoAccess: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 1 11"
      )

  /**
   * `2.5.29.14`: X.509 extension
   */
  public val subjectKeyIdentifier: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 14"
      )

  /**
   * `2.5.29.6`: X.509 extension.  Obsolete, use nameConstraints instead
   */
  public val subtreesConstraint: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 6"
      )

  /**
   * `2.16.840.1.101.2.1.1.14`: SDN.700 INFOSEC algorithms
   */
  public val suiteAConfidentialityAlgorithm: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 1 14"
      )

  /**
   * `2.16.840.1.101.2.1.1.15`: SDN.700 INFOSEC algorithms
   */
  public val suiteAIntegrityAlgorithm: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 1 15"
      )

  /**
   * `2.16.840.1.101.2.1.1.18`: SDN.700 INFOSEC algorithms
   */
  public val suiteAKMandSigAlgorithm: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 1 18"
      )

  /**
   * `2.16.840.1.101.2.1.5.51`: SDN.700 INFOSEC attributes (obsolete)
   */
  public val suiteAKMandSigCertificate: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 5 51"
      )

  /**
   * `2.16.840.1.101.2.1.1.17`: SDN.700 INFOSEC algorithms
   */
  public val suiteAKeyManagementAlgorithm: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 1 17"
      )

  /**
   * `2.16.840.1.101.2.1.5.50`: SDN.700 INFOSEC attributes (obsolete)
   */
  public val suiteAKeyManagementCertificate: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 5 50"
      )

  /**
   * `2.16.840.1.101.2.1.1.13`: SDN.700 INFOSEC algorithms
   */
  public val suiteASignatureAlgorithm: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 1 13"
      )

  /**
   * `2.16.840.1.101.2.1.1.16`: SDN.700 INFOSEC algorithms
   */
  public val suiteATokenProtectionAlgorithm: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 1 16"
      )

  /**
   * `2.16.840.1.101.2.1.5.52`: SDN.700 INFOSEC attributes (obsolete)
   */
  public val suiteAUserSignatureCertificate: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 5 52"
      )

  /**
   * `1.3.6.1.5.5.7.4.16`: PKIX CMP information
   */
  public val suppLangTags: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 4 16"
      )

  /**
   * `2.5.4.52`: X.520 DN component
   */
  public val supportedAlgorithms: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 52"
      )

  /**
   * `2.5.4.30`: X.520 DN component
   */
  public val supportedApplicationContext: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 30"
      )

  /**
   * `2.5.4.103`: X.520 DN component
   */
  public val supportedPublicKeyAlgorithms: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 103"
      )

  /**
   * `2.5.4.4`: X.520 DN component
   */
  public val surname: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 4"
      )

  /**
   * `0.2.262.1.10.3.5`: Telesec object class
   */
  public val symmetricKeyEntry: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 3 5"
      )

  /**
   * `0.2.262.1.10.7.35`: Telesec attribute
   */
  public val symmetricKeyEntryName: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 7 35"
      )

  /**
   * `1.2.840.113549.1.9.16.1.25`: S/MIME Content Types
   */
  public val symmetricKeyPackage: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 1 25"
      )

  /**
   * `1.3.6.1.4.1.311.47.1.1`: Microsoft extended key usage
   */
  public val systemHealth: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 47 1 1"
      )

  /**
   * `1.3.6.1.4.1.311.47.1.3`: Microsoft extended key usage
   */
  public val systemHealthLoophole: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 47 1 3"
      )

  /**
   * `1.2.840.113549.1.9.16.1.43`: S/MIME Content Types
   */
  public val sztpConveyedInfoJSON: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 1 43"
      )

  /**
   * `1.2.840.113549.1.9.16.1.42`: S/MIME Content Types
   */
  public val sztpConveyedInfoXML: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 1 42"
      )

  /**
   * `2.23.133`: TCPA/TCG
   */
  public val tCPA: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 133"
      )

  /**
   * `1.2.840.113549.1.9.16.1.5`: S/MIME Content Types
   */
  public val tDTInfo: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 1 5"
      )

  /**
   * `1.2.840.113549.1.9.16.1.15`: S/MIME Content Types
   */
  public val tSReq: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 1 15"
      )

  /**
   * `1.2.840.113549.1.9.16.1.4`: S/MIME Content Types
   */
  public val tSTInfo: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 1 4"
      )

  /**
   * `2.5.4.92`: X.520 DN component
   */
  public val tagAfi: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 92"
      )

  /**
   * `2.5.4.96`: X.520 DN component
   */
  public val tagLocation: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 96"
      )

  /**
   * `2.5.4.78`: X.520 DN component
   */
  public val tagOid: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 78"
      )

  /**
   * `2.5.29.55`: X.509 extension
   */
  public val targetInformation: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 55"
      )

  /**
   * `1.2.643.2.2.31.12`: TC26 params 2 for GOST 28147-89
   */
  public val tc26CipherA: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 2 2 31 12"
      )

  /**
   * `1.2.643.2.2.31.13`: TC26 params 1 for GOST 28147-89
   */
  public val tc26CipherB: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 2 2 31 13"
      )

  /**
   * `1.2.643.2.2.31.14`: TC26 params 3 for GOST 28147-89
   */
  public val tc26CipherC: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 2 2 31 14"
      )

  /**
   * `1.2.643.2.2.31.15`: TC26 params 4 for GOST 28147-89
   */
  public val tc26CipherD: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 2 2 31 15"
      )

  /**
   * `1.2.643.2.2.31.16`: TC26 params 5 for GOST 28147-89
   */
  public val tc26CipherE: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 2 2 31 16"
      )

  /**
   * `1.2.643.2.2.31.17`: TC26 params 6 for GOST 28147-89
   */
  public val tc26CipherF: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 2 2 31 17"
      )

  /**
   * `1.2.643.7.1.2.5.1.1`: TC26 params Z for GOST 28147-89
   */
  public val tc26CipherZ: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 7 1 2 5 1 1"
      )

  /**
   * `2.23.133.2`: TCPA/TCG
   */
  public val tcgAttribute: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 133 2"
      )

  /**
   * `2.23.133.2.7`: TCPA/TCG Attribute
   */
  public val tcgComponentManufacturer: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 133 2 7"
      )

  /**
   * `2.23.133.2.8`: TCPA/TCG Attribute
   */
  public val tcgComponentModel: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 133 2 8"
      )

  /**
   * `2.23.133.2.9`: TCPA/TCG Attribute
   */
  public val tcgComponentVersion: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 133 2 9"
      )

  /**
   * `2.23.133.8.1`: TCPA/TCG Key Usage
   */
  public val tcgEKCertificate: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 133 8 1"
      )

  /**
   * `2.23.133.2.13`: TCPA/TCG Attribute
   */
  public val tcgFoundationProtectionProfile: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 133 2 13"
      )

  /**
   * `2.23.133.2.14`: TCPA/TCG Attribute
   */
  public val tcgFoundationSecurityTarget: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 133 2 14"
      )

  /**
   * `2.23.133.10.1.1.1`: TCPA/TCG Object
   */
  public val tcgObject: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 133 10 1 1 1"
      )

  /**
   * `2.23.133.2.4`: TCPA/TCG Attribute
   */
  public val tcgPlatformManufacturer: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 133 2 4"
      )

  /**
   * `2.23.133.2.5`: TCPA/TCG Attribute
   */
  public val tcgPlatformModel: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 133 2 5"
      )

  /**
   * `2.23.133.2.6`: TCPA/TCG Attribute
   */
  public val tcgPlatformVersion: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 133 2 6"
      )

  /**
   * `2.23.133.3`: TCPA/TCG
   */
  public val tcgProtocol: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 133 3"
      )

  /**
   * `2.23.133.3.1`: TCPA/TCG Protocol
   */
  public val tcgPrttTpmIdProtocol: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 133 3 1"
      )

  /**
   * `2.23.133.2.10`: TCPA/TCG Attribute
   */
  public val tcgSecurityQualities: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 133 2 10"
      )

  /**
   * `2.23.133.1`: TCPA/TCG
   */
  public val tcgSpecVersion: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 133 1"
      )

  /**
   * `2.23.133.2.15`: TCPA/TCG Attribute
   */
  public val tcgTpmIdLabel: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 133 2 15"
      )

  /**
   * `2.23.133.2.1`: TCPA/TCG Attribute
   */
  public val tcgTpmManufacturer: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 133 2 1"
      )

  /**
   * `2.23.133.2.2`: TCPA/TCG Attribute
   */
  public val tcgTpmModel: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 133 2 2"
      )

  /**
   * `2.23.133.2.11`: TCPA/TCG Attribute
   */
  public val tcgTpmProtectionProfile: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 133 2 11"
      )

  /**
   * `2.23.133.2.18`: TCPA/TCG Attribute
   */
  public val tcgTpmSecurityAssertions: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 133 2 18"
      )

  /**
   * `2.23.133.2.12`: TCPA/TCG Attribute
   */
  public val tcgTpmSecurityTarget: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 133 2 12"
      )

  /**
   * `2.23.133.2.16`: TCPA/TCG Attribute
   */
  public val tcgTpmSpecification: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 133 2 16"
      )

  /**
   * `2.23.133.2.3`: TCPA/TCG Attribute
   */
  public val tcgTpmVersion: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 133 2 3"
      )

  /**
   * `2.16.840.1.101.2.1.12.1.1`: SDN.700 INFOSEC test objects
   */
  public val tcp1: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 12 1 1"
      )

  /**
   * `0.2.262.1.10.1.0.8`: Telesec authentication
   */
  public val telekomAuthentication: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 1 0 8"
      )

  /**
   * `2.23.42.2.9`: SET field
   */
  public val telephone: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 2 9"
      )

  /**
   * `2.5.4.20`: X.520 DN component
   */
  public val telephoneNumber: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 20"
      )

  /**
   * `0.2.262.1.10.12.5`: Telesec cert/CRL extension
   */
  public val telesecCRLFilterExt: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 12 5"
      )

  /**
   * `0.2.262.1.10.12.4`: Telesec cert/CRL extension
   */
  public val telesecCRLFilteredExt: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 12 4"
      )

  /**
   * `0.2.262.1.10.12.1`: Telesec cert/CRL extension
   */
  public val telesecCertIdExt: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 12 1"
      )

  /**
   * `0.2.262.1.10.7.2`: Telesec attribute
   */
  public val telesecCertificate: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 7 2"
      )

  /**
   * `0.2.262.1.10.7.21`: Telesec attribute
   */
  public val telesecCertificateList: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 7 21"
      )

  /**
   * `0.2.262.1.10.7.17`: Telesec attribute
   */
  public val telesecGivenName: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 7 17"
      )

  /**
   * `0.2.262.1.10.12.6`: Telesec cert/CRL extension
   */
  public val telesecNamingAuthorityExt: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 12 6"
      )

  /**
   * `0.2.262.1.10.3.0`: Telesec object class
   */
  public val telesecOtherName: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 3 0"
      )

  /**
   * `0.2.262.1.10.12.3`: Telesec cert/CRL extension
   */
  public val telesecPolicyQualifierID: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 12 3"
      )

  /**
   * `0.2.262.1.10.7.19`: Telesec attribute
   */
  public val telesecPostalCode: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 7 19"
      )

  /**
   * `0.2.262.1.10.2.11`: Telesec module
   */
  public val telesecTtpAsymmetricApplication: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 2 11"
      )

  /**
   * `0.2.262.1.10.2.12`: Telesec module
   */
  public val telesecTtpBasisApplication: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 2 12"
      )

  /**
   * `0.2.262.1.10.2.13`: Telesec module
   */
  public val telesecTtpMessages: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 2 13"
      )

  /**
   * `0.2.262.1.10.2.14`: Telesec module
   */
  public val telesecTtpTimeStampApplication: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 2 14"
      )

  /**
   * `2.5.4.22`: X.520 DN component
   */
  public val teletexTerminalIdentifier: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 22"
      )

  /**
   * `0.2.262.1.10.7.22`: Telesec attribute
   */
  public val teletrustCertificateList: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 7 22"
      )

  /**
   * `2.5.4.21`: X.520 DN component
   */
  public val telexNumber: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 21"
      )

  /**
   * `1.2.840.113549.1.9.16.7.1`: S/MIMETest Security Policies
   */
  public val testAmoco: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 7 1"
      )

  /**
   * `1.2.840.113549.1.9.16.7.2`: S/MIMETest Security Policies
   */
  public val testCaterpillar: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 7 2"
      )

  /**
   * `1.2.643.2.2.31.0`: Test params for GOST 28147-89
   */
  public val testCipherParams: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 2 2 31 0"
      )

  /**
   * `1.2.643.2.2.30.0`: Test params for GOST R 34.11-94
   */
  public val testDigestParams: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 2 2 30 0"
      )

  /**
   * `2.16.840.1.101.2.1.12.0`: SDN.700 INFOSEC test objects
   */
  public val testSecurityPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 12 0"
      )

  /**
   * `1.2.643.2.2.35.0`: Test elliptic curve for GOST R 34.10-2001
   */
  public val testSignParams: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 643 2 2 35 0"
      )

  /**
   * `1.2.840.113549.1.9.16.7.3`: S/MIMETest Security Policies
   */
  public val testWhirlpool: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 7 3"
      )

  /**
   * `1.2.840.113549.1.9.16.7.4`: S/MIMETest Security Policies
   */
  public val testWhirlpoolCategories: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 7 4"
      )

  /**
   * `1.3.6.1.5.5.7.2.3`: PKIX policy qualifier
   */
  public val textNotice: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 2 3"
      )

  /**
   * `1.3.101.1.4`: Thawte
   */
  public val thawte_ce: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 101 1 4"
      )

  /**
   * `0.2.262.1.10.1.0.5`: Telesec authentication
   */
  public val threeWayX509Authentication: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 1 0 5"
      )

  /**
   * `1.3.6.1.4.1.11591.12.2`: GNU digest algorithm
   */
  public val tiger: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 11591 12 2"
      )

  /**
   * `0.2.262.1.10.7.24`: Telesec attribute
   */
  public val timeOfIssue: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 7 24"
      )

  /**
   * `0.2.262.1.10.7.11`: Telesec attribute
   */
  public val timeOfRevocation: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 7 11"
      )

  /**
   * `0.2.262.1.10.7.51`: Telesec attribute
   */
  public val timeOfRevocationGen: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 7 51"
      )

  /**
   * `2.5.29.43`: X.509 extension
   */
  public val timeSpecification: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 43"
      )

  /**
   * `1.3.6.1.4.1.311.10.3.2`: Microsoft extended key usage
   */
  public val timeStampSigning: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 10 3 2"
      )

  /**
   * `1.2.840.113549.1.9.16.2.14`: S/MIME Authenticated Attributes
   */
  public val timeStampToken: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 2 14"
      )

  /**
   * `1.3.6.1.5.5.7.3.8`: PKIX key purpose
   */
  public val timeStamping: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 3 8"
      )

  /**
   * `1.3.6.1.5.5.7.48.3`: PKIX subject/authority info access descriptor
   */
  public val timeStamping_1_3_6_1_5_5_7_48_3: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 48 3"
      )

  /**
   * `1.3.6.1.4.1.5472`: enterprise
   */
  public val timeproof: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 5472"
      )

  /**
   * `1.3.6.1.4.1.311.3.2.1`: Microsoft code signing
   */
  public val timestampRequest: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 3 2 1"
      )

  /**
   * `1.2.840.113549.1.9.16.1.31`: S/MIME Content Types
   */
  public val timestampedData: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 1 31"
      )

  /**
   * `2.5.4.12`: X.520 DN component
   */
  public val title: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 12"
      )

  /**
   * `1.2.840.113556.4.4`: Microsoft
   */
  public val titledWithOID: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113556 4 4"
      )

  /**
   * `1.3.6.1.5.5.7.1.24`: PKIX private extension
   */
  public val tlsFeature: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 1 24"
      )

  /**
   * `1.3.6.1.5.5.7.1.26`: PKIX private extension
   */
  public val tnAuthList: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 1 26"
      )

  /**
   * `2.5.29.58`: X.509 extension
   */
  public val toBeRevoked: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 58"
      )

  /**
   * `2.5.6.0`: X.520 objectClass
   */
  public val top: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 6 0"
      )

  /**
   * `1.2.840.10045.1.2.3.2`: ANSI X9.62 field basis
   */
  public val tpBasis: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10045 1 2 3 2"
      )

  /**
   * `2.16.840.1.113733.1.9.7`: Verisign PKCS #7 attribute
   */
  public val transID: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113733 1 9 7"
      )

  /**
   * `1.2.840.113549.1.9.16.1.34`: S/MIME Content Types
   */
  public val trustAnchorList: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 1 34"
      )

  /**
   * `2.16.840.1.101.2.1.12.0.1`: SDN.700 INFOSEC test objects
   */
  public val tsp1: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 12 0 1"
      )

  /**
   * `2.16.840.1.101.2.1.12.0.1.0`: SDN.700 INFOSEC test objects
   */
  public val tsp1SecurityCategories: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 12 0 1 0"
      )

  /**
   * `2.16.840.1.101.2.1.12.0.1.0.1`: SDN.700 INFOSEC test objects
   */
  public val tsp1TagSetOne: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 12 0 1 0 1"
      )

  /**
   * `2.16.840.1.101.2.1.12.0.1.0.2`: SDN.700 INFOSEC test objects
   */
  public val tsp1TagSetTwo: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 12 0 1 0 2"
      )

  /**
   * `2.16.840.1.101.2.1.12.0.1.0.0`: SDN.700 INFOSEC test objects
   */
  public val tsp1TagSetZero: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 12 0 1 0 0"
      )

  /**
   * `2.16.840.1.101.2.1.12.0.2`: SDN.700 INFOSEC test objects
   */
  public val tsp2: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 12 0 2"
      )

  /**
   * `2.16.840.1.101.2.1.12.0.2.0`: SDN.700 INFOSEC test objects
   */
  public val tsp2SecurityCategories: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 12 0 2 0"
      )

  /**
   * `2.16.840.1.101.2.1.12.0.2.0.1`: SDN.700 INFOSEC test objects
   */
  public val tsp2TagSetOne: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 12 0 2 0 1"
      )

  /**
   * `2.16.840.1.101.2.1.12.0.2.0.2`: SDN.700 INFOSEC test objects
   */
  public val tsp2TagSetTwo: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 12 0 2 0 2"
      )

  /**
   * `2.16.840.1.101.2.1.12.0.2.0.0`: SDN.700 INFOSEC test objects
   */
  public val tsp2TagSetZero: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 12 0 2 0 0"
      )

  /**
   * `1.3.6.1.4.1.5472.1`: timeproof
   */
  public val tss: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 5472 1"
      )

  /**
   * `1.3.6.1.4.1.5472.1.2`: timeproof TSS
   */
  public val tss380: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 5472 1 2"
      )

  /**
   * `1.3.6.1.4.1.5472.1.3`: timeproof TSS
   */
  public val tss400: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 5472 1 3"
      )

  /**
   * `1.3.6.1.4.1.5472.1.1`: timeproof TSS
   */
  public val tss80: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 5472 1 1"
      )

  /**
   * `2.23.42.7.4`: SET cert extension
   */
  public val tunneling: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 7 4"
      )

  /**
   * `0.2.262.1.10.1.0.7`: Telesec authentication
   */
  public val twoWayISO9798Authentication: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 1 0 7"
      )

  /**
   * `0.2.262.1.10.1.0.4`: Telesec authentication
   */
  public val twoWayX509Authentication: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 1 0 4"
      )

  /**
   * `2.5.4.90`: X.520 DN component
   */
  public val uii: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 90"
      )

  /**
   * `2.5.4.79`: X.520 DN component
   */
  public val uiiFormat: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 79"
      )

  /**
   * `2.5.4.80`: X.520 DN component
   */
  public val uiiInUrh: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 80"
      )

  /**
   * `2.16.840.1.101.2.1.11.1`: SDN.700 INFOSEC certificate policy
   */
  public val ukDemo: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 11 1"
      )

  /**
   * `2.5.4.45`: X.520 DN component
   */
  public val uniqueIdentifier: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 45"
      )

  /**
   * `2.5.4.50`: X.520 DN component
   */
  public val uniqueMember: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 50"
      )

  /**
   * `1.3.6.1.5.5.7.2.2`: PKIX policy qualifier
   */
  public val unotice: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 2 2"
      )

  /**
   * `2.16.840.1.101.2.1.22.3`: RFC 7906 key attribute error codes
   */
  public val unrecognizedSecurityPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 22 3"
      )

  /**
   * `1.2.840.113549.1.9.8`: PKCS #9
   */
  public val unstructuredAddress: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 8"
      )

  /**
   * `1.2.840.113549.1.9.2`: PKCS #9
   */
  public val unstructuredName: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 2"
      )

  /**
   * `1.3.6.1.5.5.7.4.7`: PKIX CMP information
   */
  public val unsupportedOIDs: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 4 7"
      )

  /**
   * `2.5.4.83`: X.520 DN component
   */
  public val uri: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 83"
      )

  /**
   * `2.5.4.87`: X.520 DN component
   */
  public val url: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 87"
      )

  /**
   * `2.5.4.86`: X.520 DN component
   */
  public val urn: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 86"
      )

  /**
   * `2.5.4.89`: X.520 DN component
   */
  public val urnC: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 89"
      )

  /**
   * `2.16.840.1.101.2.1.11.2`: SDN.700 INFOSEC certificate policy
   */
  public val usDODClass2: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 11 2"
      )

  /**
   * `2.16.840.1.101.2.1.11.5`: SDN.700 INFOSEC certificate policy
   */
  public val usDODClass3: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 11 5"
      )

  /**
   * `2.16.840.1.101.2.1.11.4`: SDN.700 INFOSEC certificate policy
   */
  public val usDODClass4: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 11 4"
      )

  /**
   * `2.16.840.1.101.2.1.11.6`: SDN.700 INFOSEC certificate policy
   */
  public val usDODClass5: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 11 6"
      )

  /**
   * `2.16.840.1.101.2.1.11.3`: SDN.700 INFOSEC certificate policy
   */
  public val usMediumPilot: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 101 2 1 11 3"
      )

  /**
   * `0.2.262.1.10.2.7`: Telesec module
   */
  public val usefulDefinitions: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 2 7"
      )

  /**
   * `2.5.4.36`: X.520 DN component
   */
  public val userCertificate: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 36"
      )

  /**
   * `1.3.6.1.5.5.7.8.2`: PKIX other name
   */
  public val userGroup: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 8 2"
      )

  /**
   * `0.2.262.1.10.7.12`: Telesec attribute
   */
  public val userGroupReference: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 7 12"
      )

  /**
   * `0.9.2342.19200300.100.1.1`: Some oddball X.500 attribute collection
   */
  public val userID: ObjectIdentifier = 
      ObjectIdentifier(
      "0 9 2342 19200300 100 1 1"
      )

  /**
   * `2.5.29.49`: X.509 extension
   */
  public val userNotice: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 29 49"
      )

  /**
   * `2.16.840.1.113730.3.1.216`: Netscape LDAP definitions
   */
  public val userPKCS12: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113730 3 1 216"
      )

  /**
   * `2.5.4.35`: X.520 DN component
   */
  public val userPassword: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 35"
      )

  /**
   * `1.3.6.1.4.1.311.20.2.3`: Microsoft UPN
   */
  public val userPrincipalName: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 20 2 3"
      )

  /**
   * `2.5.4.85`: X.520 DN component
   */
  public val userPwd: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 85"
      )

  /**
   * `1.3.6.1.5.5.7.5.2`: PKIX CRMF registration
   */
  public val utf8Pairs: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 5 2"
      )

  /**
   * `1.3.6.1.5.5.7.5.2.1`: PKIX CRMF registration control
   */
  public val utf8Pairs_1_3_6_1_5_5_7_5_2_1: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 5 2 1"
      )

  /**
   * `1.2.840.113549.1.9.16.1.37`: S/MIME Content Types
   */
  public val utf8TextWithCRLF: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 1 37"
      )

  /**
   * `1.3.36.6.1.1`: Teletrust API
   */
  public val utimaco_api: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 6 1 1"
      )

  /**
   * `2.5.4.88`: X.520 DN component
   */
  public val utmCoordinates: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 88"
      )

  /**
   * `2.5.4.77`: X.520 DN component
   */
  public val uuidpair: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 77"
      )

  /**
   * `0.2.262.1.10.7.13`: Telesec attribute
   */
  public val validity: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 7 13"
      )

  /**
   * `1.3.6.1.4.1.8301.3.5.1`: TU Darmstadt ValidityModel
   */
  public val validityModelChain: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 8301 3 5 1"
      )

  /**
   * `1.3.6.1.4.1.8301.3.5.2`: ValidityModel
   */
  public val validityModelShell: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 8301 3 5 2"
      )

  /**
   * `2.23.42.9`: SET
   */
  public val vendor: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 42 9"
      )

  /**
   * `1.3.36.8.3.11.1.16`: Teletrust ProfessionInfo
   */
  public val vereidigteBuchprueferin: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 3 11 1 16"
      )

  /**
   * `1.3.36.8.3.11.1.17`: Teletrust ProfessionInfo
   */
  public val vereidigterBuchpruefer: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 3 11 1 17"
      )

  /**
   * `2.16.840.1.113733.1.7.1.1.1`: Verisign policy (obsolete)
   */
  public val verisignCPSv1notice: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113733 1 7 1 1 1"
      )

  /**
   * `2.16.840.1.113733.1.7.1.1.2`: Verisign policy (obsolete)
   */
  public val verisignCPSv1nsi: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113733 1 7 1 1 2"
      )

  /**
   * `2.16.840.1.113733.1.6.3`: Verisign extension
   */
  public val verisignCZAG: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113733 1 6 3"
      )

  /**
   * `2.16.840.1.113733.1.7.1.1`: Verisign policy
   */
  public val verisignCertPolicies95Qualifier1: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113733 1 7 1 1"
      )

  /**
   * `2.16.840.1.113733.1.8.1`: Verisign
   */
  public val verisignISSStrongCrypto: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113733 1 8 1"
      )

  /**
   * `2.16.840.1.113733.1.6.6`: Verisign extension
   */
  public val verisignInBox: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113733 1 6 6"
      )

  /**
   * `2.16.840.1.113733.1.6.11`: Verisign extension
   */
  public val verisignOnsiteJurisdictionHash: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113733 1 6 11"
      )

  /**
   * `2.16.840.1.113733.1.6.15`: Verisign extension
   */
  public val verisignServerID: ObjectIdentifier = 
      ObjectIdentifier(
      "2 16 840 1 113733 1 6 15"
      )

  /**
   * `2.23.43.1.4`: WAP WTLS
   */
  public val wTLS_ECC: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 43 1 4"
      )

  /**
   * `2.23.43.1.4.1`: WAP WTLS
   */
  public val wTLS_ECC_curve1: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 43 1 4 1"
      )

  /**
   * `2.23.43.1.4.6`: WAP WTLS
   */
  public val wTLS_ECC_curve6: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 43 1 4 6"
      )

  /**
   * `2.23.43.1.4.8`: WAP WTLS
   */
  public val wTLS_ECC_curve8: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 43 1 4 8"
      )

  /**
   * `2.23.43.1.4.9`: WAP WTLS
   */
  public val wTLS_ECC_curve9: ObjectIdentifier = 
      ObjectIdentifier(
      "2 23 43 1 4 9"
      )

  /**
   * `1.0.10118.3.0.55`: ISO 10118-3 hash function
   */
  public val whirlpool: ObjectIdentifier = 
      ObjectIdentifier(
      "1 0 10118 3 0 55"
      )

  /**
   * `1.3.6.1.4.1.311.10.3.5`: Microsoft extended key usage
   */
  public val whqlCrypto: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 10 3 5"
      )

  /**
   * `1.3.36.8.3.11.1.15`: Teletrust ProfessionInfo
   */
  public val wirtschaftsPruefer: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 3 11 1 15"
      )

  /**
   * `1.3.36.8.3.11.1.14`: Teletrust ProfessionInfo
   */
  public val wirtschaftsPrueferin: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 36 8 3 11 1 14"
      )

  /**
   * `1.3.6.1.5.5.7.1.13`: PKIX private extension
   */
  public val wlanSSID: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 1 13"
      )

  /**
   * `1.3.6.1.5.5.7.10.6`: PKIX attribute-certificate extension
   */
  public val wlanSSID_1_3_6_1_5_5_7_10_6: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 10 6"
      )

  /**
   * `1.3.6.1.4.1.6449.1.2.2.15`: WoTrust (Comodo) CA
   */
  public val wotrustPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 6449 1 2 2 15"
      )

  /**
   * `1.3.6.1.5.5.7.1.20`: PKIX private extension
   */
  public val wrappedApexContinKey: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 1 20"
      )

  /**
   * `1.3.6.1.5.5.7.5.1.8`: PKIX CRMF registration control
   */
  public val wtlsTemplate: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 5 1 8"
      )

  /**
   * `2.5.4.24`: X.520 DN component
   */
  public val x121Address: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 24"
      )

  /**
   * `0.2.262.1.10.7.23`: Telesec attribute
   */
  public val x509CertificateList: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 7 23"
      )

  /**
   * `1.2.840.113549.1.9.22.1`: PKCS #9 via PKCS #12
   */
  public val x509Certificate_for_PKCS_12: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 22 1"
      )

  /**
   * `1.2.840.113549.1.9.23.1`: PKCS #9 via PKCS #12
   */
  public val x509Crl_for_PKCS_12: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 23 1"
      )

  /**
   * `1.3.133.16.840.9.44`: X9.44
   */
  public val x944: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 133 16 840 9 44"
      )

  /**
   * `1.3.133.16.840.9.44.1`: X9.44
   */
  public val x944Components: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 133 16 840 9 44 1"
      )

  /**
   * `1.3.133.16.840.9.44.1.1`: X9.44
   */
  public val x944Kdf2: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 133 16 840 9 44 1 1"
      )

  /**
   * `1.3.133.16.840.9.44.1.2`: X9.44
   */
  public val x944Kdf3: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 133 16 840 9 44 1 2"
      )

  /**
   * `1.3.133.16.840.9.84`: X9.84
   */
  public val x984: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 133 16 840 9 84"
      )

  /**
   * `1.3.133.16.840.9.84.1`: X9.84
   */
  public val x984Biometric: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 133 16 840 9 84 1"
      )

  /**
   * `1.3.133.16.840.9.84.0.1`: X9.84 Module
   */
  public val x984Biometrics: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 133 16 840 9 84 0 1"
      )

  /**
   * `1.3.133.16.840.9.84.0.2`: X9.84 Module
   */
  public val x984CMS: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 133 16 840 9 84 0 2"
      )

  /**
   * `1.3.133.16.840.9.84.4.0`: X9.84 Format Owner
   */
  public val x984CbeffOwner: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 133 16 840 9 84 4 0"
      )

  /**
   * `1.3.133.16.840.9.84.4`: X9.84
   */
  public val x984FormatOwner: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 133 16 840 9 84 4"
      )

  /**
   * `1.3.133.16.840.9.84.4.1`: X9.84 Format Owner
   */
  public val x984IbiaOwner: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 133 16 840 9 84 4 1"
      )

  /**
   * `1.3.133.16.840.9.84.0.3`: X9.84 Module
   */
  public val x984Identifiers: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 133 16 840 9 84 0 3"
      )

  /**
   * `1.3.133.16.840.9.84.3`: X9.84
   */
  public val x984MatchingMethod: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 133 16 840 9 84 3"
      )

  /**
   * `1.3.133.16.840.9.84.0`: X9.84
   */
  public val x984Module: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 133 16 840 9 84 0"
      )

  /**
   * `1.2.840.10040.1.1`: ANSI X9.57 module
   */
  public val x9f1_cert_mgmt: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 10040 1 1"
      )

  /**
   * `2.5.4.75`: X.520 DN component
   */
  public val xMLPrivilegeInfo: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 75"
      )

  /**
   * `1.3.6.1.4.1.3029.88.89.90.90.89`: cryptlib certificate policy
   */
  public val xYZZY_policyIdentifier: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 3029 88 89 90 90 89"
      )

  /**
   * `1.2.840.113549.1.9.16.1.28`: S/MIME Content Types
   */
  public val xml: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 1 28"
      )

  /**
   * `2.5.4.76`: X.520 DN component
   */
  public val xmlPrivPolicy: ObjectIdentifier = 
      ObjectIdentifier(
      "2 5 4 76"
      )

  /**
   * `1.3.6.1.5.5.7.8.5`: PKIX other name
   */
  public val xmppAddr: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 5 5 7 8 5"
      )

  /**
   * `1.3.6.1.4.1.311.10.4.1`: Microsoft attribute
   */
  public val yesnoTrustAttr: ObjectIdentifier = 
      ObjectIdentifier(
      "1 3 6 1 4 1 311 10 4 1"
      )

  /**
   * `0.2.262.1.10.7.39`: Telesec attribute
   */
  public val zKeyData: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 7 39"
      )

  /**
   * `0.2.262.1.10.7.14`: Telesec attribute
   */
  public val zert93: ObjectIdentifier = 
      ObjectIdentifier(
      "0 2 262 1 10 7 14"
      )

  /**
   * `1.2.840.113549.1.9.16.3.8`: S/MIME Algorithms
   */
  public val zlib: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 840 113549 1 9 16 3 8"
      )

  /**
   * `1.2.156.10197.1.201`: China GM Standards Committee
   */
  public val zucCipher: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 156 10197 1 201"
      )

  /**
   * `1.2.156.10197.6.1.1.1`: China GM Standards Committee
   */
  public val zucStandard: ObjectIdentifier = 
      ObjectIdentifier(
      "1 2 156 10197 6 1 1 1"
      )
}
