package at.asitplus.wallet.lib.data.dif

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

/**
 * Data class for
 * [DIF Presentation Exchange v1.0.0](https://identity.foundation/presentation-exchange/spec/v1.0.0/#presentation-definition)
 */
@Serializable
data class Constraint(
    @SerialName("fields")
    val fields: Collection<ConstraintField>? = null,
    @SerialName("limit_disclosure")
    val limitDisclosure: RequirementEnum? = null,
    @SerialName("statuses")
    val statuses: ConstraintStatusHolder? = null,
    @SerialName("subject_is_issuer")
    val subjectIsIssuer: RequirementEnum? = null,
    @SerialName("is_holder")
    val isHolder: Collection<ConstraintHolder>? = null,
    @SerialName("same_subject")
    val sameSubject: Collection<ConstraintHolder>? = null,
)