package at.austriapro.utils;

import java.util.Locale;

import com.google.common.collect.HashBiMap;

/**
 * Created by Paul on 10.09.2015.
 */
public class ISO639Util {

  final static String NULL = null;

  final static String AAR = "AAR";
  final static String ABK = "ABK";
  final static String ACE = "ACE";
  final static String ACH = "ACH";
  final static String ADA = "ADA";
  final static String ADY = "ADY";
  final static String AFA = "AFA";
  final static String AFH = "AFH";
  final static String AFR = "AFR";
  final static String AIN = "AIN";
  final static String AKA = "AKA";
  final static String AKK = "AKK";
  final static String ALB = "ALB";
  final static String SQI = "SQI";
  final static String ALE = "ALE";
  final static String ALG = "ALG";
  final static String ALT = "ALT";
  final static String AMH = "AMH";
  final static String ANG = "ANG";
  final static String ANP = "ANP";
  final static String APA = "APA";
  final static String ARA = "ARA";
  final static String ARC = "ARC";
  final static String ARG = "ARG";
  final static String ARM = "ARM";
  final static String HYE = "HYE";
  final static String ARN = "ARN";
  final static String ARP = "ARP";
  final static String ART = "ART";
  final static String ARW = "ARW";
  final static String ASM = "ASM";
  final static String AST = "AST";
  final static String ATH = "ATH";
  final static String AUS = "AUS";
  final static String AVA = "AVA";
  final static String AVE = "AVE";
  final static String AWA = "AWA";
  final static String AYM = "AYM";
  final static String AZE = "AZE";
  final static String BAD = "BAD";
  final static String BAI = "BAI";
  final static String BAK = "BAK";
  final static String BAL = "BAL";
  final static String BAM = "BAM";
  final static String BAN = "BAN";
  final static String BAQ = "BAQ";
  final static String EUS = "EUS";
  final static String BAS = "BAS";
  final static String BAT = "BAT";
  final static String BEJ = "BEJ";
  final static String BEL = "BEL";
  final static String BEM = "BEM";
  final static String BEN = "BEN";
  final static String BER = "BER";
  final static String BHO = "BHO";
  final static String BIH = "BIH";
  final static String BIK = "BIK";
  final static String BIN = "BIN";
  final static String BIS = "BIS";
  final static String BLA = "BLA";
  final static String BNT = "BNT";
  final static String TIB = "TIB";
  final static String BOD = "BOD";
  final static String BOS = "BOS";
  final static String BRA = "BRA";
  final static String BRE = "BRE";
  final static String BTK = "BTK";
  final static String BUA = "BUA";
  final static String BUG = "BUG";
  final static String BUL = "BUL";
  final static String BUR = "BUR";
  final static String MYA = "MYA";
  final static String BYN = "BYN";
  final static String CAD = "CAD";
  final static String CAI = "CAI";
  final static String CAR = "CAR";
  final static String CAT = "CAT";
  final static String CAU = "CAU";
  final static String CEB = "CEB";
  final static String CEL = "CEL";
  final static String CZE = "CZE";
  final static String CES = "CES";
  final static String CHA = "CHA";
  final static String CHB = "CHB";
  final static String CHE = "CHE";
  final static String CHG = "CHG";
  final static String CHI = "CHI";
  final static String ZHO = "ZHO";
  final static String CHK = "CHK";
  final static String CHM = "CHM";
  final static String CHN = "CHN";
  final static String CHO = "CHO";
  final static String CHP = "CHP";
  final static String CHR = "CHR";
  final static String CHU = "CHU";
  final static String CHV = "CHV";
  final static String CHY = "CHY";
  final static String CMC = "CMC";
  final static String COP = "COP";
  final static String COR = "COR";
  final static String COS = "COS";
  final static String CPE = "CPE";
  final static String CPF = "CPF";
  final static String CPP = "CPP";
  final static String CRE = "CRE";
  final static String CRH = "CRH";
  final static String CRP = "CRP";
  final static String CSB = "CSB";
  final static String CUS = "CUS";
  final static String WEL = "WEL";
  final static String CYM = "CYM";
  final static String DAK = "DAK";
  final static String DAN = "DAN";
  final static String DAR = "DAR";
  final static String DAY = "DAY";
  final static String DEL = "DEL";
  final static String DEN = "DEN";
  final static String GER = "GER";
  final static String DEU = "DEU";
  final static String DGR = "DGR";
  final static String DIN = "DIN";
  final static String DIV = "DIV";
  final static String DOI = "DOI";
  final static String DRA = "DRA";
  final static String DSB = "DSB";
  final static String DUA = "DUA";
  final static String DUM = "DUM";
  final static String DUT = "DUT";
  final static String NLD = "NLD";
  final static String DYU = "DYU";
  final static String DZO = "DZO";
  final static String EFI = "EFI";
  final static String EGY = "EGY";
  final static String EKA = "EKA";
  final static String GRE = "GRE";
  final static String ELL = "ELL";
  final static String ELX = "ELX";
  final static String ENG = "ENG";
  final static String ENM = "ENM";
  final static String EPO = "EPO";
  final static String EST = "EST";
  final static String EWE = "EWE";
  final static String EWO = "EWO";
  final static String FAN = "FAN";
  final static String FAO = "FAO";
  final static String PER = "PER";
  final static String FAS = "FAS";
  final static String FAT = "FAT";
  final static String FIJ = "FIJ";
  final static String FIL = "FIL";
  final static String FIN = "FIN";
  final static String FIU = "FIU";
  final static String FON = "FON";
  final static String FRE = "FRE";
  final static String FRA = "FRA";
  final static String FRM = "FRM";
  final static String FRO = "FRO";
  final static String FRR = "FRR";
  final static String FRS = "FRS";
  final static String FRY = "FRY";
  final static String FUL = "FUL";
  final static String FUR = "FUR";
  final static String GAA = "GAA";
  final static String GAY = "GAY";
  final static String GBA = "GBA";
  final static String GEM = "GEM";
  final static String GEO = "GEO";
  final static String KAT = "KAT";
  final static String GEZ = "GEZ";
  final static String GIL = "GIL";
  final static String GLA = "GLA";
  final static String GLE = "GLE";
  final static String GLG = "GLG";
  final static String GLV = "GLV";
  final static String GMH = "GMH";
  final static String GOH = "GOH";
  final static String GON = "GON";
  final static String GOR = "GOR";
  final static String GOT = "GOT";
  final static String GRB = "GRB";
  final static String GRC = "GRC";
  final static String GRN = "GRN";
  final static String GSW = "GSW";
  final static String GUJ = "GUJ";
  final static String GWI = "GWI";
  final static String HAI = "HAI";
  final static String HAT = "HAT";
  final static String HAU = "HAU";
  final static String HAW = "HAW";
  final static String HEB = "HEB";
  final static String HER = "HER";
  final static String HIL = "HIL";
  final static String HIM = "HIM";
  final static String HIN = "HIN";
  final static String HIT = "HIT";
  final static String HMN = "HMN";
  final static String HMO = "HMO";
  final static String HRV = "HRV";
  final static String HSB = "HSB";
  final static String HUN = "HUN";
  final static String HUP = "HUP";
  final static String IBA = "IBA";
  final static String IBO = "IBO";
  final static String ICE = "ICE";
  final static String ISL = "ISL";
  final static String IDO = "IDO";
  final static String III = "III";
  final static String IJO = "IJO";
  final static String IKU = "IKU";
  final static String ILE = "ILE";
  final static String ILO = "ILO";
  final static String INA = "INA";
  final static String INC = "INC";
  final static String IND = "IND";
  final static String INE = "INE";
  final static String INH = "INH";
  final static String IPK = "IPK";
  final static String IRA = "IRA";
  final static String IRO = "IRO";
  final static String ITA = "ITA";
  final static String JAV = "JAV";
  final static String JBO = "JBO";
  final static String JPN = "JPN";
  final static String JPR = "JPR";
  final static String JRB = "JRB";
  final static String KAA = "KAA";
  final static String KAB = "KAB";
  final static String KAC = "KAC";
  final static String KAL = "KAL";
  final static String KAM = "KAM";
  final static String KAN = "KAN";
  final static String KAR = "KAR";
  final static String KAS = "KAS";
  final static String KAU = "KAU";
  final static String KAW = "KAW";
  final static String KAZ = "KAZ";
  final static String KBD = "KBD";
  final static String KHA = "KHA";
  final static String KHI = "KHI";
  final static String KHM = "KHM";
  final static String KHO = "KHO";
  final static String KIK = "KIK";
  final static String KIN = "KIN";
  final static String KIR = "KIR";
  final static String KMB = "KMB";
  final static String KOK = "KOK";
  final static String KOM = "KOM";
  final static String KON = "KON";
  final static String KOR = "KOR";
  final static String KOS = "KOS";
  final static String KPE = "KPE";
  final static String KRC = "KRC";
  final static String KRL = "KRL";
  final static String KRO = "KRO";
  final static String KRU = "KRU";
  final static String KUA = "KUA";
  final static String KUM = "KUM";
  final static String KUR = "KUR";
  final static String KUT = "KUT";
  final static String LAD = "LAD";
  final static String LAH = "LAH";
  final static String LAM = "LAM";
  final static String LAO = "LAO";
  final static String LAT = "LAT";
  final static String LAV = "LAV";
  final static String LEZ = "LEZ";
  final static String LIM = "LIM";
  final static String LIN = "LIN";
  final static String LIT = "LIT";
  final static String LOL = "LOL";
  final static String LOZ = "LOZ";
  final static String LTZ = "LTZ";
  final static String LUA = "LUA";
  final static String LUB = "LUB";
  final static String LUG = "LUG";
  final static String LUI = "LUI";
  final static String LUN = "LUN";
  final static String LUO = "LUO";
  final static String LUS = "LUS";
  final static String MAC = "MAC";
  final static String MKD = "MKD";
  final static String MAD = "MAD";
  final static String MAG = "MAG";
  final static String MAH = "MAH";
  final static String MAI = "MAI";
  final static String MAK = "MAK";
  final static String MAL = "MAL";
  final static String MAN = "MAN";
  final static String MAO = "MAO";
  final static String MRI = "MRI";
  final static String MAP = "MAP";
  final static String MAR = "MAR";
  final static String MAS = "MAS";
  final static String MAY = "MAY";
  final static String MSA = "MSA";
  final static String MDF = "MDF";
  final static String MDR = "MDR";
  final static String MEN = "MEN";
  final static String MGA = "MGA";
  final static String MIC = "MIC";
  final static String MIN = "MIN";
  final static String MIS = "MIS";
  final static String MKH = "MKH";
  final static String MLG = "MLG";
  final static String MLT = "MLT";
  final static String MNC = "MNC";
  final static String MNI = "MNI";
  final static String MNO = "MNO";
  final static String MOH = "MOH";
  final static String MON = "MON";
  final static String MOS = "MOS";
  final static String MUL = "MUL";
  final static String MUN = "MUN";
  final static String MUS = "MUS";
  final static String MWL = "MWL";
  final static String MWR = "MWR";
  final static String MYN = "MYN";
  final static String MYV = "MYV";
  final static String NAH = "NAH";
  final static String NAI = "NAI";
  final static String NAP = "NAP";
  final static String NAU = "NAU";
  final static String NAV = "NAV";
  final static String NBL = "NBL";
  final static String NDE = "NDE";
  final static String NDO = "NDO";
  final static String NDS = "NDS";
  final static String NEP = "NEP";
  final static String NEW = "NEW";
  final static String NIA = "NIA";
  final static String NIC = "NIC";
  final static String NIU = "NIU";
  final static String NNO = "NNO";
  final static String NOB = "NOB";
  final static String NOG = "NOG";
  final static String NON = "NON";
  final static String NOR = "NOR";
  final static String NQO = "NQO";
  final static String NSO = "NSO";
  final static String NUB = "NUB";
  final static String NWC = "NWC";
  final static String NYA = "NYA";
  final static String NYM = "NYM";
  final static String NYN = "NYN";
  final static String NYO = "NYO";
  final static String NZI = "NZI";
  final static String OCI = "OCI";
  final static String OJI = "OJI";
  final static String ORI = "ORI";
  final static String ORM = "ORM";
  final static String OSA = "OSA";
  final static String OSS = "OSS";
  final static String OTA = "OTA";
  final static String OTO = "OTO";
  final static String PAA = "PAA";
  final static String PAG = "PAG";
  final static String PAL = "PAL";
  final static String PAM = "PAM";
  final static String PAN = "PAN";
  final static String PAP = "PAP";
  final static String PAU = "PAU";
  final static String PEO = "PEO";
  final static String PHI = "PHI";
  final static String PHN = "PHN";
  final static String PLI = "PLI";
  final static String POL = "POL";
  final static String PON = "PON";
  final static String POR = "POR";
  final static String PRA = "PRA";
  final static String PRO = "PRO";
  final static String PUS = "PUS";
  final static String QUE = "QUE";
  final static String RAJ = "RAJ";
  final static String RAP = "RAP";
  final static String RAR = "RAR";
  final static String ROA = "ROA";
  final static String ROH = "ROH";
  final static String ROM = "ROM";
  final static String RUM = "RUM";
  final static String RON = "RON";
  final static String RUN = "RUN";
  final static String RUP = "RUP";
  final static String RUS = "RUS";
  final static String SAD = "SAD";
  final static String SAG = "SAG";
  final static String SAH = "SAH";
  final static String SAI = "SAI";
  final static String SAL = "SAL";
  final static String SAM = "SAM";
  final static String SAN = "SAN";
  final static String SAS = "SAS";
  final static String SAT = "SAT";
  final static String SCN = "SCN";
  final static String SCO = "SCO";
  final static String SEL = "SEL";
  final static String SEM = "SEM";
  final static String SGA = "SGA";
  final static String SGN = "SGN";
  final static String SHN = "SHN";
  final static String SID = "SID";
  final static String SIN = "SIN";
  final static String SIO = "SIO";
  final static String SIT = "SIT";
  final static String SLA = "SLA";
  final static String SLO = "SLO";
  final static String SLK = "SLK";
  final static String SLV = "SLV";
  final static String SMA = "SMA";
  final static String SME = "SME";
  final static String SMI = "SMI";
  final static String SMJ = "SMJ";
  final static String SMN = "SMN";
  final static String SMO = "SMO";
  final static String SMS = "SMS";
  final static String SNA = "SNA";
  final static String SND = "SND";
  final static String SNK = "SNK";
  final static String SOG = "SOG";
  final static String SOM = "SOM";
  final static String SON = "SON";
  final static String SOT = "SOT";
  final static String SPA = "SPA";
  final static String SRD = "SRD";
  final static String SRN = "SRN";
  final static String SRP = "SRP";
  final static String SRR = "SRR";
  final static String SSA = "SSA";
  final static String SSW = "SSW";
  final static String SUK = "SUK";
  final static String SUN = "SUN";
  final static String SUS = "SUS";
  final static String SUX = "SUX";
  final static String SWA = "SWA";
  final static String SWE = "SWE";
  final static String SYC = "SYC";
  final static String SYR = "SYR";
  final static String TAH = "TAH";
  final static String TAI = "TAI";
  final static String TAM = "TAM";
  final static String TAT = "TAT";
  final static String TEL = "TEL";
  final static String TEM = "TEM";
  final static String TER = "TER";
  final static String TET = "TET";
  final static String TGK = "TGK";
  final static String TGL = "TGL";
  final static String THA = "THA";
  final static String TIG = "TIG";
  final static String TIR = "TIR";
  final static String TIV = "TIV";
  final static String TKL = "TKL";
  final static String TLH = "TLH";
  final static String TLI = "TLI";
  final static String TMH = "TMH";
  final static String TOG = "TOG";
  final static String TON = "TON";
  final static String TPI = "TPI";
  final static String TSI = "TSI";
  final static String TSN = "TSN";
  final static String TSO = "TSO";
  final static String TUK = "TUK";
  final static String TUM = "TUM";
  final static String TUP = "TUP";
  final static String TUR = "TUR";
  final static String TUT = "TUT";
  final static String TVL = "TVL";
  final static String TWI = "TWI";
  final static String TYV = "TYV";
  final static String UDM = "UDM";
  final static String UGA = "UGA";
  final static String UIG = "UIG";
  final static String UKR = "UKR";
  final static String UMB = "UMB";
  final static String UND = "UND";
  final static String URD = "URD";
  final static String UZB = "UZB";
  final static String VAI = "VAI";
  final static String VEN = "VEN";
  final static String VIE = "VIE";
  final static String VOL = "VOL";
  final static String VOT = "VOT";
  final static String WAK = "WAK";
  final static String WAL = "WAL";
  final static String WAR = "WAR";
  final static String WAS = "WAS";
  final static String WEN = "WEN";
  final static String WLN = "WLN";
  final static String WOL = "WOL";
  final static String XAL = "XAL";
  final static String XHO = "XHO";
  final static String YAO = "YAO";
  final static String YAP = "YAP";
  final static String YID = "YID";
  final static String YOR = "YOR";
  final static String YPK = "YPK";
  final static String AA = "AA";
  final static String AB = "AB";
  final static String AF = "AF";
  final static String AK = "AK";
  final static String SQ = "SQ";
  final static String AM = "AM";
  final static String AR = "AR";
  final static String AN = "AN";
  final static String HY = "HY";
  final static String AS = "AS";
  final static String AV = "AV";
  final static String AE = "AE";
  final static String AY = "AY";
  final static String AZ = "AZ";
  final static String BA = "BA";
  final static String BM = "BM";
  final static String EU = "EU";
  final static String BE = "BE";
  final static String BN = "BN";
  final static String BH = "BH";
  final static String BI = "BI";
  final static String BO = "BO";
  final static String BS = "BS";
  final static String BR = "BR";
  final static String BG = "BG";
  final static String MY = "MY";
  final static String CA = "CA";
  final static String CS = "CS";
  final static String CH = "CH";
  final static String CE = "CE";
  final static String ZH = "ZH";
  final static String CU = "CU";
  final static String CV = "CV";
  final static String KW = "KW";
  final static String CO = "CO";
  final static String CR = "CR";
  final static String CY = "CY";
  final static String DA = "DA";
  final static String DE = "DE";
  final static String DV = "DV";
  final static String NL = "NL";
  final static String DZ = "DZ";
  final static String EL = "EL";
  final static String EN = "EN";
  final static String EO = "EO";
  final static String ET = "ET";
  final static String EE = "EE";
  final static String FO = "FO";
  final static String FA = "FA";
  final static String FJ = "FJ";
  final static String FI = "FI";
  final static String FR = "FR";
  final static String FY = "FY";
  final static String FF = "FF";
  final static String KA = "KA";
  final static String GD = "GD";
  final static String GA = "GA";
  final static String GL = "GL";
  final static String GV = "GV";
  final static String GN = "GN";
  final static String GU = "GU";
  final static String HT = "HT";
  final static String HA = "HA";
  final static String HE = "HE";
  final static String HZ = "HZ";
  final static String HI = "HI";
  final static String HO = "HO";
  final static String HR = "HR";
  final static String HU = "HU";
  final static String IG = "IG";
  final static String IS = "IS";
  final static String IO = "IO";
  final static String II = "II";
  final static String IU = "IU";
  final static String IE = "IE";
  final static String IA = "IA";
  final static String ID = "ID";
  final static String IK = "IK";
  final static String IT = "IT";
  final static String JV = "JV";
  final static String JA = "JA";
  final static String KL = "KL";
  final static String KN = "KN";
  final static String KS = "KS";
  final static String KR = "KR";
  final static String KK = "KK";
  final static String KM = "KM";
  final static String KI = "KI";
  final static String RW = "RW";
  final static String KY = "KY";
  final static String KV = "KV";
  final static String KG = "KG";
  final static String KO = "KO";
  final static String KJ = "KJ";
  final static String KU = "KU";
  final static String LO = "LO";
  final static String LA = "LA";
  final static String LV = "LV";
  final static String LI = "LI";
  final static String LN = "LN";
  final static String LT = "LT";
  final static String LB = "LB";
  final static String LU = "LU";
  final static String LG = "LG";
  final static String MK = "MK";
  final static String MH = "MH";
  final static String ML = "ML";
  final static String MI = "MI";
  final static String MR = "MR";
  final static String MS = "MS";
  final static String MG = "MG";
  final static String MT = "MT";
  final static String MN = "MN";
  final static String NA = "NA";
  final static String NV = "NV";
  final static String NR = "NR";
  final static String ND = "ND";
  final static String NG = "NG";
  final static String NE = "NE";
  final static String NN = "NN";
  final static String NB = "NB";
  final static String NO = "NO";
  final static String NY = "NY";
  final static String OC = "OC";
  final static String OJ = "OJ";
  final static String OR = "OR";
  final static String OM = "OM";
  final static String OS = "OS";
  final static String PA = "PA";
  final static String PI = "PI";
  final static String PL = "PL";
  final static String PT = "PT";
  final static String PS = "PS";
  final static String QU = "QU";
  final static String RM = "RM";
  final static String RO = "RO";
  final static String RN = "RN";
  final static String RU = "RU";
  final static String SG = "SG";
  final static String SA = "SA";
  final static String SI = "SI";
  final static String SK = "SK";
  final static String SL = "SL";
  final static String SE = "SE";
  final static String SM = "SM";
  final static String SN = "SN";
  final static String SD = "SD";
  final static String SO = "SO";
  final static String ST = "ST";
  final static String ES = "ES";
  final static String SC = "SC";
  final static String SR = "SR";
  final static String SS = "SS";
  final static String SU = "SU";
  final static String SW = "SW";
  final static String SV = "SV";
  final static String TY = "TY";
  final static String TA = "TA";
  final static String TT = "TT";
  final static String TE = "TE";
  final static String TG = "TG";
  final static String TL = "TL";
  final static String TH = "TH";
  final static String TI = "TI";
  final static String TO = "TO";
  final static String TN = "TN";
  final static String TS = "TS";
  final static String TK = "TK";
  final static String TR = "TR";
  final static String TW = "TW";
  final static String UG = "UG";
  final static String UK = "UK";
  final static String UR = "UR";
  final static String UZ = "UZ";
  final static String VE = "VE";
  final static String VI = "VI";
  final static String VO = "VO";
  final static String WA = "WA";
  final static String WO = "WO";
  final static String XH = "XH";
  final static String YI = "YI";
  final static String YO = "YO";

  private static HashBiMap<String, String> ISO639_1_2 = HashBiMap.create();
  private static HashBiMap<String, String> ISO639_1_2_B = HashBiMap.create();
  private static HashBiMap<String, String> ISO639_1_2_T = HashBiMap.create();

  static {
    ISO639_1_2.put(AAR, AA);
    ISO639_1_2.put(ABK, AB);
    ISO639_1_2.put(AFR, AF);
    ISO639_1_2.put(AKA, AK);
    ISO639_1_2.put(AMH, AM);
    ISO639_1_2.put(ARA, AR);
    ISO639_1_2.put(ARG, AN);
    ISO639_1_2.put(ASM, AS);
    ISO639_1_2.put(AVA, AV);
    ISO639_1_2.put(AVE, AE);
    ISO639_1_2.put(AYM, AY);
    ISO639_1_2.put(AZE, AZ);
    ISO639_1_2.put(BAK, BA);
    ISO639_1_2.put(BAM, BM);
    ISO639_1_2.put(BEL, BE);
    ISO639_1_2.put(BEN, BN);
    ISO639_1_2.put(BIH, BH);
    ISO639_1_2.put(BIS, BI);
    ISO639_1_2.put(BOS, BS);
    ISO639_1_2.put(BRE, BR);
    ISO639_1_2.put(BUL, BG);
    ISO639_1_2.put(CAT, CA);
    ISO639_1_2.put(CHA, CH);
    ISO639_1_2.put(CHE, CE);
    ISO639_1_2.put(CHU, CU);
    ISO639_1_2.put(CHV, CV);
    ISO639_1_2.put(COR, KW);
    ISO639_1_2.put(COS, CO);
    ISO639_1_2.put(CRE, CR);
    ISO639_1_2.put(DAN, DA);
    ISO639_1_2.put(DIV, DV);
    ISO639_1_2.put(DZO, DZ);
    ISO639_1_2.put(ENG, EN);
    ISO639_1_2.put(EPO, EO);
    ISO639_1_2.put(EST, ET);
    ISO639_1_2.put(EWE, EE);
    ISO639_1_2.put(FAO, FO);
    ISO639_1_2.put(FIJ, FJ);
    ISO639_1_2.put(FIN, FI);
    ISO639_1_2.put(FRY, FY);
    ISO639_1_2.put(FUL, FF);
    ISO639_1_2.put(GLA, GD);
    ISO639_1_2.put(GLE, GA);
    ISO639_1_2.put(GLG, GL);
    ISO639_1_2.put(GLV, GV);
    ISO639_1_2.put(GRN, GN);
    ISO639_1_2.put(GUJ, GU);
    ISO639_1_2.put(HAT, HT);
    ISO639_1_2.put(HAU, HA);
    ISO639_1_2.put(HEB, HE);
    ISO639_1_2.put(HER, HZ);
    ISO639_1_2.put(HIN, HI);
    ISO639_1_2.put(HMO, HO);
    ISO639_1_2.put(HRV, HR);
    ISO639_1_2.put(HUN, HU);
    ISO639_1_2.put(IBO, IG);
    ISO639_1_2.put(IDO, IO);
    ISO639_1_2.put(III, II);
    ISO639_1_2.put(IKU, IU);
    ISO639_1_2.put(ILE, IE);
    ISO639_1_2.put(INA, IA);
    ISO639_1_2.put(IND, ID);
    ISO639_1_2.put(IPK, IK);
    ISO639_1_2.put(ITA, IT);
    ISO639_1_2.put(JAV, JV);
    ISO639_1_2.put(JPN, JA);
    ISO639_1_2.put(KAL, KL);
    ISO639_1_2.put(KAN, KN);
    ISO639_1_2.put(KAS, KS);
    ISO639_1_2.put(KAU, KR);
    ISO639_1_2.put(KAZ, KK);
    ISO639_1_2.put(KHM, KM);
    ISO639_1_2.put(KIK, KI);
    ISO639_1_2.put(KIN, RW);
    ISO639_1_2.put(KIR, KY);
    ISO639_1_2.put(KOM, KV);
    ISO639_1_2.put(KON, KG);
    ISO639_1_2.put(KOR, KO);
    ISO639_1_2.put(KUA, KJ);
    ISO639_1_2.put(KUR, KU);
    ISO639_1_2.put(LAO, LO);
    ISO639_1_2.put(LAT, LA);
    ISO639_1_2.put(LAV, LV);
    ISO639_1_2.put(LIM, LI);
    ISO639_1_2.put(LIN, LN);
    ISO639_1_2.put(LIT, LT);
    ISO639_1_2.put(LTZ, LB);
    ISO639_1_2.put(LUB, LU);
    ISO639_1_2.put(LUG, LG);
    ISO639_1_2.put(MAH, MH);
    ISO639_1_2.put(MAL, ML);
    ISO639_1_2.put(MAR, MR);
    ISO639_1_2.put(MLG, MG);
    ISO639_1_2.put(MLT, MT);
    ISO639_1_2.put(MON, MN);
    ISO639_1_2.put(NAU, NA);
    ISO639_1_2.put(NAV, NV);
    ISO639_1_2.put(NBL, NR);
    ISO639_1_2.put(NDE, ND);
    ISO639_1_2.put(NDO, NG);
    ISO639_1_2.put(NEP, NE);
    ISO639_1_2.put(NNO, NN);
    ISO639_1_2.put(NOB, NB);
    ISO639_1_2.put(NOR, NO);
    ISO639_1_2.put(NYA, NY);
    ISO639_1_2.put(OCI, OC);
    ISO639_1_2.put(OJI, OJ);
    ISO639_1_2.put(ORI, OR);
    ISO639_1_2.put(ORM, OM);
    ISO639_1_2.put(OSS, OS);
    ISO639_1_2.put(PAN, PA);
    ISO639_1_2.put(PLI, PI);
    ISO639_1_2.put(POL, PL);
    ISO639_1_2.put(POR, PT);
    ISO639_1_2.put(PUS, PS);
    ISO639_1_2.put(QUE, QU);
    ISO639_1_2.put(ROH, RM);
    ISO639_1_2.put(RUN, RN);
    ISO639_1_2.put(RUS, RU);
    ISO639_1_2.put(SAG, SG);
    ISO639_1_2.put(SAN, SA);
    ISO639_1_2.put(SIN, SI);
    ISO639_1_2.put(SLV, SL);
    ISO639_1_2.put(SME, SE);
    ISO639_1_2.put(SMO, SM);
    ISO639_1_2.put(SNA, SN);
    ISO639_1_2.put(SND, SD);
    ISO639_1_2.put(SOM, SO);
    ISO639_1_2.put(SOT, ST);
    ISO639_1_2.put(SPA, ES);
    ISO639_1_2.put(SRD, SC);
    ISO639_1_2.put(SRP, SR);
    ISO639_1_2.put(SSW, SS);
    ISO639_1_2.put(SUN, SU);
    ISO639_1_2.put(SWA, SW);
    ISO639_1_2.put(SWE, SV);
    ISO639_1_2.put(TAH, TY);
    ISO639_1_2.put(TAM, TA);
    ISO639_1_2.put(TAT, TT);
    ISO639_1_2.put(TEL, TE);
    ISO639_1_2.put(TGK, TG);
    ISO639_1_2.put(TGL, TL);
    ISO639_1_2.put(THA, TH);
    ISO639_1_2.put(TIR, TI);
    ISO639_1_2.put(TON, TO);
    ISO639_1_2.put(TSN, TN);
    ISO639_1_2.put(TSO, TS);
    ISO639_1_2.put(TUK, TK);
    ISO639_1_2.put(TUR, TR);
    ISO639_1_2.put(TWI, TW);
    ISO639_1_2.put(UIG, UG);
    ISO639_1_2.put(UKR, UK);
    ISO639_1_2.put(URD, UR);
    ISO639_1_2.put(UZB, UZ);
    ISO639_1_2.put(VEN, VE);
    ISO639_1_2.put(VIE, VI);
    ISO639_1_2.put(VOL, VO);
    ISO639_1_2.put(WLN, WA);
    ISO639_1_2.put(WOL, WO);
    ISO639_1_2.put(XHO, XH);
    ISO639_1_2.put(YID, YI);
    ISO639_1_2.put(YOR, YO);

    ISO639_1_2_B.put(ALB, SQ);
    ISO639_1_2_B.put(ARM, HY);
    ISO639_1_2_B.put(BAQ, EU);
    ISO639_1_2_B.put(TIB, BO);
    ISO639_1_2_B.put(BUR, MY);
    ISO639_1_2_B.put(CZE, CS);
    ISO639_1_2_B.put(CHI, ZH);
    ISO639_1_2_B.put(WEL, CY);
    ISO639_1_2_B.put(GER, DE);
    ISO639_1_2_B.put(DUT, NL);
    ISO639_1_2_B.put(GRE, EL);
    ISO639_1_2_B.put(PER, FA);
    ISO639_1_2_B.put(FRE, FR);
    ISO639_1_2_B.put(GEO, KA);
    ISO639_1_2_B.put(ICE, IS);
    ISO639_1_2_B.put(MAC, MK);
    ISO639_1_2_B.put(MAO, MI);
    ISO639_1_2_B.put(MAY, MS);
    ISO639_1_2_B.put(RUM, RO);
    ISO639_1_2_B.put(SLO, SK);

    ISO639_1_2_T.put(SQI, SQ);
    ISO639_1_2_T.put(HYE, HY);
    ISO639_1_2_T.put(EUS, EU);
    ISO639_1_2_T.put(BOD, BO);
    ISO639_1_2_T.put(MYA, MY);
    ISO639_1_2_T.put(CES, CS);
    ISO639_1_2_T.put(ZHO, ZH);
    ISO639_1_2_T.put(CYM, CY);
    ISO639_1_2_T.put(DEU, DE);
    ISO639_1_2_T.put(NLD, NL);
    ISO639_1_2_T.put(ELL, EL);
    ISO639_1_2_T.put(FAS, FA);
    ISO639_1_2_T.put(FRA, FR);
    ISO639_1_2_T.put(KAT, KA);
    ISO639_1_2_T.put(ISL, IS);
    ISO639_1_2_T.put(MKD, MK);
    ISO639_1_2_T.put(MRI, MI);
    ISO639_1_2_T.put(MSA, MS);
    ISO639_1_2_T.put(RON, RO);
    ISO639_1_2_T.put(SLK, SK);
  }

  public static String convertISO639_2ToISO639_1(String langISO639_2) {
    final String sUnified = langISO639_2.toUpperCase(Locale.US);
    if (ISO639_1_2.containsKey(sUnified)) {
      return ISO639_1_2.get(sUnified);
    }

    if (ISO639_1_2_B.containsKey(sUnified)) {
      return ISO639_1_2_B.get(sUnified);
    }

    if (ISO639_1_2_T.containsKey(sUnified)) {
      return ISO639_1_2_T.get(sUnified);
    }

    //Language not supported
    return NULL;
  }

  public static String convertISO639_1ToISO639_2Bibliographic(String langISO639_1) {
    final String sUnified = langISO639_1.toUpperCase(Locale.US);
    if (ISO639_1_2_B.containsValue(sUnified)) {
      return ISO639_1_2_B.inverse().get(sUnified);
    }

    if (ISO639_1_2.containsValue(sUnified)) {
      return ISO639_1_2.inverse().get(sUnified);
    }

    //Language not supported
    return NULL;
  }

  public static String convertISO639_1ToISO639_2Terminology(String langISO639_1) {
    final String sUnified = langISO639_1.toUpperCase(Locale.US);
    if (ISO639_1_2_T.containsValue(sUnified)) {
      return ISO639_1_2_T.inverse().get(sUnified);
    }

    if (ISO639_1_2.containsValue(sUnified)) {
      return ISO639_1_2.inverse().get(sUnified);
    }

    //Language not supported
    return NULL;
  }
}
