<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:rsm="urn:ferd:CrossIndustryDocument:invoice:1p0"
                xmlns:qdt="urn:un:unece:uncefact:data:standard:QualifiedDataType:12"
                xmlns:ram="urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:12"
                xmlns:udt="urn:un:unece:uncefact:data:standard:UnqualifiedDataType:15"
                xmlns:ccts="urn:un:unece:uncefact:documentation:standard:CoreComponentsTechnicalSpecification:2"
                version="1.0"><!--Implementers: please note that overriding process-prolog or process-root is 
    the preferred method for meta-stylesheets to use where possible. The name or details of 
    this mode may change during 1Q 2007.-->


<!--PHASES-->


<!--PROLOG-->
   <xsl:output method="xml"/>

   <!--KEYS-->


   <!--DEFAULT RULES-->


   <!--MODE: SCHEMATRON-FULL-PATH-->
   <!--This mode can be used to generate an ugly though full XPath for locators-->
   <xsl:template match="*" mode="schematron-get-full-path">
      <xsl:text>/</xsl:text>
      <xsl:choose>
         <xsl:when test="namespace-uri()=''">
            <xsl:value-of select="name()"/>
            <xsl:variable name="p"
                          select="1+    count(preceding-sibling::*[name()=name(current())])"/>
            <xsl:if test="$p&gt;1">[<xsl:value-of select="$p"/>]</xsl:if>
         </xsl:when>
         <xsl:otherwise>
            <xsl:text>*[local-name()='</xsl:text>
            <xsl:value-of select="local-name()"/>
            <xsl:text>']</xsl:text>
            <xsl:variable name="p"
                          select="1+   count(preceding-sibling::*[local-name()=local-name(current())])"/>
            <xsl:if test="$p&gt;1">[<xsl:value-of select="$p"/>]</xsl:if>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xsl:template match="@*" mode="schematron-get-full-path">
      <xsl:text>/</xsl:text>
      <xsl:choose>
         <xsl:when test="namespace-uri()=''">@schema</xsl:when>
         <xsl:otherwise>
            <xsl:text>@*[local-name()='</xsl:text>
            <xsl:value-of select="local-name()"/>
            <xsl:text>' and namespace-uri()='</xsl:text>
            <xsl:value-of select="namespace-uri()"/>
            <xsl:text>']</xsl:text>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <xsl:template match="text()" mode="schematron-get-full-path">
      <xsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
      <xsl:text>/</xsl:text>
      <xsl:text>text()</xsl:text>
      <xsl:variable name="preceding" select="count(preceding-sibling::text())"/>
      <xsl:text>[</xsl:text>
      <xsl:value-of select="1+ $preceding"/>
      <xsl:text>]</xsl:text>
   </xsl:template>
   <xsl:template match="comment()" mode="schematron-get-full-path">
      <xsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
      <xsl:text>/</xsl:text>
      <xsl:text>comment()</xsl:text>
      <xsl:variable name="preceding" select="count(preceding-sibling::comment())"/>
      <xsl:text>[</xsl:text>
      <xsl:value-of select="1+ $preceding"/>
      <xsl:text>]</xsl:text>
   </xsl:template>
   <xsl:template match="processing-instruction()" mode="schematron-get-full-path">
      <xsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
      <xsl:text>/</xsl:text>
      <xsl:text>processing-instruction()</xsl:text>
      <xsl:variable name="preceding"
                    select="count(preceding-sibling::processing-instruction())"/>
      <xsl:text>[</xsl:text>
      <xsl:value-of select="1+ $preceding"/>
      <xsl:text>]</xsl:text>
   </xsl:template>

   <!--MODE: SCHEMATRON-FULL-PATH-2-->
   <!--This mode can be used to generate prefixed XPath for humans-->
   <xsl:template match="node() | @*" mode="schematron-get-full-path-2">
      <xsl:for-each select="ancestor-or-self::*">
         <xsl:text>/</xsl:text>
         <xsl:value-of select="name(.)"/>
         <xsl:if test="preceding-sibling::*[name(.)=name(current())]">
            <xsl:text>[</xsl:text>
            <xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/>
            <xsl:text>]</xsl:text>
         </xsl:if>
      </xsl:for-each>
      <xsl:if test="not(self::*)">
         <xsl:text/>/@<xsl:value-of select="name(.)"/>
      </xsl:if>
   </xsl:template>

   <!--MODE: GENERATE-ID-FROM-PATH -->
   <xsl:template match="/" mode="generate-id-from-path"/>
   <xsl:template match="text()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.text-', 1+count(preceding-sibling::text()), '-')"/>
   </xsl:template>
   <xsl:template match="comment()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.comment-', 1+count(preceding-sibling::comment()), '-')"/>
   </xsl:template>
   <xsl:template match="processing-instruction()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.processing-instruction-', 1+count(preceding-sibling::processing-instruction()), '-')"/>
   </xsl:template>
   <xsl:template match="@*" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.@', name())"/>
   </xsl:template>
   <xsl:template match="*" mode="generate-id-from-path" priority="-0.5">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:text>.</xsl:text>
      <xsl:choose>
         <xsl:when test="count(. | ../namespace::*) = count(../namespace::*)">
            <xsl:value-of select="concat('.namespace::-',1+count(namespace::*),'-')"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:value-of select="concat('.',name(),'-',1+count(preceding-sibling::*[name()=name(current())]),'-')"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--MODE: GENERATE-ID-2 -->
   <xsl:template match="/" mode="generate-id-2">U</xsl:template>
   <xsl:template match="*" mode="generate-id-2" priority="2">
      <xsl:text>U</xsl:text>
      <xsl:number level="multiple" count="*"/>
   </xsl:template>
   <xsl:template match="node()" mode="generate-id-2">
      <xsl:text>U.</xsl:text>
      <xsl:number level="multiple" count="*"/>
      <xsl:text>n</xsl:text>
      <xsl:number count="node()"/>
   </xsl:template>
   <xsl:template match="@*" mode="generate-id-2">
      <xsl:text>U.</xsl:text>
      <xsl:number level="multiple" count="*"/>
      <xsl:text>_</xsl:text>
      <xsl:value-of select="string-length(local-name(.))"/>
      <xsl:text>_</xsl:text>
      <xsl:value-of select="translate(name(),':','.')"/>
   </xsl:template>
   <!--Strip characters-->
   <xsl:template match="text()" priority="-1"/>

   <!--SCHEMA METADATA-->
   <xsl:template match="/">
      <xsl:apply-templates select="/" mode="M6"/>
      <xsl:apply-templates select="/" mode="M7"/>
      <xsl:apply-templates select="/" mode="M8"/>
      <xsl:apply-templates select="/" mode="M9"/>
      <xsl:apply-templates select="/" mode="M10"/>
      <xsl:apply-templates select="/" mode="M11"/>
      <xsl:apply-templates select="/" mode="M12"/>
      <xsl:apply-templates select="/" mode="M13"/>
      <xsl:apply-templates select="/" mode="M14"/>
      <xsl:apply-templates select="/" mode="M15"/>
      <xsl:apply-templates select="/" mode="M16"/>
      <xsl:apply-templates select="/" mode="M17"/>
      <xsl:apply-templates select="/" mode="M18"/>
      <xsl:apply-templates select="/" mode="M19"/>
      <xsl:apply-templates select="/" mode="M20"/>
      <xsl:apply-templates select="/" mode="M21"/>
      <xsl:apply-templates select="/" mode="M22"/>
      <xsl:apply-templates select="/" mode="M23"/>
      <xsl:apply-templates select="/" mode="M24"/>
      <xsl:apply-templates select="/" mode="M25"/>
      <xsl:apply-templates select="/" mode="M26"/>
      <xsl:apply-templates select="/" mode="M27"/>
      <xsl:apply-templates select="/" mode="M28"/>
      <xsl:apply-templates select="/" mode="M29"/>
      <xsl:apply-templates select="/" mode="M30"/>
      <xsl:apply-templates select="/" mode="M31"/>
      <xsl:apply-templates select="/" mode="M32"/>
      <xsl:apply-templates select="/" mode="M33"/>
      <xsl:apply-templates select="/" mode="M34"/>
      <xsl:apply-templates select="/" mode="M35"/>
      <xsl:apply-templates select="/" mode="M36"/>
      <xsl:apply-templates select="/" mode="M37"/>
      <xsl:apply-templates select="/" mode="M38"/>
      <xsl:apply-templates select="/" mode="M39"/>
      <xsl:apply-templates select="/" mode="M40"/>
      <xsl:apply-templates select="/" mode="M41"/>
      <xsl:apply-templates select="/" mode="M42"/>
      <xsl:apply-templates select="/" mode="M43"/>
      <xsl:apply-templates select="/" mode="M44"/>
      <xsl:apply-templates select="/" mode="M45"/>
      <xsl:apply-templates select="/" mode="M46"/>
      <xsl:apply-templates select="/" mode="M47"/>
      <xsl:apply-templates select="/" mode="M48"/>
      <xsl:apply-templates select="/" mode="M49"/>
      <xsl:apply-templates select="/" mode="M50"/>
      <xsl:apply-templates select="/" mode="M51"/>
      <xsl:apply-templates select="/" mode="M52"/>
      <xsl:apply-templates select="/" mode="M53"/>
      <xsl:apply-templates select="/" mode="M54"/>
      <xsl:apply-templates select="/" mode="M55"/>
      <xsl:apply-templates select="/" mode="M56"/>
      <xsl:apply-templates select="/" mode="M57"/>
      <xsl:apply-templates select="/" mode="M58"/>
      <xsl:apply-templates select="/" mode="M59"/>
      <xsl:apply-templates select="/" mode="M60"/>
      <xsl:apply-templates select="/" mode="M61"/>
      <xsl:apply-templates select="/" mode="M62"/>
      <xsl:apply-templates select="/" mode="M63"/>
      <xsl:apply-templates select="/" mode="M64"/>
      <xsl:apply-templates select="/" mode="M65"/>
      <xsl:apply-templates select="/" mode="M66"/>
      <xsl:apply-templates select="/" mode="M67"/>
      <xsl:apply-templates select="/" mode="M68"/>
      <xsl:apply-templates select="/" mode="M69"/>
      <xsl:apply-templates select="/" mode="M70"/>
      <xsl:apply-templates select="/" mode="M71"/>
      <xsl:apply-templates select="/" mode="M72"/>
      <xsl:apply-templates select="/" mode="M73"/>
      <xsl:apply-templates select="/" mode="M74"/>
      <xsl:apply-templates select="/" mode="M75"/>
      <xsl:apply-templates select="/" mode="M76"/>
      <xsl:apply-templates select="/" mode="M77"/>
      <xsl:apply-templates select="/" mode="M78"/>
      <xsl:apply-templates select="/" mode="M79"/>
      <xsl:apply-templates select="/" mode="M80"/>
      <xsl:apply-templates select="/" mode="M81"/>
      <xsl:apply-templates select="/" mode="M82"/>
      <xsl:apply-templates select="/" mode="M83"/>
      <xsl:apply-templates select="/" mode="M84"/>
      <xsl:apply-templates select="/" mode="M85"/>
      <xsl:apply-templates select="/" mode="M86"/>
      <xsl:apply-templates select="/" mode="M87"/>
      <xsl:apply-templates select="/" mode="M88"/>
      <xsl:apply-templates select="/" mode="M89"/>
      <xsl:apply-templates select="/" mode="M90"/>
      <xsl:apply-templates select="/" mode="M91"/>
      <xsl:apply-templates select="/" mode="M92"/>
      <xsl:apply-templates select="/" mode="M93"/>
      <xsl:apply-templates select="/" mode="M94"/>
      <xsl:apply-templates select="/" mode="M95"/>
      <xsl:apply-templates select="/" mode="M96"/>
      <xsl:apply-templates select="/" mode="M97"/>
      <xsl:apply-templates select="/" mode="M98"/>
      <xsl:apply-templates select="/" mode="M99"/>
      <xsl:apply-templates select="/" mode="M100"/>
      <xsl:apply-templates select="/" mode="M101"/>
      <xsl:apply-templates select="/" mode="M102"/>
      <xsl:apply-templates select="/" mode="M103"/>
      <xsl:apply-templates select="/" mode="M104"/>
      <xsl:apply-templates select="/" mode="M105"/>
      <xsl:apply-templates select="/" mode="M106"/>
      <xsl:apply-templates select="/" mode="M107"/>
      <xsl:apply-templates select="/" mode="M108"/>
      <xsl:apply-templates select="/" mode="M109"/>
      <xsl:apply-templates select="/" mode="M110"/>
      <xsl:apply-templates select="/" mode="M111"/>
      <xsl:apply-templates select="/" mode="M112"/>
      <xsl:apply-templates select="/" mode="M113"/>
      <xsl:apply-templates select="/" mode="M114"/>
      <xsl:apply-templates select="/" mode="M115"/>
      <xsl:apply-templates select="/" mode="M116"/>
      <xsl:apply-templates select="/" mode="M117"/>
      <xsl:apply-templates select="/" mode="M118"/>
      <xsl:apply-templates select="/" mode="M119"/>
      <xsl:apply-templates select="/" mode="M120"/>
      <xsl:apply-templates select="/" mode="M121"/>
      <xsl:apply-templates select="/" mode="M122"/>
      <xsl:apply-templates select="/" mode="M123"/>
      <xsl:apply-templates select="/" mode="M124"/>
      <xsl:apply-templates select="/" mode="M125"/>
      <xsl:apply-templates select="/" mode="M126"/>
      <xsl:apply-templates select="/" mode="M127"/>
      <xsl:apply-templates select="/" mode="M128"/>
      <xsl:apply-templates select="/" mode="M129"/>
      <xsl:apply-templates select="/" mode="M130"/>
      <xsl:apply-templates select="/" mode="M131"/>
      <xsl:apply-templates select="/" mode="M132"/>
      <xsl:apply-templates select="/" mode="M133"/>
      <xsl:apply-templates select="/" mode="M134"/>
      <xsl:apply-templates select="/" mode="M135"/>
      <xsl:apply-templates select="/" mode="M136"/>
      <xsl:apply-templates select="/" mode="M137"/>
      <xsl:apply-templates select="/" mode="M138"/>
      <xsl:apply-templates select="/" mode="M139"/>
      <xsl:apply-templates select="/" mode="M140"/>
      <xsl:apply-templates select="/" mode="M141"/>
      <xsl:apply-templates select="/" mode="M142"/>
      <xsl:apply-templates select="/" mode="M143"/>
      <xsl:apply-templates select="/" mode="M144"/>
      <xsl:apply-templates select="/" mode="M145"/>
      <xsl:apply-templates select="/" mode="M146"/>
      <xsl:apply-templates select="/" mode="M147"/>
      <xsl:apply-templates select="/" mode="M148"/>
      <xsl:apply-templates select="/" mode="M149"/>
      <xsl:apply-templates select="/" mode="M150"/>
      <xsl:apply-templates select="/" mode="M151"/>
      <xsl:apply-templates select="/" mode="M152"/>
      <xsl:apply-templates select="/" mode="M153"/>
      <xsl:apply-templates select="/" mode="M154"/>
      <xsl:apply-templates select="/" mode="M155"/>
      <xsl:apply-templates select="/" mode="M156"/>
      <xsl:apply-templates select="/" mode="M157"/>
      <xsl:apply-templates select="/" mode="M158"/>
      <xsl:apply-templates select="/" mode="M159"/>
      <xsl:apply-templates select="/" mode="M160"/>
      <xsl:apply-templates select="/" mode="M161"/>
      <xsl:apply-templates select="/" mode="M162"/>
      <xsl:apply-templates select="/" mode="M163"/>
      <xsl:apply-templates select="/" mode="M164"/>
      <xsl:apply-templates select="/" mode="M165"/>
      <xsl:apply-templates select="/" mode="M166"/>
      <xsl:apply-templates select="/" mode="M167"/>
      <xsl:apply-templates select="/" mode="M168"/>
      <xsl:apply-templates select="/" mode="M169"/>
      <xsl:apply-templates select="/" mode="M170"/>
      <xsl:apply-templates select="/" mode="M171"/>
      <xsl:apply-templates select="/" mode="M172"/>
      <xsl:apply-templates select="/" mode="M173"/>
      <xsl:apply-templates select="/" mode="M174"/>
      <xsl:apply-templates select="/" mode="M175"/>
      <xsl:apply-templates select="/" mode="M176"/>
      <xsl:apply-templates select="/" mode="M177"/>
      <xsl:apply-templates select="/" mode="M178"/>
      <xsl:apply-templates select="/" mode="M179"/>
      <xsl:apply-templates select="/" mode="M180"/>
      <xsl:apply-templates select="/" mode="M181"/>
      <xsl:apply-templates select="/" mode="M182"/>
      <xsl:apply-templates select="/" mode="M183"/>
      <xsl:apply-templates select="/" mode="M184"/>
      <xsl:apply-templates select="/" mode="M185"/>
      <xsl:apply-templates select="/" mode="M186"/>
      <xsl:apply-templates select="/" mode="M187"/>
      <xsl:apply-templates select="/" mode="M188"/>
      <xsl:apply-templates select="/" mode="M189"/>
      <xsl:apply-templates select="/" mode="M190"/>
      <xsl:apply-templates select="/" mode="M191"/>
      <xsl:apply-templates select="/" mode="M192"/>
      <xsl:apply-templates select="/" mode="M193"/>
      <xsl:apply-templates select="/" mode="M194"/>
      <xsl:apply-templates select="/" mode="M195"/>
      <xsl:apply-templates select="/" mode="M196"/>
      <xsl:apply-templates select="/" mode="M197"/>
      <xsl:apply-templates select="/" mode="M198"/>
      <xsl:apply-templates select="/" mode="M199"/>
      <xsl:apply-templates select="/" mode="M200"/>
      <xsl:apply-templates select="/" mode="M201"/>
      <xsl:apply-templates select="/" mode="M202"/>
      <xsl:apply-templates select="/" mode="M203"/>
      <xsl:apply-templates select="/" mode="M204"/>
      <xsl:apply-templates select="/" mode="M205"/>
      <xsl:apply-templates select="/" mode="M206"/>
      <xsl:apply-templates select="/" mode="M207"/>
      <xsl:apply-templates select="/" mode="M208"/>
      <xsl:apply-templates select="/" mode="M209"/>
      <xsl:apply-templates select="/" mode="M210"/>
      <xsl:apply-templates select="/" mode="M211"/>
      <xsl:apply-templates select="/" mode="M212"/>
      <xsl:apply-templates select="/" mode="M213"/>
      <xsl:apply-templates select="/" mode="M214"/>
      <xsl:apply-templates select="/" mode="M215"/>
      <xsl:apply-templates select="/" mode="M216"/>
      <xsl:apply-templates select="/" mode="M217"/>
      <xsl:apply-templates select="/" mode="M218"/>
      <xsl:apply-templates select="/" mode="M219"/>
      <xsl:apply-templates select="/" mode="M220"/>
      <xsl:apply-templates select="/" mode="M221"/>
      <xsl:apply-templates select="/" mode="M222"/>
      <xsl:apply-templates select="/" mode="M223"/>
      <xsl:apply-templates select="/" mode="M224"/>
      <xsl:apply-templates select="/" mode="M225"/>
      <xsl:apply-templates select="/" mode="M226"/>
      <xsl:apply-templates select="/" mode="M227"/>
      <xsl:apply-templates select="/" mode="M228"/>
      <xsl:apply-templates select="/" mode="M229"/>
      <xsl:apply-templates select="/" mode="M230"/>
      <xsl:apply-templates select="/" mode="M231"/>
      <xsl:apply-templates select="/" mode="M232"/>
      <xsl:apply-templates select="/" mode="M233"/>
      <xsl:apply-templates select="/" mode="M234"/>
      <xsl:apply-templates select="/" mode="M235"/>
      <xsl:apply-templates select="/" mode="M236"/>
      <xsl:apply-templates select="/" mode="M237"/>
      <xsl:apply-templates select="/" mode="M238"/>
      <xsl:apply-templates select="/" mode="M239"/>
      <xsl:apply-templates select="/" mode="M240"/>
      <xsl:apply-templates select="/" mode="M241"/>
      <xsl:apply-templates select="/" mode="M242"/>
      <xsl:apply-templates select="/" mode="M243"/>
      <xsl:apply-templates select="/" mode="M244"/>
      <xsl:apply-templates select="/" mode="M245"/>
      <xsl:apply-templates select="/" mode="M246"/>
      <xsl:apply-templates select="/" mode="M247"/>
      <xsl:apply-templates select="/" mode="M248"/>
      <xsl:apply-templates select="/" mode="M249"/>
      <xsl:apply-templates select="/" mode="M250"/>
      <xsl:apply-templates select="/" mode="M251"/>
      <xsl:apply-templates select="/" mode="M252"/>
      <xsl:apply-templates select="/" mode="M253"/>
      <xsl:apply-templates select="/" mode="M254"/>
      <xsl:apply-templates select="/" mode="M255"/>
      <xsl:apply-templates select="/" mode="M256"/>
      <xsl:apply-templates select="/" mode="M257"/>
      <xsl:apply-templates select="/" mode="M258"/>
      <xsl:apply-templates select="/" mode="M259"/>
      <xsl:apply-templates select="/" mode="M260"/>
      <xsl:apply-templates select="/" mode="M261"/>
      <xsl:apply-templates select="/" mode="M262"/>
      <xsl:apply-templates select="/" mode="M263"/>
      <xsl:apply-templates select="/" mode="M264"/>
      <xsl:apply-templates select="/" mode="M265"/>
      <xsl:apply-templates select="/" mode="M266"/>
      <xsl:apply-templates select="/" mode="M267"/>
      <xsl:apply-templates select="/" mode="M268"/>
      <xsl:apply-templates select="/" mode="M269"/>
      <xsl:apply-templates select="/" mode="M270"/>
      <xsl:apply-templates select="/" mode="M271"/>
      <xsl:apply-templates select="/" mode="M272"/>
      <xsl:apply-templates select="/" mode="M273"/>
      <xsl:apply-templates select="/" mode="M274"/>
      <xsl:apply-templates select="/" mode="M275"/>
      <xsl:apply-templates select="/" mode="M276"/>
      <xsl:apply-templates select="/" mode="M277"/>
      <xsl:apply-templates select="/" mode="M278"/>
      <xsl:apply-templates select="/" mode="M279"/>
      <xsl:apply-templates select="/" mode="M280"/>
      <xsl:apply-templates select="/" mode="M281"/>
      <xsl:apply-templates select="/" mode="M282"/>
      <xsl:apply-templates select="/" mode="M283"/>
      <xsl:apply-templates select="/" mode="M284"/>
      <xsl:apply-templates select="/" mode="M285"/>
      <xsl:apply-templates select="/" mode="M286"/>
      <xsl:apply-templates select="/" mode="M287"/>
      <xsl:apply-templates select="/" mode="M288"/>
      <xsl:apply-templates select="/" mode="M289"/>
      <xsl:apply-templates select="/" mode="M290"/>
      <xsl:apply-templates select="/" mode="M291"/>
      <xsl:apply-templates select="/" mode="M292"/>
      <xsl:apply-templates select="/" mode="M293"/>
      <xsl:apply-templates select="/" mode="M294"/>
      <xsl:apply-templates select="/" mode="M295"/>
      <xsl:apply-templates select="/" mode="M296"/>
      <xsl:apply-templates select="/" mode="M297"/>
      <xsl:apply-templates select="/" mode="M298"/>
      <xsl:apply-templates select="/" mode="M299"/>
      <xsl:apply-templates select="/" mode="M300"/>
      <xsl:apply-templates select="/" mode="M301"/>
      <xsl:apply-templates select="/" mode="M302"/>
      <xsl:apply-templates select="/" mode="M303"/>
      <xsl:apply-templates select="/" mode="M304"/>
      <xsl:apply-templates select="/" mode="M305"/>
      <xsl:apply-templates select="/" mode="M306"/>
      <xsl:apply-templates select="/" mode="M307"/>
      <xsl:apply-templates select="/" mode="M308"/>
      <xsl:apply-templates select="/" mode="M309"/>
      <xsl:apply-templates select="/" mode="M310"/>
      <xsl:apply-templates select="/" mode="M311"/>
      <xsl:apply-templates select="/" mode="M312"/>
      <xsl:apply-templates select="/" mode="M313"/>
      <xsl:apply-templates select="/" mode="M314"/>
      <xsl:apply-templates select="/" mode="M315"/>
      <xsl:apply-templates select="/" mode="M316"/>
      <xsl:apply-templates select="/" mode="M317"/>
      <xsl:apply-templates select="/" mode="M318"/>
      <xsl:apply-templates select="/" mode="M319"/>
      <xsl:apply-templates select="/" mode="M320"/>
      <xsl:apply-templates select="/" mode="M321"/>
      <xsl:apply-templates select="/" mode="M322"/>
      <xsl:apply-templates select="/" mode="M323"/>
      <xsl:apply-templates select="/" mode="M324"/>
      <xsl:apply-templates select="/" mode="M325"/>
      <xsl:apply-templates select="/" mode="M326"/>
      <xsl:apply-templates select="/" mode="M327"/>
      <xsl:apply-templates select="/" mode="M328"/>
      <xsl:apply-templates select="/" mode="M329"/>
      <xsl:apply-templates select="/" mode="M330"/>
      <xsl:apply-templates select="/" mode="M331"/>
      <xsl:apply-templates select="/" mode="M332"/>
      <xsl:apply-templates select="/" mode="M333"/>
      <xsl:apply-templates select="/" mode="M334"/>
      <xsl:apply-templates select="/" mode="M335"/>
      <xsl:apply-templates select="/" mode="M336"/>
      <xsl:apply-templates select="/" mode="M337"/>
      <xsl:apply-templates select="/" mode="M338"/>
      <xsl:apply-templates select="/" mode="M339"/>
      <xsl:apply-templates select="/" mode="M340"/>
      <xsl:apply-templates select="/" mode="M341"/>
      <xsl:apply-templates select="/" mode="M342"/>
      <xsl:apply-templates select="/" mode="M343"/>
      <xsl:apply-templates select="/" mode="M344"/>
      <xsl:apply-templates select="/" mode="M345"/>
      <xsl:apply-templates select="/" mode="M346"/>
      <xsl:apply-templates select="/" mode="M347"/>
      <xsl:apply-templates select="/" mode="M348"/>
      <xsl:apply-templates select="/" mode="M349"/>
      <xsl:apply-templates select="/" mode="M350"/>
      <xsl:apply-templates select="/" mode="M351"/>
      <xsl:apply-templates select="/" mode="M352"/>
      <xsl:apply-templates select="/" mode="M353"/>
      <xsl:apply-templates select="/" mode="M354"/>
      <xsl:apply-templates select="/" mode="M355"/>
      <xsl:apply-templates select="/" mode="M356"/>
      <xsl:apply-templates select="/" mode="M357"/>
      <xsl:apply-templates select="/" mode="M358"/>
      <xsl:apply-templates select="/" mode="M359"/>
      <xsl:apply-templates select="/" mode="M360"/>
      <xsl:apply-templates select="/" mode="M361"/>
      <xsl:apply-templates select="/" mode="M362"/>
      <xsl:apply-templates select="/" mode="M363"/>
      <xsl:apply-templates select="/" mode="M364"/>
      <xsl:apply-templates select="/" mode="M365"/>
      <xsl:apply-templates select="/" mode="M366"/>
      <xsl:apply-templates select="/" mode="M367"/>
      <xsl:apply-templates select="/" mode="M368"/>
      <xsl:apply-templates select="/" mode="M369"/>
      <xsl:apply-templates select="/" mode="M370"/>
      <xsl:apply-templates select="/" mode="M371"/>
      <xsl:apply-templates select="/" mode="M372"/>
      <xsl:apply-templates select="/" mode="M373"/>
      <xsl:apply-templates select="/" mode="M374"/>
      <xsl:apply-templates select="/" mode="M375"/>
      <xsl:apply-templates select="/" mode="M376"/>
      <xsl:apply-templates select="/" mode="M377"/>
      <xsl:apply-templates select="/" mode="M378"/>
      <xsl:apply-templates select="/" mode="M379"/>
      <xsl:apply-templates select="/" mode="M380"/>
      <xsl:apply-templates select="/" mode="M381"/>
      <xsl:apply-templates select="/" mode="M382"/>
      <xsl:apply-templates select="/" mode="M383"/>
      <xsl:apply-templates select="/" mode="M384"/>
      <xsl:apply-templates select="/" mode="M385"/>
      <xsl:apply-templates select="/" mode="M386"/>
      <xsl:apply-templates select="/" mode="M387"/>
      <xsl:apply-templates select="/" mode="M388"/>
      <xsl:apply-templates select="/" mode="M389"/>
      <xsl:apply-templates select="/" mode="M390"/>
      <xsl:apply-templates select="/" mode="M391"/>
      <xsl:apply-templates select="/" mode="M392"/>
      <xsl:apply-templates select="/" mode="M393"/>
      <xsl:apply-templates select="/" mode="M394"/>
      <xsl:apply-templates select="/" mode="M395"/>
      <xsl:apply-templates select="/" mode="M396"/>
      <xsl:apply-templates select="/" mode="M397"/>
      <xsl:apply-templates select="/" mode="M398"/>
      <xsl:apply-templates select="/" mode="M399"/>
      <xsl:apply-templates select="/" mode="M400"/>
      <xsl:apply-templates select="/" mode="M401"/>
      <xsl:apply-templates select="/" mode="M402"/>
      <xsl:apply-templates select="/" mode="M403"/>
      <xsl:apply-templates select="/" mode="M404"/>
      <xsl:apply-templates select="/" mode="M405"/>
      <xsl:apply-templates select="/" mode="M406"/>
      <xsl:apply-templates select="/" mode="M407"/>
      <xsl:apply-templates select="/" mode="M408"/>
      <xsl:apply-templates select="/" mode="M409"/>
      <xsl:apply-templates select="/" mode="M410"/>
      <xsl:apply-templates select="/" mode="M411"/>
      <xsl:apply-templates select="/" mode="M412"/>
      <xsl:apply-templates select="/" mode="M413"/>
      <xsl:apply-templates select="/" mode="M414"/>
      <xsl:apply-templates select="/" mode="M415"/>
      <xsl:apply-templates select="/" mode="M416"/>
      <xsl:apply-templates select="/" mode="M417"/>
      <xsl:apply-templates select="/" mode="M418"/>
      <xsl:apply-templates select="/" mode="M419"/>
      <xsl:apply-templates select="/" mode="M420"/>
      <xsl:apply-templates select="/" mode="M421"/>
      <xsl:apply-templates select="/" mode="M422"/>
      <xsl:apply-templates select="/" mode="M423"/>
      <xsl:apply-templates select="/" mode="M424"/>
      <xsl:apply-templates select="/" mode="M425"/>
      <xsl:apply-templates select="/" mode="M426"/>
      <xsl:apply-templates select="/" mode="M427"/>
      <xsl:apply-templates select="/" mode="M428"/>
      <xsl:apply-templates select="/" mode="M429"/>
      <xsl:apply-templates select="/" mode="M430"/>
      <xsl:apply-templates select="/" mode="M431"/>
      <xsl:apply-templates select="/" mode="M432"/>
      <xsl:apply-templates select="/" mode="M433"/>
      <xsl:apply-templates select="/" mode="M434"/>
      <xsl:apply-templates select="/" mode="M435"/>
      <xsl:apply-templates select="/" mode="M436"/>
      <xsl:apply-templates select="/" mode="M437"/>
      <xsl:apply-templates select="/" mode="M438"/>
      <xsl:apply-templates select="/" mode="M439"/>
      <xsl:apply-templates select="/" mode="M440"/>
      <xsl:apply-templates select="/" mode="M441"/>
      <xsl:apply-templates select="/" mode="M442"/>
      <xsl:apply-templates select="/" mode="M443"/>
      <xsl:apply-templates select="/" mode="M444"/>
      <xsl:apply-templates select="/" mode="M445"/>
      <xsl:apply-templates select="/" mode="M446"/>
      <xsl:apply-templates select="/" mode="M447"/>
      <xsl:apply-templates select="/" mode="M448"/>
      <xsl:apply-templates select="/" mode="M449"/>
      <xsl:apply-templates select="/" mode="M450"/>
      <xsl:apply-templates select="/" mode="M451"/>
      <xsl:apply-templates select="/" mode="M452"/>
      <xsl:apply-templates select="/" mode="M453"/>
      <xsl:apply-templates select="/" mode="M454"/>
      <xsl:apply-templates select="/" mode="M455"/>
      <xsl:apply-templates select="/" mode="M456"/>
      <xsl:apply-templates select="/" mode="M457"/>
      <xsl:apply-templates select="/" mode="M458"/>
      <xsl:apply-templates select="/" mode="M459"/>
      <xsl:apply-templates select="/" mode="M460"/>
      <xsl:apply-templates select="/" mode="M461"/>
      <xsl:apply-templates select="/" mode="M462"/>
      <xsl:apply-templates select="/" mode="M463"/>
      <xsl:apply-templates select="/" mode="M464"/>
      <xsl:apply-templates select="/" mode="M465"/>
      <xsl:apply-templates select="/" mode="M466"/>
      <xsl:apply-templates select="/" mode="M467"/>
      <xsl:apply-templates select="/" mode="M468"/>
      <xsl:apply-templates select="/" mode="M469"/>
      <xsl:apply-templates select="/" mode="M470"/>
      <xsl:apply-templates select="/" mode="M471"/>
      <xsl:apply-templates select="/" mode="M472"/>
      <xsl:apply-templates select="/" mode="M473"/>
      <xsl:apply-templates select="/" mode="M474"/>
      <xsl:apply-templates select="/" mode="M475"/>
      <xsl:apply-templates select="/" mode="M476"/>
      <xsl:apply-templates select="/" mode="M477"/>
      <xsl:apply-templates select="/" mode="M478"/>
      <xsl:apply-templates select="/" mode="M479"/>
      <xsl:apply-templates select="/" mode="M480"/>
      <xsl:apply-templates select="/" mode="M481"/>
      <xsl:apply-templates select="/" mode="M482"/>
      <xsl:apply-templates select="/" mode="M483"/>
      <xsl:apply-templates select="/" mode="M484"/>
      <xsl:apply-templates select="/" mode="M485"/>
      <xsl:apply-templates select="/" mode="M486"/>
      <xsl:apply-templates select="/" mode="M487"/>
      <xsl:apply-templates select="/" mode="M488"/>
      <xsl:apply-templates select="/" mode="M489"/>
      <xsl:apply-templates select="/" mode="M490"/>
      <xsl:apply-templates select="/" mode="M491"/>
      <xsl:apply-templates select="/" mode="M492"/>
      <xsl:apply-templates select="/" mode="M493"/>
      <xsl:apply-templates select="/" mode="M494"/>
      <xsl:apply-templates select="/" mode="M495"/>
      <xsl:apply-templates select="/" mode="M496"/>
      <xsl:apply-templates select="/" mode="M497"/>
      <xsl:apply-templates select="/" mode="M498"/>
      <xsl:apply-templates select="/" mode="M499"/>
      <xsl:apply-templates select="/" mode="M500"/>
      <xsl:apply-templates select="/" mode="M501"/>
      <xsl:apply-templates select="/" mode="M502"/>
      <xsl:apply-templates select="/" mode="M503"/>
      <xsl:apply-templates select="/" mode="M504"/>
      <xsl:apply-templates select="/" mode="M505"/>
      <xsl:apply-templates select="/" mode="M506"/>
      <xsl:apply-templates select="/" mode="M507"/>
      <xsl:apply-templates select="/" mode="M508"/>
      <xsl:apply-templates select="/" mode="M509"/>
      <xsl:apply-templates select="/" mode="M510"/>
      <xsl:apply-templates select="/" mode="M511"/>
      <xsl:apply-templates select="/" mode="M512"/>
      <xsl:apply-templates select="/" mode="M513"/>
      <xsl:apply-templates select="/" mode="M514"/>
      <xsl:apply-templates select="/" mode="M515"/>
      <xsl:apply-templates select="/" mode="M516"/>
      <xsl:apply-templates select="/" mode="M517"/>
      <xsl:apply-templates select="/" mode="M518"/>
      <xsl:apply-templates select="/" mode="M519"/>
      <xsl:apply-templates select="/" mode="M520"/>
      <xsl:apply-templates select="/" mode="M521"/>
      <xsl:apply-templates select="/" mode="M522"/>
      <xsl:apply-templates select="/" mode="M523"/>
      <xsl:apply-templates select="/" mode="M524"/>
      <xsl:apply-templates select="/" mode="M525"/>
      <xsl:apply-templates select="/" mode="M526"/>
      <xsl:apply-templates select="/" mode="M527"/>
      <xsl:apply-templates select="/" mode="M528"/>
      <xsl:apply-templates select="/" mode="M529"/>
      <xsl:apply-templates select="/" mode="M530"/>
      <xsl:apply-templates select="/" mode="M531"/>
      <xsl:apply-templates select="/" mode="M532"/>
      <xsl:apply-templates select="/" mode="M533"/>
      <xsl:apply-templates select="/" mode="M534"/>
      <xsl:apply-templates select="/" mode="M535"/>
      <xsl:apply-templates select="/" mode="M536"/>
      <xsl:apply-templates select="/" mode="M537"/>
      <xsl:apply-templates select="/" mode="M538"/>
      <xsl:apply-templates select="/" mode="M539"/>
      <xsl:apply-templates select="/" mode="M540"/>
      <xsl:apply-templates select="/" mode="M541"/>
      <xsl:apply-templates select="/" mode="M542"/>
      <xsl:apply-templates select="/" mode="M543"/>
      <xsl:apply-templates select="/" mode="M544"/>
      <xsl:apply-templates select="/" mode="M545"/>
      <xsl:apply-templates select="/" mode="M546"/>
      <xsl:apply-templates select="/" mode="M547"/>
      <xsl:apply-templates select="/" mode="M548"/>
      <xsl:apply-templates select="/" mode="M549"/>
      <xsl:apply-templates select="/" mode="M550"/>
      <xsl:apply-templates select="/" mode="M551"/>
      <xsl:apply-templates select="/" mode="M552"/>
      <xsl:apply-templates select="/" mode="M553"/>
      <xsl:apply-templates select="/" mode="M554"/>
      <xsl:apply-templates select="/" mode="M555"/>
      <xsl:apply-templates select="/" mode="M556"/>
      <xsl:apply-templates select="/" mode="M557"/>
      <xsl:apply-templates select="/" mode="M558"/>
      <xsl:apply-templates select="/" mode="M559"/>
      <xsl:apply-templates select="/" mode="M560"/>
      <xsl:apply-templates select="/" mode="M561"/>
      <xsl:apply-templates select="/" mode="M562"/>
      <xsl:apply-templates select="/" mode="M563"/>
      <xsl:apply-templates select="/" mode="M564"/>
      <xsl:apply-templates select="/" mode="M565"/>
      <xsl:apply-templates select="/" mode="M566"/>
      <xsl:apply-templates select="/" mode="M567"/>
      <xsl:apply-templates select="/" mode="M568"/>
      <xsl:apply-templates select="/" mode="M569"/>
      <xsl:apply-templates select="/" mode="M570"/>
      <xsl:apply-templates select="/" mode="M571"/>
      <xsl:apply-templates select="/" mode="M572"/>
      <xsl:apply-templates select="/" mode="M573"/>
      <xsl:apply-templates select="/" mode="M574"/>
      <xsl:apply-templates select="/" mode="M575"/>
      <xsl:apply-templates select="/" mode="M576"/>
      <xsl:apply-templates select="/" mode="M577"/>
      <xsl:apply-templates select="/" mode="M578"/>
      <xsl:apply-templates select="/" mode="M579"/>
      <xsl:apply-templates select="/" mode="M580"/>
      <xsl:apply-templates select="/" mode="M581"/>
      <xsl:apply-templates select="/" mode="M582"/>
      <xsl:apply-templates select="/" mode="M583"/>
      <xsl:apply-templates select="/" mode="M584"/>
      <xsl:apply-templates select="/" mode="M585"/>
      <xsl:apply-templates select="/" mode="M586"/>
      <xsl:apply-templates select="/" mode="M587"/>
      <xsl:apply-templates select="/" mode="M588"/>
      <xsl:apply-templates select="/" mode="M589"/>
      <xsl:apply-templates select="/" mode="M590"/>
      <xsl:apply-templates select="/" mode="M591"/>
      <xsl:apply-templates select="/" mode="M592"/>
      <xsl:apply-templates select="/" mode="M593"/>
      <xsl:apply-templates select="/" mode="M594"/>
      <xsl:apply-templates select="/" mode="M595"/>
      <xsl:apply-templates select="/" mode="M596"/>
      <xsl:apply-templates select="/" mode="M597"/>
      <xsl:apply-templates select="/" mode="M598"/>
      <xsl:apply-templates select="/" mode="M599"/>
      <xsl:apply-templates select="/" mode="M600"/>
      <xsl:apply-templates select="/" mode="M601"/>
      <xsl:apply-templates select="/" mode="M602"/>
      <xsl:apply-templates select="/" mode="M603"/>
      <xsl:apply-templates select="/" mode="M604"/>
      <xsl:apply-templates select="/" mode="M605"/>
      <xsl:apply-templates select="/" mode="M606"/>
      <xsl:apply-templates select="/" mode="M607"/>
      <xsl:apply-templates select="/" mode="M608"/>
      <xsl:apply-templates select="/" mode="M609"/>
      <xsl:apply-templates select="/" mode="M610"/>
      <xsl:apply-templates select="/" mode="M611"/>
      <xsl:apply-templates select="/" mode="M612"/>
      <xsl:apply-templates select="/" mode="M613"/>
      <xsl:apply-templates select="/" mode="M614"/>
      <xsl:apply-templates select="/" mode="M615"/>
      <xsl:apply-templates select="/" mode="M616"/>
      <xsl:apply-templates select="/" mode="M617"/>
      <xsl:apply-templates select="/" mode="M618"/>
      <xsl:apply-templates select="/" mode="M619"/>
      <xsl:apply-templates select="/" mode="M620"/>
      <xsl:apply-templates select="/" mode="M621"/>
      <xsl:apply-templates select="/" mode="M622"/>
      <xsl:apply-templates select="/" mode="M623"/>
      <xsl:apply-templates select="/" mode="M624"/>
      <xsl:apply-templates select="/" mode="M625"/>
      <xsl:apply-templates select="/" mode="M626"/>
      <xsl:apply-templates select="/" mode="M627"/>
      <xsl:apply-templates select="/" mode="M628"/>
      <xsl:apply-templates select="/" mode="M629"/>
      <xsl:apply-templates select="/" mode="M630"/>
      <xsl:apply-templates select="/" mode="M631"/>
      <xsl:apply-templates select="/" mode="M632"/>
      <xsl:apply-templates select="/" mode="M633"/>
      <xsl:apply-templates select="/" mode="M634"/>
      <xsl:apply-templates select="/" mode="M635"/>
      <xsl:apply-templates select="/" mode="M636"/>
      <xsl:apply-templates select="/" mode="M637"/>
      <xsl:apply-templates select="/" mode="M638"/>
      <xsl:apply-templates select="/" mode="M639"/>
      <xsl:apply-templates select="/" mode="M640"/>
      <xsl:apply-templates select="/" mode="M641"/>
      <xsl:apply-templates select="/" mode="M642"/>
      <xsl:apply-templates select="/" mode="M643"/>
      <xsl:apply-templates select="/" mode="M644"/>
      <xsl:apply-templates select="/" mode="M645"/>
      <xsl:apply-templates select="/" mode="M646"/>
      <xsl:apply-templates select="/" mode="M647"/>
      <xsl:apply-templates select="/" mode="M648"/>
      <xsl:apply-templates select="/" mode="M649"/>
      <xsl:apply-templates select="/" mode="M650"/>
      <xsl:apply-templates select="/" mode="M651"/>
      <xsl:apply-templates select="/" mode="M652"/>
      <xsl:apply-templates select="/" mode="M653"/>
      <xsl:apply-templates select="/" mode="M654"/>
      <xsl:apply-templates select="/" mode="M655"/>
      <xsl:apply-templates select="/" mode="M656"/>
      <xsl:apply-templates select="/" mode="M657"/>
      <xsl:apply-templates select="/" mode="M658"/>
      <xsl:apply-templates select="/" mode="M659"/>
      <xsl:apply-templates select="/" mode="M660"/>
      <xsl:apply-templates select="/" mode="M661"/>
      <xsl:apply-templates select="/" mode="M662"/>
      <xsl:apply-templates select="/" mode="M663"/>
      <xsl:apply-templates select="/" mode="M664"/>
      <xsl:apply-templates select="/" mode="M665"/>
      <xsl:apply-templates select="/" mode="M666"/>
      <xsl:apply-templates select="/" mode="M667"/>
      <xsl:apply-templates select="/" mode="M668"/>
      <xsl:apply-templates select="/" mode="M669"/>
      <xsl:apply-templates select="/" mode="M670"/>
      <xsl:apply-templates select="/" mode="M671"/>
      <xsl:apply-templates select="/" mode="M672"/>
      <xsl:apply-templates select="/" mode="M673"/>
      <xsl:apply-templates select="/" mode="M674"/>
      <xsl:apply-templates select="/" mode="M675"/>
      <xsl:apply-templates select="/" mode="M676"/>
      <xsl:apply-templates select="/" mode="M677"/>
      <xsl:apply-templates select="/" mode="M678"/>
      <xsl:apply-templates select="/" mode="M679"/>
      <xsl:apply-templates select="/" mode="M680"/>
      <xsl:apply-templates select="/" mode="M681"/>
      <xsl:apply-templates select="/" mode="M682"/>
      <xsl:apply-templates select="/" mode="M683"/>
      <xsl:apply-templates select="/" mode="M684"/>
      <xsl:apply-templates select="/" mode="M685"/>
      <xsl:apply-templates select="/" mode="M686"/>
      <xsl:apply-templates select="/" mode="M687"/>
      <xsl:apply-templates select="/" mode="M688"/>
      <xsl:apply-templates select="/" mode="M689"/>
      <xsl:apply-templates select="/" mode="M690"/>
      <xsl:apply-templates select="/" mode="M691"/>
      <xsl:apply-templates select="/" mode="M692"/>
      <xsl:apply-templates select="/" mode="M693"/>
      <xsl:apply-templates select="/" mode="M694"/>
      <xsl:apply-templates select="/" mode="M695"/>
      <xsl:apply-templates select="/" mode="M696"/>
      <xsl:apply-templates select="/" mode="M697"/>
      <xsl:apply-templates select="/" mode="M698"/>
      <xsl:apply-templates select="/" mode="M699"/>
      <xsl:apply-templates select="/" mode="M700"/>
      <xsl:apply-templates select="/" mode="M701"/>
      <xsl:apply-templates select="/" mode="M702"/>
      <xsl:apply-templates select="/" mode="M703"/>
      <xsl:apply-templates select="/" mode="M704"/>
      <xsl:apply-templates select="/" mode="M705"/>
      <xsl:apply-templates select="/" mode="M706"/>
      <xsl:apply-templates select="/" mode="M707"/>
      <xsl:apply-templates select="/" mode="M708"/>
      <xsl:apply-templates select="/" mode="M709"/>
      <xsl:apply-templates select="/" mode="M710"/>
      <xsl:apply-templates select="/" mode="M711"/>
      <xsl:apply-templates select="/" mode="M712"/>
      <xsl:apply-templates select="/" mode="M713"/>
      <xsl:apply-templates select="/" mode="M714"/>
      <xsl:apply-templates select="/" mode="M715"/>
      <xsl:apply-templates select="/" mode="M716"/>
      <xsl:apply-templates select="/" mode="M717"/>
      <xsl:apply-templates select="/" mode="M718"/>
      <xsl:apply-templates select="/" mode="M719"/>
      <xsl:apply-templates select="/" mode="M720"/>
      <xsl:apply-templates select="/" mode="M721"/>
      <xsl:apply-templates select="/" mode="M722"/>
      <xsl:apply-templates select="/" mode="M723"/>
      <xsl:apply-templates select="/" mode="M724"/>
      <xsl:apply-templates select="/" mode="M725"/>
      <xsl:apply-templates select="/" mode="M726"/>
      <xsl:apply-templates select="/" mode="M727"/>
      <xsl:apply-templates select="/" mode="M728"/>
      <xsl:apply-templates select="/" mode="M729"/>
      <xsl:apply-templates select="/" mode="M730"/>
      <xsl:apply-templates select="/" mode="M731"/>
      <xsl:apply-templates select="/" mode="M732"/>
      <xsl:apply-templates select="/" mode="M733"/>
      <xsl:apply-templates select="/" mode="M734"/>
      <xsl:apply-templates select="/" mode="M735"/>
      <xsl:apply-templates select="/" mode="M736"/>
      <xsl:apply-templates select="/" mode="M737"/>
      <xsl:apply-templates select="/" mode="M738"/>
      <xsl:apply-templates select="/" mode="M739"/>
      <xsl:apply-templates select="/" mode="M740"/>
      <xsl:apply-templates select="/" mode="M741"/>
      <xsl:apply-templates select="/" mode="M742"/>
      <xsl:apply-templates select="/" mode="M743"/>
      <xsl:apply-templates select="/" mode="M744"/>
      <xsl:apply-templates select="/" mode="M745"/>
      <xsl:apply-templates select="/" mode="M746"/>
      <xsl:apply-templates select="/" mode="M747"/>
      <xsl:apply-templates select="/" mode="M748"/>
      <xsl:apply-templates select="/" mode="M749"/>
      <xsl:apply-templates select="/" mode="M750"/>
      <xsl:apply-templates select="/" mode="M751"/>
      <xsl:apply-templates select="/" mode="M752"/>
      <xsl:apply-templates select="/" mode="M753"/>
      <xsl:apply-templates select="/" mode="M754"/>
      <xsl:apply-templates select="/" mode="M755"/>
      <xsl:apply-templates select="/" mode="M756"/>
      <xsl:apply-templates select="/" mode="M757"/>
      <xsl:apply-templates select="/" mode="M758"/>
      <xsl:apply-templates select="/" mode="M759"/>
      <xsl:apply-templates select="/" mode="M760"/>
      <xsl:apply-templates select="/" mode="M761"/>
      <xsl:apply-templates select="/" mode="M762"/>
      <xsl:apply-templates select="/" mode="M763"/>
      <xsl:apply-templates select="/" mode="M764"/>
      <xsl:apply-templates select="/" mode="M765"/>
      <xsl:apply-templates select="/" mode="M766"/>
      <xsl:apply-templates select="/" mode="M767"/>
      <xsl:apply-templates select="/" mode="M768"/>
      <xsl:apply-templates select="/" mode="M769"/>
      <xsl:apply-templates select="/" mode="M770"/>
      <xsl:apply-templates select="/" mode="M771"/>
      <xsl:apply-templates select="/" mode="M772"/>
      <xsl:apply-templates select="/" mode="M773"/>
      <xsl:apply-templates select="/" mode="M774"/>
      <xsl:apply-templates select="/" mode="M775"/>
      <xsl:apply-templates select="/" mode="M776"/>
      <xsl:apply-templates select="/" mode="M777"/>
      <xsl:apply-templates select="/" mode="M778"/>
      <xsl:apply-templates select="/" mode="M779"/>
      <xsl:apply-templates select="/" mode="M780"/>
      <xsl:apply-templates select="/" mode="M781"/>
      <xsl:apply-templates select="/" mode="M782"/>
      <xsl:apply-templates select="/" mode="M783"/>
      <xsl:apply-templates select="/" mode="M784"/>
      <xsl:apply-templates select="/" mode="M785"/>
      <xsl:apply-templates select="/" mode="M786"/>
      <xsl:apply-templates select="/" mode="M787"/>
      <xsl:apply-templates select="/" mode="M788"/>
      <xsl:apply-templates select="/" mode="M789"/>
      <xsl:apply-templates select="/" mode="M790"/>
      <xsl:apply-templates select="/" mode="M791"/>
      <xsl:apply-templates select="/" mode="M792"/>
      <xsl:apply-templates select="/" mode="M793"/>
      <xsl:apply-templates select="/" mode="M794"/>
      <xsl:apply-templates select="/" mode="M795"/>
      <xsl:apply-templates select="/" mode="M796"/>
      <xsl:apply-templates select="/" mode="M797"/>
      <xsl:apply-templates select="/" mode="M798"/>
      <xsl:apply-templates select="/" mode="M799"/>
      <xsl:apply-templates select="/" mode="M800"/>
      <xsl:apply-templates select="/" mode="M801"/>
      <xsl:apply-templates select="/" mode="M802"/>
      <xsl:apply-templates select="/" mode="M803"/>
      <xsl:apply-templates select="/" mode="M804"/>
      <xsl:apply-templates select="/" mode="M805"/>
      <xsl:apply-templates select="/" mode="M806"/>
      <xsl:apply-templates select="/" mode="M807"/>
      <xsl:apply-templates select="/" mode="M808"/>
      <xsl:apply-templates select="/" mode="M809"/>
      <xsl:apply-templates select="/" mode="M810"/>
      <xsl:apply-templates select="/" mode="M811"/>
      <xsl:apply-templates select="/" mode="M812"/>
      <xsl:apply-templates select="/" mode="M813"/>
      <xsl:apply-templates select="/" mode="M814"/>
      <xsl:apply-templates select="/" mode="M815"/>
      <xsl:apply-templates select="/" mode="M816"/>
      <xsl:apply-templates select="/" mode="M817"/>
      <xsl:apply-templates select="/" mode="M818"/>
      <xsl:apply-templates select="/" mode="M819"/>
      <xsl:apply-templates select="/" mode="M820"/>
      <xsl:apply-templates select="/" mode="M821"/>
      <xsl:apply-templates select="/" mode="M822"/>
      <xsl:apply-templates select="/" mode="M823"/>
      <xsl:apply-templates select="/" mode="M824"/>
      <xsl:apply-templates select="/" mode="M825"/>
      <xsl:apply-templates select="/" mode="M826"/>
      <xsl:apply-templates select="/" mode="M827"/>
      <xsl:apply-templates select="/" mode="M828"/>
      <xsl:apply-templates select="/" mode="M829"/>
      <xsl:apply-templates select="/" mode="M830"/>
      <xsl:apply-templates select="/" mode="M831"/>
      <xsl:apply-templates select="/" mode="M832"/>
      <xsl:apply-templates select="/" mode="M833"/>
      <xsl:apply-templates select="/" mode="M834"/>
      <xsl:apply-templates select="/" mode="M835"/>
      <xsl:apply-templates select="/" mode="M836"/>
      <xsl:apply-templates select="/" mode="M837"/>
      <xsl:apply-templates select="/" mode="M838"/>
      <xsl:apply-templates select="/" mode="M839"/>
      <xsl:apply-templates select="/" mode="M840"/>
      <xsl:apply-templates select="/" mode="M841"/>
      <xsl:apply-templates select="/" mode="M842"/>
      <xsl:apply-templates select="/" mode="M843"/>
      <xsl:apply-templates select="/" mode="M844"/>
      <xsl:apply-templates select="/" mode="M845"/>
      <xsl:apply-templates select="/" mode="M846"/>
      <xsl:apply-templates select="/" mode="M847"/>
      <xsl:apply-templates select="/" mode="M848"/>
      <xsl:apply-templates select="/" mode="M849"/>
      <xsl:apply-templates select="/" mode="M850"/>
      <xsl:apply-templates select="/" mode="M851"/>
      <xsl:apply-templates select="/" mode="M852"/>
      <xsl:apply-templates select="/" mode="M853"/>
      <xsl:apply-templates select="/" mode="M854"/>
      <xsl:apply-templates select="/" mode="M855"/>
      <xsl:apply-templates select="/" mode="M856"/>
      <xsl:apply-templates select="/" mode="M857"/>
      <xsl:apply-templates select="/" mode="M858"/>
      <xsl:apply-templates select="/" mode="M859"/>
      <xsl:apply-templates select="/" mode="M860"/>
      <xsl:apply-templates select="/" mode="M861"/>
      <xsl:apply-templates select="/" mode="M862"/>
      <xsl:apply-templates select="/" mode="M863"/>
      <xsl:apply-templates select="/" mode="M864"/>
      <xsl:apply-templates select="/" mode="M865"/>
      <xsl:apply-templates select="/" mode="M866"/>
      <xsl:apply-templates select="/" mode="M867"/>
      <xsl:apply-templates select="/" mode="M868"/>
      <xsl:apply-templates select="/" mode="M869"/>
      <xsl:apply-templates select="/" mode="M870"/>
      <xsl:apply-templates select="/" mode="M871"/>
      <xsl:apply-templates select="/" mode="M872"/>
      <xsl:apply-templates select="/" mode="M873"/>
      <xsl:apply-templates select="/" mode="M874"/>
      <xsl:apply-templates select="/" mode="M875"/>
      <xsl:apply-templates select="/" mode="M876"/>
      <xsl:apply-templates select="/" mode="M877"/>
      <xsl:apply-templates select="/" mode="M878"/>
      <xsl:apply-templates select="/" mode="M879"/>
      <xsl:apply-templates select="/" mode="M880"/>
      <xsl:apply-templates select="/" mode="M881"/>
      <xsl:apply-templates select="/" mode="M882"/>
      <xsl:apply-templates select="/" mode="M883"/>
      <xsl:apply-templates select="/" mode="M884"/>
      <xsl:apply-templates select="/" mode="M885"/>
      <xsl:apply-templates select="/" mode="M886"/>
      <xsl:apply-templates select="/" mode="M887"/>
      <xsl:apply-templates select="/" mode="M888"/>
      <xsl:apply-templates select="/" mode="M889"/>
      <xsl:apply-templates select="/" mode="M890"/>
      <xsl:apply-templates select="/" mode="M891"/>
      <xsl:apply-templates select="/" mode="M892"/>
      <xsl:apply-templates select="/" mode="M893"/>
      <xsl:apply-templates select="/" mode="M894"/>
      <xsl:apply-templates select="/" mode="M895"/>
      <xsl:apply-templates select="/" mode="M896"/>
      <xsl:apply-templates select="/" mode="M897"/>
      <xsl:apply-templates select="/" mode="M898"/>
      <xsl:apply-templates select="/" mode="M899"/>
      <xsl:apply-templates select="/" mode="M900"/>
      <xsl:apply-templates select="/" mode="M901"/>
      <xsl:apply-templates select="/" mode="M902"/>
      <xsl:apply-templates select="/" mode="M903"/>
      <xsl:apply-templates select="/" mode="M904"/>
      <xsl:apply-templates select="/" mode="M905"/>
      <xsl:apply-templates select="/" mode="M906"/>
      <xsl:apply-templates select="/" mode="M907"/>
      <xsl:apply-templates select="/" mode="M908"/>
      <xsl:apply-templates select="/" mode="M909"/>
      <xsl:apply-templates select="/" mode="M910"/>
      <xsl:apply-templates select="/" mode="M911"/>
      <xsl:apply-templates select="/" mode="M912"/>
      <xsl:apply-templates select="/" mode="M913"/>
      <xsl:apply-templates select="/" mode="M914"/>
      <xsl:apply-templates select="/" mode="M915"/>
      <xsl:apply-templates select="/" mode="M916"/>
      <xsl:apply-templates select="/" mode="M917"/>
      <xsl:apply-templates select="/" mode="M918"/>
      <xsl:apply-templates select="/" mode="M919"/>
      <xsl:apply-templates select="/" mode="M920"/>
      <xsl:apply-templates select="/" mode="M921"/>
      <xsl:apply-templates select="/" mode="M922"/>
      <xsl:apply-templates select="/" mode="M923"/>
      <xsl:apply-templates select="/" mode="M924"/>
      <xsl:apply-templates select="/" mode="M925"/>
      <xsl:apply-templates select="/" mode="M926"/>
      <xsl:apply-templates select="/" mode="M927"/>
      <xsl:apply-templates select="/" mode="M928"/>
      <xsl:apply-templates select="/" mode="M929"/>
      <xsl:apply-templates select="/" mode="M930"/>
      <xsl:apply-templates select="/" mode="M931"/>
      <xsl:apply-templates select="/" mode="M932"/>
      <xsl:apply-templates select="/" mode="M933"/>
      <xsl:apply-templates select="/" mode="M934"/>
      <xsl:apply-templates select="/" mode="M935"/>
      <xsl:apply-templates select="/" mode="M936"/>
      <xsl:apply-templates select="/" mode="M937"/>
      <xsl:apply-templates select="/" mode="M938"/>
      <xsl:apply-templates select="/" mode="M939"/>
      <xsl:apply-templates select="/" mode="M940"/>
      <xsl:apply-templates select="/" mode="M941"/>
      <xsl:apply-templates select="/" mode="M942"/>
      <xsl:apply-templates select="/" mode="M943"/>
      <xsl:apply-templates select="/" mode="M944"/>
      <xsl:apply-templates select="/" mode="M945"/>
      <xsl:apply-templates select="/" mode="M946"/>
      <xsl:apply-templates select="/" mode="M947"/>
      <xsl:apply-templates select="/" mode="M948"/>
      <xsl:apply-templates select="/" mode="M949"/>
      <xsl:apply-templates select="/" mode="M950"/>
      <xsl:apply-templates select="/" mode="M951"/>
      <xsl:apply-templates select="/" mode="M952"/>
      <xsl:apply-templates select="/" mode="M953"/>
      <xsl:apply-templates select="/" mode="M954"/>
      <xsl:apply-templates select="/" mode="M955"/>
      <xsl:apply-templates select="/" mode="M956"/>
      <xsl:apply-templates select="/" mode="M957"/>
      <xsl:apply-templates select="/" mode="M958"/>
      <xsl:apply-templates select="/" mode="M959"/>
      <xsl:apply-templates select="/" mode="M960"/>
      <xsl:apply-templates select="/" mode="M961"/>
      <xsl:apply-templates select="/" mode="M962"/>
      <xsl:apply-templates select="/" mode="M963"/>
      <xsl:apply-templates select="/" mode="M964"/>
      <xsl:apply-templates select="/" mode="M965"/>
      <xsl:apply-templates select="/" mode="M966"/>
      <xsl:apply-templates select="/" mode="M967"/>
      <xsl:apply-templates select="/" mode="M968"/>
      <xsl:apply-templates select="/" mode="M969"/>
      <xsl:apply-templates select="/" mode="M970"/>
      <xsl:apply-templates select="/" mode="M971"/>
      <xsl:apply-templates select="/" mode="M972"/>
      <xsl:apply-templates select="/" mode="M973"/>
      <xsl:apply-templates select="/" mode="M974"/>
      <xsl:apply-templates select="/" mode="M975"/>
      <xsl:apply-templates select="/" mode="M976"/>
      <xsl:apply-templates select="/" mode="M977"/>
      <xsl:apply-templates select="/" mode="M978"/>
      <xsl:apply-templates select="/" mode="M979"/>
      <xsl:apply-templates select="/" mode="M980"/>
      <xsl:apply-templates select="/" mode="M981"/>
      <xsl:apply-templates select="/" mode="M982"/>
      <xsl:apply-templates select="/" mode="M983"/>
      <xsl:apply-templates select="/" mode="M984"/>
      <xsl:apply-templates select="/" mode="M985"/>
      <xsl:apply-templates select="/" mode="M986"/>
      <xsl:apply-templates select="/" mode="M987"/>
      <xsl:apply-templates select="/" mode="M988"/>
      <xsl:apply-templates select="/" mode="M989"/>
      <xsl:apply-templates select="/" mode="M990"/>
      <xsl:apply-templates select="/" mode="M991"/>
      <xsl:apply-templates select="/" mode="M992"/>
      <xsl:apply-templates select="/" mode="M993"/>
      <xsl:apply-templates select="/" mode="M994"/>
      <xsl:apply-templates select="/" mode="M995"/>
      <xsl:apply-templates select="/" mode="M996"/>
      <xsl:apply-templates select="/" mode="M997"/>
      <xsl:apply-templates select="/" mode="M998"/>
      <xsl:apply-templates select="/" mode="M999"/>
      <xsl:apply-templates select="/" mode="M1000"/>
      <xsl:apply-templates select="/" mode="M1001"/>
      <xsl:apply-templates select="/" mode="M1002"/>
      <xsl:apply-templates select="/" mode="M1003"/>
      <xsl:apply-templates select="/" mode="M1004"/>
      <xsl:apply-templates select="/" mode="M1005"/>
      <xsl:apply-templates select="/" mode="M1006"/>
      <xsl:apply-templates select="/" mode="M1007"/>
      <xsl:apply-templates select="/" mode="M1008"/>
      <xsl:apply-templates select="/" mode="M1009"/>
      <xsl:apply-templates select="/" mode="M1010"/>
      <xsl:apply-templates select="/" mode="M1011"/>
      <xsl:apply-templates select="/" mode="M1012"/>
      <xsl:apply-templates select="/" mode="M1013"/>
      <xsl:apply-templates select="/" mode="M1014"/>
      <xsl:apply-templates select="/" mode="M1015"/>
      <xsl:apply-templates select="/" mode="M1016"/>
      <xsl:apply-templates select="/" mode="M1017"/>
      <xsl:apply-templates select="/" mode="M1018"/>
      <xsl:apply-templates select="/" mode="M1019"/>
      <xsl:apply-templates select="/" mode="M1020"/>
      <xsl:apply-templates select="/" mode="M1021"/>
      <xsl:apply-templates select="/" mode="M1022"/>
      <xsl:apply-templates select="/" mode="M1023"/>
      <xsl:apply-templates select="/" mode="M1024"/>
      <xsl:apply-templates select="/" mode="M1025"/>
      <xsl:apply-templates select="/" mode="M1026"/>
      <xsl:apply-templates select="/" mode="M1027"/>
      <xsl:apply-templates select="/" mode="M1028"/>
      <xsl:apply-templates select="/" mode="M1029"/>
      <xsl:apply-templates select="/" mode="M1030"/>
      <xsl:apply-templates select="/" mode="M1031"/>
      <xsl:apply-templates select="/" mode="M1032"/>
      <xsl:apply-templates select="/" mode="M1033"/>
      <xsl:apply-templates select="/" mode="M1034"/>
      <xsl:apply-templates select="/" mode="M1035"/>
      <xsl:apply-templates select="/" mode="M1036"/>
      <xsl:apply-templates select="/" mode="M1037"/>
      <xsl:apply-templates select="/" mode="M1038"/>
      <xsl:apply-templates select="/" mode="M1039"/>
      <xsl:apply-templates select="/" mode="M1040"/>
      <xsl:apply-templates select="/" mode="M1041"/>
      <xsl:apply-templates select="/" mode="M1042"/>
      <xsl:apply-templates select="/" mode="M1043"/>
      <xsl:apply-templates select="/" mode="M1044"/>
      <xsl:apply-templates select="/" mode="M1045"/>
      <xsl:apply-templates select="/" mode="M1046"/>
      <xsl:apply-templates select="/" mode="M1047"/>
      <xsl:apply-templates select="/" mode="M1048"/>
      <xsl:apply-templates select="/" mode="M1049"/>
      <xsl:apply-templates select="/" mode="M1050"/>
      <xsl:apply-templates select="/" mode="M1051"/>
      <xsl:apply-templates select="/" mode="M1052"/>
      <xsl:apply-templates select="/" mode="M1053"/>
      <xsl:apply-templates select="/" mode="M1054"/>
      <xsl:apply-templates select="/" mode="M1055"/>
      <xsl:apply-templates select="/" mode="M1056"/>
      <xsl:apply-templates select="/" mode="M1057"/>
      <xsl:apply-templates select="/" mode="M1058"/>
      <xsl:apply-templates select="/" mode="M1059"/>
      <xsl:apply-templates select="/" mode="M1060"/>
      <xsl:apply-templates select="/" mode="M1061"/>
      <xsl:apply-templates select="/" mode="M1062"/>
      <xsl:apply-templates select="/" mode="M1063"/>
      <xsl:apply-templates select="/" mode="M1064"/>
      <xsl:apply-templates select="/" mode="M1065"/>
      <xsl:apply-templates select="/" mode="M1066"/>
      <xsl:apply-templates select="/" mode="M1067"/>
      <xsl:apply-templates select="/" mode="M1068"/>
      <xsl:apply-templates select="/" mode="M1069"/>
      <xsl:apply-templates select="/" mode="M1070"/>
      <xsl:apply-templates select="/" mode="M1071"/>
      <xsl:apply-templates select="/" mode="M1072"/>
      <xsl:apply-templates select="/" mode="M1073"/>
      <xsl:apply-templates select="/" mode="M1074"/>
      <xsl:apply-templates select="/" mode="M1075"/>
      <xsl:apply-templates select="/" mode="M1076"/>
      <xsl:apply-templates select="/" mode="M1077"/>
      <xsl:apply-templates select="/" mode="M1078"/>
      <xsl:apply-templates select="/" mode="M1079"/>
      <xsl:apply-templates select="/" mode="M1080"/>
      <xsl:apply-templates select="/" mode="M1081"/>
      <xsl:apply-templates select="/" mode="M1082"/>
      <xsl:apply-templates select="/" mode="M1083"/>
      <xsl:apply-templates select="/" mode="M1084"/>
      <xsl:apply-templates select="/" mode="M1085"/>
      <xsl:apply-templates select="/" mode="M1086"/>
      <xsl:apply-templates select="/" mode="M1087"/>
      <xsl:apply-templates select="/" mode="M1088"/>
      <xsl:apply-templates select="/" mode="M1089"/>
      <xsl:apply-templates select="/" mode="M1090"/>
      <xsl:apply-templates select="/" mode="M1091"/>
      <xsl:apply-templates select="/" mode="M1092"/>
      <xsl:apply-templates select="/" mode="M1093"/>
      <xsl:apply-templates select="/" mode="M1094"/>
      <xsl:apply-templates select="/" mode="M1095"/>
      <xsl:apply-templates select="/" mode="M1096"/>
      <xsl:apply-templates select="/" mode="M1097"/>
      <xsl:apply-templates select="/" mode="M1098"/>
      <xsl:apply-templates select="/" mode="M1099"/>
      <xsl:apply-templates select="/" mode="M1100"/>
      <xsl:apply-templates select="/" mode="M1101"/>
      <xsl:apply-templates select="/" mode="M1102"/>
      <xsl:apply-templates select="/" mode="M1103"/>
      <xsl:apply-templates select="/" mode="M1104"/>
      <xsl:apply-templates select="/" mode="M1105"/>
      <xsl:apply-templates select="/" mode="M1106"/>
      <xsl:apply-templates select="/" mode="M1107"/>
      <xsl:apply-templates select="/" mode="M1108"/>
      <xsl:apply-templates select="/" mode="M1109"/>
      <xsl:apply-templates select="/" mode="M1110"/>
      <xsl:apply-templates select="/" mode="M1111"/>
      <xsl:apply-templates select="/" mode="M1112"/>
      <xsl:apply-templates select="/" mode="M1113"/>
      <xsl:apply-templates select="/" mode="M1114"/>
      <xsl:apply-templates select="/" mode="M1115"/>
      <xsl:apply-templates select="/" mode="M1116"/>
      <xsl:apply-templates select="/" mode="M1117"/>
      <xsl:apply-templates select="/" mode="M1118"/>
      <xsl:apply-templates select="/" mode="M1119"/>
      <xsl:apply-templates select="/" mode="M1120"/>
      <xsl:apply-templates select="/" mode="M1121"/>
      <xsl:apply-templates select="/" mode="M1122"/>
      <xsl:apply-templates select="/" mode="M1123"/>
      <xsl:apply-templates select="/" mode="M1124"/>
      <xsl:apply-templates select="/" mode="M1125"/>
      <xsl:apply-templates select="/" mode="M1126"/>
      <xsl:apply-templates select="/" mode="M1127"/>
      <xsl:apply-templates select="/" mode="M1128"/>
      <xsl:apply-templates select="/" mode="M1129"/>
      <xsl:apply-templates select="/" mode="M1130"/>
      <xsl:apply-templates select="/" mode="M1131"/>
      <xsl:apply-templates select="/" mode="M1132"/>
      <xsl:apply-templates select="/" mode="M1133"/>
      <xsl:apply-templates select="/" mode="M1134"/>
      <xsl:apply-templates select="/" mode="M1135"/>
      <xsl:apply-templates select="/" mode="M1136"/>
      <xsl:apply-templates select="/" mode="M1137"/>
      <xsl:apply-templates select="/" mode="M1138"/>
      <xsl:apply-templates select="/" mode="M1139"/>
      <xsl:apply-templates select="/" mode="M1140"/>
      <xsl:apply-templates select="/" mode="M1141"/>
      <xsl:apply-templates select="/" mode="M1142"/>
      <xsl:apply-templates select="/" mode="M1143"/>
      <xsl:apply-templates select="/" mode="M1144"/>
      <xsl:apply-templates select="/" mode="M1145"/>
      <xsl:apply-templates select="/" mode="M1146"/>
      <xsl:apply-templates select="/" mode="M1147"/>
      <xsl:apply-templates select="/" mode="M1148"/>
      <xsl:apply-templates select="/" mode="M1149"/>
      <xsl:apply-templates select="/" mode="M1150"/>
      <xsl:apply-templates select="/" mode="M1151"/>
      <xsl:apply-templates select="/" mode="M1152"/>
      <xsl:apply-templates select="/" mode="M1153"/>
      <xsl:apply-templates select="/" mode="M1154"/>
      <xsl:apply-templates select="/" mode="M1155"/>
      <xsl:apply-templates select="/" mode="M1156"/>
      <xsl:apply-templates select="/" mode="M1157"/>
      <xsl:apply-templates select="/" mode="M1158"/>
      <xsl:apply-templates select="/" mode="M1159"/>
      <xsl:apply-templates select="/" mode="M1160"/>
      <xsl:apply-templates select="/" mode="M1161"/>
      <xsl:apply-templates select="/" mode="M1162"/>
      <xsl:apply-templates select="/" mode="M1163"/>
      <xsl:apply-templates select="/" mode="M1164"/>
      <xsl:apply-templates select="/" mode="M1165"/>
      <xsl:apply-templates select="/" mode="M1166"/>
      <xsl:apply-templates select="/" mode="M1167"/>
      <xsl:apply-templates select="/" mode="M1168"/>
      <xsl:apply-templates select="/" mode="M1169"/>
      <xsl:apply-templates select="/" mode="M1170"/>
      <xsl:apply-templates select="/" mode="M1171"/>
      <xsl:apply-templates select="/" mode="M1172"/>
      <xsl:apply-templates select="/" mode="M1173"/>
      <xsl:apply-templates select="/" mode="M1174"/>
      <xsl:apply-templates select="/" mode="M1175"/>
      <xsl:apply-templates select="/" mode="M1176"/>
      <xsl:apply-templates select="/" mode="M1177"/>
      <xsl:apply-templates select="/" mode="M1178"/>
      <xsl:apply-templates select="/" mode="M1179"/>
      <xsl:apply-templates select="/" mode="M1180"/>
      <xsl:apply-templates select="/" mode="M1181"/>
      <xsl:apply-templates select="/" mode="M1182"/>
      <xsl:apply-templates select="/" mode="M1183"/>
      <xsl:apply-templates select="/" mode="M1184"/>
      <xsl:apply-templates select="/" mode="M1185"/>
      <xsl:apply-templates select="/" mode="M1186"/>
      <xsl:apply-templates select="/" mode="M1187"/>
      <xsl:apply-templates select="/" mode="M1188"/>
      <xsl:apply-templates select="/" mode="M1189"/>
      <xsl:apply-templates select="/" mode="M1190"/>
      <xsl:apply-templates select="/" mode="M1191"/>
      <xsl:apply-templates select="/" mode="M1192"/>
      <xsl:apply-templates select="/" mode="M1193"/>
      <xsl:apply-templates select="/" mode="M1194"/>
      <xsl:apply-templates select="/" mode="M1195"/>
      <xsl:apply-templates select="/" mode="M1196"/>
      <xsl:apply-templates select="/" mode="M1197"/>
      <xsl:apply-templates select="/" mode="M1198"/>
      <xsl:apply-templates select="/" mode="M1199"/>
      <xsl:apply-templates select="/" mode="M1200"/>
      <xsl:apply-templates select="/" mode="M1201"/>
      <xsl:apply-templates select="/" mode="M1202"/>
      <xsl:apply-templates select="/" mode="M1203"/>
      <xsl:apply-templates select="/" mode="M1204"/>
      <xsl:apply-templates select="/" mode="M1205"/>
      <xsl:apply-templates select="/" mode="M1206"/>
      <xsl:apply-templates select="/" mode="M1207"/>
      <xsl:apply-templates select="/" mode="M1208"/>
      <xsl:apply-templates select="/" mode="M1209"/>
      <xsl:apply-templates select="/" mode="M1210"/>
      <xsl:apply-templates select="/" mode="M1211"/>
      <xsl:apply-templates select="/" mode="M1212"/>
      <xsl:apply-templates select="/" mode="M1213"/>
      <xsl:apply-templates select="/" mode="M1214"/>
      <xsl:apply-templates select="/" mode="M1215"/>
      <xsl:apply-templates select="/" mode="M1216"/>
      <xsl:apply-templates select="/" mode="M1217"/>
      <xsl:apply-templates select="/" mode="M1218"/>
      <xsl:apply-templates select="/" mode="M1219"/>
      <xsl:apply-templates select="/" mode="M1220"/>
      <xsl:apply-templates select="/" mode="M1221"/>
      <xsl:apply-templates select="/" mode="M1222"/>
      <xsl:apply-templates select="/" mode="M1223"/>
      <xsl:apply-templates select="/" mode="M1224"/>
      <xsl:apply-templates select="/" mode="M1225"/>
      <xsl:apply-templates select="/" mode="M1226"/>
      <xsl:apply-templates select="/" mode="M1227"/>
      <xsl:apply-templates select="/" mode="M1228"/>
      <xsl:apply-templates select="/" mode="M1229"/>
      <xsl:apply-templates select="/" mode="M1230"/>
      <xsl:apply-templates select="/" mode="M1231"/>
      <xsl:apply-templates select="/" mode="M1232"/>
      <xsl:apply-templates select="/" mode="M1233"/>
      <xsl:apply-templates select="/" mode="M1234"/>
      <xsl:apply-templates select="/" mode="M1235"/>
      <xsl:apply-templates select="/" mode="M1236"/>
      <xsl:apply-templates select="/" mode="M1237"/>
      <xsl:apply-templates select="/" mode="M1238"/>
      <xsl:apply-templates select="/" mode="M1239"/>
      <xsl:apply-templates select="/" mode="M1240"/>
      <xsl:apply-templates select="/" mode="M1241"/>
      <xsl:apply-templates select="/" mode="M1242"/>
      <xsl:apply-templates select="/" mode="M1243"/>
      <xsl:apply-templates select="/" mode="M1244"/>
      <xsl:apply-templates select="/" mode="M1245"/>
      <xsl:apply-templates select="/" mode="M1246"/>
      <xsl:apply-templates select="/" mode="M1247"/>
      <xsl:apply-templates select="/" mode="M1248"/>
      <xsl:apply-templates select="/" mode="M1249"/>
      <xsl:apply-templates select="/" mode="M1250"/>
      <xsl:apply-templates select="/" mode="M1251"/>
      <xsl:apply-templates select="/" mode="M1252"/>
      <xsl:apply-templates select="/" mode="M1253"/>
      <xsl:apply-templates select="/" mode="M1254"/>
      <xsl:apply-templates select="/" mode="M1255"/>
      <xsl:apply-templates select="/" mode="M1256"/>
      <xsl:apply-templates select="/" mode="M1257"/>
      <xsl:apply-templates select="/" mode="M1258"/>
      <xsl:apply-templates select="/" mode="M1259"/>
      <xsl:apply-templates select="/" mode="M1260"/>
      <xsl:apply-templates select="/" mode="M1261"/>
      <xsl:apply-templates select="/" mode="M1262"/>
      <xsl:apply-templates select="/" mode="M1263"/>
      <xsl:apply-templates select="/" mode="M1264"/>
      <xsl:apply-templates select="/" mode="M1265"/>
      <xsl:apply-templates select="/" mode="M1266"/>
      <xsl:apply-templates select="/" mode="M1267"/>
      <xsl:apply-templates select="/" mode="M1268"/>
      <xsl:apply-templates select="/" mode="M1269"/>
      <xsl:apply-templates select="/" mode="M1270"/>
      <xsl:apply-templates select="/" mode="M1271"/>
      <xsl:apply-templates select="/" mode="M1272"/>
      <xsl:apply-templates select="/" mode="M1273"/>
      <xsl:apply-templates select="/" mode="M1274"/>
      <xsl:apply-templates select="/" mode="M1275"/>
      <xsl:apply-templates select="/" mode="M1276"/>
      <xsl:apply-templates select="/" mode="M1277"/>
      <xsl:apply-templates select="/" mode="M1278"/>
      <xsl:apply-templates select="/" mode="M1279"/>
      <xsl:apply-templates select="/" mode="M1280"/>
      <xsl:apply-templates select="/" mode="M1281"/>
      <xsl:apply-templates select="/" mode="M1282"/>
      <xsl:apply-templates select="/" mode="M1283"/>
      <xsl:apply-templates select="/" mode="M1284"/>
      <xsl:apply-templates select="/" mode="M1285"/>
      <xsl:apply-templates select="/" mode="M1286"/>
      <xsl:apply-templates select="/" mode="M1287"/>
      <xsl:apply-templates select="/" mode="M1288"/>
      <xsl:apply-templates select="/" mode="M1289"/>
      <xsl:apply-templates select="/" mode="M1290"/>
      <xsl:apply-templates select="/" mode="M1291"/>
      <xsl:apply-templates select="/" mode="M1292"/>
      <xsl:apply-templates select="/" mode="M1293"/>
      <xsl:apply-templates select="/" mode="M1294"/>
      <xsl:apply-templates select="/" mode="M1295"/>
      <xsl:apply-templates select="/" mode="M1296"/>
      <xsl:apply-templates select="/" mode="M1297"/>
      <xsl:apply-templates select="/" mode="M1298"/>
      <xsl:apply-templates select="/" mode="M1299"/>
      <xsl:apply-templates select="/" mode="M1300"/>
      <xsl:apply-templates select="/" mode="M1301"/>
      <xsl:apply-templates select="/" mode="M1302"/>
      <xsl:apply-templates select="/" mode="M1303"/>
      <xsl:apply-templates select="/" mode="M1304"/>
      <xsl:apply-templates select="/" mode="M1305"/>
      <xsl:apply-templates select="/" mode="M1306"/>
      <xsl:apply-templates select="/" mode="M1307"/>
      <xsl:apply-templates select="/" mode="M1308"/>
      <xsl:apply-templates select="/" mode="M1309"/>
      <xsl:apply-templates select="/" mode="M1310"/>
      <xsl:apply-templates select="/" mode="M1311"/>
      <xsl:apply-templates select="/" mode="M1312"/>
      <xsl:apply-templates select="/" mode="M1313"/>
      <xsl:apply-templates select="/" mode="M1314"/>
      <xsl:apply-templates select="/" mode="M1315"/>
      <xsl:apply-templates select="/" mode="M1316"/>
      <xsl:apply-templates select="/" mode="M1317"/>
      <xsl:apply-templates select="/" mode="M1318"/>
      <xsl:apply-templates select="/" mode="M1319"/>
      <xsl:apply-templates select="/" mode="M1320"/>
      <xsl:apply-templates select="/" mode="M1321"/>
      <xsl:apply-templates select="/" mode="M1322"/>
      <xsl:apply-templates select="/" mode="M1323"/>
      <xsl:apply-templates select="/" mode="M1324"/>
      <xsl:apply-templates select="/" mode="M1325"/>
      <xsl:apply-templates select="/" mode="M1326"/>
      <xsl:apply-templates select="/" mode="M1327"/>
      <xsl:apply-templates select="/" mode="M1328"/>
      <xsl:apply-templates select="/" mode="M1329"/>
      <xsl:apply-templates select="/" mode="M1330"/>
      <xsl:apply-templates select="/" mode="M1331"/>
      <xsl:apply-templates select="/" mode="M1332"/>
      <xsl:apply-templates select="/" mode="M1333"/>
      <xsl:apply-templates select="/" mode="M1334"/>
      <xsl:apply-templates select="/" mode="M1335"/>
      <xsl:apply-templates select="/" mode="M1336"/>
      <xsl:apply-templates select="/" mode="M1337"/>
      <xsl:apply-templates select="/" mode="M1338"/>
      <xsl:apply-templates select="/" mode="M1339"/>
      <xsl:apply-templates select="/" mode="M1340"/>
      <xsl:apply-templates select="/" mode="M1341"/>
      <xsl:apply-templates select="/" mode="M1342"/>
      <xsl:apply-templates select="/" mode="M1343"/>
      <xsl:apply-templates select="/" mode="M1344"/>
      <xsl:apply-templates select="/" mode="M1345"/>
      <xsl:apply-templates select="/" mode="M1346"/>
      <xsl:apply-templates select="/" mode="M1347"/>
      <xsl:apply-templates select="/" mode="M1348"/>
      <xsl:apply-templates select="/" mode="M1349"/>
      <xsl:apply-templates select="/" mode="M1350"/>
      <xsl:apply-templates select="/" mode="M1351"/>
      <xsl:apply-templates select="/" mode="M1352"/>
      <xsl:apply-templates select="/" mode="M1353"/>
      <xsl:apply-templates select="/" mode="M1354"/>
      <xsl:apply-templates select="/" mode="M1355"/>
      <xsl:apply-templates select="/" mode="M1356"/>
      <xsl:apply-templates select="/" mode="M1357"/>
      <xsl:apply-templates select="/" mode="M1358"/>
      <xsl:apply-templates select="/" mode="M1359"/>
      <xsl:apply-templates select="/" mode="M1360"/>
      <xsl:apply-templates select="/" mode="M1361"/>
      <xsl:apply-templates select="/" mode="M1362"/>
      <xsl:apply-templates select="/" mode="M1363"/>
      <xsl:apply-templates select="/" mode="M1364"/>
      <xsl:apply-templates select="/" mode="M1365"/>
      <xsl:apply-templates select="/" mode="M1366"/>
      <xsl:apply-templates select="/" mode="M1367"/>
      <xsl:apply-templates select="/" mode="M1368"/>
      <xsl:apply-templates select="/" mode="M1369"/>
      <xsl:apply-templates select="/" mode="M1370"/>
      <xsl:apply-templates select="/" mode="M1371"/>
      <xsl:apply-templates select="/" mode="M1372"/>
      <xsl:apply-templates select="/" mode="M1373"/>
      <xsl:apply-templates select="/" mode="M1374"/>
      <xsl:apply-templates select="/" mode="M1375"/>
      <xsl:apply-templates select="/" mode="M1376"/>
      <xsl:apply-templates select="/" mode="M1377"/>
      <xsl:apply-templates select="/" mode="M1378"/>
      <xsl:apply-templates select="/" mode="M1379"/>
      <xsl:apply-templates select="/" mode="M1380"/>
      <xsl:apply-templates select="/" mode="M1381"/>
      <xsl:apply-templates select="/" mode="M1382"/>
      <xsl:apply-templates select="/" mode="M1383"/>
      <xsl:apply-templates select="/" mode="M1384"/>
      <xsl:apply-templates select="/" mode="M1385"/>
      <xsl:apply-templates select="/" mode="M1386"/>
      <xsl:apply-templates select="/" mode="M1387"/>
      <xsl:apply-templates select="/" mode="M1388"/>
      <xsl:apply-templates select="/" mode="M1389"/>
      <xsl:apply-templates select="/" mode="M1390"/>
      <xsl:apply-templates select="/" mode="M1391"/>
      <xsl:apply-templates select="/" mode="M1392"/>
      <xsl:apply-templates select="/" mode="M1393"/>
      <xsl:apply-templates select="/" mode="M1394"/>
      <xsl:apply-templates select="/" mode="M1395"/>
      <xsl:apply-templates select="/" mode="M1396"/>
      <xsl:apply-templates select="/" mode="M1397"/>
      <xsl:apply-templates select="/" mode="M1398"/>
      <xsl:apply-templates select="/" mode="M1399"/>
      <xsl:apply-templates select="/" mode="M1400"/>
      <xsl:apply-templates select="/" mode="M1401"/>
      <xsl:apply-templates select="/" mode="M1402"/>
      <xsl:apply-templates select="/" mode="M1403"/>
      <xsl:apply-templates select="/" mode="M1404"/>
      <xsl:apply-templates select="/" mode="M1405"/>
      <xsl:apply-templates select="/" mode="M1406"/>
      <xsl:apply-templates select="/" mode="M1407"/>
      <xsl:apply-templates select="/" mode="M1408"/>
      <xsl:apply-templates select="/" mode="M1409"/>
      <xsl:apply-templates select="/" mode="M1410"/>
      <xsl:apply-templates select="/" mode="M1411"/>
      <xsl:apply-templates select="/" mode="M1412"/>
      <xsl:apply-templates select="/" mode="M1413"/>
      <xsl:apply-templates select="/" mode="M1414"/>
      <xsl:apply-templates select="/" mode="M1415"/>
      <xsl:apply-templates select="/" mode="M1416"/>
      <xsl:apply-templates select="/" mode="M1417"/>
      <xsl:apply-templates select="/" mode="M1418"/>
      <xsl:apply-templates select="/" mode="M1419"/>
      <xsl:apply-templates select="/" mode="M1420"/>
      <xsl:apply-templates select="/" mode="M1421"/>
      <xsl:apply-templates select="/" mode="M1422"/>
      <xsl:apply-templates select="/" mode="M1423"/>
      <xsl:apply-templates select="/" mode="M1424"/>
      <xsl:apply-templates select="/" mode="M1425"/>
      <xsl:apply-templates select="/" mode="M1426"/>
      <xsl:apply-templates select="/" mode="M1427"/>
      <xsl:apply-templates select="/" mode="M1428"/>
      <xsl:apply-templates select="/" mode="M1429"/>
      <xsl:apply-templates select="/" mode="M1430"/>
      <xsl:apply-templates select="/" mode="M1431"/>
      <xsl:apply-templates select="/" mode="M1432"/>
      <xsl:apply-templates select="/" mode="M1433"/>
      <xsl:apply-templates select="/" mode="M1434"/>
      <xsl:apply-templates select="/" mode="M1435"/>
      <xsl:apply-templates select="/" mode="M1436"/>
      <xsl:apply-templates select="/" mode="M1437"/>
      <xsl:apply-templates select="/" mode="M1438"/>
      <xsl:apply-templates select="/" mode="M1439"/>
      <xsl:apply-templates select="/" mode="M1440"/>
      <xsl:apply-templates select="/" mode="M1441"/>
      <xsl:apply-templates select="/" mode="M1442"/>
      <xsl:apply-templates select="/" mode="M1443"/>
      <xsl:apply-templates select="/" mode="M1444"/>
      <xsl:apply-templates select="/" mode="M1445"/>
      <xsl:apply-templates select="/" mode="M1446"/>
      <xsl:apply-templates select="/" mode="M1447"/>
      <xsl:apply-templates select="/" mode="M1448"/>
      <xsl:apply-templates select="/" mode="M1449"/>
      <xsl:apply-templates select="/" mode="M1450"/>
      <xsl:apply-templates select="/" mode="M1451"/>
      <xsl:apply-templates select="/" mode="M1452"/>
      <xsl:apply-templates select="/" mode="M1453"/>
      <xsl:apply-templates select="/" mode="M1454"/>
      <xsl:apply-templates select="/" mode="M1455"/>
      <xsl:apply-templates select="/" mode="M1456"/>
      <xsl:apply-templates select="/" mode="M1457"/>
      <xsl:apply-templates select="/" mode="M1458"/>
      <xsl:apply-templates select="/" mode="M1459"/>
      <xsl:apply-templates select="/" mode="M1460"/>
      <xsl:apply-templates select="/" mode="M1461"/>
      <xsl:apply-templates select="/" mode="M1462"/>
      <xsl:apply-templates select="/" mode="M1463"/>
      <xsl:apply-templates select="/" mode="M1464"/>
      <xsl:apply-templates select="/" mode="M1465"/>
      <xsl:apply-templates select="/" mode="M1466"/>
      <xsl:apply-templates select="/" mode="M1467"/>
      <xsl:apply-templates select="/" mode="M1468"/>
      <xsl:apply-templates select="/" mode="M1469"/>
      <xsl:apply-templates select="/" mode="M1470"/>
      <xsl:apply-templates select="/" mode="M1471"/>
      <xsl:apply-templates select="/" mode="M1472"/>
      <xsl:apply-templates select="/" mode="M1473"/>
      <xsl:apply-templates select="/" mode="M1474"/>
      <xsl:apply-templates select="/" mode="M1475"/>
      <xsl:apply-templates select="/" mode="M1476"/>
      <xsl:apply-templates select="/" mode="M1477"/>
      <xsl:apply-templates select="/" mode="M1478"/>
      <xsl:apply-templates select="/" mode="M1479"/>
      <xsl:apply-templates select="/" mode="M1480"/>
      <xsl:apply-templates select="/" mode="M1481"/>
      <xsl:apply-templates select="/" mode="M1482"/>
      <xsl:apply-templates select="/" mode="M1483"/>
      <xsl:apply-templates select="/" mode="M1484"/>
      <xsl:apply-templates select="/" mode="M1485"/>
      <xsl:apply-templates select="/" mode="M1486"/>
      <xsl:apply-templates select="/" mode="M1487"/>
      <xsl:apply-templates select="/" mode="M1488"/>
      <xsl:apply-templates select="/" mode="M1489"/>
      <xsl:apply-templates select="/" mode="M1490"/>
      <xsl:apply-templates select="/" mode="M1491"/>
      <xsl:apply-templates select="/" mode="M1492"/>
      <xsl:apply-templates select="/" mode="M1493"/>
      <xsl:apply-templates select="/" mode="M1494"/>
      <xsl:apply-templates select="/" mode="M1495"/>
      <xsl:apply-templates select="/" mode="M1496"/>
      <xsl:apply-templates select="/" mode="M1497"/>
      <xsl:apply-templates select="/" mode="M1498"/>
      <xsl:apply-templates select="/" mode="M1499"/>
      <xsl:apply-templates select="/" mode="M1500"/>
      <xsl:apply-templates select="/" mode="M1501"/>
      <xsl:apply-templates select="/" mode="M1502"/>
      <xsl:apply-templates select="/" mode="M1503"/>
      <xsl:apply-templates select="/" mode="M1504"/>
      <xsl:apply-templates select="/" mode="M1505"/>
      <xsl:apply-templates select="/" mode="M1506"/>
      <xsl:apply-templates select="/" mode="M1507"/>
      <xsl:apply-templates select="/" mode="M1508"/>
      <xsl:apply-templates select="/" mode="M1509"/>
      <xsl:apply-templates select="/" mode="M1510"/>
      <xsl:apply-templates select="/" mode="M1511"/>
      <xsl:apply-templates select="/" mode="M1512"/>
      <xsl:apply-templates select="/" mode="M1513"/>
      <xsl:apply-templates select="/" mode="M1514"/>
      <xsl:apply-templates select="/" mode="M1515"/>
      <xsl:apply-templates select="/" mode="M1516"/>
      <xsl:apply-templates select="/" mode="M1517"/>
      <xsl:apply-templates select="/" mode="M1518"/>
      <xsl:apply-templates select="/" mode="M1519"/>
      <xsl:apply-templates select="/" mode="M1520"/>
      <xsl:apply-templates select="/" mode="M1521"/>
      <xsl:apply-templates select="/" mode="M1522"/>
      <xsl:apply-templates select="/" mode="M1523"/>
      <xsl:apply-templates select="/" mode="M1524"/>
      <xsl:apply-templates select="/" mode="M1525"/>
      <xsl:apply-templates select="/" mode="M1526"/>
      <xsl:apply-templates select="/" mode="M1527"/>
      <xsl:apply-templates select="/" mode="M1528"/>
      <xsl:apply-templates select="/" mode="M1529"/>
      <xsl:apply-templates select="/" mode="M1530"/>
      <xsl:apply-templates select="/" mode="M1531"/>
      <xsl:apply-templates select="/" mode="M1532"/>
      <xsl:apply-templates select="/" mode="M1533"/>
      <xsl:apply-templates select="/" mode="M1534"/>
      <xsl:apply-templates select="/" mode="M1535"/>
      <xsl:apply-templates select="/" mode="M1536"/>
      <xsl:apply-templates select="/" mode="M1537"/>
      <xsl:apply-templates select="/" mode="M1538"/>
      <xsl:apply-templates select="/" mode="M1539"/>
      <xsl:apply-templates select="/" mode="M1540"/>
      <xsl:apply-templates select="/" mode="M1541"/>
      <xsl:apply-templates select="/" mode="M1542"/>
      <xsl:apply-templates select="/" mode="M1543"/>
      <xsl:apply-templates select="/" mode="M1544"/>
      <xsl:apply-templates select="/" mode="M1545"/>
      <xsl:apply-templates select="/" mode="M1546"/>
      <xsl:apply-templates select="/" mode="M1547"/>
      <xsl:apply-templates select="/" mode="M1548"/>
      <xsl:apply-templates select="/" mode="M1549"/>
      <xsl:apply-templates select="/" mode="M1550"/>
      <xsl:apply-templates select="/" mode="M1551"/>
      <xsl:apply-templates select="/" mode="M1552"/>
      <xsl:apply-templates select="/" mode="M1553"/>
      <xsl:apply-templates select="/" mode="M1554"/>
      <xsl:apply-templates select="/" mode="M1555"/>
      <xsl:apply-templates select="/" mode="M1556"/>
      <xsl:apply-templates select="/" mode="M1557"/>
      <xsl:apply-templates select="/" mode="M1558"/>
      <xsl:apply-templates select="/" mode="M1559"/>
      <xsl:apply-templates select="/" mode="M1560"/>
      <xsl:apply-templates select="/" mode="M1561"/>
      <xsl:apply-templates select="/" mode="M1562"/>
      <xsl:apply-templates select="/" mode="M1563"/>
      <xsl:apply-templates select="/" mode="M1564"/>
      <xsl:apply-templates select="/" mode="M1565"/>
      <xsl:apply-templates select="/" mode="M1566"/>
      <xsl:apply-templates select="/" mode="M1567"/>
      <xsl:apply-templates select="/" mode="M1568"/>
      <xsl:apply-templates select="/" mode="M1569"/>
      <xsl:apply-templates select="/" mode="M1570"/>
      <xsl:apply-templates select="/" mode="M1571"/>
      <xsl:apply-templates select="/" mode="M1572"/>
      <xsl:apply-templates select="/" mode="M1573"/>
      <xsl:apply-templates select="/" mode="M1574"/>
      <xsl:apply-templates select="/" mode="M1575"/>
      <xsl:apply-templates select="/" mode="M1576"/>
      <xsl:apply-templates select="/" mode="M1577"/>
      <xsl:apply-templates select="/" mode="M1578"/>
      <xsl:apply-templates select="/" mode="M1579"/>
      <xsl:apply-templates select="/" mode="M1580"/>
      <xsl:apply-templates select="/" mode="M1581"/>
      <xsl:apply-templates select="/" mode="M1582"/>
      <xsl:apply-templates select="/" mode="M1583"/>
      <xsl:apply-templates select="/" mode="M1584"/>
      <xsl:apply-templates select="/" mode="M1585"/>
      <xsl:apply-templates select="/" mode="M1586"/>
      <xsl:apply-templates select="/" mode="M1587"/>
      <xsl:apply-templates select="/" mode="M1588"/>
      <xsl:apply-templates select="/" mode="M1589"/>
      <xsl:apply-templates select="/" mode="M1590"/>
      <xsl:apply-templates select="/" mode="M1591"/>
      <xsl:apply-templates select="/" mode="M1592"/>
      <xsl:apply-templates select="/" mode="M1593"/>
      <xsl:apply-templates select="/" mode="M1594"/>
      <xsl:apply-templates select="/" mode="M1595"/>
      <xsl:apply-templates select="/" mode="M1596"/>
      <xsl:apply-templates select="/" mode="M1597"/>
      <xsl:apply-templates select="/" mode="M1598"/>
      <xsl:apply-templates select="/" mode="M1599"/>
      <xsl:apply-templates select="/" mode="M1600"/>
      <xsl:apply-templates select="/" mode="M1601"/>
      <xsl:apply-templates select="/" mode="M1602"/>
      <xsl:apply-templates select="/" mode="M1603"/>
      <xsl:apply-templates select="/" mode="M1604"/>
      <xsl:apply-templates select="/" mode="M1605"/>
      <xsl:apply-templates select="/" mode="M1606"/>
      <xsl:apply-templates select="/" mode="M1607"/>
      <xsl:apply-templates select="/" mode="M1608"/>
      <xsl:apply-templates select="/" mode="M1609"/>
      <xsl:apply-templates select="/" mode="M1610"/>
      <xsl:apply-templates select="/" mode="M1611"/>
      <xsl:apply-templates select="/" mode="M1612"/>
      <xsl:apply-templates select="/" mode="M1613"/>
      <xsl:apply-templates select="/" mode="M1614"/>
      <xsl:apply-templates select="/" mode="M1615"/>
      <xsl:apply-templates select="/" mode="M1616"/>
      <xsl:apply-templates select="/" mode="M1617"/>
      <xsl:apply-templates select="/" mode="M1618"/>
      <xsl:apply-templates select="/" mode="M1619"/>
      <xsl:apply-templates select="/" mode="M1620"/>
      <xsl:apply-templates select="/" mode="M1621"/>
      <xsl:apply-templates select="/" mode="M1622"/>
      <xsl:apply-templates select="/" mode="M1623"/>
      <xsl:apply-templates select="/" mode="M1624"/>
      <xsl:apply-templates select="/" mode="M1625"/>
      <xsl:apply-templates select="/" mode="M1626"/>
      <xsl:apply-templates select="/" mode="M1627"/>
      <xsl:apply-templates select="/" mode="M1628"/>
      <xsl:apply-templates select="/" mode="M1629"/>
      <xsl:apply-templates select="/" mode="M1630"/>
      <xsl:apply-templates select="/" mode="M1631"/>
      <xsl:apply-templates select="/" mode="M1632"/>
      <xsl:apply-templates select="/" mode="M1633"/>
      <xsl:apply-templates select="/" mode="M1634"/>
      <xsl:apply-templates select="/" mode="M1635"/>
      <xsl:apply-templates select="/" mode="M1636"/>
      <xsl:apply-templates select="/" mode="M1637"/>
      <xsl:apply-templates select="/" mode="M1638"/>
      <xsl:apply-templates select="/" mode="M1639"/>
      <xsl:apply-templates select="/" mode="M1640"/>
      <xsl:apply-templates select="/" mode="M1641"/>
      <xsl:apply-templates select="/" mode="M1642"/>
      <xsl:apply-templates select="/" mode="M1643"/>
      <xsl:apply-templates select="/" mode="M1644"/>
      <xsl:apply-templates select="/" mode="M1645"/>
      <xsl:apply-templates select="/" mode="M1646"/>
      <xsl:apply-templates select="/" mode="M1647"/>
      <xsl:apply-templates select="/" mode="M1648"/>
      <xsl:apply-templates select="/" mode="M1649"/>
      <xsl:apply-templates select="/" mode="M1650"/>
      <xsl:apply-templates select="/" mode="M1651"/>
      <xsl:apply-templates select="/" mode="M1652"/>
      <xsl:apply-templates select="/" mode="M1653"/>
      <xsl:apply-templates select="/" mode="M1654"/>
      <xsl:apply-templates select="/" mode="M1655"/>
      <xsl:apply-templates select="/" mode="M1656"/>
      <xsl:apply-templates select="/" mode="M1657"/>
      <xsl:apply-templates select="/" mode="M1658"/>
      <xsl:apply-templates select="/" mode="M1659"/>
      <xsl:apply-templates select="/" mode="M1660"/>
      <xsl:apply-templates select="/" mode="M1661"/>
      <xsl:apply-templates select="/" mode="M1662"/>
      <xsl:apply-templates select="/" mode="M1663"/>
      <xsl:apply-templates select="/" mode="M1664"/>
      <xsl:apply-templates select="/" mode="M1665"/>
      <xsl:apply-templates select="/" mode="M1666"/>
      <xsl:apply-templates select="/" mode="M1667"/>
      <xsl:apply-templates select="/" mode="M1668"/>
      <xsl:apply-templates select="/" mode="M1669"/>
      <xsl:apply-templates select="/" mode="M1670"/>
      <xsl:apply-templates select="/" mode="M1671"/>
      <xsl:apply-templates select="/" mode="M1672"/>
      <xsl:apply-templates select="/" mode="M1673"/>
      <xsl:apply-templates select="/" mode="M1674"/>
      <xsl:apply-templates select="/" mode="M1675"/>
      <xsl:apply-templates select="/" mode="M1676"/>
      <xsl:apply-templates select="/" mode="M1677"/>
      <xsl:apply-templates select="/" mode="M1678"/>
      <xsl:apply-templates select="/" mode="M1679"/>
      <xsl:apply-templates select="/" mode="M1680"/>
      <xsl:apply-templates select="/" mode="M1681"/>
      <xsl:apply-templates select="/" mode="M1682"/>
      <xsl:apply-templates select="/" mode="M1683"/>
      <xsl:apply-templates select="/" mode="M1684"/>
      <xsl:apply-templates select="/" mode="M1685"/>
      <xsl:apply-templates select="/" mode="M1686"/>
      <xsl:apply-templates select="/" mode="M1687"/>
      <xsl:apply-templates select="/" mode="M1688"/>
      <xsl:apply-templates select="/" mode="M1689"/>
      <xsl:apply-templates select="/" mode="M1690"/>
      <xsl:apply-templates select="/" mode="M1691"/>
      <xsl:apply-templates select="/" mode="M1692"/>
      <xsl:apply-templates select="/" mode="M1693"/>
      <xsl:apply-templates select="/" mode="M1694"/>
      <xsl:apply-templates select="/" mode="M1695"/>
      <xsl:apply-templates select="/" mode="M1696"/>
      <xsl:apply-templates select="/" mode="M1697"/>
      <xsl:apply-templates select="/" mode="M1698"/>
      <xsl:apply-templates select="/" mode="M1699"/>
      <xsl:apply-templates select="/" mode="M1700"/>
      <xsl:apply-templates select="/" mode="M1701"/>
      <xsl:apply-templates select="/" mode="M1702"/>
      <xsl:apply-templates select="/" mode="M1703"/>
      <xsl:apply-templates select="/" mode="M1704"/>
      <xsl:apply-templates select="/" mode="M1705"/>
      <xsl:apply-templates select="/" mode="M1706"/>
      <xsl:apply-templates select="/" mode="M1707"/>
      <xsl:apply-templates select="/" mode="M1708"/>
      <xsl:apply-templates select="/" mode="M1709"/>
      <xsl:apply-templates select="/" mode="M1710"/>
      <xsl:apply-templates select="/" mode="M1711"/>
      <xsl:apply-templates select="/" mode="M1712"/>
      <xsl:apply-templates select="/" mode="M1713"/>
      <xsl:apply-templates select="/" mode="M1714"/>
      <xsl:apply-templates select="/" mode="M1715"/>
      <xsl:apply-templates select="/" mode="M1716"/>
      <xsl:apply-templates select="/" mode="M1717"/>
      <xsl:apply-templates select="/" mode="M1718"/>
      <xsl:apply-templates select="/" mode="M1719"/>
      <xsl:apply-templates select="/" mode="M1720"/>
      <xsl:apply-templates select="/" mode="M1721"/>
      <xsl:apply-templates select="/" mode="M1722"/>
      <xsl:apply-templates select="/" mode="M1723"/>
      <xsl:apply-templates select="/" mode="M1724"/>
      <xsl:apply-templates select="/" mode="M1725"/>
      <xsl:apply-templates select="/" mode="M1726"/>
      <xsl:apply-templates select="/" mode="M1727"/>
      <xsl:apply-templates select="/" mode="M1728"/>
      <xsl:apply-templates select="/" mode="M1729"/>
      <xsl:apply-templates select="/" mode="M1730"/>
      <xsl:apply-templates select="/" mode="M1731"/>
      <xsl:apply-templates select="/" mode="M1732"/>
      <xsl:apply-templates select="/" mode="M1733"/>
      <xsl:apply-templates select="/" mode="M1734"/>
      <xsl:apply-templates select="/" mode="M1735"/>
      <xsl:apply-templates select="/" mode="M1736"/>
      <xsl:apply-templates select="/" mode="M1737"/>
      <xsl:apply-templates select="/" mode="M1738"/>
      <xsl:apply-templates select="/" mode="M1739"/>
      <xsl:apply-templates select="/" mode="M1740"/>
      <xsl:apply-templates select="/" mode="M1741"/>
      <xsl:apply-templates select="/" mode="M1742"/>
      <xsl:apply-templates select="/" mode="M1743"/>
      <xsl:apply-templates select="/" mode="M1744"/>
      <xsl:apply-templates select="/" mode="M1745"/>
      <xsl:apply-templates select="/" mode="M1746"/>
      <xsl:apply-templates select="/" mode="M1747"/>
      <xsl:apply-templates select="/" mode="M1748"/>
      <xsl:apply-templates select="/" mode="M1749"/>
      <xsl:apply-templates select="/" mode="M1750"/>
      <xsl:apply-templates select="/" mode="M1751"/>
      <xsl:apply-templates select="/" mode="M1752"/>
      <xsl:apply-templates select="/" mode="M1753"/>
      <xsl:apply-templates select="/" mode="M1754"/>
      <xsl:apply-templates select="/" mode="M1755"/>
      <xsl:apply-templates select="/" mode="M1756"/>
      <xsl:apply-templates select="/" mode="M1757"/>
      <xsl:apply-templates select="/" mode="M1758"/>
      <xsl:apply-templates select="/" mode="M1759"/>
      <xsl:apply-templates select="/" mode="M1760"/>
      <xsl:apply-templates select="/" mode="M1761"/>
      <xsl:apply-templates select="/" mode="M1762"/>
      <xsl:apply-templates select="/" mode="M1763"/>
      <xsl:apply-templates select="/" mode="M1764"/>
      <xsl:apply-templates select="/" mode="M1765"/>
      <xsl:apply-templates select="/" mode="M1766"/>
      <xsl:apply-templates select="/" mode="M1767"/>
      <xsl:apply-templates select="/" mode="M1768"/>
      <xsl:apply-templates select="/" mode="M1769"/>
      <xsl:apply-templates select="/" mode="M1770"/>
      <xsl:apply-templates select="/" mode="M1771"/>
      <xsl:apply-templates select="/" mode="M1772"/>
      <xsl:apply-templates select="/" mode="M1773"/>
      <xsl:apply-templates select="/" mode="M1774"/>
      <xsl:apply-templates select="/" mode="M1775"/>
      <xsl:apply-templates select="/" mode="M1776"/>
      <xsl:apply-templates select="/" mode="M1777"/>
      <xsl:apply-templates select="/" mode="M1778"/>
      <xsl:apply-templates select="/" mode="M1779"/>
      <xsl:apply-templates select="/" mode="M1780"/>
      <xsl:apply-templates select="/" mode="M1781"/>
      <xsl:apply-templates select="/" mode="M1782"/>
      <xsl:apply-templates select="/" mode="M1783"/>
      <xsl:apply-templates select="/" mode="M1784"/>
      <xsl:apply-templates select="/" mode="M1785"/>
      <xsl:apply-templates select="/" mode="M1786"/>
      <xsl:apply-templates select="/" mode="M1787"/>
      <xsl:apply-templates select="/" mode="M1788"/>
      <xsl:apply-templates select="/" mode="M1789"/>
      <xsl:apply-templates select="/" mode="M1790"/>
      <xsl:apply-templates select="/" mode="M1791"/>
      <xsl:apply-templates select="/" mode="M1792"/>
      <xsl:apply-templates select="/" mode="M1793"/>
      <xsl:apply-templates select="/" mode="M1794"/>
      <xsl:apply-templates select="/" mode="M1795"/>
      <xsl:apply-templates select="/" mode="M1796"/>
      <xsl:apply-templates select="/" mode="M1797"/>
      <xsl:apply-templates select="/" mode="M1798"/>
      <xsl:apply-templates select="/" mode="M1799"/>
      <xsl:apply-templates select="/" mode="M1800"/>
      <xsl:apply-templates select="/" mode="M1801"/>
      <xsl:apply-templates select="/" mode="M1802"/>
      <xsl:apply-templates select="/" mode="M1803"/>
      <xsl:apply-templates select="/" mode="M1804"/>
      <xsl:apply-templates select="/" mode="M1805"/>
      <xsl:apply-templates select="/" mode="M1806"/>
      <xsl:apply-templates select="/" mode="M1807"/>
      <xsl:apply-templates select="/" mode="M1808"/>
      <xsl:apply-templates select="/" mode="M1809"/>
      <xsl:apply-templates select="/" mode="M1810"/>
      <xsl:apply-templates select="/" mode="M1811"/>
      <xsl:apply-templates select="/" mode="M1812"/>
      <xsl:apply-templates select="/" mode="M1813"/>
      <xsl:apply-templates select="/" mode="M1814"/>
      <xsl:apply-templates select="/" mode="M1815"/>
      <xsl:apply-templates select="/" mode="M1816"/>
      <xsl:apply-templates select="/" mode="M1817"/>
      <xsl:apply-templates select="/" mode="M1818"/>
      <xsl:apply-templates select="/" mode="M1819"/>
      <xsl:apply-templates select="/" mode="M1820"/>
      <xsl:apply-templates select="/" mode="M1821"/>
      <xsl:apply-templates select="/" mode="M1822"/>
      <xsl:apply-templates select="/" mode="M1823"/>
      <xsl:apply-templates select="/" mode="M1824"/>
      <xsl:apply-templates select="/" mode="M1825"/>
      <xsl:apply-templates select="/" mode="M1826"/>
      <xsl:apply-templates select="/" mode="M1827"/>
      <xsl:apply-templates select="/" mode="M1828"/>
      <xsl:apply-templates select="/" mode="M1829"/>
      <xsl:apply-templates select="/" mode="M1830"/>
      <xsl:apply-templates select="/" mode="M1831"/>
      <xsl:apply-templates select="/" mode="M1832"/>
      <xsl:apply-templates select="/" mode="M1833"/>
      <xsl:apply-templates select="/" mode="M1834"/>
      <xsl:apply-templates select="/" mode="M1835"/>
      <xsl:apply-templates select="/" mode="M1836"/>
      <xsl:apply-templates select="/" mode="M1837"/>
      <xsl:apply-templates select="/" mode="M1838"/>
      <xsl:apply-templates select="/" mode="M1839"/>
      <xsl:apply-templates select="/" mode="M1840"/>
      <xsl:apply-templates select="/" mode="M1841"/>
      <xsl:apply-templates select="/" mode="M1842"/>
      <xsl:apply-templates select="/" mode="M1843"/>
      <xsl:apply-templates select="/" mode="M1844"/>
      <xsl:apply-templates select="/" mode="M1845"/>
      <xsl:apply-templates select="/" mode="M1846"/>
      <xsl:apply-templates select="/" mode="M1847"/>
      <xsl:apply-templates select="/" mode="M1848"/>
      <xsl:apply-templates select="/" mode="M1849"/>
      <xsl:apply-templates select="/" mode="M1850"/>
      <xsl:apply-templates select="/" mode="M1851"/>
      <xsl:apply-templates select="/" mode="M1852"/>
      <xsl:apply-templates select="/" mode="M1853"/>
      <xsl:apply-templates select="/" mode="M1854"/>
      <xsl:apply-templates select="/" mode="M1855"/>
      <xsl:apply-templates select="/" mode="M1856"/>
      <xsl:apply-templates select="/" mode="M1857"/>
      <xsl:apply-templates select="/" mode="M1858"/>
      <xsl:apply-templates select="/" mode="M1859"/>
      <xsl:apply-templates select="/" mode="M1860"/>
      <xsl:apply-templates select="/" mode="M1861"/>
      <xsl:apply-templates select="/" mode="M1862"/>
      <xsl:apply-templates select="/" mode="M1863"/>
      <xsl:apply-templates select="/" mode="M1864"/>
      <xsl:apply-templates select="/" mode="M1865"/>
      <xsl:apply-templates select="/" mode="M1866"/>
      <xsl:apply-templates select="/" mode="M1867"/>
      <xsl:apply-templates select="/" mode="M1868"/>
      <xsl:apply-templates select="/" mode="M1869"/>
      <xsl:apply-templates select="/" mode="M1870"/>
      <xsl:apply-templates select="/" mode="M1871"/>
      <xsl:apply-templates select="/" mode="M1872"/>
      <xsl:apply-templates select="/" mode="M1873"/>
      <xsl:apply-templates select="/" mode="M1874"/>
      <xsl:apply-templates select="/" mode="M1875"/>
      <xsl:apply-templates select="/" mode="M1876"/>
      <xsl:apply-templates select="/" mode="M1877"/>
      <xsl:apply-templates select="/" mode="M1878"/>
      <xsl:apply-templates select="/" mode="M1879"/>
      <xsl:apply-templates select="/" mode="M1880"/>
      <xsl:apply-templates select="/" mode="M1881"/>
      <xsl:apply-templates select="/" mode="M1882"/>
      <xsl:apply-templates select="/" mode="M1883"/>
      <xsl:apply-templates select="/" mode="M1884"/>
      <xsl:apply-templates select="/" mode="M1885"/>
      <xsl:apply-templates select="/" mode="M1886"/>
      <xsl:apply-templates select="/" mode="M1887"/>
      <xsl:apply-templates select="/" mode="M1888"/>
      <xsl:apply-templates select="/" mode="M1889"/>
      <xsl:apply-templates select="/" mode="M1890"/>
      <xsl:apply-templates select="/" mode="M1891"/>
      <xsl:apply-templates select="/" mode="M1892"/>
      <xsl:apply-templates select="/" mode="M1893"/>
      <xsl:apply-templates select="/" mode="M1894"/>
      <xsl:apply-templates select="/" mode="M1895"/>
      <xsl:apply-templates select="/" mode="M1896"/>
      <xsl:apply-templates select="/" mode="M1897"/>
      <xsl:apply-templates select="/" mode="M1898"/>
      <xsl:apply-templates select="/" mode="M1899"/>
      <xsl:apply-templates select="/" mode="M1900"/>
      <xsl:apply-templates select="/" mode="M1901"/>
      <xsl:apply-templates select="/" mode="M1902"/>
      <xsl:apply-templates select="/" mode="M1903"/>
      <xsl:apply-templates select="/" mode="M1904"/>
      <xsl:apply-templates select="/" mode="M1905"/>
      <xsl:apply-templates select="/" mode="M1906"/>
      <xsl:apply-templates select="/" mode="M1907"/>
      <xsl:apply-templates select="/" mode="M1908"/>
      <xsl:apply-templates select="/" mode="M1909"/>
      <xsl:apply-templates select="/" mode="M1910"/>
      <xsl:apply-templates select="/" mode="M1911"/>
      <xsl:apply-templates select="/" mode="M1912"/>
      <xsl:apply-templates select="/" mode="M1913"/>
      <xsl:apply-templates select="/" mode="M1914"/>
      <xsl:apply-templates select="/" mode="M1915"/>
      <xsl:apply-templates select="/" mode="M1916"/>
      <xsl:apply-templates select="/" mode="M1917"/>
      <xsl:apply-templates select="/" mode="M1918"/>
      <xsl:apply-templates select="/" mode="M1919"/>
      <xsl:apply-templates select="/" mode="M1920"/>
      <xsl:apply-templates select="/" mode="M1921"/>
      <xsl:apply-templates select="/" mode="M1922"/>
      <xsl:apply-templates select="/" mode="M1923"/>
      <xsl:apply-templates select="/" mode="M1924"/>
      <xsl:apply-templates select="/" mode="M1925"/>
      <xsl:apply-templates select="/" mode="M1926"/>
      <xsl:apply-templates select="/" mode="M1927"/>
      <xsl:apply-templates select="/" mode="M1928"/>
      <xsl:apply-templates select="/" mode="M1929"/>
      <xsl:apply-templates select="/" mode="M1930"/>
      <xsl:apply-templates select="/" mode="M1931"/>
      <xsl:apply-templates select="/" mode="M1932"/>
      <xsl:apply-templates select="/" mode="M1933"/>
      <xsl:apply-templates select="/" mode="M1934"/>
      <xsl:apply-templates select="/" mode="M1935"/>
      <xsl:apply-templates select="/" mode="M1936"/>
      <xsl:apply-templates select="/" mode="M1937"/>
      <xsl:apply-templates select="/" mode="M1938"/>
      <xsl:apply-templates select="/" mode="M1939"/>
      <xsl:apply-templates select="/" mode="M1940"/>
      <xsl:apply-templates select="/" mode="M1941"/>
      <xsl:apply-templates select="/" mode="M1942"/>
      <xsl:apply-templates select="/" mode="M1943"/>
      <xsl:apply-templates select="/" mode="M1944"/>
      <xsl:apply-templates select="/" mode="M1945"/>
      <xsl:apply-templates select="/" mode="M1946"/>
      <xsl:apply-templates select="/" mode="M1947"/>
      <xsl:apply-templates select="/" mode="M1948"/>
      <xsl:apply-templates select="/" mode="M1949"/>
      <xsl:apply-templates select="/" mode="M1950"/>
      <xsl:apply-templates select="/" mode="M1951"/>
      <xsl:apply-templates select="/" mode="M1952"/>
      <xsl:apply-templates select="/" mode="M1953"/>
      <xsl:apply-templates select="/" mode="M1954"/>
      <xsl:apply-templates select="/" mode="M1955"/>
      <xsl:apply-templates select="/" mode="M1956"/>
      <xsl:apply-templates select="/" mode="M1957"/>
      <xsl:apply-templates select="/" mode="M1958"/>
      <xsl:apply-templates select="/" mode="M1959"/>
      <xsl:apply-templates select="/" mode="M1960"/>
      <xsl:apply-templates select="/" mode="M1961"/>
      <xsl:apply-templates select="/" mode="M1962"/>
      <xsl:apply-templates select="/" mode="M1963"/>
      <xsl:apply-templates select="/" mode="M1964"/>
      <xsl:apply-templates select="/" mode="M1965"/>
      <xsl:apply-templates select="/" mode="M1966"/>
      <xsl:apply-templates select="/" mode="M1967"/>
      <xsl:apply-templates select="/" mode="M1968"/>
      <xsl:apply-templates select="/" mode="M1969"/>
      <xsl:apply-templates select="/" mode="M1970"/>
      <xsl:apply-templates select="/" mode="M1971"/>
      <xsl:apply-templates select="/" mode="M1972"/>
      <xsl:apply-templates select="/" mode="M1973"/>
      <xsl:apply-templates select="/" mode="M1974"/>
      <xsl:apply-templates select="/" mode="M1975"/>
      <xsl:apply-templates select="/" mode="M1976"/>
      <xsl:apply-templates select="/" mode="M1977"/>
      <xsl:apply-templates select="/" mode="M1978"/>
      <xsl:apply-templates select="/" mode="M1979"/>
      <xsl:apply-templates select="/" mode="M1980"/>
      <xsl:apply-templates select="/" mode="M1981"/>
      <xsl:apply-templates select="/" mode="M1982"/>
      <xsl:apply-templates select="/" mode="M1983"/>
      <xsl:apply-templates select="/" mode="M1984"/>
      <xsl:apply-templates select="/" mode="M1985"/>
      <xsl:apply-templates select="/" mode="M1986"/>
      <xsl:apply-templates select="/" mode="M1987"/>
      <xsl:apply-templates select="/" mode="M1988"/>
      <xsl:apply-templates select="/" mode="M1989"/>
      <xsl:apply-templates select="/" mode="M1990"/>
      <xsl:apply-templates select="/" mode="M1991"/>
      <xsl:apply-templates select="/" mode="M1992"/>
      <xsl:apply-templates select="/" mode="M1993"/>
      <xsl:apply-templates select="/" mode="M1994"/>
      <xsl:apply-templates select="/" mode="M1995"/>
      <xsl:apply-templates select="/" mode="M1996"/>
      <xsl:apply-templates select="/" mode="M1997"/>
      <xsl:apply-templates select="/" mode="M1998"/>
      <xsl:apply-templates select="/" mode="M1999"/>
      <xsl:apply-templates select="/" mode="M2000"/>
      <xsl:apply-templates select="/" mode="M2001"/>
      <xsl:apply-templates select="/" mode="M2002"/>
      <xsl:apply-templates select="/" mode="M2003"/>
      <xsl:apply-templates select="/" mode="M2004"/>
      <xsl:apply-templates select="/" mode="M2005"/>
      <xsl:apply-templates select="/" mode="M2006"/>
      <xsl:apply-templates select="/" mode="M2007"/>
      <xsl:apply-templates select="/" mode="M2008"/>
      <xsl:apply-templates select="/" mode="M2009"/>
      <xsl:apply-templates select="/" mode="M2010"/>
      <xsl:apply-templates select="/" mode="M2011"/>
      <xsl:apply-templates select="/" mode="M2012"/>
      <xsl:apply-templates select="/" mode="M2013"/>
      <xsl:apply-templates select="/" mode="M2014"/>
      <xsl:apply-templates select="/" mode="M2015"/>
      <xsl:apply-templates select="/" mode="M2016"/>
      <xsl:apply-templates select="/" mode="M2017"/>
      <xsl:apply-templates select="/" mode="M2018"/>
      <xsl:apply-templates select="/" mode="M2019"/>
      <xsl:apply-templates select="/" mode="M2020"/>
      <xsl:apply-templates select="/" mode="M2021"/>
      <xsl:apply-templates select="/" mode="M2022"/>
      <xsl:apply-templates select="/" mode="M2023"/>
      <xsl:apply-templates select="/" mode="M2024"/>
      <xsl:apply-templates select="/" mode="M2025"/>
      <xsl:apply-templates select="/" mode="M2026"/>
      <xsl:apply-templates select="/" mode="M2027"/>
      <xsl:apply-templates select="/" mode="M2028"/>
      <xsl:apply-templates select="/" mode="M2029"/>
      <xsl:apply-templates select="/" mode="M2030"/>
      <xsl:apply-templates select="/" mode="M2031"/>
      <xsl:apply-templates select="/" mode="M2032"/>
      <xsl:apply-templates select="/" mode="M2033"/>
      <xsl:apply-templates select="/" mode="M2034"/>
      <xsl:apply-templates select="/" mode="M2035"/>
      <xsl:apply-templates select="/" mode="M2036"/>
      <xsl:apply-templates select="/" mode="M2037"/>
      <xsl:apply-templates select="/" mode="M2038"/>
      <xsl:apply-templates select="/" mode="M2039"/>
      <xsl:apply-templates select="/" mode="M2040"/>
      <xsl:apply-templates select="/" mode="M2041"/>
      <xsl:apply-templates select="/" mode="M2042"/>
      <xsl:apply-templates select="/" mode="M2043"/>
      <xsl:apply-templates select="/" mode="M2044"/>
      <xsl:apply-templates select="/" mode="M2045"/>
      <xsl:apply-templates select="/" mode="M2046"/>
      <xsl:apply-templates select="/" mode="M2047"/>
      <xsl:apply-templates select="/" mode="M2048"/>
      <xsl:apply-templates select="/" mode="M2049"/>
      <xsl:apply-templates select="/" mode="M2050"/>
      <xsl:apply-templates select="/" mode="M2051"/>
      <xsl:apply-templates select="/" mode="M2052"/>
      <xsl:apply-templates select="/" mode="M2053"/>
      <xsl:apply-templates select="/" mode="M2054"/>
      <xsl:apply-templates select="/" mode="M2055"/>
      <xsl:apply-templates select="/" mode="M2056"/>
      <xsl:apply-templates select="/" mode="M2057"/>
      <xsl:apply-templates select="/" mode="M2058"/>
      <xsl:apply-templates select="/" mode="M2059"/>
      <xsl:apply-templates select="/" mode="M2060"/>
      <xsl:apply-templates select="/" mode="M2061"/>
      <xsl:apply-templates select="/" mode="M2062"/>
      <xsl:apply-templates select="/" mode="M2063"/>
      <xsl:apply-templates select="/" mode="M2064"/>
      <xsl:apply-templates select="/" mode="M2065"/>
      <xsl:apply-templates select="/" mode="M2066"/>
      <xsl:apply-templates select="/" mode="M2067"/>
      <xsl:apply-templates select="/" mode="M2068"/>
      <xsl:apply-templates select="/" mode="M2069"/>
      <xsl:apply-templates select="/" mode="M2070"/>
      <xsl:apply-templates select="/" mode="M2071"/>
      <xsl:apply-templates select="/" mode="M2072"/>
      <xsl:apply-templates select="/" mode="M2073"/>
      <xsl:apply-templates select="/" mode="M2074"/>
      <xsl:apply-templates select="/" mode="M2075"/>
      <xsl:apply-templates select="/" mode="M2076"/>
      <xsl:apply-templates select="/" mode="M2077"/>
      <xsl:apply-templates select="/" mode="M2078"/>
      <xsl:apply-templates select="/" mode="M2079"/>
      <xsl:apply-templates select="/" mode="M2080"/>
      <xsl:apply-templates select="/" mode="M2081"/>
      <xsl:apply-templates select="/" mode="M2082"/>
      <xsl:apply-templates select="/" mode="M2083"/>
      <xsl:apply-templates select="/" mode="M2084"/>
      <xsl:apply-templates select="/" mode="M2085"/>
      <xsl:apply-templates select="/" mode="M2086"/>
      <xsl:apply-templates select="/" mode="M2087"/>
      <xsl:apply-templates select="/" mode="M2088"/>
      <xsl:apply-templates select="/" mode="M2089"/>
      <xsl:apply-templates select="/" mode="M2090"/>
      <xsl:apply-templates select="/" mode="M2091"/>
      <xsl:apply-templates select="/" mode="M2092"/>
      <xsl:apply-templates select="/" mode="M2093"/>
      <xsl:apply-templates select="/" mode="M2094"/>
      <xsl:apply-templates select="/" mode="M2095"/>
      <xsl:apply-templates select="/" mode="M2096"/>
      <xsl:apply-templates select="/" mode="M2097"/>
      <xsl:apply-templates select="/" mode="M2098"/>
      <xsl:apply-templates select="/" mode="M2099"/>
      <xsl:apply-templates select="/" mode="M2100"/>
      <xsl:apply-templates select="/" mode="M2101"/>
      <xsl:apply-templates select="/" mode="M2102"/>
      <xsl:apply-templates select="/" mode="M2103"/>
      <xsl:apply-templates select="/" mode="M2104"/>
      <xsl:apply-templates select="/" mode="M2105"/>
      <xsl:apply-templates select="/" mode="M2106"/>
      <xsl:apply-templates select="/" mode="M2107"/>
      <xsl:apply-templates select="/" mode="M2108"/>
      <xsl:apply-templates select="/" mode="M2109"/>
      <xsl:apply-templates select="/" mode="M2110"/>
      <xsl:apply-templates select="/" mode="M2111"/>
      <xsl:apply-templates select="/" mode="M2112"/>
      <xsl:apply-templates select="/" mode="M2113"/>
      <xsl:apply-templates select="/" mode="M2114"/>
      <xsl:apply-templates select="/" mode="M2115"/>
      <xsl:apply-templates select="/" mode="M2116"/>
      <xsl:apply-templates select="/" mode="M2117"/>
      <xsl:apply-templates select="/" mode="M2118"/>
      <xsl:apply-templates select="/" mode="M2119"/>
      <xsl:apply-templates select="/" mode="M2120"/>
      <xsl:apply-templates select="/" mode="M2121"/>
      <xsl:apply-templates select="/" mode="M2122"/>
      <xsl:apply-templates select="/" mode="M2123"/>
      <xsl:apply-templates select="/" mode="M2124"/>
      <xsl:apply-templates select="/" mode="M2125"/>
      <xsl:apply-templates select="/" mode="M2126"/>
      <xsl:apply-templates select="/" mode="M2127"/>
      <xsl:apply-templates select="/" mode="M2128"/>
      <xsl:apply-templates select="/" mode="M2129"/>
      <xsl:apply-templates select="/" mode="M2130"/>
      <xsl:apply-templates select="/" mode="M2131"/>
      <xsl:apply-templates select="/" mode="M2132"/>
      <xsl:apply-templates select="/" mode="M2133"/>
      <xsl:apply-templates select="/" mode="M2134"/>
      <xsl:apply-templates select="/" mode="M2135"/>
      <xsl:apply-templates select="/" mode="M2136"/>
      <xsl:apply-templates select="/" mode="M2137"/>
      <xsl:apply-templates select="/" mode="M2138"/>
      <xsl:apply-templates select="/" mode="M2139"/>
      <xsl:apply-templates select="/" mode="M2140"/>
      <xsl:apply-templates select="/" mode="M2141"/>
      <xsl:apply-templates select="/" mode="M2142"/>
      <xsl:apply-templates select="/" mode="M2143"/>
      <xsl:apply-templates select="/" mode="M2144"/>
      <xsl:apply-templates select="/" mode="M2145"/>
      <xsl:apply-templates select="/" mode="M2146"/>
      <xsl:apply-templates select="/" mode="M2147"/>
      <xsl:apply-templates select="/" mode="M2148"/>
      <xsl:apply-templates select="/" mode="M2149"/>
      <xsl:apply-templates select="/" mode="M2150"/>
      <xsl:apply-templates select="/" mode="M2151"/>
      <xsl:apply-templates select="/" mode="M2152"/>
      <xsl:apply-templates select="/" mode="M2153"/>
      <xsl:apply-templates select="/" mode="M2154"/>
      <xsl:apply-templates select="/" mode="M2155"/>
      <xsl:apply-templates select="/" mode="M2156"/>
      <xsl:apply-templates select="/" mode="M2157"/>
      <xsl:apply-templates select="/" mode="M2158"/>
      <xsl:apply-templates select="/" mode="M2159"/>
      <xsl:apply-templates select="/" mode="M2160"/>
      <xsl:apply-templates select="/" mode="M2161"/>
      <xsl:apply-templates select="/" mode="M2162"/>
      <xsl:apply-templates select="/" mode="M2163"/>
      <xsl:apply-templates select="/" mode="M2164"/>
      <xsl:apply-templates select="/" mode="M2165"/>
      <xsl:apply-templates select="/" mode="M2166"/>
      <xsl:apply-templates select="/" mode="M2167"/>
      <xsl:apply-templates select="/" mode="M2168"/>
      <xsl:apply-templates select="/" mode="M2169"/>
      <xsl:apply-templates select="/" mode="M2170"/>
      <xsl:apply-templates select="/" mode="M2171"/>
      <xsl:apply-templates select="/" mode="M2172"/>
      <xsl:apply-templates select="/" mode="M2173"/>
      <xsl:apply-templates select="/" mode="M2174"/>
      <xsl:apply-templates select="/" mode="M2175"/>
      <xsl:apply-templates select="/" mode="M2176"/>
      <xsl:apply-templates select="/" mode="M2177"/>
      <xsl:apply-templates select="/" mode="M2178"/>
      <xsl:apply-templates select="/" mode="M2179"/>
      <xsl:apply-templates select="/" mode="M2180"/>
      <xsl:apply-templates select="/" mode="M2181"/>
      <xsl:apply-templates select="/" mode="M2182"/>
      <xsl:apply-templates select="/" mode="M2183"/>
      <xsl:apply-templates select="/" mode="M2184"/>
      <xsl:apply-templates select="/" mode="M2185"/>
      <xsl:apply-templates select="/" mode="M2186"/>
      <xsl:apply-templates select="/" mode="M2187"/>
      <xsl:apply-templates select="/" mode="M2188"/>
      <xsl:apply-templates select="/" mode="M2189"/>
      <xsl:apply-templates select="/" mode="M2190"/>
      <xsl:apply-templates select="/" mode="M2191"/>
      <xsl:apply-templates select="/" mode="M2192"/>
      <xsl:apply-templates select="/" mode="M2193"/>
      <xsl:apply-templates select="/" mode="M2194"/>
      <xsl:apply-templates select="/" mode="M2195"/>
      <xsl:apply-templates select="/" mode="M2196"/>
      <xsl:apply-templates select="/" mode="M2197"/>
      <xsl:apply-templates select="/" mode="M2198"/>
      <xsl:apply-templates select="/" mode="M2199"/>
      <xsl:apply-templates select="/" mode="M2200"/>
      <xsl:apply-templates select="/" mode="M2201"/>
      <xsl:apply-templates select="/" mode="M2202"/>
      <xsl:apply-templates select="/" mode="M2203"/>
      <xsl:apply-templates select="/" mode="M2204"/>
      <xsl:apply-templates select="/" mode="M2205"/>
      <xsl:apply-templates select="/" mode="M2206"/>
      <xsl:apply-templates select="/" mode="M2207"/>
      <xsl:apply-templates select="/" mode="M2208"/>
      <xsl:apply-templates select="/" mode="M2209"/>
      <xsl:apply-templates select="/" mode="M2210"/>
      <xsl:apply-templates select="/" mode="M2211"/>
      <xsl:apply-templates select="/" mode="M2212"/>
      <xsl:apply-templates select="/" mode="M2213"/>
      <xsl:apply-templates select="/" mode="M2214"/>
      <xsl:apply-templates select="/" mode="M2215"/>
      <xsl:apply-templates select="/" mode="M2216"/>
      <xsl:apply-templates select="/" mode="M2217"/>
      <xsl:apply-templates select="/" mode="M2218"/>
      <xsl:apply-templates select="/" mode="M2219"/>
      <xsl:apply-templates select="/" mode="M2220"/>
      <xsl:apply-templates select="/" mode="M2221"/>
      <xsl:apply-templates select="/" mode="M2222"/>
      <xsl:apply-templates select="/" mode="M2223"/>
      <xsl:apply-templates select="/" mode="M2224"/>
      <xsl:apply-templates select="/" mode="M2225"/>
      <xsl:apply-templates select="/" mode="M2226"/>
      <xsl:apply-templates select="/" mode="M2227"/>
      <xsl:apply-templates select="/" mode="M2228"/>
      <xsl:apply-templates select="/" mode="M2229"/>
      <xsl:apply-templates select="/" mode="M2230"/>
      <xsl:apply-templates select="/" mode="M2231"/>
      <xsl:apply-templates select="/" mode="M2232"/>
      <xsl:apply-templates select="/" mode="M2233"/>
      <xsl:apply-templates select="/" mode="M2234"/>
      <xsl:apply-templates select="/" mode="M2235"/>
      <xsl:apply-templates select="/" mode="M2236"/>
      <xsl:apply-templates select="/" mode="M2237"/>
      <xsl:apply-templates select="/" mode="M2238"/>
      <xsl:apply-templates select="/" mode="M2239"/>
      <xsl:apply-templates select="/" mode="M2240"/>
      <xsl:apply-templates select="/" mode="M2241"/>
      <xsl:apply-templates select="/" mode="M2242"/>
      <xsl:apply-templates select="/" mode="M2243"/>
      <xsl:apply-templates select="/" mode="M2244"/>
      <xsl:apply-templates select="/" mode="M2245"/>
      <xsl:apply-templates select="/" mode="M2246"/>
      <xsl:apply-templates select="/" mode="M2247"/>
      <xsl:apply-templates select="/" mode="M2248"/>
      <xsl:apply-templates select="/" mode="M2249"/>
      <xsl:apply-templates select="/" mode="M2250"/>
      <xsl:apply-templates select="/" mode="M2251"/>
      <xsl:apply-templates select="/" mode="M2252"/>
      <xsl:apply-templates select="/" mode="M2253"/>
      <xsl:apply-templates select="/" mode="M2254"/>
      <xsl:apply-templates select="/" mode="M2255"/>
      <xsl:apply-templates select="/" mode="M2256"/>
      <xsl:apply-templates select="/" mode="M2257"/>
      <xsl:apply-templates select="/" mode="M2258"/>
      <xsl:apply-templates select="/" mode="M2259"/>
      <xsl:apply-templates select="/" mode="M2260"/>
      <xsl:apply-templates select="/" mode="M2261"/>
      <xsl:apply-templates select="/" mode="M2262"/>
      <xsl:apply-templates select="/" mode="M2263"/>
      <xsl:apply-templates select="/" mode="M2264"/>
      <xsl:apply-templates select="/" mode="M2265"/>
      <xsl:apply-templates select="/" mode="M2266"/>
      <xsl:apply-templates select="/" mode="M2267"/>
      <xsl:apply-templates select="/" mode="M2268"/>
      <xsl:apply-templates select="/" mode="M2269"/>
      <xsl:apply-templates select="/" mode="M2270"/>
      <xsl:apply-templates select="/" mode="M2271"/>
      <xsl:apply-templates select="/" mode="M2272"/>
      <xsl:apply-templates select="/" mode="M2273"/>
      <xsl:apply-templates select="/" mode="M2274"/>
      <xsl:apply-templates select="/" mode="M2275"/>
      <xsl:apply-templates select="/" mode="M2276"/>
      <xsl:apply-templates select="/" mode="M2277"/>
      <xsl:apply-templates select="/" mode="M2278"/>
      <xsl:apply-templates select="/" mode="M2279"/>
      <xsl:apply-templates select="/" mode="M2280"/>
      <xsl:apply-templates select="/" mode="M2281"/>
      <xsl:apply-templates select="/" mode="M2282"/>
      <xsl:apply-templates select="/" mode="M2283"/>
      <xsl:apply-templates select="/" mode="M2284"/>
      <xsl:apply-templates select="/" mode="M2285"/>
      <xsl:apply-templates select="/" mode="M2286"/>
      <xsl:apply-templates select="/" mode="M2287"/>
      <xsl:apply-templates select="/" mode="M2288"/>
      <xsl:apply-templates select="/" mode="M2289"/>
      <xsl:apply-templates select="/" mode="M2290"/>
      <xsl:apply-templates select="/" mode="M2291"/>
      <xsl:apply-templates select="/" mode="M2292"/>
      <xsl:apply-templates select="/" mode="M2293"/>
      <xsl:apply-templates select="/" mode="M2294"/>
      <xsl:apply-templates select="/" mode="M2295"/>
      <xsl:apply-templates select="/" mode="M2296"/>
      <xsl:apply-templates select="/" mode="M2297"/>
      <xsl:apply-templates select="/" mode="M2298"/>
      <xsl:apply-templates select="/" mode="M2299"/>
      <xsl:apply-templates select="/" mode="M2300"/>
      <xsl:apply-templates select="/" mode="M2301"/>
      <xsl:apply-templates select="/" mode="M2302"/>
      <xsl:apply-templates select="/" mode="M2303"/>
      <xsl:apply-templates select="/" mode="M2304"/>
      <xsl:apply-templates select="/" mode="M2305"/>
      <xsl:apply-templates select="/" mode="M2306"/>
      <xsl:apply-templates select="/" mode="M2307"/>
      <xsl:apply-templates select="/" mode="M2308"/>
      <xsl:apply-templates select="/" mode="M2309"/>
      <xsl:apply-templates select="/" mode="M2310"/>
      <xsl:apply-templates select="/" mode="M2311"/>
      <xsl:apply-templates select="/" mode="M2312"/>
      <xsl:apply-templates select="/" mode="M2313"/>
      <xsl:apply-templates select="/" mode="M2314"/>
      <xsl:apply-templates select="/" mode="M2315"/>
      <xsl:apply-templates select="/" mode="M2316"/>
      <xsl:apply-templates select="/" mode="M2317"/>
      <xsl:apply-templates select="/" mode="M2318"/>
      <xsl:apply-templates select="/" mode="M2319"/>
      <xsl:apply-templates select="/" mode="M2320"/>
      <xsl:apply-templates select="/" mode="M2321"/>
      <xsl:apply-templates select="/" mode="M2322"/>
      <xsl:apply-templates select="/" mode="M2323"/>
      <xsl:apply-templates select="/" mode="M2324"/>
      <xsl:apply-templates select="/" mode="M2325"/>
      <xsl:apply-templates select="/" mode="M2326"/>
      <xsl:apply-templates select="/" mode="M2327"/>
      <xsl:apply-templates select="/" mode="M2328"/>
      <xsl:apply-templates select="/" mode="M2329"/>
      <xsl:apply-templates select="/" mode="M2330"/>
      <xsl:apply-templates select="/" mode="M2331"/>
      <xsl:apply-templates select="/" mode="M2332"/>
      <xsl:apply-templates select="/" mode="M2333"/>
      <xsl:apply-templates select="/" mode="M2334"/>
      <xsl:apply-templates select="/" mode="M2335"/>
      <xsl:apply-templates select="/" mode="M2336"/>
      <xsl:apply-templates select="/" mode="M2337"/>
      <xsl:apply-templates select="/" mode="M2338"/>
      <xsl:apply-templates select="/" mode="M2339"/>
      <xsl:apply-templates select="/" mode="M2340"/>
      <xsl:apply-templates select="/" mode="M2341"/>
      <xsl:apply-templates select="/" mode="M2342"/>
      <xsl:apply-templates select="/" mode="M2343"/>
      <xsl:apply-templates select="/" mode="M2344"/>
      <xsl:apply-templates select="/" mode="M2345"/>
      <xsl:apply-templates select="/" mode="M2346"/>
      <xsl:apply-templates select="/" mode="M2347"/>
      <xsl:apply-templates select="/" mode="M2348"/>
      <xsl:apply-templates select="/" mode="M2349"/>
      <xsl:apply-templates select="/" mode="M2350"/>
      <xsl:apply-templates select="/" mode="M2351"/>
      <xsl:apply-templates select="/" mode="M2352"/>
      <xsl:apply-templates select="/" mode="M2353"/>
      <xsl:apply-templates select="/" mode="M2354"/>
      <xsl:apply-templates select="/" mode="M2355"/>
      <xsl:apply-templates select="/" mode="M2356"/>
      <xsl:apply-templates select="/" mode="M2357"/>
      <xsl:apply-templates select="/" mode="M2358"/>
      <xsl:apply-templates select="/" mode="M2359"/>
      <xsl:apply-templates select="/" mode="M2360"/>
      <xsl:apply-templates select="/" mode="M2361"/>
      <xsl:apply-templates select="/" mode="M2362"/>
      <xsl:apply-templates select="/" mode="M2363"/>
      <xsl:apply-templates select="/" mode="M2364"/>
      <xsl:apply-templates select="/" mode="M2365"/>
      <xsl:apply-templates select="/" mode="M2366"/>
      <xsl:apply-templates select="/" mode="M2367"/>
      <xsl:apply-templates select="/" mode="M2368"/>
      <xsl:apply-templates select="/" mode="M2369"/>
      <xsl:apply-templates select="/" mode="M2370"/>
      <xsl:apply-templates select="/" mode="M2371"/>
      <xsl:apply-templates select="/" mode="M2372"/>
      <xsl:apply-templates select="/" mode="M2373"/>
      <xsl:apply-templates select="/" mode="M2374"/>
      <xsl:apply-templates select="/" mode="M2375"/>
      <xsl:apply-templates select="/" mode="M2376"/>
      <xsl:apply-templates select="/" mode="M2377"/>
      <xsl:apply-templates select="/" mode="M2378"/>
      <xsl:apply-templates select="/" mode="M2379"/>
      <xsl:apply-templates select="/" mode="M2380"/>
      <xsl:apply-templates select="/" mode="M2381"/>
      <xsl:apply-templates select="/" mode="M2382"/>
      <xsl:apply-templates select="/" mode="M2383"/>
      <xsl:apply-templates select="/" mode="M2384"/>
      <xsl:apply-templates select="/" mode="M2385"/>
      <xsl:apply-templates select="/" mode="M2386"/>
      <xsl:apply-templates select="/" mode="M2387"/>
      <xsl:apply-templates select="/" mode="M2388"/>
      <xsl:apply-templates select="/" mode="M2389"/>
      <xsl:apply-templates select="/" mode="M2390"/>
      <xsl:apply-templates select="/" mode="M2391"/>
      <xsl:apply-templates select="/" mode="M2392"/>
      <xsl:apply-templates select="/" mode="M2393"/>
      <xsl:apply-templates select="/" mode="M2394"/>
      <xsl:apply-templates select="/" mode="M2395"/>
      <xsl:apply-templates select="/" mode="M2396"/>
      <xsl:apply-templates select="/" mode="M2397"/>
      <xsl:apply-templates select="/" mode="M2398"/>
      <xsl:apply-templates select="/" mode="M2399"/>
      <xsl:apply-templates select="/" mode="M2400"/>
      <xsl:apply-templates select="/" mode="M2401"/>
      <xsl:apply-templates select="/" mode="M2402"/>
      <xsl:apply-templates select="/" mode="M2403"/>
      <xsl:apply-templates select="/" mode="M2404"/>
      <xsl:apply-templates select="/" mode="M2405"/>
      <xsl:apply-templates select="/" mode="M2406"/>
      <xsl:apply-templates select="/" mode="M2407"/>
      <xsl:apply-templates select="/" mode="M2408"/>
      <xsl:apply-templates select="/" mode="M2409"/>
      <xsl:apply-templates select="/" mode="M2410"/>
      <xsl:apply-templates select="/" mode="M2411"/>
      <xsl:apply-templates select="/" mode="M2412"/>
      <xsl:apply-templates select="/" mode="M2413"/>
      <xsl:apply-templates select="/" mode="M2414"/>
      <xsl:apply-templates select="/" mode="M2415"/>
      <xsl:apply-templates select="/" mode="M2416"/>
      <xsl:apply-templates select="/" mode="M2417"/>
      <xsl:apply-templates select="/" mode="M2418"/>
      <xsl:apply-templates select="/" mode="M2419"/>
      <xsl:apply-templates select="/" mode="M2420"/>
      <xsl:apply-templates select="/" mode="M2421"/>
      <xsl:apply-templates select="/" mode="M2422"/>
      <xsl:apply-templates select="/" mode="M2423"/>
      <xsl:apply-templates select="/" mode="M2424"/>
      <xsl:apply-templates select="/" mode="M2425"/>
      <xsl:apply-templates select="/" mode="M2426"/>
      <xsl:apply-templates select="/" mode="M2427"/>
      <xsl:apply-templates select="/" mode="M2428"/>
      <xsl:apply-templates select="/" mode="M2429"/>
      <xsl:apply-templates select="/" mode="M2430"/>
      <xsl:apply-templates select="/" mode="M2431"/>
      <xsl:apply-templates select="/" mode="M2432"/>
      <xsl:apply-templates select="/" mode="M2433"/>
      <xsl:apply-templates select="/" mode="M2434"/>
      <xsl:apply-templates select="/" mode="M2435"/>
      <xsl:apply-templates select="/" mode="M2436"/>
      <xsl:apply-templates select="/" mode="M2437"/>
      <xsl:apply-templates select="/" mode="M2438"/>
      <xsl:apply-templates select="/" mode="M2439"/>
      <xsl:apply-templates select="/" mode="M2440"/>
      <xsl:apply-templates select="/" mode="M2441"/>
      <xsl:apply-templates select="/" mode="M2442"/>
      <xsl:apply-templates select="/" mode="M2443"/>
      <xsl:apply-templates select="/" mode="M2444"/>
      <xsl:apply-templates select="/" mode="M2445"/>
      <xsl:apply-templates select="/" mode="M2446"/>
      <xsl:apply-templates select="/" mode="M2447"/>
      <xsl:apply-templates select="/" mode="M2448"/>
      <xsl:apply-templates select="/" mode="M2449"/>
      <xsl:apply-templates select="/" mode="M2450"/>
      <xsl:apply-templates select="/" mode="M2451"/>
      <xsl:apply-templates select="/" mode="M2452"/>
      <xsl:apply-templates select="/" mode="M2453"/>
      <xsl:apply-templates select="/" mode="M2454"/>
      <xsl:apply-templates select="/" mode="M2455"/>
      <xsl:apply-templates select="/" mode="M2456"/>
      <xsl:apply-templates select="/" mode="M2457"/>
      <xsl:apply-templates select="/" mode="M2458"/>
      <xsl:apply-templates select="/" mode="M2459"/>
      <xsl:apply-templates select="/" mode="M2460"/>
      <xsl:apply-templates select="/" mode="M2461"/>
      <xsl:apply-templates select="/" mode="M2462"/>
      <xsl:apply-templates select="/" mode="M2463"/>
      <xsl:apply-templates select="/" mode="M2464"/>
      <xsl:apply-templates select="/" mode="M2465"/>
      <xsl:apply-templates select="/" mode="M2466"/>
      <xsl:apply-templates select="/" mode="M2467"/>
      <xsl:apply-templates select="/" mode="M2468"/>
      <xsl:apply-templates select="/" mode="M2469"/>
      <xsl:apply-templates select="/" mode="M2470"/>
      <xsl:apply-templates select="/" mode="M2471"/>
      <xsl:apply-templates select="/" mode="M2472"/>
      <xsl:apply-templates select="/" mode="M2473"/>
      <xsl:apply-templates select="/" mode="M2474"/>
      <xsl:apply-templates select="/" mode="M2475"/>
      <xsl:apply-templates select="/" mode="M2476"/>
      <xsl:apply-templates select="/" mode="M2477"/>
      <xsl:apply-templates select="/" mode="M2478"/>
      <xsl:apply-templates select="/" mode="M2479"/>
      <xsl:apply-templates select="/" mode="M2480"/>
      <xsl:apply-templates select="/" mode="M2481"/>
      <xsl:apply-templates select="/" mode="M2482"/>
      <xsl:apply-templates select="/" mode="M2483"/>
      <xsl:apply-templates select="/" mode="M2484"/>
      <xsl:apply-templates select="/" mode="M2485"/>
      <xsl:apply-templates select="/" mode="M2486"/>
      <xsl:apply-templates select="/" mode="M2487"/>
      <xsl:apply-templates select="/" mode="M2488"/>
      <xsl:apply-templates select="/" mode="M2489"/>
      <xsl:apply-templates select="/" mode="M2490"/>
      <xsl:apply-templates select="/" mode="M2491"/>
      <xsl:apply-templates select="/" mode="M2492"/>
      <xsl:apply-templates select="/" mode="M2493"/>
      <xsl:apply-templates select="/" mode="M2494"/>
      <xsl:apply-templates select="/" mode="M2495"/>
      <xsl:apply-templates select="/" mode="M2496"/>
      <xsl:apply-templates select="/" mode="M2497"/>
      <xsl:apply-templates select="/" mode="M2498"/>
      <xsl:apply-templates select="/" mode="M2499"/>
      <xsl:apply-templates select="/" mode="M2500"/>
      <xsl:apply-templates select="/" mode="M2501"/>
      <xsl:apply-templates select="/" mode="M2502"/>
      <xsl:apply-templates select="/" mode="M2503"/>
      <xsl:apply-templates select="/" mode="M2504"/>
      <xsl:apply-templates select="/" mode="M2505"/>
      <xsl:apply-templates select="/" mode="M2506"/>
      <xsl:apply-templates select="/" mode="M2507"/>
      <xsl:apply-templates select="/" mode="M2508"/>
      <xsl:apply-templates select="/" mode="M2509"/>
      <xsl:apply-templates select="/" mode="M2510"/>
      <xsl:apply-templates select="/" mode="M2511"/>
      <xsl:apply-templates select="/" mode="M2512"/>
      <xsl:apply-templates select="/" mode="M2513"/>
      <xsl:apply-templates select="/" mode="M2514"/>
      <xsl:apply-templates select="/" mode="M2515"/>
      <xsl:apply-templates select="/" mode="M2516"/>
      <xsl:apply-templates select="/" mode="M2517"/>
      <xsl:apply-templates select="/" mode="M2518"/>
      <xsl:apply-templates select="/" mode="M2519"/>
      <xsl:apply-templates select="/" mode="M2520"/>
      <xsl:apply-templates select="/" mode="M2521"/>
      <xsl:apply-templates select="/" mode="M2522"/>
      <xsl:apply-templates select="/" mode="M2523"/>
      <xsl:apply-templates select="/" mode="M2524"/>
      <xsl:apply-templates select="/" mode="M2525"/>
      <xsl:apply-templates select="/" mode="M2526"/>
      <xsl:apply-templates select="/" mode="M2527"/>
      <xsl:apply-templates select="/" mode="M2528"/>
      <xsl:apply-templates select="/" mode="M2529"/>
      <xsl:apply-templates select="/" mode="M2530"/>
      <xsl:apply-templates select="/" mode="M2531"/>
      <xsl:apply-templates select="/" mode="M2532"/>
      <xsl:apply-templates select="/" mode="M2533"/>
      <xsl:apply-templates select="/" mode="M2534"/>
      <xsl:apply-templates select="/" mode="M2535"/>
      <xsl:apply-templates select="/" mode="M2536"/>
      <xsl:apply-templates select="/" mode="M2537"/>
      <xsl:apply-templates select="/" mode="M2538"/>
      <xsl:apply-templates select="/" mode="M2539"/>
      <xsl:apply-templates select="/" mode="M2540"/>
      <xsl:apply-templates select="/" mode="M2541"/>
      <xsl:apply-templates select="/" mode="M2542"/>
      <xsl:apply-templates select="/" mode="M2543"/>
      <xsl:apply-templates select="/" mode="M2544"/>
      <xsl:apply-templates select="/" mode="M2545"/>
      <xsl:apply-templates select="/" mode="M2546"/>
      <xsl:apply-templates select="/" mode="M2547"/>
      <xsl:apply-templates select="/" mode="M2548"/>
      <xsl:apply-templates select="/" mode="M2549"/>
      <xsl:apply-templates select="/" mode="M2550"/>
      <xsl:apply-templates select="/" mode="M2551"/>
      <xsl:apply-templates select="/" mode="M2552"/>
      <xsl:apply-templates select="/" mode="M2553"/>
      <xsl:apply-templates select="/" mode="M2554"/>
      <xsl:apply-templates select="/" mode="M2555"/>
      <xsl:apply-templates select="/" mode="M2556"/>
      <xsl:apply-templates select="/" mode="M2557"/>
      <xsl:apply-templates select="/" mode="M2558"/>
      <xsl:apply-templates select="/" mode="M2559"/>
      <xsl:apply-templates select="/" mode="M2560"/>
      <xsl:apply-templates select="/" mode="M2561"/>
      <xsl:apply-templates select="/" mode="M2562"/>
      <xsl:apply-templates select="/" mode="M2563"/>
      <xsl:apply-templates select="/" mode="M2564"/>
      <xsl:apply-templates select="/" mode="M2565"/>
      <xsl:apply-templates select="/" mode="M2566"/>
      <xsl:apply-templates select="/" mode="M2567"/>
      <xsl:apply-templates select="/" mode="M2568"/>
      <xsl:apply-templates select="/" mode="M2569"/>
      <xsl:apply-templates select="/" mode="M2570"/>
      <xsl:apply-templates select="/" mode="M2571"/>
      <xsl:apply-templates select="/" mode="M2572"/>
      <xsl:apply-templates select="/" mode="M2573"/>
      <xsl:apply-templates select="/" mode="M2574"/>
      <xsl:apply-templates select="/" mode="M2575"/>
      <xsl:apply-templates select="/" mode="M2576"/>
      <xsl:apply-templates select="/" mode="M2577"/>
      <xsl:apply-templates select="/" mode="M2578"/>
      <xsl:apply-templates select="/" mode="M2579"/>
      <xsl:apply-templates select="/" mode="M2580"/>
      <xsl:apply-templates select="/" mode="M2581"/>
      <xsl:apply-templates select="/" mode="M2582"/>
      <xsl:apply-templates select="/" mode="M2583"/>
      <xsl:apply-templates select="/" mode="M2584"/>
      <xsl:apply-templates select="/" mode="M2585"/>
      <xsl:apply-templates select="/" mode="M2586"/>
      <xsl:apply-templates select="/" mode="M2587"/>
      <xsl:apply-templates select="/" mode="M2588"/>
      <xsl:apply-templates select="/" mode="M2589"/>
      <xsl:apply-templates select="/" mode="M2590"/>
      <xsl:apply-templates select="/" mode="M2591"/>
      <xsl:apply-templates select="/" mode="M2592"/>
      <xsl:apply-templates select="/" mode="M2593"/>
      <xsl:apply-templates select="/" mode="M2594"/>
      <xsl:apply-templates select="/" mode="M2595"/>
      <xsl:apply-templates select="/" mode="M2596"/>
      <xsl:apply-templates select="/" mode="M2597"/>
      <xsl:apply-templates select="/" mode="M2598"/>
      <xsl:apply-templates select="/" mode="M2599"/>
      <xsl:apply-templates select="/" mode="M2600"/>
      <xsl:apply-templates select="/" mode="M2601"/>
      <xsl:apply-templates select="/" mode="M2602"/>
      <xsl:apply-templates select="/" mode="M2603"/>
      <xsl:apply-templates select="/" mode="M2604"/>
      <xsl:apply-templates select="/" mode="M2605"/>
      <xsl:apply-templates select="/" mode="M2606"/>
      <xsl:apply-templates select="/" mode="M2607"/>
      <xsl:apply-templates select="/" mode="M2608"/>
      <xsl:apply-templates select="/" mode="M2609"/>
      <xsl:apply-templates select="/" mode="M2610"/>
      <xsl:apply-templates select="/" mode="M2611"/>
      <xsl:apply-templates select="/" mode="M2612"/>
      <xsl:apply-templates select="/" mode="M2613"/>
      <xsl:apply-templates select="/" mode="M2614"/>
      <xsl:apply-templates select="/" mode="M2615"/>
      <xsl:apply-templates select="/" mode="M2616"/>
      <xsl:apply-templates select="/" mode="M2617"/>
      <xsl:apply-templates select="/" mode="M2618"/>
      <xsl:apply-templates select="/" mode="M2619"/>
      <xsl:apply-templates select="/" mode="M2620"/>
      <xsl:apply-templates select="/" mode="M2621"/>
      <xsl:apply-templates select="/" mode="M2622"/>
      <xsl:apply-templates select="/" mode="M2623"/>
      <xsl:apply-templates select="/" mode="M2624"/>
      <xsl:apply-templates select="/" mode="M2625"/>
      <xsl:apply-templates select="/" mode="M2626"/>
      <xsl:apply-templates select="/" mode="M2627"/>
      <xsl:apply-templates select="/" mode="M2628"/>
      <xsl:apply-templates select="/" mode="M2629"/>
      <xsl:apply-templates select="/" mode="M2630"/>
      <xsl:apply-templates select="/" mode="M2631"/>
      <xsl:apply-templates select="/" mode="M2632"/>
      <xsl:apply-templates select="/" mode="M2633"/>
      <xsl:apply-templates select="/" mode="M2634"/>
      <xsl:apply-templates select="/" mode="M2635"/>
      <xsl:apply-templates select="/" mode="M2636"/>
      <xsl:apply-templates select="/" mode="M2637"/>
      <xsl:apply-templates select="/" mode="M2638"/>
      <xsl:apply-templates select="/" mode="M2639"/>
      <xsl:apply-templates select="/" mode="M2640"/>
      <xsl:apply-templates select="/" mode="M2641"/>
      <xsl:apply-templates select="/" mode="M2642"/>
      <xsl:apply-templates select="/" mode="M2643"/>
      <xsl:apply-templates select="/" mode="M2644"/>
      <xsl:apply-templates select="/" mode="M2645"/>
      <xsl:apply-templates select="/" mode="M2646"/>
      <xsl:apply-templates select="/" mode="M2647"/>
      <xsl:apply-templates select="/" mode="M2648"/>
      <xsl:apply-templates select="/" mode="M2649"/>
      <xsl:apply-templates select="/" mode="M2650"/>
      <xsl:apply-templates select="/" mode="M2651"/>
      <xsl:apply-templates select="/" mode="M2652"/>
      <xsl:apply-templates select="/" mode="M2653"/>
      <xsl:apply-templates select="/" mode="M2654"/>
      <xsl:apply-templates select="/" mode="M2655"/>
      <xsl:apply-templates select="/" mode="M2656"/>
      <xsl:apply-templates select="/" mode="M2657"/>
      <xsl:apply-templates select="/" mode="M2658"/>
      <xsl:apply-templates select="/" mode="M2659"/>
      <xsl:apply-templates select="/" mode="M2660"/>
      <xsl:apply-templates select="/" mode="M2661"/>
      <xsl:apply-templates select="/" mode="M2662"/>
      <xsl:apply-templates select="/" mode="M2663"/>
      <xsl:apply-templates select="/" mode="M2664"/>
      <xsl:apply-templates select="/" mode="M2665"/>
      <xsl:apply-templates select="/" mode="M2666"/>
      <xsl:apply-templates select="/" mode="M2667"/>
      <xsl:apply-templates select="/" mode="M2668"/>
      <xsl:apply-templates select="/" mode="M2669"/>
      <xsl:apply-templates select="/" mode="M2670"/>
      <xsl:apply-templates select="/" mode="M2671"/>
      <xsl:apply-templates select="/" mode="M2672"/>
      <xsl:apply-templates select="/" mode="M2673"/>
      <xsl:apply-templates select="/" mode="M2674"/>
      <xsl:apply-templates select="/" mode="M2675"/>
      <xsl:apply-templates select="/" mode="M2676"/>
      <xsl:apply-templates select="/" mode="M2677"/>
      <xsl:apply-templates select="/" mode="M2678"/>
      <xsl:apply-templates select="/" mode="M2679"/>
      <xsl:apply-templates select="/" mode="M2680"/>
      <xsl:apply-templates select="/" mode="M2681"/>
      <xsl:apply-templates select="/" mode="M2682"/>
      <xsl:apply-templates select="/" mode="M2683"/>
      <xsl:apply-templates select="/" mode="M2684"/>
      <xsl:apply-templates select="/" mode="M2685"/>
      <xsl:apply-templates select="/" mode="M2686"/>
      <xsl:apply-templates select="/" mode="M2687"/>
      <xsl:apply-templates select="/" mode="M2688"/>
      <xsl:apply-templates select="/" mode="M2689"/>
      <xsl:apply-templates select="/" mode="M2690"/>
      <xsl:apply-templates select="/" mode="M2691"/>
      <xsl:apply-templates select="/" mode="M2692"/>
      <xsl:apply-templates select="/" mode="M2693"/>
      <xsl:apply-templates select="/" mode="M2694"/>
      <xsl:apply-templates select="/" mode="M2695"/>
      <xsl:apply-templates select="/" mode="M2696"/>
      <xsl:apply-templates select="/" mode="M2697"/>
      <xsl:apply-templates select="/" mode="M2698"/>
      <xsl:apply-templates select="/" mode="M2699"/>
      <xsl:apply-templates select="/" mode="M2700"/>
      <xsl:apply-templates select="/" mode="M2701"/>
      <xsl:apply-templates select="/" mode="M2702"/>
      <xsl:apply-templates select="/" mode="M2703"/>
      <xsl:apply-templates select="/" mode="M2704"/>
      <xsl:apply-templates select="/" mode="M2705"/>
      <xsl:apply-templates select="/" mode="M2706"/>
      <xsl:apply-templates select="/" mode="M2707"/>
      <xsl:apply-templates select="/" mode="M2708"/>
      <xsl:apply-templates select="/" mode="M2709"/>
      <xsl:apply-templates select="/" mode="M2710"/>
      <xsl:apply-templates select="/" mode="M2711"/>
      <xsl:apply-templates select="/" mode="M2712"/>
      <xsl:apply-templates select="/" mode="M2713"/>
      <xsl:apply-templates select="/" mode="M2714"/>
      <xsl:apply-templates select="/" mode="M2715"/>
      <xsl:apply-templates select="/" mode="M2716"/>
      <xsl:apply-templates select="/" mode="M2717"/>
      <xsl:apply-templates select="/" mode="M2718"/>
      <xsl:apply-templates select="/" mode="M2719"/>
      <xsl:apply-templates select="/" mode="M2720"/>
      <xsl:apply-templates select="/" mode="M2721"/>
      <xsl:apply-templates select="/" mode="M2722"/>
      <xsl:apply-templates select="/" mode="M2723"/>
      <xsl:apply-templates select="/" mode="M2724"/>
      <xsl:apply-templates select="/" mode="M2725"/>
      <xsl:apply-templates select="/" mode="M2726"/>
      <xsl:apply-templates select="/" mode="M2727"/>
      <xsl:apply-templates select="/" mode="M2728"/>
      <xsl:apply-templates select="/" mode="M2729"/>
      <xsl:apply-templates select="/" mode="M2730"/>
      <xsl:apply-templates select="/" mode="M2731"/>
      <xsl:apply-templates select="/" mode="M2732"/>
      <xsl:apply-templates select="/" mode="M2733"/>
      <xsl:apply-templates select="/" mode="M2734"/>
      <xsl:apply-templates select="/" mode="M2735"/>
      <xsl:apply-templates select="/" mode="M2736"/>
      <xsl:apply-templates select="/" mode="M2737"/>
      <xsl:apply-templates select="/" mode="M2738"/>
      <xsl:apply-templates select="/" mode="M2739"/>
      <xsl:apply-templates select="/" mode="M2740"/>
      <xsl:apply-templates select="/" mode="M2741"/>
      <xsl:apply-templates select="/" mode="M2742"/>
      <xsl:apply-templates select="/" mode="M2743"/>
      <xsl:apply-templates select="/" mode="M2744"/>
      <xsl:apply-templates select="/" mode="M2745"/>
      <xsl:apply-templates select="/" mode="M2746"/>
      <xsl:apply-templates select="/" mode="M2747"/>
      <xsl:apply-templates select="/" mode="M2748"/>
      <xsl:apply-templates select="/" mode="M2749"/>
      <xsl:apply-templates select="/" mode="M2750"/>
      <xsl:apply-templates select="/" mode="M2751"/>
      <xsl:apply-templates select="/" mode="M2752"/>
      <xsl:apply-templates select="/" mode="M2753"/>
      <xsl:apply-templates select="/" mode="M2754"/>
      <xsl:apply-templates select="/" mode="M2755"/>
      <xsl:apply-templates select="/" mode="M2756"/>
      <xsl:apply-templates select="/" mode="M2757"/>
      <xsl:apply-templates select="/" mode="M2758"/>
      <xsl:apply-templates select="/" mode="M2759"/>
      <xsl:apply-templates select="/" mode="M2760"/>
      <xsl:apply-templates select="/" mode="M2761"/>
      <xsl:apply-templates select="/" mode="M2762"/>
      <xsl:apply-templates select="/" mode="M2763"/>
      <xsl:apply-templates select="/" mode="M2764"/>
      <xsl:apply-templates select="/" mode="M2765"/>
      <xsl:apply-templates select="/" mode="M2766"/>
      <xsl:apply-templates select="/" mode="M2767"/>
      <xsl:apply-templates select="/" mode="M2768"/>
      <xsl:apply-templates select="/" mode="M2769"/>
      <xsl:apply-templates select="/" mode="M2770"/>
      <xsl:apply-templates select="/" mode="M2771"/>
      <xsl:apply-templates select="/" mode="M2772"/>
      <xsl:apply-templates select="/" mode="M2773"/>
      <xsl:apply-templates select="/" mode="M2774"/>
      <xsl:apply-templates select="/" mode="M2775"/>
      <xsl:apply-templates select="/" mode="M2776"/>
      <xsl:apply-templates select="/" mode="M2777"/>
      <xsl:apply-templates select="/" mode="M2778"/>
      <xsl:apply-templates select="/" mode="M2779"/>
      <xsl:apply-templates select="/" mode="M2780"/>
      <xsl:apply-templates select="/" mode="M2781"/>
      <xsl:apply-templates select="/" mode="M2782"/>
      <xsl:apply-templates select="/" mode="M2783"/>
      <xsl:apply-templates select="/" mode="M2784"/>
      <xsl:apply-templates select="/" mode="M2785"/>
      <xsl:apply-templates select="/" mode="M2786"/>
      <xsl:apply-templates select="/" mode="M2787"/>
      <xsl:apply-templates select="/" mode="M2788"/>
      <xsl:apply-templates select="/" mode="M2789"/>
      <xsl:apply-templates select="/" mode="M2790"/>
      <xsl:apply-templates select="/" mode="M2791"/>
      <xsl:apply-templates select="/" mode="M2792"/>
      <xsl:apply-templates select="/" mode="M2793"/>
      <xsl:apply-templates select="/" mode="M2794"/>
      <xsl:apply-templates select="/" mode="M2795"/>
      <xsl:apply-templates select="/" mode="M2796"/>
      <xsl:apply-templates select="/" mode="M2797"/>
      <xsl:apply-templates select="/" mode="M2798"/>
      <xsl:apply-templates select="/" mode="M2799"/>
      <xsl:apply-templates select="/" mode="M2800"/>
      <xsl:apply-templates select="/" mode="M2801"/>
      <xsl:apply-templates select="/" mode="M2802"/>
      <xsl:apply-templates select="/" mode="M2803"/>
      <xsl:apply-templates select="/" mode="M2804"/>
      <xsl:apply-templates select="/" mode="M2805"/>
      <xsl:apply-templates select="/" mode="M2806"/>
      <xsl:apply-templates select="/" mode="M2807"/>
      <xsl:apply-templates select="/" mode="M2808"/>
      <xsl:apply-templates select="/" mode="M2809"/>
      <xsl:apply-templates select="/" mode="M2810"/>
      <xsl:apply-templates select="/" mode="M2811"/>
      <xsl:apply-templates select="/" mode="M2812"/>
      <xsl:apply-templates select="/" mode="M2813"/>
      <xsl:apply-templates select="/" mode="M2814"/>
      <xsl:apply-templates select="/" mode="M2815"/>
      <xsl:apply-templates select="/" mode="M2816"/>
      <xsl:apply-templates select="/" mode="M2817"/>
      <xsl:apply-templates select="/" mode="M2818"/>
      <xsl:apply-templates select="/" mode="M2819"/>
      <xsl:apply-templates select="/" mode="M2820"/>
      <xsl:apply-templates select="/" mode="M2821"/>
      <xsl:apply-templates select="/" mode="M2822"/>
      <xsl:apply-templates select="/" mode="M2823"/>
      <xsl:apply-templates select="/" mode="M2824"/>
      <xsl:apply-templates select="/" mode="M2825"/>
      <xsl:apply-templates select="/" mode="M2826"/>
      <xsl:apply-templates select="/" mode="M2827"/>
      <xsl:apply-templates select="/" mode="M2828"/>
      <xsl:apply-templates select="/" mode="M2829"/>
      <xsl:apply-templates select="/" mode="M2830"/>
      <xsl:apply-templates select="/" mode="M2831"/>
      <xsl:apply-templates select="/" mode="M2832"/>
      <xsl:apply-templates select="/" mode="M2833"/>
      <xsl:apply-templates select="/" mode="M2834"/>
      <xsl:apply-templates select="/" mode="M2835"/>
      <xsl:apply-templates select="/" mode="M2836"/>
      <xsl:apply-templates select="/" mode="M2837"/>
      <xsl:apply-templates select="/" mode="M2838"/>
      <xsl:apply-templates select="/" mode="M2839"/>
      <xsl:apply-templates select="/" mode="M2840"/>
      <xsl:apply-templates select="/" mode="M2841"/>
      <xsl:apply-templates select="/" mode="M2842"/>
      <xsl:apply-templates select="/" mode="M2843"/>
      <xsl:apply-templates select="/" mode="M2844"/>
      <xsl:apply-templates select="/" mode="M2845"/>
      <xsl:apply-templates select="/" mode="M2846"/>
      <xsl:apply-templates select="/" mode="M2847"/>
      <xsl:apply-templates select="/" mode="M2848"/>
      <xsl:apply-templates select="/" mode="M2849"/>
      <xsl:apply-templates select="/" mode="M2850"/>
      <xsl:apply-templates select="/" mode="M2851"/>
      <xsl:apply-templates select="/" mode="M2852"/>
      <xsl:apply-templates select="/" mode="M2853"/>
      <xsl:apply-templates select="/" mode="M2854"/>
      <xsl:apply-templates select="/" mode="M2855"/>
      <xsl:apply-templates select="/" mode="M2856"/>
      <xsl:apply-templates select="/" mode="M2857"/>
      <xsl:apply-templates select="/" mode="M2858"/>
      <xsl:apply-templates select="/" mode="M2859"/>
      <xsl:apply-templates select="/" mode="M2860"/>
      <xsl:apply-templates select="/" mode="M2861"/>
      <xsl:apply-templates select="/" mode="M2862"/>
      <xsl:apply-templates select="/" mode="M2863"/>
      <xsl:apply-templates select="/" mode="M2864"/>
      <xsl:apply-templates select="/" mode="M2865"/>
      <xsl:apply-templates select="/" mode="M2866"/>
      <xsl:apply-templates select="/" mode="M2867"/>
      <xsl:apply-templates select="/" mode="M2868"/>
      <xsl:apply-templates select="/" mode="M2869"/>
      <xsl:apply-templates select="/" mode="M2870"/>
      <xsl:apply-templates select="/" mode="M2871"/>
      <xsl:apply-templates select="/" mode="M2872"/>
      <xsl:apply-templates select="/" mode="M2873"/>
      <xsl:apply-templates select="/" mode="M2874"/>
      <xsl:apply-templates select="/" mode="M2875"/>
      <xsl:apply-templates select="/" mode="M2876"/>
      <xsl:apply-templates select="/" mode="M2877"/>
      <xsl:apply-templates select="/" mode="M2878"/>
      <xsl:apply-templates select="/" mode="M2879"/>
      <xsl:apply-templates select="/" mode="M2880"/>
      <xsl:apply-templates select="/" mode="M2881"/>
      <xsl:apply-templates select="/" mode="M2882"/>
      <xsl:apply-templates select="/" mode="M2883"/>
      <xsl:apply-templates select="/" mode="M2884"/>
      <xsl:apply-templates select="/" mode="M2885"/>
      <xsl:apply-templates select="/" mode="M2886"/>
      <xsl:apply-templates select="/" mode="M2887"/>
      <xsl:apply-templates select="/" mode="M2888"/>
      <xsl:apply-templates select="/" mode="M2889"/>
      <xsl:apply-templates select="/" mode="M2890"/>
      <xsl:apply-templates select="/" mode="M2891"/>
      <xsl:apply-templates select="/" mode="M2892"/>
      <xsl:apply-templates select="/" mode="M2893"/>
      <xsl:apply-templates select="/" mode="M2894"/>
      <xsl:apply-templates select="/" mode="M2895"/>
      <xsl:apply-templates select="/" mode="M2896"/>
      <xsl:apply-templates select="/" mode="M2897"/>
      <xsl:apply-templates select="/" mode="M2898"/>
      <xsl:apply-templates select="/" mode="M2899"/>
      <xsl:apply-templates select="/" mode="M2900"/>
      <xsl:apply-templates select="/" mode="M2901"/>
      <xsl:apply-templates select="/" mode="M2902"/>
      <xsl:apply-templates select="/" mode="M2903"/>
      <xsl:apply-templates select="/" mode="M2904"/>
      <xsl:apply-templates select="/" mode="M2905"/>
      <xsl:apply-templates select="/" mode="M2906"/>
      <xsl:apply-templates select="/" mode="M2907"/>
      <xsl:apply-templates select="/" mode="M2908"/>
      <xsl:apply-templates select="/" mode="M2909"/>
      <xsl:apply-templates select="/" mode="M2910"/>
      <xsl:apply-templates select="/" mode="M2911"/>
      <xsl:apply-templates select="/" mode="M2912"/>
      <xsl:apply-templates select="/" mode="M2913"/>
      <xsl:apply-templates select="/" mode="M2914"/>
      <xsl:apply-templates select="/" mode="M2915"/>
      <xsl:apply-templates select="/" mode="M2916"/>
      <xsl:apply-templates select="/" mode="M2917"/>
      <xsl:apply-templates select="/" mode="M2918"/>
      <xsl:apply-templates select="/" mode="M2919"/>
      <xsl:apply-templates select="/" mode="M2920"/>
      <xsl:apply-templates select="/" mode="M2921"/>
      <xsl:apply-templates select="/" mode="M2922"/>
      <xsl:apply-templates select="/" mode="M2923"/>
      <xsl:apply-templates select="/" mode="M2924"/>
      <xsl:apply-templates select="/" mode="M2925"/>
      <xsl:apply-templates select="/" mode="M2926"/>
      <xsl:apply-templates select="/" mode="M2927"/>
      <xsl:apply-templates select="/" mode="M2928"/>
      <xsl:apply-templates select="/" mode="M2929"/>
      <xsl:apply-templates select="/" mode="M2930"/>
      <xsl:apply-templates select="/" mode="M2931"/>
      <xsl:apply-templates select="/" mode="M2932"/>
      <xsl:apply-templates select="/" mode="M2933"/>
      <xsl:apply-templates select="/" mode="M2934"/>
      <xsl:apply-templates select="/" mode="M2935"/>
      <xsl:apply-templates select="/" mode="M2936"/>
      <xsl:apply-templates select="/" mode="M2937"/>
      <xsl:apply-templates select="/" mode="M2938"/>
      <xsl:apply-templates select="/" mode="M2939"/>
      <xsl:apply-templates select="/" mode="M2940"/>
      <xsl:apply-templates select="/" mode="M2941"/>
      <xsl:apply-templates select="/" mode="M2942"/>
      <xsl:apply-templates select="/" mode="M2943"/>
      <xsl:apply-templates select="/" mode="M2944"/>
      <xsl:apply-templates select="/" mode="M2945"/>
      <xsl:apply-templates select="/" mode="M2946"/>
      <xsl:apply-templates select="/" mode="M2947"/>
      <xsl:apply-templates select="/" mode="M2948"/>
      <xsl:apply-templates select="/" mode="M2949"/>
      <xsl:apply-templates select="/" mode="M2950"/>
      <xsl:apply-templates select="/" mode="M2951"/>
      <xsl:apply-templates select="/" mode="M2952"/>
      <xsl:apply-templates select="/" mode="M2953"/>
      <xsl:apply-templates select="/" mode="M2954"/>
      <xsl:apply-templates select="/" mode="M2955"/>
      <xsl:apply-templates select="/" mode="M2956"/>
      <xsl:apply-templates select="/" mode="M2957"/>
      <xsl:apply-templates select="/" mode="M2958"/>
      <xsl:apply-templates select="/" mode="M2959"/>
      <xsl:apply-templates select="/" mode="M2960"/>
      <xsl:apply-templates select="/" mode="M2961"/>
      <xsl:apply-templates select="/" mode="M2962"/>
      <xsl:apply-templates select="/" mode="M2963"/>
      <xsl:apply-templates select="/" mode="M2964"/>
      <xsl:apply-templates select="/" mode="M2965"/>
      <xsl:apply-templates select="/" mode="M2966"/>
      <xsl:apply-templates select="/" mode="M2967"/>
      <xsl:apply-templates select="/" mode="M2968"/>
      <xsl:apply-templates select="/" mode="M2969"/>
      <xsl:apply-templates select="/" mode="M2970"/>
      <xsl:apply-templates select="/" mode="M2971"/>
      <xsl:apply-templates select="/" mode="M2972"/>
      <xsl:apply-templates select="/" mode="M2973"/>
      <xsl:apply-templates select="/" mode="M2974"/>
      <xsl:apply-templates select="/" mode="M2975"/>
      <xsl:apply-templates select="/" mode="M2976"/>
      <xsl:apply-templates select="/" mode="M2977"/>
      <xsl:apply-templates select="/" mode="M2978"/>
      <xsl:apply-templates select="/" mode="M2979"/>
      <xsl:apply-templates select="/" mode="M2980"/>
      <xsl:apply-templates select="/" mode="M2981"/>
      <xsl:apply-templates select="/" mode="M2982"/>
      <xsl:apply-templates select="/" mode="M2983"/>
      <xsl:apply-templates select="/" mode="M2984"/>
      <xsl:apply-templates select="/" mode="M2985"/>
      <xsl:apply-templates select="/" mode="M2986"/>
      <xsl:apply-templates select="/" mode="M2987"/>
      <xsl:apply-templates select="/" mode="M2988"/>
      <xsl:apply-templates select="/" mode="M2989"/>
      <xsl:apply-templates select="/" mode="M2990"/>
      <xsl:apply-templates select="/" mode="M2991"/>
      <xsl:apply-templates select="/" mode="M2992"/>
      <xsl:apply-templates select="/" mode="M2993"/>
      <xsl:apply-templates select="/" mode="M2994"/>
      <xsl:apply-templates select="/" mode="M2995"/>
      <xsl:apply-templates select="/" mode="M2996"/>
      <xsl:apply-templates select="/" mode="M2997"/>
      <xsl:apply-templates select="/" mode="M2998"/>
      <xsl:apply-templates select="/" mode="M2999"/>
      <xsl:apply-templates select="/" mode="M3000"/>
      <xsl:apply-templates select="/" mode="M3001"/>
      <xsl:apply-templates select="/" mode="M3002"/>
      <xsl:apply-templates select="/" mode="M3003"/>
      <xsl:apply-templates select="/" mode="M3004"/>
      <xsl:apply-templates select="/" mode="M3005"/>
      <xsl:apply-templates select="/" mode="M3006"/>
      <xsl:apply-templates select="/" mode="M3007"/>
      <xsl:apply-templates select="/" mode="M3008"/>
      <xsl:apply-templates select="/" mode="M3009"/>
      <xsl:apply-templates select="/" mode="M3010"/>
      <xsl:apply-templates select="/" mode="M3011"/>
      <xsl:apply-templates select="/" mode="M3012"/>
      <xsl:apply-templates select="/" mode="M3013"/>
      <xsl:apply-templates select="/" mode="M3014"/>
      <xsl:apply-templates select="/" mode="M3015"/>
      <xsl:apply-templates select="/" mode="M3016"/>
      <xsl:apply-templates select="/" mode="M3017"/>
      <xsl:apply-templates select="/" mode="M3018"/>
      <xsl:apply-templates select="/" mode="M3019"/>
      <xsl:apply-templates select="/" mode="M3020"/>
      <xsl:apply-templates select="/" mode="M3021"/>
      <xsl:apply-templates select="/" mode="M3022"/>
      <xsl:apply-templates select="/" mode="M3023"/>
      <xsl:apply-templates select="/" mode="M3024"/>
      <xsl:apply-templates select="/" mode="M3025"/>
      <xsl:apply-templates select="/" mode="M3026"/>
      <xsl:apply-templates select="/" mode="M3027"/>
      <xsl:apply-templates select="/" mode="M3028"/>
      <xsl:apply-templates select="/" mode="M3029"/>
      <xsl:apply-templates select="/" mode="M3030"/>
      <xsl:apply-templates select="/" mode="M3031"/>
      <xsl:apply-templates select="/" mode="M3032"/>
      <xsl:apply-templates select="/" mode="M3033"/>
      <xsl:apply-templates select="/" mode="M3034"/>
      <xsl:apply-templates select="/" mode="M3035"/>
      <xsl:apply-templates select="/" mode="M3036"/>
      <xsl:apply-templates select="/" mode="M3037"/>
      <xsl:apply-templates select="/" mode="M3038"/>
      <xsl:apply-templates select="/" mode="M3039"/>
      <xsl:apply-templates select="/" mode="M3040"/>
      <xsl:apply-templates select="/" mode="M3041"/>
      <xsl:apply-templates select="/" mode="M3042"/>
      <xsl:apply-templates select="/" mode="M3043"/>
      <xsl:apply-templates select="/" mode="M3044"/>
      <xsl:apply-templates select="/" mode="M3045"/>
      <xsl:apply-templates select="/" mode="M3046"/>
      <xsl:apply-templates select="/" mode="M3047"/>
      <xsl:apply-templates select="/" mode="M3048"/>
      <xsl:apply-templates select="/" mode="M3049"/>
      <xsl:apply-templates select="/" mode="M3050"/>
      <xsl:apply-templates select="/" mode="M3051"/>
      <xsl:apply-templates select="/" mode="M3052"/>
      <xsl:apply-templates select="/" mode="M3053"/>
      <xsl:apply-templates select="/" mode="M3054"/>
      <xsl:apply-templates select="/" mode="M3055"/>
      <xsl:apply-templates select="/" mode="M3056"/>
      <xsl:apply-templates select="/" mode="M3057"/>
      <xsl:apply-templates select="/" mode="M3058"/>
      <xsl:apply-templates select="/" mode="M3059"/>
      <xsl:apply-templates select="/" mode="M3060"/>
      <xsl:apply-templates select="/" mode="M3061"/>
      <xsl:apply-templates select="/" mode="M3062"/>
      <xsl:apply-templates select="/" mode="M3063"/>
      <xsl:apply-templates select="/" mode="M3064"/>
      <xsl:apply-templates select="/" mode="M3065"/>
      <xsl:apply-templates select="/" mode="M3066"/>
      <xsl:apply-templates select="/" mode="M3067"/>
      <xsl:apply-templates select="/" mode="M3068"/>
      <xsl:apply-templates select="/" mode="M3069"/>
      <xsl:apply-templates select="/" mode="M3070"/>
      <xsl:apply-templates select="/" mode="M3071"/>
      <xsl:apply-templates select="/" mode="M3072"/>
      <xsl:apply-templates select="/" mode="M3073"/>
      <xsl:apply-templates select="/" mode="M3074"/>
      <xsl:apply-templates select="/" mode="M3075"/>
      <xsl:apply-templates select="/" mode="M3076"/>
      <xsl:apply-templates select="/" mode="M3077"/>
      <xsl:apply-templates select="/" mode="M3078"/>
      <xsl:apply-templates select="/" mode="M3079"/>
      <xsl:apply-templates select="/" mode="M3080"/>
      <xsl:apply-templates select="/" mode="M3081"/>
      <xsl:apply-templates select="/" mode="M3082"/>
      <xsl:apply-templates select="/" mode="M3083"/>
      <xsl:apply-templates select="/" mode="M3084"/>
      <xsl:apply-templates select="/" mode="M3085"/>
      <xsl:apply-templates select="/" mode="M3086"/>
      <xsl:apply-templates select="/" mode="M3087"/>
      <xsl:apply-templates select="/" mode="M3088"/>
      <xsl:apply-templates select="/" mode="M3089"/>
      <xsl:apply-templates select="/" mode="M3090"/>
      <xsl:apply-templates select="/" mode="M3091"/>
      <xsl:apply-templates select="/" mode="M3092"/>
      <xsl:apply-templates select="/" mode="M3093"/>
      <xsl:apply-templates select="/" mode="M3094"/>
      <xsl:apply-templates select="/" mode="M3095"/>
      <xsl:apply-templates select="/" mode="M3096"/>
      <xsl:apply-templates select="/" mode="M3097"/>
      <xsl:apply-templates select="/" mode="M3098"/>
      <xsl:apply-templates select="/" mode="M3099"/>
      <xsl:apply-templates select="/" mode="M3100"/>
      <xsl:apply-templates select="/" mode="M3101"/>
      <xsl:apply-templates select="/" mode="M3102"/>
      <xsl:apply-templates select="/" mode="M3103"/>
      <xsl:apply-templates select="/" mode="M3104"/>
      <xsl:apply-templates select="/" mode="M3105"/>
      <xsl:apply-templates select="/" mode="M3106"/>
      <xsl:apply-templates select="/" mode="M3107"/>
      <xsl:apply-templates select="/" mode="M3108"/>
      <xsl:apply-templates select="/" mode="M3109"/>
      <xsl:apply-templates select="/" mode="M3110"/>
      <xsl:apply-templates select="/" mode="M3111"/>
      <xsl:apply-templates select="/" mode="M3112"/>
      <xsl:apply-templates select="/" mode="M3113"/>
      <xsl:apply-templates select="/" mode="M3114"/>
      <xsl:apply-templates select="/" mode="M3115"/>
      <xsl:apply-templates select="/" mode="M3116"/>
      <xsl:apply-templates select="/" mode="M3117"/>
      <xsl:apply-templates select="/" mode="M3118"/>
      <xsl:apply-templates select="/" mode="M3119"/>
      <xsl:apply-templates select="/" mode="M3120"/>
      <xsl:apply-templates select="/" mode="M3121"/>
      <xsl:apply-templates select="/" mode="M3122"/>
      <xsl:apply-templates select="/" mode="M3123"/>
      <xsl:apply-templates select="/" mode="M3124"/>
      <xsl:apply-templates select="/" mode="M3125"/>
      <xsl:apply-templates select="/" mode="M3126"/>
      <xsl:apply-templates select="/" mode="M3127"/>
      <xsl:apply-templates select="/" mode="M3128"/>
      <xsl:apply-templates select="/" mode="M3129"/>
      <xsl:apply-templates select="/" mode="M3130"/>
      <xsl:apply-templates select="/" mode="M3131"/>
      <xsl:apply-templates select="/" mode="M3132"/>
      <xsl:apply-templates select="/" mode="M3133"/>
      <xsl:apply-templates select="/" mode="M3134"/>
      <xsl:apply-templates select="/" mode="M3135"/>
      <xsl:apply-templates select="/" mode="M3136"/>
      <xsl:apply-templates select="/" mode="M3137"/>
      <xsl:apply-templates select="/" mode="M3138"/>
      <xsl:apply-templates select="/" mode="M3139"/>
      <xsl:apply-templates select="/" mode="M3140"/>
      <xsl:apply-templates select="/" mode="M3141"/>
      <xsl:apply-templates select="/" mode="M3142"/>
      <xsl:apply-templates select="/" mode="M3143"/>
      <xsl:apply-templates select="/" mode="M3144"/>
      <xsl:apply-templates select="/" mode="M3145"/>
      <xsl:apply-templates select="/" mode="M3146"/>
      <xsl:apply-templates select="/" mode="M3147"/>
      <xsl:apply-templates select="/" mode="M3148"/>
      <xsl:apply-templates select="/" mode="M3149"/>
      <xsl:apply-templates select="/" mode="M3150"/>
      <xsl:apply-templates select="/" mode="M3151"/>
      <xsl:apply-templates select="/" mode="M3152"/>
      <xsl:apply-templates select="/" mode="M3153"/>
      <xsl:apply-templates select="/" mode="M3154"/>
      <xsl:apply-templates select="/" mode="M3155"/>
      <xsl:apply-templates select="/" mode="M3156"/>
      <xsl:apply-templates select="/" mode="M3157"/>
      <xsl:apply-templates select="/" mode="M3158"/>
      <xsl:apply-templates select="/" mode="M3159"/>
      <xsl:apply-templates select="/" mode="M3160"/>
      <xsl:apply-templates select="/" mode="M3161"/>
      <xsl:apply-templates select="/" mode="M3162"/>
      <xsl:apply-templates select="/" mode="M3163"/>
      <xsl:apply-templates select="/" mode="M3164"/>
      <xsl:apply-templates select="/" mode="M3165"/>
      <xsl:apply-templates select="/" mode="M3166"/>
      <xsl:apply-templates select="/" mode="M3167"/>
      <xsl:apply-templates select="/" mode="M3168"/>
      <xsl:apply-templates select="/" mode="M3169"/>
      <xsl:apply-templates select="/" mode="M3170"/>
      <xsl:apply-templates select="/" mode="M3171"/>
      <xsl:apply-templates select="/" mode="M3172"/>
      <xsl:apply-templates select="/" mode="M3173"/>
      <xsl:apply-templates select="/" mode="M3174"/>
      <xsl:apply-templates select="/" mode="M3175"/>
      <xsl:apply-templates select="/" mode="M3176"/>
      <xsl:apply-templates select="/" mode="M3177"/>
      <xsl:apply-templates select="/" mode="M3178"/>
      <xsl:apply-templates select="/" mode="M3179"/>
      <xsl:apply-templates select="/" mode="M3180"/>
      <xsl:apply-templates select="/" mode="M3181"/>
      <xsl:apply-templates select="/" mode="M3182"/>
      <xsl:apply-templates select="/" mode="M3183"/>
      <xsl:apply-templates select="/" mode="M3184"/>
      <xsl:apply-templates select="/" mode="M3185"/>
      <xsl:apply-templates select="/" mode="M3186"/>
      <xsl:apply-templates select="/" mode="M3187"/>
      <xsl:apply-templates select="/" mode="M3188"/>
      <xsl:apply-templates select="/" mode="M3189"/>
      <xsl:apply-templates select="/" mode="M3190"/>
      <xsl:apply-templates select="/" mode="M3191"/>
      <xsl:apply-templates select="/" mode="M3192"/>
      <xsl:apply-templates select="/" mode="M3193"/>
      <xsl:apply-templates select="/" mode="M3194"/>
      <xsl:apply-templates select="/" mode="M3195"/>
      <xsl:apply-templates select="/" mode="M3196"/>
      <xsl:apply-templates select="/" mode="M3197"/>
      <xsl:apply-templates select="/" mode="M3198"/>
      <xsl:apply-templates select="/" mode="M3199"/>
      <xsl:apply-templates select="/" mode="M3200"/>
      <xsl:apply-templates select="/" mode="M3201"/>
      <xsl:apply-templates select="/" mode="M3202"/>
      <xsl:apply-templates select="/" mode="M3203"/>
      <xsl:apply-templates select="/" mode="M3204"/>
      <xsl:apply-templates select="/" mode="M3205"/>
      <xsl:apply-templates select="/" mode="M3206"/>
      <xsl:apply-templates select="/" mode="M3207"/>
      <xsl:apply-templates select="/" mode="M3208"/>
      <xsl:apply-templates select="/" mode="M3209"/>
      <xsl:apply-templates select="/" mode="M3210"/>
      <xsl:apply-templates select="/" mode="M3211"/>
      <xsl:apply-templates select="/" mode="M3212"/>
      <xsl:apply-templates select="/" mode="M3213"/>
      <xsl:apply-templates select="/" mode="M3214"/>
      <xsl:apply-templates select="/" mode="M3215"/>
      <xsl:apply-templates select="/" mode="M3216"/>
      <xsl:apply-templates select="/" mode="M3217"/>
      <xsl:apply-templates select="/" mode="M3218"/>
      <xsl:apply-templates select="/" mode="M3219"/>
      <xsl:apply-templates select="/" mode="M3220"/>
      <xsl:apply-templates select="/" mode="M3221"/>
      <xsl:apply-templates select="/" mode="M3222"/>
      <xsl:apply-templates select="/" mode="M3223"/>
      <xsl:apply-templates select="/" mode="M3224"/>
      <xsl:apply-templates select="/" mode="M3225"/>
      <xsl:apply-templates select="/" mode="M3226"/>
      <xsl:apply-templates select="/" mode="M3227"/>
      <xsl:apply-templates select="/" mode="M3228"/>
      <xsl:apply-templates select="/" mode="M3229"/>
      <xsl:apply-templates select="/" mode="M3230"/>
      <xsl:apply-templates select="/" mode="M3231"/>
      <xsl:apply-templates select="/" mode="M3232"/>
      <xsl:apply-templates select="/" mode="M3233"/>
      <xsl:apply-templates select="/" mode="M3234"/>
      <xsl:apply-templates select="/" mode="M3235"/>
      <xsl:apply-templates select="/" mode="M3236"/>
      <xsl:apply-templates select="/" mode="M3237"/>
      <xsl:apply-templates select="/" mode="M3238"/>
      <xsl:apply-templates select="/" mode="M3239"/>
      <xsl:apply-templates select="/" mode="M3240"/>
      <xsl:apply-templates select="/" mode="M3241"/>
      <xsl:apply-templates select="/" mode="M3242"/>
      <xsl:apply-templates select="/" mode="M3243"/>
      <xsl:apply-templates select="/" mode="M3244"/>
      <xsl:apply-templates select="/" mode="M3245"/>
      <xsl:apply-templates select="/" mode="M3246"/>
      <xsl:apply-templates select="/" mode="M3247"/>
      <xsl:apply-templates select="/" mode="M3248"/>
      <xsl:apply-templates select="/" mode="M3249"/>
      <xsl:apply-templates select="/" mode="M3250"/>
      <xsl:apply-templates select="/" mode="M3251"/>
      <xsl:apply-templates select="/" mode="M3252"/>
      <xsl:apply-templates select="/" mode="M3253"/>
      <xsl:apply-templates select="/" mode="M3254"/>
      <xsl:apply-templates select="/" mode="M3255"/>
      <xsl:apply-templates select="/" mode="M3256"/>
      <xsl:apply-templates select="/" mode="M3257"/>
      <xsl:apply-templates select="/" mode="M3258"/>
      <xsl:apply-templates select="/" mode="M3259"/>
      <xsl:apply-templates select="/" mode="M3260"/>
      <xsl:apply-templates select="/" mode="M3261"/>
      <xsl:apply-templates select="/" mode="M3262"/>
      <xsl:apply-templates select="/" mode="M3263"/>
      <xsl:apply-templates select="/" mode="M3264"/>
      <xsl:apply-templates select="/" mode="M3265"/>
      <xsl:apply-templates select="/" mode="M3266"/>
      <xsl:apply-templates select="/" mode="M3267"/>
      <xsl:apply-templates select="/" mode="M3268"/>
      <xsl:apply-templates select="/" mode="M3269"/>
      <xsl:apply-templates select="/" mode="M3270"/>
      <xsl:apply-templates select="/" mode="M3271"/>
      <xsl:apply-templates select="/" mode="M3272"/>
      <xsl:apply-templates select="/" mode="M3273"/>
      <xsl:apply-templates select="/" mode="M3274"/>
      <xsl:apply-templates select="/" mode="M3275"/>
      <xsl:apply-templates select="/" mode="M3276"/>
      <xsl:apply-templates select="/" mode="M3277"/>
      <xsl:apply-templates select="/" mode="M3278"/>
      <xsl:apply-templates select="/" mode="M3279"/>
      <xsl:apply-templates select="/" mode="M3280"/>
      <xsl:apply-templates select="/" mode="M3281"/>
      <xsl:apply-templates select="/" mode="M3282"/>
      <xsl:apply-templates select="/" mode="M3283"/>
      <xsl:apply-templates select="/" mode="M3284"/>
      <xsl:apply-templates select="/" mode="M3285"/>
      <xsl:apply-templates select="/" mode="M3286"/>
      <xsl:apply-templates select="/" mode="M3287"/>
      <xsl:apply-templates select="/" mode="M3288"/>
      <xsl:apply-templates select="/" mode="M3289"/>
      <xsl:apply-templates select="/" mode="M3290"/>
      <xsl:apply-templates select="/" mode="M3291"/>
      <xsl:apply-templates select="/" mode="M3292"/>
      <xsl:apply-templates select="/" mode="M3293"/>
      <xsl:apply-templates select="/" mode="M3294"/>
      <xsl:apply-templates select="/" mode="M3295"/>
      <xsl:apply-templates select="/" mode="M3296"/>
      <xsl:apply-templates select="/" mode="M3297"/>
      <xsl:apply-templates select="/" mode="M3298"/>
      <xsl:apply-templates select="/" mode="M3299"/>
      <xsl:apply-templates select="/" mode="M3300"/>
      <xsl:apply-templates select="/" mode="M3301"/>
      <xsl:apply-templates select="/" mode="M3302"/>
      <xsl:apply-templates select="/" mode="M3303"/>
      <xsl:apply-templates select="/" mode="M3304"/>
      <xsl:apply-templates select="/" mode="M3305"/>
      <xsl:apply-templates select="/" mode="M3306"/>
      <xsl:apply-templates select="/" mode="M3307"/>
      <xsl:apply-templates select="/" mode="M3308"/>
      <xsl:apply-templates select="/" mode="M3309"/>
      <xsl:apply-templates select="/" mode="M3310"/>
      <xsl:apply-templates select="/" mode="M3311"/>
      <xsl:apply-templates select="/" mode="M3312"/>
      <xsl:apply-templates select="/" mode="M3313"/>
      <xsl:apply-templates select="/" mode="M3314"/>
      <xsl:apply-templates select="/" mode="M3315"/>
      <xsl:apply-templates select="/" mode="M3316"/>
      <xsl:apply-templates select="/" mode="M3317"/>
      <xsl:apply-templates select="/" mode="M3318"/>
      <xsl:apply-templates select="/" mode="M3319"/>
      <xsl:apply-templates select="/" mode="M3320"/>
      <xsl:apply-templates select="/" mode="M3321"/>
      <xsl:apply-templates select="/" mode="M3322"/>
      <xsl:apply-templates select="/" mode="M3323"/>
      <xsl:apply-templates select="/" mode="M3324"/>
      <xsl:apply-templates select="/" mode="M3325"/>
      <xsl:apply-templates select="/" mode="M3326"/>
      <xsl:apply-templates select="/" mode="M3327"/>
      <xsl:apply-templates select="/" mode="M3328"/>
      <xsl:apply-templates select="/" mode="M3329"/>
      <xsl:apply-templates select="/" mode="M3330"/>
      <xsl:apply-templates select="/" mode="M3331"/>
      <xsl:apply-templates select="/" mode="M3332"/>
      <xsl:apply-templates select="/" mode="M3333"/>
      <xsl:apply-templates select="/" mode="M3334"/>
      <xsl:apply-templates select="/" mode="M3335"/>
      <xsl:apply-templates select="/" mode="M3336"/>
      <xsl:apply-templates select="/" mode="M3337"/>
      <xsl:apply-templates select="/" mode="M3338"/>
      <xsl:apply-templates select="/" mode="M3339"/>
      <xsl:apply-templates select="/" mode="M3340"/>
      <xsl:apply-templates select="/" mode="M3341"/>
      <xsl:apply-templates select="/" mode="M3342"/>
      <xsl:apply-templates select="/" mode="M3343"/>
      <xsl:apply-templates select="/" mode="M3344"/>
      <xsl:apply-templates select="/" mode="M3345"/>
      <xsl:apply-templates select="/" mode="M3346"/>
      <xsl:apply-templates select="/" mode="M3347"/>
      <xsl:apply-templates select="/" mode="M3348"/>
      <xsl:apply-templates select="/" mode="M3349"/>
      <xsl:apply-templates select="/" mode="M3350"/>
      <xsl:apply-templates select="/" mode="M3351"/>
      <xsl:apply-templates select="/" mode="M3352"/>
      <xsl:apply-templates select="/" mode="M3353"/>
      <xsl:apply-templates select="/" mode="M3354"/>
      <xsl:apply-templates select="/" mode="M3355"/>
      <xsl:apply-templates select="/" mode="M3356"/>
      <xsl:apply-templates select="/" mode="M3357"/>
      <xsl:apply-templates select="/" mode="M3358"/>
      <xsl:apply-templates select="/" mode="M3359"/>
      <xsl:apply-templates select="/" mode="M3360"/>
      <xsl:apply-templates select="/" mode="M3361"/>
      <xsl:apply-templates select="/" mode="M3362"/>
      <xsl:apply-templates select="/" mode="M3363"/>
      <xsl:apply-templates select="/" mode="M3364"/>
      <xsl:apply-templates select="/" mode="M3365"/>
      <xsl:apply-templates select="/" mode="M3366"/>
      <xsl:apply-templates select="/" mode="M3367"/>
      <xsl:apply-templates select="/" mode="M3368"/>
      <xsl:apply-templates select="/" mode="M3369"/>
      <xsl:apply-templates select="/" mode="M3370"/>
      <xsl:apply-templates select="/" mode="M3371"/>
      <xsl:apply-templates select="/" mode="M3372"/>
      <xsl:apply-templates select="/" mode="M3373"/>
      <xsl:apply-templates select="/" mode="M3374"/>
      <xsl:apply-templates select="/" mode="M3375"/>
      <xsl:apply-templates select="/" mode="M3376"/>
      <xsl:apply-templates select="/" mode="M3377"/>
      <xsl:apply-templates select="/" mode="M3378"/>
      <xsl:apply-templates select="/" mode="M3379"/>
      <xsl:apply-templates select="/" mode="M3380"/>
      <xsl:apply-templates select="/" mode="M3381"/>
      <xsl:apply-templates select="/" mode="M3382"/>
      <xsl:apply-templates select="/" mode="M3383"/>
      <xsl:apply-templates select="/" mode="M3384"/>
      <xsl:apply-templates select="/" mode="M3385"/>
      <xsl:apply-templates select="/" mode="M3386"/>
      <xsl:apply-templates select="/" mode="M3387"/>
      <xsl:apply-templates select="/" mode="M3388"/>
      <xsl:apply-templates select="/" mode="M3389"/>
      <xsl:apply-templates select="/" mode="M3390"/>
      <xsl:apply-templates select="/" mode="M3391"/>
      <xsl:apply-templates select="/" mode="M3392"/>
      <xsl:apply-templates select="/" mode="M3393"/>
      <xsl:apply-templates select="/" mode="M3394"/>
      <xsl:apply-templates select="/" mode="M3395"/>
      <xsl:apply-templates select="/" mode="M3396"/>
      <xsl:apply-templates select="/" mode="M3397"/>
      <xsl:apply-templates select="/" mode="M3398"/>
      <xsl:apply-templates select="/" mode="M3399"/>
      <xsl:apply-templates select="/" mode="M3400"/>
      <xsl:apply-templates select="/" mode="M3401"/>
      <xsl:apply-templates select="/" mode="M3402"/>
      <xsl:apply-templates select="/" mode="M3403"/>
      <xsl:apply-templates select="/" mode="M3404"/>
      <xsl:apply-templates select="/" mode="M3405"/>
      <xsl:apply-templates select="/" mode="M3406"/>
      <xsl:apply-templates select="/" mode="M3407"/>
      <xsl:apply-templates select="/" mode="M3408"/>
      <xsl:apply-templates select="/" mode="M3409"/>
      <xsl:apply-templates select="/" mode="M3410"/>
      <xsl:apply-templates select="/" mode="M3411"/>
      <xsl:apply-templates select="/" mode="M3412"/>
      <xsl:apply-templates select="/" mode="M3413"/>
      <xsl:apply-templates select="/" mode="M3414"/>
      <xsl:apply-templates select="/" mode="M3415"/>
      <xsl:apply-templates select="/" mode="M3416"/>
      <xsl:apply-templates select="/" mode="M3417"/>
      <xsl:apply-templates select="/" mode="M3418"/>
      <xsl:apply-templates select="/" mode="M3419"/>
      <xsl:apply-templates select="/" mode="M3420"/>
      <xsl:apply-templates select="/" mode="M3421"/>
      <xsl:apply-templates select="/" mode="M3422"/>
      <xsl:apply-templates select="/" mode="M3423"/>
      <xsl:apply-templates select="/" mode="M3424"/>
      <xsl:apply-templates select="/" mode="M3425"/>
      <xsl:apply-templates select="/" mode="M3426"/>
      <xsl:apply-templates select="/" mode="M3427"/>
      <xsl:apply-templates select="/" mode="M3428"/>
      <xsl:apply-templates select="/" mode="M3429"/>
      <xsl:apply-templates select="/" mode="M3430"/>
      <xsl:apply-templates select="/" mode="M3431"/>
      <xsl:apply-templates select="/" mode="M3432"/>
      <xsl:apply-templates select="/" mode="M3433"/>
      <xsl:apply-templates select="/" mode="M3434"/>
      <xsl:apply-templates select="/" mode="M3435"/>
      <xsl:apply-templates select="/" mode="M3436"/>
      <xsl:apply-templates select="/" mode="M3437"/>
      <xsl:apply-templates select="/" mode="M3438"/>
      <xsl:apply-templates select="/" mode="M3439"/>
      <xsl:apply-templates select="/" mode="M3440"/>
      <xsl:apply-templates select="/" mode="M3441"/>
      <xsl:apply-templates select="/" mode="M3442"/>
      <xsl:apply-templates select="/" mode="M3443"/>
      <xsl:apply-templates select="/" mode="M3444"/>
      <xsl:apply-templates select="/" mode="M3445"/>
      <xsl:apply-templates select="/" mode="M3446"/>
      <xsl:apply-templates select="/" mode="M3447"/>
      <xsl:apply-templates select="/" mode="M3448"/>
      <xsl:apply-templates select="/" mode="M3449"/>
      <xsl:apply-templates select="/" mode="M3450"/>
      <xsl:apply-templates select="/" mode="M3451"/>
      <xsl:apply-templates select="/" mode="M3452"/>
      <xsl:apply-templates select="/" mode="M3453"/>
      <xsl:apply-templates select="/" mode="M3454"/>
      <xsl:apply-templates select="/" mode="M3455"/>
      <xsl:apply-templates select="/" mode="M3456"/>
      <xsl:apply-templates select="/" mode="M3457"/>
      <xsl:apply-templates select="/" mode="M3458"/>
      <xsl:apply-templates select="/" mode="M3459"/>
      <xsl:apply-templates select="/" mode="M3460"/>
      <xsl:apply-templates select="/" mode="M3461"/>
      <xsl:apply-templates select="/" mode="M3462"/>
      <xsl:apply-templates select="/" mode="M3463"/>
      <xsl:apply-templates select="/" mode="M3464"/>
      <xsl:apply-templates select="/" mode="M3465"/>
      <xsl:apply-templates select="/" mode="M3466"/>
      <xsl:apply-templates select="/" mode="M3467"/>
      <xsl:apply-templates select="/" mode="M3468"/>
      <xsl:apply-templates select="/" mode="M3469"/>
      <xsl:apply-templates select="/" mode="M3470"/>
      <xsl:apply-templates select="/" mode="M3471"/>
      <xsl:apply-templates select="/" mode="M3472"/>
      <xsl:apply-templates select="/" mode="M3473"/>
      <xsl:apply-templates select="/" mode="M3474"/>
      <xsl:apply-templates select="/" mode="M3475"/>
      <xsl:apply-templates select="/" mode="M3476"/>
      <xsl:apply-templates select="/" mode="M3477"/>
      <xsl:apply-templates select="/" mode="M3478"/>
      <xsl:apply-templates select="/" mode="M3479"/>
      <xsl:apply-templates select="/" mode="M3480"/>
      <xsl:apply-templates select="/" mode="M3481"/>
      <xsl:apply-templates select="/" mode="M3482"/>
      <xsl:apply-templates select="/" mode="M3483"/>
      <xsl:apply-templates select="/" mode="M3484"/>
      <xsl:apply-templates select="/" mode="M3485"/>
      <xsl:apply-templates select="/" mode="M3486"/>
      <xsl:apply-templates select="/" mode="M3487"/>
      <xsl:apply-templates select="/" mode="M3488"/>
      <xsl:apply-templates select="/" mode="M3489"/>
      <xsl:apply-templates select="/" mode="M3490"/>
      <xsl:apply-templates select="/" mode="M3491"/>
      <xsl:apply-templates select="/" mode="M3492"/>
      <xsl:apply-templates select="/" mode="M3493"/>
      <xsl:apply-templates select="/" mode="M3494"/>
      <xsl:apply-templates select="/" mode="M3495"/>
      <xsl:apply-templates select="/" mode="M3496"/>
      <xsl:apply-templates select="/" mode="M3497"/>
      <xsl:apply-templates select="/" mode="M3498"/>
      <xsl:apply-templates select="/" mode="M3499"/>
      <xsl:apply-templates select="/" mode="M3500"/>
      <xsl:apply-templates select="/" mode="M3501"/>
      <xsl:apply-templates select="/" mode="M3502"/>
      <xsl:apply-templates select="/" mode="M3503"/>
      <xsl:apply-templates select="/" mode="M3504"/>
      <xsl:apply-templates select="/" mode="M3505"/>
      <xsl:apply-templates select="/" mode="M3506"/>
      <xsl:apply-templates select="/" mode="M3507"/>
      <xsl:apply-templates select="/" mode="M3508"/>
      <xsl:apply-templates select="/" mode="M3509"/>
      <xsl:apply-templates select="/" mode="M3510"/>
      <xsl:apply-templates select="/" mode="M3511"/>
      <xsl:apply-templates select="/" mode="M3512"/>
      <xsl:apply-templates select="/" mode="M3513"/>
      <xsl:apply-templates select="/" mode="M3514"/>
      <xsl:apply-templates select="/" mode="M3515"/>
      <xsl:apply-templates select="/" mode="M3516"/>
      <xsl:apply-templates select="/" mode="M3517"/>
      <xsl:apply-templates select="/" mode="M3518"/>
      <xsl:apply-templates select="/" mode="M3519"/>
      <xsl:apply-templates select="/" mode="M3520"/>
      <xsl:apply-templates select="/" mode="M3521"/>
      <xsl:apply-templates select="/" mode="M3522"/>
      <xsl:apply-templates select="/" mode="M3523"/>
      <xsl:apply-templates select="/" mode="M3524"/>
      <xsl:apply-templates select="/" mode="M3525"/>
      <xsl:apply-templates select="/" mode="M3526"/>
      <xsl:apply-templates select="/" mode="M3527"/>
      <xsl:apply-templates select="/" mode="M3528"/>
      <xsl:apply-templates select="/" mode="M3529"/>
      <xsl:apply-templates select="/" mode="M3530"/>
      <xsl:apply-templates select="/" mode="M3531"/>
      <xsl:apply-templates select="/" mode="M3532"/>
      <xsl:apply-templates select="/" mode="M3533"/>
      <xsl:apply-templates select="/" mode="M3534"/>
      <xsl:apply-templates select="/" mode="M3535"/>
      <xsl:apply-templates select="/" mode="M3536"/>
      <xsl:apply-templates select="/" mode="M3537"/>
      <xsl:apply-templates select="/" mode="M3538"/>
      <xsl:apply-templates select="/" mode="M3539"/>
      <xsl:apply-templates select="/" mode="M3540"/>
      <xsl:apply-templates select="/" mode="M3541"/>
      <xsl:apply-templates select="/" mode="M3542"/>
      <xsl:apply-templates select="/" mode="M3543"/>
      <xsl:apply-templates select="/" mode="M3544"/>
      <xsl:apply-templates select="/" mode="M3545"/>
      <xsl:apply-templates select="/" mode="M3546"/>
      <xsl:apply-templates select="/" mode="M3547"/>
      <xsl:apply-templates select="/" mode="M3548"/>
      <xsl:apply-templates select="/" mode="M3549"/>
      <xsl:apply-templates select="/" mode="M3550"/>
      <xsl:apply-templates select="/" mode="M3551"/>
      <xsl:apply-templates select="/" mode="M3552"/>
      <xsl:apply-templates select="/" mode="M3553"/>
      <xsl:apply-templates select="/" mode="M3554"/>
      <xsl:apply-templates select="/" mode="M3555"/>
      <xsl:apply-templates select="/" mode="M3556"/>
      <xsl:apply-templates select="/" mode="M3557"/>
      <xsl:apply-templates select="/" mode="M3558"/>
      <xsl:apply-templates select="/" mode="M3559"/>
      <xsl:apply-templates select="/" mode="M3560"/>
      <xsl:apply-templates select="/" mode="M3561"/>
      <xsl:apply-templates select="/" mode="M3562"/>
      <xsl:apply-templates select="/" mode="M3563"/>
      <xsl:apply-templates select="/" mode="M3564"/>
      <xsl:apply-templates select="/" mode="M3565"/>
      <xsl:apply-templates select="/" mode="M3566"/>
      <xsl:apply-templates select="/" mode="M3567"/>
      <xsl:apply-templates select="/" mode="M3568"/>
      <xsl:apply-templates select="/" mode="M3569"/>
      <xsl:apply-templates select="/" mode="M3570"/>
      <xsl:apply-templates select="/" mode="M3571"/>
      <xsl:apply-templates select="/" mode="M3572"/>
      <xsl:apply-templates select="/" mode="M3573"/>
      <xsl:apply-templates select="/" mode="M3574"/>
      <xsl:apply-templates select="/" mode="M3575"/>
      <xsl:apply-templates select="/" mode="M3576"/>
      <xsl:apply-templates select="/" mode="M3577"/>
      <xsl:apply-templates select="/" mode="M3578"/>
      <xsl:apply-templates select="/" mode="M3579"/>
      <xsl:apply-templates select="/" mode="M3580"/>
      <xsl:apply-templates select="/" mode="M3581"/>
      <xsl:apply-templates select="/" mode="M3582"/>
      <xsl:apply-templates select="/" mode="M3583"/>
      <xsl:apply-templates select="/" mode="M3584"/>
      <xsl:apply-templates select="/" mode="M3585"/>
      <xsl:apply-templates select="/" mode="M3586"/>
      <xsl:apply-templates select="/" mode="M3587"/>
      <xsl:apply-templates select="/" mode="M3588"/>
      <xsl:apply-templates select="/" mode="M3589"/>
      <xsl:apply-templates select="/" mode="M3590"/>
      <xsl:apply-templates select="/" mode="M3591"/>
      <xsl:apply-templates select="/" mode="M3592"/>
      <xsl:apply-templates select="/" mode="M3593"/>
      <xsl:apply-templates select="/" mode="M3594"/>
      <xsl:apply-templates select="/" mode="M3595"/>
      <xsl:apply-templates select="/" mode="M3596"/>
      <xsl:apply-templates select="/" mode="M3597"/>
      <xsl:apply-templates select="/" mode="M3598"/>
      <xsl:apply-templates select="/" mode="M3599"/>
      <xsl:apply-templates select="/" mode="M3600"/>
      <xsl:apply-templates select="/" mode="M3601"/>
      <xsl:apply-templates select="/" mode="M3602"/>
      <xsl:apply-templates select="/" mode="M3603"/>
      <xsl:apply-templates select="/" mode="M3604"/>
      <xsl:apply-templates select="/" mode="M3605"/>
      <xsl:apply-templates select="/" mode="M3606"/>
      <xsl:apply-templates select="/" mode="M3607"/>
      <xsl:apply-templates select="/" mode="M3608"/>
      <xsl:apply-templates select="/" mode="M3609"/>
      <xsl:apply-templates select="/" mode="M3610"/>
      <xsl:apply-templates select="/" mode="M3611"/>
      <xsl:apply-templates select="/" mode="M3612"/>
      <xsl:apply-templates select="/" mode="M3613"/>
      <xsl:apply-templates select="/" mode="M3614"/>
      <xsl:apply-templates select="/" mode="M3615"/>
      <xsl:apply-templates select="/" mode="M3616"/>
      <xsl:apply-templates select="/" mode="M3617"/>
      <xsl:apply-templates select="/" mode="M3618"/>
      <xsl:apply-templates select="/" mode="M3619"/>
      <xsl:apply-templates select="/" mode="M3620"/>
      <xsl:apply-templates select="/" mode="M3621"/>
      <xsl:apply-templates select="/" mode="M3622"/>
      <xsl:apply-templates select="/" mode="M3623"/>
      <xsl:apply-templates select="/" mode="M3624"/>
      <xsl:apply-templates select="/" mode="M3625"/>
      <xsl:apply-templates select="/" mode="M3626"/>
      <xsl:apply-templates select="/" mode="M3627"/>
      <xsl:apply-templates select="/" mode="M3628"/>
      <xsl:apply-templates select="/" mode="M3629"/>
      <xsl:apply-templates select="/" mode="M3630"/>
      <xsl:apply-templates select="/" mode="M3631"/>
      <xsl:apply-templates select="/" mode="M3632"/>
      <xsl:apply-templates select="/" mode="M3633"/>
      <xsl:apply-templates select="/" mode="M3634"/>
      <xsl:apply-templates select="/" mode="M3635"/>
      <xsl:apply-templates select="/" mode="M3636"/>
      <xsl:apply-templates select="/" mode="M3637"/>
      <xsl:apply-templates select="/" mode="M3638"/>
      <xsl:apply-templates select="/" mode="M3639"/>
      <xsl:apply-templates select="/" mode="M3640"/>
      <xsl:apply-templates select="/" mode="M3641"/>
      <xsl:apply-templates select="/" mode="M3642"/>
      <xsl:apply-templates select="/" mode="M3643"/>
      <xsl:apply-templates select="/" mode="M3644"/>
      <xsl:apply-templates select="/" mode="M3645"/>
      <xsl:apply-templates select="/" mode="M3646"/>
      <xsl:apply-templates select="/" mode="M3647"/>
      <xsl:apply-templates select="/" mode="M3648"/>
      <xsl:apply-templates select="/" mode="M3649"/>
      <xsl:apply-templates select="/" mode="M3650"/>
      <xsl:apply-templates select="/" mode="M3651"/>
      <xsl:apply-templates select="/" mode="M3652"/>
      <xsl:apply-templates select="/" mode="M3653"/>
      <xsl:apply-templates select="/" mode="M3654"/>
      <xsl:apply-templates select="/" mode="M3655"/>
      <xsl:apply-templates select="/" mode="M3656"/>
      <xsl:apply-templates select="/" mode="M3657"/>
      <xsl:apply-templates select="/" mode="M3658"/>
      <xsl:apply-templates select="/" mode="M3659"/>
      <xsl:apply-templates select="/" mode="M3660"/>
      <xsl:apply-templates select="/" mode="M3661"/>
      <xsl:apply-templates select="/" mode="M3662"/>
      <xsl:apply-templates select="/" mode="M3663"/>
      <xsl:apply-templates select="/" mode="M3664"/>
      <xsl:apply-templates select="/" mode="M3665"/>
      <xsl:apply-templates select="/" mode="M3666"/>
      <xsl:apply-templates select="/" mode="M3667"/>
      <xsl:apply-templates select="/" mode="M3668"/>
      <xsl:apply-templates select="/" mode="M3669"/>
      <xsl:apply-templates select="/" mode="M3670"/>
      <xsl:apply-templates select="/" mode="M3671"/>
      <xsl:apply-templates select="/" mode="M3672"/>
      <xsl:apply-templates select="/" mode="M3673"/>
      <xsl:apply-templates select="/" mode="M3674"/>
      <xsl:apply-templates select="/" mode="M3675"/>
      <xsl:apply-templates select="/" mode="M3676"/>
      <xsl:apply-templates select="/" mode="M3677"/>
      <xsl:apply-templates select="/" mode="M3678"/>
      <xsl:apply-templates select="/" mode="M3679"/>
      <xsl:apply-templates select="/" mode="M3680"/>
      <xsl:apply-templates select="/" mode="M3681"/>
      <xsl:apply-templates select="/" mode="M3682"/>
      <xsl:apply-templates select="/" mode="M3683"/>
      <xsl:apply-templates select="/" mode="M3684"/>
      <xsl:apply-templates select="/" mode="M3685"/>
      <xsl:apply-templates select="/" mode="M3686"/>
      <xsl:apply-templates select="/" mode="M3687"/>
      <xsl:apply-templates select="/" mode="M3688"/>
      <xsl:apply-templates select="/" mode="M3689"/>
      <xsl:apply-templates select="/" mode="M3690"/>
      <xsl:apply-templates select="/" mode="M3691"/>
      <xsl:apply-templates select="/" mode="M3692"/>
      <xsl:apply-templates select="/" mode="M3693"/>
      <xsl:apply-templates select="/" mode="M3694"/>
      <xsl:apply-templates select="/" mode="M3695"/>
      <xsl:apply-templates select="/" mode="M3696"/>
      <xsl:apply-templates select="/" mode="M3697"/>
      <xsl:apply-templates select="/" mode="M3698"/>
      <xsl:apply-templates select="/" mode="M3699"/>
      <xsl:apply-templates select="/" mode="M3700"/>
      <xsl:apply-templates select="/" mode="M3701"/>
      <xsl:apply-templates select="/" mode="M3702"/>
      <xsl:apply-templates select="/" mode="M3703"/>
      <xsl:apply-templates select="/" mode="M3704"/>
      <xsl:apply-templates select="/" mode="M3705"/>
      <xsl:apply-templates select="/" mode="M3706"/>
      <xsl:apply-templates select="/" mode="M3707"/>
      <xsl:apply-templates select="/" mode="M3708"/>
      <xsl:apply-templates select="/" mode="M3709"/>
      <xsl:apply-templates select="/" mode="M3710"/>
      <xsl:apply-templates select="/" mode="M3711"/>
      <xsl:apply-templates select="/" mode="M3712"/>
      <xsl:apply-templates select="/" mode="M3713"/>
      <xsl:apply-templates select="/" mode="M3714"/>
      <xsl:apply-templates select="/" mode="M3715"/>
      <xsl:apply-templates select="/" mode="M3716"/>
      <xsl:apply-templates select="/" mode="M3717"/>
      <xsl:apply-templates select="/" mode="M3718"/>
      <xsl:apply-templates select="/" mode="M3719"/>
      <xsl:apply-templates select="/" mode="M3720"/>
      <xsl:apply-templates select="/" mode="M3721"/>
      <xsl:apply-templates select="/" mode="M3722"/>
      <xsl:apply-templates select="/" mode="M3723"/>
      <xsl:apply-templates select="/" mode="M3724"/>
      <xsl:apply-templates select="/" mode="M3725"/>
      <xsl:apply-templates select="/" mode="M3726"/>
      <xsl:apply-templates select="/" mode="M3727"/>
      <xsl:apply-templates select="/" mode="M3728"/>
      <xsl:apply-templates select="/" mode="M3729"/>
      <xsl:apply-templates select="/" mode="M3730"/>
      <xsl:apply-templates select="/" mode="M3731"/>
      <xsl:apply-templates select="/" mode="M3732"/>
      <xsl:apply-templates select="/" mode="M3733"/>
      <xsl:apply-templates select="/" mode="M3734"/>
      <xsl:apply-templates select="/" mode="M3735"/>
      <xsl:apply-templates select="/" mode="M3736"/>
      <xsl:apply-templates select="/" mode="M3737"/>
      <xsl:apply-templates select="/" mode="M3738"/>
      <xsl:apply-templates select="/" mode="M3739"/>
      <xsl:apply-templates select="/" mode="M3740"/>
      <xsl:apply-templates select="/" mode="M3741"/>
      <xsl:apply-templates select="/" mode="M3742"/>
      <xsl:apply-templates select="/" mode="M3743"/>
      <xsl:apply-templates select="/" mode="M3744"/>
      <xsl:apply-templates select="/" mode="M3745"/>
      <xsl:apply-templates select="/" mode="M3746"/>
      <xsl:apply-templates select="/" mode="M3747"/>
      <xsl:apply-templates select="/" mode="M3748"/>
      <xsl:apply-templates select="/" mode="M3749"/>
      <xsl:apply-templates select="/" mode="M3750"/>
      <xsl:apply-templates select="/" mode="M3751"/>
      <xsl:apply-templates select="/" mode="M3752"/>
      <xsl:apply-templates select="/" mode="M3753"/>
      <xsl:apply-templates select="/" mode="M3754"/>
      <xsl:apply-templates select="/" mode="M3755"/>
      <xsl:apply-templates select="/" mode="M3756"/>
      <xsl:apply-templates select="/" mode="M3757"/>
      <xsl:apply-templates select="/" mode="M3758"/>
      <xsl:apply-templates select="/" mode="M3759"/>
      <xsl:apply-templates select="/" mode="M3760"/>
      <xsl:apply-templates select="/" mode="M3761"/>
      <xsl:apply-templates select="/" mode="M3762"/>
      <xsl:apply-templates select="/" mode="M3763"/>
      <xsl:apply-templates select="/" mode="M3764"/>
      <xsl:apply-templates select="/" mode="M3765"/>
      <xsl:apply-templates select="/" mode="M3766"/>
      <xsl:apply-templates select="/" mode="M3767"/>
      <xsl:apply-templates select="/" mode="M3768"/>
      <xsl:apply-templates select="/" mode="M3769"/>
      <xsl:apply-templates select="/" mode="M3770"/>
      <xsl:apply-templates select="/" mode="M3771"/>
      <xsl:apply-templates select="/" mode="M3772"/>
      <xsl:apply-templates select="/" mode="M3773"/>
      <xsl:apply-templates select="/" mode="M3774"/>
      <xsl:apply-templates select="/" mode="M3775"/>
      <xsl:apply-templates select="/" mode="M3776"/>
      <xsl:apply-templates select="/" mode="M3777"/>
      <xsl:apply-templates select="/" mode="M3778"/>
      <xsl:apply-templates select="/" mode="M3779"/>
      <xsl:apply-templates select="/" mode="M3780"/>
      <xsl:apply-templates select="/" mode="M3781"/>
      <xsl:apply-templates select="/" mode="M3782"/>
      <xsl:apply-templates select="/" mode="M3783"/>
      <xsl:apply-templates select="/" mode="M3784"/>
      <xsl:apply-templates select="/" mode="M3785"/>
      <xsl:apply-templates select="/" mode="M3786"/>
      <xsl:apply-templates select="/" mode="M3787"/>
      <xsl:apply-templates select="/" mode="M3788"/>
      <xsl:apply-templates select="/" mode="M3789"/>
      <xsl:apply-templates select="/" mode="M3790"/>
      <xsl:apply-templates select="/" mode="M3791"/>
      <xsl:apply-templates select="/" mode="M3792"/>
      <xsl:apply-templates select="/" mode="M3793"/>
      <xsl:apply-templates select="/" mode="M3794"/>
      <xsl:apply-templates select="/" mode="M3795"/>
      <xsl:apply-templates select="/" mode="M3796"/>
      <xsl:apply-templates select="/" mode="M3797"/>
      <xsl:apply-templates select="/" mode="M3798"/>
      <xsl:apply-templates select="/" mode="M3799"/>
      <xsl:apply-templates select="/" mode="M3800"/>
      <xsl:apply-templates select="/" mode="M3801"/>
      <xsl:apply-templates select="/" mode="M3802"/>
      <xsl:apply-templates select="/" mode="M3803"/>
      <xsl:apply-templates select="/" mode="M3804"/>
      <xsl:apply-templates select="/" mode="M3805"/>
      <xsl:apply-templates select="/" mode="M3806"/>
      <xsl:apply-templates select="/" mode="M3807"/>
      <xsl:apply-templates select="/" mode="M3808"/>
      <xsl:apply-templates select="/" mode="M3809"/>
      <xsl:apply-templates select="/" mode="M3810"/>
      <xsl:apply-templates select="/" mode="M3811"/>
      <xsl:apply-templates select="/" mode="M3812"/>
      <xsl:apply-templates select="/" mode="M3813"/>
      <xsl:apply-templates select="/" mode="M3814"/>
      <xsl:apply-templates select="/" mode="M3815"/>
      <xsl:apply-templates select="/" mode="M3816"/>
      <xsl:apply-templates select="/" mode="M3817"/>
      <xsl:apply-templates select="/" mode="M3818"/>
      <xsl:apply-templates select="/" mode="M3819"/>
      <xsl:apply-templates select="/" mode="M3820"/>
      <xsl:apply-templates select="/" mode="M3821"/>
      <xsl:apply-templates select="/" mode="M3822"/>
      <xsl:apply-templates select="/" mode="M3823"/>
      <xsl:apply-templates select="/" mode="M3824"/>
      <xsl:apply-templates select="/" mode="M3825"/>
      <xsl:apply-templates select="/" mode="M3826"/>
      <xsl:apply-templates select="/" mode="M3827"/>
      <xsl:apply-templates select="/" mode="M3828"/>
      <xsl:apply-templates select="/" mode="M3829"/>
      <xsl:apply-templates select="/" mode="M3830"/>
      <xsl:apply-templates select="/" mode="M3831"/>
      <xsl:apply-templates select="/" mode="M3832"/>
      <xsl:apply-templates select="/" mode="M3833"/>
      <xsl:apply-templates select="/" mode="M3834"/>
      <xsl:apply-templates select="/" mode="M3835"/>
      <xsl:apply-templates select="/" mode="M3836"/>
      <xsl:apply-templates select="/" mode="M3837"/>
      <xsl:apply-templates select="/" mode="M3838"/>
      <xsl:apply-templates select="/" mode="M3839"/>
      <xsl:apply-templates select="/" mode="M3840"/>
      <xsl:apply-templates select="/" mode="M3841"/>
      <xsl:apply-templates select="/" mode="M3842"/>
      <xsl:apply-templates select="/" mode="M3843"/>
      <xsl:apply-templates select="/" mode="M3844"/>
      <xsl:apply-templates select="/" mode="M3845"/>
      <xsl:apply-templates select="/" mode="M3846"/>
      <xsl:apply-templates select="/" mode="M3847"/>
      <xsl:apply-templates select="/" mode="M3848"/>
      <xsl:apply-templates select="/" mode="M3849"/>
      <xsl:apply-templates select="/" mode="M3850"/>
      <xsl:apply-templates select="/" mode="M3851"/>
      <xsl:apply-templates select="/" mode="M3852"/>
      <xsl:apply-templates select="/" mode="M3853"/>
      <xsl:apply-templates select="/" mode="M3854"/>
      <xsl:apply-templates select="/" mode="M3855"/>
      <xsl:apply-templates select="/" mode="M3856"/>
      <xsl:apply-templates select="/" mode="M3857"/>
      <xsl:apply-templates select="/" mode="M3858"/>
      <xsl:apply-templates select="/" mode="M3859"/>
      <xsl:apply-templates select="/" mode="M3860"/>
      <xsl:apply-templates select="/" mode="M3861"/>
      <xsl:apply-templates select="/" mode="M3862"/>
      <xsl:apply-templates select="/" mode="M3863"/>
      <xsl:apply-templates select="/" mode="M3864"/>
      <xsl:apply-templates select="/" mode="M3865"/>
      <xsl:apply-templates select="/" mode="M3866"/>
      <xsl:apply-templates select="/" mode="M3867"/>
      <xsl:apply-templates select="/" mode="M3868"/>
      <xsl:apply-templates select="/" mode="M3869"/>
      <xsl:apply-templates select="/" mode="M3870"/>
      <xsl:apply-templates select="/" mode="M3871"/>
      <xsl:apply-templates select="/" mode="M3872"/>
      <xsl:apply-templates select="/" mode="M3873"/>
      <xsl:apply-templates select="/" mode="M3874"/>
      <xsl:apply-templates select="/" mode="M3875"/>
      <xsl:apply-templates select="/" mode="M3876"/>
      <xsl:apply-templates select="/" mode="M3877"/>
      <xsl:apply-templates select="/" mode="M3878"/>
      <xsl:apply-templates select="/" mode="M3879"/>
      <xsl:apply-templates select="/" mode="M3880"/>
      <xsl:apply-templates select="/" mode="M3881"/>
      <xsl:apply-templates select="/" mode="M3882"/>
      <xsl:apply-templates select="/" mode="M3883"/>
      <xsl:apply-templates select="/" mode="M3884"/>
      <xsl:apply-templates select="/" mode="M3885"/>
      <xsl:apply-templates select="/" mode="M3886"/>
      <xsl:apply-templates select="/" mode="M3887"/>
      <xsl:apply-templates select="/" mode="M3888"/>
      <xsl:apply-templates select="/" mode="M3889"/>
      <xsl:apply-templates select="/" mode="M3890"/>
      <xsl:apply-templates select="/" mode="M3891"/>
      <xsl:apply-templates select="/" mode="M3892"/>
      <xsl:apply-templates select="/" mode="M3893"/>
      <xsl:apply-templates select="/" mode="M3894"/>
      <xsl:apply-templates select="/" mode="M3895"/>
      <xsl:apply-templates select="/" mode="M3896"/>
      <xsl:apply-templates select="/" mode="M3897"/>
      <xsl:apply-templates select="/" mode="M3898"/>
      <xsl:apply-templates select="/" mode="M3899"/>
      <xsl:apply-templates select="/" mode="M3900"/>
      <xsl:apply-templates select="/" mode="M3901"/>
      <xsl:apply-templates select="/" mode="M3902"/>
      <xsl:apply-templates select="/" mode="M3903"/>
      <xsl:apply-templates select="/" mode="M3904"/>
      <xsl:apply-templates select="/" mode="M3905"/>
      <xsl:apply-templates select="/" mode="M3906"/>
      <xsl:apply-templates select="/" mode="M3907"/>
      <xsl:apply-templates select="/" mode="M3908"/>
      <xsl:apply-templates select="/" mode="M3909"/>
      <xsl:apply-templates select="/" mode="M3910"/>
      <xsl:apply-templates select="/" mode="M3911"/>
      <xsl:apply-templates select="/" mode="M3912"/>
      <xsl:apply-templates select="/" mode="M3913"/>
      <xsl:apply-templates select="/" mode="M3914"/>
      <xsl:apply-templates select="/" mode="M3915"/>
      <xsl:apply-templates select="/" mode="M3916"/>
      <xsl:apply-templates select="/" mode="M3917"/>
      <xsl:apply-templates select="/" mode="M3918"/>
      <xsl:apply-templates select="/" mode="M3919"/>
      <xsl:apply-templates select="/" mode="M3920"/>
      <xsl:apply-templates select="/" mode="M3921"/>
      <xsl:apply-templates select="/" mode="M3922"/>
      <xsl:apply-templates select="/" mode="M3923"/>
      <xsl:apply-templates select="/" mode="M3924"/>
      <xsl:apply-templates select="/" mode="M3925"/>
      <xsl:apply-templates select="/" mode="M3926"/>
      <xsl:apply-templates select="/" mode="M3927"/>
      <xsl:apply-templates select="/" mode="M3928"/>
      <xsl:apply-templates select="/" mode="M3929"/>
      <xsl:apply-templates select="/" mode="M3930"/>
      <xsl:apply-templates select="/" mode="M3931"/>
      <xsl:apply-templates select="/" mode="M3932"/>
      <xsl:apply-templates select="/" mode="M3933"/>
      <xsl:apply-templates select="/" mode="M3934"/>
      <xsl:apply-templates select="/" mode="M3935"/>
      <xsl:apply-templates select="/" mode="M3936"/>
      <xsl:apply-templates select="/" mode="M3937"/>
      <xsl:apply-templates select="/" mode="M3938"/>
      <xsl:apply-templates select="/" mode="M3939"/>
      <xsl:apply-templates select="/" mode="M3940"/>
      <xsl:apply-templates select="/" mode="M3941"/>
      <xsl:apply-templates select="/" mode="M3942"/>
      <xsl:apply-templates select="/" mode="M3943"/>
      <xsl:apply-templates select="/" mode="M3944"/>
      <xsl:apply-templates select="/" mode="M3945"/>
      <xsl:apply-templates select="/" mode="M3946"/>
      <xsl:apply-templates select="/" mode="M3947"/>
      <xsl:apply-templates select="/" mode="M3948"/>
      <xsl:apply-templates select="/" mode="M3949"/>
      <xsl:apply-templates select="/" mode="M3950"/>
      <xsl:apply-templates select="/" mode="M3951"/>
      <xsl:apply-templates select="/" mode="M3952"/>
      <xsl:apply-templates select="/" mode="M3953"/>
      <xsl:apply-templates select="/" mode="M3954"/>
      <xsl:apply-templates select="/" mode="M3955"/>
      <xsl:apply-templates select="/" mode="M3956"/>
      <xsl:apply-templates select="/" mode="M3957"/>
      <xsl:apply-templates select="/" mode="M3958"/>
      <xsl:apply-templates select="/" mode="M3959"/>
      <xsl:apply-templates select="/" mode="M3960"/>
      <xsl:apply-templates select="/" mode="M3961"/>
      <xsl:apply-templates select="/" mode="M3962"/>
      <xsl:apply-templates select="/" mode="M3963"/>
      <xsl:apply-templates select="/" mode="M3964"/>
      <xsl:apply-templates select="/" mode="M3965"/>
      <xsl:apply-templates select="/" mode="M3966"/>
      <xsl:apply-templates select="/" mode="M3967"/>
      <xsl:apply-templates select="/" mode="M3968"/>
      <xsl:apply-templates select="/" mode="M3969"/>
      <xsl:apply-templates select="/" mode="M3970"/>
      <xsl:apply-templates select="/" mode="M3971"/>
      <xsl:apply-templates select="/" mode="M3972"/>
      <xsl:apply-templates select="/" mode="M3973"/>
      <xsl:apply-templates select="/" mode="M3974"/>
      <xsl:apply-templates select="/" mode="M3975"/>
      <xsl:apply-templates select="/" mode="M3976"/>
      <xsl:apply-templates select="/" mode="M3977"/>
      <xsl:apply-templates select="/" mode="M3978"/>
      <xsl:apply-templates select="/" mode="M3979"/>
      <xsl:apply-templates select="/" mode="M3980"/>
      <xsl:apply-templates select="/" mode="M3981"/>
      <xsl:apply-templates select="/" mode="M3982"/>
      <xsl:apply-templates select="/" mode="M3983"/>
      <xsl:apply-templates select="/" mode="M3984"/>
      <xsl:apply-templates select="/" mode="M3985"/>
      <xsl:apply-templates select="/" mode="M3986"/>
      <xsl:apply-templates select="/" mode="M3987"/>
      <xsl:apply-templates select="/" mode="M3988"/>
      <xsl:apply-templates select="/" mode="M3989"/>
      <xsl:apply-templates select="/" mode="M3990"/>
      <xsl:apply-templates select="/" mode="M3991"/>
      <xsl:apply-templates select="/" mode="M3992"/>
      <xsl:apply-templates select="/" mode="M3993"/>
      <xsl:apply-templates select="/" mode="M3994"/>
      <xsl:apply-templates select="/" mode="M3995"/>
      <xsl:apply-templates select="/" mode="M3996"/>
      <xsl:apply-templates select="/" mode="M3997"/>
      <xsl:apply-templates select="/" mode="M3998"/>
      <xsl:apply-templates select="/" mode="M3999"/>
      <xsl:apply-templates select="/" mode="M4000"/>
      <xsl:apply-templates select="/" mode="M4001"/>
      <xsl:apply-templates select="/" mode="M4002"/>
      <xsl:apply-templates select="/" mode="M4003"/>
      <xsl:apply-templates select="/" mode="M4004"/>
      <xsl:apply-templates select="/" mode="M4005"/>
      <xsl:apply-templates select="/" mode="M4006"/>
      <xsl:apply-templates select="/" mode="M4007"/>
      <xsl:apply-templates select="/" mode="M4008"/>
      <xsl:apply-templates select="/" mode="M4009"/>
      <xsl:apply-templates select="/" mode="M4010"/>
      <xsl:apply-templates select="/" mode="M4011"/>
      <xsl:apply-templates select="/" mode="M4012"/>
      <xsl:apply-templates select="/" mode="M4013"/>
      <xsl:apply-templates select="/" mode="M4014"/>
      <xsl:apply-templates select="/" mode="M4015"/>
      <xsl:apply-templates select="/" mode="M4016"/>
      <xsl:apply-templates select="/" mode="M4017"/>
      <xsl:apply-templates select="/" mode="M4018"/>
      <xsl:apply-templates select="/" mode="M4019"/>
      <xsl:apply-templates select="/" mode="M4020"/>
      <xsl:apply-templates select="/" mode="M4021"/>
      <xsl:apply-templates select="/" mode="M4022"/>
      <xsl:apply-templates select="/" mode="M4023"/>
      <xsl:apply-templates select="/" mode="M4024"/>
      <xsl:apply-templates select="/" mode="M4025"/>
      <xsl:apply-templates select="/" mode="M4026"/>
      <xsl:apply-templates select="/" mode="M4027"/>
      <xsl:apply-templates select="/" mode="M4028"/>
      <xsl:apply-templates select="/" mode="M4029"/>
      <xsl:apply-templates select="/" mode="M4030"/>
      <xsl:apply-templates select="/" mode="M4031"/>
      <xsl:apply-templates select="/" mode="M4032"/>
      <xsl:apply-templates select="/" mode="M4033"/>
      <xsl:apply-templates select="/" mode="M4034"/>
      <xsl:apply-templates select="/" mode="M4035"/>
      <xsl:apply-templates select="/" mode="M4036"/>
      <xsl:apply-templates select="/" mode="M4037"/>
      <xsl:apply-templates select="/" mode="M4038"/>
      <xsl:apply-templates select="/" mode="M4039"/>
      <xsl:apply-templates select="/" mode="M4040"/>
      <xsl:apply-templates select="/" mode="M4041"/>
      <xsl:apply-templates select="/" mode="M4042"/>
      <xsl:apply-templates select="/" mode="M4043"/>
      <xsl:apply-templates select="/" mode="M4044"/>
      <xsl:apply-templates select="/" mode="M4045"/>
      <xsl:apply-templates select="/" mode="M4046"/>
      <xsl:apply-templates select="/" mode="M4047"/>
      <xsl:apply-templates select="/" mode="M4048"/>
      <xsl:apply-templates select="/" mode="M4049"/>
      <xsl:apply-templates select="/" mode="M4050"/>
      <xsl:apply-templates select="/" mode="M4051"/>
      <xsl:apply-templates select="/" mode="M4052"/>
      <xsl:apply-templates select="/" mode="M4053"/>
      <xsl:apply-templates select="/" mode="M4054"/>
      <xsl:apply-templates select="/" mode="M4055"/>
      <xsl:apply-templates select="/" mode="M4056"/>
      <xsl:apply-templates select="/" mode="M4057"/>
      <xsl:apply-templates select="/" mode="M4058"/>
      <xsl:apply-templates select="/" mode="M4059"/>
      <xsl:apply-templates select="/" mode="M4060"/>
      <xsl:apply-templates select="/" mode="M4061"/>
      <xsl:apply-templates select="/" mode="M4062"/>
      <xsl:apply-templates select="/" mode="M4063"/>
      <xsl:apply-templates select="/" mode="M4064"/>
      <xsl:apply-templates select="/" mode="M4065"/>
      <xsl:apply-templates select="/" mode="M4066"/>
      <xsl:apply-templates select="/" mode="M4067"/>
      <xsl:apply-templates select="/" mode="M4068"/>
      <xsl:apply-templates select="/" mode="M4069"/>
      <xsl:apply-templates select="/" mode="M4070"/>
      <xsl:apply-templates select="/" mode="M4071"/>
      <xsl:apply-templates select="/" mode="M4072"/>
      <xsl:apply-templates select="/" mode="M4073"/>
      <xsl:apply-templates select="/" mode="M4074"/>
      <xsl:apply-templates select="/" mode="M4075"/>
      <xsl:apply-templates select="/" mode="M4076"/>
      <xsl:apply-templates select="/" mode="M4077"/>
      <xsl:apply-templates select="/" mode="M4078"/>
      <xsl:apply-templates select="/" mode="M4079"/>
      <xsl:apply-templates select="/" mode="M4080"/>
      <xsl:apply-templates select="/" mode="M4081"/>
      <xsl:apply-templates select="/" mode="M4082"/>
      <xsl:apply-templates select="/" mode="M4083"/>
      <xsl:apply-templates select="/" mode="M4084"/>
      <xsl:apply-templates select="/" mode="M4085"/>
      <xsl:apply-templates select="/" mode="M4086"/>
      <xsl:apply-templates select="/" mode="M4087"/>
      <xsl:apply-templates select="/" mode="M4088"/>
      <xsl:apply-templates select="/" mode="M4089"/>
      <xsl:apply-templates select="/" mode="M4090"/>
      <xsl:apply-templates select="/" mode="M4091"/>
      <xsl:apply-templates select="/" mode="M4092"/>
      <xsl:apply-templates select="/" mode="M4093"/>
      <xsl:apply-templates select="/" mode="M4094"/>
      <xsl:apply-templates select="/" mode="M4095"/>
      <xsl:apply-templates select="/" mode="M4096"/>
      <xsl:apply-templates select="/" mode="M4097"/>
      <xsl:apply-templates select="/" mode="M4098"/>
      <xsl:apply-templates select="/" mode="M4099"/>
      <xsl:apply-templates select="/" mode="M4100"/>
      <xsl:apply-templates select="/" mode="M4101"/>
      <xsl:apply-templates select="/" mode="M4102"/>
      <xsl:apply-templates select="/" mode="M4103"/>
      <xsl:apply-templates select="/" mode="M4104"/>
      <xsl:apply-templates select="/" mode="M4105"/>
      <xsl:apply-templates select="/" mode="M4106"/>
      <xsl:apply-templates select="/" mode="M4107"/>
      <xsl:apply-templates select="/" mode="M4108"/>
      <xsl:apply-templates select="/" mode="M4109"/>
      <xsl:apply-templates select="/" mode="M4110"/>
      <xsl:apply-templates select="/" mode="M4111"/>
      <xsl:apply-templates select="/" mode="M4112"/>
      <xsl:apply-templates select="/" mode="M4113"/>
      <xsl:apply-templates select="/" mode="M4114"/>
      <xsl:apply-templates select="/" mode="M4115"/>
      <xsl:apply-templates select="/" mode="M4116"/>
      <xsl:apply-templates select="/" mode="M4117"/>
      <xsl:apply-templates select="/" mode="M4118"/>
      <xsl:apply-templates select="/" mode="M4119"/>
      <xsl:apply-templates select="/" mode="M4120"/>
      <xsl:apply-templates select="/" mode="M4121"/>
      <xsl:apply-templates select="/" mode="M4122"/>
      <xsl:apply-templates select="/" mode="M4123"/>
      <xsl:apply-templates select="/" mode="M4124"/>
      <xsl:apply-templates select="/" mode="M4125"/>
      <xsl:apply-templates select="/" mode="M4126"/>
      <xsl:apply-templates select="/" mode="M4127"/>
      <xsl:apply-templates select="/" mode="M4128"/>
      <xsl:apply-templates select="/" mode="M4129"/>
      <xsl:apply-templates select="/" mode="M4130"/>
      <xsl:apply-templates select="/" mode="M4131"/>
      <xsl:apply-templates select="/" mode="M4132"/>
      <xsl:apply-templates select="/" mode="M4133"/>
      <xsl:apply-templates select="/" mode="M4134"/>
      <xsl:apply-templates select="/" mode="M4135"/>
      <xsl:apply-templates select="/" mode="M4136"/>
      <xsl:apply-templates select="/" mode="M4137"/>
      <xsl:apply-templates select="/" mode="M4138"/>
      <xsl:apply-templates select="/" mode="M4139"/>
      <xsl:apply-templates select="/" mode="M4140"/>
      <xsl:apply-templates select="/" mode="M4141"/>
      <xsl:apply-templates select="/" mode="M4142"/>
      <xsl:apply-templates select="/" mode="M4143"/>
      <xsl:apply-templates select="/" mode="M4144"/>
      <xsl:apply-templates select="/" mode="M4145"/>
   </xsl:template>

   <!--SCHEMATRON PATTERNS-->


   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument"
                 priority="101"
                 mode="M6">

		<!--ASSERT -->
      <xsl:choose>
         <xsl:when test="count(ram:ID)=1"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text> Element 'ram:ID' must occur exactly 1 times.</xsl:text>
            </xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
      <xsl:choose>
         <xsl:when test="count(ram:Name)=1"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text> Element 'ram:Name' must occur exactly 1 times.</xsl:text>
            </xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
      <xsl:choose>
         <xsl:when test="count(ram:TypeCode)=1"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text> Element 'ram:TypeCode' must occur exactly 1 times.</xsl:text>
            </xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
      <xsl:choose>
         <xsl:when test="count(ram:IssueDateTime)=1"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text> Element 'ram:IssueDateTime' must occur exactly 1 times.</xsl:text>
            </xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M6"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M6"/>
   <xsl:template match="@*|node()" priority="-2" mode="M6">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M6"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M6"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:AcceptanceDateTime"
                 priority="101"
                 mode="M7">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:AcceptanceDateTime' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M7"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M7"/>
   <xsl:template match="@*|node()" priority="-2" mode="M7">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M7"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M7"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:AgentTradeParty"
                 priority="101"
                 mode="M8">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:AgentTradeParty' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M8"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M8"/>
   <xsl:template match="@*|node()" priority="-2" mode="M8">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M8"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M8"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:AmendmentPurposeCode"
                 priority="101"
                 mode="M9">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:AmendmentPurposeCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M9"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M9"/>
   <xsl:template match="@*|node()" priority="-2" mode="M9">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M9"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M9"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:AttachedSpecifiedBinaryFile"
                 priority="101"
                 mode="M10">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:AttachedSpecifiedBinaryFile' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M10"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M10"/>
   <xsl:template match="@*|node()" priority="-2" mode="M10">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M10"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M10"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:AttachmentBinaryObject"
                 priority="101"
                 mode="M11">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:AttachmentBinaryObject' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M11"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M11"/>
   <xsl:template match="@*|node()" priority="-2" mode="M11">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M11"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M11"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:CancellationDateTime"
                 priority="101"
                 mode="M12">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:CancellationDateTime' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M12"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M12"/>
   <xsl:template match="@*|node()" priority="-2" mode="M12">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M12"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M12"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:CategoryCode"
                 priority="101"
                 mode="M13">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:CategoryCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M13"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M13"/>
   <xsl:template match="@*|node()" priority="-2" mode="M13">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M13"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M13"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:ContractualDocumentClause"
                 priority="101"
                 mode="M14">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ContractualDocumentClause' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M14"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M14"/>
   <xsl:template match="@*|node()" priority="-2" mode="M14">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M14"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M14"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:ControlRequirementIndicator"
                 priority="101"
                 mode="M15">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ControlRequirementIndicator' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M15"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M15"/>
   <xsl:template match="@*|node()" priority="-2" mode="M15">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M15"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M15"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:CopyIndicator/udt:IndicatorString"
                 priority="101"
                 mode="M16">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'udt:IndicatorString' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M16"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M16"/>
   <xsl:template match="@*|node()" priority="-2" mode="M16">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M16"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M16"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:CopyIssuedQuantity"
                 priority="101"
                 mode="M17">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:CopyIssuedQuantity' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M17"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M17"/>
   <xsl:template match="@*|node()" priority="-2" mode="M17">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M17"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M17"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:CopyRequiredQuantity"
                 priority="101"
                 mode="M18">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:CopyRequiredQuantity' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M18"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M18"/>
   <xsl:template match="@*|node()" priority="-2" mode="M18">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M18"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M18"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:CustomsID"
                 priority="101"
                 mode="M19">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:CustomsID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M19"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M19"/>
   <xsl:template match="@*|node()" priority="-2" mode="M19">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M19"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M19"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:Description"
                 priority="101"
                 mode="M20">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:Description' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M20"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M20"/>
   <xsl:template match="@*|node()" priority="-2" mode="M20">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M20"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M20"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:Disposition"
                 priority="101"
                 mode="M21">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:Disposition' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M21"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M21"/>
   <xsl:template match="@*|node()" priority="-2" mode="M21">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M21"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M21"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:EffectiveSpecifiedPeriod"
                 priority="101"
                 mode="M22">

		<!--ASSERT -->
      <xsl:choose>
         <xsl:when test="count(ram:CompleteDateTime)=1"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text> Element 'ram:CompleteDateTime' must occur exactly 1 times.</xsl:text>
            </xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M22"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M22"/>
   <xsl:template match="@*|node()" priority="-2" mode="M22">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M22"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M22"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:EffectiveSpecifiedPeriod/ram:CompleteDateTime/udt:DateTime"
                 priority="101"
                 mode="M23">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'udt:DateTime' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M23"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M23"/>
   <xsl:template match="@*|node()" priority="-2" mode="M23">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M23"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M23"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:EffectiveSpecifiedPeriod/ram:CompleteDateTime/udt:DateTimeString"
                 priority="101"
                 mode="M24">

		<!--ASSERT -->
      <xsl:choose>
         <xsl:when test="@format"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text> Attribute '@format' is required in this context.</xsl:text>
            </xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M24"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M24"/>
   <xsl:template match="@*|node()" priority="-2" mode="M24">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M24"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M24"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:EffectiveSpecifiedPeriod/ram:ContinuousIndicator"
                 priority="101"
                 mode="M25">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ContinuousIndicator' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M25"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M25"/>
   <xsl:template match="@*|node()" priority="-2" mode="M25">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M25"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M25"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:EffectiveSpecifiedPeriod/ram:Description"
                 priority="101"
                 mode="M26">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:Description' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M26"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M26"/>
   <xsl:template match="@*|node()" priority="-2" mode="M26">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M26"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M26"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:EffectiveSpecifiedPeriod/ram:DurationMeasure"
                 priority="101"
                 mode="M27">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:DurationMeasure' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M27"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M27"/>
   <xsl:template match="@*|node()" priority="-2" mode="M27">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M27"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M27"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:EffectiveSpecifiedPeriod/ram:EndDateTime"
                 priority="101"
                 mode="M28">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:EndDateTime' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M28"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M28"/>
   <xsl:template match="@*|node()" priority="-2" mode="M28">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M28"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M28"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:EffectiveSpecifiedPeriod/ram:ID"
                 priority="101"
                 mode="M29">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M29"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M29"/>
   <xsl:template match="@*|node()" priority="-2" mode="M29">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M29"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M29"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:EffectiveSpecifiedPeriod/ram:InclusiveIndicator"
                 priority="101"
                 mode="M30">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:InclusiveIndicator' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M30"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M30"/>
   <xsl:template match="@*|node()" priority="-2" mode="M30">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M30"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M30"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:EffectiveSpecifiedPeriod/ram:Name"
                 priority="101"
                 mode="M31">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:Name' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M31"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M31"/>
   <xsl:template match="@*|node()" priority="-2" mode="M31">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M31"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M31"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:EffectiveSpecifiedPeriod/ram:OpenIndicator"
                 priority="101"
                 mode="M32">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:OpenIndicator' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M32"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M32"/>
   <xsl:template match="@*|node()" priority="-2" mode="M32">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M32"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M32"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:EffectiveSpecifiedPeriod/ram:PurposeCode"
                 priority="101"
                 mode="M33">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:PurposeCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M33"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M33"/>
   <xsl:template match="@*|node()" priority="-2" mode="M33">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M33"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M33"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:EffectiveSpecifiedPeriod/ram:SeasonCode"
                 priority="101"
                 mode="M34">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:SeasonCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M34"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M34"/>
   <xsl:template match="@*|node()" priority="-2" mode="M34">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M34"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M34"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:EffectiveSpecifiedPeriod/ram:SequenceNumeric"
                 priority="101"
                 mode="M35">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:SequenceNumeric' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M35"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M35"/>
   <xsl:template match="@*|node()" priority="-2" mode="M35">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M35"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M35"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:EffectiveSpecifiedPeriod/ram:StartDateFlexibilityCode"
                 priority="101"
                 mode="M36">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:StartDateFlexibilityCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M36"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M36"/>
   <xsl:template match="@*|node()" priority="-2" mode="M36">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M36"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M36"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:EffectiveSpecifiedPeriod/ram:StartDateTime"
                 priority="101"
                 mode="M37">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:StartDateTime' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M37"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M37"/>
   <xsl:template match="@*|node()" priority="-2" mode="M37">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M37"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M37"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:ElectronicPresentationIndicator"
                 priority="101"
                 mode="M38">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ElectronicPresentationIndicator' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M38"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M38"/>
   <xsl:template match="@*|node()" priority="-2" mode="M38">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M38"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M38"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:FirstSignatoryDocumentAuthentication"
                 priority="101"
                 mode="M39">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:FirstSignatoryDocumentAuthentication' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M39"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M39"/>
   <xsl:template match="@*|node()" priority="-2" mode="M39">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M39"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M39"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:FourthSignatoryDocumentAuthentication"
                 priority="101"
                 mode="M40">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:FourthSignatoryDocumentAuthentication' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M40"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M40"/>
   <xsl:template match="@*|node()" priority="-2" mode="M40">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M40"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M40"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:GlobalID"
                 priority="101"
                 mode="M41">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:GlobalID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M41"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M41"/>
   <xsl:template match="@*|node()" priority="-2" mode="M41">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M41"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M41"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:HeaderInformation"
                 priority="101"
                 mode="M42">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:HeaderInformation' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M42"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M42"/>
   <xsl:template match="@*|node()" priority="-2" mode="M42">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M42"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M42"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:ID[@schemeAgencyID]"
                 priority="101"
                 mode="M43">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeAgencyID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M43"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M43"/>
   <xsl:template match="@*|node()" priority="-2" mode="M43">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M43"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M43"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:ID[@schemeAgencyName]"
                 priority="101"
                 mode="M44">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeAgencyName' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M44"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M44"/>
   <xsl:template match="@*|node()" priority="-2" mode="M44">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M44"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M44"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:ID[@schemeDataURI]"
                 priority="101"
                 mode="M45">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeDataURI' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M45"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M45"/>
   <xsl:template match="@*|node()" priority="-2" mode="M45">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M45"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M45"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:ID[@schemeID]"
                 priority="101"
                 mode="M46">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M46"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M46"/>
   <xsl:template match="@*|node()" priority="-2" mode="M46">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M46"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M46"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:ID[@schemeName]"
                 priority="101"
                 mode="M47">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeName' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M47"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M47"/>
   <xsl:template match="@*|node()" priority="-2" mode="M47">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M47"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M47"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:ID[@schemeURI]"
                 priority="101"
                 mode="M48">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeURI' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M48"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M48"/>
   <xsl:template match="@*|node()" priority="-2" mode="M48">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M48"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M48"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:ID[@schemeVersionID]"
                 priority="101"
                 mode="M49">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeVersionID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M49"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M49"/>
   <xsl:template match="@*|node()" priority="-2" mode="M49">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M49"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M49"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:IncludedNote"
                 priority="101"
                 mode="M50">

		<!--ASSERT -->
      <xsl:choose>
         <xsl:when test="count(ram:ContentCode)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text> Element 'ram:ContentCode' may occur at maximum 1 times.</xsl:text>
            </xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
      <xsl:choose>
         <xsl:when test="count(ram:Content)&gt;=1"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text> Element 'ram:Content' must occur at least 1 times.</xsl:text>
            </xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M50"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M50"/>
   <xsl:template match="@*|node()" priority="-2" mode="M50">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M50"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M50"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:IncludedNote/ram:ContentCode[@languageID]"
                 priority="101"
                 mode="M51">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @languageID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M51"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M51"/>
   <xsl:template match="@*|node()" priority="-2" mode="M51">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M51"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M51"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:IncludedNote/ram:ContentCode[@listAgencyID]"
                 priority="101"
                 mode="M52">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @listAgencyID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M52"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M52"/>
   <xsl:template match="@*|node()" priority="-2" mode="M52">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M52"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M52"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:IncludedNote/ram:ContentCode[@listAgencyName]"
                 priority="101"
                 mode="M53">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @listAgencyName' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M53"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M53"/>
   <xsl:template match="@*|node()" priority="-2" mode="M53">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M53"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M53"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:IncludedNote/ram:ContentCode[@listID]"
                 priority="101"
                 mode="M54">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @listID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M54"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M54"/>
   <xsl:template match="@*|node()" priority="-2" mode="M54">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M54"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M54"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:IncludedNote/ram:ContentCode[@listName]"
                 priority="101"
                 mode="M55">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @listName' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M55"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M55"/>
   <xsl:template match="@*|node()" priority="-2" mode="M55">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M55"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M55"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:IncludedNote/ram:ContentCode[@listSchemeURI]"
                 priority="101"
                 mode="M56">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @listSchemeURI' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M56"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M56"/>
   <xsl:template match="@*|node()" priority="-2" mode="M56">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M56"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M56"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:IncludedNote/ram:ContentCode[@listURI]"
                 priority="101"
                 mode="M57">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @listURI' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M57"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M57"/>
   <xsl:template match="@*|node()" priority="-2" mode="M57">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M57"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M57"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:IncludedNote/ram:ContentCode[@listVersionID]"
                 priority="101"
                 mode="M58">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @listVersionID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M58"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M58"/>
   <xsl:template match="@*|node()" priority="-2" mode="M58">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M58"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M58"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:IncludedNote/ram:ContentCode[@name]"
                 priority="101"
                 mode="M59">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @name' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M59"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M59"/>
   <xsl:template match="@*|node()" priority="-2" mode="M59">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M59"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M59"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:IncludedNote/ram:Content[@languageID]"
                 priority="101"
                 mode="M60">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @languageID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M60"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M60"/>
   <xsl:template match="@*|node()" priority="-2" mode="M60">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M60"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M60"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:IncludedNote/ram:Content[@languageLocaleID]"
                 priority="101"
                 mode="M61">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @languageLocaleID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M61"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M61"/>
   <xsl:template match="@*|node()" priority="-2" mode="M61">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M61"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M61"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:IncludedNote/ram:CreationDateTime"
                 priority="101"
                 mode="M62">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:CreationDateTime' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M62"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M62"/>
   <xsl:template match="@*|node()" priority="-2" mode="M62">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M62"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M62"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:IncludedNote/ram:ID"
                 priority="101"
                 mode="M63">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M63"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M63"/>
   <xsl:template match="@*|node()" priority="-2" mode="M63">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M63"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M63"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:IncludedNote/ram:Name"
                 priority="101"
                 mode="M64">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:Name' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M64"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M64"/>
   <xsl:template match="@*|node()" priority="-2" mode="M64">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M64"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M64"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:IncludedNote/ram:Subject"
                 priority="101"
                 mode="M65">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:Subject' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M65"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M65"/>
   <xsl:template match="@*|node()" priority="-2" mode="M65">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M65"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M65"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:IncludedNote/ram:SubjectCode[@languageID]"
                 priority="101"
                 mode="M66">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @languageID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M66"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M66"/>
   <xsl:template match="@*|node()" priority="-2" mode="M66">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M66"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M66"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:IncludedNote/ram:SubjectCode[@listAgencyID]"
                 priority="101"
                 mode="M67">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @listAgencyID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M67"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M67"/>
   <xsl:template match="@*|node()" priority="-2" mode="M67">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M67"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M67"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:IncludedNote/ram:SubjectCode[@listAgencyName]"
                 priority="101"
                 mode="M68">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @listAgencyName' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M68"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M68"/>
   <xsl:template match="@*|node()" priority="-2" mode="M68">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M68"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M68"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:IncludedNote/ram:SubjectCode[@listID]"
                 priority="101"
                 mode="M69">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @listID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M69"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M69"/>
   <xsl:template match="@*|node()" priority="-2" mode="M69">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M69"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M69"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:IncludedNote/ram:SubjectCode[@listName]"
                 priority="101"
                 mode="M70">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @listName' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M70"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M70"/>
   <xsl:template match="@*|node()" priority="-2" mode="M70">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M70"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M70"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:IncludedNote/ram:SubjectCode[@listSchemeURI]"
                 priority="101"
                 mode="M71">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @listSchemeURI' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M71"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M71"/>
   <xsl:template match="@*|node()" priority="-2" mode="M71">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M71"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M71"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:IncludedNote/ram:SubjectCode[@listURI]"
                 priority="101"
                 mode="M72">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @listURI' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M72"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M72"/>
   <xsl:template match="@*|node()" priority="-2" mode="M72">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M72"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M72"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:IncludedNote/ram:SubjectCode[@listVersionID]"
                 priority="101"
                 mode="M73">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @listVersionID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M73"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M73"/>
   <xsl:template match="@*|node()" priority="-2" mode="M73">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M73"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M73"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:IncludedNote/ram:SubjectCode[@name]"
                 priority="101"
                 mode="M74">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @name' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M74"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M74"/>
   <xsl:template match="@*|node()" priority="-2" mode="M74">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M74"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M74"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:Information"
                 priority="101"
                 mode="M75">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:Information' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M75"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M75"/>
   <xsl:template match="@*|node()" priority="-2" mode="M75">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M75"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M75"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:IssueDateTime/udt:DateTime"
                 priority="101"
                 mode="M76">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'udt:DateTime' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M76"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M76"/>
   <xsl:template match="@*|node()" priority="-2" mode="M76">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M76"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M76"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:IssueDateTime/udt:DateTimeString"
                 priority="101"
                 mode="M77">

		<!--ASSERT -->
      <xsl:choose>
         <xsl:when test="@format"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text> Attribute '@format' is required in this context.</xsl:text>
            </xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M77"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M77"/>
   <xsl:template match="@*|node()" priority="-2" mode="M77">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M77"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M77"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:IssueLogisticsLocation"
                 priority="101"
                 mode="M78">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:IssueLogisticsLocation' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M78"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M78"/>
   <xsl:template match="@*|node()" priority="-2" mode="M78">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M78"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M78"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:IssuerTradeParty"
                 priority="101"
                 mode="M79">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:IssuerTradeParty' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M79"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M79"/>
   <xsl:template match="@*|node()" priority="-2" mode="M79">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M79"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M79"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:ItemIdentificationID"
                 priority="101"
                 mode="M80">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ItemIdentificationID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M80"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M80"/>
   <xsl:template match="@*|node()" priority="-2" mode="M80">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M80"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M80"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:LanguageID[@schemeAgencyID]"
                 priority="101"
                 mode="M81">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeAgencyID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M81"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M81"/>
   <xsl:template match="@*|node()" priority="-2" mode="M81">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M81"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M81"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:LanguageID[@schemeAgencyName]"
                 priority="101"
                 mode="M82">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeAgencyName' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M82"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M82"/>
   <xsl:template match="@*|node()" priority="-2" mode="M82">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M82"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M82"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:LanguageID[@schemeDataURI]"
                 priority="101"
                 mode="M83">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeDataURI' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M83"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M83"/>
   <xsl:template match="@*|node()" priority="-2" mode="M83">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M83"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M83"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:LanguageID[@schemeID]"
                 priority="101"
                 mode="M84">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M84"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M84"/>
   <xsl:template match="@*|node()" priority="-2" mode="M84">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M84"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M84"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:LanguageID[@schemeName]"
                 priority="101"
                 mode="M85">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeName' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M85"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M85"/>
   <xsl:template match="@*|node()" priority="-2" mode="M85">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M85"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M85"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:LanguageID[@schemeURI]"
                 priority="101"
                 mode="M86">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeURI' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M86"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M86"/>
   <xsl:template match="@*|node()" priority="-2" mode="M86">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M86"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M86"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:LanguageID[@schemeVersionID]"
                 priority="101"
                 mode="M87">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeVersionID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M87"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M87"/>
   <xsl:template match="@*|node()" priority="-2" mode="M87">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M87"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M87"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:LineCountNumeric"
                 priority="101"
                 mode="M88">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:LineCountNumeric' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M88"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M88"/>
   <xsl:template match="@*|node()" priority="-2" mode="M88">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M88"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M88"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:LineItemQuantity"
                 priority="101"
                 mode="M89">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:LineItemQuantity' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M89"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M89"/>
   <xsl:template match="@*|node()" priority="-2" mode="M89">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M89"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M89"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:LodgementLogisticsLocation"
                 priority="101"
                 mode="M90">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:LodgementLogisticsLocation' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M90"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M90"/>
   <xsl:template match="@*|node()" priority="-2" mode="M90">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M90"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M90"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:Name[@languageID]"
                 priority="101"
                 mode="M91">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @languageID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M91"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M91"/>
   <xsl:template match="@*|node()" priority="-2" mode="M91">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M91"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M91"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:Name[@languageLocaleID]"
                 priority="101"
                 mode="M92">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @languageLocaleID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M92"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M92"/>
   <xsl:template match="@*|node()" priority="-2" mode="M92">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M92"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M92"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:OriginalIssuedQuantity"
                 priority="101"
                 mode="M93">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:OriginalIssuedQuantity' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M93"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M93"/>
   <xsl:template match="@*|node()" priority="-2" mode="M93">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M93"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M93"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:OriginalRequiredQuantity"
                 priority="101"
                 mode="M94">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:OriginalRequiredQuantity' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M94"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M94"/>
   <xsl:template match="@*|node()" priority="-2" mode="M94">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M94"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M94"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:OwnerTradeParty"
                 priority="101"
                 mode="M95">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:OwnerTradeParty' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M95"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M95"/>
   <xsl:template match="@*|node()" priority="-2" mode="M95">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M95"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M95"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:PageID"
                 priority="101"
                 mode="M96">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:PageID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M96"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M96"/>
   <xsl:template match="@*|node()" priority="-2" mode="M96">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M96"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M96"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:PreviousDocumentID"
                 priority="101"
                 mode="M97">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:PreviousDocumentID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M97"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M97"/>
   <xsl:template match="@*|node()" priority="-2" mode="M97">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M97"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M97"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:PreviousRevisionID"
                 priority="101"
                 mode="M98">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:PreviousRevisionID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M98"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M98"/>
   <xsl:template match="@*|node()" priority="-2" mode="M98">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M98"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M98"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:Purpose"
                 priority="101"
                 mode="M99">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:Purpose' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M99"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M99"/>
   <xsl:template match="@*|node()" priority="-2" mode="M99">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M99"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M99"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:PurposeCode"
                 priority="101"
                 mode="M100">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:PurposeCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M100"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M100"/>
   <xsl:template match="@*|node()" priority="-2" mode="M100">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M100"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M100"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:RecipientAssignedID"
                 priority="101"
                 mode="M101">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:RecipientAssignedID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M101"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M101"/>
   <xsl:template match="@*|node()" priority="-2" mode="M101">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M101"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M101"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:RecipientTradeParty"
                 priority="101"
                 mode="M102">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:RecipientTradeParty' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M102"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M102"/>
   <xsl:template match="@*|node()" priority="-2" mode="M102">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M102"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M102"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:ReferenceReferencedDocument"
                 priority="101"
                 mode="M103">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ReferenceReferencedDocument' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M103"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M103"/>
   <xsl:template match="@*|node()" priority="-2" mode="M103">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M103"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M103"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:RejectionResponseDateTime"
                 priority="101"
                 mode="M104">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:RejectionResponseDateTime' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M104"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M104"/>
   <xsl:template match="@*|node()" priority="-2" mode="M104">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M104"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M104"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:Remarks"
                 priority="101"
                 mode="M105">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:Remarks' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M105"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M105"/>
   <xsl:template match="@*|node()" priority="-2" mode="M105">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M105"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M105"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:RemarksCode"
                 priority="101"
                 mode="M106">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:RemarksCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M106"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M106"/>
   <xsl:template match="@*|node()" priority="-2" mode="M106">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M106"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M106"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:RequestedResponseTypeCode"
                 priority="101"
                 mode="M107">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:RequestedResponseTypeCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>

		    <!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:RequestedResponseTypeCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M107"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M107"/>
   <xsl:template match="@*|node()" priority="-2" mode="M107">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M107"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M107"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:ResponseDateTime"
                 priority="101"
                 mode="M108">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ResponseDateTime' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M108"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M108"/>
   <xsl:template match="@*|node()" priority="-2" mode="M108">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M108"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M108"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:ResponseDocumentTypeCode"
                 priority="101"
                 mode="M109">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ResponseDocumentTypeCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>

		    <!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ResponseDocumentTypeCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M109"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M109"/>
   <xsl:template match="@*|node()" priority="-2" mode="M109">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M109"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M109"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:ResponseReasonCode"
                 priority="101"
                 mode="M110">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ResponseReasonCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M110"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M110"/>
   <xsl:template match="@*|node()" priority="-2" mode="M110">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M110"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M110"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:RevisionDateTime"
                 priority="101"
                 mode="M111">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:RevisionDateTime' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M111"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M111"/>
   <xsl:template match="@*|node()" priority="-2" mode="M111">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M111"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M111"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:RevisionID"
                 priority="101"
                 mode="M112">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:RevisionID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M112"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M112"/>
   <xsl:template match="@*|node()" priority="-2" mode="M112">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M112"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M112"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:SecondSignatoryDocumentAuthentication"
                 priority="101"
                 mode="M113">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:SecondSignatoryDocumentAuthentication' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M113"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M113"/>
   <xsl:template match="@*|node()" priority="-2" mode="M113">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M113"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M113"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:SenderAssignedID"
                 priority="101"
                 mode="M114">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:SenderAssignedID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M114"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M114"/>
   <xsl:template match="@*|node()" priority="-2" mode="M114">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M114"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M114"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:SenderTradeParty"
                 priority="101"
                 mode="M115">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:SenderTradeParty' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M115"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M115"/>
   <xsl:template match="@*|node()" priority="-2" mode="M115">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M115"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M115"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:SignatoryDocumentAuthentication"
                 priority="101"
                 mode="M116">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:SignatoryDocumentAuthentication' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M116"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M116"/>
   <xsl:template match="@*|node()" priority="-2" mode="M116">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M116"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M116"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:StatusCode"
                 priority="101"
                 mode="M117">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:StatusCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M117"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M117"/>
   <xsl:template match="@*|node()" priority="-2" mode="M117">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M117"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M117"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:SubmissionDateTime"
                 priority="101"
                 mode="M118">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:SubmissionDateTime' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M118"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M118"/>
   <xsl:template match="@*|node()" priority="-2" mode="M118">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M118"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M118"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:SuffixID"
                 priority="101"
                 mode="M119">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:SuffixID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M119"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M119"/>
   <xsl:template match="@*|node()" priority="-2" mode="M119">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M119"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M119"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:SummaryInformation"
                 priority="101"
                 mode="M120">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:SummaryInformation' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M120"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M120"/>
   <xsl:template match="@*|node()" priority="-2" mode="M120">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M120"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M120"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:ThirdSignatoryDocumentAuthentication"
                 priority="101"
                 mode="M121">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ThirdSignatoryDocumentAuthentication' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M121"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M121"/>
   <xsl:template match="@*|node()" priority="-2" mode="M121">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M121"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M121"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:TotalPageQuantity"
                 priority="101"
                 mode="M122">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:TotalPageQuantity' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M122"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M122"/>
   <xsl:template match="@*|node()" priority="-2" mode="M122">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M122"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M122"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:TraderAssignedID"
                 priority="101"
                 mode="M123">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:TraderAssignedID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M123"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M123"/>
   <xsl:template match="@*|node()" priority="-2" mode="M123">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M123"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M123"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:TypeCode[@listAgencyID]"
                 priority="101"
                 mode="M124">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @listAgencyID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M124"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M124"/>
   <xsl:template match="@*|node()" priority="-2" mode="M124">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M124"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M124"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:TypeCode[@listID]"
                 priority="101"
                 mode="M125">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @listID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M125"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M125"/>
   <xsl:template match="@*|node()" priority="-2" mode="M125">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M125"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M125"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:TypeCode[@listURI]"
                 priority="101"
                 mode="M126">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @listURI' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M126"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M126"/>
   <xsl:template match="@*|node()" priority="-2" mode="M126">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M126"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M126"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:TypeCode[@listVersionID]"
                 priority="101"
                 mode="M127">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @listVersionID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M127"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M127"/>
   <xsl:template match="@*|node()" priority="-2" mode="M127">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M127"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M127"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:TypeCode[@name]"
                 priority="101"
                 mode="M128">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @name' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M128"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M128"/>
   <xsl:template match="@*|node()" priority="-2" mode="M128">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M128"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M128"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:HeaderExchangedDocument/ram:VersionID"
                 priority="101"
                 mode="M129">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:VersionID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M129"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M129"/>
   <xsl:template match="@*|node()" priority="-2" mode="M129">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M129"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M129"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedExchangedDocumentContext"
                 priority="101"
                 mode="M130">

		<!--ASSERT -->
      <xsl:choose>
         <xsl:when test="count(ram:BusinessProcessSpecifiedDocumentContextParameter)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text> Element 'ram:BusinessProcessSpecifiedDocumentContextParameter' may occur at maximum 1 times.</xsl:text>
            </xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
      <xsl:choose>
         <xsl:when test="count(ram:GuidelineSpecifiedDocumentContextParameter)=1"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text> Element 'ram:GuidelineSpecifiedDocumentContextParameter' must occur exactly 1 times.</xsl:text>
            </xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M130"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M130"/>
   <xsl:template match="@*|node()" priority="-2" mode="M130">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M130"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M130"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedExchangedDocumentContext/ram:ApplicationSpecifiedDocumentContextParameter"
                 priority="101"
                 mode="M131">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ApplicationSpecifiedDocumentContextParameter' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M131"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M131"/>
   <xsl:template match="@*|node()" priority="-2" mode="M131">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M131"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M131"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedExchangedDocumentContext/ram:BIMSpecifiedDocumentContextParameter"
                 priority="101"
                 mode="M132">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:BIMSpecifiedDocumentContextParameter' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M132"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M132"/>
   <xsl:template match="@*|node()" priority="-2" mode="M132">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M132"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M132"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedExchangedDocumentContext/ram:BusinessProcessSpecifiedDocumentContextParameter/ram:ID[@schemeAgencyID]"
                 priority="101"
                 mode="M133">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeAgencyID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M133"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M133"/>
   <xsl:template match="@*|node()" priority="-2" mode="M133">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M133"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M133"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedExchangedDocumentContext/ram:BusinessProcessSpecifiedDocumentContextParameter/ram:ID[@schemeAgencyName]"
                 priority="101"
                 mode="M134">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeAgencyName' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M134"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M134"/>
   <xsl:template match="@*|node()" priority="-2" mode="M134">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M134"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M134"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedExchangedDocumentContext/ram:BusinessProcessSpecifiedDocumentContextParameter/ram:ID[@schemeDataURI]"
                 priority="101"
                 mode="M135">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeDataURI' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M135"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M135"/>
   <xsl:template match="@*|node()" priority="-2" mode="M135">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M135"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M135"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedExchangedDocumentContext/ram:BusinessProcessSpecifiedDocumentContextParameter/ram:ID[@schemeID]"
                 priority="101"
                 mode="M136">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M136"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M136"/>
   <xsl:template match="@*|node()" priority="-2" mode="M136">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M136"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M136"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedExchangedDocumentContext/ram:BusinessProcessSpecifiedDocumentContextParameter/ram:ID[@schemeName]"
                 priority="101"
                 mode="M137">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeName' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M137"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M137"/>
   <xsl:template match="@*|node()" priority="-2" mode="M137">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M137"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M137"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedExchangedDocumentContext/ram:BusinessProcessSpecifiedDocumentContextParameter/ram:ID[@schemeURI]"
                 priority="101"
                 mode="M138">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeURI' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M138"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M138"/>
   <xsl:template match="@*|node()" priority="-2" mode="M138">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M138"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M138"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedExchangedDocumentContext/ram:BusinessProcessSpecifiedDocumentContextParameter/ram:ID[@schemeVersionID]"
                 priority="101"
                 mode="M139">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeVersionID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M139"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M139"/>
   <xsl:template match="@*|node()" priority="-2" mode="M139">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M139"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M139"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedExchangedDocumentContext/ram:BusinessProcessSpecifiedDocumentContextParameter/ram:SpecifiedDocumentVersion"
                 priority="101"
                 mode="M140">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:SpecifiedDocumentVersion' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M140"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M140"/>
   <xsl:template match="@*|node()" priority="-2" mode="M140">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M140"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M140"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedExchangedDocumentContext/ram:BusinessProcessSpecifiedDocumentContextParameter/ram:Value"
                 priority="101"
                 mode="M141">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:Value' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M141"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M141"/>
   <xsl:template match="@*|node()" priority="-2" mode="M141">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M141"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M141"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedExchangedDocumentContext/ram:GuidelineSpecifiedDocumentContextParameter"
                 priority="101"
                 mode="M142">

		<!--ASSERT -->
      <xsl:choose>
         <xsl:when test="count(ram:ID)=1"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text> Element 'ram:ID' must occur exactly 1 times.</xsl:text>
            </xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M142"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M142"/>
   <xsl:template match="@*|node()" priority="-2" mode="M142">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M142"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M142"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedExchangedDocumentContext/ram:GuidelineSpecifiedDocumentContextParameter/ram:ID[@schemeAgencyID]"
                 priority="101"
                 mode="M143">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeAgencyID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M143"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M143"/>
   <xsl:template match="@*|node()" priority="-2" mode="M143">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M143"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M143"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedExchangedDocumentContext/ram:GuidelineSpecifiedDocumentContextParameter/ram:ID[@schemeAgencyName]"
                 priority="101"
                 mode="M144">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeAgencyName' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M144"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M144"/>
   <xsl:template match="@*|node()" priority="-2" mode="M144">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M144"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M144"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedExchangedDocumentContext/ram:GuidelineSpecifiedDocumentContextParameter/ram:ID[@schemeDataURI]"
                 priority="101"
                 mode="M145">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeDataURI' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M145"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M145"/>
   <xsl:template match="@*|node()" priority="-2" mode="M145">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M145"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M145"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedExchangedDocumentContext/ram:GuidelineSpecifiedDocumentContextParameter/ram:ID[@schemeID]"
                 priority="101"
                 mode="M146">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M146"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M146"/>
   <xsl:template match="@*|node()" priority="-2" mode="M146">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M146"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M146"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedExchangedDocumentContext/ram:GuidelineSpecifiedDocumentContextParameter/ram:ID[@schemeName]"
                 priority="101"
                 mode="M147">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeName' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M147"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M147"/>
   <xsl:template match="@*|node()" priority="-2" mode="M147">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M147"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M147"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedExchangedDocumentContext/ram:GuidelineSpecifiedDocumentContextParameter/ram:ID[@schemeURI]"
                 priority="101"
                 mode="M148">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeURI' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M148"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M148"/>
   <xsl:template match="@*|node()" priority="-2" mode="M148">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M148"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M148"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedExchangedDocumentContext/ram:GuidelineSpecifiedDocumentContextParameter/ram:ID[@schemeVersionID]"
                 priority="101"
                 mode="M149">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeVersionID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M149"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M149"/>
   <xsl:template match="@*|node()" priority="-2" mode="M149">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M149"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M149"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedExchangedDocumentContext/ram:GuidelineSpecifiedDocumentContextParameter/ram:SpecifiedDocumentVersion"
                 priority="101"
                 mode="M150">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:SpecifiedDocumentVersion' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M150"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M150"/>
   <xsl:template match="@*|node()" priority="-2" mode="M150">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M150"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M150"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedExchangedDocumentContext/ram:GuidelineSpecifiedDocumentContextParameter/ram:Value"
                 priority="101"
                 mode="M151">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:Value' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M151"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M151"/>
   <xsl:template match="@*|node()" priority="-2" mode="M151">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M151"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M151"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedExchangedDocumentContext/ram:MessageStandardSpecifiedDocumentContextParameter"
                 priority="101"
                 mode="M152">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:MessageStandardSpecifiedDocumentContextParameter' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M152"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M152"/>
   <xsl:template match="@*|node()" priority="-2" mode="M152">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M152"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M152"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedExchangedDocumentContext/ram:ScenarioSpecifiedDocumentContextParameter"
                 priority="101"
                 mode="M153">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ScenarioSpecifiedDocumentContextParameter' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M153"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M153"/>
   <xsl:template match="@*|node()" priority="-2" mode="M153">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M153"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M153"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedExchangedDocumentContext/ram:SpecifiedTransactionID"
                 priority="101"
                 mode="M154">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:SpecifiedTransactionID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M154"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M154"/>
   <xsl:template match="@*|node()" priority="-2" mode="M154">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M154"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M154"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedExchangedDocumentContext/ram:SubsetSpecifiedDocumentContextParameter"
                 priority="101"
                 mode="M155">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:SubsetSpecifiedDocumentContextParameter' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M155"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M155"/>
   <xsl:template match="@*|node()" priority="-2" mode="M155">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M155"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M155"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedExchangedDocumentContext/ram:TestIndicator/udt:IndicatorString"
                 priority="101"
                 mode="M156">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'udt:IndicatorString' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M156"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M156"/>
   <xsl:template match="@*|node()" priority="-2" mode="M156">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M156"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M156"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction"
                 priority="101"
                 mode="M157">

		<!--ASSERT -->
      <xsl:choose>
         <xsl:when test="count(ram:ApplicableSupplyChainTradeAgreement)=1"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text> Element 'ram:ApplicableSupplyChainTradeAgreement' must occur exactly 1 times.</xsl:text>
            </xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
      <xsl:choose>
         <xsl:when test="count(ram:ApplicableSupplyChainTradeDelivery)=1"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text> Element 'ram:ApplicableSupplyChainTradeDelivery' must occur exactly 1 times.</xsl:text>
            </xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
      <xsl:choose>
         <xsl:when test="count(ram:ApplicableSupplyChainTradeSettlement)=1"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text> Element 'ram:ApplicableSupplyChainTradeSettlement' must occur exactly 1 times.</xsl:text>
            </xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
      <xsl:choose>
         <xsl:when test="count(ram:IncludedSupplyChainTradeLineItem)&gt;=1"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text> Element 'ram:IncludedSupplyChainTradeLineItem' must occur at least 1 times.</xsl:text>
            </xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M157"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M157"/>
   <xsl:template match="@*|node()" priority="-2" mode="M157">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M157"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M157"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement"
                 priority="101"
                 mode="M158">

		<!--ASSERT -->
      <xsl:choose>
         <xsl:when test="count(ram:BuyerReference)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text> Element 'ram:BuyerReference' may occur at maximum 1 times.</xsl:text>
            </xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
      <xsl:choose>
         <xsl:when test="count(ram:SellerTradeParty)=1"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text> Element 'ram:SellerTradeParty' must occur exactly 1 times.</xsl:text>
            </xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
      <xsl:choose>
         <xsl:when test="count(ram:BuyerTradeParty)=1"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text> Element 'ram:BuyerTradeParty' must occur exactly 1 times.</xsl:text>
            </xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
      <xsl:choose>
         <xsl:when test="count(ram:BuyerOrderReferencedDocument)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text> Element 'ram:BuyerOrderReferencedDocument' may occur at maximum 1 times.</xsl:text>
            </xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
      <xsl:choose>
         <xsl:when test="count(ram:ContractReferencedDocument)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text> Element 'ram:ContractReferencedDocument' may occur at maximum 1 times.</xsl:text>
            </xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
      <xsl:choose>
         <xsl:when test="count(ram:CustomerOrderReferencedDocument)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text> Element 'ram:CustomerOrderReferencedDocument' may occur at maximum 1 times.</xsl:text>
            </xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M158"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M158"/>
   <xsl:template match="@*|node()" priority="-2" mode="M158">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M158"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M158"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument"
                 priority="101"
                 mode="M159">

		<!--ASSERT -->
      <xsl:choose>
         <xsl:when test="count(ram:TypeCode)=1"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text> Element 'ram:TypeCode' must occur exactly 1 times.</xsl:text>
            </xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
      <xsl:choose>
         <xsl:when test="count(ram:ID)=1"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text> Element 'ram:ID' must occur exactly 1 times.</xsl:text>
            </xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M159"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M159"/>
   <xsl:template match="@*|node()" priority="-2" mode="M159">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M159"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M159"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:AcceptableSpecifiedPeriod"
                 priority="101"
                 mode="M160">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:AcceptableSpecifiedPeriod' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M160"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M160"/>
   <xsl:template match="@*|node()" priority="-2" mode="M160">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M160"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M160"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:AcceptanceDateTime"
                 priority="101"
                 mode="M161">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:AcceptanceDateTime' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M161"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M161"/>
   <xsl:template match="@*|node()" priority="-2" mode="M161">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M161"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M161"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:AmendmentPurposeCode"
                 priority="101"
                 mode="M162">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:AmendmentPurposeCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M162"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M162"/>
   <xsl:template match="@*|node()" priority="-2" mode="M162">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M162"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M162"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:AttachedSpecifiedBinaryFile"
                 priority="101"
                 mode="M163">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:AttachedSpecifiedBinaryFile' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M163"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M163"/>
   <xsl:template match="@*|node()" priority="-2" mode="M163">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M163"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M163"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:AttachmentBinaryObject"
                 priority="101"
                 mode="M164">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:AttachmentBinaryObject' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M164"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M164"/>
   <xsl:template match="@*|node()" priority="-2" mode="M164">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M164"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M164"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:AuthenticatedOriginalIndicator"
                 priority="101"
                 mode="M165">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:AuthenticatedOriginalIndicator' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M165"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M165"/>
   <xsl:template match="@*|node()" priority="-2" mode="M165">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M165"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M165"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:CategoryCode"
                 priority="101"
                 mode="M166">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:CategoryCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M166"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M166"/>
   <xsl:template match="@*|node()" priority="-2" mode="M166">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M166"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M166"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:ChannelCode"
                 priority="101"
                 mode="M167">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ChannelCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M167"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M167"/>
   <xsl:template match="@*|node()" priority="-2" mode="M167">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M167"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M167"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:ContractualDocumentClause"
                 priority="101"
                 mode="M168">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ContractualDocumentClause' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M168"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M168"/>
   <xsl:template match="@*|node()" priority="-2" mode="M168">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M168"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M168"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:CopyIndicator"
                 priority="101"
                 mode="M169">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:CopyIndicator' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M169"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M169"/>
   <xsl:template match="@*|node()" priority="-2" mode="M169">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M169"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M169"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:CopyIssuedQuantity"
                 priority="101"
                 mode="M170">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:CopyIssuedQuantity' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M170"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M170"/>
   <xsl:template match="@*|node()" priority="-2" mode="M170">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M170"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M170"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:CopyRequiredQuantity"
                 priority="101"
                 mode="M171">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:CopyRequiredQuantity' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M171"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M171"/>
   <xsl:template match="@*|node()" priority="-2" mode="M171">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M171"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M171"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:CreationDateTime"
                 priority="101"
                 mode="M172">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:CreationDateTime' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M172"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M172"/>
   <xsl:template match="@*|node()" priority="-2" mode="M172">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M172"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M172"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:EffectiveSpecifiedPeriod"
                 priority="101"
                 mode="M173">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:EffectiveSpecifiedPeriod' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M173"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M173"/>
   <xsl:template match="@*|node()" priority="-2" mode="M173">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M173"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M173"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:ElectronicPresentationIndicator"
                 priority="101"
                 mode="M174">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ElectronicPresentationIndicator' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M174"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M174"/>
   <xsl:template match="@*|node()" priority="-2" mode="M174">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M174"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M174"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:GlobalID"
                 priority="101"
                 mode="M175">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:GlobalID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M175"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M175"/>
   <xsl:template match="@*|node()" priority="-2" mode="M175">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M175"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M175"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:ID[@schemeAgencyID]"
                 priority="101"
                 mode="M176">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeAgencyID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M176"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M176"/>
   <xsl:template match="@*|node()" priority="-2" mode="M176">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M176"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M176"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:ID[@schemeAgencyName]"
                 priority="101"
                 mode="M177">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeAgencyName' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M177"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M177"/>
   <xsl:template match="@*|node()" priority="-2" mode="M177">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M177"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M177"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:ID[@schemeDataURI]"
                 priority="101"
                 mode="M178">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeDataURI' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M178"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M178"/>
   <xsl:template match="@*|node()" priority="-2" mode="M178">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M178"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M178"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:ID[@schemeID]"
                 priority="101"
                 mode="M179">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M179"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M179"/>
   <xsl:template match="@*|node()" priority="-2" mode="M179">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M179"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M179"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:ID[@schemeName]"
                 priority="101"
                 mode="M180">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeName' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M180"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M180"/>
   <xsl:template match="@*|node()" priority="-2" mode="M180">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M180"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M180"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:ID[@schemeURI]"
                 priority="101"
                 mode="M181">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeURI' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M181"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M181"/>
   <xsl:template match="@*|node()" priority="-2" mode="M181">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M181"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M181"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:ID[@schemeVersionID]"
                 priority="101"
                 mode="M182">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeVersionID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M182"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M182"/>
   <xsl:template match="@*|node()" priority="-2" mode="M182">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M182"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M182"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:Information"
                 priority="101"
                 mode="M183">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:Information' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M183"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M183"/>
   <xsl:template match="@*|node()" priority="-2" mode="M183">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M183"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M183"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:IssueLogisticsLocation"
                 priority="101"
                 mode="M184">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:IssueLogisticsLocation' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M184"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M184"/>
   <xsl:template match="@*|node()" priority="-2" mode="M184">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M184"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M184"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:IssuerAssignedID"
                 priority="101"
                 mode="M185">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:IssuerAssignedID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M185"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M185"/>
   <xsl:template match="@*|node()" priority="-2" mode="M185">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M185"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M185"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:IssuerTradeParty"
                 priority="101"
                 mode="M186">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:IssuerTradeParty' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M186"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M186"/>
   <xsl:template match="@*|node()" priority="-2" mode="M186">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M186"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M186"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:ItemIdentificationID"
                 priority="101"
                 mode="M187">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ItemIdentificationID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M187"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M187"/>
   <xsl:template match="@*|node()" priority="-2" mode="M187">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M187"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M187"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:LanguageID"
                 priority="101"
                 mode="M188">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:LanguageID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M188"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M188"/>
   <xsl:template match="@*|node()" priority="-2" mode="M188">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M188"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M188"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:LineID"
                 priority="101"
                 mode="M189">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:LineID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M189"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M189"/>
   <xsl:template match="@*|node()" priority="-2" mode="M189">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M189"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M189"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:LineItemQuantity"
                 priority="101"
                 mode="M190">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:LineItemQuantity' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M190"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M190"/>
   <xsl:template match="@*|node()" priority="-2" mode="M190">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M190"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M190"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:LineStatusCode"
                 priority="101"
                 mode="M191">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:LineStatusCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M191"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M191"/>
   <xsl:template match="@*|node()" priority="-2" mode="M191">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M191"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M191"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:LodgementLogisticsLocation"
                 priority="101"
                 mode="M192">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:LodgementLogisticsLocation' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M192"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M192"/>
   <xsl:template match="@*|node()" priority="-2" mode="M192">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M192"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M192"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:Name"
                 priority="101"
                 mode="M193">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:Name' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M193"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M193"/>
   <xsl:template match="@*|node()" priority="-2" mode="M193">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M193"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M193"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:OriginalIssuedQuantity"
                 priority="101"
                 mode="M194">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:OriginalIssuedQuantity' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M194"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M194"/>
   <xsl:template match="@*|node()" priority="-2" mode="M194">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M194"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M194"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:OriginalRequiredQuantity"
                 priority="101"
                 mode="M195">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:OriginalRequiredQuantity' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M195"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M195"/>
   <xsl:template match="@*|node()" priority="-2" mode="M195">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M195"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M195"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:PreviousRevisionID"
                 priority="101"
                 mode="M196">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:PreviousRevisionID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M196"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M196"/>
   <xsl:template match="@*|node()" priority="-2" mode="M196">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M196"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M196"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:PurposeCode"
                 priority="101"
                 mode="M197">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:PurposeCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M197"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M197"/>
   <xsl:template match="@*|node()" priority="-2" mode="M197">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M197"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M197"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:ReceiptDateTime"
                 priority="101"
                 mode="M198">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ReceiptDateTime' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M198"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M198"/>
   <xsl:template match="@*|node()" priority="-2" mode="M198">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M198"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M198"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:RecipientTradeParty"
                 priority="101"
                 mode="M199">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:RecipientTradeParty' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M199"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M199"/>
   <xsl:template match="@*|node()" priority="-2" mode="M199">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M199"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M199"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:ReferenceTypeCode"
                 priority="101"
                 mode="M200">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ReferenceTypeCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M200"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M200"/>
   <xsl:template match="@*|node()" priority="-2" mode="M200">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M200"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M200"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:RelationshipTypeCode"
                 priority="101"
                 mode="M201">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:RelationshipTypeCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M201"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M201"/>
   <xsl:template match="@*|node()" priority="-2" mode="M201">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M201"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M201"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:Remarks"
                 priority="101"
                 mode="M202">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:Remarks' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M202"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M202"/>
   <xsl:template match="@*|node()" priority="-2" mode="M202">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M202"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M202"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:Revision"
                 priority="101"
                 mode="M203">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:Revision' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M203"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M203"/>
   <xsl:template match="@*|node()" priority="-2" mode="M203">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M203"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M203"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:RevisionDateTime"
                 priority="101"
                 mode="M204">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:RevisionDateTime' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M204"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M204"/>
   <xsl:template match="@*|node()" priority="-2" mode="M204">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M204"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M204"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:RevisionID"
                 priority="101"
                 mode="M205">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:RevisionID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M205"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M205"/>
   <xsl:template match="@*|node()" priority="-2" mode="M205">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M205"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M205"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:SectionName"
                 priority="101"
                 mode="M206">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:SectionName' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M206"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M206"/>
   <xsl:template match="@*|node()" priority="-2" mode="M206">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M206"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M206"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:SignatoryDocumentAuthentication"
                 priority="101"
                 mode="M207">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:SignatoryDocumentAuthentication' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M207"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M207"/>
   <xsl:template match="@*|node()" priority="-2" mode="M207">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M207"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M207"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:StatusCode"
                 priority="101"
                 mode="M208">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:StatusCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M208"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M208"/>
   <xsl:template match="@*|node()" priority="-2" mode="M208">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M208"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M208"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:SubordinateLineID"
                 priority="101"
                 mode="M209">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:SubordinateLineID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M209"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M209"/>
   <xsl:template match="@*|node()" priority="-2" mode="M209">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M209"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M209"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:TypeCode[@listAgencyID]"
                 priority="101"
                 mode="M210">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @listAgencyID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M210"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M210"/>
   <xsl:template match="@*|node()" priority="-2" mode="M210">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M210"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M210"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:TypeCode[@listID]"
                 priority="101"
                 mode="M211">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @listID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M211"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M211"/>
   <xsl:template match="@*|node()" priority="-2" mode="M211">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M211"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M211"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:TypeCode[@listURI]"
                 priority="101"
                 mode="M212">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @listURI' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M212"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M212"/>
   <xsl:template match="@*|node()" priority="-2" mode="M212">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M212"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M212"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:TypeCode[@listVersionID]"
                 priority="101"
                 mode="M213">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @listVersionID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M213"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M213"/>
   <xsl:template match="@*|node()" priority="-2" mode="M213">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M213"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M213"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:TypeCode[@name]"
                 priority="101"
                 mode="M214">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @name' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M214"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M214"/>
   <xsl:template match="@*|node()" priority="-2" mode="M214">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M214"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M214"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdditionalReferencedDocument/ram:URIID"
                 priority="101"
                 mode="M215">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:URIID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M215"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M215"/>
   <xsl:template match="@*|node()" priority="-2" mode="M215">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M215"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M215"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdministrativeAgentTradeParty"
                 priority="101"
                 mode="M216">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:AdministrativeAgentTradeParty' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M216"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M216"/>
   <xsl:template match="@*|node()" priority="-2" mode="M216">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M216"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M216"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AdministrativeTradeParty"
                 priority="101"
                 mode="M217">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:AdministrativeTradeParty' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M217"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M217"/>
   <xsl:template match="@*|node()" priority="-2" mode="M217">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M217"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M217"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:AgreedPriceProductTradePrice"
                 priority="101"
                 mode="M218">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:AgreedPriceProductTradePrice' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M218"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M218"/>
   <xsl:template match="@*|node()" priority="-2" mode="M218">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M218"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M218"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ApplicableLogisticsLocation"
                 priority="101"
                 mode="M219">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ApplicableLogisticsLocation' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M219"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M219"/>
   <xsl:template match="@*|node()" priority="-2" mode="M219">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M219"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M219"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ApplicableSupplyChainForecastTerms"
                 priority="101"
                 mode="M220">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ApplicableSupplyChainForecastTerms' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M220"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M220"/>
   <xsl:template match="@*|node()" priority="-2" mode="M220">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M220"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M220"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ApplicableTradeAllowanceCharge"
                 priority="101"
                 mode="M221">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ApplicableTradeAllowanceCharge' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M221"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M221"/>
   <xsl:template match="@*|node()" priority="-2" mode="M221">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M221"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M221"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ApplicableTradeDeliveryTerms"
                 priority="101"
                 mode="M222">

		<!--ASSERT -->
      <xsl:choose>
         <xsl:when test="count(ram:DeliveryTypeCode)=1"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text> Element 'ram:DeliveryTypeCode' must occur exactly 1 times.</xsl:text>
            </xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M222"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M222"/>
   <xsl:template match="@*|node()" priority="-2" mode="M222">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M222"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M222"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ApplicableTradeDeliveryTerms/ram:DeclarationCountryRelationshipCode"
                 priority="101"
                 mode="M223">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:DeclarationCountryRelationshipCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M223"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M223"/>
   <xsl:template match="@*|node()" priority="-2" mode="M223">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M223"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M223"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ApplicableTradeDeliveryTerms/ram:DeliveryTypeCode[@listAgencyID]"
                 priority="101"
                 mode="M224">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @listAgencyID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M224"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M224"/>
   <xsl:template match="@*|node()" priority="-2" mode="M224">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M224"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M224"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ApplicableTradeDeliveryTerms/ram:DeliveryTypeCode[@listID]"
                 priority="101"
                 mode="M225">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @listID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M225"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M225"/>
   <xsl:template match="@*|node()" priority="-2" mode="M225">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M225"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M225"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ApplicableTradeDeliveryTerms/ram:DeliveryTypeCode[@listVersionID]"
                 priority="101"
                 mode="M226">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @listVersionID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M226"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M226"/>
   <xsl:template match="@*|node()" priority="-2" mode="M226">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M226"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M226"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ApplicableTradeDeliveryTerms/ram:Description"
                 priority="101"
                 mode="M227">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:Description' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M227"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M227"/>
   <xsl:template match="@*|node()" priority="-2" mode="M227">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M227"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M227"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ApplicableTradeDeliveryTerms/ram:FunctionCode"
                 priority="101"
                 mode="M228">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:FunctionCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M228"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M228"/>
   <xsl:template match="@*|node()" priority="-2" mode="M228">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M228"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M228"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ApplicableTradeDeliveryTerms/ram:RelevantTradeLocation"
                 priority="101"
                 mode="M229">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:RelevantTradeLocation' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M229"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M229"/>
   <xsl:template match="@*|node()" priority="-2" mode="M229">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M229"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M229"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ApplicableTradeDeliveryTerms/ram:RiskResponsibilityCode"
                 priority="101"
                 mode="M230">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:RiskResponsibilityCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M230"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M230"/>
   <xsl:template match="@*|node()" priority="-2" mode="M230">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M230"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M230"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ApplicableTradePaymentTerms"
                 priority="101"
                 mode="M231">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ApplicableTradePaymentTerms' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M231"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M231"/>
   <xsl:template match="@*|node()" priority="-2" mode="M231">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M231"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M231"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BillOfQuantitiesReferencedDocument"
                 priority="101"
                 mode="M232">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:BillOfQuantitiesReferencedDocument' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M232"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M232"/>
   <xsl:template match="@*|node()" priority="-2" mode="M232">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M232"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M232"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BlanketOrderReferencedDocument"
                 priority="101"
                 mode="M233">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:BlanketOrderReferencedDocument' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M233"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M233"/>
   <xsl:template match="@*|node()" priority="-2" mode="M233">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M233"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M233"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerAgentTradeParty"
                 priority="101"
                 mode="M234">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:BuyerAgentTradeParty' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M234"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M234"/>
   <xsl:template match="@*|node()" priority="-2" mode="M234">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M234"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M234"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerAssignedAccountantTradeParty"
                 priority="101"
                 mode="M235">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:BuyerAssignedAccountantTradeParty' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M235"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M235"/>
   <xsl:template match="@*|node()" priority="-2" mode="M235">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M235"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M235"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerBankTradeParty"
                 priority="101"
                 mode="M236">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:BuyerBankTradeParty' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M236"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M236"/>
   <xsl:template match="@*|node()" priority="-2" mode="M236">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M236"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M236"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerOrderReferencedDocument"
                 priority="101"
                 mode="M237">

		<!--ASSERT -->
      <xsl:choose>
         <xsl:when test="count(ram:ID)=1"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text> Element 'ram:ID' must occur exactly 1 times.</xsl:text>
            </xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M237"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M237"/>
   <xsl:template match="@*|node()" priority="-2" mode="M237">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M237"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M237"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerOrderReferencedDocument/ram:AcceptableSpecifiedPeriod"
                 priority="101"
                 mode="M238">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:AcceptableSpecifiedPeriod' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M238"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M238"/>
   <xsl:template match="@*|node()" priority="-2" mode="M238">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M238"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M238"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerOrderReferencedDocument/ram:AcceptanceDateTime"
                 priority="101"
                 mode="M239">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:AcceptanceDateTime' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M239"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M239"/>
   <xsl:template match="@*|node()" priority="-2" mode="M239">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M239"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M239"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerOrderReferencedDocument/ram:AmendmentPurposeCode"
                 priority="101"
                 mode="M240">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:AmendmentPurposeCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M240"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M240"/>
   <xsl:template match="@*|node()" priority="-2" mode="M240">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M240"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M240"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerOrderReferencedDocument/ram:AttachedSpecifiedBinaryFile"
                 priority="101"
                 mode="M241">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:AttachedSpecifiedBinaryFile' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M241"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M241"/>
   <xsl:template match="@*|node()" priority="-2" mode="M241">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M241"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M241"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerOrderReferencedDocument/ram:AttachmentBinaryObject"
                 priority="101"
                 mode="M242">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:AttachmentBinaryObject' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M242"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M242"/>
   <xsl:template match="@*|node()" priority="-2" mode="M242">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M242"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M242"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerOrderReferencedDocument/ram:AuthenticatedOriginalIndicator"
                 priority="101"
                 mode="M243">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:AuthenticatedOriginalIndicator' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M243"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M243"/>
   <xsl:template match="@*|node()" priority="-2" mode="M243">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M243"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M243"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerOrderReferencedDocument/ram:CategoryCode"
                 priority="101"
                 mode="M244">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:CategoryCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M244"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M244"/>
   <xsl:template match="@*|node()" priority="-2" mode="M244">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M244"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M244"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerOrderReferencedDocument/ram:ChannelCode"
                 priority="101"
                 mode="M245">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ChannelCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M245"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M245"/>
   <xsl:template match="@*|node()" priority="-2" mode="M245">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M245"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M245"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerOrderReferencedDocument/ram:ContractualDocumentClause"
                 priority="101"
                 mode="M246">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ContractualDocumentClause' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M246"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M246"/>
   <xsl:template match="@*|node()" priority="-2" mode="M246">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M246"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M246"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerOrderReferencedDocument/ram:CopyIndicator"
                 priority="101"
                 mode="M247">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:CopyIndicator' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M247"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M247"/>
   <xsl:template match="@*|node()" priority="-2" mode="M247">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M247"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M247"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerOrderReferencedDocument/ram:CopyIssuedQuantity"
                 priority="101"
                 mode="M248">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:CopyIssuedQuantity' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M248"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M248"/>
   <xsl:template match="@*|node()" priority="-2" mode="M248">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M248"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M248"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerOrderReferencedDocument/ram:CopyRequiredQuantity"
                 priority="101"
                 mode="M249">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:CopyRequiredQuantity' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M249"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M249"/>
   <xsl:template match="@*|node()" priority="-2" mode="M249">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M249"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M249"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerOrderReferencedDocument/ram:CreationDateTime"
                 priority="101"
                 mode="M250">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:CreationDateTime' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M250"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M250"/>
   <xsl:template match="@*|node()" priority="-2" mode="M250">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M250"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M250"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerOrderReferencedDocument/ram:EffectiveSpecifiedPeriod"
                 priority="101"
                 mode="M251">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:EffectiveSpecifiedPeriod' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M251"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M251"/>
   <xsl:template match="@*|node()" priority="-2" mode="M251">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M251"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M251"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerOrderReferencedDocument/ram:ElectronicPresentationIndicator"
                 priority="101"
                 mode="M252">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ElectronicPresentationIndicator' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M252"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M252"/>
   <xsl:template match="@*|node()" priority="-2" mode="M252">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M252"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M252"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerOrderReferencedDocument/ram:GlobalID"
                 priority="101"
                 mode="M253">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:GlobalID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M253"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M253"/>
   <xsl:template match="@*|node()" priority="-2" mode="M253">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M253"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M253"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerOrderReferencedDocument/ram:ID[@schemeAgencyID]"
                 priority="101"
                 mode="M254">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeAgencyID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M254"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M254"/>
   <xsl:template match="@*|node()" priority="-2" mode="M254">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M254"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M254"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerOrderReferencedDocument/ram:ID[@schemeAgencyName]"
                 priority="101"
                 mode="M255">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeAgencyName' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M255"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M255"/>
   <xsl:template match="@*|node()" priority="-2" mode="M255">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M255"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M255"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerOrderReferencedDocument/ram:ID[@schemeDataURI]"
                 priority="101"
                 mode="M256">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeDataURI' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M256"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M256"/>
   <xsl:template match="@*|node()" priority="-2" mode="M256">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M256"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M256"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerOrderReferencedDocument/ram:ID[@schemeID]"
                 priority="101"
                 mode="M257">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M257"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M257"/>
   <xsl:template match="@*|node()" priority="-2" mode="M257">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M257"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M257"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerOrderReferencedDocument/ram:ID[@schemeName]"
                 priority="101"
                 mode="M258">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeName' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M258"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M258"/>
   <xsl:template match="@*|node()" priority="-2" mode="M258">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M258"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M258"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerOrderReferencedDocument/ram:ID[@schemeURI]"
                 priority="101"
                 mode="M259">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeURI' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M259"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M259"/>
   <xsl:template match="@*|node()" priority="-2" mode="M259">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M259"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M259"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerOrderReferencedDocument/ram:ID[@schemeVersionID]"
                 priority="101"
                 mode="M260">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeVersionID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M260"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M260"/>
   <xsl:template match="@*|node()" priority="-2" mode="M260">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M260"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M260"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerOrderReferencedDocument/ram:Information"
                 priority="101"
                 mode="M261">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:Information' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M261"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M261"/>
   <xsl:template match="@*|node()" priority="-2" mode="M261">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M261"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M261"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerOrderReferencedDocument/ram:IssueLogisticsLocation"
                 priority="101"
                 mode="M262">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:IssueLogisticsLocation' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M262"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M262"/>
   <xsl:template match="@*|node()" priority="-2" mode="M262">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M262"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M262"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerOrderReferencedDocument/ram:IssuerAssignedID"
                 priority="101"
                 mode="M263">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:IssuerAssignedID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M263"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M263"/>
   <xsl:template match="@*|node()" priority="-2" mode="M263">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M263"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M263"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerOrderReferencedDocument/ram:IssuerTradeParty"
                 priority="101"
                 mode="M264">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:IssuerTradeParty' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M264"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M264"/>
   <xsl:template match="@*|node()" priority="-2" mode="M264">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M264"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M264"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerOrderReferencedDocument/ram:ItemIdentificationID"
                 priority="101"
                 mode="M265">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ItemIdentificationID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M265"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M265"/>
   <xsl:template match="@*|node()" priority="-2" mode="M265">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M265"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M265"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerOrderReferencedDocument/ram:LanguageID"
                 priority="101"
                 mode="M266">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:LanguageID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M266"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M266"/>
   <xsl:template match="@*|node()" priority="-2" mode="M266">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M266"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M266"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerOrderReferencedDocument/ram:LineID"
                 priority="101"
                 mode="M267">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:LineID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M267"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M267"/>
   <xsl:template match="@*|node()" priority="-2" mode="M267">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M267"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M267"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerOrderReferencedDocument/ram:LineItemQuantity"
                 priority="101"
                 mode="M268">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:LineItemQuantity' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M268"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M268"/>
   <xsl:template match="@*|node()" priority="-2" mode="M268">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M268"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M268"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerOrderReferencedDocument/ram:LineStatusCode"
                 priority="101"
                 mode="M269">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:LineStatusCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M269"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M269"/>
   <xsl:template match="@*|node()" priority="-2" mode="M269">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M269"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M269"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerOrderReferencedDocument/ram:LodgementLogisticsLocation"
                 priority="101"
                 mode="M270">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:LodgementLogisticsLocation' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M270"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M270"/>
   <xsl:template match="@*|node()" priority="-2" mode="M270">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M270"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M270"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerOrderReferencedDocument/ram:Name"
                 priority="101"
                 mode="M271">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:Name' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M271"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M271"/>
   <xsl:template match="@*|node()" priority="-2" mode="M271">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M271"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M271"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerOrderReferencedDocument/ram:OriginalIssuedQuantity"
                 priority="101"
                 mode="M272">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:OriginalIssuedQuantity' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M272"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M272"/>
   <xsl:template match="@*|node()" priority="-2" mode="M272">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M272"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M272"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerOrderReferencedDocument/ram:OriginalRequiredQuantity"
                 priority="101"
                 mode="M273">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:OriginalRequiredQuantity' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M273"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M273"/>
   <xsl:template match="@*|node()" priority="-2" mode="M273">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M273"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M273"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerOrderReferencedDocument/ram:PreviousRevisionID"
                 priority="101"
                 mode="M274">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:PreviousRevisionID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M274"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M274"/>
   <xsl:template match="@*|node()" priority="-2" mode="M274">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M274"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M274"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerOrderReferencedDocument/ram:PurposeCode"
                 priority="101"
                 mode="M275">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:PurposeCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M275"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M275"/>
   <xsl:template match="@*|node()" priority="-2" mode="M275">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M275"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M275"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerOrderReferencedDocument/ram:ReceiptDateTime"
                 priority="101"
                 mode="M276">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ReceiptDateTime' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M276"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M276"/>
   <xsl:template match="@*|node()" priority="-2" mode="M276">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M276"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M276"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerOrderReferencedDocument/ram:RecipientTradeParty"
                 priority="101"
                 mode="M277">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:RecipientTradeParty' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M277"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M277"/>
   <xsl:template match="@*|node()" priority="-2" mode="M277">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M277"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M277"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerOrderReferencedDocument/ram:ReferenceTypeCode"
                 priority="101"
                 mode="M278">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ReferenceTypeCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M278"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M278"/>
   <xsl:template match="@*|node()" priority="-2" mode="M278">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M278"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M278"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerOrderReferencedDocument/ram:RelationshipTypeCode"
                 priority="101"
                 mode="M279">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:RelationshipTypeCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M279"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M279"/>
   <xsl:template match="@*|node()" priority="-2" mode="M279">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M279"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M279"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerOrderReferencedDocument/ram:Remarks"
                 priority="101"
                 mode="M280">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:Remarks' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M280"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M280"/>
   <xsl:template match="@*|node()" priority="-2" mode="M280">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M280"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M280"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerOrderReferencedDocument/ram:Revision"
                 priority="101"
                 mode="M281">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:Revision' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M281"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M281"/>
   <xsl:template match="@*|node()" priority="-2" mode="M281">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M281"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M281"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerOrderReferencedDocument/ram:RevisionDateTime"
                 priority="101"
                 mode="M282">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:RevisionDateTime' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M282"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M282"/>
   <xsl:template match="@*|node()" priority="-2" mode="M282">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M282"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M282"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerOrderReferencedDocument/ram:RevisionID"
                 priority="101"
                 mode="M283">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:RevisionID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M283"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M283"/>
   <xsl:template match="@*|node()" priority="-2" mode="M283">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M283"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M283"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerOrderReferencedDocument/ram:SectionName"
                 priority="101"
                 mode="M284">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:SectionName' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M284"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M284"/>
   <xsl:template match="@*|node()" priority="-2" mode="M284">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M284"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M284"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerOrderReferencedDocument/ram:SignatoryDocumentAuthentication"
                 priority="101"
                 mode="M285">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:SignatoryDocumentAuthentication' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M285"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M285"/>
   <xsl:template match="@*|node()" priority="-2" mode="M285">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M285"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M285"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerOrderReferencedDocument/ram:StatusCode"
                 priority="101"
                 mode="M286">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:StatusCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M286"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M286"/>
   <xsl:template match="@*|node()" priority="-2" mode="M286">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M286"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M286"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerOrderReferencedDocument/ram:SubordinateLineID"
                 priority="101"
                 mode="M287">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:SubordinateLineID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M287"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M287"/>
   <xsl:template match="@*|node()" priority="-2" mode="M287">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M287"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M287"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerOrderReferencedDocument/ram:TypeCode"
                 priority="101"
                 mode="M288">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:TypeCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M288"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M288"/>
   <xsl:template match="@*|node()" priority="-2" mode="M288">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M288"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M288"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerOrderReferencedDocument/ram:URIID"
                 priority="101"
                 mode="M289">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:URIID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M289"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M289"/>
   <xsl:template match="@*|node()" priority="-2" mode="M289">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M289"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M289"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerReference[@languageID]"
                 priority="101"
                 mode="M290">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @languageID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M290"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M290"/>
   <xsl:template match="@*|node()" priority="-2" mode="M290">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M290"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M290"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerReference[@languageLocaleID]"
                 priority="101"
                 mode="M291">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @languageLocaleID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M291"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M291"/>
   <xsl:template match="@*|node()" priority="-2" mode="M291">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M291"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M291"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerRequisitionerTradeParty"
                 priority="101"
                 mode="M292">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:BuyerRequisitionerTradeParty' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M292"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M292"/>
   <xsl:template match="@*|node()" priority="-2" mode="M292">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M292"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M292"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTaxRepresentativeTradeParty"
                 priority="101"
                 mode="M293">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:BuyerTaxRepresentativeTradeParty' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M293"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M293"/>
   <xsl:template match="@*|node()" priority="-2" mode="M293">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M293"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M293"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty"
                 priority="101"
                 mode="M294">

		<!--ASSERT -->
      <xsl:choose>
         <xsl:when test="count(ram:ID)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text> Element 'ram:ID' may occur at maximum 1 times.</xsl:text>
            </xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
      <xsl:choose>
         <xsl:when test="count(ram:Name)=1"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text> Element 'ram:Name' must occur exactly 1 times.</xsl:text>
            </xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
      <xsl:choose>
         <xsl:when test="count(ram:DefinedTradeContact)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text> Element 'ram:DefinedTradeContact' may occur at maximum 1 times.</xsl:text>
            </xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M294"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M294"/>
   <xsl:template match="@*|node()" priority="-2" mode="M294">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M294"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M294"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:ApplicableLogisticsServiceCharge"
                 priority="101"
                 mode="M295">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ApplicableLogisticsServiceCharge' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M295"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M295"/>
   <xsl:template match="@*|node()" priority="-2" mode="M295">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M295"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M295"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:AssociatedTradeParty"
                 priority="101"
                 mode="M296">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:AssociatedTradeParty' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M296"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M296"/>
   <xsl:template match="@*|node()" priority="-2" mode="M296">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M296"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M296"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:AttentionOfAssociatedTradeParty"
                 priority="101"
                 mode="M297">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:AttentionOfAssociatedTradeParty' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M297"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M297"/>
   <xsl:template match="@*|node()" priority="-2" mode="M297">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M297"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M297"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:BuyerAssignedID"
                 priority="101"
                 mode="M298">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:BuyerAssignedID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M298"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M298"/>
   <xsl:template match="@*|node()" priority="-2" mode="M298">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M298"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M298"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:CAGEID"
                 priority="101"
                 mode="M299">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:CAGEID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M299"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M299"/>
   <xsl:template match="@*|node()" priority="-2" mode="M299">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M299"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M299"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DODAACID"
                 priority="101"
                 mode="M300">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:DODAACID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M300"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M300"/>
   <xsl:template match="@*|node()" priority="-2" mode="M300">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M300"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M300"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DUNSID"
                 priority="101"
                 mode="M301">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:DUNSID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M301"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M301"/>
   <xsl:template match="@*|node()" priority="-2" mode="M301">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M301"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M301"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact"
                 priority="101"
                 mode="M302">

		<!--ASSERT -->
      <xsl:choose>
         <xsl:when test="count(ram:TelephoneUniversalCommunication)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text> Element 'ram:TelephoneUniversalCommunication' may occur at maximum 1 times.</xsl:text>
            </xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
      <xsl:choose>
         <xsl:when test="count(ram:FaxUniversalCommunication)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text> Element 'ram:FaxUniversalCommunication' may occur at maximum 1 times.</xsl:text>
            </xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M302"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M302"/>
   <xsl:template match="@*|node()" priority="-2" mode="M302">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M302"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M302"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:DepartmentName[@languageID]"
                 priority="101"
                 mode="M303">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @languageID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M303"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M303"/>
   <xsl:template match="@*|node()" priority="-2" mode="M303">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M303"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M303"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:DepartmentName[@languageLocaleID]"
                 priority="101"
                 mode="M304">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @languageLocaleID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M304"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M304"/>
   <xsl:template match="@*|node()" priority="-2" mode="M304">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M304"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M304"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:DirectTelephoneUniversalCommunication"
                 priority="101"
                 mode="M305">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:DirectTelephoneUniversalCommunication' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M305"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M305"/>
   <xsl:template match="@*|node()" priority="-2" mode="M305">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M305"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M305"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:EDIUniversalCommunication"
                 priority="101"
                 mode="M306">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:EDIUniversalCommunication' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M306"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M306"/>
   <xsl:template match="@*|node()" priority="-2" mode="M306">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M306"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M306"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:EmailURIUniversalCommunication"
                 priority="101"
                 mode="M307">

		<!--ASSERT -->
      <xsl:choose>
         <xsl:when test="count(ram:URIID)=1"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text> Element 'ram:URIID' must occur exactly 1 times.</xsl:text>
            </xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M307"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M307"/>
   <xsl:template match="@*|node()" priority="-2" mode="M307">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M307"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M307"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:EmailURIUniversalCommunication/ram:Access"
                 priority="101"
                 mode="M308">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:Access' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M308"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M308"/>
   <xsl:template match="@*|node()" priority="-2" mode="M308">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M308"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M308"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:EmailURIUniversalCommunication/ram:AreaNumberCode"
                 priority="101"
                 mode="M309">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:AreaNumberCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M309"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M309"/>
   <xsl:template match="@*|node()" priority="-2" mode="M309">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M309"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M309"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:EmailURIUniversalCommunication/ram:ChannelCode"
                 priority="101"
                 mode="M310">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ChannelCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M310"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M310"/>
   <xsl:template match="@*|node()" priority="-2" mode="M310">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M310"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M310"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:EmailURIUniversalCommunication/ram:CompleteNumber"
                 priority="101"
                 mode="M311">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:CompleteNumber' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M311"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M311"/>
   <xsl:template match="@*|node()" priority="-2" mode="M311">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M311"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M311"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:EmailURIUniversalCommunication/ram:CountryNumberCode"
                 priority="101"
                 mode="M312">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:CountryNumberCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M312"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M312"/>
   <xsl:template match="@*|node()" priority="-2" mode="M312">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M312"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M312"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:EmailURIUniversalCommunication/ram:ExtensionNumber"
                 priority="101"
                 mode="M313">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ExtensionNumber' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M313"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M313"/>
   <xsl:template match="@*|node()" priority="-2" mode="M313">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M313"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M313"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:EmailURIUniversalCommunication/ram:HTMLPreferredIndicator"
                 priority="101"
                 mode="M314">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:HTMLPreferredIndicator' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M314"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M314"/>
   <xsl:template match="@*|node()" priority="-2" mode="M314">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M314"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M314"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:EmailURIUniversalCommunication/ram:LocalNumber"
                 priority="101"
                 mode="M315">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:LocalNumber' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M315"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M315"/>
   <xsl:template match="@*|node()" priority="-2" mode="M315">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M315"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M315"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:EmailURIUniversalCommunication/ram:URIID[@schemeAgencyID]"
                 priority="101"
                 mode="M316">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeAgencyID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M316"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M316"/>
   <xsl:template match="@*|node()" priority="-2" mode="M316">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M316"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M316"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:EmailURIUniversalCommunication/ram:URIID[@schemeAgencyName]"
                 priority="101"
                 mode="M317">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeAgencyName' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M317"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M317"/>
   <xsl:template match="@*|node()" priority="-2" mode="M317">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M317"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M317"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:EmailURIUniversalCommunication/ram:URIID[@schemeDataURI]"
                 priority="101"
                 mode="M318">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeDataURI' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M318"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M318"/>
   <xsl:template match="@*|node()" priority="-2" mode="M318">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M318"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M318"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:EmailURIUniversalCommunication/ram:URIID[@schemeID]"
                 priority="101"
                 mode="M319">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M319"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M319"/>
   <xsl:template match="@*|node()" priority="-2" mode="M319">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M319"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M319"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:EmailURIUniversalCommunication/ram:URIID[@schemeName]"
                 priority="101"
                 mode="M320">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeName' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M320"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M320"/>
   <xsl:template match="@*|node()" priority="-2" mode="M320">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M320"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M320"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:EmailURIUniversalCommunication/ram:URIID[@schemeURI]"
                 priority="101"
                 mode="M321">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeURI' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M321"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M321"/>
   <xsl:template match="@*|node()" priority="-2" mode="M321">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M321"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M321"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:EmailURIUniversalCommunication/ram:URIID[@schemeVersionID]"
                 priority="101"
                 mode="M322">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeVersionID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M322"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M322"/>
   <xsl:template match="@*|node()" priority="-2" mode="M322">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M322"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M322"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:EmailURIUniversalCommunication/ram:UseCode"
                 priority="101"
                 mode="M323">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:UseCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M323"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M323"/>
   <xsl:template match="@*|node()" priority="-2" mode="M323">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M323"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M323"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:FaxUniversalCommunication"
                 priority="101"
                 mode="M324">

		<!--ASSERT -->
      <xsl:choose>
         <xsl:when test="count(ram:CompleteNumber)=1"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text> Element 'ram:CompleteNumber' must occur exactly 1 times.</xsl:text>
            </xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M324"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M324"/>
   <xsl:template match="@*|node()" priority="-2" mode="M324">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M324"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M324"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:FaxUniversalCommunication/ram:Access"
                 priority="101"
                 mode="M325">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:Access' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M325"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M325"/>
   <xsl:template match="@*|node()" priority="-2" mode="M325">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M325"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M325"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:FaxUniversalCommunication/ram:AreaNumberCode"
                 priority="101"
                 mode="M326">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:AreaNumberCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M326"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M326"/>
   <xsl:template match="@*|node()" priority="-2" mode="M326">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M326"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M326"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:FaxUniversalCommunication/ram:ChannelCode"
                 priority="101"
                 mode="M327">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ChannelCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M327"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M327"/>
   <xsl:template match="@*|node()" priority="-2" mode="M327">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M327"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M327"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:FaxUniversalCommunication/ram:CompleteNumber[@languageID]"
                 priority="101"
                 mode="M328">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @languageID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M328"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M328"/>
   <xsl:template match="@*|node()" priority="-2" mode="M328">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M328"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M328"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:FaxUniversalCommunication/ram:CompleteNumber[@languageLocaleID]"
                 priority="101"
                 mode="M329">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @languageLocaleID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M329"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M329"/>
   <xsl:template match="@*|node()" priority="-2" mode="M329">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M329"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M329"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:FaxUniversalCommunication/ram:CountryNumberCode"
                 priority="101"
                 mode="M330">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:CountryNumberCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M330"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M330"/>
   <xsl:template match="@*|node()" priority="-2" mode="M330">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M330"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M330"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:FaxUniversalCommunication/ram:ExtensionNumber"
                 priority="101"
                 mode="M331">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ExtensionNumber' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M331"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M331"/>
   <xsl:template match="@*|node()" priority="-2" mode="M331">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M331"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M331"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:FaxUniversalCommunication/ram:HTMLPreferredIndicator"
                 priority="101"
                 mode="M332">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:HTMLPreferredIndicator' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M332"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M332"/>
   <xsl:template match="@*|node()" priority="-2" mode="M332">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M332"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M332"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:FaxUniversalCommunication/ram:LocalNumber"
                 priority="101"
                 mode="M333">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:LocalNumber' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M333"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M333"/>
   <xsl:template match="@*|node()" priority="-2" mode="M333">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M333"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M333"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:FaxUniversalCommunication/ram:URIID"
                 priority="101"
                 mode="M334">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:URIID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M334"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M334"/>
   <xsl:template match="@*|node()" priority="-2" mode="M334">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M334"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M334"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:FaxUniversalCommunication/ram:UseCode"
                 priority="101"
                 mode="M335">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:UseCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M335"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M335"/>
   <xsl:template match="@*|node()" priority="-2" mode="M335">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M335"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M335"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:ID"
                 priority="101"
                 mode="M336">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M336"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M336"/>
   <xsl:template match="@*|node()" priority="-2" mode="M336">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M336"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M336"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:InstantMessagingUniversalCommunication"
                 priority="101"
                 mode="M337">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:InstantMessagingUniversalCommunication' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M337"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M337"/>
   <xsl:template match="@*|node()" priority="-2" mode="M337">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M337"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M337"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:JobTitle"
                 priority="101"
                 mode="M338">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:JobTitle' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M338"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M338"/>
   <xsl:template match="@*|node()" priority="-2" mode="M338">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M338"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M338"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:MobileTelephoneUniversalCommunication"
                 priority="101"
                 mode="M339">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:MobileTelephoneUniversalCommunication' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M339"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M339"/>
   <xsl:template match="@*|node()" priority="-2" mode="M339">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M339"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M339"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:PersonID"
                 priority="101"
                 mode="M340">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:PersonID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M340"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M340"/>
   <xsl:template match="@*|node()" priority="-2" mode="M340">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M340"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M340"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:PersonName[@languageID]"
                 priority="101"
                 mode="M341">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @languageID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M341"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M341"/>
   <xsl:template match="@*|node()" priority="-2" mode="M341">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M341"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M341"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:PersonName[@languageLocaleID]"
                 priority="101"
                 mode="M342">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @languageLocaleID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M342"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M342"/>
   <xsl:template match="@*|node()" priority="-2" mode="M342">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M342"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M342"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:Responsibility"
                 priority="101"
                 mode="M343">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:Responsibility' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M343"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M343"/>
   <xsl:template match="@*|node()" priority="-2" mode="M343">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M343"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M343"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:SpecifiedContactPerson"
                 priority="101"
                 mode="M344">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:SpecifiedContactPerson' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M344"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M344"/>
   <xsl:template match="@*|node()" priority="-2" mode="M344">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M344"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M344"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:SpecifiedNote"
                 priority="101"
                 mode="M345">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:SpecifiedNote' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M345"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M345"/>
   <xsl:template match="@*|node()" priority="-2" mode="M345">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M345"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M345"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:TelephoneUniversalCommunication"
                 priority="101"
                 mode="M346">

		<!--ASSERT -->
      <xsl:choose>
         <xsl:when test="count(ram:CompleteNumber)=1"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text> Element 'ram:CompleteNumber' must occur exactly 1 times.</xsl:text>
            </xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M346"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M346"/>
   <xsl:template match="@*|node()" priority="-2" mode="M346">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M346"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M346"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:TelephoneUniversalCommunication/ram:Access"
                 priority="101"
                 mode="M347">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:Access' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M347"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M347"/>
   <xsl:template match="@*|node()" priority="-2" mode="M347">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M347"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M347"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:TelephoneUniversalCommunication/ram:AreaNumberCode"
                 priority="101"
                 mode="M348">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:AreaNumberCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M348"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M348"/>
   <xsl:template match="@*|node()" priority="-2" mode="M348">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M348"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M348"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:TelephoneUniversalCommunication/ram:ChannelCode"
                 priority="101"
                 mode="M349">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ChannelCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M349"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M349"/>
   <xsl:template match="@*|node()" priority="-2" mode="M349">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M349"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M349"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:TelephoneUniversalCommunication/ram:CompleteNumber[@languageID]"
                 priority="101"
                 mode="M350">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @languageID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M350"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M350"/>
   <xsl:template match="@*|node()" priority="-2" mode="M350">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M350"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M350"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:TelephoneUniversalCommunication/ram:CompleteNumber[@languageLocaleID]"
                 priority="101"
                 mode="M351">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @languageLocaleID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M351"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M351"/>
   <xsl:template match="@*|node()" priority="-2" mode="M351">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M351"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M351"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:TelephoneUniversalCommunication/ram:CountryNumberCode"
                 priority="101"
                 mode="M352">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:CountryNumberCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M352"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M352"/>
   <xsl:template match="@*|node()" priority="-2" mode="M352">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M352"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M352"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:TelephoneUniversalCommunication/ram:ExtensionNumber"
                 priority="101"
                 mode="M353">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ExtensionNumber' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M353"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M353"/>
   <xsl:template match="@*|node()" priority="-2" mode="M353">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M353"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M353"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:TelephoneUniversalCommunication/ram:HTMLPreferredIndicator"
                 priority="101"
                 mode="M354">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:HTMLPreferredIndicator' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M354"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M354"/>
   <xsl:template match="@*|node()" priority="-2" mode="M354">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M354"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M354"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:TelephoneUniversalCommunication/ram:LocalNumber"
                 priority="101"
                 mode="M355">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:LocalNumber' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M355"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M355"/>
   <xsl:template match="@*|node()" priority="-2" mode="M355">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M355"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M355"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:TelephoneUniversalCommunication/ram:URIID"
                 priority="101"
                 mode="M356">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:URIID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M356"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M356"/>
   <xsl:template match="@*|node()" priority="-2" mode="M356">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M356"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M356"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:TelephoneUniversalCommunication/ram:UseCode"
                 priority="101"
                 mode="M357">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:UseCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M357"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M357"/>
   <xsl:template match="@*|node()" priority="-2" mode="M357">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M357"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M357"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:TelexUniversalCommunication"
                 priority="101"
                 mode="M358">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:TelexUniversalCommunication' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M358"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M358"/>
   <xsl:template match="@*|node()" priority="-2" mode="M358">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M358"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M358"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:TypeCode"
                 priority="101"
                 mode="M359">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:TypeCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M359"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M359"/>
   <xsl:template match="@*|node()" priority="-2" mode="M359">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M359"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M359"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:URIUniversalCommunication"
                 priority="101"
                 mode="M360">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:URIUniversalCommunication' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M360"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M360"/>
   <xsl:template match="@*|node()" priority="-2" mode="M360">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M360"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M360"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:VOIPUniversalCommunication"
                 priority="101"
                 mode="M361">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:VOIPUniversalCommunication' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M361"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M361"/>
   <xsl:template match="@*|node()" priority="-2" mode="M361">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M361"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M361"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:Description"
                 priority="101"
                 mode="M362">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:Description' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M362"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M362"/>
   <xsl:template match="@*|node()" priority="-2" mode="M362">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M362"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M362"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:EmailURIUniversalCommunication"
                 priority="101"
                 mode="M363">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:EmailURIUniversalCommunication' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M363"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M363"/>
   <xsl:template match="@*|node()" priority="-2" mode="M363">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M363"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M363"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:EndPointURIUniversalCommunication"
                 priority="101"
                 mode="M364">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:EndPointURIUniversalCommunication' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M364"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M364"/>
   <xsl:template match="@*|node()" priority="-2" mode="M364">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M364"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M364"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:FaxUniversalCommunication"
                 priority="101"
                 mode="M365">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:FaxUniversalCommunication' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M365"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M365"/>
   <xsl:template match="@*|node()" priority="-2" mode="M365">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M365"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M365"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:GLNID"
                 priority="101"
                 mode="M366">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:GLNID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M366"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M366"/>
   <xsl:template match="@*|node()" priority="-2" mode="M366">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M366"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M366"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:GlobalID"
                 priority="101"
                 mode="M367">

		<!--ASSERT -->
      <xsl:choose>
         <xsl:when test="@schemeID"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text> Attribute '@schemeID' is required in this context.</xsl:text>
            </xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M367"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M367"/>
   <xsl:template match="@*|node()" priority="-2" mode="M367">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M367"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M367"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:GlobalID[@schemeAgencyID]"
                 priority="101"
                 mode="M368">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeAgencyID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M368"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M368"/>
   <xsl:template match="@*|node()" priority="-2" mode="M368">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M368"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M368"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:GlobalID[@schemeAgencyName]"
                 priority="101"
                 mode="M369">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeAgencyName' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M369"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M369"/>
   <xsl:template match="@*|node()" priority="-2" mode="M369">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M369"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M369"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:GlobalID[@schemeDataURI]"
                 priority="101"
                 mode="M370">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeDataURI' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M370"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M370"/>
   <xsl:template match="@*|node()" priority="-2" mode="M370">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M370"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M370"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:GlobalID[@schemeName]"
                 priority="101"
                 mode="M371">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeName' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M371"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M371"/>
   <xsl:template match="@*|node()" priority="-2" mode="M371">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M371"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M371"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:GlobalID[@schemeURI]"
                 priority="101"
                 mode="M372">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeURI' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M372"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M372"/>
   <xsl:template match="@*|node()" priority="-2" mode="M372">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M372"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M372"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:GlobalID[@schemeVersionID]"
                 priority="101"
                 mode="M373">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeVersionID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M373"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M373"/>
   <xsl:template match="@*|node()" priority="-2" mode="M373">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M373"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M373"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:ID[@schemeAgencyID]"
                 priority="101"
                 mode="M374">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeAgencyID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M374"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M374"/>
   <xsl:template match="@*|node()" priority="-2" mode="M374">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M374"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M374"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:ID[@schemeAgencyName]"
                 priority="101"
                 mode="M375">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeAgencyName' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M375"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M375"/>
   <xsl:template match="@*|node()" priority="-2" mode="M375">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M375"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M375"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:ID[@schemeDataURI]"
                 priority="101"
                 mode="M376">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeDataURI' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M376"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M376"/>
   <xsl:template match="@*|node()" priority="-2" mode="M376">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M376"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M376"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:ID[@schemeID]"
                 priority="101"
                 mode="M377">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M377"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M377"/>
   <xsl:template match="@*|node()" priority="-2" mode="M377">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M377"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M377"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:ID[@schemeName]"
                 priority="101"
                 mode="M378">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeName' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M378"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M378"/>
   <xsl:template match="@*|node()" priority="-2" mode="M378">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M378"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M378"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:ID[@schemeURI]"
                 priority="101"
                 mode="M379">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeURI' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M379"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M379"/>
   <xsl:template match="@*|node()" priority="-2" mode="M379">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M379"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M379"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:ID[@schemeVersionID]"
                 priority="101"
                 mode="M380">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeVersionID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M380"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M380"/>
   <xsl:template match="@*|node()" priority="-2" mode="M380">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M380"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M380"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:IssuedNotificationReferencedDocument"
                 priority="101"
                 mode="M381">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:IssuedNotificationReferencedDocument' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M381"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M381"/>
   <xsl:template match="@*|node()" priority="-2" mode="M381">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M381"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M381"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:LanguageCode"
                 priority="101"
                 mode="M382">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:LanguageCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M382"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M382"/>
   <xsl:template match="@*|node()" priority="-2" mode="M382">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M382"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M382"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:LogoAssociatedSpecifiedBinaryFile"
                 priority="101"
                 mode="M383">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:LogoAssociatedSpecifiedBinaryFile' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M383"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M383"/>
   <xsl:template match="@*|node()" priority="-2" mode="M383">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M383"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M383"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:LogoReferencedDocument"
                 priority="101"
                 mode="M384">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:LogoReferencedDocument' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M384"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M384"/>
   <xsl:template match="@*|node()" priority="-2" mode="M384">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M384"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M384"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:Name[@languageID]"
                 priority="101"
                 mode="M385">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @languageID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M385"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M385"/>
   <xsl:template match="@*|node()" priority="-2" mode="M385">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M385"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M385"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:Name[@languageLocaleID]"
                 priority="101"
                 mode="M386">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @languageLocaleID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M386"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M386"/>
   <xsl:template match="@*|node()" priority="-2" mode="M386">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M386"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M386"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:PostalTradeAddress"
                 priority="101"
                 mode="M387">

		<!--ASSERT -->
      <xsl:choose>
         <xsl:when test="count(ram:PostcodeCode)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text> Element 'ram:PostcodeCode' may occur at maximum 1 times.</xsl:text>
            </xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M387"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M387"/>
   <xsl:template match="@*|node()" priority="-2" mode="M387">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M387"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M387"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:PostalTradeAddress/ram:AdditionalStreetName"
                 priority="101"
                 mode="M388">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:AdditionalStreetName' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M388"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M388"/>
   <xsl:template match="@*|node()" priority="-2" mode="M388">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M388"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M388"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:PostalTradeAddress/ram:AttentionOf"
                 priority="101"
                 mode="M389">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:AttentionOf' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M389"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M389"/>
   <xsl:template match="@*|node()" priority="-2" mode="M389">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M389"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M389"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:PostalTradeAddress/ram:BuildingName"
                 priority="101"
                 mode="M390">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:BuildingName' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M390"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M390"/>
   <xsl:template match="@*|node()" priority="-2" mode="M390">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M390"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M390"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:PostalTradeAddress/ram:BuildingNumber"
                 priority="101"
                 mode="M391">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:BuildingNumber' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M391"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M391"/>
   <xsl:template match="@*|node()" priority="-2" mode="M391">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M391"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M391"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:PostalTradeAddress/ram:CareOf"
                 priority="101"
                 mode="M392">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:CareOf' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M392"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M392"/>
   <xsl:template match="@*|node()" priority="-2" mode="M392">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M392"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M392"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:PostalTradeAddress/ram:CityName[@languageID]"
                 priority="101"
                 mode="M393">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @languageID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M393"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M393"/>
   <xsl:template match="@*|node()" priority="-2" mode="M393">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M393"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M393"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:PostalTradeAddress/ram:CityName[@languageLocaleID]"
                 priority="101"
                 mode="M394">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @languageLocaleID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M394"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M394"/>
   <xsl:template match="@*|node()" priority="-2" mode="M394">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M394"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M394"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:PostalTradeAddress/ram:CitySubDivisionName"
                 priority="101"
                 mode="M395">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:CitySubDivisionName' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M395"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M395"/>
   <xsl:template match="@*|node()" priority="-2" mode="M395">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M395"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M395"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:PostalTradeAddress/ram:CountryID[@schemeAgencyID]"
                 priority="101"
                 mode="M396">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeAgencyID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M396"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M396"/>
   <xsl:template match="@*|node()" priority="-2" mode="M396">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M396"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M396"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:PostalTradeAddress/ram:CountryID[@schemeID]"
                 priority="101"
                 mode="M397">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M397"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M397"/>
   <xsl:template match="@*|node()" priority="-2" mode="M397">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M397"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M397"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:PostalTradeAddress/ram:CountryID[@schemeVersionID]"
                 priority="101"
                 mode="M398">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeVersionID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M398"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M398"/>
   <xsl:template match="@*|node()" priority="-2" mode="M398">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M398"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M398"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:PostalTradeAddress/ram:CountryIdentificationTradeCountry"
                 priority="101"
                 mode="M399">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:CountryIdentificationTradeCountry' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M399"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M399"/>
   <xsl:template match="@*|node()" priority="-2" mode="M399">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M399"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M399"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:PostalTradeAddress/ram:CountryName"
                 priority="101"
                 mode="M400">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:CountryName' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M400"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M400"/>
   <xsl:template match="@*|node()" priority="-2" mode="M400">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M400"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M400"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:PostalTradeAddress/ram:CountrySubDivisionID"
                 priority="101"
                 mode="M401">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:CountrySubDivisionID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M401"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M401"/>
   <xsl:template match="@*|node()" priority="-2" mode="M401">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M401"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M401"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:PostalTradeAddress/ram:CountrySubDivisionName"
                 priority="101"
                 mode="M402">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:CountrySubDivisionName' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M402"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M402"/>
   <xsl:template match="@*|node()" priority="-2" mode="M402">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M402"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M402"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:PostalTradeAddress/ram:DepartmentName"
                 priority="101"
                 mode="M403">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:DepartmentName' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M403"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M403"/>
   <xsl:template match="@*|node()" priority="-2" mode="M403">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M403"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M403"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:PostalTradeAddress/ram:FreeForm"
                 priority="101"
                 mode="M404">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:FreeForm' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M404"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M404"/>
   <xsl:template match="@*|node()" priority="-2" mode="M404">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M404"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M404"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:PostalTradeAddress/ram:GeoCoordinateIdentificationGeographicalCoordinate"
                 priority="101"
                 mode="M405">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:GeoCoordinateIdentificationGeographicalCoordinate' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M405"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M405"/>
   <xsl:template match="@*|node()" priority="-2" mode="M405">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M405"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M405"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:PostalTradeAddress/ram:ID"
                 priority="101"
                 mode="M406">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M406"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M406"/>
   <xsl:template match="@*|node()" priority="-2" mode="M406">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M406"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M406"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:PostalTradeAddress/ram:LineFive"
                 priority="101"
                 mode="M407">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:LineFive' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M407"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M407"/>
   <xsl:template match="@*|node()" priority="-2" mode="M407">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M407"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M407"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:PostalTradeAddress/ram:LineFour"
                 priority="101"
                 mode="M408">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:LineFour' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M408"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M408"/>
   <xsl:template match="@*|node()" priority="-2" mode="M408">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M408"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M408"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:PostalTradeAddress/ram:LineOne[@languageID]"
                 priority="101"
                 mode="M409">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @languageID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M409"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M409"/>
   <xsl:template match="@*|node()" priority="-2" mode="M409">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M409"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M409"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:PostalTradeAddress/ram:LineOne[@languageLocaleID]"
                 priority="101"
                 mode="M410">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @languageLocaleID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M410"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M410"/>
   <xsl:template match="@*|node()" priority="-2" mode="M410">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M410"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M410"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:PostalTradeAddress/ram:LineThree"
                 priority="101"
                 mode="M411">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:LineThree' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M411"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M411"/>
   <xsl:template match="@*|node()" priority="-2" mode="M411">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M411"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M411"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:PostalTradeAddress/ram:LineTwo[@languageID]"
                 priority="101"
                 mode="M412">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @languageID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M412"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M412"/>
   <xsl:template match="@*|node()" priority="-2" mode="M412">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M412"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M412"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:PostalTradeAddress/ram:LineTwo[@languageLocaleID]"
                 priority="101"
                 mode="M413">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @languageLocaleID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M413"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M413"/>
   <xsl:template match="@*|node()" priority="-2" mode="M413">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M413"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M413"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:PostalTradeAddress/ram:PostOfficeBox"
                 priority="101"
                 mode="M414">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:PostOfficeBox' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M414"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M414"/>
   <xsl:template match="@*|node()" priority="-2" mode="M414">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M414"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M414"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:PostalTradeAddress/ram:PostcodeCode[@languageID]"
                 priority="101"
                 mode="M415">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @languageID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M415"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M415"/>
   <xsl:template match="@*|node()" priority="-2" mode="M415">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M415"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M415"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:PostalTradeAddress/ram:PostcodeCode[@listAgencyID]"
                 priority="101"
                 mode="M416">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @listAgencyID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M416"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M416"/>
   <xsl:template match="@*|node()" priority="-2" mode="M416">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M416"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M416"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:PostalTradeAddress/ram:PostcodeCode[@listAgencyName]"
                 priority="101"
                 mode="M417">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @listAgencyName' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M417"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M417"/>
   <xsl:template match="@*|node()" priority="-2" mode="M417">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M417"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M417"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:PostalTradeAddress/ram:PostcodeCode[@listID]"
                 priority="101"
                 mode="M418">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @listID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M418"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M418"/>
   <xsl:template match="@*|node()" priority="-2" mode="M418">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M418"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M418"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:PostalTradeAddress/ram:PostcodeCode[@listName]"
                 priority="101"
                 mode="M419">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @listName' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M419"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M419"/>
   <xsl:template match="@*|node()" priority="-2" mode="M419">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M419"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M419"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:PostalTradeAddress/ram:PostcodeCode[@listSchemeURI]"
                 priority="101"
                 mode="M420">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @listSchemeURI' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M420"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M420"/>
   <xsl:template match="@*|node()" priority="-2" mode="M420">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M420"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M420"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:PostalTradeAddress/ram:PostcodeCode[@listURI]"
                 priority="101"
                 mode="M421">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @listURI' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M421"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M421"/>
   <xsl:template match="@*|node()" priority="-2" mode="M421">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M421"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M421"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:PostalTradeAddress/ram:PostcodeCode[@listVersionID]"
                 priority="101"
                 mode="M422">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @listVersionID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M422"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M422"/>
   <xsl:template match="@*|node()" priority="-2" mode="M422">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M422"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M422"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:PostalTradeAddress/ram:PostcodeCode[@name]"
                 priority="101"
                 mode="M423">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @name' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M423"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M423"/>
   <xsl:template match="@*|node()" priority="-2" mode="M423">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M423"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M423"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:PostalTradeAddress/ram:SecondaryPostcodeCode"
                 priority="101"
                 mode="M424">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:SecondaryPostcodeCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M424"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M424"/>
   <xsl:template match="@*|node()" priority="-2" mode="M424">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M424"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M424"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:PostalTradeAddress/ram:StreetName"
                 priority="101"
                 mode="M425">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:StreetName' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M425"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M425"/>
   <xsl:template match="@*|node()" priority="-2" mode="M425">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M425"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M425"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:PostalTradeAddress/ram:UTCOffsetNumeric"
                 priority="101"
                 mode="M426">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:UTCOffsetNumeric' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M426"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M426"/>
   <xsl:template match="@*|node()" priority="-2" mode="M426">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M426"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M426"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:ProvidedTransportService"
                 priority="101"
                 mode="M427">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ProvidedTransportService' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M427"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M427"/>
   <xsl:template match="@*|node()" priority="-2" mode="M427">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M427"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M427"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:QualityAssuranceIndicator"
                 priority="101"
                 mode="M428">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:QualityAssuranceIndicator' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M428"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M428"/>
   <xsl:template match="@*|node()" priority="-2" mode="M428">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M428"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M428"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:RICID"
                 priority="101"
                 mode="M429">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:RICID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M429"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M429"/>
   <xsl:template match="@*|node()" priority="-2" mode="M429">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M429"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M429"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:RequestedNotificationReferencedDocument"
                 priority="101"
                 mode="M430">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:RequestedNotificationReferencedDocument' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M430"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M430"/>
   <xsl:template match="@*|node()" priority="-2" mode="M430">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M430"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M430"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:RoleCode"
                 priority="101"
                 mode="M431">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:RoleCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M431"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M431"/>
   <xsl:template match="@*|node()" priority="-2" mode="M431">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M431"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M431"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:SellerAssignedID"
                 priority="101"
                 mode="M432">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:SellerAssignedID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M432"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M432"/>
   <xsl:template match="@*|node()" priority="-2" mode="M432">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M432"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M432"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:SpecifiedAuthoritativeSignatoryPerson"
                 priority="101"
                 mode="M433">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:SpecifiedAuthoritativeSignatoryPerson' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M433"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M433"/>
   <xsl:template match="@*|node()" priority="-2" mode="M433">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M433"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M433"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:SpecifiedLegalOrganization"
                 priority="101"
                 mode="M434">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:SpecifiedLegalOrganization' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M434"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M434"/>
   <xsl:template match="@*|node()" priority="-2" mode="M434">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M434"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M434"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:SpecifiedLogisticsLocation"
                 priority="101"
                 mode="M435">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:SpecifiedLogisticsLocation' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M435"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M435"/>
   <xsl:template match="@*|node()" priority="-2" mode="M435">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M435"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M435"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:SpecifiedRepresentativePerson"
                 priority="101"
                 mode="M436">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:SpecifiedRepresentativePerson' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M436"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M436"/>
   <xsl:template match="@*|node()" priority="-2" mode="M436">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M436"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M436"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:SpecifiedTaxRegistration/ram:AssociatedRegisteredTax"
                 priority="101"
                 mode="M437">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:AssociatedRegisteredTax' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M437"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M437"/>
   <xsl:template match="@*|node()" priority="-2" mode="M437">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M437"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M437"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:SpecifiedTaxRegistration/ram:ID"
                 priority="101"
                 mode="M438">

		<!--ASSERT -->
      <xsl:choose>
         <xsl:when test="@schemeID"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text> Attribute '@schemeID' is required in this context.</xsl:text>
            </xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M438"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M438"/>
   <xsl:template match="@*|node()" priority="-2" mode="M438">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M438"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M438"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:SpecifiedTaxRegistration/ram:ID[@schemeAgencyID]"
                 priority="101"
                 mode="M439">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeAgencyID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M439"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M439"/>
   <xsl:template match="@*|node()" priority="-2" mode="M439">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M439"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M439"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:SpecifiedTaxRegistration/ram:ID[@schemeAgencyName]"
                 priority="101"
                 mode="M440">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeAgencyName' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M440"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M440"/>
   <xsl:template match="@*|node()" priority="-2" mode="M440">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M440"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M440"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:SpecifiedTaxRegistration/ram:ID[@schemeDataURI]"
                 priority="101"
                 mode="M441">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeDataURI' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M441"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M441"/>
   <xsl:template match="@*|node()" priority="-2" mode="M441">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M441"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M441"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:SpecifiedTaxRegistration/ram:ID[@schemeName]"
                 priority="101"
                 mode="M442">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeName' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M442"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M442"/>
   <xsl:template match="@*|node()" priority="-2" mode="M442">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M442"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M442"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:SpecifiedTaxRegistration/ram:ID[@schemeURI]"
                 priority="101"
                 mode="M443">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeURI' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M443"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M443"/>
   <xsl:template match="@*|node()" priority="-2" mode="M443">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M443"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M443"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:SpecifiedTaxRegistration/ram:ID[@schemeVersionID]"
                 priority="101"
                 mode="M444">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeVersionID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M444"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M444"/>
   <xsl:template match="@*|node()" priority="-2" mode="M444">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M444"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M444"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:TelephoneUniversalCommunication"
                 priority="101"
                 mode="M445">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:TelephoneUniversalCommunication' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M445"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M445"/>
   <xsl:template match="@*|node()" priority="-2" mode="M445">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M445"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M445"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:TypeCode"
                 priority="101"
                 mode="M446">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:TypeCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M446"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M446"/>
   <xsl:template match="@*|node()" priority="-2" mode="M446">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M446"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M446"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:BuyerTradeParty/ram:URIUniversalCommunication"
                 priority="101"
                 mode="M447">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:URIUniversalCommunication' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M447"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M447"/>
   <xsl:template match="@*|node()" priority="-2" mode="M447">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M447"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M447"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CarrierTradeParty"
                 priority="101"
                 mode="M448">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:CarrierTradeParty' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M448"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M448"/>
   <xsl:template match="@*|node()" priority="-2" mode="M448">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M448"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M448"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CatalogueInformationProviderTradeParty"
                 priority="101"
                 mode="M449">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:CatalogueInformationProviderTradeParty' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M449"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M449"/>
   <xsl:template match="@*|node()" priority="-2" mode="M449">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M449"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M449"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CatalogueInformationReceiverTradeParty"
                 priority="101"
                 mode="M450">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:CatalogueInformationReceiverTradeParty' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M450"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M450"/>
   <xsl:template match="@*|node()" priority="-2" mode="M450">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M450"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M450"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CatalogueReferencedDocument"
                 priority="101"
                 mode="M451">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:CatalogueReferencedDocument' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M451"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M451"/>
   <xsl:template match="@*|node()" priority="-2" mode="M451">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M451"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M451"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CatalogueRequestReferencedDocument"
                 priority="101"
                 mode="M452">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:CatalogueRequestReferencedDocument' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M452"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M452"/>
   <xsl:template match="@*|node()" priority="-2" mode="M452">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M452"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M452"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CatalogueSubscriptionReferencedDocument"
                 priority="101"
                 mode="M453">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:CatalogueSubscriptionReferencedDocument' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M453"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M453"/>
   <xsl:template match="@*|node()" priority="-2" mode="M453">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M453"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M453"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ContractReferencedDocument"
                 priority="101"
                 mode="M454">

		<!--ASSERT -->
      <xsl:choose>
         <xsl:when test="count(ram:ID)=1"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text> Element 'ram:ID' must occur exactly 1 times.</xsl:text>
            </xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M454"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M454"/>
   <xsl:template match="@*|node()" priority="-2" mode="M454">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M454"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M454"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ContractReferencedDocument/ram:AcceptableSpecifiedPeriod"
                 priority="101"
                 mode="M455">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:AcceptableSpecifiedPeriod' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M455"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M455"/>
   <xsl:template match="@*|node()" priority="-2" mode="M455">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M455"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M455"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ContractReferencedDocument/ram:AcceptanceDateTime"
                 priority="101"
                 mode="M456">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:AcceptanceDateTime' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M456"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M456"/>
   <xsl:template match="@*|node()" priority="-2" mode="M456">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M456"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M456"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ContractReferencedDocument/ram:AmendmentPurposeCode"
                 priority="101"
                 mode="M457">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:AmendmentPurposeCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M457"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M457"/>
   <xsl:template match="@*|node()" priority="-2" mode="M457">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M457"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M457"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ContractReferencedDocument/ram:AttachedSpecifiedBinaryFile"
                 priority="101"
                 mode="M458">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:AttachedSpecifiedBinaryFile' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M458"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M458"/>
   <xsl:template match="@*|node()" priority="-2" mode="M458">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M458"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M458"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ContractReferencedDocument/ram:AttachmentBinaryObject"
                 priority="101"
                 mode="M459">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:AttachmentBinaryObject' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M459"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M459"/>
   <xsl:template match="@*|node()" priority="-2" mode="M459">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M459"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M459"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ContractReferencedDocument/ram:AuthenticatedOriginalIndicator"
                 priority="101"
                 mode="M460">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:AuthenticatedOriginalIndicator' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M460"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M460"/>
   <xsl:template match="@*|node()" priority="-2" mode="M460">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M460"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M460"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ContractReferencedDocument/ram:CategoryCode"
                 priority="101"
                 mode="M461">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:CategoryCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M461"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M461"/>
   <xsl:template match="@*|node()" priority="-2" mode="M461">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M461"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M461"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ContractReferencedDocument/ram:ChannelCode"
                 priority="101"
                 mode="M462">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ChannelCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M462"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M462"/>
   <xsl:template match="@*|node()" priority="-2" mode="M462">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M462"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M462"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ContractReferencedDocument/ram:ContractualDocumentClause"
                 priority="101"
                 mode="M463">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ContractualDocumentClause' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M463"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M463"/>
   <xsl:template match="@*|node()" priority="-2" mode="M463">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M463"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M463"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ContractReferencedDocument/ram:CopyIndicator"
                 priority="101"
                 mode="M464">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:CopyIndicator' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M464"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M464"/>
   <xsl:template match="@*|node()" priority="-2" mode="M464">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M464"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M464"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ContractReferencedDocument/ram:CopyIssuedQuantity"
                 priority="101"
                 mode="M465">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:CopyIssuedQuantity' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M465"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M465"/>
   <xsl:template match="@*|node()" priority="-2" mode="M465">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M465"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M465"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ContractReferencedDocument/ram:CopyRequiredQuantity"
                 priority="101"
                 mode="M466">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:CopyRequiredQuantity' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M466"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M466"/>
   <xsl:template match="@*|node()" priority="-2" mode="M466">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M466"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M466"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ContractReferencedDocument/ram:CreationDateTime"
                 priority="101"
                 mode="M467">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:CreationDateTime' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M467"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M467"/>
   <xsl:template match="@*|node()" priority="-2" mode="M467">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M467"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M467"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ContractReferencedDocument/ram:EffectiveSpecifiedPeriod"
                 priority="101"
                 mode="M468">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:EffectiveSpecifiedPeriod' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M468"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M468"/>
   <xsl:template match="@*|node()" priority="-2" mode="M468">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M468"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M468"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ContractReferencedDocument/ram:ElectronicPresentationIndicator"
                 priority="101"
                 mode="M469">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ElectronicPresentationIndicator' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M469"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M469"/>
   <xsl:template match="@*|node()" priority="-2" mode="M469">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M469"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M469"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ContractReferencedDocument/ram:GlobalID"
                 priority="101"
                 mode="M470">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:GlobalID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M470"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M470"/>
   <xsl:template match="@*|node()" priority="-2" mode="M470">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M470"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M470"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ContractReferencedDocument/ram:ID[@schemeAgencyID]"
                 priority="101"
                 mode="M471">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeAgencyID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M471"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M471"/>
   <xsl:template match="@*|node()" priority="-2" mode="M471">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M471"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M471"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ContractReferencedDocument/ram:ID[@schemeAgencyName]"
                 priority="101"
                 mode="M472">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeAgencyName' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M472"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M472"/>
   <xsl:template match="@*|node()" priority="-2" mode="M472">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M472"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M472"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ContractReferencedDocument/ram:ID[@schemeDataURI]"
                 priority="101"
                 mode="M473">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeDataURI' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M473"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M473"/>
   <xsl:template match="@*|node()" priority="-2" mode="M473">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M473"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M473"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ContractReferencedDocument/ram:ID[@schemeID]"
                 priority="101"
                 mode="M474">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M474"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M474"/>
   <xsl:template match="@*|node()" priority="-2" mode="M474">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M474"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M474"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ContractReferencedDocument/ram:ID[@schemeName]"
                 priority="101"
                 mode="M475">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeName' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M475"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M475"/>
   <xsl:template match="@*|node()" priority="-2" mode="M475">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M475"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M475"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ContractReferencedDocument/ram:ID[@schemeURI]"
                 priority="101"
                 mode="M476">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeURI' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M476"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M476"/>
   <xsl:template match="@*|node()" priority="-2" mode="M476">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M476"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M476"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ContractReferencedDocument/ram:ID[@schemeVersionID]"
                 priority="101"
                 mode="M477">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeVersionID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M477"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M477"/>
   <xsl:template match="@*|node()" priority="-2" mode="M477">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M477"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M477"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ContractReferencedDocument/ram:Information"
                 priority="101"
                 mode="M478">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:Information' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M478"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M478"/>
   <xsl:template match="@*|node()" priority="-2" mode="M478">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M478"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M478"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ContractReferencedDocument/ram:IssueLogisticsLocation"
                 priority="101"
                 mode="M479">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:IssueLogisticsLocation' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M479"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M479"/>
   <xsl:template match="@*|node()" priority="-2" mode="M479">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M479"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M479"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ContractReferencedDocument/ram:IssuerAssignedID"
                 priority="101"
                 mode="M480">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:IssuerAssignedID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M480"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M480"/>
   <xsl:template match="@*|node()" priority="-2" mode="M480">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M480"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M480"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ContractReferencedDocument/ram:IssuerTradeParty"
                 priority="101"
                 mode="M481">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:IssuerTradeParty' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M481"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M481"/>
   <xsl:template match="@*|node()" priority="-2" mode="M481">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M481"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M481"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ContractReferencedDocument/ram:ItemIdentificationID"
                 priority="101"
                 mode="M482">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ItemIdentificationID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M482"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M482"/>
   <xsl:template match="@*|node()" priority="-2" mode="M482">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M482"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M482"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ContractReferencedDocument/ram:LanguageID"
                 priority="101"
                 mode="M483">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:LanguageID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M483"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M483"/>
   <xsl:template match="@*|node()" priority="-2" mode="M483">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M483"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M483"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ContractReferencedDocument/ram:LineID"
                 priority="101"
                 mode="M484">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:LineID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M484"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M484"/>
   <xsl:template match="@*|node()" priority="-2" mode="M484">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M484"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M484"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ContractReferencedDocument/ram:LineItemQuantity"
                 priority="101"
                 mode="M485">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:LineItemQuantity' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M485"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M485"/>
   <xsl:template match="@*|node()" priority="-2" mode="M485">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M485"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M485"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ContractReferencedDocument/ram:LineStatusCode"
                 priority="101"
                 mode="M486">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:LineStatusCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M486"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M486"/>
   <xsl:template match="@*|node()" priority="-2" mode="M486">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M486"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M486"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ContractReferencedDocument/ram:LodgementLogisticsLocation"
                 priority="101"
                 mode="M487">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:LodgementLogisticsLocation' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M487"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M487"/>
   <xsl:template match="@*|node()" priority="-2" mode="M487">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M487"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M487"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ContractReferencedDocument/ram:Name"
                 priority="101"
                 mode="M488">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:Name' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M488"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M488"/>
   <xsl:template match="@*|node()" priority="-2" mode="M488">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M488"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M488"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ContractReferencedDocument/ram:OriginalIssuedQuantity"
                 priority="101"
                 mode="M489">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:OriginalIssuedQuantity' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M489"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M489"/>
   <xsl:template match="@*|node()" priority="-2" mode="M489">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M489"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M489"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ContractReferencedDocument/ram:OriginalRequiredQuantity"
                 priority="101"
                 mode="M490">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:OriginalRequiredQuantity' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M490"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M490"/>
   <xsl:template match="@*|node()" priority="-2" mode="M490">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M490"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M490"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ContractReferencedDocument/ram:PreviousRevisionID"
                 priority="101"
                 mode="M491">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:PreviousRevisionID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M491"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M491"/>
   <xsl:template match="@*|node()" priority="-2" mode="M491">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M491"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M491"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ContractReferencedDocument/ram:PurposeCode"
                 priority="101"
                 mode="M492">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:PurposeCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M492"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M492"/>
   <xsl:template match="@*|node()" priority="-2" mode="M492">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M492"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M492"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ContractReferencedDocument/ram:ReceiptDateTime"
                 priority="101"
                 mode="M493">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ReceiptDateTime' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M493"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M493"/>
   <xsl:template match="@*|node()" priority="-2" mode="M493">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M493"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M493"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ContractReferencedDocument/ram:RecipientTradeParty"
                 priority="101"
                 mode="M494">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:RecipientTradeParty' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M494"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M494"/>
   <xsl:template match="@*|node()" priority="-2" mode="M494">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M494"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M494"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ContractReferencedDocument/ram:ReferenceTypeCode"
                 priority="101"
                 mode="M495">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ReferenceTypeCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M495"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M495"/>
   <xsl:template match="@*|node()" priority="-2" mode="M495">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M495"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M495"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ContractReferencedDocument/ram:RelationshipTypeCode"
                 priority="101"
                 mode="M496">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:RelationshipTypeCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M496"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M496"/>
   <xsl:template match="@*|node()" priority="-2" mode="M496">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M496"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M496"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ContractReferencedDocument/ram:Remarks"
                 priority="101"
                 mode="M497">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:Remarks' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M497"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M497"/>
   <xsl:template match="@*|node()" priority="-2" mode="M497">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M497"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M497"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ContractReferencedDocument/ram:Revision"
                 priority="101"
                 mode="M498">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:Revision' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M498"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M498"/>
   <xsl:template match="@*|node()" priority="-2" mode="M498">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M498"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M498"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ContractReferencedDocument/ram:RevisionDateTime"
                 priority="101"
                 mode="M499">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:RevisionDateTime' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M499"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M499"/>
   <xsl:template match="@*|node()" priority="-2" mode="M499">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M499"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M499"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ContractReferencedDocument/ram:RevisionID"
                 priority="101"
                 mode="M500">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:RevisionID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M500"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M500"/>
   <xsl:template match="@*|node()" priority="-2" mode="M500">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M500"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M500"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ContractReferencedDocument/ram:SectionName"
                 priority="101"
                 mode="M501">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:SectionName' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M501"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M501"/>
   <xsl:template match="@*|node()" priority="-2" mode="M501">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M501"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M501"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ContractReferencedDocument/ram:SignatoryDocumentAuthentication"
                 priority="101"
                 mode="M502">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:SignatoryDocumentAuthentication' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M502"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M502"/>
   <xsl:template match="@*|node()" priority="-2" mode="M502">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M502"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M502"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ContractReferencedDocument/ram:StatusCode"
                 priority="101"
                 mode="M503">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:StatusCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M503"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M503"/>
   <xsl:template match="@*|node()" priority="-2" mode="M503">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M503"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M503"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ContractReferencedDocument/ram:SubordinateLineID"
                 priority="101"
                 mode="M504">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:SubordinateLineID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M504"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M504"/>
   <xsl:template match="@*|node()" priority="-2" mode="M504">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M504"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M504"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ContractReferencedDocument/ram:TypeCode"
                 priority="101"
                 mode="M505">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:TypeCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M505"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M505"/>
   <xsl:template match="@*|node()" priority="-2" mode="M505">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M505"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M505"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ContractReferencedDocument/ram:URIID"
                 priority="101"
                 mode="M506">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:URIID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M506"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M506"/>
   <xsl:template match="@*|node()" priority="-2" mode="M506">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M506"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M506"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CustomerOrderReferencedDocument"
                 priority="101"
                 mode="M507">

		<!--ASSERT -->
      <xsl:choose>
         <xsl:when test="count(ram:ID)=1"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text> Element 'ram:ID' must occur exactly 1 times.</xsl:text>
            </xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M507"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M507"/>
   <xsl:template match="@*|node()" priority="-2" mode="M507">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M507"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M507"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CustomerOrderReferencedDocument/ram:AcceptableSpecifiedPeriod"
                 priority="101"
                 mode="M508">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:AcceptableSpecifiedPeriod' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M508"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M508"/>
   <xsl:template match="@*|node()" priority="-2" mode="M508">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M508"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M508"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CustomerOrderReferencedDocument/ram:AcceptanceDateTime"
                 priority="101"
                 mode="M509">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:AcceptanceDateTime' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M509"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M509"/>
   <xsl:template match="@*|node()" priority="-2" mode="M509">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M509"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M509"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CustomerOrderReferencedDocument/ram:AmendmentPurposeCode"
                 priority="101"
                 mode="M510">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:AmendmentPurposeCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M510"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M510"/>
   <xsl:template match="@*|node()" priority="-2" mode="M510">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M510"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M510"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CustomerOrderReferencedDocument/ram:AttachedSpecifiedBinaryFile"
                 priority="101"
                 mode="M511">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:AttachedSpecifiedBinaryFile' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M511"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M511"/>
   <xsl:template match="@*|node()" priority="-2" mode="M511">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M511"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M511"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CustomerOrderReferencedDocument/ram:AttachmentBinaryObject"
                 priority="101"
                 mode="M512">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:AttachmentBinaryObject' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M512"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M512"/>
   <xsl:template match="@*|node()" priority="-2" mode="M512">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M512"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M512"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CustomerOrderReferencedDocument/ram:AuthenticatedOriginalIndicator"
                 priority="101"
                 mode="M513">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:AuthenticatedOriginalIndicator' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M513"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M513"/>
   <xsl:template match="@*|node()" priority="-2" mode="M513">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M513"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M513"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CustomerOrderReferencedDocument/ram:CategoryCode"
                 priority="101"
                 mode="M514">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:CategoryCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M514"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M514"/>
   <xsl:template match="@*|node()" priority="-2" mode="M514">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M514"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M514"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CustomerOrderReferencedDocument/ram:ChannelCode"
                 priority="101"
                 mode="M515">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ChannelCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M515"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M515"/>
   <xsl:template match="@*|node()" priority="-2" mode="M515">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M515"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M515"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CustomerOrderReferencedDocument/ram:ContractualDocumentClause"
                 priority="101"
                 mode="M516">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ContractualDocumentClause' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M516"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M516"/>
   <xsl:template match="@*|node()" priority="-2" mode="M516">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M516"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M516"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CustomerOrderReferencedDocument/ram:CopyIndicator"
                 priority="101"
                 mode="M517">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:CopyIndicator' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M517"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M517"/>
   <xsl:template match="@*|node()" priority="-2" mode="M517">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M517"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M517"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CustomerOrderReferencedDocument/ram:CopyIssuedQuantity"
                 priority="101"
                 mode="M518">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:CopyIssuedQuantity' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M518"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M518"/>
   <xsl:template match="@*|node()" priority="-2" mode="M518">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M518"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M518"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CustomerOrderReferencedDocument/ram:CopyRequiredQuantity"
                 priority="101"
                 mode="M519">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:CopyRequiredQuantity' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M519"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M519"/>
   <xsl:template match="@*|node()" priority="-2" mode="M519">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M519"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M519"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CustomerOrderReferencedDocument/ram:CreationDateTime"
                 priority="101"
                 mode="M520">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:CreationDateTime' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M520"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M520"/>
   <xsl:template match="@*|node()" priority="-2" mode="M520">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M520"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M520"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CustomerOrderReferencedDocument/ram:EffectiveSpecifiedPeriod"
                 priority="101"
                 mode="M521">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:EffectiveSpecifiedPeriod' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M521"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M521"/>
   <xsl:template match="@*|node()" priority="-2" mode="M521">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M521"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M521"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CustomerOrderReferencedDocument/ram:ElectronicPresentationIndicator"
                 priority="101"
                 mode="M522">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ElectronicPresentationIndicator' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M522"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M522"/>
   <xsl:template match="@*|node()" priority="-2" mode="M522">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M522"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M522"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CustomerOrderReferencedDocument/ram:GlobalID"
                 priority="101"
                 mode="M523">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:GlobalID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M523"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M523"/>
   <xsl:template match="@*|node()" priority="-2" mode="M523">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M523"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M523"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CustomerOrderReferencedDocument/ram:ID[@schemeAgencyID]"
                 priority="101"
                 mode="M524">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeAgencyID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M524"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M524"/>
   <xsl:template match="@*|node()" priority="-2" mode="M524">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M524"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M524"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CustomerOrderReferencedDocument/ram:ID[@schemeAgencyName]"
                 priority="101"
                 mode="M525">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeAgencyName' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M525"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M525"/>
   <xsl:template match="@*|node()" priority="-2" mode="M525">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M525"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M525"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CustomerOrderReferencedDocument/ram:ID[@schemeDataURI]"
                 priority="101"
                 mode="M526">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeDataURI' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M526"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M526"/>
   <xsl:template match="@*|node()" priority="-2" mode="M526">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M526"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M526"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CustomerOrderReferencedDocument/ram:ID[@schemeID]"
                 priority="101"
                 mode="M527">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M527"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M527"/>
   <xsl:template match="@*|node()" priority="-2" mode="M527">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M527"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M527"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CustomerOrderReferencedDocument/ram:ID[@schemeName]"
                 priority="101"
                 mode="M528">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeName' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M528"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M528"/>
   <xsl:template match="@*|node()" priority="-2" mode="M528">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M528"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M528"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CustomerOrderReferencedDocument/ram:ID[@schemeURI]"
                 priority="101"
                 mode="M529">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeURI' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M529"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M529"/>
   <xsl:template match="@*|node()" priority="-2" mode="M529">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M529"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M529"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CustomerOrderReferencedDocument/ram:ID[@schemeVersionID]"
                 priority="101"
                 mode="M530">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeVersionID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M530"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M530"/>
   <xsl:template match="@*|node()" priority="-2" mode="M530">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M530"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M530"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CustomerOrderReferencedDocument/ram:Information"
                 priority="101"
                 mode="M531">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:Information' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M531"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M531"/>
   <xsl:template match="@*|node()" priority="-2" mode="M531">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M531"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M531"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CustomerOrderReferencedDocument/ram:IssueLogisticsLocation"
                 priority="101"
                 mode="M532">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:IssueLogisticsLocation' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M532"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M532"/>
   <xsl:template match="@*|node()" priority="-2" mode="M532">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M532"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M532"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CustomerOrderReferencedDocument/ram:IssuerAssignedID"
                 priority="101"
                 mode="M533">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:IssuerAssignedID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M533"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M533"/>
   <xsl:template match="@*|node()" priority="-2" mode="M533">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M533"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M533"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CustomerOrderReferencedDocument/ram:IssuerTradeParty"
                 priority="101"
                 mode="M534">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:IssuerTradeParty' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M534"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M534"/>
   <xsl:template match="@*|node()" priority="-2" mode="M534">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M534"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M534"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CustomerOrderReferencedDocument/ram:ItemIdentificationID"
                 priority="101"
                 mode="M535">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ItemIdentificationID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M535"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M535"/>
   <xsl:template match="@*|node()" priority="-2" mode="M535">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M535"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M535"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CustomerOrderReferencedDocument/ram:LanguageID"
                 priority="101"
                 mode="M536">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:LanguageID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M536"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M536"/>
   <xsl:template match="@*|node()" priority="-2" mode="M536">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M536"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M536"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CustomerOrderReferencedDocument/ram:LineID"
                 priority="101"
                 mode="M537">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:LineID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M537"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M537"/>
   <xsl:template match="@*|node()" priority="-2" mode="M537">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M537"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M537"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CustomerOrderReferencedDocument/ram:LineItemQuantity"
                 priority="101"
                 mode="M538">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:LineItemQuantity' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M538"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M538"/>
   <xsl:template match="@*|node()" priority="-2" mode="M538">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M538"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M538"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CustomerOrderReferencedDocument/ram:LineStatusCode"
                 priority="101"
                 mode="M539">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:LineStatusCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M539"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M539"/>
   <xsl:template match="@*|node()" priority="-2" mode="M539">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M539"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M539"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CustomerOrderReferencedDocument/ram:LodgementLogisticsLocation"
                 priority="101"
                 mode="M540">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:LodgementLogisticsLocation' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M540"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M540"/>
   <xsl:template match="@*|node()" priority="-2" mode="M540">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M540"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M540"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CustomerOrderReferencedDocument/ram:Name"
                 priority="101"
                 mode="M541">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:Name' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M541"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M541"/>
   <xsl:template match="@*|node()" priority="-2" mode="M541">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M541"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M541"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CustomerOrderReferencedDocument/ram:OriginalIssuedQuantity"
                 priority="101"
                 mode="M542">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:OriginalIssuedQuantity' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M542"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M542"/>
   <xsl:template match="@*|node()" priority="-2" mode="M542">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M542"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M542"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CustomerOrderReferencedDocument/ram:OriginalRequiredQuantity"
                 priority="101"
                 mode="M543">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:OriginalRequiredQuantity' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M543"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M543"/>
   <xsl:template match="@*|node()" priority="-2" mode="M543">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M543"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M543"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CustomerOrderReferencedDocument/ram:PreviousRevisionID"
                 priority="101"
                 mode="M544">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:PreviousRevisionID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M544"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M544"/>
   <xsl:template match="@*|node()" priority="-2" mode="M544">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M544"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M544"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CustomerOrderReferencedDocument/ram:PurposeCode"
                 priority="101"
                 mode="M545">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:PurposeCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M545"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M545"/>
   <xsl:template match="@*|node()" priority="-2" mode="M545">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M545"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M545"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CustomerOrderReferencedDocument/ram:ReceiptDateTime"
                 priority="101"
                 mode="M546">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ReceiptDateTime' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M546"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M546"/>
   <xsl:template match="@*|node()" priority="-2" mode="M546">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M546"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M546"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CustomerOrderReferencedDocument/ram:RecipientTradeParty"
                 priority="101"
                 mode="M547">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:RecipientTradeParty' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M547"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M547"/>
   <xsl:template match="@*|node()" priority="-2" mode="M547">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M547"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M547"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CustomerOrderReferencedDocument/ram:ReferenceTypeCode"
                 priority="101"
                 mode="M548">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ReferenceTypeCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M548"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M548"/>
   <xsl:template match="@*|node()" priority="-2" mode="M548">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M548"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M548"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CustomerOrderReferencedDocument/ram:RelationshipTypeCode"
                 priority="101"
                 mode="M549">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:RelationshipTypeCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M549"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M549"/>
   <xsl:template match="@*|node()" priority="-2" mode="M549">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M549"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M549"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CustomerOrderReferencedDocument/ram:Remarks"
                 priority="101"
                 mode="M550">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:Remarks' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M550"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M550"/>
   <xsl:template match="@*|node()" priority="-2" mode="M550">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M550"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M550"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CustomerOrderReferencedDocument/ram:Revision"
                 priority="101"
                 mode="M551">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:Revision' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M551"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M551"/>
   <xsl:template match="@*|node()" priority="-2" mode="M551">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M551"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M551"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CustomerOrderReferencedDocument/ram:RevisionDateTime"
                 priority="101"
                 mode="M552">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:RevisionDateTime' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M552"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M552"/>
   <xsl:template match="@*|node()" priority="-2" mode="M552">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M552"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M552"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CustomerOrderReferencedDocument/ram:RevisionID"
                 priority="101"
                 mode="M553">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:RevisionID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M553"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M553"/>
   <xsl:template match="@*|node()" priority="-2" mode="M553">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M553"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M553"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CustomerOrderReferencedDocument/ram:SectionName"
                 priority="101"
                 mode="M554">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:SectionName' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M554"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M554"/>
   <xsl:template match="@*|node()" priority="-2" mode="M554">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M554"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M554"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CustomerOrderReferencedDocument/ram:SignatoryDocumentAuthentication"
                 priority="101"
                 mode="M555">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:SignatoryDocumentAuthentication' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M555"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M555"/>
   <xsl:template match="@*|node()" priority="-2" mode="M555">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M555"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M555"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CustomerOrderReferencedDocument/ram:StatusCode"
                 priority="101"
                 mode="M556">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:StatusCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M556"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M556"/>
   <xsl:template match="@*|node()" priority="-2" mode="M556">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M556"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M556"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CustomerOrderReferencedDocument/ram:SubordinateLineID"
                 priority="101"
                 mode="M557">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:SubordinateLineID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M557"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M557"/>
   <xsl:template match="@*|node()" priority="-2" mode="M557">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M557"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M557"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CustomerOrderReferencedDocument/ram:TypeCode"
                 priority="101"
                 mode="M558">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:TypeCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M558"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M558"/>
   <xsl:template match="@*|node()" priority="-2" mode="M558">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M558"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M558"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:CustomerOrderReferencedDocument/ram:URIID"
                 priority="101"
                 mode="M559">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:URIID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M559"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M559"/>
   <xsl:template match="@*|node()" priority="-2" mode="M559">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M559"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M559"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:DeliveryOrderFulfilmentLeadTimeMeasure"
                 priority="101"
                 mode="M560">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:DeliveryOrderFulfilmentLeadTimeMeasure' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M560"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M560"/>
   <xsl:template match="@*|node()" priority="-2" mode="M560">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M560"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M560"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:DeliveryPriorityCode"
                 priority="101"
                 mode="M561">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:DeliveryPriorityCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M561"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M561"/>
   <xsl:template match="@*|node()" priority="-2" mode="M561">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M561"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M561"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:DemandForecastReferencedDocument"
                 priority="101"
                 mode="M562">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:DemandForecastReferencedDocument' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M562"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M562"/>
   <xsl:template match="@*|node()" priority="-2" mode="M562">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M562"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M562"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:DiscountedProductTradePrice"
                 priority="101"
                 mode="M563">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:DiscountedProductTradePrice' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M563"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M563"/>
   <xsl:template match="@*|node()" priority="-2" mode="M563">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M563"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M563"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:EngineeringChangeReferencedDocument"
                 priority="101"
                 mode="M564">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:EngineeringChangeReferencedDocument' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M564"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M564"/>
   <xsl:template match="@*|node()" priority="-2" mode="M564">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M564"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M564"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ExclusivitySpecifiedPeriod"
                 priority="101"
                 mode="M565">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ExclusivitySpecifiedPeriod' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M565"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M565"/>
   <xsl:template match="@*|node()" priority="-2" mode="M565">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M565"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M565"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ExportLicenceReferencedDocument"
                 priority="101"
                 mode="M566">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ExportLicenceReferencedDocument' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M566"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M566"/>
   <xsl:template match="@*|node()" priority="-2" mode="M566">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M566"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M566"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:GrossPriceProductTradePrice"
                 priority="101"
                 mode="M567">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:GrossPriceProductTradePrice' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M567"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M567"/>
   <xsl:template match="@*|node()" priority="-2" mode="M567">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M567"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M567"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:GuaranteedProductLifeSpanSpecifiedPeriod"
                 priority="101"
                 mode="M568">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:GuaranteedProductLifeSpanSpecifiedPeriod' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M568"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M568"/>
   <xsl:template match="@*|node()" priority="-2" mode="M568">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M568"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M568"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ImpactCode"
                 priority="101"
                 mode="M569">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ImpactCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M569"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M569"/>
   <xsl:template match="@*|node()" priority="-2" mode="M569">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M569"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M569"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ImportLicenceReferencedDocument"
                 priority="101"
                 mode="M570">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ImportLicenceReferencedDocument' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M570"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M570"/>
   <xsl:template match="@*|node()" priority="-2" mode="M570">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M570"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M570"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:IncrementalProductOrderableQuantity"
                 priority="101"
                 mode="M571">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:IncrementalProductOrderableQuantity' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M571"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M571"/>
   <xsl:template match="@*|node()" priority="-2" mode="M571">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M571"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M571"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:InformationUseRestrictionIndicator"
                 priority="101"
                 mode="M572">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:InformationUseRestrictionIndicator' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M572"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M572"/>
   <xsl:template match="@*|node()" priority="-2" mode="M572">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M572"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M572"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ItemBuyerTradeParty"
                 priority="101"
                 mode="M573">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ItemBuyerTradeParty' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M573"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M573"/>
   <xsl:template match="@*|node()" priority="-2" mode="M573">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M573"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M573"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ItemSellerTradeParty"
                 priority="101"
                 mode="M574">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ItemSellerTradeParty' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M574"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M574"/>
   <xsl:template match="@*|node()" priority="-2" mode="M574">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M574"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M574"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:LastKnownTradeParty"
                 priority="101"
                 mode="M575">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:LastKnownTradeParty' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M575"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M575"/>
   <xsl:template match="@*|node()" priority="-2" mode="M575">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M575"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M575"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:LetterOfCreditReferencedDocument"
                 priority="101"
                 mode="M576">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:LetterOfCreditReferencedDocument' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M576"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M576"/>
   <xsl:template match="@*|node()" priority="-2" mode="M576">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M576"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M576"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ListProductTradePrice"
                 priority="101"
                 mode="M577">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ListProductTradePrice' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M577"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M577"/>
   <xsl:template match="@*|node()" priority="-2" mode="M577">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M577"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M577"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:MarketplaceOrderReferencedDocument"
                 priority="101"
                 mode="M578">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:MarketplaceOrderReferencedDocument' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M578"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M578"/>
   <xsl:template match="@*|node()" priority="-2" mode="M578">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M578"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M578"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:MaterialReleaseReferencedDocument"
                 priority="101"
                 mode="M579">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:MaterialReleaseReferencedDocument' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M579"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M579"/>
   <xsl:template match="@*|node()" priority="-2" mode="M579">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M579"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M579"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:MaterialReturnsReferencedDocument"
                 priority="101"
                 mode="M580">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:MaterialReturnsReferencedDocument' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M580"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M580"/>
   <xsl:template match="@*|node()" priority="-2" mode="M580">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M580"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M580"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:MaximumOrderQuantityOrderingSpecifiedPeriod"
                 priority="101"
                 mode="M581">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:MaximumOrderQuantityOrderingSpecifiedPeriod' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M581"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M581"/>
   <xsl:template match="@*|node()" priority="-2" mode="M581">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M581"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M581"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:MaximumProductOrderableQuantity"
                 priority="101"
                 mode="M582">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:MaximumProductOrderableQuantity' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M582"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M582"/>
   <xsl:template match="@*|node()" priority="-2" mode="M582">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M582"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M582"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:MinimumOrderQuantityOrderingSpecifiedPeriod"
                 priority="101"
                 mode="M583">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:MinimumOrderQuantityOrderingSpecifiedPeriod' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M583"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M583"/>
   <xsl:template match="@*|node()" priority="-2" mode="M583">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M583"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M583"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:MinimumProductOrderableQuantity"
                 priority="101"
                 mode="M584">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:MinimumProductOrderableQuantity' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M584"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M584"/>
   <xsl:template match="@*|node()" priority="-2" mode="M584">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M584"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M584"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:NetPriceProductTradePrice"
                 priority="101"
                 mode="M585">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:NetPriceProductTradePrice' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M585"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M585"/>
   <xsl:template match="@*|node()" priority="-2" mode="M585">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M585"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M585"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:OrderProductUnitMeasureCode"
                 priority="101"
                 mode="M586">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:OrderProductUnitMeasureCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M586"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M586"/>
   <xsl:template match="@*|node()" priority="-2" mode="M586">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M586"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M586"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:OrderResponseReferencedDocument"
                 priority="101"
                 mode="M587">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:OrderResponseReferencedDocument' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M587"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M587"/>
   <xsl:template match="@*|node()" priority="-2" mode="M587">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M587"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M587"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:OrderingSpecifiedPeriod"
                 priority="101"
                 mode="M588">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:OrderingSpecifiedPeriod' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M588"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M588"/>
   <xsl:template match="@*|node()" priority="-2" mode="M588">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M588"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M588"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:OriginalOrderReferencedDocument"
                 priority="101"
                 mode="M589">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:OriginalOrderReferencedDocument' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M589"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M589"/>
   <xsl:template match="@*|node()" priority="-2" mode="M589">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M589"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M589"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:PickUpOrderFulfilmentLeadTimeMeasure"
                 priority="101"
                 mode="M590">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:PickUpOrderFulfilmentLeadTimeMeasure' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M590"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M590"/>
   <xsl:template match="@*|node()" priority="-2" mode="M590">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M590"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M590"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:PreviousOrderChangeReferencedDocument"
                 priority="101"
                 mode="M591">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:PreviousOrderChangeReferencedDocument' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M591"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M591"/>
   <xsl:template match="@*|node()" priority="-2" mode="M591">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M591"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M591"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:PreviousOrderReferencedDocument"
                 priority="101"
                 mode="M592">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:PreviousOrderReferencedDocument' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M592"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M592"/>
   <xsl:template match="@*|node()" priority="-2" mode="M592">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M592"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M592"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:PreviousOrderResponseReferencedDocument"
                 priority="101"
                 mode="M593">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:PreviousOrderResponseReferencedDocument' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M593"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M593"/>
   <xsl:template match="@*|node()" priority="-2" mode="M593">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M593"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M593"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:PreviousPriceListReferencedDocument"
                 priority="101"
                 mode="M594">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:PreviousPriceListReferencedDocument' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M594"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M594"/>
   <xsl:template match="@*|node()" priority="-2" mode="M594">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M594"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M594"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:PriceListReferencedDocument"
                 priority="101"
                 mode="M595">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:PriceListReferencedDocument' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M595"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M595"/>
   <xsl:template match="@*|node()" priority="-2" mode="M595">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M595"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M595"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:PriorityCode"
                 priority="101"
                 mode="M596">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:PriorityCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M596"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M596"/>
   <xsl:template match="@*|node()" priority="-2" mode="M596">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M596"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M596"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProcurementTradeParty"
                 priority="101"
                 mode="M597">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ProcurementTradeParty' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M597"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M597"/>
   <xsl:template match="@*|node()" priority="-2" mode="M597">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M597"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M597"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductAvailabilityCode"
                 priority="101"
                 mode="M598">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ProductAvailabilityCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M598"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M598"/>
   <xsl:template match="@*|node()" priority="-2" mode="M598">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M598"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M598"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductChargeFreeIndicator"
                 priority="101"
                 mode="M599">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ProductChargeFreeIndicator' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M599"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M599"/>
   <xsl:template match="@*|node()" priority="-2" mode="M599">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M599"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M599"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty"
                 priority="101"
                 mode="M600">

		<!--ASSERT -->
      <xsl:choose>
         <xsl:when test="count(ram:ID)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text> Element 'ram:ID' may occur at maximum 1 times.</xsl:text>
            </xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
      <xsl:choose>
         <xsl:when test="count(ram:Name)=1"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text> Element 'ram:Name' must occur exactly 1 times.</xsl:text>
            </xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
      <xsl:choose>
         <xsl:when test="count(ram:DefinedTradeContact)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text> Element 'ram:DefinedTradeContact' may occur at maximum 1 times.</xsl:text>
            </xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M600"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M600"/>
   <xsl:template match="@*|node()" priority="-2" mode="M600">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M600"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M600"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:ApplicableLogisticsServiceCharge"
                 priority="101"
                 mode="M601">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ApplicableLogisticsServiceCharge' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M601"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M601"/>
   <xsl:template match="@*|node()" priority="-2" mode="M601">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M601"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M601"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:AssociatedTradeParty"
                 priority="101"
                 mode="M602">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:AssociatedTradeParty' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M602"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M602"/>
   <xsl:template match="@*|node()" priority="-2" mode="M602">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M602"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M602"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:AttentionOfAssociatedTradeParty"
                 priority="101"
                 mode="M603">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:AttentionOfAssociatedTradeParty' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M603"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M603"/>
   <xsl:template match="@*|node()" priority="-2" mode="M603">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M603"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M603"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:BuyerAssignedID"
                 priority="101"
                 mode="M604">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:BuyerAssignedID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M604"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M604"/>
   <xsl:template match="@*|node()" priority="-2" mode="M604">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M604"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M604"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:CAGEID"
                 priority="101"
                 mode="M605">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:CAGEID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M605"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M605"/>
   <xsl:template match="@*|node()" priority="-2" mode="M605">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M605"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M605"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DODAACID"
                 priority="101"
                 mode="M606">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:DODAACID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M606"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M606"/>
   <xsl:template match="@*|node()" priority="-2" mode="M606">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M606"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M606"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DUNSID"
                 priority="101"
                 mode="M607">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:DUNSID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M607"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M607"/>
   <xsl:template match="@*|node()" priority="-2" mode="M607">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M607"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M607"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact"
                 priority="101"
                 mode="M608">

		<!--ASSERT -->
      <xsl:choose>
         <xsl:when test="count(ram:TelephoneUniversalCommunication)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text> Element 'ram:TelephoneUniversalCommunication' may occur at maximum 1 times.</xsl:text>
            </xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
      <xsl:choose>
         <xsl:when test="count(ram:FaxUniversalCommunication)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text> Element 'ram:FaxUniversalCommunication' may occur at maximum 1 times.</xsl:text>
            </xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M608"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M608"/>
   <xsl:template match="@*|node()" priority="-2" mode="M608">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M608"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M608"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:DepartmentName[@languageID]"
                 priority="101"
                 mode="M609">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @languageID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M609"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M609"/>
   <xsl:template match="@*|node()" priority="-2" mode="M609">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M609"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M609"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:DepartmentName[@languageLocaleID]"
                 priority="101"
                 mode="M610">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @languageLocaleID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M610"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M610"/>
   <xsl:template match="@*|node()" priority="-2" mode="M610">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M610"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M610"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:DirectTelephoneUniversalCommunication"
                 priority="101"
                 mode="M611">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:DirectTelephoneUniversalCommunication' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M611"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M611"/>
   <xsl:template match="@*|node()" priority="-2" mode="M611">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M611"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M611"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:EDIUniversalCommunication"
                 priority="101"
                 mode="M612">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:EDIUniversalCommunication' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M612"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M612"/>
   <xsl:template match="@*|node()" priority="-2" mode="M612">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M612"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M612"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:EmailURIUniversalCommunication"
                 priority="101"
                 mode="M613">

		<!--ASSERT -->
      <xsl:choose>
         <xsl:when test="count(ram:URIID)=1"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text> Element 'ram:URIID' must occur exactly 1 times.</xsl:text>
            </xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M613"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M613"/>
   <xsl:template match="@*|node()" priority="-2" mode="M613">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M613"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M613"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:EmailURIUniversalCommunication/ram:Access"
                 priority="101"
                 mode="M614">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:Access' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M614"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M614"/>
   <xsl:template match="@*|node()" priority="-2" mode="M614">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M614"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M614"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:EmailURIUniversalCommunication/ram:AreaNumberCode"
                 priority="101"
                 mode="M615">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:AreaNumberCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M615"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M615"/>
   <xsl:template match="@*|node()" priority="-2" mode="M615">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M615"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M615"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:EmailURIUniversalCommunication/ram:ChannelCode"
                 priority="101"
                 mode="M616">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ChannelCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M616"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M616"/>
   <xsl:template match="@*|node()" priority="-2" mode="M616">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M616"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M616"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:EmailURIUniversalCommunication/ram:CompleteNumber"
                 priority="101"
                 mode="M617">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:CompleteNumber' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M617"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M617"/>
   <xsl:template match="@*|node()" priority="-2" mode="M617">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M617"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M617"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:EmailURIUniversalCommunication/ram:CountryNumberCode"
                 priority="101"
                 mode="M618">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:CountryNumberCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M618"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M618"/>
   <xsl:template match="@*|node()" priority="-2" mode="M618">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M618"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M618"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:EmailURIUniversalCommunication/ram:ExtensionNumber"
                 priority="101"
                 mode="M619">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ExtensionNumber' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M619"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M619"/>
   <xsl:template match="@*|node()" priority="-2" mode="M619">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M619"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M619"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:EmailURIUniversalCommunication/ram:HTMLPreferredIndicator"
                 priority="101"
                 mode="M620">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:HTMLPreferredIndicator' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M620"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M620"/>
   <xsl:template match="@*|node()" priority="-2" mode="M620">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M620"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M620"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:EmailURIUniversalCommunication/ram:LocalNumber"
                 priority="101"
                 mode="M621">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:LocalNumber' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M621"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M621"/>
   <xsl:template match="@*|node()" priority="-2" mode="M621">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M621"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M621"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:EmailURIUniversalCommunication/ram:URIID[@schemeAgencyID]"
                 priority="101"
                 mode="M622">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeAgencyID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M622"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M622"/>
   <xsl:template match="@*|node()" priority="-2" mode="M622">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M622"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M622"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:EmailURIUniversalCommunication/ram:URIID[@schemeAgencyName]"
                 priority="101"
                 mode="M623">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeAgencyName' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M623"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M623"/>
   <xsl:template match="@*|node()" priority="-2" mode="M623">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M623"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M623"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:EmailURIUniversalCommunication/ram:URIID[@schemeDataURI]"
                 priority="101"
                 mode="M624">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeDataURI' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M624"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M624"/>
   <xsl:template match="@*|node()" priority="-2" mode="M624">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M624"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M624"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:EmailURIUniversalCommunication/ram:URIID[@schemeID]"
                 priority="101"
                 mode="M625">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M625"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M625"/>
   <xsl:template match="@*|node()" priority="-2" mode="M625">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M625"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M625"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:EmailURIUniversalCommunication/ram:URIID[@schemeName]"
                 priority="101"
                 mode="M626">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeName' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M626"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M626"/>
   <xsl:template match="@*|node()" priority="-2" mode="M626">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M626"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M626"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:EmailURIUniversalCommunication/ram:URIID[@schemeURI]"
                 priority="101"
                 mode="M627">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeURI' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M627"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M627"/>
   <xsl:template match="@*|node()" priority="-2" mode="M627">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M627"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M627"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:EmailURIUniversalCommunication/ram:URIID[@schemeVersionID]"
                 priority="101"
                 mode="M628">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeVersionID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M628"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M628"/>
   <xsl:template match="@*|node()" priority="-2" mode="M628">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M628"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M628"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:EmailURIUniversalCommunication/ram:UseCode"
                 priority="101"
                 mode="M629">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:UseCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M629"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M629"/>
   <xsl:template match="@*|node()" priority="-2" mode="M629">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M629"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M629"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:FaxUniversalCommunication"
                 priority="101"
                 mode="M630">

		<!--ASSERT -->
      <xsl:choose>
         <xsl:when test="count(ram:CompleteNumber)=1"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text> Element 'ram:CompleteNumber' must occur exactly 1 times.</xsl:text>
            </xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M630"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M630"/>
   <xsl:template match="@*|node()" priority="-2" mode="M630">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M630"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M630"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:FaxUniversalCommunication/ram:Access"
                 priority="101"
                 mode="M631">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:Access' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M631"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M631"/>
   <xsl:template match="@*|node()" priority="-2" mode="M631">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M631"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M631"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:FaxUniversalCommunication/ram:AreaNumberCode"
                 priority="101"
                 mode="M632">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:AreaNumberCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M632"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M632"/>
   <xsl:template match="@*|node()" priority="-2" mode="M632">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M632"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M632"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:FaxUniversalCommunication/ram:ChannelCode"
                 priority="101"
                 mode="M633">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ChannelCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M633"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M633"/>
   <xsl:template match="@*|node()" priority="-2" mode="M633">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M633"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M633"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:FaxUniversalCommunication/ram:CompleteNumber[@languageID]"
                 priority="101"
                 mode="M634">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @languageID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M634"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M634"/>
   <xsl:template match="@*|node()" priority="-2" mode="M634">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M634"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M634"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:FaxUniversalCommunication/ram:CompleteNumber[@languageLocaleID]"
                 priority="101"
                 mode="M635">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @languageLocaleID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M635"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M635"/>
   <xsl:template match="@*|node()" priority="-2" mode="M635">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M635"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M635"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:FaxUniversalCommunication/ram:CountryNumberCode"
                 priority="101"
                 mode="M636">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:CountryNumberCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M636"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M636"/>
   <xsl:template match="@*|node()" priority="-2" mode="M636">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M636"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M636"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:FaxUniversalCommunication/ram:ExtensionNumber"
                 priority="101"
                 mode="M637">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ExtensionNumber' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M637"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M637"/>
   <xsl:template match="@*|node()" priority="-2" mode="M637">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M637"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M637"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:FaxUniversalCommunication/ram:HTMLPreferredIndicator"
                 priority="101"
                 mode="M638">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:HTMLPreferredIndicator' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M638"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M638"/>
   <xsl:template match="@*|node()" priority="-2" mode="M638">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M638"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M638"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:FaxUniversalCommunication/ram:LocalNumber"
                 priority="101"
                 mode="M639">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:LocalNumber' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M639"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M639"/>
   <xsl:template match="@*|node()" priority="-2" mode="M639">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M639"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M639"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:FaxUniversalCommunication/ram:URIID"
                 priority="101"
                 mode="M640">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:URIID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M640"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M640"/>
   <xsl:template match="@*|node()" priority="-2" mode="M640">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M640"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M640"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:FaxUniversalCommunication/ram:UseCode"
                 priority="101"
                 mode="M641">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:UseCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M641"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M641"/>
   <xsl:template match="@*|node()" priority="-2" mode="M641">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M641"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M641"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:ID"
                 priority="101"
                 mode="M642">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M642"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M642"/>
   <xsl:template match="@*|node()" priority="-2" mode="M642">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M642"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M642"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:InstantMessagingUniversalCommunication"
                 priority="101"
                 mode="M643">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:InstantMessagingUniversalCommunication' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M643"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M643"/>
   <xsl:template match="@*|node()" priority="-2" mode="M643">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M643"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M643"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:JobTitle"
                 priority="101"
                 mode="M644">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:JobTitle' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M644"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M644"/>
   <xsl:template match="@*|node()" priority="-2" mode="M644">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M644"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M644"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:MobileTelephoneUniversalCommunication"
                 priority="101"
                 mode="M645">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:MobileTelephoneUniversalCommunication' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M645"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M645"/>
   <xsl:template match="@*|node()" priority="-2" mode="M645">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M645"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M645"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:PersonID"
                 priority="101"
                 mode="M646">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:PersonID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M646"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M646"/>
   <xsl:template match="@*|node()" priority="-2" mode="M646">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M646"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M646"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:PersonName[@languageID]"
                 priority="101"
                 mode="M647">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @languageID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M647"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M647"/>
   <xsl:template match="@*|node()" priority="-2" mode="M647">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M647"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M647"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:PersonName[@languageLocaleID]"
                 priority="101"
                 mode="M648">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @languageLocaleID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M648"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M648"/>
   <xsl:template match="@*|node()" priority="-2" mode="M648">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M648"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M648"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:Responsibility"
                 priority="101"
                 mode="M649">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:Responsibility' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M649"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M649"/>
   <xsl:template match="@*|node()" priority="-2" mode="M649">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M649"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M649"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:SpecifiedContactPerson"
                 priority="101"
                 mode="M650">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:SpecifiedContactPerson' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M650"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M650"/>
   <xsl:template match="@*|node()" priority="-2" mode="M650">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M650"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M650"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:SpecifiedNote"
                 priority="101"
                 mode="M651">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:SpecifiedNote' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M651"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M651"/>
   <xsl:template match="@*|node()" priority="-2" mode="M651">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M651"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M651"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:TelephoneUniversalCommunication"
                 priority="101"
                 mode="M652">

		<!--ASSERT -->
      <xsl:choose>
         <xsl:when test="count(ram:CompleteNumber)=1"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text> Element 'ram:CompleteNumber' must occur exactly 1 times.</xsl:text>
            </xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M652"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M652"/>
   <xsl:template match="@*|node()" priority="-2" mode="M652">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M652"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M652"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:TelephoneUniversalCommunication/ram:Access"
                 priority="101"
                 mode="M653">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:Access' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M653"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M653"/>
   <xsl:template match="@*|node()" priority="-2" mode="M653">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M653"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M653"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:TelephoneUniversalCommunication/ram:AreaNumberCode"
                 priority="101"
                 mode="M654">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:AreaNumberCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M654"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M654"/>
   <xsl:template match="@*|node()" priority="-2" mode="M654">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M654"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M654"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:TelephoneUniversalCommunication/ram:ChannelCode"
                 priority="101"
                 mode="M655">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ChannelCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M655"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M655"/>
   <xsl:template match="@*|node()" priority="-2" mode="M655">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M655"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M655"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:TelephoneUniversalCommunication/ram:CompleteNumber[@languageID]"
                 priority="101"
                 mode="M656">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @languageID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M656"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M656"/>
   <xsl:template match="@*|node()" priority="-2" mode="M656">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M656"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M656"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:TelephoneUniversalCommunication/ram:CompleteNumber[@languageLocaleID]"
                 priority="101"
                 mode="M657">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @languageLocaleID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M657"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M657"/>
   <xsl:template match="@*|node()" priority="-2" mode="M657">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M657"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M657"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:TelephoneUniversalCommunication/ram:CountryNumberCode"
                 priority="101"
                 mode="M658">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:CountryNumberCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M658"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M658"/>
   <xsl:template match="@*|node()" priority="-2" mode="M658">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M658"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M658"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:TelephoneUniversalCommunication/ram:ExtensionNumber"
                 priority="101"
                 mode="M659">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:ExtensionNumber' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M659"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M659"/>
   <xsl:template match="@*|node()" priority="-2" mode="M659">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M659"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M659"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:TelephoneUniversalCommunication/ram:HTMLPreferredIndicator"
                 priority="101"
                 mode="M660">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:HTMLPreferredIndicator' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M660"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M660"/>
   <xsl:template match="@*|node()" priority="-2" mode="M660">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M660"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M660"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:TelephoneUniversalCommunication/ram:LocalNumber"
                 priority="101"
                 mode="M661">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:LocalNumber' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M661"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M661"/>
   <xsl:template match="@*|node()" priority="-2" mode="M661">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M661"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M661"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:TelephoneUniversalCommunication/ram:URIID"
                 priority="101"
                 mode="M662">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:URIID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M662"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M662"/>
   <xsl:template match="@*|node()" priority="-2" mode="M662">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M662"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M662"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:TelephoneUniversalCommunication/ram:UseCode"
                 priority="101"
                 mode="M663">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:UseCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M663"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M663"/>
   <xsl:template match="@*|node()" priority="-2" mode="M663">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M663"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M663"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:TelexUniversalCommunication"
                 priority="101"
                 mode="M664">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:TelexUniversalCommunication' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M664"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M664"/>
   <xsl:template match="@*|node()" priority="-2" mode="M664">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M664"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M664"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:TypeCode"
                 priority="101"
                 mode="M665">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:TypeCode' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M665"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M665"/>
   <xsl:template match="@*|node()" priority="-2" mode="M665">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M665"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M665"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:URIUniversalCommunication"
                 priority="101"
                 mode="M666">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:URIUniversalCommunication' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M666"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M666"/>
   <xsl:template match="@*|node()" priority="-2" mode="M666">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M666"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M666"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:DefinedTradeContact/ram:VOIPUniversalCommunication"
                 priority="101"
                 mode="M667">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:VOIPUniversalCommunication' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M667"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M667"/>
   <xsl:template match="@*|node()" priority="-2" mode="M667">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M667"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M667"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:Description"
                 priority="101"
                 mode="M668">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:Description' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M668"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M668"/>
   <xsl:template match="@*|node()" priority="-2" mode="M668">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M668"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M668"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:EmailURIUniversalCommunication"
                 priority="101"
                 mode="M669">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:EmailURIUniversalCommunication' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M669"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M669"/>
   <xsl:template match="@*|node()" priority="-2" mode="M669">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M669"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M669"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:EndPointURIUniversalCommunication"
                 priority="101"
                 mode="M670">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:EndPointURIUniversalCommunication' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M670"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M670"/>
   <xsl:template match="@*|node()" priority="-2" mode="M670">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M670"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M670"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:FaxUniversalCommunication"
                 priority="101"
                 mode="M671">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:FaxUniversalCommunication' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M671"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M671"/>
   <xsl:template match="@*|node()" priority="-2" mode="M671">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M671"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M671"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:GLNID"
                 priority="101"
                 mode="M672">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Element 'ram:GLNID' is marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M672"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M672"/>
   <xsl:template match="@*|node()" priority="-2" mode="M672">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M672"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M672"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:GlobalID"
                 priority="101"
                 mode="M673">

		<!--ASSERT -->
      <xsl:choose>
         <xsl:when test="@schemeID"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text> Attribute '@schemeID' is required in this context.</xsl:text>
            </xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M673"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M673"/>
   <xsl:template match="@*|node()" priority="-2" mode="M673">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M673"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M673"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:GlobalID[@schemeAgencyID]"
                 priority="101"
                 mode="M674">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeAgencyID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M674"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M674"/>
   <xsl:template match="@*|node()" priority="-2" mode="M674">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M674"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M674"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:GlobalID[@schemeAgencyName]"
                 priority="101"
                 mode="M675">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeAgencyName' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M675"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M675"/>
   <xsl:template match="@*|node()" priority="-2" mode="M675">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M675"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M675"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:GlobalID[@schemeDataURI]"
                 priority="101"
                 mode="M676">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeDataURI' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M676"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M676"/>
   <xsl:template match="@*|node()" priority="-2" mode="M676">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M676"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M676"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:GlobalID[@schemeName]"
                 priority="101"
                 mode="M677">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeName' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M677"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M677"/>
   <xsl:template match="@*|node()" priority="-2" mode="M677">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M677"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M677"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:GlobalID[@schemeURI]"
                 priority="101"
                 mode="M678">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeURI' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M678"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M678"/>
   <xsl:template match="@*|node()" priority="-2" mode="M678">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M678"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M678"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:GlobalID[@schemeVersionID]"
                 priority="101"
                 mode="M679">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeVersionID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M679"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M679"/>
   <xsl:template match="@*|node()" priority="-2" mode="M679">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M679"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M679"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:ID[@schemeAgencyID]"
                 priority="101"
                 mode="M680">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeAgencyID' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M680"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M680"/>
   <xsl:template match="@*|node()" priority="-2" mode="M680">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M680"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M680"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:ID[@schemeAgencyName]"
                 priority="101"
                 mode="M681">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeAgencyName' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M681"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M681"/>
   <xsl:template match="@*|node()" priority="-2" mode="M681">
      <xsl:choose><!--Housekeeping: SAXON warns if attempting to find the attribute
                           of an attribute-->
         <xsl:when test="not(@*)">
            <xsl:apply-templates select="node()" mode="M681"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:apply-templates select="@*|node()" mode="M681"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--PATTERN -->


	  <!--RULE -->
   <xsl:template match="/rsm:CrossIndustryDocument/rsm:SpecifiedSupplyChainTradeTransaction/ram:ApplicableSupplyChainTradeAgreement/ram:ProductEndUserTradeParty/ram:ID[@schemeDataURI]"
                 priority="101"
                 mode="M682">

		<!--REPORT -->
      <xsl:if test="true()">
         <xsl:message>
            <xsl:text> Attribute @schemeDataURI' marked as not used in the given context.</xsl:text>
         </xsl:message>
      </xsl:if>
      <xsl:apply-templates select="@*|*|comment()|processing-instruction()" mode="M682"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M682"/>
   <xsl:template match="@*|node()