/*
 * Decompiled with CFR 0.152.
 */
package at.austriapro.ebinterface.ubl.from;

import at.austriapro.ebinterface.ubl.from.AbstractToEbInterfaceConverter;
import at.austriapro.ebinterface.ubl.from.IToEbinterfaceSettings;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.datetime.XMLOffsetDate;
import com.helger.commons.error.SingleError;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.locale.country.CountryCache;
import com.helger.commons.math.MathHelper;
import com.helger.commons.regex.RegExHelper;
import com.helger.commons.string.StringHelper;
import com.helger.ebinterface.v40.Ebi40AccountType;
import com.helger.ebinterface.v40.Ebi40AddressIdentifierType;
import com.helger.ebinterface.v40.Ebi40AddressIdentifierTypeType;
import com.helger.ebinterface.v40.Ebi40AddressType;
import com.helger.ebinterface.v40.Ebi40CountryCodeType;
import com.helger.ebinterface.v40.Ebi40CountryType;
import com.helger.ebinterface.v40.Ebi40CurrencyType;
import com.helger.ebinterface.v40.Ebi40DeliveryType;
import com.helger.ebinterface.v40.Ebi40DirectDebitType;
import com.helger.ebinterface.v40.Ebi40DiscountType;
import com.helger.ebinterface.v40.Ebi40DocumentTypeType;
import com.helger.ebinterface.v40.Ebi40InvoiceType;
import com.helger.ebinterface.v40.Ebi40NoPaymentType;
import com.helger.ebinterface.v40.Ebi40PaymentConditionsType;
import com.helger.ebinterface.v40.Ebi40PaymentMethodType;
import com.helger.ebinterface.v40.Ebi40PaymentReferenceType;
import com.helger.ebinterface.v40.Ebi40UniversalBankTransactionType;
import com.helger.xsds.ccts.cct.schemamodule.TextType;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.AddressType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.ContactType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.CustomerPartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.DeliveryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.MonetaryTotalType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyIdentificationType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyLegalEntityType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyNameType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PaymentMeansType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PaymentTermsType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PersonType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.SupplierPartyType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.DescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.InstructionIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.InstructionNoteType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.PaymentIDType;

@Immutable
public abstract class AbstractToEbInterface40Converter
extends AbstractToEbInterfaceConverter {
    public static final int PAYMENT_REFERENCE_MAX_LENGTH = 35;

    protected AbstractToEbInterface40Converter(@Nonnull Locale locale, @Nonnull Locale locale2, @Nonnull IToEbinterfaceSettings iToEbinterfaceSettings) {
        super(locale, locale2, iToEbinterfaceSettings);
    }

    @Nullable
    public static Ebi40CountryCodeType getCountryCode(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return null;
        }
        String string2 = string.toUpperCase(Locale.US);
        for (Ebi40CountryCodeType ebi40CountryCodeType : Ebi40CountryCodeType.values()) {
            if (!ebi40CountryCodeType.name().equals(string2)) continue;
            return ebi40CountryCodeType;
        }
        return null;
    }

    @Nullable
    public static Ebi40CurrencyType getCurrencyCode(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return null;
        }
        String string2 = string.toUpperCase(Locale.US);
        for (Ebi40CurrencyType ebi40CurrencyType : Ebi40CurrencyType.values()) {
            if (!ebi40CurrencyType.name().equals(string2)) continue;
            return ebi40CurrencyType;
        }
        return null;
    }

    public static void setAddressData(@Nullable AddressType addressType, @Nonnull Ebi40AddressType ebi40AddressType, @Nonnull Locale locale) {
        if (addressType != null) {
            ebi40AddressType.setStreet(StringHelper.getImplodedNonEmpty((char)' ', (String[])new String[]{StringHelper.trim((String)addressType.getStreetNameValue()), StringHelper.trim((String)addressType.getBuildingNumberValue())}));
            ebi40AddressType.setPOBox(StringHelper.trim((String)addressType.getPostboxValue()));
            ebi40AddressType.setTown(StringHelper.trim((String)addressType.getCityNameValue()));
            ebi40AddressType.setZIP(StringHelper.trim((String)addressType.getPostalZoneValue()));
            if (addressType.getCountry() != null) {
                Locale locale2;
                Ebi40CountryType ebi40CountryType = new Ebi40CountryType();
                String string = StringHelper.trim((String)addressType.getCountry().getIdentificationCodeValue());
                ebi40CountryType.setCountryCode(AbstractToEbInterface40Converter.getCountryCode(string));
                String string2 = StringHelper.trim((String)addressType.getCountry().getNameValue());
                ebi40CountryType.setContent(string2);
                if (StringHelper.hasNoText((String)string2) && StringHelper.hasText((String)string) && (locale2 = CountryCache.getInstance().getCountry(string)) != null) {
                    ebi40CountryType.setContent(locale2.getDisplayCountry(locale));
                }
                ebi40AddressType.setCountry(ebi40CountryType);
            }
        }
    }

    public static void validateAddressData(@Nonnull Ebi40AddressType ebi40AddressType, @Nonnull String string, @Nonnull ErrorList errorList, @Nonnull Locale locale) {
        if (ebi40AddressType.getStreet() == null) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName(string + "/PostalAddress/StreetName")).errorText(AbstractToEbInterfaceConverter.EText.ADDRESS_NO_STREET.getDisplayText(locale))).build());
        }
        if (ebi40AddressType.getTown() == null) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName(string + "/PostalAddress/CityName")).errorText(AbstractToEbInterfaceConverter.EText.ADDRESS_NO_CITY.getDisplayText(locale))).build());
        }
        if (ebi40AddressType.getZIP() == null) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName(string + "/PostalAddress/PostalZone")).errorText(AbstractToEbInterfaceConverter.EText.ADDRESS_NO_ZIPCODE.getDisplayText(locale))).build());
        }
        if (ebi40AddressType.getCountry() == null) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName(string + "/PostalAddress/Country/IdentificationCode")).errorText(AbstractToEbInterfaceConverter.EText.ADDRESS_NO_COUNTRY.getDisplayText(locale))).build());
        }
    }

    @Nonnull
    public static Ebi40AddressType convertParty(@Nonnull PartyType partyType, @Nonnull String string, @Nonnull ErrorList errorList, @Nonnull Locale locale, @Nonnull Locale locale2, boolean bl) {
        Object object;
        PartyNameType partyNameType;
        Ebi40AddressType ebi40AddressType = new Ebi40AddressType();
        if (partyType.getPartyNameCount() > 1) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName(string + "/PartyName")).errorText(AbstractToEbInterfaceConverter.EText.MULTIPLE_PARTIES.getDisplayText(locale2))).build());
        }
        if ((partyNameType = (PartyNameType)CollectionHelper.getAtIndex((List)partyType.getPartyName(), (int)0)) != null) {
            ebi40AddressType.setName(StringHelper.trim((String)partyNameType.getNameValue()));
        }
        if (ebi40AddressType.getName() == null && partyType.hasPartyLegalEntityEntries()) {
            ebi40AddressType.setName(StringHelper.trim((String)partyType.getPartyLegalEntityAtIndex(0).getRegistrationNameValue()));
        }
        if (ebi40AddressType.getName() == null) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName(string)).errorText(AbstractToEbInterfaceConverter.EText.PARTY_NO_NAME.getDisplayText(locale2))).build());
        }
        AbstractToEbInterface40Converter.setAddressData(partyType.getPostalAddress(), ebi40AddressType, locale);
        ContactType contactType = partyType.getContact();
        if (contactType != null) {
            ebi40AddressType.setPhone(StringHelper.trim((String)contactType.getTelephoneValue()));
            ebi40AddressType.setEmail(StringHelper.trim((String)contactType.getElectronicMailValue()));
        }
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (contactType != null && StringHelper.hasTextAfterTrim((String)contactType.getNameValue())) {
            commonsArrayList.add((Object)StringHelper.trim((String)contactType.getNameValue()));
        }
        Object object2 = partyType.getPerson().iterator();
        while (object2.hasNext()) {
            object = (PersonType)object2.next();
            if (StringHelper.hasNoText((String)ebi40AddressType.getSalutation())) {
                ebi40AddressType.setSalutation(StringHelper.trim((String)object.getGenderCodeValue()));
            }
            commonsArrayList.add((Object)StringHelper.getImplodedNonEmpty((char)' ', (String[])new String[]{StringHelper.trim((String)object.getTitleValue()), StringHelper.trim((String)object.getFirstNameValue()), StringHelper.trim((String)object.getMiddleNameValue()), StringHelper.trim((String)object.getFamilyNameValue()), StringHelper.trim((String)object.getNameSuffixValue())}));
        }
        if (!commonsArrayList.isEmpty()) {
            ebi40AddressType.setContact(StringHelper.getImplodedNonEmpty((char)'\n', (Iterable)commonsArrayList));
        }
        if (partyType.getEndpointID() != null && StringHelper.hasText((String)(object2 = StringHelper.trim((String)partyType.getEndpointIDValue())))) {
            object = StringHelper.trim((String)partyType.getEndpointID().getSchemeID());
            for (PartyIdentificationType partyIdentificationType : Ebi40AddressIdentifierTypeType.values()) {
                if (!partyIdentificationType.value().equalsIgnoreCase((String)object)) continue;
                Ebi40AddressIdentifierType ebi40AddressIdentifierType = new Ebi40AddressIdentifierType();
                ebi40AddressIdentifierType.setAddressIdentifierType((Ebi40AddressIdentifierTypeType)partyIdentificationType);
                ebi40AddressIdentifierType.setContent((String)object2);
                ebi40AddressType.setAddressIdentifier(ebi40AddressIdentifierType);
            }
            if (ebi40AddressType.getAddressIdentifier() == null) {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName(string)).errorText(AbstractToEbInterfaceConverter.EText.PARTY_UNSUPPORTED_ENDPOINT.getDisplayTextWithArgs(locale2, new Object[]{object2, partyType.getEndpointID().getSchemeID()}))).build());
            }
        }
        if (ebi40AddressType.getAddressIdentifier() == null) {
            int n = 0;
            for (PartyIdentificationType partyIdentificationType : partyType.getPartyIdentification()) {
                String string2 = StringHelper.trim((String)partyIdentificationType.getIDValue());
                for (Ebi40AddressIdentifierTypeType ebi40AddressIdentifierTypeType : Ebi40AddressIdentifierTypeType.values()) {
                    if (!ebi40AddressIdentifierTypeType.value().equalsIgnoreCase(partyIdentificationType.getID().getSchemeID())) continue;
                    Ebi40AddressIdentifierType ebi40AddressIdentifierType = new Ebi40AddressIdentifierType();
                    ebi40AddressIdentifierType.setAddressIdentifierType(ebi40AddressIdentifierTypeType);
                    ebi40AddressIdentifierType.setContent(string2);
                    ebi40AddressType.setAddressIdentifier(ebi40AddressIdentifierType);
                }
                if (ebi40AddressType.getAddressIdentifier() == null) {
                    errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName(string + "/PartyIdentification[" + n + "]")).errorText(AbstractToEbInterfaceConverter.EText.PARTY_UNSUPPORTED_ADDRESS_IDENTIFIER.getDisplayTextWithArgs(locale2, new Object[]{string2, partyIdentificationType.getID().getSchemeID()}))).build());
                }
                ++n;
            }
        }
        if (bl) {
            AbstractToEbInterface40Converter.validateAddressData(ebi40AddressType, string, errorList, locale2);
        }
        return ebi40AddressType;
    }

    @Nonnull
    protected static String getAggregated(@Nonnull Iterable<DescriptionType> iterable) {
        return StringHelper.getImplodedMapped((char)'\n', iterable, TextType::getValue);
    }

    protected static boolean isAddressIncomplete(@Nonnull Ebi40AddressType ebi40AddressType) {
        return StringHelper.hasNoText((String)ebi40AddressType.getName()) || StringHelper.hasNoText((String)ebi40AddressType.getTown()) || StringHelper.hasNoText((String)ebi40AddressType.getZIP()) || ebi40AddressType.getCountry() == null;
    }

    @Nonnull
    public static Ebi40DeliveryType convertDelivery(@Nonnull DeliveryType deliveryType, @Nonnull String string, @Nullable CustomerPartyType customerPartyType, @Nonnull ErrorList errorList, @Nonnull Locale locale, @Nonnull Locale locale2) {
        AddressType addressType;
        Ebi40DeliveryType ebi40DeliveryType = new Ebi40DeliveryType();
        ebi40DeliveryType.setDeliveryID(deliveryType.getIDValue());
        ebi40DeliveryType.setDate(deliveryType.getActualDeliveryDateValue());
        PartyType partyType = deliveryType.getDeliveryParty();
        Ebi40AddressType ebi40AddressType = null;
        if (partyType != null) {
            ebi40AddressType = AbstractToEbInterface40Converter.convertParty(partyType, "DeliveryParty", errorList, locale, locale2, false);
            ebi40DeliveryType.setAddress(ebi40AddressType);
        }
        if ((ebi40AddressType == null || AbstractToEbInterface40Converter.isAddressIncomplete(ebi40AddressType)) && (addressType = deliveryType.getDeliveryAddress()) != null) {
            if (ebi40AddressType == null) {
                ebi40AddressType = new Ebi40AddressType();
            }
            AbstractToEbInterface40Converter.setAddressData(addressType, ebi40AddressType, locale);
            ebi40DeliveryType.setAddress(ebi40AddressType);
        }
        if ((addressType = deliveryType.getDeliveryLocation()) != null && addressType.getAddress() != null) {
            ebi40DeliveryType.setDescription(AbstractToEbInterface40Converter.getAggregated(addressType.getDescription()));
            if (ebi40AddressType == null || AbstractToEbInterface40Converter.isAddressIncomplete(ebi40AddressType)) {
                if (ebi40AddressType == null) {
                    ebi40AddressType = new Ebi40AddressType();
                }
                AbstractToEbInterface40Converter.setAddressData(addressType.getAddress(), ebi40AddressType, locale);
                ebi40DeliveryType.setAddress(ebi40AddressType);
            }
        }
        if (ebi40AddressType != null) {
            PartyNameType partyNameType;
            Iterator iterator;
            String string2 = null;
            if (deliveryType.getDeliveryParty() != null) {
                iterator = deliveryType.getDeliveryParty().getPartyName().iterator();
                while (iterator.hasNext() && !StringHelper.hasText((String)(string2 = StringHelper.trim((String)(partyNameType = (PartyNameType)iterator.next()).getNameValue())))) {
                }
            }
            if (StringHelper.hasNoText(string2) && addressType != null) {
                string2 = StringHelper.trim((String)addressType.getNameValue());
            }
            if (StringHelper.hasNoText(string2) && customerPartyType != null && customerPartyType.getParty() != null) {
                iterator = customerPartyType.getParty().getPartyName().iterator();
                while (iterator.hasNext() && !StringHelper.hasText((String)(string2 = StringHelper.trim((String)(partyNameType = (PartyNameType)iterator.next()).getNameValue())))) {
                }
                if (StringHelper.hasNoText((String)string2)) {
                    iterator = customerPartyType.getParty().getPartyLegalEntity().iterator();
                    while (iterator.hasNext() && !StringHelper.hasText((String)(string2 = StringHelper.trim((String)(partyNameType = (PartyLegalEntityType)iterator.next()).getRegistrationNameValue())))) {
                    }
                }
            }
            ebi40AddressType.setName(string2);
            if (StringHelper.hasNoText((String)ebi40AddressType.getName())) {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName(string + "/DeliveryParty")).errorText(AbstractToEbInterfaceConverter.EText.DELIVERY_WITHOUT_NAME.getDisplayText(locale2))).build());
            }
            AbstractToEbInterface40Converter.validateAddressData(ebi40AddressType, string + "/DeliveryParty", errorList, locale2);
        }
        return ebi40DeliveryType;
    }

    @Nullable
    protected static final Ebi40DocumentTypeType getAsDocumentTypeType(String ... stringArray) {
        if (stringArray != null) {
            for (String string : stringArray) {
                if (string == null) continue;
                String string2 = string.trim();
                try {
                    return Ebi40DocumentTypeType.fromValue((String)string2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if ("326".equals(string2)) {
                        return Ebi40DocumentTypeType.INVOICE_FOR_PARTIAL_DELIVERY;
                    }
                    if ("386".equals(string2)) {
                        return Ebi40DocumentTypeType.INVOICE_FOR_ADVANCE_PAYMENT;
                    }
                    if (!"389".equals(string2)) continue;
                    return Ebi40DocumentTypeType.SELF_BILLING;
                }
            }
        }
        return null;
    }

    private static void _setPaymentMeansComment(@Nonnull PaymentMeansType paymentMeansType, @Nonnull Ebi40PaymentMethodType ebi40PaymentMethodType) {
        if (paymentMeansType.hasInstructionNoteEntries()) {
            CommonsArrayList commonsArrayList = new CommonsArrayList();
            for (InstructionNoteType instructionNoteType : paymentMeansType.getInstructionNote()) {
                commonsArrayList.add((Object)StringHelper.trim((String)instructionNoteType.getValue()));
            }
            if (commonsArrayList.isNotEmpty()) {
                ebi40PaymentMethodType.setComment(StringHelper.getImplodedNonEmpty((char)'\n', (Iterable)commonsArrayList));
            }
        }
    }

    protected void convertPayment(@Nonnull Supplier<XMLOffsetDate> supplier, @Nonnull Supplier<List<PaymentMeansType>> supplier2, @Nonnull Supplier<PartyType> supplier3, @Nonnull Supplier<SupplierPartyType> supplier4, @Nonnull Supplier<List<PaymentTermsType>> supplier5, @Nonnull Supplier<MonetaryTotalType> supplier6, @Nonnull ErrorList errorList, @Nonnull Ebi40InvoiceType ebi40InvoiceType, boolean bl) {
        Object object;
        Object object2;
        InstructionIDType instructionIDType;
        Object object3;
        String string6;
        Object object4;
        Ebi40PaymentConditionsType ebi40PaymentConditionsType = new Ebi40PaymentConditionsType();
        int n = 0;
        for (PaymentMeansType object5 : supplier2.get()) {
            String string2 = StringHelper.trim((String)object5.getPaymentMeansCodeValue());
            if (AbstractToEbInterface40Converter.isUniversalBankTransaction(string2)) {
                object4 = new Ebi40UniversalBankTransactionType();
                string6 = StringHelper.trim((String)object5.getPaymentChannelCodeValue());
                if (AbstractToEbInterface40Converter.isIBAN(string6)) {
                    PartyNameType partyNameType;
                    Object object6;
                    String string3;
                    PaymentIDType paymentIDType2;
                    String string4;
                    AbstractToEbInterface40Converter._setPaymentMeansComment(object5, (Ebi40PaymentMethodType)object4);
                    object3 = new Ebi40UniversalBankTransactionType();
                    instructionIDType = object5.getInstructionID();
                    if (instructionIDType != null && StringHelper.hasText((String)(string4 = StringHelper.trim((String)instructionIDType.getValue())))) {
                        if (string4.length() > 35) {
                            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("PaymentMeans[" + n + "]/InstructionID")).errorText(AbstractToEbInterfaceConverter.EText.PAYMENT_ID_TOO_LONG_CUT.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{string4}))).build());
                            string4 = string4.substring(0, 35);
                        }
                        object2 = new Ebi40PaymentReferenceType();
                        object2.setValue(string4);
                        object3.setPaymentReference((Ebi40PaymentReferenceType)object2);
                    }
                    if (object3.getPaymentReference() == null) {
                        int n2 = 0;
                        for (PaymentIDType paymentIDType2 : object5.getPaymentID()) {
                            string3 = StringHelper.trim((String)paymentIDType2.getValue());
                            if (StringHelper.hasText((String)string3)) {
                                if (string3.length() > 35) {
                                    errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("PaymentMeans[" + n + "]/PaymentID[" + n2 + "]")).errorText(AbstractToEbInterfaceConverter.EText.PAYMENT_ID_TOO_LONG_CUT.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{string3}))).build());
                                    string3 = string3.substring(0, 35);
                                }
                                object6 = new Ebi40PaymentReferenceType();
                                object6.setValue(string3);
                                object3.setPaymentReference(object6);
                            }
                            ++n2;
                        }
                    }
                    object = new Ebi40AccountType();
                    object2 = object5.getPayeeFinancialAccount();
                    if (object2 != null && object2.getFinancialInstitutionBranch() != null && object2.getFinancialInstitutionBranch().getFinancialInstitution() != null && StringHelper.hasText((String)(paymentIDType2 = object2.getFinancialInstitutionBranch().getFinancialInstitution()).getIDValue())) {
                        string3 = StringHelper.trim((String)paymentIDType2.getID().getValue());
                        object6 = StringHelper.trim((String)paymentIDType2.getID().getSchemeID());
                        boolean bl2 = AbstractToEbInterface40Converter.isBIC((String)object6);
                        if (bl2) {
                            object.setBIC(string3);
                        } else {
                            object.setBankName(string3);
                        }
                        if (bl2 && (StringHelper.hasNoText((String)string3) || !RegExHelper.stringMatchesPattern((String)"[0-9A-Za-z]{8}([0-9A-Za-z]{3})?", (String)string3))) {
                            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("PaymentMeans[" + n + "]/PayeeFinancialAccount/FinancialInstitutionBranch/FinancialInstitution/ID")).errorText(AbstractToEbInterfaceConverter.EText.BIC_INVALID.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{string3}))).build());
                            object.setBIC(null);
                        }
                    }
                    paymentIDType2 = object2 != null ? StringHelper.trim((String)object2.getIDValue()) : null;
                    object.setIBAN((String)paymentIDType2);
                    if (StringHelper.getLength((CharSequence)paymentIDType2) > 34) {
                        errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("PaymentMeans[" + n + "]/PayeeFinancialAccount/ID")).errorText(AbstractToEbInterfaceConverter.EText.IBAN_TOO_LONG_STRIPPING.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{paymentIDType2, 34}))).build());
                        object.setIBAN(paymentIDType2.substring(0, 34));
                    }
                    String string5 = string3 = object2 != null ? object2.getNameValue() : null;
                    if (StringHelper.hasNoText((String)string3) && (object6 = supplier3.get()) != null) {
                        Iterator iterator = object6.getPartyName().iterator();
                        while (iterator.hasNext() && !StringHelper.hasText((String)(string3 = StringHelper.trim((String)(partyNameType = (PartyNameType)iterator.next()).getNameValue())))) {
                        }
                    }
                    if (StringHelper.hasNoText((String)string3) && (object6 = supplier4.get().getParty()) != null) {
                        Iterator iterator = object6.getPartyName().iterator();
                        while (iterator.hasNext() && !StringHelper.hasText((String)(string3 = StringHelper.trim((String)(partyNameType = (PartyNameType)iterator.next()).getNameValue())))) {
                        }
                    }
                    object.setBankAccountOwner(string3);
                    object3.addBeneficiaryAccount(object);
                    ebi40InvoiceType.setPaymentMethod((Ebi40PaymentMethodType)object4);
                    ebi40PaymentConditionsType.setDueDate(object5.getPaymentDueDateValue());
                    break;
                }
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("PaymentMeans[" + n + "]")).errorText(AbstractToEbInterfaceConverter.EText.PAYMENTMEANS_UNSUPPORTED_CHANNELCODE.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{string6}))).build());
            } else {
                if (AbstractToEbInterface40Converter.isDirectDebit(string2)) {
                    object4 = new Ebi40DirectDebitType();
                    AbstractToEbInterface40Converter._setPaymentMeansComment(object5, (Ebi40PaymentMethodType)object4);
                    ebi40InvoiceType.setPaymentMethod((Ebi40PaymentMethodType)object4);
                    ebi40PaymentConditionsType.setDueDate(object5.getPaymentDueDateValue());
                    break;
                }
                if (MathHelper.isEQ0((BigDecimal)ebi40InvoiceType.getTotalGrossAmount())) {
                    object4 = new Ebi40NoPaymentType();
                    AbstractToEbInterface40Converter._setPaymentMeansComment(object5, (Ebi40PaymentMethodType)object4);
                    ebi40InvoiceType.setPaymentMethod((Ebi40PaymentMethodType)object4);
                    break;
                }
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("PaymentMeans[" + n + "]")).errorText(AbstractToEbInterfaceConverter.EText.PAYMENTMEANS_CODE_INVALID.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{string2, this.getOrString(", ", "30", "31", "42", "58"), this.getOrString(", ", "49")}))).build());
            }
            ++n;
        }
        if (ebi40InvoiceType.getPaymentMethod() == null && this.m_aSettings.isInvoicePaymentMethodMandatory()) {
            if (bl) {
                Ebi40NoPaymentType ebi40NoPaymentType = new Ebi40NoPaymentType();
                ebi40InvoiceType.setPaymentMethod((Ebi40PaymentMethodType)ebi40NoPaymentType);
            } else {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName(bl ? "CreditNote" : "Invoice")).errorText(AbstractToEbInterfaceConverter.EText.ERB_NO_PAYMENT_METHOD.getDisplayText(this.m_aDisplayLocale))).build());
            }
        }
        if (ebi40PaymentConditionsType.getDueDate() == null) {
            ebi40PaymentConditionsType.setDueDate(supplier.get());
        }
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        int n3 = 0;
        for (PaymentTermsType paymentTermsType : supplier5.get()) {
            for (String string6 : paymentTermsType.getNote()) {
                object3 = StringHelper.trim((String)string6.getValue());
                if (!StringHelper.hasText((String)object3)) continue;
                commonsArrayList.add(object3);
            }
            if (paymentTermsType.getPaymentDueDate() != null) {
                object4 = paymentTermsType.getPaymentDueDateValue();
                string6 = ebi40PaymentConditionsType.getDueDate();
                if (object4 != null && string6 != null) {
                    if (!string6.equals(object4)) {
                        errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("PaymentTerms[" + n3 + "]/PaymentDueDate")).errorText(AbstractToEbInterfaceConverter.EText.PAYMENT_DUE_DATE_ALREADY_CONTAINED.getDisplayText(this.m_aDisplayLocale))).build());
                    }
                } else {
                    ebi40PaymentConditionsType.setDueDate((XMLOffsetDate)object4);
                }
                if ((object3 = paymentTermsType.getPaymentPercentValue()) != null && MathHelper.isGT0((BigDecimal)object3) && MathHelper.isLT100((BigDecimal)object3)) {
                    instructionIDType = supplier6.get();
                    BigDecimal bigDecimal = object = instructionIDType == null ? null : instructionIDType.getPayableAmountValue();
                    if (object != null) {
                        object2 = MathHelper.getPercentValue((BigDecimal)object, (BigDecimal)object3, (int)2, (RoundingMode)ROUNDING_MODE);
                        ebi40PaymentConditionsType.setMinimumPayment((BigDecimal)object2);
                    }
                }
            } else if (paymentTermsType.getSettlementDiscountPercent() != null) {
                if (paymentTermsType.getSettlementPeriod() == null || paymentTermsType.getSettlementPeriod().getEndDate() == null) {
                    errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("PaymentTerms[" + n3 + "]/SettlementPeriod")).errorText(AbstractToEbInterfaceConverter.EText.SETTLEMENT_PERIOD_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
                } else {
                    object4 = new Ebi40DiscountType();
                    object4.setPaymentDate(paymentTermsType.getSettlementPeriod().getEndDateValue());
                    object4.setPercentage(paymentTermsType.getSettlementDiscountPercentValue());
                    object4.setAmount(paymentTermsType.getAmountValue());
                    ebi40PaymentConditionsType.addDiscount((Ebi40DiscountType)object4);
                }
            } else if (paymentTermsType.getPenaltySurchargePercent() != null) {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("PaymentTerms[" + n3 + "]")).errorText(AbstractToEbInterfaceConverter.EText.PENALTY_NOT_ALLOWED.getDisplayText(this.m_aDisplayLocale))).build());
            }
            ++n3;
        }
        if (!commonsArrayList.isEmpty()) {
            ebi40PaymentConditionsType.setComment(StringHelper.getImploded((char)'\n', (Iterable)commonsArrayList));
        }
        if (ebi40PaymentConditionsType.getDueDate() == null) {
            if (ebi40PaymentConditionsType.hasDiscountEntries()) {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("PaymentMeans/PaymentDueDate")).errorText(AbstractToEbInterfaceConverter.EText.DISCOUNT_WITHOUT_DUEDATE.getDisplayText(this.m_aDisplayLocale))).build());
            }
        } else {
            ebi40InvoiceType.setPaymentConditions(ebi40PaymentConditionsType);
        }
    }
}

