/*
 * Decompiled with CFR 0.152.
 */
package at.austriapro.ebinterface.ubl.from;

import at.austriapro.ebinterface.ubl.from.AbstractToEbInterfaceConverter;
import at.austriapro.ebinterface.ubl.from.IToEbinterfaceSettings;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.datetime.XMLOffsetDate;
import com.helger.commons.error.SingleError;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.locale.country.CountryCache;
import com.helger.commons.math.MathHelper;
import com.helger.commons.regex.RegExHelper;
import com.helger.commons.string.StringHelper;
import com.helger.ebinterface.v41.Ebi41AccountType;
import com.helger.ebinterface.v41.Ebi41AddressIdentifierType;
import com.helger.ebinterface.v41.Ebi41AddressIdentifierTypeType;
import com.helger.ebinterface.v41.Ebi41AddressType;
import com.helger.ebinterface.v41.Ebi41CountryCodeType;
import com.helger.ebinterface.v41.Ebi41CountryType;
import com.helger.ebinterface.v41.Ebi41CurrencyType;
import com.helger.ebinterface.v41.Ebi41DeliveryType;
import com.helger.ebinterface.v41.Ebi41DirectDebitType;
import com.helger.ebinterface.v41.Ebi41DiscountType;
import com.helger.ebinterface.v41.Ebi41DocumentTypeType;
import com.helger.ebinterface.v41.Ebi41InvoiceType;
import com.helger.ebinterface.v41.Ebi41NoPaymentType;
import com.helger.ebinterface.v41.Ebi41PaymentConditionsType;
import com.helger.ebinterface.v41.Ebi41PaymentMethodType;
import com.helger.ebinterface.v41.Ebi41PaymentReferenceType;
import com.helger.ebinterface.v41.Ebi41RelatedDocumentType;
import com.helger.ebinterface.v41.Ebi41UniversalBankTransactionType;
import com.helger.xsds.ccts.cct.schemamodule.TextType;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.AddressType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.BillingReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.ContactType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.CustomerPartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.DeliveryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.DocumentReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.MonetaryTotalType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyIdentificationType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyLegalEntityType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyNameType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PaymentMeansType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PaymentTermsType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PersonType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.SupplierPartyType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.DescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.DocumentDescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.InstructionNoteType;

@Immutable
public abstract class AbstractToEbInterface41Converter
extends AbstractToEbInterfaceConverter {
    public static final int PAYMENT_REFERENCE_MAX_LENGTH = 35;

    protected AbstractToEbInterface41Converter(@Nonnull Locale locale, @Nonnull Locale locale2, @Nonnull IToEbinterfaceSettings iToEbinterfaceSettings) {
        super(locale, locale2, iToEbinterfaceSettings);
    }

    @Nullable
    public static Ebi41CountryCodeType getCountryCode(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return null;
        }
        String string2 = string.toUpperCase(Locale.US);
        for (Ebi41CountryCodeType ebi41CountryCodeType : Ebi41CountryCodeType.values()) {
            if (!ebi41CountryCodeType.name().equals(string2)) continue;
            return ebi41CountryCodeType;
        }
        return null;
    }

    @Nullable
    public static Ebi41CurrencyType getCurrencyCode(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return null;
        }
        String string2 = string.toUpperCase(Locale.US);
        for (Ebi41CurrencyType ebi41CurrencyType : Ebi41CurrencyType.values()) {
            if (!ebi41CurrencyType.name().equals(string2)) continue;
            return ebi41CurrencyType;
        }
        return null;
    }

    public static void setAddressData(@Nullable AddressType addressType, @Nonnull Ebi41AddressType ebi41AddressType, @Nonnull Locale locale) {
        if (addressType != null) {
            ebi41AddressType.setStreet(StringHelper.getImplodedNonEmpty((char)' ', (String[])new String[]{StringHelper.trim((String)addressType.getStreetNameValue()), StringHelper.trim((String)addressType.getBuildingNumberValue())}));
            ebi41AddressType.setPOBox(StringHelper.trim((String)addressType.getPostboxValue()));
            ebi41AddressType.setTown(StringHelper.trim((String)addressType.getCityNameValue()));
            ebi41AddressType.setZIP(StringHelper.trim((String)addressType.getPostalZoneValue()));
            if (addressType.getCountry() != null) {
                Locale locale2;
                Ebi41CountryType ebi41CountryType = new Ebi41CountryType();
                String string = StringHelper.trim((String)addressType.getCountry().getIdentificationCodeValue());
                ebi41CountryType.setCountryCode(AbstractToEbInterface41Converter.getCountryCode(string));
                String string2 = StringHelper.trim((String)addressType.getCountry().getNameValue());
                ebi41CountryType.setContent(string2);
                if (StringHelper.hasNoText((String)string2) && StringHelper.hasText((String)string) && (locale2 = CountryCache.getInstance().getCountry(string)) != null) {
                    ebi41CountryType.setContent(locale2.getDisplayCountry(locale));
                }
                ebi41AddressType.setCountry(ebi41CountryType);
            }
        }
    }

    public static void validateAddressData(@Nonnull Ebi41AddressType ebi41AddressType, @Nonnull String string, @Nonnull ErrorList errorList, @Nonnull Locale locale) {
        if (ebi41AddressType.getStreet() == null) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName(string + "/PostalAddress/StreetName")).errorText(AbstractToEbInterfaceConverter.EText.ADDRESS_NO_STREET.getDisplayText(locale))).build());
        }
        if (ebi41AddressType.getTown() == null) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName(string + "/PostalAddress/CityName")).errorText(AbstractToEbInterfaceConverter.EText.ADDRESS_NO_CITY.getDisplayText(locale))).build());
        }
        if (ebi41AddressType.getZIP() == null) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName(string + "/PostalAddress/PostalZone")).errorText(AbstractToEbInterfaceConverter.EText.ADDRESS_NO_ZIPCODE.getDisplayText(locale))).build());
        }
        if (ebi41AddressType.getCountry() == null) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName(string + "/PostalAddress/Country/IdentificationCode")).errorText(AbstractToEbInterfaceConverter.EText.ADDRESS_NO_COUNTRY.getDisplayText(locale))).build());
        }
    }

    @Nonnull
    public static Ebi41AddressType convertParty(@Nonnull PartyType partyType, @Nonnull String string, @Nonnull ErrorList errorList, @Nonnull Locale locale, @Nonnull Locale locale2, boolean bl) {
        Object object;
        PartyNameType partyNameType;
        Ebi41AddressType ebi41AddressType = new Ebi41AddressType();
        if (partyType.getPartyNameCount() > 1) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName(string + "/PartyName")).errorText(AbstractToEbInterfaceConverter.EText.MULTIPLE_PARTIES.getDisplayText(locale2))).build());
        }
        if ((partyNameType = (PartyNameType)CollectionHelper.getAtIndex((List)partyType.getPartyName(), (int)0)) != null) {
            ebi41AddressType.setName(StringHelper.trim((String)partyNameType.getNameValue()));
        }
        if (ebi41AddressType.getName() == null && partyType.hasPartyLegalEntityEntries()) {
            ebi41AddressType.setName(StringHelper.trim((String)partyType.getPartyLegalEntityAtIndex(0).getRegistrationNameValue()));
        }
        if (ebi41AddressType.getName() == null) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName(string)).errorText(AbstractToEbInterfaceConverter.EText.PARTY_NO_NAME.getDisplayText(locale2))).build());
        }
        AbstractToEbInterface41Converter.setAddressData(partyType.getPostalAddress(), ebi41AddressType, locale);
        ContactType contactType = partyType.getContact();
        if (contactType != null) {
            ebi41AddressType.setPhone(StringHelper.trim((String)contactType.getTelephoneValue()));
            ebi41AddressType.setEmail(StringHelper.trim((String)contactType.getElectronicMailValue()));
        }
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (contactType != null && StringHelper.hasTextAfterTrim((String)contactType.getNameValue())) {
            commonsArrayList.add((Object)StringHelper.trim((String)contactType.getNameValue()));
        }
        Object object2 = partyType.getPerson().iterator();
        while (object2.hasNext()) {
            object = (PersonType)object2.next();
            if (StringHelper.hasNoText((String)ebi41AddressType.getSalutation())) {
                ebi41AddressType.setSalutation(StringHelper.trim((String)object.getGenderCodeValue()));
            }
            commonsArrayList.add((Object)StringHelper.getImplodedNonEmpty((char)' ', (String[])new String[]{StringHelper.trim((String)object.getTitleValue()), StringHelper.trim((String)object.getFirstNameValue()), StringHelper.trim((String)object.getMiddleNameValue()), StringHelper.trim((String)object.getFamilyNameValue()), StringHelper.trim((String)object.getNameSuffixValue())}));
        }
        if (!commonsArrayList.isEmpty()) {
            ebi41AddressType.setContact(StringHelper.getImplodedNonEmpty((char)'\n', (Iterable)commonsArrayList));
        }
        if (partyType.getEndpointID() != null && StringHelper.hasText((String)(object2 = StringHelper.trim((String)partyType.getEndpointIDValue())))) {
            object = StringHelper.trim((String)partyType.getEndpointID().getSchemeID());
            for (PartyIdentificationType partyIdentificationType : Ebi41AddressIdentifierTypeType.values()) {
                if (!partyIdentificationType.value().equalsIgnoreCase((String)object)) continue;
                Ebi41AddressIdentifierType ebi41AddressIdentifierType = new Ebi41AddressIdentifierType();
                ebi41AddressIdentifierType.setAddressIdentifierType((Ebi41AddressIdentifierTypeType)partyIdentificationType);
                ebi41AddressIdentifierType.setValue((String)object2);
                ebi41AddressType.addAddressIdentifier(ebi41AddressIdentifierType);
            }
            if (ebi41AddressType.hasNoAddressIdentifierEntries()) {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName(string)).errorText(AbstractToEbInterfaceConverter.EText.PARTY_UNSUPPORTED_ENDPOINT.getDisplayTextWithArgs(locale2, new Object[]{object2, partyType.getEndpointID().getSchemeID()}))).build());
            }
        }
        if (ebi41AddressType.hasNoAddressIdentifierEntries()) {
            int n = 0;
            for (PartyIdentificationType partyIdentificationType : partyType.getPartyIdentification()) {
                String string2 = StringHelper.trim((String)partyIdentificationType.getIDValue());
                for (Ebi41AddressIdentifierTypeType ebi41AddressIdentifierTypeType : Ebi41AddressIdentifierTypeType.values()) {
                    if (!ebi41AddressIdentifierTypeType.value().equalsIgnoreCase(partyIdentificationType.getID().getSchemeID())) continue;
                    Ebi41AddressIdentifierType ebi41AddressIdentifierType = new Ebi41AddressIdentifierType();
                    ebi41AddressIdentifierType.setAddressIdentifierType(ebi41AddressIdentifierTypeType);
                    ebi41AddressIdentifierType.setValue(string2);
                    ebi41AddressType.addAddressIdentifier(ebi41AddressIdentifierType);
                }
                if (ebi41AddressType.hasNoAddressIdentifierEntries()) {
                    errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName(string + "/PartyIdentification[" + n + "]")).errorText(AbstractToEbInterfaceConverter.EText.PARTY_UNSUPPORTED_ADDRESS_IDENTIFIER.getDisplayTextWithArgs(locale2, new Object[]{string2, partyIdentificationType.getID().getSchemeID()}))).build());
                }
                ++n;
            }
        }
        if (bl) {
            AbstractToEbInterface41Converter.validateAddressData(ebi41AddressType, string, errorList, locale2);
        }
        return ebi41AddressType;
    }

    @Nonnull
    protected static String getAggregated(@Nonnull Iterable<DescriptionType> iterable) {
        return StringHelper.getImplodedMapped((char)'\n', iterable, TextType::getValue);
    }

    protected static boolean isAddressIncomplete(@Nonnull Ebi41AddressType ebi41AddressType) {
        return StringHelper.hasNoText((String)ebi41AddressType.getName()) || StringHelper.hasNoText((String)ebi41AddressType.getTown()) || StringHelper.hasNoText((String)ebi41AddressType.getZIP()) || ebi41AddressType.getCountry() == null;
    }

    @Nonnull
    public static Ebi41DeliveryType convertDelivery(@Nonnull DeliveryType deliveryType, @Nonnull String string, @Nullable CustomerPartyType customerPartyType, @Nonnull ErrorList errorList, @Nonnull Locale locale, @Nonnull Locale locale2) {
        AddressType addressType;
        Ebi41DeliveryType ebi41DeliveryType = new Ebi41DeliveryType();
        ebi41DeliveryType.setDeliveryID(deliveryType.getIDValue());
        ebi41DeliveryType.setDate(deliveryType.getActualDeliveryDateValue());
        PartyType partyType = deliveryType.getDeliveryParty();
        Ebi41AddressType ebi41AddressType = null;
        if (partyType != null) {
            ebi41AddressType = AbstractToEbInterface41Converter.convertParty(partyType, "DeliveryParty", errorList, locale, locale2, false);
            ebi41DeliveryType.setAddress(ebi41AddressType);
        }
        if ((ebi41AddressType == null || AbstractToEbInterface41Converter.isAddressIncomplete(ebi41AddressType)) && (addressType = deliveryType.getDeliveryAddress()) != null) {
            if (ebi41AddressType == null) {
                ebi41AddressType = new Ebi41AddressType();
            }
            AbstractToEbInterface41Converter.setAddressData(addressType, ebi41AddressType, locale);
            ebi41DeliveryType.setAddress(ebi41AddressType);
        }
        if ((addressType = deliveryType.getDeliveryLocation()) != null && addressType.getAddress() != null) {
            ebi41DeliveryType.setDescription(AbstractToEbInterface41Converter.getAggregated(addressType.getDescription()));
            if (ebi41AddressType == null || AbstractToEbInterface41Converter.isAddressIncomplete(ebi41AddressType)) {
                if (ebi41AddressType == null) {
                    ebi41AddressType = new Ebi41AddressType();
                }
                AbstractToEbInterface41Converter.setAddressData(addressType.getAddress(), ebi41AddressType, locale);
                ebi41DeliveryType.setAddress(ebi41AddressType);
            }
        }
        if (ebi41AddressType != null) {
            PartyNameType partyNameType;
            Iterator iterator;
            String string2 = null;
            if (deliveryType.getDeliveryParty() != null) {
                iterator = deliveryType.getDeliveryParty().getPartyName().iterator();
                while (iterator.hasNext() && !StringHelper.hasText((String)(string2 = StringHelper.trim((String)(partyNameType = (PartyNameType)iterator.next()).getNameValue())))) {
                }
            }
            if (StringHelper.hasNoText(string2) && addressType != null) {
                string2 = StringHelper.trim((String)addressType.getNameValue());
            }
            if (StringHelper.hasNoText(string2) && customerPartyType != null && customerPartyType.getParty() != null) {
                iterator = customerPartyType.getParty().getPartyName().iterator();
                while (iterator.hasNext() && !StringHelper.hasText((String)(string2 = StringHelper.trim((String)(partyNameType = (PartyNameType)iterator.next()).getNameValue())))) {
                }
                if (StringHelper.hasNoText((String)string2)) {
                    iterator = customerPartyType.getParty().getPartyLegalEntity().iterator();
                    while (iterator.hasNext() && !StringHelper.hasText((String)(string2 = StringHelper.trim((String)(partyNameType = (PartyLegalEntityType)iterator.next()).getRegistrationNameValue())))) {
                    }
                }
            }
            ebi41AddressType.setName(string2);
            if (StringHelper.hasNoText((String)ebi41AddressType.getName())) {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName(string + "/DeliveryParty")).errorText(AbstractToEbInterfaceConverter.EText.DELIVERY_WITHOUT_NAME.getDisplayText(locale2))).build());
            }
            AbstractToEbInterface41Converter.validateAddressData(ebi41AddressType, string + "/DeliveryParty", errorList, locale2);
        }
        return ebi41DeliveryType;
    }

    @Nullable
    protected static final Ebi41DocumentTypeType getAsDocumentTypeType(String ... stringArray) {
        if (stringArray != null) {
            for (String string : stringArray) {
                if (string == null) continue;
                String string2 = string.trim();
                try {
                    return Ebi41DocumentTypeType.fromValue((String)string2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if ("326".equals(string2)) {
                        return Ebi41DocumentTypeType.INVOICE_FOR_PARTIAL_DELIVERY;
                    }
                    if ("386".equals(string2)) {
                        return Ebi41DocumentTypeType.INVOICE_FOR_ADVANCE_PAYMENT;
                    }
                    if (!"389".equals(string2)) continue;
                    return Ebi41DocumentTypeType.SELF_BILLING;
                }
            }
        }
        return null;
    }

    protected static void convertRelatedDocuments(@Nonnull List<BillingReferenceType> list, @Nonnull Ebi41InvoiceType ebi41InvoiceType) {
        for (BillingReferenceType billingReferenceType : list) {
            Ebi41RelatedDocumentType ebi41RelatedDocumentType;
            if (billingReferenceType.getInvoiceDocumentReference() != null && billingReferenceType.getInvoiceDocumentReference().getIDValue() != null) {
                ebi41RelatedDocumentType = new Ebi41RelatedDocumentType();
                ebi41RelatedDocumentType.setInvoiceNumber(billingReferenceType.getInvoiceDocumentReference().getIDValue());
                ebi41RelatedDocumentType.setInvoiceDate(billingReferenceType.getInvoiceDocumentReference().getIssueDateValue());
                ebi41RelatedDocumentType.setDocumentType(Ebi41DocumentTypeType.INVOICE);
                ebi41InvoiceType.addRelatedDocument(ebi41RelatedDocumentType);
                continue;
            }
            if (billingReferenceType.getCreditNoteDocumentReference() == null || billingReferenceType.getCreditNoteDocumentReference().getIDValue() == null) continue;
            ebi41RelatedDocumentType = new Ebi41RelatedDocumentType();
            ebi41RelatedDocumentType.setInvoiceNumber(billingReferenceType.getCreditNoteDocumentReference().getIDValue());
            ebi41RelatedDocumentType.setInvoiceDate(billingReferenceType.getCreditNoteDocumentReference().getIssueDateValue());
            ebi41RelatedDocumentType.setDocumentType(Ebi41DocumentTypeType.CREDIT_MEMO);
            ebi41InvoiceType.addRelatedDocument(ebi41RelatedDocumentType);
        }
    }

    protected static void convertReferencedDocuments(@Nonnull List<DocumentReferenceType> list, @Nonnull Ebi41InvoiceType ebi41InvoiceType) {
        for (DocumentReferenceType documentReferenceType : list) {
            if (!StringHelper.hasText((String)documentReferenceType.getIDValue()) || documentReferenceType.getAttachment() != null) continue;
            Ebi41RelatedDocumentType ebi41RelatedDocumentType = new Ebi41RelatedDocumentType();
            ebi41RelatedDocumentType.setInvoiceNumber(documentReferenceType.getIDValue());
            ebi41RelatedDocumentType.setInvoiceDate(documentReferenceType.getIssueDateValue());
            CommonsArrayList commonsArrayList = new CommonsArrayList();
            for (DocumentDescriptionType documentDescriptionType : documentReferenceType.getDocumentDescription()) {
                commonsArrayList.add((Object)documentDescriptionType.getValue());
            }
            ebi41RelatedDocumentType.setComment(StringHelper.getImplodedNonEmpty((char)'\n', (Iterable)commonsArrayList));
            if (documentReferenceType.getDocumentTypeCode() != null) {
                ebi41RelatedDocumentType.setDocumentType(AbstractToEbInterface41Converter.getAsDocumentTypeType(documentReferenceType.getDocumentTypeCode().getName(), documentReferenceType.getDocumentTypeCodeValue()));
            }
            ebi41InvoiceType.addRelatedDocument(ebi41RelatedDocumentType);
        }
    }

    private static void _setPaymentMeansComment(@Nonnull PaymentMeansType paymentMeansType, @Nonnull Ebi41PaymentMethodType ebi41PaymentMethodType) {
        if (paymentMeansType.hasInstructionNoteEntries()) {
            CommonsArrayList commonsArrayList = new CommonsArrayList();
            for (InstructionNoteType instructionNoteType : paymentMeansType.getInstructionNote()) {
                commonsArrayList.add((Object)StringHelper.trim((String)instructionNoteType.getValue()));
            }
            if (commonsArrayList.isNotEmpty()) {
                ebi41PaymentMethodType.setComment(StringHelper.getImplodedNonEmpty((char)'\n', (Iterable)commonsArrayList));
            }
        }
    }

    protected void convertPayment(@Nonnull Supplier<XMLOffsetDate> supplier, @Nonnull Supplier<List<PaymentMeansType>> supplier2, @Nonnull Supplier<PartyType> supplier3, @Nonnull Supplier<SupplierPartyType> supplier4, @Nonnull Supplier<List<PaymentTermsType>> supplier5, @Nonnull Supplier<MonetaryTotalType> supplier6, @Nonnull ErrorList errorList, @Nonnull Ebi41InvoiceType ebi41InvoiceType, boolean bl) {
        Ebi41AccountType ebi41AccountType;
        Object object7;
        Object object2;
        Object object3;
        Ebi41UniversalBankTransactionType ebi41UniversalBankTransactionType2;
        Object object4;
        Ebi41PaymentMethodType ebi41PaymentMethodType = new Ebi41PaymentMethodType();
        Ebi41PaymentConditionsType ebi41PaymentConditionsType = new Ebi41PaymentConditionsType();
        int n = 0;
        for (PaymentMeansType object5 : supplier2.get()) {
            String string = StringHelper.trim((String)object5.getPaymentMeansCodeValue());
            if (AbstractToEbInterface41Converter.isUniversalBankTransaction(string)) {
                object4 = StringHelper.trim((String)object5.getPaymentChannelCodeValue());
                if (AbstractToEbInterface41Converter.isIBAN((String)object4)) {
                    PartyNameType partyNameType;
                    Object object6;
                    String string2;
                    String string3;
                    AbstractToEbInterface41Converter._setPaymentMeansComment(object5, ebi41PaymentMethodType);
                    ebi41UniversalBankTransactionType2 = new Ebi41UniversalBankTransactionType();
                    object3 = object5.getInstructionID();
                    if (object3 != null && StringHelper.hasText((String)(string3 = StringHelper.trim((String)object3.getValue())))) {
                        if (string3.length() > 35) {
                            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("PaymentMeans[" + n + "]/InstructionID")).errorText(AbstractToEbInterfaceConverter.EText.PAYMENT_ID_TOO_LONG_CUT.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{string3}))).build());
                            string3 = string3.substring(0, 35);
                        }
                        object2 = new Ebi41PaymentReferenceType();
                        object2.setValue(string3);
                        ebi41UniversalBankTransactionType2.setPaymentReference((Ebi41PaymentReferenceType)object2);
                    }
                    if (ebi41UniversalBankTransactionType2.getPaymentReference() == null) {
                        int n2 = 0;
                        for (Object object7 : object5.getPaymentID()) {
                            string2 = StringHelper.trim((String)object7.getValue());
                            if (StringHelper.hasText((String)string2)) {
                                if (string2.length() > 35) {
                                    errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("PaymentMeans[" + n + "]/PaymentID[" + n2 + "]")).errorText(AbstractToEbInterfaceConverter.EText.PAYMENT_ID_TOO_LONG_CUT.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{string2}))).build());
                                    string2 = string2.substring(0, 35);
                                }
                                object6 = new Ebi41PaymentReferenceType();
                                object6.setValue(string2);
                                ebi41UniversalBankTransactionType2.setPaymentReference(object6);
                            }
                            ++n2;
                        }
                    }
                    ebi41AccountType = new Ebi41AccountType();
                    object2 = object5.getPayeeFinancialAccount();
                    if (object2 != null && object2.getFinancialInstitutionBranch() != null && object2.getFinancialInstitutionBranch().getFinancialInstitution() != null && StringHelper.hasText((String)(object7 = object2.getFinancialInstitutionBranch().getFinancialInstitution()).getIDValue())) {
                        string2 = StringHelper.trim((String)object7.getID().getValue());
                        object6 = StringHelper.trim((String)object7.getID().getSchemeID());
                        boolean bl2 = AbstractToEbInterface41Converter.isBIC((String)object6);
                        if (bl2) {
                            ebi41AccountType.setBIC(string2);
                        } else {
                            ebi41AccountType.setBankName(string2);
                        }
                        if (bl2 && (StringHelper.hasNoText((String)string2) || !RegExHelper.stringMatchesPattern((String)"[0-9A-Za-z]{8}([0-9A-Za-z]{3})?", (String)string2))) {
                            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("PaymentMeans[" + n + "]/PayeeFinancialAccount/FinancialInstitutionBranch/FinancialInstitution/ID")).errorText(AbstractToEbInterfaceConverter.EText.BIC_INVALID.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{string2}))).build());
                            ebi41AccountType.setBIC(null);
                        }
                    }
                    object7 = object2 != null ? StringHelper.trim((String)object2.getIDValue()) : null;
                    ebi41AccountType.setIBAN((String)object7);
                    if (StringHelper.getLength((CharSequence)object7) > 34) {
                        errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("PaymentMeans[" + n + "]/PayeeFinancialAccount/ID")).errorText(AbstractToEbInterfaceConverter.EText.IBAN_TOO_LONG_STRIPPING.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{object7, 34}))).build());
                        ebi41AccountType.setIBAN(((String)object7).substring(0, 34));
                    }
                    String string4 = string2 = object2 != null ? object2.getNameValue() : null;
                    if (StringHelper.hasNoText((String)string2) && (object6 = supplier3.get()) != null) {
                        Iterator iterator = object6.getPartyName().iterator();
                        while (iterator.hasNext() && !StringHelper.hasText((String)(string2 = StringHelper.trim((String)(partyNameType = (PartyNameType)iterator.next()).getNameValue())))) {
                        }
                    }
                    if (StringHelper.hasNoText((String)string2) && (object6 = supplier4.get().getParty()) != null) {
                        Iterator iterator = object6.getPartyName().iterator();
                        while (iterator.hasNext() && !StringHelper.hasText((String)(string2 = StringHelper.trim((String)(partyNameType = (PartyNameType)iterator.next()).getNameValue())))) {
                        }
                    }
                    ebi41AccountType.setBankAccountOwner(string2);
                    ebi41UniversalBankTransactionType2.addBeneficiaryAccount(ebi41AccountType);
                    ebi41PaymentMethodType.setUniversalBankTransaction(ebi41UniversalBankTransactionType2);
                    ebi41InvoiceType.setPaymentMethod(ebi41PaymentMethodType);
                    ebi41PaymentConditionsType.setDueDate(object5.getPaymentDueDateValue());
                    break;
                }
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("PaymentMeans[" + n + "]")).errorText(AbstractToEbInterfaceConverter.EText.PAYMENTMEANS_UNSUPPORTED_CHANNELCODE.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{object4}))).build());
            } else {
                if (AbstractToEbInterface41Converter.isDirectDebit(string)) {
                    AbstractToEbInterface41Converter._setPaymentMeansComment(object5, ebi41PaymentMethodType);
                    object4 = new Ebi41DirectDebitType();
                    ebi41PaymentMethodType.setDirectDebit((Ebi41DirectDebitType)object4);
                    ebi41InvoiceType.setPaymentMethod(ebi41PaymentMethodType);
                    ebi41PaymentConditionsType.setDueDate(object5.getPaymentDueDateValue());
                    break;
                }
                if (AbstractToEbInterface41Converter.isSEPADirectDebit(string)) {
                    AbstractToEbInterface41Converter._setPaymentMeansComment(object5, ebi41PaymentMethodType);
                    object4 = new Ebi41DirectDebitType();
                    ebi41PaymentMethodType.setDirectDebit((Ebi41DirectDebitType)object4);
                    ebi41InvoiceType.setPaymentMethod(ebi41PaymentMethodType);
                    ebi41PaymentConditionsType.setDueDate(object5.getPaymentDueDateValue());
                    break;
                }
                if (MathHelper.isEQ0((BigDecimal)ebi41InvoiceType.getPayableAmount())) {
                    AbstractToEbInterface41Converter._setPaymentMeansComment(object5, ebi41PaymentMethodType);
                    object4 = new Ebi41NoPaymentType();
                    ebi41PaymentMethodType.setNoPayment((Ebi41NoPaymentType)object4);
                    break;
                }
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("PaymentMeans[" + n + "]")).errorText(AbstractToEbInterfaceConverter.EText.PAYMENTMEANS_CODE_INVALID.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{string, this.getOrString(", ", "30", "31", "42", "58"), this.getOrString(", ", "49", "59")}))).build());
            }
            ++n;
        }
        if (ebi41InvoiceType.getPaymentMethod() == null && this.m_aSettings.isInvoicePaymentMethodMandatory()) {
            if (bl) {
                Ebi41NoPaymentType ebi41NoPaymentType = new Ebi41NoPaymentType();
                ebi41PaymentMethodType.setNoPayment(ebi41NoPaymentType);
                ebi41InvoiceType.setPaymentMethod(ebi41PaymentMethodType);
            } else {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName(bl ? "CreditNote" : "Invoice")).errorText(AbstractToEbInterfaceConverter.EText.ERB_NO_PAYMENT_METHOD.getDisplayText(this.m_aDisplayLocale))).build());
            }
        }
        if (ebi41PaymentConditionsType.getDueDate() == null) {
            ebi41PaymentConditionsType.setDueDate(supplier.get());
        }
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        int n3 = 0;
        for (PaymentTermsType paymentTermsType : supplier5.get()) {
            for (Ebi41UniversalBankTransactionType ebi41UniversalBankTransactionType2 : paymentTermsType.getNote()) {
                object3 = StringHelper.trim((String)ebi41UniversalBankTransactionType2.getValue());
                if (!StringHelper.hasText((String)object3)) continue;
                commonsArrayList.add(object3);
            }
            if (paymentTermsType.getPaymentDueDate() != null) {
                object4 = paymentTermsType.getPaymentDueDateValue();
                ebi41UniversalBankTransactionType2 = ebi41PaymentConditionsType.getDueDate();
                if (object4 != null && ebi41UniversalBankTransactionType2 != null) {
                    if (!ebi41UniversalBankTransactionType2.equals(object4)) {
                        errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("PaymentTerms[" + n3 + "]/PaymentDueDate")).errorText(AbstractToEbInterfaceConverter.EText.PAYMENT_DUE_DATE_ALREADY_CONTAINED.getDisplayText(this.m_aDisplayLocale))).build());
                    }
                } else {
                    ebi41PaymentConditionsType.setDueDate((XMLOffsetDate)object4);
                }
                if ((object3 = paymentTermsType.getPaymentPercentValue()) != null && MathHelper.isGT0((BigDecimal)object3) && MathHelper.isLT100((BigDecimal)object3)) {
                    ebi41AccountType = supplier6.get();
                    BigDecimal bigDecimal = object2 = ebi41AccountType == null ? null : ebi41AccountType.getPayableAmountValue();
                    if (object2 != null) {
                        object7 = MathHelper.getPercentValue((BigDecimal)object2, (BigDecimal)object3, (int)2, (RoundingMode)ROUNDING_MODE);
                        ebi41PaymentConditionsType.setMinimumPayment((BigDecimal)object7);
                    }
                }
            } else if (paymentTermsType.getSettlementDiscountPercent() != null) {
                if (paymentTermsType.getSettlementPeriod() == null || paymentTermsType.getSettlementPeriod().getEndDate() == null) {
                    errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("PaymentTerms[" + n3 + "]/SettlementPeriod")).errorText(AbstractToEbInterfaceConverter.EText.SETTLEMENT_PERIOD_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
                } else {
                    object4 = new Ebi41DiscountType();
                    object4.setPaymentDate(paymentTermsType.getSettlementPeriod().getEndDateValue());
                    object4.setPercentage(paymentTermsType.getSettlementDiscountPercentValue());
                    object4.setAmount(paymentTermsType.getAmountValue());
                    ebi41PaymentConditionsType.addDiscount((Ebi41DiscountType)object4);
                }
            } else if (paymentTermsType.getPenaltySurchargePercent() != null) {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("PaymentTerms[" + n3 + "]")).errorText(AbstractToEbInterfaceConverter.EText.PENALTY_NOT_ALLOWED.getDisplayText(this.m_aDisplayLocale))).build());
            }
            ++n3;
        }
        if (!commonsArrayList.isEmpty()) {
            ebi41PaymentConditionsType.setComment(StringHelper.getImploded((char)'\n', (Iterable)commonsArrayList));
        }
        if (ebi41PaymentConditionsType.getDueDate() == null) {
            if (ebi41PaymentConditionsType.hasDiscountEntries()) {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("PaymentMeans/PaymentDueDate")).errorText(AbstractToEbInterfaceConverter.EText.DISCOUNT_WITHOUT_DUEDATE.getDisplayText(this.m_aDisplayLocale))).build());
            }
        } else {
            ebi41InvoiceType.setPaymentConditions(ebi41PaymentConditionsType);
        }
    }
}

