/*
 * Decompiled with CFR 0.152.
 */
package at.austriapro.ebinterface.ubl.from;

import at.austriapro.ebinterface.ubl.from.AbstractToEbInterfaceConverter;
import at.austriapro.ebinterface.ubl.from.IToEbinterfaceSettings;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.datetime.XMLOffsetDate;
import com.helger.commons.error.SingleError;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.locale.country.CountryCache;
import com.helger.commons.math.MathHelper;
import com.helger.commons.regex.RegExHelper;
import com.helger.commons.string.StringHelper;
import com.helger.ebinterface.v42.Ebi42AccountType;
import com.helger.ebinterface.v42.Ebi42AddressIdentifierType;
import com.helger.ebinterface.v42.Ebi42AddressIdentifierTypeType;
import com.helger.ebinterface.v42.Ebi42AddressType;
import com.helger.ebinterface.v42.Ebi42CountryType;
import com.helger.ebinterface.v42.Ebi42DeliveryType;
import com.helger.ebinterface.v42.Ebi42DirectDebitType;
import com.helger.ebinterface.v42.Ebi42DiscountType;
import com.helger.ebinterface.v42.Ebi42DocumentTypeType;
import com.helger.ebinterface.v42.Ebi42InvoiceType;
import com.helger.ebinterface.v42.Ebi42NoPaymentType;
import com.helger.ebinterface.v42.Ebi42PaymentConditionsType;
import com.helger.ebinterface.v42.Ebi42PaymentMethodType;
import com.helger.ebinterface.v42.Ebi42PaymentReferenceType;
import com.helger.ebinterface.v42.Ebi42RelatedDocumentType;
import com.helger.ebinterface.v42.Ebi42UniversalBankTransactionType;
import com.helger.xsds.ccts.cct.schemamodule.TextType;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.AddressType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.BillingReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.ContactType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.CustomerPartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.DeliveryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.DocumentReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.MonetaryTotalType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyIdentificationType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyLegalEntityType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyNameType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PaymentMeansType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PaymentTermsType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PersonType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.SupplierPartyType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.DescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.DocumentDescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.InstructionNoteType;

@Immutable
public abstract class AbstractToEbInterface42Converter
extends AbstractToEbInterfaceConverter {
    public static final int PAYMENT_REFERENCE_MAX_LENGTH = 35;

    protected AbstractToEbInterface42Converter(@Nonnull Locale locale, @Nonnull Locale locale2, @Nonnull IToEbinterfaceSettings iToEbinterfaceSettings) {
        super(locale, locale2, iToEbinterfaceSettings);
    }

    public static void setAddressData(@Nullable AddressType addressType, @Nonnull Ebi42AddressType ebi42AddressType, @Nonnull Locale locale) {
        if (addressType != null) {
            ebi42AddressType.setStreet(StringHelper.getImplodedNonEmpty((char)' ', (String[])new String[]{StringHelper.trim((String)addressType.getStreetNameValue()), StringHelper.trim((String)addressType.getBuildingNumberValue())}));
            ebi42AddressType.setPOBox(StringHelper.trim((String)addressType.getPostboxValue()));
            ebi42AddressType.setTown(StringHelper.trim((String)addressType.getCityNameValue()));
            ebi42AddressType.setZIP(StringHelper.trim((String)addressType.getPostalZoneValue()));
            if (addressType.getCountry() != null) {
                Locale locale2;
                Ebi42CountryType ebi42CountryType = new Ebi42CountryType();
                String string = StringHelper.trim((String)addressType.getCountry().getIdentificationCodeValue());
                ebi42CountryType.setCountryCode(string);
                String string2 = StringHelper.trim((String)addressType.getCountry().getNameValue());
                ebi42CountryType.setValue(string2);
                if (StringHelper.hasNoText((String)string2) && StringHelper.hasText((String)string) && (locale2 = CountryCache.getInstance().getCountry(string)) != null) {
                    ebi42CountryType.setValue(locale2.getDisplayCountry(locale));
                }
                ebi42AddressType.setCountry(ebi42CountryType);
            }
        }
    }

    public static void validateAddressData(@Nonnull Ebi42AddressType ebi42AddressType, @Nonnull String string, @Nonnull ErrorList errorList, @Nonnull Locale locale) {
        if (ebi42AddressType.getStreet() == null) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName(string + "/PostalAddress/StreetName")).errorText(AbstractToEbInterfaceConverter.EText.ADDRESS_NO_STREET.getDisplayText(locale))).build());
        }
        if (ebi42AddressType.getTown() == null) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName(string + "/PostalAddress/CityName")).errorText(AbstractToEbInterfaceConverter.EText.ADDRESS_NO_CITY.getDisplayText(locale))).build());
        }
        if (ebi42AddressType.getZIP() == null) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName(string + "/PostalAddress/PostalZone")).errorText(AbstractToEbInterfaceConverter.EText.ADDRESS_NO_ZIPCODE.getDisplayText(locale))).build());
        }
        if (ebi42AddressType.getCountry() == null) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName(string + "/PostalAddress/Country/IdentificationCode")).errorText(AbstractToEbInterfaceConverter.EText.ADDRESS_NO_COUNTRY.getDisplayText(locale))).build());
        }
    }

    @Nonnull
    public static Ebi42AddressType convertParty(@Nonnull PartyType partyType, @Nonnull String string, @Nonnull ErrorList errorList, @Nonnull Locale locale, @Nonnull Locale locale2, boolean bl) {
        Object object;
        PartyNameType partyNameType;
        Ebi42AddressType ebi42AddressType = new Ebi42AddressType();
        if (partyType.getPartyNameCount() > 1) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName(string + "/PartyName")).errorText(AbstractToEbInterfaceConverter.EText.MULTIPLE_PARTIES.getDisplayText(locale2))).build());
        }
        if ((partyNameType = (PartyNameType)CollectionHelper.getAtIndex((List)partyType.getPartyName(), (int)0)) != null) {
            ebi42AddressType.setName(StringHelper.trim((String)partyNameType.getNameValue()));
        }
        if (ebi42AddressType.getName() == null && partyType.hasPartyLegalEntityEntries()) {
            ebi42AddressType.setName(StringHelper.trim((String)partyType.getPartyLegalEntityAtIndex(0).getRegistrationNameValue()));
        }
        if (ebi42AddressType.getName() == null) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName(string)).errorText(AbstractToEbInterfaceConverter.EText.PARTY_NO_NAME.getDisplayText(locale2))).build());
        }
        AbstractToEbInterface42Converter.setAddressData(partyType.getPostalAddress(), ebi42AddressType, locale);
        ContactType contactType = partyType.getContact();
        if (contactType != null) {
            ebi42AddressType.setPhone(StringHelper.trim((String)contactType.getTelephoneValue()));
            ebi42AddressType.setEmail(StringHelper.trim((String)contactType.getElectronicMailValue()));
        }
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (contactType != null && StringHelper.hasTextAfterTrim((String)contactType.getNameValue())) {
            commonsArrayList.add((Object)StringHelper.trim((String)contactType.getNameValue()));
        }
        Object object2 = partyType.getPerson().iterator();
        while (object2.hasNext()) {
            object = (PersonType)object2.next();
            if (StringHelper.hasNoText((String)ebi42AddressType.getSalutation())) {
                ebi42AddressType.setSalutation(StringHelper.trim((String)object.getGenderCodeValue()));
            }
            commonsArrayList.add((Object)StringHelper.getImplodedNonEmpty((char)' ', (String[])new String[]{StringHelper.trim((String)object.getTitleValue()), StringHelper.trim((String)object.getFirstNameValue()), StringHelper.trim((String)object.getMiddleNameValue()), StringHelper.trim((String)object.getFamilyNameValue()), StringHelper.trim((String)object.getNameSuffixValue())}));
        }
        if (!commonsArrayList.isEmpty()) {
            ebi42AddressType.setContact(StringHelper.getImplodedNonEmpty((char)'\n', (Iterable)commonsArrayList));
        }
        if (partyType.getEndpointID() != null && StringHelper.hasText((String)(object2 = StringHelper.trim((String)partyType.getEndpointIDValue())))) {
            object = StringHelper.trim((String)partyType.getEndpointID().getSchemeID());
            for (PartyIdentificationType partyIdentificationType : Ebi42AddressIdentifierTypeType.values()) {
                if (!partyIdentificationType.value().equalsIgnoreCase((String)object)) continue;
                Ebi42AddressIdentifierType ebi42AddressIdentifierType = new Ebi42AddressIdentifierType();
                ebi42AddressIdentifierType.setAddressIdentifierType((Ebi42AddressIdentifierTypeType)partyIdentificationType);
                ebi42AddressIdentifierType.setValue((String)object2);
                ebi42AddressType.addAddressIdentifier(ebi42AddressIdentifierType);
            }
            if (ebi42AddressType.hasNoAddressIdentifierEntries()) {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName(string)).errorText(AbstractToEbInterfaceConverter.EText.PARTY_UNSUPPORTED_ENDPOINT.getDisplayTextWithArgs(locale2, new Object[]{object2, partyType.getEndpointID().getSchemeID()}))).build());
            }
        }
        if (ebi42AddressType.hasNoAddressIdentifierEntries()) {
            int n = 0;
            for (PartyIdentificationType partyIdentificationType : partyType.getPartyIdentification()) {
                String string2 = StringHelper.trim((String)partyIdentificationType.getIDValue());
                for (Ebi42AddressIdentifierTypeType ebi42AddressIdentifierTypeType : Ebi42AddressIdentifierTypeType.values()) {
                    if (!ebi42AddressIdentifierTypeType.value().equalsIgnoreCase(partyIdentificationType.getID().getSchemeID())) continue;
                    Ebi42AddressIdentifierType ebi42AddressIdentifierType = new Ebi42AddressIdentifierType();
                    ebi42AddressIdentifierType.setAddressIdentifierType(ebi42AddressIdentifierTypeType);
                    ebi42AddressIdentifierType.setValue(string2);
                    ebi42AddressType.addAddressIdentifier(ebi42AddressIdentifierType);
                }
                if (ebi42AddressType.hasNoAddressIdentifierEntries()) {
                    errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName(string + "/PartyIdentification[" + n + "]")).errorText(AbstractToEbInterfaceConverter.EText.PARTY_UNSUPPORTED_ADDRESS_IDENTIFIER.getDisplayTextWithArgs(locale2, new Object[]{string2, partyIdentificationType.getID().getSchemeID()}))).build());
                }
                ++n;
            }
        }
        if (bl) {
            AbstractToEbInterface42Converter.validateAddressData(ebi42AddressType, string, errorList, locale2);
        }
        return ebi42AddressType;
    }

    @Nonnull
    protected static String getAggregated(@Nonnull Iterable<DescriptionType> iterable) {
        return StringHelper.getImplodedMapped((char)'\n', iterable, TextType::getValue);
    }

    protected static boolean isAddressIncomplete(@Nonnull Ebi42AddressType ebi42AddressType) {
        return StringHelper.hasNoText((String)ebi42AddressType.getName()) || StringHelper.hasNoText((String)ebi42AddressType.getTown()) || StringHelper.hasNoText((String)ebi42AddressType.getZIP()) || ebi42AddressType.getCountry() == null;
    }

    @Nonnull
    public static Ebi42DeliveryType convertDelivery(@Nonnull DeliveryType deliveryType, @Nonnull String string, @Nullable CustomerPartyType customerPartyType, @Nonnull ErrorList errorList, @Nonnull Locale locale, @Nonnull Locale locale2) {
        AddressType addressType;
        Ebi42DeliveryType ebi42DeliveryType = new Ebi42DeliveryType();
        ebi42DeliveryType.setDeliveryID(deliveryType.getIDValue());
        ebi42DeliveryType.setDate(deliveryType.getActualDeliveryDateValue());
        PartyType partyType = deliveryType.getDeliveryParty();
        Ebi42AddressType ebi42AddressType = null;
        if (partyType != null) {
            ebi42AddressType = AbstractToEbInterface42Converter.convertParty(partyType, "DeliveryParty", errorList, locale, locale2, false);
            ebi42DeliveryType.setAddress(ebi42AddressType);
        }
        if ((ebi42AddressType == null || AbstractToEbInterface42Converter.isAddressIncomplete(ebi42AddressType)) && (addressType = deliveryType.getDeliveryAddress()) != null) {
            if (ebi42AddressType == null) {
                ebi42AddressType = new Ebi42AddressType();
            }
            AbstractToEbInterface42Converter.setAddressData(addressType, ebi42AddressType, locale);
            ebi42DeliveryType.setAddress(ebi42AddressType);
        }
        if ((addressType = deliveryType.getDeliveryLocation()) != null && addressType.getAddress() != null) {
            ebi42DeliveryType.setDescription(AbstractToEbInterface42Converter.getAggregated(addressType.getDescription()));
            if (ebi42AddressType == null || AbstractToEbInterface42Converter.isAddressIncomplete(ebi42AddressType)) {
                if (ebi42AddressType == null) {
                    ebi42AddressType = new Ebi42AddressType();
                }
                AbstractToEbInterface42Converter.setAddressData(addressType.getAddress(), ebi42AddressType, locale);
                ebi42DeliveryType.setAddress(ebi42AddressType);
            }
        }
        if (ebi42AddressType != null) {
            PartyNameType partyNameType;
            Iterator iterator;
            String string2 = null;
            if (deliveryType.getDeliveryParty() != null) {
                iterator = deliveryType.getDeliveryParty().getPartyName().iterator();
                while (iterator.hasNext() && !StringHelper.hasText((String)(string2 = StringHelper.trim((String)(partyNameType = (PartyNameType)iterator.next()).getNameValue())))) {
                }
            }
            if (StringHelper.hasNoText(string2) && addressType != null) {
                string2 = StringHelper.trim((String)addressType.getNameValue());
            }
            if (StringHelper.hasNoText(string2) && customerPartyType != null && customerPartyType.getParty() != null) {
                iterator = customerPartyType.getParty().getPartyName().iterator();
                while (iterator.hasNext() && !StringHelper.hasText((String)(string2 = StringHelper.trim((String)(partyNameType = (PartyNameType)iterator.next()).getNameValue())))) {
                }
                if (StringHelper.hasNoText((String)string2)) {
                    iterator = customerPartyType.getParty().getPartyLegalEntity().iterator();
                    while (iterator.hasNext() && !StringHelper.hasText((String)(string2 = StringHelper.trim((String)(partyNameType = (PartyLegalEntityType)iterator.next()).getRegistrationNameValue())))) {
                    }
                }
            }
            ebi42AddressType.setName(string2);
            if (StringHelper.hasNoText((String)ebi42AddressType.getName())) {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName(string + "/DeliveryParty")).errorText(AbstractToEbInterfaceConverter.EText.DELIVERY_WITHOUT_NAME.getDisplayText(locale2))).build());
            }
            AbstractToEbInterface42Converter.validateAddressData(ebi42AddressType, string + "/DeliveryParty", errorList, locale2);
        }
        return ebi42DeliveryType;
    }

    @Nullable
    protected static final Ebi42DocumentTypeType getAsDocumentTypeType(String ... stringArray) {
        if (stringArray != null) {
            for (String string : stringArray) {
                if (string == null) continue;
                String string2 = string.trim();
                try {
                    return Ebi42DocumentTypeType.fromValue((String)string2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if ("326".equals(string2)) {
                        return Ebi42DocumentTypeType.INVOICE_FOR_PARTIAL_DELIVERY;
                    }
                    if ("386".equals(string2)) {
                        return Ebi42DocumentTypeType.INVOICE_FOR_ADVANCE_PAYMENT;
                    }
                    if (!"389".equals(string2)) continue;
                    return Ebi42DocumentTypeType.SELF_BILLING;
                }
            }
        }
        return null;
    }

    protected static void convertRelatedDocuments(@Nonnull List<BillingReferenceType> list, @Nonnull Ebi42InvoiceType ebi42InvoiceType) {
        for (BillingReferenceType billingReferenceType : list) {
            Ebi42RelatedDocumentType ebi42RelatedDocumentType;
            if (billingReferenceType.getInvoiceDocumentReference() != null && billingReferenceType.getInvoiceDocumentReference().getIDValue() != null) {
                ebi42RelatedDocumentType = new Ebi42RelatedDocumentType();
                ebi42RelatedDocumentType.setInvoiceNumber(billingReferenceType.getInvoiceDocumentReference().getIDValue());
                ebi42RelatedDocumentType.setInvoiceDate(billingReferenceType.getInvoiceDocumentReference().getIssueDateValue());
                ebi42RelatedDocumentType.setDocumentType(Ebi42DocumentTypeType.INVOICE);
                ebi42InvoiceType.addRelatedDocument(ebi42RelatedDocumentType);
                continue;
            }
            if (billingReferenceType.getCreditNoteDocumentReference() == null || billingReferenceType.getCreditNoteDocumentReference().getIDValue() == null) continue;
            ebi42RelatedDocumentType = new Ebi42RelatedDocumentType();
            ebi42RelatedDocumentType.setInvoiceNumber(billingReferenceType.getCreditNoteDocumentReference().getIDValue());
            ebi42RelatedDocumentType.setInvoiceDate(billingReferenceType.getCreditNoteDocumentReference().getIssueDateValue());
            ebi42RelatedDocumentType.setDocumentType(Ebi42DocumentTypeType.CREDIT_MEMO);
            ebi42InvoiceType.addRelatedDocument(ebi42RelatedDocumentType);
        }
    }

    protected static void convertReferencedDocuments(@Nonnull List<DocumentReferenceType> list, @Nonnull Ebi42InvoiceType ebi42InvoiceType) {
        for (DocumentReferenceType documentReferenceType : list) {
            if (!StringHelper.hasText((String)documentReferenceType.getIDValue()) || documentReferenceType.getAttachment() != null) continue;
            Ebi42RelatedDocumentType ebi42RelatedDocumentType = new Ebi42RelatedDocumentType();
            ebi42RelatedDocumentType.setInvoiceNumber(documentReferenceType.getIDValue());
            ebi42RelatedDocumentType.setInvoiceDate(documentReferenceType.getIssueDateValue());
            CommonsArrayList commonsArrayList = new CommonsArrayList();
            for (DocumentDescriptionType documentDescriptionType : documentReferenceType.getDocumentDescription()) {
                commonsArrayList.add((Object)documentDescriptionType.getValue());
            }
            ebi42RelatedDocumentType.setComment(StringHelper.getImplodedNonEmpty((char)'\n', (Iterable)commonsArrayList));
            if (documentReferenceType.getDocumentTypeCode() != null) {
                ebi42RelatedDocumentType.setDocumentType(AbstractToEbInterface42Converter.getAsDocumentTypeType(documentReferenceType.getDocumentTypeCode().getName(), documentReferenceType.getDocumentTypeCodeValue()));
            }
            ebi42InvoiceType.addRelatedDocument(ebi42RelatedDocumentType);
        }
    }

    private static void _setPaymentMeansComment(@Nonnull PaymentMeansType paymentMeansType, @Nonnull Ebi42PaymentMethodType ebi42PaymentMethodType) {
        if (paymentMeansType.hasInstructionNoteEntries()) {
            CommonsArrayList commonsArrayList = new CommonsArrayList();
            for (InstructionNoteType instructionNoteType : paymentMeansType.getInstructionNote()) {
                commonsArrayList.add((Object)StringHelper.trim((String)instructionNoteType.getValue()));
            }
            if (commonsArrayList.isNotEmpty()) {
                ebi42PaymentMethodType.setComment(StringHelper.getImplodedNonEmpty((char)'\n', (Iterable)commonsArrayList));
            }
        }
    }

    protected void convertPayment(@Nonnull Supplier<XMLOffsetDate> supplier, @Nonnull Supplier<List<PaymentMeansType>> supplier2, @Nonnull Supplier<PartyType> supplier3, @Nonnull Supplier<SupplierPartyType> supplier4, @Nonnull Supplier<List<PaymentTermsType>> supplier5, @Nonnull Supplier<MonetaryTotalType> supplier6, @Nonnull ErrorList errorList, @Nonnull Ebi42InvoiceType ebi42InvoiceType, boolean bl) {
        Ebi42AccountType ebi42AccountType;
        Object object7;
        Object object2;
        Object object3;
        Ebi42UniversalBankTransactionType ebi42UniversalBankTransactionType2;
        Object object4;
        Ebi42PaymentMethodType ebi42PaymentMethodType = new Ebi42PaymentMethodType();
        Ebi42PaymentConditionsType ebi42PaymentConditionsType = new Ebi42PaymentConditionsType();
        int n = 0;
        for (PaymentMeansType object5 : supplier2.get()) {
            String string = StringHelper.trim((String)object5.getPaymentMeansCodeValue());
            if (AbstractToEbInterface42Converter.isUniversalBankTransaction(string)) {
                object4 = StringHelper.trim((String)object5.getPaymentChannelCodeValue());
                if (AbstractToEbInterface42Converter.isIBAN((String)object4)) {
                    PartyNameType partyNameType;
                    Object object6;
                    String string2;
                    String string3;
                    AbstractToEbInterface42Converter._setPaymentMeansComment(object5, ebi42PaymentMethodType);
                    ebi42UniversalBankTransactionType2 = new Ebi42UniversalBankTransactionType();
                    object3 = object5.getInstructionID();
                    if (object3 != null && StringHelper.hasText((String)(string3 = StringHelper.trim((String)object3.getValue())))) {
                        if (string3.length() > 35) {
                            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("PaymentMeans[" + n + "]/InstructionID")).errorText(AbstractToEbInterfaceConverter.EText.PAYMENT_ID_TOO_LONG_CUT.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{string3}))).build());
                            string3 = string3.substring(0, 35);
                        }
                        object2 = new Ebi42PaymentReferenceType();
                        object2.setValue(string3);
                        ebi42UniversalBankTransactionType2.setPaymentReference((Ebi42PaymentReferenceType)object2);
                    }
                    if (ebi42UniversalBankTransactionType2.getPaymentReference() == null) {
                        int n2 = 0;
                        for (Object object7 : object5.getPaymentID()) {
                            string2 = StringHelper.trim((String)object7.getValue());
                            if (StringHelper.hasText((String)string2)) {
                                if (string2.length() > 35) {
                                    errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("PaymentMeans[" + n + "]/PaymentID[" + n2 + "]")).errorText(AbstractToEbInterfaceConverter.EText.PAYMENT_ID_TOO_LONG_CUT.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{string2}))).build());
                                    string2 = string2.substring(0, 35);
                                }
                                object6 = new Ebi42PaymentReferenceType();
                                object6.setValue(string2);
                                ebi42UniversalBankTransactionType2.setPaymentReference(object6);
                            }
                            ++n2;
                        }
                    }
                    ebi42AccountType = new Ebi42AccountType();
                    object2 = object5.getPayeeFinancialAccount();
                    if (object2 != null && object2.getFinancialInstitutionBranch() != null && object2.getFinancialInstitutionBranch().getFinancialInstitution() != null && StringHelper.hasText((String)(object7 = object2.getFinancialInstitutionBranch().getFinancialInstitution()).getIDValue())) {
                        string2 = StringHelper.trim((String)object7.getID().getValue());
                        object6 = StringHelper.trim((String)object7.getID().getSchemeID());
                        boolean bl2 = AbstractToEbInterface42Converter.isBIC((String)object6);
                        if (bl2) {
                            ebi42AccountType.setBIC(string2);
                        } else {
                            ebi42AccountType.setBankName(string2);
                        }
                        if (bl2 && (StringHelper.hasNoText((String)string2) || !RegExHelper.stringMatchesPattern((String)"[0-9A-Za-z]{8}([0-9A-Za-z]{3})?", (String)string2))) {
                            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("PaymentMeans[" + n + "]/PayeeFinancialAccount/FinancialInstitutionBranch/FinancialInstitution/ID")).errorText(AbstractToEbInterfaceConverter.EText.BIC_INVALID.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{string2}))).build());
                            ebi42AccountType.setBIC(null);
                        }
                    }
                    object7 = object2 != null ? StringHelper.trim((String)object2.getIDValue()) : null;
                    ebi42AccountType.setIBAN((String)object7);
                    if (StringHelper.getLength((CharSequence)object7) > 34) {
                        errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("PaymentMeans[" + n + "]/PayeeFinancialAccount/ID")).errorText(AbstractToEbInterfaceConverter.EText.IBAN_TOO_LONG_STRIPPING.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{object7, 34}))).build());
                        ebi42AccountType.setIBAN(((String)object7).substring(0, 34));
                    }
                    String string4 = string2 = object2 != null ? object2.getNameValue() : null;
                    if (StringHelper.hasNoText((String)string2) && (object6 = supplier3.get()) != null) {
                        Iterator iterator = object6.getPartyName().iterator();
                        while (iterator.hasNext() && !StringHelper.hasText((String)(string2 = StringHelper.trim((String)(partyNameType = (PartyNameType)iterator.next()).getNameValue())))) {
                        }
                    }
                    if (StringHelper.hasNoText((String)string2) && (object6 = supplier4.get().getParty()) != null) {
                        Iterator iterator = object6.getPartyName().iterator();
                        while (iterator.hasNext() && !StringHelper.hasText((String)(string2 = StringHelper.trim((String)(partyNameType = (PartyNameType)iterator.next()).getNameValue())))) {
                        }
                    }
                    ebi42AccountType.setBankAccountOwner(string2);
                    ebi42UniversalBankTransactionType2.addBeneficiaryAccount(ebi42AccountType);
                    ebi42PaymentMethodType.setUniversalBankTransaction(ebi42UniversalBankTransactionType2);
                    ebi42InvoiceType.setPaymentMethod(ebi42PaymentMethodType);
                    ebi42PaymentConditionsType.setDueDate(object5.getPaymentDueDateValue());
                    break;
                }
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("PaymentMeans[" + n + "]")).errorText(AbstractToEbInterfaceConverter.EText.PAYMENTMEANS_UNSUPPORTED_CHANNELCODE.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{object4}))).build());
            } else {
                if (AbstractToEbInterface42Converter.isDirectDebit(string)) {
                    AbstractToEbInterface42Converter._setPaymentMeansComment(object5, ebi42PaymentMethodType);
                    object4 = new Ebi42DirectDebitType();
                    ebi42PaymentMethodType.setDirectDebit((Ebi42DirectDebitType)object4);
                    ebi42InvoiceType.setPaymentMethod(ebi42PaymentMethodType);
                    ebi42PaymentConditionsType.setDueDate(object5.getPaymentDueDateValue());
                    break;
                }
                if (AbstractToEbInterface42Converter.isSEPADirectDebit(string)) {
                    AbstractToEbInterface42Converter._setPaymentMeansComment(object5, ebi42PaymentMethodType);
                    object4 = new Ebi42DirectDebitType();
                    ebi42PaymentMethodType.setDirectDebit((Ebi42DirectDebitType)object4);
                    ebi42InvoiceType.setPaymentMethod(ebi42PaymentMethodType);
                    ebi42PaymentConditionsType.setDueDate(object5.getPaymentDueDateValue());
                    break;
                }
                if (MathHelper.isEQ0((BigDecimal)ebi42InvoiceType.getPayableAmount())) {
                    AbstractToEbInterface42Converter._setPaymentMeansComment(object5, ebi42PaymentMethodType);
                    object4 = new Ebi42NoPaymentType();
                    ebi42PaymentMethodType.setNoPayment((Ebi42NoPaymentType)object4);
                    break;
                }
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("PaymentMeans[" + n + "]")).errorText(AbstractToEbInterfaceConverter.EText.PAYMENTMEANS_CODE_INVALID.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{string, this.getOrString(", ", "30", "31", "42", "58"), this.getOrString(", ", "49", "59")}))).build());
            }
            ++n;
        }
        if (ebi42InvoiceType.getPaymentMethod() == null && this.m_aSettings.isInvoicePaymentMethodMandatory()) {
            if (bl) {
                Ebi42NoPaymentType ebi42NoPaymentType = new Ebi42NoPaymentType();
                ebi42PaymentMethodType.setNoPayment(ebi42NoPaymentType);
                ebi42InvoiceType.setPaymentMethod(ebi42PaymentMethodType);
            } else {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName(bl ? "CreditNote" : "Invoice")).errorText(AbstractToEbInterfaceConverter.EText.ERB_NO_PAYMENT_METHOD.getDisplayText(this.m_aDisplayLocale))).build());
            }
        }
        if (ebi42PaymentConditionsType.getDueDate() == null) {
            ebi42PaymentConditionsType.setDueDate(supplier.get());
        }
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        int n3 = 0;
        for (PaymentTermsType paymentTermsType : supplier5.get()) {
            for (Ebi42UniversalBankTransactionType ebi42UniversalBankTransactionType2 : paymentTermsType.getNote()) {
                object3 = StringHelper.trim((String)ebi42UniversalBankTransactionType2.getValue());
                if (!StringHelper.hasText((String)object3)) continue;
                commonsArrayList.add(object3);
            }
            if (paymentTermsType.getPaymentDueDate() != null) {
                object4 = paymentTermsType.getPaymentDueDateValue();
                ebi42UniversalBankTransactionType2 = ebi42PaymentConditionsType.getDueDate();
                if (object4 != null && ebi42UniversalBankTransactionType2 != null) {
                    if (!ebi42UniversalBankTransactionType2.equals(object4)) {
                        errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("PaymentTerms[" + n3 + "]/PaymentDueDate")).errorText(AbstractToEbInterfaceConverter.EText.PAYMENT_DUE_DATE_ALREADY_CONTAINED.getDisplayText(this.m_aDisplayLocale))).build());
                    }
                } else {
                    ebi42PaymentConditionsType.setDueDate((XMLOffsetDate)object4);
                }
                if ((object3 = paymentTermsType.getPaymentPercentValue()) != null && MathHelper.isGT0((BigDecimal)object3) && MathHelper.isLT100((BigDecimal)object3)) {
                    ebi42AccountType = supplier6.get();
                    BigDecimal bigDecimal = object2 = ebi42AccountType == null ? null : ebi42AccountType.getPayableAmountValue();
                    if (object2 != null) {
                        object7 = MathHelper.getPercentValue((BigDecimal)object2, (BigDecimal)object3, (int)2, (RoundingMode)ROUNDING_MODE);
                        ebi42PaymentConditionsType.setMinimumPayment((BigDecimal)object7);
                    }
                }
            } else if (paymentTermsType.getSettlementDiscountPercent() != null) {
                if (paymentTermsType.getSettlementPeriod() == null || paymentTermsType.getSettlementPeriod().getEndDate() == null) {
                    errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("PaymentTerms[" + n3 + "]/SettlementPeriod")).errorText(AbstractToEbInterfaceConverter.EText.SETTLEMENT_PERIOD_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
                } else {
                    object4 = new Ebi42DiscountType();
                    object4.setPaymentDate(paymentTermsType.getSettlementPeriod().getEndDateValue());
                    object4.setPercentage(paymentTermsType.getSettlementDiscountPercentValue());
                    object4.setAmount(paymentTermsType.getAmountValue());
                    ebi42PaymentConditionsType.addDiscount((Ebi42DiscountType)object4);
                }
            } else if (paymentTermsType.getPenaltySurchargePercent() != null) {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("PaymentTerms[" + n3 + "]")).errorText(AbstractToEbInterfaceConverter.EText.PENALTY_NOT_ALLOWED.getDisplayText(this.m_aDisplayLocale))).build());
            }
            ++n3;
        }
        if (!commonsArrayList.isEmpty()) {
            ebi42PaymentConditionsType.setComment(StringHelper.getImploded((char)'\n', (Iterable)commonsArrayList));
        }
        if (ebi42PaymentConditionsType.getDueDate() == null) {
            if (ebi42PaymentConditionsType.hasDiscountEntries()) {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("PaymentMeans/PaymentDueDate")).errorText(AbstractToEbInterfaceConverter.EText.DISCOUNT_WITHOUT_DUEDATE.getDisplayText(this.m_aDisplayLocale))).build());
            }
        } else {
            ebi42InvoiceType.setPaymentConditions(ebi42PaymentConditionsType);
        }
    }
}

