/*
 * Decompiled with CFR 0.152.
 */
package at.austriapro.ebinterface.ubl.from;

import at.austriapro.ebinterface.ubl.from.AbstractToEbInterfaceConverter;
import at.austriapro.ebinterface.ubl.from.IToEbinterfaceSettings;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.datetime.XMLOffsetDate;
import com.helger.commons.error.SingleError;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.locale.country.CountryCache;
import com.helger.commons.math.MathHelper;
import com.helger.commons.regex.RegExHelper;
import com.helger.commons.string.StringHelper;
import com.helger.ebinterface.v43.Ebi43AccountType;
import com.helger.ebinterface.v43.Ebi43AddressIdentifierType;
import com.helger.ebinterface.v43.Ebi43AddressIdentifierTypeType;
import com.helger.ebinterface.v43.Ebi43AddressType;
import com.helger.ebinterface.v43.Ebi43CountryType;
import com.helger.ebinterface.v43.Ebi43DeliveryType;
import com.helger.ebinterface.v43.Ebi43DirectDebitType;
import com.helger.ebinterface.v43.Ebi43DiscountType;
import com.helger.ebinterface.v43.Ebi43DocumentTypeType;
import com.helger.ebinterface.v43.Ebi43InvoiceType;
import com.helger.ebinterface.v43.Ebi43NoPaymentType;
import com.helger.ebinterface.v43.Ebi43PaymentConditionsType;
import com.helger.ebinterface.v43.Ebi43PaymentMethodType;
import com.helger.ebinterface.v43.Ebi43PaymentReferenceType;
import com.helger.ebinterface.v43.Ebi43RelatedDocumentType;
import com.helger.ebinterface.v43.Ebi43UniversalBankTransactionType;
import com.helger.xsds.ccts.cct.schemamodule.TextType;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.AddressType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.BillingReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.ContactType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.CustomerPartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.DeliveryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.DocumentReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.MonetaryTotalType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyIdentificationType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyLegalEntityType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyNameType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PaymentMeansType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PaymentTermsType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PersonType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.SupplierPartyType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.DescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.DocumentDescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.InstructionNoteType;

@Immutable
public abstract class AbstractToEbInterface43Converter
extends AbstractToEbInterfaceConverter {
    public static final int PAYMENT_REFERENCE_MAX_LENGTH = 35;

    protected AbstractToEbInterface43Converter(@Nonnull Locale locale, @Nonnull Locale locale2, @Nonnull IToEbinterfaceSettings iToEbinterfaceSettings) {
        super(locale, locale2, iToEbinterfaceSettings);
    }

    public static void setAddressData(@Nullable AddressType addressType, @Nonnull Ebi43AddressType ebi43AddressType, @Nonnull Locale locale) {
        if (addressType != null) {
            ebi43AddressType.setStreet(StringHelper.getImplodedNonEmpty((char)' ', (String[])new String[]{StringHelper.trim((String)addressType.getStreetNameValue()), StringHelper.trim((String)addressType.getBuildingNumberValue())}));
            ebi43AddressType.setPOBox(StringHelper.trim((String)addressType.getPostboxValue()));
            ebi43AddressType.setTown(StringHelper.trim((String)addressType.getCityNameValue()));
            ebi43AddressType.setZIP(StringHelper.trim((String)addressType.getPostalZoneValue()));
            if (addressType.getCountry() != null) {
                Locale locale2;
                Ebi43CountryType ebi43CountryType = new Ebi43CountryType();
                String string = StringHelper.trim((String)addressType.getCountry().getIdentificationCodeValue());
                ebi43CountryType.setCountryCode(string);
                String string2 = StringHelper.trim((String)addressType.getCountry().getNameValue());
                ebi43CountryType.setValue(string2);
                if (StringHelper.hasNoText((String)string2) && StringHelper.hasText((String)string) && (locale2 = CountryCache.getInstance().getCountry(string)) != null) {
                    ebi43CountryType.setValue(locale2.getDisplayCountry(locale));
                }
                ebi43AddressType.setCountry(ebi43CountryType);
            }
        }
    }

    public static void validateAddressData(@Nonnull Ebi43AddressType ebi43AddressType, @Nonnull String string, @Nonnull ErrorList errorList, @Nonnull Locale locale) {
        if (ebi43AddressType.getStreet() == null) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName(string + "/PostalAddress/StreetName")).errorText(AbstractToEbInterfaceConverter.EText.ADDRESS_NO_STREET.getDisplayText(locale))).build());
        }
        if (ebi43AddressType.getTown() == null) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName(string + "/PostalAddress/CityName")).errorText(AbstractToEbInterfaceConverter.EText.ADDRESS_NO_CITY.getDisplayText(locale))).build());
        }
        if (ebi43AddressType.getZIP() == null) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName(string + "/PostalAddress/PostalZone")).errorText(AbstractToEbInterfaceConverter.EText.ADDRESS_NO_ZIPCODE.getDisplayText(locale))).build());
        }
        if (ebi43AddressType.getCountry() == null) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName(string + "/PostalAddress/Country/IdentificationCode")).errorText(AbstractToEbInterfaceConverter.EText.ADDRESS_NO_COUNTRY.getDisplayText(locale))).build());
        }
    }

    @Nonnull
    public static Ebi43AddressType convertParty(@Nonnull PartyType partyType, @Nonnull String string, @Nonnull ErrorList errorList, @Nonnull Locale locale, @Nonnull Locale locale2, boolean bl) {
        Object object;
        PartyNameType partyNameType;
        Ebi43AddressType ebi43AddressType = new Ebi43AddressType();
        if (partyType.getPartyNameCount() > 1) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName(string + "/PartyName")).errorText(AbstractToEbInterfaceConverter.EText.MULTIPLE_PARTIES.getDisplayText(locale2))).build());
        }
        if ((partyNameType = (PartyNameType)CollectionHelper.getAtIndex((List)partyType.getPartyName(), (int)0)) != null) {
            ebi43AddressType.setName(StringHelper.trim((String)partyNameType.getNameValue()));
        }
        if (ebi43AddressType.getName() == null && partyType.hasPartyLegalEntityEntries()) {
            ebi43AddressType.setName(StringHelper.trim((String)partyType.getPartyLegalEntityAtIndex(0).getRegistrationNameValue()));
        }
        if (ebi43AddressType.getName() == null) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName(string)).errorText(AbstractToEbInterfaceConverter.EText.PARTY_NO_NAME.getDisplayText(locale2))).build());
        }
        AbstractToEbInterface43Converter.setAddressData(partyType.getPostalAddress(), ebi43AddressType, locale);
        ContactType contactType = partyType.getContact();
        if (contactType != null) {
            ebi43AddressType.setPhone(StringHelper.trim((String)contactType.getTelephoneValue()));
            ebi43AddressType.setEmail(StringHelper.trim((String)contactType.getElectronicMailValue()));
        }
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (contactType != null && StringHelper.hasTextAfterTrim((String)contactType.getNameValue())) {
            commonsArrayList.add((Object)StringHelper.trim((String)contactType.getNameValue()));
        }
        Object object2 = partyType.getPerson().iterator();
        while (object2.hasNext()) {
            object = (PersonType)object2.next();
            if (StringHelper.hasNoText((String)ebi43AddressType.getSalutation())) {
                ebi43AddressType.setSalutation(StringHelper.trim((String)object.getGenderCodeValue()));
            }
            commonsArrayList.add((Object)StringHelper.getImplodedNonEmpty((char)' ', (String[])new String[]{StringHelper.trim((String)object.getTitleValue()), StringHelper.trim((String)object.getFirstNameValue()), StringHelper.trim((String)object.getMiddleNameValue()), StringHelper.trim((String)object.getFamilyNameValue()), StringHelper.trim((String)object.getNameSuffixValue())}));
        }
        if (!commonsArrayList.isEmpty()) {
            ebi43AddressType.setContact(StringHelper.getImplodedNonEmpty((char)'\n', (Iterable)commonsArrayList));
        }
        if (partyType.getEndpointID() != null && StringHelper.hasText((String)(object2 = StringHelper.trim((String)partyType.getEndpointIDValue())))) {
            object = StringHelper.trim((String)partyType.getEndpointID().getSchemeID());
            for (PartyIdentificationType partyIdentificationType : Ebi43AddressIdentifierTypeType.values()) {
                if (!partyIdentificationType.value().equalsIgnoreCase((String)object)) continue;
                Ebi43AddressIdentifierType ebi43AddressIdentifierType = new Ebi43AddressIdentifierType();
                ebi43AddressIdentifierType.setAddressIdentifierType((Ebi43AddressIdentifierTypeType)partyIdentificationType);
                ebi43AddressIdentifierType.setValue((String)object2);
                ebi43AddressType.addAddressIdentifier(ebi43AddressIdentifierType);
            }
            if (ebi43AddressType.hasNoAddressIdentifierEntries()) {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName(string)).errorText(AbstractToEbInterfaceConverter.EText.PARTY_UNSUPPORTED_ENDPOINT.getDisplayTextWithArgs(locale2, new Object[]{object2, partyType.getEndpointID().getSchemeID()}))).build());
            }
        }
        if (ebi43AddressType.hasNoAddressIdentifierEntries()) {
            int n = 0;
            for (PartyIdentificationType partyIdentificationType : partyType.getPartyIdentification()) {
                String string2 = StringHelper.trim((String)partyIdentificationType.getIDValue());
                for (Ebi43AddressIdentifierTypeType ebi43AddressIdentifierTypeType : Ebi43AddressIdentifierTypeType.values()) {
                    if (!ebi43AddressIdentifierTypeType.value().equalsIgnoreCase(partyIdentificationType.getID().getSchemeID())) continue;
                    Ebi43AddressIdentifierType ebi43AddressIdentifierType = new Ebi43AddressIdentifierType();
                    ebi43AddressIdentifierType.setAddressIdentifierType(ebi43AddressIdentifierTypeType);
                    ebi43AddressIdentifierType.setValue(string2);
                    ebi43AddressType.addAddressIdentifier(ebi43AddressIdentifierType);
                }
                if (ebi43AddressType.hasNoAddressIdentifierEntries()) {
                    errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName(string + "/PartyIdentification[" + n + "]")).errorText(AbstractToEbInterfaceConverter.EText.PARTY_UNSUPPORTED_ADDRESS_IDENTIFIER.getDisplayTextWithArgs(locale2, new Object[]{string2, partyIdentificationType.getID().getSchemeID()}))).build());
                }
                ++n;
            }
        }
        if (bl) {
            AbstractToEbInterface43Converter.validateAddressData(ebi43AddressType, string, errorList, locale2);
        }
        return ebi43AddressType;
    }

    @Nonnull
    protected static String getAggregated(@Nonnull Iterable<DescriptionType> iterable) {
        return StringHelper.getImplodedMapped((char)'\n', iterable, TextType::getValue);
    }

    protected static boolean isAddressIncomplete(@Nonnull Ebi43AddressType ebi43AddressType) {
        return StringHelper.hasNoText((String)ebi43AddressType.getName()) || StringHelper.hasNoText((String)ebi43AddressType.getTown()) || StringHelper.hasNoText((String)ebi43AddressType.getZIP()) || ebi43AddressType.getCountry() == null;
    }

    @Nonnull
    public static Ebi43DeliveryType convertDelivery(@Nonnull DeliveryType deliveryType, @Nonnull String string, @Nullable CustomerPartyType customerPartyType, @Nonnull ErrorList errorList, @Nonnull Locale locale, @Nonnull Locale locale2) {
        AddressType addressType;
        Ebi43DeliveryType ebi43DeliveryType = new Ebi43DeliveryType();
        ebi43DeliveryType.setDeliveryID(deliveryType.getIDValue());
        ebi43DeliveryType.setDate(deliveryType.getActualDeliveryDateValue());
        PartyType partyType = deliveryType.getDeliveryParty();
        Ebi43AddressType ebi43AddressType = null;
        if (partyType != null) {
            ebi43AddressType = AbstractToEbInterface43Converter.convertParty(partyType, "DeliveryParty", errorList, locale, locale2, false);
            ebi43DeliveryType.setAddress(ebi43AddressType);
        }
        if ((ebi43AddressType == null || AbstractToEbInterface43Converter.isAddressIncomplete(ebi43AddressType)) && (addressType = deliveryType.getDeliveryAddress()) != null) {
            if (ebi43AddressType == null) {
                ebi43AddressType = new Ebi43AddressType();
            }
            AbstractToEbInterface43Converter.setAddressData(addressType, ebi43AddressType, locale);
            ebi43DeliveryType.setAddress(ebi43AddressType);
        }
        if ((addressType = deliveryType.getDeliveryLocation()) != null && addressType.getAddress() != null) {
            ebi43DeliveryType.setDescription(AbstractToEbInterface43Converter.getAggregated(addressType.getDescription()));
            if (ebi43AddressType == null || AbstractToEbInterface43Converter.isAddressIncomplete(ebi43AddressType)) {
                if (ebi43AddressType == null) {
                    ebi43AddressType = new Ebi43AddressType();
                }
                AbstractToEbInterface43Converter.setAddressData(addressType.getAddress(), ebi43AddressType, locale);
                ebi43DeliveryType.setAddress(ebi43AddressType);
            }
        }
        if (ebi43AddressType != null) {
            PartyNameType partyNameType;
            Iterator iterator;
            String string2 = null;
            if (deliveryType.getDeliveryParty() != null) {
                iterator = deliveryType.getDeliveryParty().getPartyName().iterator();
                while (iterator.hasNext() && !StringHelper.hasText((String)(string2 = StringHelper.trim((String)(partyNameType = (PartyNameType)iterator.next()).getNameValue())))) {
                }
            }
            if (StringHelper.hasNoText(string2) && addressType != null) {
                string2 = StringHelper.trim((String)addressType.getNameValue());
            }
            if (StringHelper.hasNoText(string2) && customerPartyType != null && customerPartyType.getParty() != null) {
                iterator = customerPartyType.getParty().getPartyName().iterator();
                while (iterator.hasNext() && !StringHelper.hasText((String)(string2 = StringHelper.trim((String)(partyNameType = (PartyNameType)iterator.next()).getNameValue())))) {
                }
                if (StringHelper.hasNoText((String)string2)) {
                    iterator = customerPartyType.getParty().getPartyLegalEntity().iterator();
                    while (iterator.hasNext() && !StringHelper.hasText((String)(string2 = StringHelper.trim((String)(partyNameType = (PartyLegalEntityType)iterator.next()).getRegistrationNameValue())))) {
                    }
                }
            }
            ebi43AddressType.setName(string2);
            if (StringHelper.hasNoText((String)ebi43AddressType.getName())) {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName(string + "/DeliveryParty")).errorText(AbstractToEbInterfaceConverter.EText.DELIVERY_WITHOUT_NAME.getDisplayText(locale2))).build());
            }
            AbstractToEbInterface43Converter.validateAddressData(ebi43AddressType, string + "/DeliveryParty", errorList, locale2);
        }
        return ebi43DeliveryType;
    }

    @Nullable
    protected static final Ebi43DocumentTypeType getAsDocumentTypeType(String ... stringArray) {
        if (stringArray != null) {
            for (String string : stringArray) {
                if (string == null) continue;
                String string2 = string.trim();
                try {
                    return Ebi43DocumentTypeType.fromValue((String)string2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if ("326".equals(string2)) {
                        return Ebi43DocumentTypeType.INVOICE_FOR_PARTIAL_DELIVERY;
                    }
                    if ("386".equals(string2)) {
                        return Ebi43DocumentTypeType.INVOICE_FOR_ADVANCE_PAYMENT;
                    }
                    if (!"389".equals(string2)) continue;
                    return Ebi43DocumentTypeType.SELF_BILLING;
                }
            }
        }
        return null;
    }

    protected static void convertRelatedDocuments(@Nonnull List<BillingReferenceType> list, @Nonnull Ebi43InvoiceType ebi43InvoiceType) {
        for (BillingReferenceType billingReferenceType : list) {
            Ebi43RelatedDocumentType ebi43RelatedDocumentType;
            if (billingReferenceType.getInvoiceDocumentReference() != null && billingReferenceType.getInvoiceDocumentReference().getIDValue() != null) {
                ebi43RelatedDocumentType = new Ebi43RelatedDocumentType();
                ebi43RelatedDocumentType.setInvoiceNumber(billingReferenceType.getInvoiceDocumentReference().getIDValue());
                ebi43RelatedDocumentType.setInvoiceDate(billingReferenceType.getInvoiceDocumentReference().getIssueDateValue());
                ebi43RelatedDocumentType.setDocumentType(Ebi43DocumentTypeType.INVOICE);
                ebi43InvoiceType.addRelatedDocument(ebi43RelatedDocumentType);
                continue;
            }
            if (billingReferenceType.getCreditNoteDocumentReference() == null || billingReferenceType.getCreditNoteDocumentReference().getIDValue() == null) continue;
            ebi43RelatedDocumentType = new Ebi43RelatedDocumentType();
            ebi43RelatedDocumentType.setInvoiceNumber(billingReferenceType.getCreditNoteDocumentReference().getIDValue());
            ebi43RelatedDocumentType.setInvoiceDate(billingReferenceType.getCreditNoteDocumentReference().getIssueDateValue());
            ebi43RelatedDocumentType.setDocumentType(Ebi43DocumentTypeType.CREDIT_MEMO);
            ebi43InvoiceType.addRelatedDocument(ebi43RelatedDocumentType);
        }
    }

    protected static void convertReferencedDocuments(@Nonnull List<DocumentReferenceType> list, @Nonnull Ebi43InvoiceType ebi43InvoiceType) {
        for (DocumentReferenceType documentReferenceType : list) {
            if (!StringHelper.hasText((String)documentReferenceType.getIDValue()) || documentReferenceType.getAttachment() != null) continue;
            Ebi43RelatedDocumentType ebi43RelatedDocumentType = new Ebi43RelatedDocumentType();
            ebi43RelatedDocumentType.setInvoiceNumber(documentReferenceType.getIDValue());
            ebi43RelatedDocumentType.setInvoiceDate(documentReferenceType.getIssueDateValue());
            CommonsArrayList commonsArrayList = new CommonsArrayList();
            for (DocumentDescriptionType documentDescriptionType : documentReferenceType.getDocumentDescription()) {
                commonsArrayList.add((Object)documentDescriptionType.getValue());
            }
            ebi43RelatedDocumentType.setComment(StringHelper.getImplodedNonEmpty((char)'\n', (Iterable)commonsArrayList));
            if (documentReferenceType.getDocumentTypeCode() != null) {
                ebi43RelatedDocumentType.setDocumentType(AbstractToEbInterface43Converter.getAsDocumentTypeType(documentReferenceType.getDocumentTypeCode().getName(), documentReferenceType.getDocumentTypeCodeValue()));
            }
            ebi43InvoiceType.addRelatedDocument(ebi43RelatedDocumentType);
        }
    }

    private static void _setPaymentMeansComment(@Nonnull PaymentMeansType paymentMeansType, @Nonnull Ebi43PaymentMethodType ebi43PaymentMethodType) {
        if (paymentMeansType.hasInstructionNoteEntries()) {
            CommonsArrayList commonsArrayList = new CommonsArrayList();
            for (InstructionNoteType instructionNoteType : paymentMeansType.getInstructionNote()) {
                commonsArrayList.add((Object)StringHelper.trim((String)instructionNoteType.getValue()));
            }
            if (commonsArrayList.isNotEmpty()) {
                ebi43PaymentMethodType.setComment(StringHelper.getImplodedNonEmpty((char)'\n', (Iterable)commonsArrayList));
            }
        }
    }

    protected void convertPayment(@Nonnull Supplier<XMLOffsetDate> supplier, @Nonnull Supplier<List<PaymentMeansType>> supplier2, @Nonnull Supplier<PartyType> supplier3, @Nonnull Supplier<SupplierPartyType> supplier4, @Nonnull Supplier<List<PaymentTermsType>> supplier5, @Nonnull Supplier<MonetaryTotalType> supplier6, @Nonnull ErrorList errorList, @Nonnull Ebi43InvoiceType ebi43InvoiceType, boolean bl) {
        Ebi43AccountType ebi43AccountType;
        Object object7;
        Object object2;
        Object object3;
        Ebi43UniversalBankTransactionType ebi43UniversalBankTransactionType2;
        Object object4;
        Ebi43PaymentMethodType ebi43PaymentMethodType = new Ebi43PaymentMethodType();
        Ebi43PaymentConditionsType ebi43PaymentConditionsType = new Ebi43PaymentConditionsType();
        int n = 0;
        for (PaymentMeansType object5 : supplier2.get()) {
            String string = StringHelper.trim((String)object5.getPaymentMeansCodeValue());
            if (AbstractToEbInterface43Converter.isUniversalBankTransaction(string)) {
                object4 = StringHelper.trim((String)object5.getPaymentChannelCodeValue());
                if (AbstractToEbInterface43Converter.isIBAN((String)object4)) {
                    PartyNameType partyNameType;
                    Object object6;
                    String string2;
                    String string3;
                    AbstractToEbInterface43Converter._setPaymentMeansComment(object5, ebi43PaymentMethodType);
                    ebi43UniversalBankTransactionType2 = new Ebi43UniversalBankTransactionType();
                    object3 = object5.getInstructionID();
                    if (object3 != null && StringHelper.hasText((String)(string3 = StringHelper.trim((String)object3.getValue())))) {
                        if (string3.length() > 35) {
                            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("PaymentMeans[" + n + "]/InstructionID")).errorText(AbstractToEbInterfaceConverter.EText.PAYMENT_ID_TOO_LONG_CUT.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{string3}))).build());
                            string3 = string3.substring(0, 35);
                        }
                        object2 = new Ebi43PaymentReferenceType();
                        object2.setValue(string3);
                        ebi43UniversalBankTransactionType2.setPaymentReference((Ebi43PaymentReferenceType)object2);
                    }
                    if (ebi43UniversalBankTransactionType2.getPaymentReference() == null) {
                        int n2 = 0;
                        for (Object object7 : object5.getPaymentID()) {
                            string2 = StringHelper.trim((String)object7.getValue());
                            if (StringHelper.hasText((String)string2)) {
                                if (string2.length() > 35) {
                                    errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("PaymentMeans[" + n + "]/PaymentID[" + n2 + "]")).errorText(AbstractToEbInterfaceConverter.EText.PAYMENT_ID_TOO_LONG_CUT.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{string2}))).build());
                                    string2 = string2.substring(0, 35);
                                }
                                object6 = new Ebi43PaymentReferenceType();
                                object6.setValue(string2);
                                ebi43UniversalBankTransactionType2.setPaymentReference(object6);
                            }
                            ++n2;
                        }
                    }
                    ebi43AccountType = new Ebi43AccountType();
                    object2 = object5.getPayeeFinancialAccount();
                    if (object2 != null && object2.getFinancialInstitutionBranch() != null && object2.getFinancialInstitutionBranch().getFinancialInstitution() != null && StringHelper.hasText((String)(object7 = object2.getFinancialInstitutionBranch().getFinancialInstitution()).getIDValue())) {
                        string2 = StringHelper.trim((String)object7.getID().getValue());
                        object6 = StringHelper.trim((String)object7.getID().getSchemeID());
                        boolean bl2 = AbstractToEbInterface43Converter.isBIC((String)object6);
                        if (bl2) {
                            ebi43AccountType.setBIC(string2);
                        } else {
                            ebi43AccountType.setBankName(string2);
                        }
                        if (bl2 && (StringHelper.hasNoText((String)string2) || !RegExHelper.stringMatchesPattern((String)"[0-9A-Za-z]{8}([0-9A-Za-z]{3})?", (String)string2))) {
                            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("PaymentMeans[" + n + "]/PayeeFinancialAccount/FinancialInstitutionBranch/FinancialInstitution/ID")).errorText(AbstractToEbInterfaceConverter.EText.BIC_INVALID.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{string2}))).build());
                            ebi43AccountType.setBIC(null);
                        }
                    }
                    object7 = object2 != null ? StringHelper.trim((String)object2.getIDValue()) : null;
                    ebi43AccountType.setIBAN((String)object7);
                    if (StringHelper.getLength((CharSequence)object7) > 34) {
                        errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("PaymentMeans[" + n + "]/PayeeFinancialAccount/ID")).errorText(AbstractToEbInterfaceConverter.EText.IBAN_TOO_LONG_STRIPPING.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{object7, 34}))).build());
                        ebi43AccountType.setIBAN(((String)object7).substring(0, 34));
                    }
                    String string4 = string2 = object2 != null ? object2.getNameValue() : null;
                    if (StringHelper.hasNoText((String)string2) && (object6 = supplier3.get()) != null) {
                        Iterator iterator = object6.getPartyName().iterator();
                        while (iterator.hasNext() && !StringHelper.hasText((String)(string2 = StringHelper.trim((String)(partyNameType = (PartyNameType)iterator.next()).getNameValue())))) {
                        }
                    }
                    if (StringHelper.hasNoText((String)string2) && (object6 = supplier4.get().getParty()) != null) {
                        Iterator iterator = object6.getPartyName().iterator();
                        while (iterator.hasNext() && !StringHelper.hasText((String)(string2 = StringHelper.trim((String)(partyNameType = (PartyNameType)iterator.next()).getNameValue())))) {
                        }
                    }
                    ebi43AccountType.setBankAccountOwner(string2);
                    ebi43UniversalBankTransactionType2.addBeneficiaryAccount(ebi43AccountType);
                    ebi43PaymentMethodType.setUniversalBankTransaction(ebi43UniversalBankTransactionType2);
                    ebi43InvoiceType.setPaymentMethod(ebi43PaymentMethodType);
                    ebi43PaymentConditionsType.setDueDate(object5.getPaymentDueDateValue());
                    break;
                }
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("PaymentMeans[" + n + "]")).errorText(AbstractToEbInterfaceConverter.EText.PAYMENTMEANS_UNSUPPORTED_CHANNELCODE.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{object4}))).build());
            } else {
                if (AbstractToEbInterface43Converter.isDirectDebit(string)) {
                    AbstractToEbInterface43Converter._setPaymentMeansComment(object5, ebi43PaymentMethodType);
                    object4 = new Ebi43DirectDebitType();
                    ebi43PaymentMethodType.setDirectDebit((Ebi43DirectDebitType)object4);
                    ebi43InvoiceType.setPaymentMethod(ebi43PaymentMethodType);
                    ebi43PaymentConditionsType.setDueDate(object5.getPaymentDueDateValue());
                    break;
                }
                if (AbstractToEbInterface43Converter.isSEPADirectDebit(string)) {
                    AbstractToEbInterface43Converter._setPaymentMeansComment(object5, ebi43PaymentMethodType);
                    object4 = new Ebi43DirectDebitType();
                    ebi43PaymentMethodType.setDirectDebit((Ebi43DirectDebitType)object4);
                    ebi43InvoiceType.setPaymentMethod(ebi43PaymentMethodType);
                    ebi43PaymentConditionsType.setDueDate(object5.getPaymentDueDateValue());
                    break;
                }
                if (MathHelper.isEQ0((BigDecimal)ebi43InvoiceType.getPayableAmount())) {
                    AbstractToEbInterface43Converter._setPaymentMeansComment(object5, ebi43PaymentMethodType);
                    object4 = new Ebi43NoPaymentType();
                    ebi43PaymentMethodType.setNoPayment((Ebi43NoPaymentType)object4);
                    break;
                }
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("PaymentMeans[" + n + "]")).errorText(AbstractToEbInterfaceConverter.EText.PAYMENTMEANS_CODE_INVALID.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{string, this.getOrString(", ", "30", "31", "42", "58"), this.getOrString(", ", "49", "59")}))).build());
            }
            ++n;
        }
        if (ebi43InvoiceType.getPaymentMethod() == null && this.m_aSettings.isInvoicePaymentMethodMandatory()) {
            if (bl) {
                Ebi43NoPaymentType ebi43NoPaymentType = new Ebi43NoPaymentType();
                ebi43PaymentMethodType.setNoPayment(ebi43NoPaymentType);
                ebi43InvoiceType.setPaymentMethod(ebi43PaymentMethodType);
            } else {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName(bl ? "CreditNote" : "Invoice")).errorText(AbstractToEbInterfaceConverter.EText.ERB_NO_PAYMENT_METHOD.getDisplayText(this.m_aDisplayLocale))).build());
            }
        }
        if (ebi43PaymentConditionsType.getDueDate() == null) {
            ebi43PaymentConditionsType.setDueDate(supplier.get());
        }
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        int n3 = 0;
        for (PaymentTermsType paymentTermsType : supplier5.get()) {
            for (Ebi43UniversalBankTransactionType ebi43UniversalBankTransactionType2 : paymentTermsType.getNote()) {
                object3 = StringHelper.trim((String)ebi43UniversalBankTransactionType2.getValue());
                if (!StringHelper.hasText((String)object3)) continue;
                commonsArrayList.add(object3);
            }
            if (paymentTermsType.getPaymentDueDate() != null) {
                object4 = paymentTermsType.getPaymentDueDateValue();
                ebi43UniversalBankTransactionType2 = ebi43PaymentConditionsType.getDueDate();
                if (object4 != null && ebi43UniversalBankTransactionType2 != null) {
                    if (!ebi43UniversalBankTransactionType2.equals(object4)) {
                        errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("PaymentTerms[" + n3 + "]/PaymentDueDate")).errorText(AbstractToEbInterfaceConverter.EText.PAYMENT_DUE_DATE_ALREADY_CONTAINED.getDisplayText(this.m_aDisplayLocale))).build());
                    }
                } else {
                    ebi43PaymentConditionsType.setDueDate((XMLOffsetDate)object4);
                }
                if ((object3 = paymentTermsType.getPaymentPercentValue()) != null && MathHelper.isGT0((BigDecimal)object3) && MathHelper.isLT100((BigDecimal)object3)) {
                    ebi43AccountType = supplier6.get();
                    BigDecimal bigDecimal = object2 = ebi43AccountType == null ? null : ebi43AccountType.getPayableAmountValue();
                    if (object2 != null) {
                        object7 = MathHelper.getPercentValue((BigDecimal)object2, (BigDecimal)object3, (int)2, (RoundingMode)ROUNDING_MODE);
                        ebi43PaymentConditionsType.setMinimumPayment((BigDecimal)object7);
                    }
                }
            } else if (paymentTermsType.getSettlementDiscountPercent() != null) {
                if (paymentTermsType.getSettlementPeriod() == null || paymentTermsType.getSettlementPeriod().getEndDate() == null) {
                    errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("PaymentTerms[" + n3 + "]/SettlementPeriod")).errorText(AbstractToEbInterfaceConverter.EText.SETTLEMENT_PERIOD_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
                } else {
                    object4 = new Ebi43DiscountType();
                    object4.setPaymentDate(paymentTermsType.getSettlementPeriod().getEndDateValue());
                    object4.setPercentage(paymentTermsType.getSettlementDiscountPercentValue());
                    object4.setAmount(paymentTermsType.getAmountValue());
                    ebi43PaymentConditionsType.addDiscount((Ebi43DiscountType)object4);
                }
            } else if (paymentTermsType.getPenaltySurchargePercent() != null) {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("PaymentTerms[" + n3 + "]")).errorText(AbstractToEbInterfaceConverter.EText.PENALTY_NOT_ALLOWED.getDisplayText(this.m_aDisplayLocale))).build());
            }
            ++n3;
        }
        if (!commonsArrayList.isEmpty()) {
            ebi43PaymentConditionsType.setComment(StringHelper.getImploded((char)'\n', (Iterable)commonsArrayList));
        }
        if (ebi43PaymentConditionsType.getDueDate() == null) {
            if (ebi43PaymentConditionsType.hasDiscountEntries()) {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("PaymentMeans/PaymentDueDate")).errorText(AbstractToEbInterfaceConverter.EText.DISCOUNT_WITHOUT_DUEDATE.getDisplayText(this.m_aDisplayLocale))).build());
            }
        } else {
            ebi43InvoiceType.setPaymentConditions(ebi43PaymentConditionsType);
        }
    }
}

