/*
 * Decompiled with CFR 0.152.
 */
package at.austriapro.ebinterface.ubl.from;

import at.austriapro.ebinterface.ubl.from.AbstractToEbInterfaceConverter;
import at.austriapro.ebinterface.ubl.from.IToEbinterfaceSettings;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.datetime.XMLOffsetDate;
import com.helger.commons.error.SingleError;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.locale.country.CountryCache;
import com.helger.commons.math.MathHelper;
import com.helger.commons.regex.RegExHelper;
import com.helger.commons.string.StringHelper;
import com.helger.ebinterface.v60.Ebi60AccountType;
import com.helger.ebinterface.v60.Ebi60AddressIdentifierType;
import com.helger.ebinterface.v60.Ebi60AddressType;
import com.helger.ebinterface.v60.Ebi60ContactType;
import com.helger.ebinterface.v60.Ebi60CountryType;
import com.helger.ebinterface.v60.Ebi60DeliveryType;
import com.helger.ebinterface.v60.Ebi60DiscountType;
import com.helger.ebinterface.v60.Ebi60DocumentTypeType;
import com.helger.ebinterface.v60.Ebi60InvoiceType;
import com.helger.ebinterface.v60.Ebi60NoPaymentType;
import com.helger.ebinterface.v60.Ebi60PaymentConditionsType;
import com.helger.ebinterface.v60.Ebi60PaymentMethodType;
import com.helger.ebinterface.v60.Ebi60PaymentReferenceType;
import com.helger.ebinterface.v60.Ebi60RelatedDocumentType;
import com.helger.ebinterface.v60.Ebi60SEPADirectDebitType;
import com.helger.ebinterface.v60.Ebi60SEPADirectDebitTypeType;
import com.helger.ebinterface.v60.Ebi60UniversalBankTransactionType;
import com.helger.xsds.ccts.cct.schemamodule.TextType;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.AddressType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.BillingReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.ContactType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.CustomerPartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.DeliveryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.DocumentReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.MonetaryTotalType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyLegalEntityType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyNameType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PaymentMeansType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PaymentTermsType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PersonType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.SupplierPartyType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.DescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.DocumentDescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.InstructionNoteType;

@Immutable
public abstract class AbstractToEbInterface60Converter
extends AbstractToEbInterfaceConverter {
    public static final int PAYMENT_REFERENCE_MAX_LENGTH = 35;

    protected AbstractToEbInterface60Converter(@Nonnull Locale locale, @Nonnull Locale locale2, @Nonnull IToEbinterfaceSettings iToEbinterfaceSettings) {
        super(locale, locale2, iToEbinterfaceSettings);
    }

    public static void setAddressData(@Nullable AddressType addressType, @Nonnull Ebi60AddressType ebi60AddressType, @Nonnull Locale locale) {
        if (addressType != null) {
            ebi60AddressType.setStreet(StringHelper.getImplodedNonEmpty((char)' ', (String[])new String[]{StringHelper.trim((String)addressType.getStreetNameValue()), StringHelper.trim((String)addressType.getBuildingNumberValue())}));
            ebi60AddressType.setPOBox(StringHelper.trim((String)addressType.getPostboxValue()));
            ebi60AddressType.setTown(StringHelper.trim((String)addressType.getCityNameValue()));
            ebi60AddressType.setZIP(StringHelper.trim((String)addressType.getPostalZoneValue()));
            if (addressType.getCountry() != null) {
                Locale locale2;
                Ebi60CountryType ebi60CountryType = new Ebi60CountryType();
                String string = StringHelper.trim((String)addressType.getCountry().getIdentificationCodeValue());
                ebi60CountryType.setCountryCode(string);
                String string2 = StringHelper.trim((String)addressType.getCountry().getNameValue());
                ebi60CountryType.setValue(string2);
                if (StringHelper.hasNoText((String)string2) && StringHelper.hasText((String)string) && (locale2 = CountryCache.getInstance().getCountry(string)) != null) {
                    ebi60CountryType.setValue(locale2.getDisplayCountry(locale));
                }
                ebi60AddressType.setCountry(ebi60CountryType);
            }
        }
    }

    public static void validateContactData(@Nonnull Ebi60ContactType ebi60ContactType, @Nonnull String string, @Nonnull ErrorList errorList, @Nonnull Locale locale) {
        if (ebi60ContactType.getName() == null) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName(string + "/Contact/Name")).errorText(AbstractToEbInterfaceConverter.EText.CONTACT_NO_NAME.getDisplayText(locale))).build());
        }
    }

    @Nullable
    public static Ebi60ContactType convertContact(@Nonnull PartyType partyType, @Nonnull String string, @Nullable String string2, @Nonnull ErrorList errorList, @Nonnull Locale locale, boolean bl) {
        String string3;
        ContactType contactType = partyType.getContact();
        if (contactType == null && partyType.getPerson().isEmpty()) {
            return null;
        }
        Ebi60ContactType ebi60ContactType = new Ebi60ContactType();
        if (contactType != null) {
            Object object;
            string3 = StringHelper.trim((String)contactType.getTelephoneValue());
            if (StringHelper.hasText((String)string3)) {
                ebi60ContactType.addPhone(string3);
            }
            if (StringHelper.hasText((String)(object = StringHelper.trim((String)contactType.getElectronicMailValue())))) {
                ebi60ContactType.addEmail((String)object);
            }
        }
        string3 = new CommonsArrayList();
        if (contactType != null && StringHelper.hasTextAfterTrim((String)contactType.getNameValue())) {
            string3.add((Object)StringHelper.trim((String)contactType.getNameValue()));
        }
        for (PersonType personType : partyType.getPerson()) {
            if (StringHelper.hasNoText((String)ebi60ContactType.getSalutation())) {
                ebi60ContactType.setSalutation(StringHelper.trim((String)personType.getGenderCodeValue()));
            }
            string3.add((Object)StringHelper.getImplodedNonEmpty((char)' ', (String[])new String[]{StringHelper.trim((String)personType.getTitleValue()), StringHelper.trim((String)personType.getFirstNameValue()), StringHelper.trim((String)personType.getMiddleNameValue()), StringHelper.trim((String)personType.getFamilyNameValue()), StringHelper.trim((String)personType.getNameSuffixValue())}));
        }
        if (string3.isNotEmpty()) {
            ebi60ContactType.setName(StringHelper.getImplodedNonEmpty((char)'\n', (Iterable)((Object)string3)));
        }
        if (ebi60ContactType.getName() == null) {
            ebi60ContactType.setName(string2);
        }
        if (bl) {
            AbstractToEbInterface60Converter.validateContactData(ebi60ContactType, string, errorList, locale);
        }
        return ebi60ContactType;
    }

    public static void validateAddressData(@Nonnull Ebi60AddressType ebi60AddressType, @Nonnull String string, @Nonnull ErrorList errorList, @Nonnull Locale locale) {
        if (ebi60AddressType.getStreet() == null) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName(string + "/PostalAddress/StreetName")).errorText(AbstractToEbInterfaceConverter.EText.ADDRESS_NO_STREET.getDisplayText(locale))).build());
        }
        if (ebi60AddressType.getTown() == null) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName(string + "/PostalAddress/CityName")).errorText(AbstractToEbInterfaceConverter.EText.ADDRESS_NO_CITY.getDisplayText(locale))).build());
        }
        if (ebi60AddressType.getZIP() == null) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName(string + "/PostalAddress/PostalZone")).errorText(AbstractToEbInterfaceConverter.EText.ADDRESS_NO_ZIPCODE.getDisplayText(locale))).build());
        }
        if (ebi60AddressType.getCountry() == null) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName(string + "/PostalAddress/Country/IdentificationCode")).errorText(AbstractToEbInterfaceConverter.EText.ADDRESS_NO_COUNTRY.getDisplayText(locale))).build());
        }
    }

    @Nonnull
    public static Ebi60AddressType convertParty(@Nonnull PartyType partyType, @Nonnull String string, @Nonnull ErrorList errorList, @Nonnull Locale locale, @Nonnull Locale locale2, boolean bl) {
        String string2;
        PartyNameType partyNameType;
        Ebi60AddressType ebi60AddressType = new Ebi60AddressType();
        if (partyType.getPartyNameCount() > 1) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName(string + "/PartyName")).errorText(AbstractToEbInterfaceConverter.EText.MULTIPLE_PARTIES.getDisplayText(locale2))).build());
        }
        if ((partyNameType = (PartyNameType)CollectionHelper.getAtIndex((List)partyType.getPartyName(), (int)0)) != null) {
            ebi60AddressType.setName(StringHelper.trim((String)partyNameType.getNameValue()));
        }
        if (ebi60AddressType.getName() == null && partyType.hasPartyLegalEntityEntries()) {
            ebi60AddressType.setName(StringHelper.trim((String)partyType.getPartyLegalEntityAtIndex(0).getRegistrationNameValue()));
        }
        if (ebi60AddressType.getName() == null) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName(string)).errorText(AbstractToEbInterfaceConverter.EText.PARTY_NO_NAME.getDisplayText(locale2))).build());
        }
        AbstractToEbInterface60Converter.setAddressData(partyType.getPostalAddress(), ebi60AddressType, locale);
        if (partyType.getEndpointID() != null && StringHelper.hasText((String)(string2 = StringHelper.trim((String)partyType.getEndpointIDValue())))) {
            String string3 = StringHelper.trim((String)partyType.getEndpointID().getSchemeID());
            Ebi60AddressIdentifierType ebi60AddressIdentifierType = new Ebi60AddressIdentifierType();
            ebi60AddressIdentifierType.setAddressIdentifierType(string3);
            ebi60AddressIdentifierType.setValue(string2);
            ebi60AddressType.addAddressIdentifier(ebi60AddressIdentifierType);
            if (ebi60AddressType.hasNoAddressIdentifierEntries()) {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName(string)).errorText(AbstractToEbInterfaceConverter.EText.PARTY_UNSUPPORTED_ENDPOINT.getDisplayTextWithArgs(locale2, new Object[]{string2, partyType.getEndpointID().getSchemeID()}))).build());
            }
        }
        if (ebi60AddressType.hasNoAddressIdentifierEntries()) {
            int n = 0;
            for (Ebi60AddressIdentifierType ebi60AddressIdentifierType : partyType.getPartyIdentification()) {
                String string4 = StringHelper.trim((String)ebi60AddressIdentifierType.getIDValue());
                Ebi60AddressIdentifierType ebi60AddressIdentifierType2 = new Ebi60AddressIdentifierType();
                ebi60AddressIdentifierType2.setAddressIdentifierType(ebi60AddressIdentifierType.getID().getSchemeID());
                ebi60AddressIdentifierType2.setValue(string4);
                ebi60AddressType.addAddressIdentifier(ebi60AddressIdentifierType2);
                if (ebi60AddressType.hasNoAddressIdentifierEntries()) {
                    errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName(string + "/PartyIdentification[" + n + "]")).errorText(AbstractToEbInterfaceConverter.EText.PARTY_UNSUPPORTED_ADDRESS_IDENTIFIER.getDisplayTextWithArgs(locale2, new Object[]{string4, ebi60AddressIdentifierType.getID().getSchemeID()}))).build());
                }
                ++n;
            }
        }
        if (bl) {
            AbstractToEbInterface60Converter.validateAddressData(ebi60AddressType, string, errorList, locale2);
        }
        return ebi60AddressType;
    }

    @Nonnull
    protected static String getAggregated(@Nonnull Iterable<DescriptionType> iterable) {
        return StringHelper.getImplodedMapped((char)'\n', iterable, TextType::getValue);
    }

    protected static boolean isAddressIncomplete(@Nonnull Ebi60AddressType ebi60AddressType) {
        return StringHelper.hasNoText((String)ebi60AddressType.getName()) || StringHelper.hasNoText((String)ebi60AddressType.getTown()) || StringHelper.hasNoText((String)ebi60AddressType.getZIP()) || ebi60AddressType.getCountry() == null;
    }

    @Nonnull
    public static Ebi60DeliveryType convertDelivery(@Nonnull DeliveryType deliveryType, @Nonnull String string, @Nullable CustomerPartyType customerPartyType, @Nonnull ErrorList errorList, @Nonnull Locale locale, @Nonnull Locale locale2) {
        AddressType addressType;
        Ebi60DeliveryType ebi60DeliveryType = new Ebi60DeliveryType();
        ebi60DeliveryType.setDeliveryID(deliveryType.getIDValue());
        ebi60DeliveryType.setDate(deliveryType.getActualDeliveryDateValue());
        PartyType partyType = deliveryType.getDeliveryParty();
        Ebi60AddressType ebi60AddressType = null;
        if (partyType != null) {
            ebi60AddressType = AbstractToEbInterface60Converter.convertParty(partyType, "DeliveryParty", errorList, locale, locale2, false);
            ebi60DeliveryType.setAddress(ebi60AddressType);
            ebi60DeliveryType.setContact(AbstractToEbInterface60Converter.convertContact(partyType, "DeliveryParty", ebi60AddressType.getName(), errorList, locale2, true));
        }
        if ((ebi60AddressType == null || AbstractToEbInterface60Converter.isAddressIncomplete(ebi60AddressType)) && (addressType = deliveryType.getDeliveryAddress()) != null) {
            if (ebi60AddressType == null) {
                ebi60AddressType = new Ebi60AddressType();
            }
            AbstractToEbInterface60Converter.setAddressData(addressType, ebi60AddressType, locale);
            ebi60DeliveryType.setAddress(ebi60AddressType);
        }
        if ((addressType = deliveryType.getDeliveryLocation()) != null && addressType.getAddress() != null) {
            ebi60DeliveryType.setDescription(AbstractToEbInterface60Converter.getAggregated(addressType.getDescription()));
            if (ebi60AddressType == null || AbstractToEbInterface60Converter.isAddressIncomplete(ebi60AddressType)) {
                if (ebi60AddressType == null) {
                    ebi60AddressType = new Ebi60AddressType();
                }
                AbstractToEbInterface60Converter.setAddressData(addressType.getAddress(), ebi60AddressType, locale);
                ebi60DeliveryType.setAddress(ebi60AddressType);
            }
        }
        if (ebi60AddressType != null) {
            PartyNameType partyNameType;
            Iterator iterator;
            String string2 = null;
            if (deliveryType.getDeliveryParty() != null) {
                iterator = deliveryType.getDeliveryParty().getPartyName().iterator();
                while (iterator.hasNext() && !StringHelper.hasText((String)(string2 = StringHelper.trim((String)(partyNameType = (PartyNameType)iterator.next()).getNameValue())))) {
                }
            }
            if (StringHelper.hasNoText(string2) && addressType != null) {
                string2 = StringHelper.trim((String)addressType.getNameValue());
            }
            if (StringHelper.hasNoText(string2) && customerPartyType != null && customerPartyType.getParty() != null) {
                iterator = customerPartyType.getParty().getPartyName().iterator();
                while (iterator.hasNext() && !StringHelper.hasText((String)(string2 = StringHelper.trim((String)(partyNameType = (PartyNameType)iterator.next()).getNameValue())))) {
                }
                if (StringHelper.hasNoText((String)string2)) {
                    iterator = customerPartyType.getParty().getPartyLegalEntity().iterator();
                    while (iterator.hasNext() && !StringHelper.hasText((String)(string2 = StringHelper.trim((String)(partyNameType = (PartyLegalEntityType)iterator.next()).getRegistrationNameValue())))) {
                    }
                }
            }
            ebi60AddressType.setName(string2);
            if (StringHelper.hasNoText((String)ebi60AddressType.getName())) {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName(string + "/DeliveryParty")).errorText(AbstractToEbInterfaceConverter.EText.DELIVERY_WITHOUT_NAME.getDisplayText(locale2))).build());
            }
            AbstractToEbInterface60Converter.validateAddressData(ebi60AddressType, string + "/DeliveryParty", errorList, locale2);
        }
        return ebi60DeliveryType;
    }

    @Nullable
    protected static final Ebi60DocumentTypeType getAsDocumentTypeType(String ... stringArray) {
        if (stringArray != null) {
            for (String string : stringArray) {
                if (string == null) continue;
                String string2 = string.trim();
                try {
                    return Ebi60DocumentTypeType.fromValue((String)string2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if ("326".equals(string2)) {
                        return Ebi60DocumentTypeType.INVOICE_FOR_PARTIAL_DELIVERY;
                    }
                    if ("386".equals(string2)) {
                        return Ebi60DocumentTypeType.INVOICE_FOR_ADVANCE_PAYMENT;
                    }
                    if (!"389".equals(string2)) continue;
                    return Ebi60DocumentTypeType.SELF_BILLING;
                }
            }
        }
        return null;
    }

    protected static void convertRelatedDocuments(@Nonnull List<BillingReferenceType> list, @Nonnull Ebi60InvoiceType ebi60InvoiceType) {
        for (BillingReferenceType billingReferenceType : list) {
            Ebi60RelatedDocumentType ebi60RelatedDocumentType;
            if (billingReferenceType.getInvoiceDocumentReference() != null && billingReferenceType.getInvoiceDocumentReference().getIDValue() != null) {
                ebi60RelatedDocumentType = new Ebi60RelatedDocumentType();
                ebi60RelatedDocumentType.setInvoiceNumber(billingReferenceType.getInvoiceDocumentReference().getIDValue());
                ebi60RelatedDocumentType.setInvoiceDate(billingReferenceType.getInvoiceDocumentReference().getIssueDateValue());
                ebi60RelatedDocumentType.setDocumentType(Ebi60DocumentTypeType.INVOICE);
                ebi60InvoiceType.addRelatedDocument(ebi60RelatedDocumentType);
                continue;
            }
            if (billingReferenceType.getCreditNoteDocumentReference() == null || billingReferenceType.getCreditNoteDocumentReference().getIDValue() == null) continue;
            ebi60RelatedDocumentType = new Ebi60RelatedDocumentType();
            ebi60RelatedDocumentType.setInvoiceNumber(billingReferenceType.getCreditNoteDocumentReference().getIDValue());
            ebi60RelatedDocumentType.setInvoiceDate(billingReferenceType.getCreditNoteDocumentReference().getIssueDateValue());
            ebi60RelatedDocumentType.setDocumentType(Ebi60DocumentTypeType.CREDIT_MEMO);
            ebi60InvoiceType.addRelatedDocument(ebi60RelatedDocumentType);
        }
    }

    protected static void convertReferencedDocuments(@Nonnull List<DocumentReferenceType> list, @Nonnull Ebi60InvoiceType ebi60InvoiceType) {
        for (DocumentReferenceType documentReferenceType : list) {
            if (!StringHelper.hasText((String)documentReferenceType.getIDValue()) || documentReferenceType.getAttachment() != null) continue;
            Ebi60RelatedDocumentType ebi60RelatedDocumentType = new Ebi60RelatedDocumentType();
            ebi60RelatedDocumentType.setInvoiceNumber(documentReferenceType.getIDValue());
            ebi60RelatedDocumentType.setInvoiceDate(documentReferenceType.getIssueDateValue());
            CommonsArrayList commonsArrayList = new CommonsArrayList();
            for (DocumentDescriptionType documentDescriptionType : documentReferenceType.getDocumentDescription()) {
                commonsArrayList.add((Object)documentDescriptionType.getValue());
            }
            ebi60RelatedDocumentType.setComment(StringHelper.getImplodedNonEmpty((char)'\n', (Iterable)commonsArrayList));
            if (documentReferenceType.getDocumentTypeCode() != null) {
                ebi60RelatedDocumentType.setDocumentType(AbstractToEbInterface60Converter.getAsDocumentTypeType(documentReferenceType.getDocumentTypeCode().getName(), documentReferenceType.getDocumentTypeCodeValue()));
            }
            ebi60InvoiceType.addRelatedDocument(ebi60RelatedDocumentType);
        }
    }

    private static void _setPaymentMeansComment(@Nonnull PaymentMeansType paymentMeansType, @Nonnull Ebi60PaymentMethodType ebi60PaymentMethodType) {
        if (paymentMeansType.hasInstructionNoteEntries()) {
            CommonsArrayList commonsArrayList = new CommonsArrayList();
            for (InstructionNoteType instructionNoteType : paymentMeansType.getInstructionNote()) {
                commonsArrayList.add((Object)StringHelper.trim((String)instructionNoteType.getValue()));
            }
            if (commonsArrayList.isNotEmpty()) {
                ebi60PaymentMethodType.setComment(StringHelper.getImplodedNonEmpty((char)'\n', (Iterable)commonsArrayList));
            }
        }
    }

    protected void convertPayment(@Nonnull Supplier<XMLOffsetDate> supplier, @Nonnull Supplier<List<PaymentMeansType>> supplier2, @Nonnull Supplier<PartyType> supplier3, @Nonnull Supplier<SupplierPartyType> supplier4, @Nonnull Supplier<List<PaymentTermsType>> supplier5, @Nonnull Supplier<MonetaryTotalType> supplier6, @Nonnull ErrorList errorList, @Nonnull Ebi60InvoiceType ebi60InvoiceType, boolean bl) {
        Ebi60AccountType ebi60AccountType;
        Object object7;
        Object object2;
        Object object3;
        Ebi60UniversalBankTransactionType ebi60UniversalBankTransactionType2;
        Object object4;
        Ebi60PaymentMethodType ebi60PaymentMethodType = new Ebi60PaymentMethodType();
        Ebi60PaymentConditionsType ebi60PaymentConditionsType = new Ebi60PaymentConditionsType();
        int n = 0;
        for (PaymentMeansType object5 : supplier2.get()) {
            String string = StringHelper.trim((String)object5.getPaymentMeansCodeValue());
            if (AbstractToEbInterface60Converter.isUniversalBankTransaction(string)) {
                object4 = StringHelper.trim((String)object5.getPaymentChannelCodeValue());
                if (AbstractToEbInterface60Converter.isIBAN((String)object4)) {
                    PartyNameType partyNameType;
                    Object object6;
                    String string2;
                    String string3;
                    AbstractToEbInterface60Converter._setPaymentMeansComment(object5, ebi60PaymentMethodType);
                    ebi60UniversalBankTransactionType2 = new Ebi60UniversalBankTransactionType();
                    object3 = object5.getInstructionID();
                    if (object3 != null && StringHelper.hasText((String)(string3 = StringHelper.trim((String)object3.getValue())))) {
                        if (string3.length() > 35) {
                            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("PaymentMeans[" + n + "]/InstructionID")).errorText(AbstractToEbInterfaceConverter.EText.PAYMENT_ID_TOO_LONG_CUT.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{string3}))).build());
                            string3 = string3.substring(0, 35);
                        }
                        object2 = new Ebi60PaymentReferenceType();
                        object2.setValue(string3);
                        ebi60UniversalBankTransactionType2.setPaymentReference((Ebi60PaymentReferenceType)object2);
                    }
                    if (ebi60UniversalBankTransactionType2.getPaymentReference() == null) {
                        int n2 = 0;
                        for (Object object7 : object5.getPaymentID()) {
                            string2 = StringHelper.trim((String)object7.getValue());
                            if (StringHelper.hasText((String)string2)) {
                                if (string2.length() > 35) {
                                    errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("PaymentMeans[" + n + "]/PaymentID[" + n2 + "]")).errorText(AbstractToEbInterfaceConverter.EText.PAYMENT_ID_TOO_LONG_CUT.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{string2}))).build());
                                    string2 = string2.substring(0, 35);
                                }
                                object6 = new Ebi60PaymentReferenceType();
                                object6.setValue(string2);
                                ebi60UniversalBankTransactionType2.setPaymentReference(object6);
                            }
                            ++n2;
                        }
                    }
                    ebi60AccountType = new Ebi60AccountType();
                    object2 = object5.getPayeeFinancialAccount();
                    if (object2 != null && object2.getFinancialInstitutionBranch() != null && object2.getFinancialInstitutionBranch().getFinancialInstitution() != null && StringHelper.hasText((String)(object7 = object2.getFinancialInstitutionBranch().getFinancialInstitution()).getIDValue())) {
                        string2 = StringHelper.trim((String)object7.getID().getValue());
                        object6 = StringHelper.trim((String)object7.getID().getSchemeID());
                        boolean bl2 = AbstractToEbInterface60Converter.isBIC((String)object6);
                        if (bl2) {
                            ebi60AccountType.setBIC(string2);
                        } else {
                            ebi60AccountType.setBankName(string2);
                        }
                        if (bl2 && (StringHelper.hasNoText((String)string2) || !RegExHelper.stringMatchesPattern((String)"[0-9A-Za-z]{8}([0-9A-Za-z]{3})?", (String)string2))) {
                            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("PaymentMeans[" + n + "]/PayeeFinancialAccount/FinancialInstitutionBranch/FinancialInstitution/ID")).errorText(AbstractToEbInterfaceConverter.EText.BIC_INVALID.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{string2}))).build());
                            ebi60AccountType.setBIC(null);
                        }
                    }
                    object7 = object2 != null ? StringHelper.trim((String)object2.getIDValue()) : null;
                    ebi60AccountType.setIBAN((String)object7);
                    if (StringHelper.getLength((CharSequence)object7) > 34) {
                        errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("PaymentMeans[" + n + "]/PayeeFinancialAccount/ID")).errorText(AbstractToEbInterfaceConverter.EText.IBAN_TOO_LONG_STRIPPING.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{object7, 34}))).build());
                        ebi60AccountType.setIBAN(((String)object7).substring(0, 34));
                    }
                    String string4 = string2 = object2 != null ? object2.getNameValue() : null;
                    if (StringHelper.hasNoText((String)string2) && (object6 = supplier3.get()) != null) {
                        Iterator iterator = object6.getPartyName().iterator();
                        while (iterator.hasNext() && !StringHelper.hasText((String)(string2 = StringHelper.trim((String)(partyNameType = (PartyNameType)iterator.next()).getNameValue())))) {
                        }
                    }
                    if (StringHelper.hasNoText((String)string2) && (object6 = supplier4.get().getParty()) != null) {
                        Iterator iterator = object6.getPartyName().iterator();
                        while (iterator.hasNext() && !StringHelper.hasText((String)(string2 = StringHelper.trim((String)(partyNameType = (PartyNameType)iterator.next()).getNameValue())))) {
                        }
                    }
                    ebi60AccountType.setBankAccountOwner(string2);
                    ebi60UniversalBankTransactionType2.addBeneficiaryAccount(ebi60AccountType);
                    ebi60PaymentMethodType.setUniversalBankTransaction(ebi60UniversalBankTransactionType2);
                    ebi60InvoiceType.setPaymentMethod(ebi60PaymentMethodType);
                    ebi60PaymentConditionsType.setDueDate(object5.getPaymentDueDateValue());
                    break;
                }
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("PaymentMeans[" + n + "]")).errorText(AbstractToEbInterfaceConverter.EText.PAYMENTMEANS_UNSUPPORTED_CHANNELCODE.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{object4}))).build());
            } else {
                if (AbstractToEbInterface60Converter.isSEPADirectDebit(string)) {
                    AbstractToEbInterface60Converter._setPaymentMeansComment(object5, ebi60PaymentMethodType);
                    object4 = new Ebi60SEPADirectDebitType();
                    object4.setType(Ebi60SEPADirectDebitTypeType.B_2_C);
                    object4.setBIC(null);
                    object4.setIBAN(null);
                    object4.setBankAccountOwner(null);
                    object4.setCreditorID(null);
                    object4.setMandateReference(null);
                    object4.setDebitCollectionDate((XMLOffsetDate)null);
                    ebi60PaymentMethodType.setSEPADirectDebit((Ebi60SEPADirectDebitType)object4);
                    ebi60InvoiceType.setPaymentMethod(ebi60PaymentMethodType);
                    ebi60PaymentConditionsType.setDueDate(object5.getPaymentDueDateValue());
                    break;
                }
                if (MathHelper.isEQ0((BigDecimal)ebi60InvoiceType.getPayableAmount())) {
                    AbstractToEbInterface60Converter._setPaymentMeansComment(object5, ebi60PaymentMethodType);
                    object4 = new Ebi60NoPaymentType();
                    ebi60PaymentMethodType.setNoPayment((Ebi60NoPaymentType)object4);
                    break;
                }
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("PaymentMeans[" + n + "]")).errorText(AbstractToEbInterfaceConverter.EText.PAYMENTMEANS_CODE_INVALID.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{string, this.getOrString(", ", "30", "31", "42", "58"), this.getOrString(", ", "59")}))).build());
            }
            ++n;
        }
        if (ebi60InvoiceType.getPaymentMethod() == null && this.m_aSettings.isInvoicePaymentMethodMandatory()) {
            if (bl) {
                Ebi60NoPaymentType ebi60NoPaymentType = new Ebi60NoPaymentType();
                ebi60PaymentMethodType.setNoPayment(ebi60NoPaymentType);
                ebi60InvoiceType.setPaymentMethod(ebi60PaymentMethodType);
            } else {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName(bl ? "CreditNote" : "Invoice")).errorText(AbstractToEbInterfaceConverter.EText.ERB_NO_PAYMENT_METHOD.getDisplayText(this.m_aDisplayLocale))).build());
            }
        }
        if (ebi60PaymentConditionsType.getDueDate() == null) {
            ebi60PaymentConditionsType.setDueDate(supplier.get());
        }
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        int n3 = 0;
        for (PaymentTermsType paymentTermsType : supplier5.get()) {
            for (Ebi60UniversalBankTransactionType ebi60UniversalBankTransactionType2 : paymentTermsType.getNote()) {
                object3 = StringHelper.trim((String)ebi60UniversalBankTransactionType2.getValue());
                if (!StringHelper.hasText((String)object3)) continue;
                commonsArrayList.add(object3);
            }
            if (paymentTermsType.getPaymentDueDate() != null) {
                object4 = paymentTermsType.getPaymentDueDateValue();
                ebi60UniversalBankTransactionType2 = ebi60PaymentConditionsType.getDueDate();
                if (object4 != null && ebi60UniversalBankTransactionType2 != null) {
                    if (!ebi60UniversalBankTransactionType2.equals(object4)) {
                        errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("PaymentTerms[" + n3 + "]/PaymentDueDate")).errorText(AbstractToEbInterfaceConverter.EText.PAYMENT_DUE_DATE_ALREADY_CONTAINED.getDisplayText(this.m_aDisplayLocale))).build());
                    }
                } else {
                    ebi60PaymentConditionsType.setDueDate((XMLOffsetDate)object4);
                }
                if ((object3 = paymentTermsType.getPaymentPercentValue()) != null && MathHelper.isGT0((BigDecimal)object3) && MathHelper.isLT100((BigDecimal)object3)) {
                    ebi60AccountType = supplier6.get();
                    BigDecimal bigDecimal = object2 = ebi60AccountType == null ? null : ebi60AccountType.getPayableAmountValue();
                    if (object2 != null) {
                        object7 = MathHelper.getPercentValue((BigDecimal)object2, (BigDecimal)object3, (int)2, (RoundingMode)ROUNDING_MODE);
                        ebi60PaymentConditionsType.setMinimumPayment((BigDecimal)object7);
                    }
                }
            } else if (paymentTermsType.getSettlementDiscountPercent() != null) {
                if (paymentTermsType.getSettlementPeriod() == null || paymentTermsType.getSettlementPeriod().getEndDate() == null) {
                    errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("PaymentTerms[" + n3 + "]/SettlementPeriod")).errorText(AbstractToEbInterfaceConverter.EText.SETTLEMENT_PERIOD_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
                } else {
                    object4 = new Ebi60DiscountType();
                    object4.setPaymentDate(paymentTermsType.getSettlementPeriod().getEndDateValue());
                    object4.setPercentage(paymentTermsType.getSettlementDiscountPercentValue());
                    object4.setAmount(paymentTermsType.getAmountValue());
                    ebi60PaymentConditionsType.addDiscount((Ebi60DiscountType)object4);
                }
            } else if (paymentTermsType.getPenaltySurchargePercent() != null) {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("PaymentTerms[" + n3 + "]")).errorText(AbstractToEbInterfaceConverter.EText.PENALTY_NOT_ALLOWED.getDisplayText(this.m_aDisplayLocale))).build());
            }
            ++n3;
        }
        if (!commonsArrayList.isEmpty()) {
            ebi60PaymentConditionsType.setComment(StringHelper.getImploded((char)'\n', (Iterable)commonsArrayList));
        }
        if (ebi60PaymentConditionsType.getDueDate() == null) {
            if (ebi60PaymentConditionsType.hasDiscountEntries()) {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("PaymentMeans/PaymentDueDate")).errorText(AbstractToEbInterfaceConverter.EText.DISCOUNT_WITHOUT_DUEDATE.getDisplayText(this.m_aDisplayLocale))).build());
            }
        } else {
            ebi60InvoiceType.setPaymentConditions(ebi60PaymentConditionsType);
        }
    }
}

