/*
 * Decompiled with CFR 0.152.
 */
package at.austriapro.ebinterface.ubl.from;

import at.austriapro.ebinterface.ubl.from.AbstractToEbInterfaceConverter;
import at.austriapro.ebinterface.ubl.from.IToEbinterfaceSettings;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.datetime.XMLOffsetDate;
import com.helger.commons.error.SingleError;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.locale.country.CountryCache;
import com.helger.commons.math.MathHelper;
import com.helger.commons.regex.RegExHelper;
import com.helger.commons.string.StringHelper;
import com.helger.ebinterface.v61.Ebi61AccountType;
import com.helger.ebinterface.v61.Ebi61AddressIdentifierType;
import com.helger.ebinterface.v61.Ebi61AddressType;
import com.helger.ebinterface.v61.Ebi61ContactType;
import com.helger.ebinterface.v61.Ebi61CountryType;
import com.helger.ebinterface.v61.Ebi61DeliveryType;
import com.helger.ebinterface.v61.Ebi61DiscountType;
import com.helger.ebinterface.v61.Ebi61DocumentTypeType;
import com.helger.ebinterface.v61.Ebi61InvoiceType;
import com.helger.ebinterface.v61.Ebi61NoPaymentType;
import com.helger.ebinterface.v61.Ebi61PaymentConditionsType;
import com.helger.ebinterface.v61.Ebi61PaymentMethodType;
import com.helger.ebinterface.v61.Ebi61PaymentReferenceType;
import com.helger.ebinterface.v61.Ebi61RelatedDocumentType;
import com.helger.ebinterface.v61.Ebi61SEPADirectDebitType;
import com.helger.ebinterface.v61.Ebi61SEPADirectDebitTypeType;
import com.helger.ebinterface.v61.Ebi61UniversalBankTransactionType;
import com.helger.xsds.ccts.cct.schemamodule.TextType;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.AddressType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.BillingReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.ContactType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.CustomerPartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.DeliveryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.DocumentReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.MonetaryTotalType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyLegalEntityType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyNameType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PaymentMeansType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PaymentTermsType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PersonType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.SupplierPartyType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.DescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.DocumentDescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.InstructionNoteType;

@Immutable
public abstract class AbstractToEbInterface61Converter
extends AbstractToEbInterfaceConverter {
    public static final int PAYMENT_REFERENCE_MAX_LENGTH = 35;

    protected AbstractToEbInterface61Converter(@Nonnull Locale locale, @Nonnull Locale locale2, @Nonnull IToEbinterfaceSettings iToEbinterfaceSettings) {
        super(locale, locale2, iToEbinterfaceSettings);
    }

    public static void setAddressData(@Nullable AddressType addressType, @Nonnull Ebi61AddressType ebi61AddressType, @Nonnull Locale locale) {
        if (addressType != null) {
            ebi61AddressType.setStreet(StringHelper.getImplodedNonEmpty((char)' ', (String[])new String[]{StringHelper.trim((String)addressType.getStreetNameValue()), StringHelper.trim((String)addressType.getBuildingNumberValue())}));
            ebi61AddressType.setPOBox(StringHelper.trim((String)addressType.getPostboxValue()));
            ebi61AddressType.setTown(StringHelper.trim((String)addressType.getCityNameValue()));
            ebi61AddressType.setZIP(StringHelper.trim((String)addressType.getPostalZoneValue()));
            if (addressType.getCountry() != null) {
                Locale locale2;
                Ebi61CountryType ebi61CountryType = new Ebi61CountryType();
                String string = StringHelper.trim((String)addressType.getCountry().getIdentificationCodeValue());
                ebi61CountryType.setCountryCode(string);
                String string2 = StringHelper.trim((String)addressType.getCountry().getNameValue());
                ebi61CountryType.setValue(string2);
                if (StringHelper.hasNoText((String)string2) && StringHelper.hasText((String)string) && (locale2 = CountryCache.getInstance().getCountry(string)) != null) {
                    ebi61CountryType.setValue(locale2.getDisplayCountry(locale));
                }
                ebi61AddressType.setCountry(ebi61CountryType);
            }
        }
    }

    public static void validateContactData(@Nonnull Ebi61ContactType ebi61ContactType, @Nonnull String string, @Nonnull ErrorList errorList, @Nonnull Locale locale) {
        if (ebi61ContactType.getName() == null) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName(string + "/Contact/Name")).errorText(AbstractToEbInterfaceConverter.EText.CONTACT_NO_NAME.getDisplayText(locale))).build());
        }
    }

    @Nullable
    public static Ebi61ContactType convertContact(@Nonnull PartyType partyType, @Nonnull String string, @Nullable String string2, @Nonnull ErrorList errorList, @Nonnull Locale locale, boolean bl) {
        String string3;
        ContactType contactType = partyType.getContact();
        if (contactType == null && partyType.getPerson().isEmpty()) {
            return null;
        }
        Ebi61ContactType ebi61ContactType = new Ebi61ContactType();
        if (contactType != null) {
            Object object;
            string3 = StringHelper.trim((String)contactType.getTelephoneValue());
            if (StringHelper.hasText((String)string3)) {
                ebi61ContactType.addPhone(string3);
            }
            if (StringHelper.hasText((String)(object = StringHelper.trim((String)contactType.getElectronicMailValue())))) {
                ebi61ContactType.addEmail((String)object);
            }
        }
        string3 = new CommonsArrayList();
        if (contactType != null && StringHelper.hasTextAfterTrim((String)contactType.getNameValue())) {
            string3.add((Object)StringHelper.trim((String)contactType.getNameValue()));
        }
        for (PersonType personType : partyType.getPerson()) {
            if (StringHelper.hasNoText((String)ebi61ContactType.getSalutation())) {
                ebi61ContactType.setSalutation(StringHelper.trim((String)personType.getGenderCodeValue()));
            }
            string3.add((Object)StringHelper.getImplodedNonEmpty((char)' ', (String[])new String[]{StringHelper.trim((String)personType.getTitleValue()), StringHelper.trim((String)personType.getFirstNameValue()), StringHelper.trim((String)personType.getMiddleNameValue()), StringHelper.trim((String)personType.getFamilyNameValue()), StringHelper.trim((String)personType.getNameSuffixValue())}));
        }
        if (string3.isNotEmpty()) {
            ebi61ContactType.setName(StringHelper.getImplodedNonEmpty((char)'\n', (Iterable)((Object)string3)));
        }
        if (ebi61ContactType.getName() == null) {
            ebi61ContactType.setName(string2);
        }
        if (bl) {
            AbstractToEbInterface61Converter.validateContactData(ebi61ContactType, string, errorList, locale);
        }
        return ebi61ContactType;
    }

    public static void validateAddressData(@Nonnull Ebi61AddressType ebi61AddressType, @Nonnull String string, @Nonnull ErrorList errorList, @Nonnull Locale locale) {
        if (ebi61AddressType.getStreet() == null) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName(string + "/PostalAddress/StreetName")).errorText(AbstractToEbInterfaceConverter.EText.ADDRESS_NO_STREET.getDisplayText(locale))).build());
        }
        if (ebi61AddressType.getTown() == null) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName(string + "/PostalAddress/CityName")).errorText(AbstractToEbInterfaceConverter.EText.ADDRESS_NO_CITY.getDisplayText(locale))).build());
        }
        if (ebi61AddressType.getZIP() == null) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName(string + "/PostalAddress/PostalZone")).errorText(AbstractToEbInterfaceConverter.EText.ADDRESS_NO_ZIPCODE.getDisplayText(locale))).build());
        }
        if (ebi61AddressType.getCountry() == null) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName(string + "/PostalAddress/Country/IdentificationCode")).errorText(AbstractToEbInterfaceConverter.EText.ADDRESS_NO_COUNTRY.getDisplayText(locale))).build());
        }
    }

    @Nonnull
    public static Ebi61AddressType convertParty(@Nonnull PartyType partyType, @Nonnull String string, @Nonnull ErrorList errorList, @Nonnull Locale locale, @Nonnull Locale locale2, boolean bl) {
        String string2;
        PartyNameType partyNameType;
        Ebi61AddressType ebi61AddressType = new Ebi61AddressType();
        if (partyType.getPartyNameCount() > 1) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName(string + "/PartyName")).errorText(AbstractToEbInterfaceConverter.EText.MULTIPLE_PARTIES.getDisplayText(locale2))).build());
        }
        if ((partyNameType = (PartyNameType)CollectionHelper.getAtIndex((List)partyType.getPartyName(), (int)0)) != null) {
            ebi61AddressType.setName(StringHelper.trim((String)partyNameType.getNameValue()));
        }
        if (ebi61AddressType.getName() == null && partyType.hasPartyLegalEntityEntries()) {
            ebi61AddressType.setName(StringHelper.trim((String)partyType.getPartyLegalEntityAtIndex(0).getRegistrationNameValue()));
        }
        if (ebi61AddressType.getName() == null) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName(string)).errorText(AbstractToEbInterfaceConverter.EText.PARTY_NO_NAME.getDisplayText(locale2))).build());
        }
        AbstractToEbInterface61Converter.setAddressData(partyType.getPostalAddress(), ebi61AddressType, locale);
        if (partyType.getEndpointID() != null && StringHelper.hasText((String)(string2 = StringHelper.trim((String)partyType.getEndpointIDValue())))) {
            String string3 = StringHelper.trim((String)partyType.getEndpointID().getSchemeID());
            Ebi61AddressIdentifierType ebi61AddressIdentifierType = new Ebi61AddressIdentifierType();
            ebi61AddressIdentifierType.setAddressIdentifierType(string3);
            ebi61AddressIdentifierType.setValue(string2);
            ebi61AddressType.addAddressIdentifier(ebi61AddressIdentifierType);
            if (ebi61AddressType.hasNoAddressIdentifierEntries()) {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName(string)).errorText(AbstractToEbInterfaceConverter.EText.PARTY_UNSUPPORTED_ENDPOINT.getDisplayTextWithArgs(locale2, new Object[]{string2, partyType.getEndpointID().getSchemeID()}))).build());
            }
        }
        if (ebi61AddressType.hasNoAddressIdentifierEntries()) {
            int n = 0;
            for (Ebi61AddressIdentifierType ebi61AddressIdentifierType : partyType.getPartyIdentification()) {
                String string4 = StringHelper.trim((String)ebi61AddressIdentifierType.getIDValue());
                Ebi61AddressIdentifierType ebi61AddressIdentifierType2 = new Ebi61AddressIdentifierType();
                ebi61AddressIdentifierType2.setAddressIdentifierType(ebi61AddressIdentifierType.getID().getSchemeID());
                ebi61AddressIdentifierType2.setValue(string4);
                ebi61AddressType.addAddressIdentifier(ebi61AddressIdentifierType2);
                if (ebi61AddressType.hasNoAddressIdentifierEntries()) {
                    errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName(string + "/PartyIdentification[" + n + "]")).errorText(AbstractToEbInterfaceConverter.EText.PARTY_UNSUPPORTED_ADDRESS_IDENTIFIER.getDisplayTextWithArgs(locale2, new Object[]{string4, ebi61AddressIdentifierType.getID().getSchemeID()}))).build());
                }
                ++n;
            }
        }
        if (bl) {
            AbstractToEbInterface61Converter.validateAddressData(ebi61AddressType, string, errorList, locale2);
        }
        return ebi61AddressType;
    }

    @Nonnull
    protected static String getAggregated(@Nonnull Iterable<DescriptionType> iterable) {
        return StringHelper.getImplodedMapped((char)'\n', iterable, TextType::getValue);
    }

    protected static boolean isAddressIncomplete(@Nonnull Ebi61AddressType ebi61AddressType) {
        return StringHelper.hasNoText((String)ebi61AddressType.getName()) || StringHelper.hasNoText((String)ebi61AddressType.getTown()) || StringHelper.hasNoText((String)ebi61AddressType.getZIP()) || ebi61AddressType.getCountry() == null;
    }

    @Nonnull
    public static Ebi61DeliveryType convertDelivery(@Nonnull DeliveryType deliveryType, @Nonnull String string, @Nullable CustomerPartyType customerPartyType, @Nonnull ErrorList errorList, @Nonnull Locale locale, @Nonnull Locale locale2) {
        AddressType addressType;
        Ebi61DeliveryType ebi61DeliveryType = new Ebi61DeliveryType();
        ebi61DeliveryType.setDeliveryID(deliveryType.getIDValue());
        ebi61DeliveryType.setDate(deliveryType.getActualDeliveryDateValue());
        PartyType partyType = deliveryType.getDeliveryParty();
        Ebi61AddressType ebi61AddressType = null;
        if (partyType != null) {
            ebi61AddressType = AbstractToEbInterface61Converter.convertParty(partyType, "DeliveryParty", errorList, locale, locale2, false);
            ebi61DeliveryType.setAddress(ebi61AddressType);
            ebi61DeliveryType.setContact(AbstractToEbInterface61Converter.convertContact(partyType, "DeliveryParty", ebi61AddressType.getName(), errorList, locale2, true));
        }
        if ((ebi61AddressType == null || AbstractToEbInterface61Converter.isAddressIncomplete(ebi61AddressType)) && (addressType = deliveryType.getDeliveryAddress()) != null) {
            if (ebi61AddressType == null) {
                ebi61AddressType = new Ebi61AddressType();
            }
            AbstractToEbInterface61Converter.setAddressData(addressType, ebi61AddressType, locale);
            ebi61DeliveryType.setAddress(ebi61AddressType);
        }
        if ((addressType = deliveryType.getDeliveryLocation()) != null && addressType.getAddress() != null) {
            ebi61DeliveryType.setDescription(AbstractToEbInterface61Converter.getAggregated(addressType.getDescription()));
            if (ebi61AddressType == null || AbstractToEbInterface61Converter.isAddressIncomplete(ebi61AddressType)) {
                if (ebi61AddressType == null) {
                    ebi61AddressType = new Ebi61AddressType();
                }
                AbstractToEbInterface61Converter.setAddressData(addressType.getAddress(), ebi61AddressType, locale);
                ebi61DeliveryType.setAddress(ebi61AddressType);
            }
        }
        if (ebi61AddressType != null) {
            PartyNameType partyNameType;
            Iterator iterator;
            String string2 = null;
            if (deliveryType.getDeliveryParty() != null) {
                iterator = deliveryType.getDeliveryParty().getPartyName().iterator();
                while (iterator.hasNext() && !StringHelper.hasText((String)(string2 = StringHelper.trim((String)(partyNameType = (PartyNameType)iterator.next()).getNameValue())))) {
                }
            }
            if (StringHelper.hasNoText(string2) && addressType != null) {
                string2 = StringHelper.trim((String)addressType.getNameValue());
            }
            if (StringHelper.hasNoText(string2) && customerPartyType != null && customerPartyType.getParty() != null) {
                iterator = customerPartyType.getParty().getPartyName().iterator();
                while (iterator.hasNext() && !StringHelper.hasText((String)(string2 = StringHelper.trim((String)(partyNameType = (PartyNameType)iterator.next()).getNameValue())))) {
                }
                if (StringHelper.hasNoText((String)string2)) {
                    iterator = customerPartyType.getParty().getPartyLegalEntity().iterator();
                    while (iterator.hasNext() && !StringHelper.hasText((String)(string2 = StringHelper.trim((String)(partyNameType = (PartyLegalEntityType)iterator.next()).getRegistrationNameValue())))) {
                    }
                }
            }
            ebi61AddressType.setName(string2);
            if (StringHelper.hasNoText((String)ebi61AddressType.getName())) {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName(string + "/DeliveryParty")).errorText(AbstractToEbInterfaceConverter.EText.DELIVERY_WITHOUT_NAME.getDisplayText(locale2))).build());
            }
            AbstractToEbInterface61Converter.validateAddressData(ebi61AddressType, string + "/DeliveryParty", errorList, locale2);
        }
        return ebi61DeliveryType;
    }

    @Nullable
    protected static final Ebi61DocumentTypeType getAsDocumentTypeType(String ... stringArray) {
        if (stringArray != null) {
            for (String string : stringArray) {
                if (string == null) continue;
                String string2 = string.trim();
                try {
                    return Ebi61DocumentTypeType.fromValue((String)string2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if ("326".equals(string2)) {
                        return Ebi61DocumentTypeType.INVOICE_FOR_PARTIAL_DELIVERY;
                    }
                    if ("386".equals(string2)) {
                        return Ebi61DocumentTypeType.INVOICE_FOR_ADVANCE_PAYMENT;
                    }
                    if (!"389".equals(string2)) continue;
                    return Ebi61DocumentTypeType.SELF_BILLING;
                }
            }
        }
        return null;
    }

    protected static void convertRelatedDocuments(@Nonnull List<BillingReferenceType> list, @Nonnull Ebi61InvoiceType ebi61InvoiceType) {
        for (BillingReferenceType billingReferenceType : list) {
            Ebi61RelatedDocumentType ebi61RelatedDocumentType;
            if (billingReferenceType.getInvoiceDocumentReference() != null && billingReferenceType.getInvoiceDocumentReference().getIDValue() != null) {
                ebi61RelatedDocumentType = new Ebi61RelatedDocumentType();
                ebi61RelatedDocumentType.setInvoiceNumber(billingReferenceType.getInvoiceDocumentReference().getIDValue());
                ebi61RelatedDocumentType.setInvoiceDate(billingReferenceType.getInvoiceDocumentReference().getIssueDateValue());
                ebi61RelatedDocumentType.setDocumentType(Ebi61DocumentTypeType.INVOICE);
                ebi61InvoiceType.addRelatedDocument(ebi61RelatedDocumentType);
                continue;
            }
            if (billingReferenceType.getCreditNoteDocumentReference() == null || billingReferenceType.getCreditNoteDocumentReference().getIDValue() == null) continue;
            ebi61RelatedDocumentType = new Ebi61RelatedDocumentType();
            ebi61RelatedDocumentType.setInvoiceNumber(billingReferenceType.getCreditNoteDocumentReference().getIDValue());
            ebi61RelatedDocumentType.setInvoiceDate(billingReferenceType.getCreditNoteDocumentReference().getIssueDateValue());
            ebi61RelatedDocumentType.setDocumentType(Ebi61DocumentTypeType.CREDIT_MEMO);
            ebi61InvoiceType.addRelatedDocument(ebi61RelatedDocumentType);
        }
    }

    protected static void convertReferencedDocuments(@Nonnull List<DocumentReferenceType> list, @Nonnull Ebi61InvoiceType ebi61InvoiceType) {
        for (DocumentReferenceType documentReferenceType : list) {
            if (!StringHelper.hasText((String)documentReferenceType.getIDValue()) || documentReferenceType.getAttachment() != null) continue;
            Ebi61RelatedDocumentType ebi61RelatedDocumentType = new Ebi61RelatedDocumentType();
            ebi61RelatedDocumentType.setInvoiceNumber(documentReferenceType.getIDValue());
            ebi61RelatedDocumentType.setInvoiceDate(documentReferenceType.getIssueDateValue());
            CommonsArrayList commonsArrayList = new CommonsArrayList();
            for (DocumentDescriptionType documentDescriptionType : documentReferenceType.getDocumentDescription()) {
                commonsArrayList.add((Object)documentDescriptionType.getValue());
            }
            ebi61RelatedDocumentType.setComment(StringHelper.getImplodedNonEmpty((char)'\n', (Iterable)commonsArrayList));
            if (documentReferenceType.getDocumentTypeCode() != null) {
                ebi61RelatedDocumentType.setDocumentType(AbstractToEbInterface61Converter.getAsDocumentTypeType(documentReferenceType.getDocumentTypeCode().getName(), documentReferenceType.getDocumentTypeCodeValue()));
            }
            ebi61InvoiceType.addRelatedDocument(ebi61RelatedDocumentType);
        }
    }

    private static void _setPaymentMeansComment(@Nonnull PaymentMeansType paymentMeansType, @Nonnull Ebi61PaymentMethodType ebi61PaymentMethodType) {
        if (paymentMeansType.hasInstructionNoteEntries()) {
            CommonsArrayList commonsArrayList = new CommonsArrayList();
            for (InstructionNoteType instructionNoteType : paymentMeansType.getInstructionNote()) {
                commonsArrayList.add((Object)StringHelper.trim((String)instructionNoteType.getValue()));
            }
            if (commonsArrayList.isNotEmpty()) {
                ebi61PaymentMethodType.setComment(StringHelper.getImplodedNonEmpty((char)'\n', (Iterable)commonsArrayList));
            }
        }
    }

    protected void convertPayment(@Nonnull Supplier<XMLOffsetDate> supplier, @Nonnull Supplier<List<PaymentMeansType>> supplier2, @Nonnull Supplier<PartyType> supplier3, @Nonnull Supplier<SupplierPartyType> supplier4, @Nonnull Supplier<List<PaymentTermsType>> supplier5, @Nonnull Supplier<MonetaryTotalType> supplier6, @Nonnull ErrorList errorList, @Nonnull Ebi61InvoiceType ebi61InvoiceType, boolean bl) {
        Ebi61AccountType ebi61AccountType;
        Object object7;
        Object object2;
        Object object3;
        Ebi61UniversalBankTransactionType ebi61UniversalBankTransactionType2;
        Object object4;
        Ebi61PaymentMethodType ebi61PaymentMethodType = new Ebi61PaymentMethodType();
        Ebi61PaymentConditionsType ebi61PaymentConditionsType = new Ebi61PaymentConditionsType();
        int n = 0;
        for (PaymentMeansType object5 : supplier2.get()) {
            String string = StringHelper.trim((String)object5.getPaymentMeansCodeValue());
            if (AbstractToEbInterface61Converter.isUniversalBankTransaction(string)) {
                object4 = StringHelper.trim((String)object5.getPaymentChannelCodeValue());
                if (AbstractToEbInterface61Converter.isIBAN((String)object4)) {
                    PartyNameType partyNameType;
                    Object object6;
                    String string2;
                    String string3;
                    AbstractToEbInterface61Converter._setPaymentMeansComment(object5, ebi61PaymentMethodType);
                    ebi61UniversalBankTransactionType2 = new Ebi61UniversalBankTransactionType();
                    object3 = object5.getInstructionID();
                    if (object3 != null && StringHelper.hasText((String)(string3 = StringHelper.trim((String)object3.getValue())))) {
                        if (string3.length() > 35) {
                            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("PaymentMeans[" + n + "]/InstructionID")).errorText(AbstractToEbInterfaceConverter.EText.PAYMENT_ID_TOO_LONG_CUT.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{string3}))).build());
                            string3 = string3.substring(0, 35);
                        }
                        object2 = new Ebi61PaymentReferenceType();
                        object2.setValue(string3);
                        ebi61UniversalBankTransactionType2.setPaymentReference((Ebi61PaymentReferenceType)object2);
                    }
                    if (ebi61UniversalBankTransactionType2.getPaymentReference() == null) {
                        int n2 = 0;
                        for (Object object7 : object5.getPaymentID()) {
                            string2 = StringHelper.trim((String)object7.getValue());
                            if (StringHelper.hasText((String)string2)) {
                                if (string2.length() > 35) {
                                    errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("PaymentMeans[" + n + "]/PaymentID[" + n2 + "]")).errorText(AbstractToEbInterfaceConverter.EText.PAYMENT_ID_TOO_LONG_CUT.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{string2}))).build());
                                    string2 = string2.substring(0, 35);
                                }
                                object6 = new Ebi61PaymentReferenceType();
                                object6.setValue(string2);
                                ebi61UniversalBankTransactionType2.setPaymentReference(object6);
                            }
                            ++n2;
                        }
                    }
                    ebi61AccountType = new Ebi61AccountType();
                    object2 = object5.getPayeeFinancialAccount();
                    if (object2 != null && object2.getFinancialInstitutionBranch() != null && object2.getFinancialInstitutionBranch().getFinancialInstitution() != null && StringHelper.hasText((String)(object7 = object2.getFinancialInstitutionBranch().getFinancialInstitution()).getIDValue())) {
                        string2 = StringHelper.trim((String)object7.getID().getValue());
                        object6 = StringHelper.trim((String)object7.getID().getSchemeID());
                        boolean bl2 = AbstractToEbInterface61Converter.isBIC((String)object6);
                        if (bl2) {
                            ebi61AccountType.setBIC(string2);
                        } else {
                            ebi61AccountType.setBankName(string2);
                        }
                        if (bl2 && (StringHelper.hasNoText((String)string2) || !RegExHelper.stringMatchesPattern((String)"[0-9A-Za-z]{8}([0-9A-Za-z]{3})?", (String)string2))) {
                            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("PaymentMeans[" + n + "]/PayeeFinancialAccount/FinancialInstitutionBranch/FinancialInstitution/ID")).errorText(AbstractToEbInterfaceConverter.EText.BIC_INVALID.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{string2}))).build());
                            ebi61AccountType.setBIC(null);
                        }
                    }
                    object7 = object2 != null ? StringHelper.trim((String)object2.getIDValue()) : null;
                    ebi61AccountType.setIBAN((String)object7);
                    if (StringHelper.getLength((CharSequence)object7) > 34) {
                        errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("PaymentMeans[" + n + "]/PayeeFinancialAccount/ID")).errorText(AbstractToEbInterfaceConverter.EText.IBAN_TOO_LONG_STRIPPING.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{object7, 34}))).build());
                        ebi61AccountType.setIBAN(((String)object7).substring(0, 34));
                    }
                    String string4 = string2 = object2 != null ? object2.getNameValue() : null;
                    if (StringHelper.hasNoText((String)string2) && (object6 = supplier3.get()) != null) {
                        Iterator iterator = object6.getPartyName().iterator();
                        while (iterator.hasNext() && !StringHelper.hasText((String)(string2 = StringHelper.trim((String)(partyNameType = (PartyNameType)iterator.next()).getNameValue())))) {
                        }
                    }
                    if (StringHelper.hasNoText((String)string2) && (object6 = supplier4.get().getParty()) != null) {
                        Iterator iterator = object6.getPartyName().iterator();
                        while (iterator.hasNext() && !StringHelper.hasText((String)(string2 = StringHelper.trim((String)(partyNameType = (PartyNameType)iterator.next()).getNameValue())))) {
                        }
                    }
                    ebi61AccountType.setBankAccountOwner(string2);
                    ebi61UniversalBankTransactionType2.addBeneficiaryAccount(ebi61AccountType);
                    ebi61PaymentMethodType.setUniversalBankTransaction(ebi61UniversalBankTransactionType2);
                    ebi61InvoiceType.setPaymentMethod(ebi61PaymentMethodType);
                    ebi61PaymentConditionsType.setDueDate(object5.getPaymentDueDateValue());
                    break;
                }
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("PaymentMeans[" + n + "]")).errorText(AbstractToEbInterfaceConverter.EText.PAYMENTMEANS_UNSUPPORTED_CHANNELCODE.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{object4}))).build());
            } else {
                if (AbstractToEbInterface61Converter.isSEPADirectDebit(string)) {
                    AbstractToEbInterface61Converter._setPaymentMeansComment(object5, ebi61PaymentMethodType);
                    object4 = new Ebi61SEPADirectDebitType();
                    object4.setType(Ebi61SEPADirectDebitTypeType.B_2_C);
                    object4.setBIC(null);
                    object4.setIBAN(null);
                    object4.setBankAccountOwner(null);
                    object4.setCreditorID(null);
                    object4.setMandateReference(null);
                    object4.setDebitCollectionDate((XMLOffsetDate)null);
                    ebi61PaymentMethodType.setSEPADirectDebit((Ebi61SEPADirectDebitType)object4);
                    ebi61InvoiceType.setPaymentMethod(ebi61PaymentMethodType);
                    ebi61PaymentConditionsType.setDueDate(object5.getPaymentDueDateValue());
                    break;
                }
                if (MathHelper.isEQ0((BigDecimal)ebi61InvoiceType.getPayableAmount())) {
                    AbstractToEbInterface61Converter._setPaymentMeansComment(object5, ebi61PaymentMethodType);
                    object4 = new Ebi61NoPaymentType();
                    ebi61PaymentMethodType.setNoPayment((Ebi61NoPaymentType)object4);
                    break;
                }
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("PaymentMeans[" + n + "]")).errorText(AbstractToEbInterfaceConverter.EText.PAYMENTMEANS_CODE_INVALID.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{string, this.getOrString(", ", "30", "31", "42", "58"), this.getOrString(", ", "59")}))).build());
            }
            ++n;
        }
        if (ebi61InvoiceType.getPaymentMethod() == null && this.m_aSettings.isInvoicePaymentMethodMandatory()) {
            if (bl) {
                Ebi61NoPaymentType ebi61NoPaymentType = new Ebi61NoPaymentType();
                ebi61PaymentMethodType.setNoPayment(ebi61NoPaymentType);
                ebi61InvoiceType.setPaymentMethod(ebi61PaymentMethodType);
            } else {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName(bl ? "CreditNote" : "Invoice")).errorText(AbstractToEbInterfaceConverter.EText.ERB_NO_PAYMENT_METHOD.getDisplayText(this.m_aDisplayLocale))).build());
            }
        }
        if (ebi61PaymentConditionsType.getDueDate() == null) {
            ebi61PaymentConditionsType.setDueDate(supplier.get());
        }
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        int n3 = 0;
        for (PaymentTermsType paymentTermsType : supplier5.get()) {
            for (Ebi61UniversalBankTransactionType ebi61UniversalBankTransactionType2 : paymentTermsType.getNote()) {
                object3 = StringHelper.trim((String)ebi61UniversalBankTransactionType2.getValue());
                if (!StringHelper.hasText((String)object3)) continue;
                commonsArrayList.add(object3);
            }
            if (paymentTermsType.getPaymentDueDate() != null) {
                object4 = paymentTermsType.getPaymentDueDateValue();
                ebi61UniversalBankTransactionType2 = ebi61PaymentConditionsType.getDueDate();
                if (object4 != null && ebi61UniversalBankTransactionType2 != null) {
                    if (!ebi61UniversalBankTransactionType2.equals(object4)) {
                        errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("PaymentTerms[" + n3 + "]/PaymentDueDate")).errorText(AbstractToEbInterfaceConverter.EText.PAYMENT_DUE_DATE_ALREADY_CONTAINED.getDisplayText(this.m_aDisplayLocale))).build());
                    }
                } else {
                    ebi61PaymentConditionsType.setDueDate((XMLOffsetDate)object4);
                }
                if ((object3 = paymentTermsType.getPaymentPercentValue()) != null && MathHelper.isGT0((BigDecimal)object3) && MathHelper.isLT100((BigDecimal)object3)) {
                    ebi61AccountType = supplier6.get();
                    BigDecimal bigDecimal = object2 = ebi61AccountType == null ? null : ebi61AccountType.getPayableAmountValue();
                    if (object2 != null) {
                        object7 = MathHelper.getPercentValue((BigDecimal)object2, (BigDecimal)object3, (int)2, (RoundingMode)ROUNDING_MODE);
                        ebi61PaymentConditionsType.setMinimumPayment((BigDecimal)object7);
                    }
                }
            } else if (paymentTermsType.getSettlementDiscountPercent() != null) {
                if (paymentTermsType.getSettlementPeriod() == null || paymentTermsType.getSettlementPeriod().getEndDate() == null) {
                    errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("PaymentTerms[" + n3 + "]/SettlementPeriod")).errorText(AbstractToEbInterfaceConverter.EText.SETTLEMENT_PERIOD_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
                } else {
                    object4 = new Ebi61DiscountType();
                    object4.setPaymentDate(paymentTermsType.getSettlementPeriod().getEndDateValue());
                    object4.setPercentage(paymentTermsType.getSettlementDiscountPercentValue());
                    object4.setAmount(paymentTermsType.getAmountValue());
                    ebi61PaymentConditionsType.addDiscount((Ebi61DiscountType)object4);
                }
            } else if (paymentTermsType.getPenaltySurchargePercent() != null) {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("PaymentTerms[" + n3 + "]")).errorText(AbstractToEbInterfaceConverter.EText.PENALTY_NOT_ALLOWED.getDisplayText(this.m_aDisplayLocale))).build());
            }
            ++n3;
        }
        if (!commonsArrayList.isEmpty()) {
            ebi61PaymentConditionsType.setComment(StringHelper.getImploded((char)'\n', (Iterable)commonsArrayList));
        }
        if (ebi61PaymentConditionsType.getDueDate() == null) {
            if (ebi61PaymentConditionsType.hasDiscountEntries()) {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("PaymentMeans/PaymentDueDate")).errorText(AbstractToEbInterfaceConverter.EText.DISCOUNT_WITHOUT_DUEDATE.getDisplayText(this.m_aDisplayLocale))).build());
            }
        } else {
            ebi61InvoiceType.setPaymentConditions(ebi61PaymentConditionsType);
        }
    }
}

