/*
 * Decompiled with CFR 0.152.
 */
package at.austriapro.ebinterface.ubl.from;

import at.austriapro.ebinterface.ubl.AbstractConverter;
import at.austriapro.ebinterface.ubl.from.IToEbinterfaceSettings;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Translatable;
import com.helger.commons.error.SingleError;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.string.StringHelper;
import com.helger.commons.text.IHasText;
import com.helger.commons.text.IMultilingualText;
import com.helger.commons.text.display.IHasDisplayTextWithArgs;
import com.helger.commons.text.resolve.DefaultTextResolver;
import com.helger.commons.text.util.TextHelper;
import com.helger.peppolid.IProcessIdentifier;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.AllowanceChargeType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.TaxCategoryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.TaxSubtotalType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.TaxTotalType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.AllowanceChargeReasonType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.UBLVersionIDType;
import oasis.names.specification.ubl.schema.xsd.creditnote_21.CreditNoteType;
import oasis.names.specification.ubl.schema.xsd.invoice_21.InvoiceType;

@Immutable
public abstract class AbstractToEbInterfaceConverter
extends AbstractConverter {
    public static final String EBI_GENERATING_SYSTEM_40 = "UBL 2.1 to ebInterface 4.0 converter";
    public static final String EBI_GENERATING_SYSTEM_41 = "UBL 2.1 to ebInterface 4.1 converter";
    public static final String EBI_GENERATING_SYSTEM_42 = "UBL 2.1 to ebInterface 4.2 converter";
    public static final String EBI_GENERATING_SYSTEM_43 = "UBL 2.1 to ebInterface 4.3 converter";
    public static final String EBI_GENERATING_SYSTEM_50 = "UBL 2.1 to ebInterface 5.0 converter";
    public static final String EBI_GENERATING_SYSTEM_60 = "UBL 2.1 to ebInterface 6.0 converter";
    public static final String EBI_GENERATING_SYSTEM_61 = "UBL 2.1 to ebInterface 6.1 converter";
    protected final IToEbinterfaceSettings m_aSettings;

    protected AbstractToEbInterfaceConverter(@Nonnull Locale locale, @Nonnull Locale locale2, @Nonnull IToEbinterfaceSettings iToEbinterfaceSettings) {
        super(locale, locale2);
        this.m_aSettings = (IToEbinterfaceSettings)ValueEnforcer.notNull((Object)iToEbinterfaceSettings, (String)"Settings");
    }

    @Nonnull
    protected static String getAllowanceChargeComment(@Nonnull AllowanceChargeType allowanceChargeType) {
        StringBuilder stringBuilder = new StringBuilder();
        for (AllowanceChargeReasonType allowanceChargeReasonType : allowanceChargeType.getAllowanceChargeReason()) {
            String string = StringHelper.trim((String)allowanceChargeReasonType.getValue());
            if (!StringHelper.hasText((String)string)) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append('\n');
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    protected final void checkInvoiceConsistency(@Nonnull InvoiceType invoiceType, @Nonnull ErrorList errorList) {
        Object object;
        String string;
        String string2;
        UBLVersionIDType uBLVersionIDType = invoiceType.getUBLVersionID();
        if (uBLVersionIDType == null) {
            if (this.m_aSettings.isUBLVersionIDMandatory()) {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("UBLVersionID")).errorText(EText.NO_UBL_VERSION_ID.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{"2.0", "2.1", "2.2", "2.3"}))).build());
            }
        } else {
            string2 = StringHelper.trim((String)uBLVersionIDType.getValue());
            if (!("2.0".equals(string2) || "2.1".equals(string2) || "2.2".equals(string2) || "2.3".equals(string2))) {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("UBLVersionID")).errorText(EText.INVALID_UBL_VERSION_ID.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{string2, "2.0", "2.1", "2.2", "2.3"}))).build());
            }
        }
        if ((string2 = invoiceType.getProfileID()) == null) {
            if (this.m_aSettings.isUBLProfileIDMandatory()) {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("ProfileID")).errorText(EText.NO_PROFILE_ID.getDisplayText(this.m_aDisplayLocale))).build());
            }
        } else {
            string = StringHelper.trim((String)string2.getValue());
            object = (IProcessIdentifier)this.m_aSettings.getProfileIDResolver().apply(string);
            if (object == null) {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("ProfileID")).errorText(EText.INVALID_PROFILE_ID.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{string}))).build());
            }
        }
        if ((string = invoiceType.getInvoiceTypeCode()) == null) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("InvoiceTypeCode")).errorText(EText.NO_INVOICE_TYPECODE.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{StringHelper.getImploded((String)", ", (Iterable)INVOICE_TYPE_CODES)}))).build());
        } else {
            object = StringHelper.trim((String)string.getValue());
            if (!INVOICE_TYPE_CODES.contains(object)) {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("InvoiceTypeCode")).errorText(EText.INVALID_INVOICE_TYPECODE.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{object, StringHelper.getImploded((String)", ", (Iterable)INVOICE_TYPE_CODES)}))).build());
            }
        }
    }

    protected final void checkCreditNoteConsistency(@Nonnull CreditNoteType creditNoteType, @Nonnull ErrorList errorList) {
        String string;
        UBLVersionIDType uBLVersionIDType = creditNoteType.getUBLVersionID();
        if (uBLVersionIDType == null) {
            if (this.m_aSettings.isUBLVersionIDMandatory()) {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("UBLVersionID")).errorText(EText.NO_UBL_VERSION_ID.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{"2.0", "2.1", "2.2", "2.3"}))).build());
            }
        } else {
            string = StringHelper.trim((String)uBLVersionIDType.getValue());
            if (!("2.0".equals(string) || "2.1".equals(string) || "2.2".equals(string) || "2.3".equals(string))) {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("UBLVersionID")).errorText(EText.INVALID_UBL_VERSION_ID.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{string, "2.0", "2.1", "2.2", "2.3"}))).build());
            }
        }
        if ((string = creditNoteType.getProfileID()) == null) {
            if (this.m_aSettings.isUBLProfileIDMandatory()) {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("ProfileID")).errorText(EText.NO_PROFILE_ID.getDisplayText(this.m_aDisplayLocale))).build());
            }
        } else {
            String string2 = StringHelper.trim((String)string.getValue());
            IProcessIdentifier iProcessIdentifier = (IProcessIdentifier)this.m_aSettings.getProfileIDResolver().apply(string2);
            if (iProcessIdentifier == null) {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("ProfileID")).errorText(EText.INVALID_PROFILE_ID.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{string2}))).build());
            }
        }
    }

    protected static final boolean isTaxExemptionCategoryID(@Nullable String string) {
        return "AE".equals(string) || "E".equals(string) || "O".equals(string);
    }

    protected static boolean isVATSchemeID(String string) {
        if ("VAT".equals(string)) {
            return true;
        }
        return "VA".equals(string);
    }

    @Nullable
    protected static TaxCategoryType findTaxCategory(@Nonnull List<TaxTotalType> list) {
        for (TaxTotalType taxTotalType : list) {
            for (TaxSubtotalType taxSubtotalType : taxTotalType.getTaxSubtotal()) {
                if (!AbstractToEbInterfaceConverter.isVATSchemeID(taxSubtotalType.getTaxCategory().getTaxScheme().getIDValue())) continue;
                return taxSubtotalType.getTaxCategory();
            }
        }
        return null;
    }

    @Nonnull
    protected final String getOrString(@Nonnull String string, String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        if (stringArray != null) {
            int n = stringBuilder.length() - 2;
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    if (i == n) {
                        stringBuilder.append(EText.OR.getDisplayText(this.m_aDisplayLocale));
                    } else {
                        stringBuilder.append(string);
                    }
                }
                stringBuilder.append(stringArray[i]);
            }
        }
        return stringBuilder.toString();
    }

    protected static boolean isUniversalBankTransaction(@Nullable String string) {
        return "30".equals(string) || "31".equals(string) || "42".equals(string) || "58".equals(string);
    }

    protected static boolean isDirectDebit(@Nullable String string) {
        return "49".equals(string);
    }

    protected static boolean isSEPADirectDebit(@Nullable String string) {
        return "59".equals(string);
    }

    protected static boolean isIBAN(@Nullable String string) {
        return StringHelper.hasNoText((String)string) || "IBAN".equals(string);
    }

    protected static boolean isBIC(@Nullable String string) {
        return StringHelper.hasNoText((String)string) || "BIC".equalsIgnoreCase(string);
    }

    @Translatable
    public static enum EText implements IHasDisplayTextWithArgs
    {
        OR("oder", "or"),
        NO_UBL_VERSION_ID("Die UBLVersionID fehlt. Es wird der Wert ''{0}'', ''{1}'', ''{2}'' oder ''{3}'' erwartet.", "No UBLVersionID present. It must be ''{0}'', ''{1}'', ''{2}'' or ''{3}''."),
        INVALID_UBL_VERSION_ID("Die UBLVersionID ''{0}'' ist ung\u00fcltig. Diese muss den Wert ''{1}'', ''{2}'', ''{3}'' oder ''{4}'' haben.", "Invalid UBLVersionID value ''{0}'' present. It must be ''{1}'', ''{2}'', ''{3}'' or ''{4}''."),
        NO_PROFILE_ID("Die ProfileID fehlt", "No ProfileID present."),
        INVALID_PROFILE_ID("Die ProfileID ''{0}'' ist ung\u00fcltig.", "Invalid ProfileID value ''{0}'' present."),
        NO_CUSTOMIZATION_ID("Die CustomizationID fehlt", "No CustomizationID present."),
        INVALID_CUSTOMIZATION_SCHEME_ID("Die CustomizationID schemeID ''{0}'' ist ung\u00fcltig. Diese muss den Wert ''{1}'' haben.", "Invalid CustomizationID schemeID value ''{0}'' present. It must be ''{1}''."),
        INVALID_CUSTOMIZATION_ID("Die angegebene CustomizationID ''{0}'' ist ung\u00fcltig. Sie wird vom angegebenen Profil nicht unterst\u00fctzt.", "Invalid CustomizationID value ''{0}'' present. It is not supported by the passed profile."),
        NO_INVOICE_TYPECODE("Der InvoiceTypeCode fehlt. Es wird einer der folgenden Werte erwartet: {0}", "No InvoiceTypeCode present. It must be one of the following values: {0}"),
        INVALID_INVOICE_TYPECODE("Der InvoiceTypeCode ''{0}'' ist ung\u00fcltig.Es wird einer der folgenden Werte erwartet: {1}", "Invalid InvoiceTypeCode value ''{0}'' present. It must be one of the following values: {1}"),
        ADDRESS_NO_STREET("In der Adresse fehlt die Stra\u00dfe.", "Address is missing a street name."),
        ADDRESS_NO_CITY("In der Adresse fehlt der Name der Stadt.", "Address is missing a city name."),
        ADDRESS_NO_ZIPCODE("In der Adresse fehlt die PLZ.", "Address is missing a ZIP code."),
        ADDRESS_INVALID_COUNTRY("Der angegebene L\u00e4ndercode ''{0}'' ist ung\u00fcltig.", "The provided country code ''{0}'' is invalid."),
        ADDRESS_NO_COUNTRY("In der Adresse fehlt der Name des Landes.", "Address is missing a country."),
        CONTACT_NO_NAME("Im Kontakt fehlr der Name.", "Contact is missing a name."),
        MULTIPLE_PARTIES("Es sind mehrere Partynamen vorhanden - nur der erste wird verwendet.", "Multiple party names present - only the first one is used."),
        PARTY_NO_NAME("Der Name der Party fehlt.", "Party name is missing."),
        PARTY_UNSUPPORTED_ENDPOINT("Ignoriere den Enpunkt ''{0}'' des Typs ''{1}''.", "Ignoring endpoint ID ''{0}'' of type ''{1}''."),
        PARTY_UNSUPPORTED_ADDRESS_IDENTIFIER("Ignoriere die ID ''{0}'' des Typs ''{1}''.", "Ignoring identification ''{0}'' of type ''{1}''."),
        ORDERLINE_REF_ID_EMPTY("Es muss ein Wert f\u00fcr die Bestellpositionsnummer angegeben werden.", "A value must be provided for the order line reference ID."),
        ALPHANUM_ID_TYPE_CHANGE("''{0}'' ist ein ung\u00fcltiger Typ und wurde auf ''{1}'' ge\u00e4ndert.", "''{0}'' is an invalid value and was changed to ''{1}''."),
        INVALID_CURRENCY_CODE("Der angegebene W\u00e4hrungscode ''{0}'' ist ung\u00fcltig.", "Invalid currency code ''{0}'' provided."),
        MISSING_INVOICE_NUMBER("Es wurde keine Rechnungsnummer angegeben.", "No invoice number was provided."),
        MISSING_INVOICE_DATE("Es wurde keine Rechnungsdatum angegeben.", "No invoice date was provided."),
        BILLER_VAT_MISSING("Die UID-Nummer des Rechnungsstellers fehlt. Verwenden Sie 'ATU00000000' f\u00fcr \u00f6sterreichische Rechnungssteller an wenn keine UID-Nummer notwendig ist.", "Failed to get biller VAT identification number. Use 'ATU00000000' for Austrian invoice recipients if no VAT identification number is required."),
        ERB_CUSTOMER_ASSIGNED_ACCOUNTID_MISSING("Die ID des Rechnungsstellers beim Rechnungsempf\u00e4nger fehlt.", "Failed to get customer assigned account ID for supplier."),
        INVOICE_RECIPIENT_VAT_MISSING("Die UID-Nummer des Rechnungsempf\u00e4ngers fehlt. Verwenden Sie 'ATU00000000' f\u00fcr \u00f6sterreichische Empf\u00e4nger an wenn keine UID-Nummer notwendig ist.", "Failed to get invoice recipient VAT identification number. Use 'ATU00000000' for Austrian invoice recipients if no VAT identification number is required."),
        INVOICE_RECIPIENT_PARTY_MISSING("Die Adressdaten des Rechnungsempf\u00e4ngers fehlen.", "The party information of the invoice recipient are missing."),
        INVOICE_RECIPIENT_PARTY_SUPPLIER_ASSIGNED_ACCOUNT_ID_MISSING("Die ID des Auftraggebers im System des Rechnungsstellers fehlt.", "Failed to get supplier assigned account ID."),
        ORDERING_PARTY_VAT_MISSING("Die UID-Nummer des Auftraggebers fehlt. Verwenden Sie 'ATU00000000' f\u00fcr \u00f6sterreichische Empf\u00e4nger an wenn keine UID-Nummer notwendig ist.", "Failed to get ordering party VAT identification number. Use 'ATU00000000' for Austrian invoice recipients if no VAT identification number is required."),
        ORDERING_PARTY_PARTY_MISSING("Die Adressdaten des Auftraggebers fehlen.", "The party information of the ordering party are missing."),
        ORDERING_PARTY_SUPPLIER_ASSIGNED_ACCOUNT_ID_MISSING("Die ID des Auftraggebers im System des Rechnungsstellers fehlt.", "Failed to get supplier assigned account ID."),
        ORDER_REFERENCE_MISSING("Die Auftragsreferenz fehlt.", "The order reference is missing."),
        ORDER_REFERENCE_MISSING_IGNORE_ORDER_POS("Die Auftragsreferenz fehlt, daher kann auch die Bestellpositionsnummer nicht \u00fcbernommen werden.", "The order reference is missing and therefore the order position number cannot be used."),
        ORDER_REFERENCE_TOO_LONG("Die Auftragsreferenz ''{0}'' ist zu lang und wurde nach {1} Zeichen abgeschnitten.", "Order reference value ''{0}'' is too long and was cut to {1} characters."),
        UNSUPPORTED_TAX_SCHEME_ID("Die Steuerschema ID ''{0}'' ist ung\u00fcltig.", "The tax scheme ID ''{0}'' is invalid."),
        TAX_PERCENT_MISSING("Es konnte kein Steuersatz f\u00fcr diese Steuerkategorie ermittelt werden.", "No tax percentage could be determined for this tax category."),
        TAXABLE_AMOUNT_MISSING("Es konnte kein Steuerbasisbetrag (der Betrag auf den die Steuer anzuwenden ist) f\u00fcr diese Steuerkategorie ermittelt werden.", "No taxable amount could be determined for this tax category."),
        UNSUPPORTED_TAX_SCHEME("Nicht unterst\u00fctztes Steuerschema gefunden: ''{0}'' und ''{1}''.", "Other tax scheme found and ignored: ''{0}'' and ''{1}''."),
        DETAILS_TAX_PERCENTAGE_NOT_FOUND("Der Steuersatz der Rechnungszeile konnte nicht ermittelt werden. Verwende den Standardwert {0}%.", "Failed to resolve tax percentage for invoice line. Defaulting to {0}%."),
        DETAILS_INVALID_POSITION("Die Rechnungspositionsnummer ''{0}'' ist ung\u00fcltig, sie muss gr\u00f6\u00dfer als 0 sein.", "The UBL invoice line ID ''{0}'' is invalid. The ID must be bigger than 0."),
        DETAILS_INVALID_POSITION_SET_TO_INDEX("Die Rechnungspositionsnummer ''{0}'' ist nicht numerisch. Es wird der Index {1} verwendet.", "The UBL invoice line ID ''{0}'' is not numeric. Defaulting to index {1}."),
        DETAILS_INVALID_UNIT("Die Rechnungszeile hat keine Mengeneinheit. Verwende den Standardwert ''{0}''.", "The UBL invoice line has no unit of measure. Defaulting to ''{0}''."),
        DETAILS_INVALID_QUANTITY("Die Rechnungszeile hat keine Menge. Verwende den Standardwert ''{0}''.", "The UBL invoice line has no quantity. Defaulting to ''{0}''."),
        VAT_ITEM_MISSING("Keine einzige Steuersumme gefunden", "No single VAT item found."),
        ALLOWANCE_CHARGE_NO_TAXRATE("Die Steuerprozentrate f\u00fcr den globalen Zuschlag/Abschlag konnte nicht ermittelt werden.", "Failed to resolve tax rate percentage for global AllowanceCharge."),
        PAYMENTMEANS_CODE_INVALID("Der PaymentMeansCode ''{0}'' ist ung\u00fcltig. F\u00fcr \u00dcberweisungen muss {1} verwenden werden und f\u00fcr Lastschriftverfahren {2}.", "The PaymentMeansCode ''{0}'' is invalid. For credit/debit transfer use {1} and for direct debit use {2}."),
        PAYMENT_ID_TOO_LONG_CUT("Die Zahlungsreferenz ''{0}'' ist zu lang und wird abgeschnitten.", "The payment reference ''{0}'' is too long and therefore cut."),
        BIC_INVALID("Der BIC ''{0}'' ist ung\u00fcltig.", "The BIC ''{0}'' is invalid."),
        IBAN_TOO_LONG_STRIPPING("Der IBAN ''{0}'' ist zu lang. Er wurde nach {1} Zeichen abgeschnitten.", "The IBAN ''{0}'' is too long and was cut to {1} characters."),
        PAYMENTMEANS_UNSUPPORTED_CHANNELCODE("Die Zahlungsart mit dem ChannelCode ''{0}'' wird ignoriert.", "The payment means with ChannelCode ''{0}'' are ignored."),
        ERB_NO_PAYMENT_METHOD("Es muss eine Zahlungsart angegeben werden.", "A payment method must be provided."),
        PAYMENT_DUE_DATE_ALREADY_CONTAINED("Es wurde mehr als ein Zahlungsziel gefunden.", "More than one payment due date was found."),
        SETTLEMENT_PERIOD_MISSING("F\u00fcr Skontoeintr\u00e4ge muss mindestens ein Endedatum angegeben werden.", "Discount items require a settlement end date."),
        PENALTY_NOT_ALLOWED("Strafzuschl\u00e4ge werden in ebInterface nicht unterst\u00fctzt.", "Penalty surcharges are not supported in ebInterface."),
        DISCOUNT_WITHOUT_DUEDATE("Skontoeintr\u00e4ge k\u00f6nnen nur angegeben werden, wenn auch ein Zahlungsziel angegeben wurde.", "Discount items can only be provided if a payment due date is present."),
        DELIVERY_WITHOUT_NAME("Wenn eine Delivery/DeliveryLocation/Address angegeben ist muss auch ein Delivery/DeliveryParty/PartyName/Name angegeben werden.", "If a Delivery/DeliveryLocation/Address is present, a Delivery/DeliveryParty/PartyName/Name must also be present."),
        ERB_NO_DELIVERY_DATE("Ein Lieferdatum oder ein Leistungszeitraum muss vorhanden sein.", "A Delivery/DeliveryDate or an InvoicePeriod must be present."),
        PREPAID_NOT_SUPPORTED("Das Element <PrepaidAmount> wird nicht unterst\u00fctzt.", "The <PrepaidAmount> element is not supported!"),
        MISSING_TAXCATEGORY_ID("Das Element <ID> fehlt.", "Element <ID> is missing."),
        MISSING_TAXCATEGORY_ID_VALUE("Das Element <ID> hat keinen Wert.", "Element <ID> has no value."),
        MISSING_TAXCATEGORY_TAXSCHEME_ID("Das Element <ID> fehlt.", "Element <ID> is missing."),
        MISSING_TAXCATEGORY_TAXSCHEME_ID_VALUE("Das Element <ID> hat keinen Wert.", "Element <ID> has no value."),
        EBI40_CANNOT_MIX_VAT_EXEMPTION("In ebInterface 4.0 k\u00f6nnen nicht USt-Informationen und Steuerbefreiungen gemischt werden", "ebInterface 4.0 cannot mix VAT information and tax exemptions");

        private final IMultilingualText m_aTP;

        private EText(String string2, String string3) {
            this.m_aTP = TextHelper.create_DE_EN((String)string2, (String)string3);
        }

        @Nullable
        public String getDisplayText(@Nonnull Locale locale) {
            return DefaultTextResolver.getTextStatic((Enum)this, (IHasText)this.m_aTP, (Locale)locale);
        }
    }
}

