/*
 * Decompiled with CFR 0.152.
 */
package at.austriapro.ebinterface.ubl.from;

import at.austriapro.ebinterface.ubl.from.IProfileIDResolver;
import at.austriapro.ebinterface.ubl.from.IToEbinterfaceSettings;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ToEbinterfaceSettings
implements IToEbinterfaceSettings {
    public static final String DEFAULT_ENFORCED_SUPPLIER_EMAIL_ADDRESS = "no-email-address-provided@peppol.eu";
    private boolean m_bUBLVersionIDMandatory = false;
    private boolean m_bUBLProfileIDMandatory = true;
    private IProfileIDResolver m_aProfileIDResolver = IProfileIDResolver.getDefault();
    private boolean m_bOrderReferenceIDMandatory = false;
    private int m_nOrderReferenceIDMaxLen = -1;
    private boolean m_bDeliveryDateMandatory = false;
    private boolean m_bEnforceSupplierEmailAddress = false;
    private String m_sEnforcedSupplierEmailAddress = "no-email-address-provided@peppol.eu";
    private String m_sFallbackBillersInvoiceRecipientID = null;
    private boolean m_bErrorOnPositionNumber = false;
    private boolean m_bInvoicePaymentMethodMandatory = false;

    @Override
    public boolean isUBLVersionIDMandatory() {
        return this.m_bUBLVersionIDMandatory;
    }

    @Nonnull
    public ToEbinterfaceSettings setUBLVersionIDMandatory(boolean bl) {
        this.m_bUBLVersionIDMandatory = bl;
        return this;
    }

    @Override
    public boolean isUBLProfileIDMandatory() {
        return this.m_bUBLProfileIDMandatory;
    }

    @Nonnull
    public ToEbinterfaceSettings setUBLProfileIDMandatory(boolean bl) {
        this.m_bUBLProfileIDMandatory = bl;
        return this;
    }

    @Override
    @Nonnull
    public IProfileIDResolver getProfileIDResolver() {
        return this.m_aProfileIDResolver;
    }

    @Nonnull
    public ToEbinterfaceSettings setProfileIDResolver(@Nonnull IProfileIDResolver iProfileIDResolver) {
        ValueEnforcer.notNull((Object)iProfileIDResolver, (String)"ProfileIDResolver");
        this.m_aProfileIDResolver = iProfileIDResolver;
        return this;
    }

    @Override
    public boolean isOrderReferenceIDMandatory() {
        return this.m_bOrderReferenceIDMandatory;
    }

    @Nonnull
    public ToEbinterfaceSettings setOrderReferenceIDMandatory(boolean bl) {
        this.m_bOrderReferenceIDMandatory = bl;
        return this;
    }

    @Override
    public int getOrderReferenceMaxLength() {
        return this.m_nOrderReferenceIDMaxLen;
    }

    @Nonnull
    public ToEbinterfaceSettings setOrderReferenceIDMaxLength(int n) {
        this.m_nOrderReferenceIDMaxLen = n;
        return this;
    }

    @Override
    public boolean isDeliveryDateMandatory() {
        return this.m_bDeliveryDateMandatory;
    }

    @Nonnull
    public ToEbinterfaceSettings setDeliveryDateMandatory(boolean bl) {
        this.m_bDeliveryDateMandatory = bl;
        return this;
    }

    @Override
    public boolean isEnforceSupplierEmailAddress() {
        return this.m_bEnforceSupplierEmailAddress;
    }

    @Nonnull
    public ToEbinterfaceSettings setEnforceSupplierEmailAddress(boolean bl) {
        this.m_bEnforceSupplierEmailAddress = bl;
        return this;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getEnforcedSupplierEmailAddress() {
        return this.m_sEnforcedSupplierEmailAddress;
    }

    @Nonnull
    public ToEbinterfaceSettings setEnforcedSupplierEmailAddress(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"EmailAddress");
        this.m_sEnforcedSupplierEmailAddress = string;
        return this;
    }

    @Override
    @Nullable
    public String getFallbackBillersInvoiceRecipientID() {
        return this.m_sFallbackBillersInvoiceRecipientID;
    }

    @Nonnull
    public ToEbinterfaceSettings setFallbackBillersInvoiceRecipientID(@Nullable String string) {
        this.m_sFallbackBillersInvoiceRecipientID = string;
        return this;
    }

    @Override
    public boolean isErrorOnPositionNumber() {
        return this.m_bErrorOnPositionNumber;
    }

    @Nonnull
    public ToEbinterfaceSettings setErrorOnPositionNumber(boolean bl) {
        this.m_bErrorOnPositionNumber = bl;
        return this;
    }

    @Override
    public boolean isInvoicePaymentMethodMandatory() {
        return this.m_bInvoicePaymentMethodMandatory;
    }

    @Nonnull
    public ToEbinterfaceSettings setInvoicePaymentMethodMandatory(boolean bl) {
        this.m_bInvoicePaymentMethodMandatory = bl;
        return this;
    }

    @Nonnull
    public static ToEbinterfaceSettings getERechnungGvAtSettings() {
        return new ToEbinterfaceSettings().setUBLVersionIDMandatory(false).setUBLProfileIDMandatory(true).setOrderReferenceIDMandatory(true).setOrderReferenceIDMaxLength(54).setDeliveryDateMandatory(true).setEnforceSupplierEmailAddress(true).setInvoicePaymentMethodMandatory(true);
    }
}

