/*
 * Decompiled with CFR 0.152.
 */
package at.austriapro.ebinterface.ubl.from.creditnote;

import at.austriapro.ebinterface.ubl.from.AbstractToEbInterface40Converter;
import at.austriapro.ebinterface.ubl.from.AbstractToEbInterfaceConverter;
import at.austriapro.ebinterface.ubl.from.IToEbinterfaceSettings;
import at.austriapro.ebinterface.ubl.from.creditnote.ICustomCreditNoteToEbInterface40Converter;
import at.austriapro.ebinterface.ubl.from.helper.SchemedID;
import at.austriapro.ebinterface.ubl.from.helper.TaxCategoryKey;
import com.helger.commons.CGlobal;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.datetime.XMLOffsetDate;
import com.helger.commons.error.SingleError;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.math.MathHelper;
import com.helger.commons.state.ETriState;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.StringParser;
import com.helger.ebinterface.v40.Ebi40BillerType;
import com.helger.ebinterface.v40.Ebi40DeliveryType;
import com.helger.ebinterface.v40.Ebi40DetailsType;
import com.helger.ebinterface.v40.Ebi40DocumentTypeType;
import com.helger.ebinterface.v40.Ebi40FurtherIdentificationType;
import com.helger.ebinterface.v40.Ebi40InvoiceRecipientType;
import com.helger.ebinterface.v40.Ebi40InvoiceType;
import com.helger.ebinterface.v40.Ebi40ItemListType;
import com.helger.ebinterface.v40.Ebi40ItemType;
import com.helger.ebinterface.v40.Ebi40ListLineItemType;
import com.helger.ebinterface.v40.Ebi40OrderReferenceDetailType;
import com.helger.ebinterface.v40.Ebi40OrderReferenceType;
import com.helger.ebinterface.v40.Ebi40OrderingPartyType;
import com.helger.ebinterface.v40.Ebi40OtherTaxType;
import com.helger.ebinterface.v40.Ebi40PeriodType;
import com.helger.ebinterface.v40.Ebi40ReductionAndSurchargeBaseType;
import com.helger.ebinterface.v40.Ebi40ReductionAndSurchargeDetailsType;
import com.helger.ebinterface.v40.Ebi40ReductionAndSurchargeListLineItemDetailsType;
import com.helger.ebinterface.v40.Ebi40ReductionAndSurchargeType;
import com.helger.ebinterface.v40.Ebi40TaxRateType;
import com.helger.ebinterface.v40.Ebi40TaxType;
import com.helger.ebinterface.v40.Ebi40UnitType;
import com.helger.ebinterface.v40.Ebi40VATType;
import com.helger.ebinterface.v40.ObjectFactory;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.CreditNoteLineType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.DeliveryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.OrderLineReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyTaxSchemeType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PeriodType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.SupplierPartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.TaxCategoryType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.DescriptionType;
import oasis.names.specification.ubl.schema.xsd.creditnote_21.CreditNoteType;

@Immutable
public final class CreditNoteToEbInterface40Converter
extends AbstractToEbInterface40Converter {
    private ICustomCreditNoteToEbInterface40Converter m_aCustomizer;

    public CreditNoteToEbInterface40Converter(@Nonnull Locale locale, @Nonnull Locale locale2, @Nonnull IToEbinterfaceSettings iToEbinterfaceSettings) {
        super(locale, locale2, iToEbinterfaceSettings);
    }

    @Nonnull
    public CreditNoteToEbInterface40Converter setCustomizer(@Nullable ICustomCreditNoteToEbInterface40Converter iCustomCreditNoteToEbInterface40Converter) {
        this.m_aCustomizer = iCustomCreditNoteToEbInterface40Converter;
        return this;
    }

    @Nullable
    public Ebi40InvoiceType convertToEbInterface(@Nonnull CreditNoteType creditNoteType, @Nonnull ErrorList errorList) {
        Object object17;
        Object object2;
        Ebi40OtherTaxType ebi40OtherTaxType;
        Object object3;
        Object object42;
        Ebi40UnitType ebi40UnitType;
        Object object5;
        Object object62;
        Iterator iterator;
        Object object7;
        TaxCategoryType taxCategoryType2;
        Object object82;
        int n;
        Object object92;
        CommonsHashMap commonsHashMap;
        Object object10;
        PartyTaxSchemeType partyTaxSchemeType2;
        ValueEnforcer.notNull((Object)creditNoteType, (String)"UBLCreditNote");
        ValueEnforcer.notNull((Object)errorList, (String)"TransformationErrorList");
        ValueEnforcer.isTrue((boolean)errorList.isEmpty(), (String)"TransformationErrorList must be empty!");
        this.checkCreditNoteConsistency(creditNoteType, errorList);
        if (errorList.containsAtLeastOneError()) {
            return null;
        }
        Ebi40InvoiceType ebi40InvoiceType = new Ebi40InvoiceType();
        ebi40InvoiceType.setGeneratingSystem("UBL 2.1 to ebInterface 4.0 converter");
        ebi40InvoiceType.setDocumentType(CreditNoteToEbInterface40Converter.getAsDocumentTypeType(creditNoteType.getCreditNoteTypeCode() == null ? null : creditNoteType.getCreditNoteTypeCode().getName(), creditNoteType.getCreditNoteTypeCodeValue(), Ebi40DocumentTypeType.CREDIT_MEMO.value()));
        String string = StringHelper.trim((String)creditNoteType.getDocumentCurrencyCodeValue());
        ebi40InvoiceType.setInvoiceCurrency(CreditNoteToEbInterface40Converter.getCurrencyCode(string));
        String string2 = StringHelper.trim((String)creditNoteType.getIDValue());
        if (StringHelper.hasNoText((String)string2)) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("ID")).errorText(AbstractToEbInterfaceConverter.EText.MISSING_INVOICE_NUMBER.getDisplayText(this.m_aDisplayLocale))).build());
        }
        ebi40InvoiceType.setInvoiceNumber(string2);
        ebi40InvoiceType.setInvoiceDate(creditNoteType.getIssueDateValue());
        if (ebi40InvoiceType.getInvoiceDate() == null) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("IssueDate")).errorText(AbstractToEbInterfaceConverter.EText.MISSING_INVOICE_DATE.getDisplayText(this.m_aDisplayLocale))).build());
        }
        SupplierPartyType supplierPartyType = creditNoteType.getAccountingSupplierParty();
        Object object11 = new Ebi40BillerType();
        if (supplierPartyType.getParty() != null) {
            for (PartyTaxSchemeType partyTaxSchemeType2 : supplierPartyType.getParty().getPartyTaxScheme()) {
                if (!CreditNoteToEbInterface40Converter.isVATSchemeID(partyTaxSchemeType2.getTaxScheme().getIDValue())) continue;
                object11.setVATIdentificationNumber(StringHelper.trim((String)partyTaxSchemeType2.getCompanyIDValue()));
                break;
            }
        }
        if (StringHelper.hasNoText((String)object11.getVATIdentificationNumber())) {
            object11.setVATIdentificationNumber("ATU00000000");
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("AccountingSupplierParty/Party/PartyTaxScheme")).errorText(AbstractToEbInterfaceConverter.EText.BILLER_VAT_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
        }
        if (supplierPartyType.getCustomerAssignedAccountID() != null) {
            object11.setInvoiceRecipientsBillerID(StringHelper.trim((String)supplierPartyType.getCustomerAssignedAccountIDValue()));
        }
        if (StringHelper.hasNoText((String)object11.getInvoiceRecipientsBillerID()) && supplierPartyType.getParty() != null && supplierPartyType.getParty().hasPartyIdentificationEntries()) {
            object11.setInvoiceRecipientsBillerID(StringHelper.trim((String)supplierPartyType.getParty().getPartyIdentificationAtIndex(0).getIDValue()));
        }
        for (PartyTaxSchemeType partyTaxSchemeType2 : supplierPartyType.getAdditionalAccountID()) {
            object10 = new Ebi40FurtherIdentificationType();
            object10.setIdentificationType("Consolidator");
            object10.setValue(StringHelper.trim((String)partyTaxSchemeType2.getValue()));
            object11.addFurtherIdentification(object10);
        }
        if (supplierPartyType.getParty() != null) {
            object11.setAddress(CreditNoteToEbInterface40Converter.convertParty(supplierPartyType.getParty(), "AccountingSupplierParty", errorList, this.m_aContentLocale, this.m_aDisplayLocale, true));
            if (StringHelper.hasNoText((String)object11.getAddress().getEmail()) && this.m_aSettings.isEnforceSupplierEmailAddress()) {
                object11.getAddress().setEmail(this.m_aSettings.getEnforcedSupplierEmailAddress());
            }
        }
        for (PartyTaxSchemeType partyTaxSchemeType2 : creditNoteType.getContractDocumentReference()) {
            if (!StringHelper.hasTextAfterTrim((String)partyTaxSchemeType2.getIDValue())) continue;
            object10 = StringHelper.hasText((String)partyTaxSchemeType2.getID().getSchemeID()) ? partyTaxSchemeType2.getID().getSchemeID() : "Contract";
            Ebi40FurtherIdentificationType ebi40FurtherIdentificationType = new Ebi40FurtherIdentificationType();
            ebi40FurtherIdentificationType.setIdentificationType((String)object10);
            ebi40FurtherIdentificationType.setValue(StringHelper.trim((String)partyTaxSchemeType2.getIDValue()));
            object11.addFurtherIdentification(ebi40FurtherIdentificationType);
        }
        ebi40InvoiceType.setBiller((Ebi40BillerType)object11);
        supplierPartyType = creditNoteType.getAccountingCustomerParty();
        object11 = new Ebi40InvoiceRecipientType();
        if (supplierPartyType.getParty() != null) {
            for (PartyTaxSchemeType partyTaxSchemeType2 : supplierPartyType.getParty().getPartyTaxScheme()) {
                if (!CreditNoteToEbInterface40Converter.isVATSchemeID(partyTaxSchemeType2.getTaxScheme().getIDValue())) continue;
                object11.setVATIdentificationNumber(StringHelper.trim((String)partyTaxSchemeType2.getCompanyIDValue()));
                break;
            }
        }
        if (StringHelper.hasNoText((String)object11.getVATIdentificationNumber())) {
            object11.setVATIdentificationNumber("ATU00000000");
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("AccountingCustomerParty/PartyTaxScheme")).errorText(AbstractToEbInterfaceConverter.EText.INVOICE_RECIPIENT_VAT_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
        }
        if (supplierPartyType.getSupplierAssignedAccountID() != null) {
            commonsHashMap = StringHelper.trim((String)supplierPartyType.getSupplierAssignedAccountIDValue());
            object11.setBillersInvoiceRecipientID((String)commonsHashMap);
        }
        if (StringHelper.hasNoText((String)object11.getBillersInvoiceRecipientID())) {
            object11.setBillersInvoiceRecipientID(this.m_aSettings.getFallbackBillersInvoiceRecipientID());
        }
        if (StringHelper.hasNoText((String)object11.getBillersInvoiceRecipientID())) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("AccountingCustomerParty/SupplierAssignedAccountID")).errorText(AbstractToEbInterfaceConverter.EText.INVOICE_RECIPIENT_PARTY_SUPPLIER_ASSIGNED_ACCOUNT_ID_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
        }
        if (supplierPartyType.getParty() != null) {
            object11.setAddress(CreditNoteToEbInterface40Converter.convertParty(supplierPartyType.getParty(), "AccountingCustomerParty", errorList, this.m_aContentLocale, this.m_aDisplayLocale, true));
        }
        if (object11.getAddress() == null) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("AccountingCustomerParty/Party")).errorText(AbstractToEbInterfaceConverter.EText.INVOICE_RECIPIENT_PARTY_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
        }
        ebi40InvoiceType.setInvoiceRecipient((Ebi40InvoiceRecipientType)object11);
        supplierPartyType = creditNoteType.getBuyerCustomerParty();
        if (supplierPartyType != null) {
            object11 = new Ebi40OrderingPartyType();
            if (supplierPartyType.getParty() != null) {
                for (PartyTaxSchemeType partyTaxSchemeType2 : supplierPartyType.getParty().getPartyTaxScheme()) {
                    if (!CreditNoteToEbInterface40Converter.isVATSchemeID(partyTaxSchemeType2.getTaxScheme().getIDValue())) continue;
                    object11.setVATIdentificationNumber(StringHelper.trim((String)partyTaxSchemeType2.getCompanyIDValue()));
                    break;
                }
            }
            if (StringHelper.hasNoText((String)object11.getVATIdentificationNumber())) {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("BuyerCustomerParty/PartyTaxScheme")).errorText(AbstractToEbInterfaceConverter.EText.ORDERING_PARTY_VAT_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
            }
            if (supplierPartyType.getParty() != null) {
                object11.setAddress(CreditNoteToEbInterface40Converter.convertParty(supplierPartyType.getParty(), "BuyerCustomerParty", errorList, this.m_aContentLocale, this.m_aDisplayLocale, true));
            }
            if (object11.getAddress() == null) {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("BuyerCustomerParty/Party")).errorText(AbstractToEbInterfaceConverter.EText.ORDERING_PARTY_PARTY_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
            }
            if (supplierPartyType.getSupplierAssignedAccountID() != null) {
                object11.setBillersOrderingPartyID(StringHelper.trim((String)supplierPartyType.getSupplierAssignedAccountIDValue()));
            }
            if (StringHelper.hasNoText((String)object11.getBillersOrderingPartyID()) && supplierPartyType.getParty() != null && supplierPartyType.getParty().hasPartyIdentificationEntries()) {
                object11.setBillersOrderingPartyID(StringHelper.trim((String)supplierPartyType.getParty().getPartyIdentificationAtIndex(0).getIDValue()));
            }
            if (StringHelper.hasNoText((String)object11.getBillersOrderingPartyID()) && ebi40InvoiceType.getInvoiceRecipient() != null) {
                object11.setBillersOrderingPartyID(ebi40InvoiceType.getInvoiceRecipient().getBillersInvoiceRecipientID());
            }
            if (StringHelper.hasNoText((String)object11.getBillersOrderingPartyID())) {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("BuyerCustomerParty/SupplierAssignedAccountID")).errorText(AbstractToEbInterfaceConverter.EText.ORDERING_PARTY_SUPPLIER_ASSIGNED_ACCOUNT_ID_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
            }
            ebi40InvoiceType.setOrderingParty((Ebi40OrderingPartyType)object11);
        }
        object11 = null;
        commonsHashMap = creditNoteType.getOrderReference();
        if (commonsHashMap != null) {
            object11 = StringHelper.trim((String)commonsHashMap.getIDValue());
        }
        if (StringHelper.hasNoText((String)object11)) {
            if (this.m_aSettings.isOrderReferenceIDMandatory()) {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("OrderReference/ID")).errorText(AbstractToEbInterfaceConverter.EText.ORDER_REFERENCE_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
            }
        } else {
            if (this.m_aSettings.hasOrderReferenceMaxLength()) {
                int n2 = this.m_aSettings.getOrderReferenceMaxLength();
                if (((String)object11).length() > n2) {
                    errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("OrderReference/ID")).errorText(AbstractToEbInterfaceConverter.EText.ORDER_REFERENCE_TOO_LONG.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{object11, n2}))).build());
                    object11 = ((String)object11).substring(0, n2);
                }
            }
            partyTaxSchemeType2 = new Ebi40OrderReferenceType();
            partyTaxSchemeType2.setOrderID((String)object11);
            ebi40InvoiceType.getInvoiceRecipient().setOrderReference((Ebi40OrderReferenceType)partyTaxSchemeType2);
        }
        commonsHashMap = new CommonsHashMap();
        partyTaxSchemeType2 = new Ebi40TaxType();
        object10 = new Ebi40VATType();
        int n3 = 0;
        for (Object object92 : creditNoteType.getTaxTotal()) {
            n = 0;
            for (Object object82 : object92.getTaxSubtotal()) {
                taxCategoryType2 = object82.getTaxCategory();
                object7 = StringHelper.trim((String)taxCategoryType2.getID().getValue());
                boolean bl = CreditNoteToEbInterface40Converter.isTaxExemptionCategoryID((String)object7);
                BigDecimal bigDecimal = object82.getTaxAmountValue();
                iterator = object82.getTaxableAmountValue();
                Object object12 = object62 = bl ? BigDecimal.ZERO : taxCategoryType2.getPercentValue();
                if (object62 == null && bigDecimal != null && iterator != null) {
                    Object object13 = object62 = MathHelper.isEQ0((BigDecimal)((Object)iterator)) ? BigDecimal.ZERO : bigDecimal.multiply(CGlobal.BIGDEC_100).divide((BigDecimal)((Object)iterator), 2, ROUNDING_MODE);
                }
                if (object62 != null) {
                    if (iterator == null && bigDecimal != null) {
                        if (MathHelper.isNE0((BigDecimal)object62)) {
                            iterator = bigDecimal.multiply(CGlobal.BIGDEC_100).divide((BigDecimal)object62, 4, ROUNDING_MODE);
                        }
                    } else if (iterator != null && bigDecimal == null) {
                        BigDecimal bigDecimal2 = bigDecimal = MathHelper.isEQ0((BigDecimal)object62) ? BigDecimal.ZERO : ((BigDecimal)((Object)iterator)).multiply((BigDecimal)object62).divide(CGlobal.BIGDEC_100, 4, ROUNDING_MODE);
                    }
                }
                if ((object5 = taxCategoryType2.getTaxScheme().getID()) == null) {
                    errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("TaxTotal[" + n3 + "]/TaxSubtotal[" + n + "]/TaxCategory/TaxScheme/ID")).errorText(AbstractToEbInterfaceConverter.EText.MISSING_TAXCATEGORY_TAXSCHEME_ID.getDisplayText(this.m_aDisplayLocale))).build());
                    break;
                }
                ebi40UnitType = StringHelper.trim((String)object5.getSchemeID());
                object42 = StringHelper.trim((String)object5.getValue());
                if (StringHelper.hasNoText((String)object42)) {
                    errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("TaxTotal[" + n3 + "]/TaxSubtotal[" + n + "]/TaxCategory/TaxScheme/ID")).errorText(AbstractToEbInterfaceConverter.EText.MISSING_TAXCATEGORY_TAXSCHEME_ID_VALUE.getDisplayText(this.m_aDisplayLocale))).build());
                    break;
                }
                if (taxCategoryType2.getID() == null) {
                    errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("TaxTotal[" + n3 + "]/TaxSubtotal[" + n + "]/TaxCategory")).errorText(AbstractToEbInterfaceConverter.EText.MISSING_TAXCATEGORY_ID.getDisplayText(this.m_aDisplayLocale))).build());
                    break;
                }
                if (StringHelper.hasNoText((String)object7)) {
                    errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("TaxTotal[" + n3 + "]/TaxSubtotal[" + n + "]/TaxCategory")).errorText(AbstractToEbInterfaceConverter.EText.MISSING_TAXCATEGORY_ID_VALUE.getDisplayText(this.m_aDisplayLocale))).build());
                    break;
                }
                object3 = StringHelper.trim((String)taxCategoryType2.getID().getSchemeID());
                commonsHashMap.put((Object)new TaxCategoryKey(new SchemedID((String)ebi40UnitType, (String)object42), new SchemedID((String)object3, (String)object7)), object62);
                if (CreditNoteToEbInterface40Converter.isVATSchemeID((String)object42)) {
                    if (object62 == null) {
                        errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("TaxTotal[" + n3 + "]/TaxSubtotal[" + n + "]/TaxCategory/Percent")).errorText(AbstractToEbInterfaceConverter.EText.TAX_PERCENT_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
                    } else if (iterator == null) {
                        errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("TaxTotal[" + n3 + "]/TaxSubtotal[" + n + "]/TaxableAmount")).errorText(AbstractToEbInterfaceConverter.EText.TAXABLE_AMOUNT_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
                    } else {
                        ebi40OtherTaxType = new Ebi40ItemType();
                        ebi40OtherTaxType.setTaxedAmount(((BigDecimal)((Object)iterator)).setScale(2, ROUNDING_MODE));
                        if (bl) {
                            object2 = null;
                            if (taxCategoryType2.hasTaxExemptionReasonEntries()) {
                                object2 = taxCategoryType2.getTaxExemptionReasonAtIndex(0).getValue();
                            }
                            if (object2 == null && taxCategoryType2.getTaxExemptionReasonCode() != null) {
                                object2 = taxCategoryType2.getTaxExemptionReasonCode().getValue();
                            }
                            if (StringHelper.hasNoText((String)object2)) {
                                object2 = "Tax Exemption";
                            }
                            object10.setTaxExemption(StringHelper.getConcatenatedOnDemand((String)object10.getTaxExemption(), (char)'\n', (String)object2));
                        } else {
                            object2 = new Ebi40TaxRateType();
                            object2.setValue((BigDecimal)object62);
                            ebi40OtherTaxType.setTaxRate(object2);
                        }
                        ebi40OtherTaxType.setAmount(bigDecimal.setScale(2, ROUNDING_MODE));
                        object10.addItem((Ebi40ItemType)ebi40OtherTaxType);
                    }
                } else {
                    ebi40OtherTaxType = new Ebi40OtherTaxType();
                    ebi40OtherTaxType.setComment((String)object42);
                    ebi40OtherTaxType.setAmount(bigDecimal.setScale(2, ROUNDING_MODE));
                    partyTaxSchemeType2.addOtherTax(ebi40OtherTaxType);
                }
                ++n;
            }
            ++n3;
        }
        if (object10.hasItemEntries() && StringHelper.hasText((String)object10.getTaxExemption())) {
            errorList.add((Object)((SingleError.Builder)SingleError.builderError().errorText(AbstractToEbInterfaceConverter.EText.EBI40_CANNOT_MIX_VAT_EXEMPTION.getDisplayText(this.m_aDisplayLocale))).build());
        }
        partyTaxSchemeType2.setVAT((Ebi40VATType)object10);
        ebi40InvoiceType.setTax((Ebi40TaxType)partyTaxSchemeType2);
        BigDecimal bigDecimal = BigDecimal.ZERO;
        Object object14 = new Ebi40DetailsType();
        object92 = new Ebi40ItemListType();
        n = 0;
        for (Object object82 : creditNoteType.getCreditNoteLine()) {
            boolean bl;
            taxCategoryType2 = (TaxCategoryType)CollectionHelper.getAtIndex((List)object82.getItem().getClassifiedTaxCategory(), (int)0);
            if (taxCategoryType2 == null) {
                taxCategoryType2 = CreditNoteToEbInterface40Converter.findTaxCategory(object82.getTaxTotal());
            }
            object7 = null;
            String string3 = null;
            if (taxCategoryType2 != null) {
                string3 = StringHelper.trim((String)taxCategoryType2.getIDValue());
                if (taxCategoryType2.getPercent() != null) {
                    object7 = taxCategoryType2.getPercentValue();
                }
                if (object7 == null && taxCategoryType2.getID() != null && taxCategoryType2.getTaxScheme() != null && taxCategoryType2.getTaxScheme().getID() != null) {
                    String string4 = StringHelper.trim((String)taxCategoryType2.getTaxScheme().getID().getSchemeID());
                    iterator = StringHelper.trim((String)taxCategoryType2.getTaxScheme().getIDValue());
                    object62 = StringHelper.trim((String)taxCategoryType2.getID().getSchemeID());
                    if (StringHelper.hasText((String)((Object)iterator)) && StringHelper.hasText((String)string3)) {
                        object5 = new TaxCategoryKey(new SchemedID(string4, (String)((Object)iterator)), new SchemedID((String)object62, string3));
                        object7 = (BigDecimal)commonsHashMap.get(object5);
                    }
                }
            }
            if ((bl = CreditNoteToEbInterface40Converter.isTaxExemptionCategoryID(string3)) && object7 == null) {
                object7 = BigDecimal.ZERO;
            }
            if (object7 == null) {
                object7 = BigDecimal.ZERO;
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("CreditNoteLine[" + n + "]/Item/ClassifiedTaxCategory")).errorText(AbstractToEbInterfaceConverter.EText.DETAILS_TAX_PERCENTAGE_NOT_FOUND.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{object7}))).build());
            }
            iterator = new Ebi40ListLineItemType();
            object62 = StringHelper.trim((String)object82.getIDValue());
            object5 = StringParser.parseBigInteger((String)object62);
            if (object5 != null && MathHelper.isLT1((BigInteger)object5)) {
                if (this.m_aSettings.isErrorOnPositionNumber()) {
                    errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("CreditNoteLine[" + n + "]/ID")).errorText(AbstractToEbInterfaceConverter.EText.DETAILS_INVALID_POSITION.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{object62}))).build());
                } else {
                    object5 = null;
                }
            }
            if (object5 == null) {
                object5 = BigInteger.valueOf((long)n + 1L);
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("CreditNoteLine[" + n + "]/ID")).errorText(AbstractToEbInterfaceConverter.EText.DETAILS_INVALID_POSITION_SET_TO_INDEX.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{object62, object5}))).build());
            }
            iterator.setPositionNumber((BigInteger)object5);
            ebi40UnitType = object82.getItem().getDescription().iterator();
            while (ebi40UnitType.hasNext()) {
                object42 = (DescriptionType)ebi40UnitType.next();
                object3 = StringHelper.trim((String)object42.getValue());
                if (!StringHelper.hasText((String)object3)) continue;
                iterator.addDescription((String)object3);
            }
            if (iterator.hasNoDescriptionEntries() && (ebi40UnitType = object82.getItem().getName()) != null && StringHelper.hasText((String)(object42 = StringHelper.trim((String)ebi40UnitType.getValue())))) {
                iterator.addDescription((String)object42);
            }
            for (Object object42 : object82.getNote()) {
                object3 = StringHelper.trim((String)object42.getValue());
                if (!StringHelper.hasText((String)object3)) continue;
                iterator.addDescription((String)object3);
            }
            ebi40UnitType = new Ebi40UnitType();
            if (object82.getCreditedQuantity() != null) {
                if (object82.getCreditedQuantity().getUnitCode() != null) {
                    ebi40UnitType.setUnit(StringHelper.trim((String)object82.getCreditedQuantity().getUnitCode()));
                }
                ebi40UnitType.setValue(object82.getCreditedQuantityValue());
            }
            if (ebi40UnitType.getUnit() == null) {
                ebi40UnitType.setUnit("C62");
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("CreditNoteLine[" + n + "]/CreditNotedQuantity/UnitCode")).errorText(AbstractToEbInterfaceConverter.EText.DETAILS_INVALID_UNIT.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{ebi40UnitType.getUnit()}))).build());
            }
            if (ebi40UnitType.getValue() == null) {
                ebi40UnitType.setValue(BigDecimal.ONE);
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("CreditNoteLine[" + n + "]/CreditNotedQuantity")).errorText(AbstractToEbInterfaceConverter.EText.DETAILS_INVALID_QUANTITY.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{ebi40UnitType.getValue()}))).build());
            }
            iterator.setQuantity(ebi40UnitType);
            if (object82.getPrice() != null) {
                object42 = object82.getPrice().getPriceAmountValue();
                object3 = object82.getPrice().getBaseQuantityValue();
                if (object3 != null) {
                    if (MathHelper.isEQ0((BigDecimal)object3)) {
                        iterator.setUnitPrice(BigDecimal.ZERO);
                    } else {
                        iterator.setUnitPrice(((BigDecimal)object42).divide((BigDecimal)object3, 4, ROUNDING_MODE));
                    }
                } else {
                    iterator.setUnitPrice((BigDecimal)object42);
                }
            } else {
                object42 = object82.getLineExtensionAmountValue();
                object3 = MathHelper.isEQ0((BigDecimal)ebi40UnitType.getValue()) ? BigDecimal.ZERO : ((BigDecimal)object42).divide(ebi40UnitType.getValue(), 4, ROUNDING_MODE);
                iterator.setUnitPrice((BigDecimal)object3);
            }
            object42 = iterator.getUnitPrice();
            if (bl) {
                object3 = new Ebi40TaxRateType();
                object3.setValue(BigDecimal.ZERO);
                iterator.setTaxRate((Ebi40TaxRateType)object3);
            } else {
                object3 = new Ebi40TaxRateType();
                object3.setValue((BigDecimal)object7);
                if (taxCategoryType2 != null) {
                    // empty if block
                }
                iterator.setTaxRate((Ebi40TaxRateType)object3);
            }
            iterator.setLineItemAmount(object82.getLineExtensionAmountValue().setScale(2, ROUNDING_MODE));
            if (MathHelper.isEQ0((BigDecimal)object7)) {
                bigDecimal = bigDecimal.add(iterator.getLineItemAmount());
            }
            object3 = object82.getOrderLineReference().iterator();
            while (object3.hasNext()) {
                ebi40OtherTaxType = (OrderLineReferenceType)object3.next();
                if (!StringHelper.hasText((String)ebi40OtherTaxType.getLineIDValue())) continue;
                object2 = new Ebi40OrderReferenceDetailType();
                Object object15 = null;
                if (ebi40OtherTaxType.getOrderReference() != null) {
                    object15 = StringHelper.trim((String)ebi40OtherTaxType.getOrderReference().getIDValue());
                }
                if (StringHelper.hasNoText(object15)) {
                    object15 = object11;
                }
                object2.setOrderID((String)object15);
                Object object16 = StringHelper.trim((String)ebi40OtherTaxType.getLineIDValue());
                if (object16 != null) {
                    if (((String)object16).length() == 0) {
                        errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("CreditNoteLine[" + n + "]/OrderLineReference/LineID")).errorText(AbstractToEbInterfaceConverter.EText.ORDERLINE_REF_ID_EMPTY.getDisplayText(this.m_aDisplayLocale))).build());
                    } else {
                        object2.setOrderPositionNumber((String)object16);
                    }
                }
                if (StringHelper.hasText((String)object2.getOrderPositionNumber()) && StringHelper.hasNoText((String)object15)) {
                    if (this.m_aSettings.isOrderReferenceIDMandatory()) {
                        errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("CreditNoteLine[" + n + "]/OrderLineReference/OrderReference/ID")).errorText(AbstractToEbInterfaceConverter.EText.ORDER_REFERENCE_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
                    } else {
                        object2.setOrderPositionNumber(null);
                        errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("CreditNoteLine[" + n + "]/OrderLineReference/OrderReference/ID")).errorText(AbstractToEbInterfaceConverter.EText.ORDER_REFERENCE_MISSING_IGNORE_ORDER_POS.getDisplayText(this.m_aDisplayLocale))).build());
                    }
                }
                if (!StringHelper.hasText((String)object15)) break;
                iterator.setInvoiceRecipientsOrderReference((Ebi40OrderReferenceDetailType)object2);
                break;
            }
            if (object82.hasAllowanceChargeEntries()) {
                object3 = iterator.getQuantity().getValue().multiply((BigDecimal)object42);
                ebi40OtherTaxType = new Ebi40ReductionAndSurchargeListLineItemDetailsType();
                object2 = ETriState.UNDEFINED;
                for (Object object16 : object82.getAllowanceCharge()) {
                    boolean bl2 = object16.getChargeIndicator().isValue();
                    if (object2.isUndefined()) {
                        object2 = ETriState.valueOf((boolean)bl2);
                    }
                    boolean bl3 = bl2 != object2.isTrue();
                    Ebi40ReductionAndSurchargeBaseType ebi40ReductionAndSurchargeBaseType = new Ebi40ReductionAndSurchargeBaseType();
                    BigDecimal bigDecimal3 = object16.getAmountValue();
                    ebi40ReductionAndSurchargeBaseType.setAmount(bl3 ? bigDecimal3.negate() : bigDecimal3);
                    if (object16.getBaseAmount() != null) {
                        ebi40ReductionAndSurchargeBaseType.setBaseAmount(object16.getBaseAmountValue());
                    }
                    if (ebi40ReductionAndSurchargeBaseType.getBaseAmount() == null) {
                        ebi40ReductionAndSurchargeBaseType.setBaseAmount((BigDecimal)object3);
                    }
                    if (object16.getMultiplierFactorNumeric() != null) {
                        BigDecimal bigDecimal4 = object16.getMultiplierFactorNumericValue().multiply(CGlobal.BIGDEC_100);
                        ebi40ReductionAndSurchargeBaseType.setPercentage(bigDecimal4);
                    }
                    if (object2.isTrue()) {
                        ebi40OtherTaxType.addSurchargeListLineItem(ebi40ReductionAndSurchargeBaseType);
                        object3 = ((BigDecimal)object3).add(ebi40ReductionAndSurchargeBaseType.getAmount());
                        continue;
                    }
                    ebi40OtherTaxType.addReductionListLineItem(ebi40ReductionAndSurchargeBaseType);
                    object3 = ((BigDecimal)object3).subtract(ebi40ReductionAndSurchargeBaseType.getAmount());
                }
                iterator.setReductionAndSurchargeListLineItemDetails((Ebi40ReductionAndSurchargeListLineItemDetailsType)ebi40OtherTaxType);
            }
            if (object82.hasDeliveryEntries() && (object3 = object82.getDeliveryAtIndex(0)).getActualDeliveryDate() != null) {
                ebi40OtherTaxType = CreditNoteToEbInterface40Converter.convertDelivery((DeliveryType)object3, "CreditNoteLine[" + n + "]/Delivery[0]", creditNoteType.getAccountingCustomerParty(), errorList, this.m_aContentLocale, this.m_aDisplayLocale);
                iterator.setDelivery((Ebi40DeliveryType)ebi40OtherTaxType);
            }
            if (this.m_aCustomizer != null) {
                this.m_aCustomizer.additionalItemMapping((CreditNoteLineType)object82, iterator);
            }
            object92.addListLineItem(iterator);
            ++n;
        }
        object14.addItemList((Ebi40ItemListType)object92);
        ebi40InvoiceType.setDetails((Ebi40DetailsType)object14);
        if (object10.hasNoItemEntries()) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("CreditNote")).errorText(AbstractToEbInterfaceConverter.EText.VAT_ITEM_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
        }
        if (creditNoteType.hasAllowanceChargeEntries()) {
            object14 = creditNoteType.getLegalMonetaryTotal().getLineExtensionAmountValue();
            if (object14 == null) {
                object92 = BigDecimal.ZERO;
                for (Object object17 : ebi40InvoiceType.getDetails().getItemList()) {
                    for (TaxCategoryType taxCategoryType2 : object17.getListLineItem()) {
                        object92 = ((BigDecimal)object92).add(taxCategoryType2.getLineItemAmount());
                    }
                }
                object14 = object92;
            }
            object92 = new Ebi40ReductionAndSurchargeDetailsType();
            n = 0;
            for (Object object82 : creditNoteType.getAllowanceCharge()) {
                BigDecimal bigDecimal5;
                boolean bl = object82.getChargeIndicator().isValue();
                object7 = new Ebi40ReductionAndSurchargeType();
                BigDecimal bigDecimal6 = object82.getAmountValue();
                object7.setAmount(bigDecimal6);
                if (object82.getBaseAmount() != null) {
                    object7.setBaseAmount(object82.getBaseAmountValue());
                }
                if (object7.getBaseAmount() == null) {
                    object7.setBaseAmount((BigDecimal)object14);
                }
                if (object82.getMultiplierFactorNumeric() != null) {
                    bigDecimal5 = object82.getMultiplierFactorNumericValue().multiply(CGlobal.BIGDEC_100);
                    object7.setPercentage(bigDecimal5);
                }
                bigDecimal5 = null;
                for (Object object62 : object82.getTaxCategory()) {
                    if (object62.getPercent() == null) continue;
                    bigDecimal5 = new Ebi40TaxRateType();
                    bigDecimal5.setValue(object62.getPercentValue());
                    break;
                }
                if (bigDecimal5 == null) {
                    errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("CreditNote/AllowanceCharge[" + n + "]")).errorText(AbstractToEbInterfaceConverter.EText.ALLOWANCE_CHARGE_NO_TAXRATE.getDisplayText(this.m_aDisplayLocale))).build());
                }
                object7.setTaxRate((Ebi40TaxRateType)bigDecimal5);
                if (bl) {
                    object92.addReductionOrSurcharge(new ObjectFactory().createSurcharge((Ebi40ReductionAndSurchargeType)object7));
                    object14 = ((BigDecimal)object14).add(object7.getAmount());
                } else {
                    object92.addReductionOrSurcharge(new ObjectFactory().createReduction((Ebi40ReductionAndSurchargeType)object7));
                    object14 = ((BigDecimal)object14).subtract(object7.getAmount());
                }
                ebi40InvoiceType.setReductionAndSurchargeDetails((Ebi40ReductionAndSurchargeDetailsType)object92);
                ++n;
            }
        }
        if ((object14 = creditNoteType.getLegalMonetaryTotal()).getPrepaidAmount() != null && !MathHelper.isEQ0((BigDecimal)object14.getPrepaidAmountValue())) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("CreditNote/LegalMonetaryTotal/PrepaidAmount")).errorText(AbstractToEbInterfaceConverter.EText.PREPAID_NOT_SUPPORTED.getDisplayText(this.m_aDisplayLocale))).build());
        }
        if (object14.getTaxInclusiveAmountValue() != null) {
            ebi40InvoiceType.setTotalGrossAmount(object14.getTaxInclusiveAmountValue().setScale(2, ROUNDING_MODE));
        } else {
            ebi40InvoiceType.setTotalGrossAmount(object14.getPayableAmountValue().setScale(2, ROUNDING_MODE));
        }
        this.convertPayment(() -> null, () -> ((CreditNoteType)creditNoteType).getPaymentMeans(), () -> ((CreditNoteType)creditNoteType).getPayeeParty(), () -> ((CreditNoteType)creditNoteType).getAccountingSupplierParty(), () -> ((CreditNoteType)creditNoteType).getPaymentTerms(), () -> ((CreditNoteType)creditNoteType).getLegalMonetaryTotal(), errorList, ebi40InvoiceType, true);
        object92 = null;
        n = 0;
        object17 = creditNoteType.getDelivery().iterator();
        while (object17.hasNext()) {
            object82 = (DeliveryType)object17.next();
            if (object82.getActualDeliveryDate() != null) {
                object92 = CreditNoteToEbInterface40Converter.convertDelivery((DeliveryType)object82, "/Delivery[" + n + "]", creditNoteType.getAccountingCustomerParty(), errorList, this.m_aContentLocale, this.m_aDisplayLocale);
                break;
            }
            ++n;
        }
        if (object92 == null) {
            object92 = new Ebi40DeliveryType();
        }
        if ((object17 = (PeriodType)CollectionHelper.getAtIndex((List)creditNoteType.getInvoicePeriod(), (int)0)) != null) {
            object82 = object17.getStartDateValue();
            XMLOffsetDate xMLOffsetDate = object17.getEndDateValue();
            if (object82 != null) {
                if (xMLOffsetDate == null) {
                    if (object92.getDate() == null) {
                        object92.setDate((XMLOffsetDate)object82);
                    }
                } else {
                    object7 = new Ebi40PeriodType();
                    object7.setFromDate((XMLOffsetDate)object82);
                    object7.setToDate(xMLOffsetDate);
                    object92.setPeriod((Ebi40PeriodType)object7);
                    object92.setDate((XMLOffsetDate)null);
                }
            }
        }
        if (this.m_aSettings.isDeliveryDateMandatory() && object92.getDate() == null && object92.getPeriod() == null) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("CreditNote")).errorText(AbstractToEbInterfaceConverter.EText.ERB_NO_DELIVERY_DATE.getDisplayText(this.m_aDisplayLocale))).build());
        }
        if (object92.getDate() != null || object92.getPeriod() != null) {
            ebi40InvoiceType.setDelivery((Ebi40DeliveryType)object92);
        }
        if (this.m_aCustomizer != null) {
            this.m_aCustomizer.additionalGlobalMapping(creditNoteType, ebi40InvoiceType);
        }
        return ebi40InvoiceType;
    }
}

