/*
 * Decompiled with CFR 0.152.
 */
package at.austriapro.ebinterface.ubl.from.creditnote;

import at.austriapro.ebinterface.ubl.from.AbstractToEbInterface50Converter;
import at.austriapro.ebinterface.ubl.from.AbstractToEbInterfaceConverter;
import at.austriapro.ebinterface.ubl.from.IToEbinterfaceSettings;
import at.austriapro.ebinterface.ubl.from.creditnote.ICustomCreditNoteToEbInterface50Converter;
import at.austriapro.ebinterface.ubl.from.helper.SchemedID;
import at.austriapro.ebinterface.ubl.from.helper.TaxCategoryKey;
import com.helger.commons.CGlobal;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.datetime.XMLOffsetDate;
import com.helger.commons.error.SingleError;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.math.MathHelper;
import com.helger.commons.state.ETriState;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.StringParser;
import com.helger.ebinterface.v50.Ebi50AdditionalInformationType;
import com.helger.ebinterface.v50.Ebi50AddressType;
import com.helger.ebinterface.v50.Ebi50BillerType;
import com.helger.ebinterface.v50.Ebi50ContactType;
import com.helger.ebinterface.v50.Ebi50DeliveryType;
import com.helger.ebinterface.v50.Ebi50DetailsType;
import com.helger.ebinterface.v50.Ebi50DocumentTypeType;
import com.helger.ebinterface.v50.Ebi50FurtherIdentificationType;
import com.helger.ebinterface.v50.Ebi50InvoiceRecipientType;
import com.helger.ebinterface.v50.Ebi50InvoiceType;
import com.helger.ebinterface.v50.Ebi50ItemListType;
import com.helger.ebinterface.v50.Ebi50ListLineItemType;
import com.helger.ebinterface.v50.Ebi50OrderReferenceDetailType;
import com.helger.ebinterface.v50.Ebi50OrderReferenceType;
import com.helger.ebinterface.v50.Ebi50OrderingPartyType;
import com.helger.ebinterface.v50.Ebi50OtherTaxType;
import com.helger.ebinterface.v50.Ebi50PeriodType;
import com.helger.ebinterface.v50.Ebi50ReductionAndSurchargeBaseType;
import com.helger.ebinterface.v50.Ebi50ReductionAndSurchargeDetailsType;
import com.helger.ebinterface.v50.Ebi50ReductionAndSurchargeListLineItemDetailsType;
import com.helger.ebinterface.v50.Ebi50ReductionAndSurchargeType;
import com.helger.ebinterface.v50.Ebi50TaxItemType;
import com.helger.ebinterface.v50.Ebi50TaxPercentType;
import com.helger.ebinterface.v50.Ebi50TaxType;
import com.helger.ebinterface.v50.Ebi50UnitPriceType;
import com.helger.ebinterface.v50.Ebi50UnitType;
import com.helger.ebinterface.v50.ObjectFactory;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.AllowanceChargeType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.CreditNoteLineType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.DeliveryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.OrderLineReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyTaxSchemeType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PeriodType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.TaxCategoryType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.DescriptionType;
import oasis.names.specification.ubl.schema.xsd.creditnote_21.CreditNoteType;

@Immutable
public final class CreditNoteToEbInterface50Converter
extends AbstractToEbInterface50Converter {
    private ICustomCreditNoteToEbInterface50Converter m_aCustomizer;

    public CreditNoteToEbInterface50Converter(@Nonnull Locale locale, @Nonnull Locale locale2, @Nonnull IToEbinterfaceSettings iToEbinterfaceSettings) {
        super(locale, locale2, iToEbinterfaceSettings);
    }

    @Nonnull
    public CreditNoteToEbInterface50Converter setCustomizer(@Nullable ICustomCreditNoteToEbInterface50Converter iCustomCreditNoteToEbInterface50Converter) {
        this.m_aCustomizer = iCustomCreditNoteToEbInterface50Converter;
        return this;
    }

    @Nullable
    public Ebi50InvoiceType convertToEbInterface(@Nonnull CreditNoteType creditNoteType, @Nonnull ErrorList errorList) {
        Object object20;
        Object object2;
        Ebi50TaxPercentType ebi50TaxPercentType;
        Object object3;
        Object object4;
        Object object52;
        Ebi50UnitType ebi50UnitType;
        Object object6;
        Object object72;
        Ebi50TaxItemType ebi50TaxItemType;
        Object object8;
        TaxCategoryType taxCategoryType2;
        Object object92;
        int n;
        Object object102;
        Object object11;
        Object object12;
        PartyTaxSchemeType partyTaxSchemeType2;
        Object object132;
        ValueEnforcer.notNull((Object)creditNoteType, (String)"UBLCreditNote");
        ValueEnforcer.notNull((Object)errorList, (String)"TransformationErrorList");
        ValueEnforcer.isTrue((boolean)errorList.isEmpty(), (String)"TransformationErrorList must be empty!");
        this.checkCreditNoteConsistency(creditNoteType, errorList);
        if (errorList.containsAtLeastOneError()) {
            return null;
        }
        Ebi50InvoiceType ebi50InvoiceType = new Ebi50InvoiceType();
        ebi50InvoiceType.setGeneratingSystem("UBL 2.1 to ebInterface 5.0 converter");
        ebi50InvoiceType.setDocumentType(CreditNoteToEbInterface50Converter.getAsDocumentTypeType(creditNoteType.getCreditNoteTypeCode() == null ? null : creditNoteType.getCreditNoteTypeCode().getName(), creditNoteType.getCreditNoteTypeCodeValue(), Ebi50DocumentTypeType.CREDIT_MEMO.value()));
        String string = StringHelper.trim((String)creditNoteType.getDocumentCurrencyCodeValue());
        ebi50InvoiceType.setInvoiceCurrency(string);
        String string2 = StringHelper.trim((String)creditNoteType.getIDValue());
        if (StringHelper.hasNoText((String)string2)) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("ID")).errorText(AbstractToEbInterfaceConverter.EText.MISSING_INVOICE_NUMBER.getDisplayText(this.m_aDisplayLocale))).build());
        }
        ebi50InvoiceType.setInvoiceNumber(string2);
        ebi50InvoiceType.setInvoiceDate(creditNoteType.getIssueDateValue());
        if (ebi50InvoiceType.getInvoiceDate() == null) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("IssueDate")).errorText(AbstractToEbInterfaceConverter.EText.MISSING_INVOICE_DATE.getDisplayText(this.m_aDisplayLocale))).build());
        }
        if (creditNoteType.getCopyIndicator() != null) {
            ebi50InvoiceType.setIsDuplicate(Boolean.valueOf(creditNoteType.getCopyIndicator().isValue()));
        }
        CreditNoteToEbInterface50Converter.convertRelatedDocuments(creditNoteType.getBillingReference(), ebi50InvoiceType);
        CreditNoteToEbInterface50Converter.convertReferencedDocuments(creditNoteType.getDespatchDocumentReference(), ebi50InvoiceType);
        CreditNoteToEbInterface50Converter.convertReferencedDocuments(creditNoteType.getReceiptDocumentReference(), ebi50InvoiceType);
        CreditNoteToEbInterface50Converter.convertReferencedDocuments(creditNoteType.getContractDocumentReference(), ebi50InvoiceType);
        CreditNoteToEbInterface50Converter.convertReferencedDocuments(creditNoteType.getAdditionalDocumentReference(), ebi50InvoiceType);
        CreditNoteToEbInterface50Converter.convertReferencedDocuments(creditNoteType.getStatementDocumentReference(), ebi50InvoiceType);
        CreditNoteToEbInterface50Converter.convertReferencedDocuments(creditNoteType.getOriginatorDocumentReference(), ebi50InvoiceType);
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        for (Object object132 : creditNoteType.getNote()) {
            if (!StringHelper.hasText((String)object132.getValue())) continue;
            commonsArrayList.add((Object)object132.getValue());
        }
        if (!commonsArrayList.isEmpty()) {
            ebi50InvoiceType.setComment(StringHelper.getImplodedNonEmpty((char)'\n', (Iterable)commonsArrayList));
        }
        commonsArrayList = creditNoteType.getAccountingSupplierParty();
        Object object14 = new Ebi50BillerType();
        if (commonsArrayList.getParty() != null) {
            for (PartyTaxSchemeType partyTaxSchemeType2 : commonsArrayList.getParty().getPartyTaxScheme()) {
                if (!CreditNoteToEbInterface50Converter.isVATSchemeID(partyTaxSchemeType2.getTaxScheme().getIDValue())) continue;
                object14.setVATIdentificationNumber(StringHelper.trim((String)partyTaxSchemeType2.getCompanyIDValue()));
                break;
            }
        }
        if (StringHelper.hasNoText((String)object14.getVATIdentificationNumber())) {
            object14.setVATIdentificationNumber("ATU00000000");
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("AccountingSupplierParty/Party/PartyTaxScheme")).errorText(AbstractToEbInterfaceConverter.EText.BILLER_VAT_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
        }
        if (commonsArrayList.getCustomerAssignedAccountID() != null) {
            object14.setInvoiceRecipientsBillerID(StringHelper.trim((String)commonsArrayList.getCustomerAssignedAccountIDValue()));
        }
        if (StringHelper.hasNoText((String)object14.getInvoiceRecipientsBillerID()) && commonsArrayList.getParty() != null && commonsArrayList.getParty().hasPartyIdentificationEntries()) {
            object14.setInvoiceRecipientsBillerID(StringHelper.trim((String)commonsArrayList.getParty().getPartyIdentificationAtIndex(0).getIDValue()));
        }
        for (PartyTaxSchemeType partyTaxSchemeType2 : commonsArrayList.getAdditionalAccountID()) {
            object12 = new Ebi50FurtherIdentificationType();
            object12.setIdentificationType("Consolidator");
            object12.setValue(StringHelper.trim((String)partyTaxSchemeType2.getValue()));
            object14.addFurtherIdentification(object12);
        }
        if (commonsArrayList.getParty() != null) {
            object132 = CreditNoteToEbInterface50Converter.convertParty(commonsArrayList.getParty(), "AccountingSupplierParty", errorList, this.m_aContentLocale, this.m_aDisplayLocale, true);
            object14.setAddress((Ebi50AddressType)object132);
            partyTaxSchemeType2 = CreditNoteToEbInterface50Converter.convertContact(commonsArrayList.getParty(), "AccountingSupplierParty", object14.getAddress().getName(), errorList, this.m_aDisplayLocale, true);
            object14.setContact((Ebi50ContactType)partyTaxSchemeType2);
            if (object132.hasNoEmailEntries() && (partyTaxSchemeType2 == null || partyTaxSchemeType2.hasNoEmailEntries()) && this.m_aSettings.isEnforceSupplierEmailAddress()) {
                object132.addEmail(this.m_aSettings.getEnforcedSupplierEmailAddress());
            }
        }
        for (PartyTaxSchemeType partyTaxSchemeType2 : creditNoteType.getContractDocumentReference()) {
            if (!StringHelper.hasTextAfterTrim((String)partyTaxSchemeType2.getIDValue())) continue;
            object12 = StringHelper.hasText((String)partyTaxSchemeType2.getID().getSchemeID()) ? partyTaxSchemeType2.getID().getSchemeID() : "Contract";
            object11 = new Ebi50FurtherIdentificationType();
            object11.setIdentificationType((String)object12);
            object11.setValue(StringHelper.trim((String)partyTaxSchemeType2.getIDValue()));
            object14.addFurtherIdentification((Ebi50FurtherIdentificationType)object11);
        }
        ebi50InvoiceType.setBiller((Ebi50BillerType)object14);
        commonsArrayList = creditNoteType.getAccountingCustomerParty();
        object14 = new Ebi50InvoiceRecipientType();
        if (commonsArrayList.getParty() != null) {
            for (PartyTaxSchemeType partyTaxSchemeType2 : commonsArrayList.getParty().getPartyTaxScheme()) {
                if (!CreditNoteToEbInterface50Converter.isVATSchemeID(partyTaxSchemeType2.getTaxScheme().getIDValue())) continue;
                object14.setVATIdentificationNumber(StringHelper.trim((String)partyTaxSchemeType2.getCompanyIDValue()));
                break;
            }
        }
        if (StringHelper.hasNoText((String)object14.getVATIdentificationNumber())) {
            object14.setVATIdentificationNumber("ATU00000000");
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("AccountingCustomerParty/PartyTaxScheme")).errorText(AbstractToEbInterfaceConverter.EText.INVOICE_RECIPIENT_VAT_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
        }
        if (commonsArrayList.getSupplierAssignedAccountID() != null) {
            object14.setBillersInvoiceRecipientID(StringHelper.trim((String)commonsArrayList.getSupplierAssignedAccountIDValue()));
        }
        for (PartyTaxSchemeType partyTaxSchemeType2 : commonsArrayList.getAdditionalAccountID()) {
            object12 = new Ebi50FurtherIdentificationType();
            object12.setIdentificationType("Consolidator");
            object12.setValue(StringHelper.trim((String)partyTaxSchemeType2.getValue()));
            object14.addFurtherIdentification(object12);
        }
        if (commonsArrayList.getParty() != null) {
            object14.setAddress(CreditNoteToEbInterface50Converter.convertParty(commonsArrayList.getParty(), "AccountingCustomerParty", errorList, this.m_aContentLocale, this.m_aDisplayLocale, true));
            object14.setContact(CreditNoteToEbInterface50Converter.convertContact(commonsArrayList.getParty(), "AccountingCustomerParty", object14.getAddress().getName(), errorList, this.m_aDisplayLocale, true));
        }
        ebi50InvoiceType.setInvoiceRecipient((Ebi50InvoiceRecipientType)object14);
        commonsArrayList = creditNoteType.getBuyerCustomerParty();
        if (commonsArrayList != null) {
            object14 = new Ebi50OrderingPartyType();
            if (commonsArrayList.getParty() != null) {
                for (PartyTaxSchemeType partyTaxSchemeType2 : commonsArrayList.getParty().getPartyTaxScheme()) {
                    if (!CreditNoteToEbInterface50Converter.isVATSchemeID(partyTaxSchemeType2.getTaxScheme().getIDValue())) continue;
                    object14.setVATIdentificationNumber(StringHelper.trim((String)partyTaxSchemeType2.getCompanyIDValue()));
                    break;
                }
            }
            if (StringHelper.hasNoText((String)object14.getVATIdentificationNumber())) {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("BuyerCustomerParty/PartyTaxScheme")).errorText(AbstractToEbInterfaceConverter.EText.ORDERING_PARTY_VAT_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
            }
            if (commonsArrayList.getParty() != null) {
                object14.setAddress(CreditNoteToEbInterface50Converter.convertParty(commonsArrayList.getParty(), "BuyerCustomerParty", errorList, this.m_aContentLocale, this.m_aDisplayLocale, true));
                object14.setContact(CreditNoteToEbInterface50Converter.convertContact(commonsArrayList.getParty(), "BuyerCustomerParty", object14.getAddress().getName(), errorList, this.m_aDisplayLocale, true));
            }
            if (commonsArrayList.getSupplierAssignedAccountID() != null) {
                object14.setBillersOrderingPartyID(StringHelper.trim((String)commonsArrayList.getSupplierAssignedAccountIDValue()));
            }
            if (StringHelper.hasNoText((String)object14.getBillersOrderingPartyID()) && commonsArrayList.getParty() != null && commonsArrayList.getParty().hasPartyIdentificationEntries()) {
                object14.setBillersOrderingPartyID(StringHelper.trim((String)commonsArrayList.getParty().getPartyIdentificationAtIndex(0).getIDValue()));
            }
            if (StringHelper.hasNoText((String)object14.getBillersOrderingPartyID()) && ebi50InvoiceType.getInvoiceRecipient() != null) {
                object14.setBillersOrderingPartyID(ebi50InvoiceType.getInvoiceRecipient().getBillersInvoiceRecipientID());
            }
            if (StringHelper.hasNoText((String)object14.getBillersOrderingPartyID())) {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("BuyerCustomerParty/SupplierAssignedAccountID")).errorText(AbstractToEbInterfaceConverter.EText.ORDERING_PARTY_SUPPLIER_ASSIGNED_ACCOUNT_ID_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
            }
            ebi50InvoiceType.setOrderingParty((Ebi50OrderingPartyType)object14);
        }
        object14 = null;
        object132 = creditNoteType.getOrderReference();
        if (object132 != null) {
            object14 = StringHelper.trim((String)object132.getIDValue());
        }
        if (StringHelper.hasNoText((String)object14)) {
            if (this.m_aSettings.isOrderReferenceIDMandatory()) {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("OrderReference/ID")).errorText(AbstractToEbInterfaceConverter.EText.ORDER_REFERENCE_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
            }
        } else {
            if (this.m_aSettings.hasOrderReferenceMaxLength()) {
                int n2 = this.m_aSettings.getOrderReferenceMaxLength();
                if (((String)object14).length() > n2) {
                    errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("OrderReference/ID")).errorText(AbstractToEbInterfaceConverter.EText.ORDER_REFERENCE_TOO_LONG.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{object14, n2}))).build());
                    object14 = ((String)object14).substring(0, n2);
                }
            }
            partyTaxSchemeType2 = new Ebi50OrderReferenceType();
            partyTaxSchemeType2.setOrderID((String)object14);
            ebi50InvoiceType.getInvoiceRecipient().setOrderReference((Ebi50OrderReferenceType)partyTaxSchemeType2);
        }
        object132 = new CommonsHashMap();
        partyTaxSchemeType2 = new Ebi50TaxType();
        int n3 = 0;
        for (Object object102 : creditNoteType.getTaxTotal()) {
            n = 0;
            for (Object object92 : object102.getTaxSubtotal()) {
                taxCategoryType2 = object92.getTaxCategory();
                object8 = StringHelper.trim((String)taxCategoryType2.getIDValue());
                boolean bl = CreditNoteToEbInterface50Converter.isTaxExemptionCategoryID((String)object8);
                BigDecimal bigDecimal = object92.getTaxAmountValue();
                ebi50TaxItemType = object92.getTaxableAmountValue();
                Object object15 = object72 = bl ? BigDecimal.ZERO : taxCategoryType2.getPercentValue();
                if (object72 == null && bigDecimal != null && ebi50TaxItemType != null) {
                    Object object16 = object72 = MathHelper.isEQ0((BigDecimal)ebi50TaxItemType) ? BigDecimal.ZERO : bigDecimal.multiply(CGlobal.BIGDEC_100).divide((BigDecimal)ebi50TaxItemType, 2, ROUNDING_MODE);
                }
                if (object72 != null) {
                    if (ebi50TaxItemType == null && bigDecimal != null) {
                        if (MathHelper.isNE0((BigDecimal)object72)) {
                            ebi50TaxItemType = bigDecimal.multiply(CGlobal.BIGDEC_100).divide((BigDecimal)object72, 4, ROUNDING_MODE);
                        }
                    } else if (ebi50TaxItemType != null && bigDecimal == null) {
                        BigDecimal bigDecimal2 = bigDecimal = MathHelper.isEQ0((BigDecimal)object72) ? BigDecimal.ZERO : ebi50TaxItemType.multiply((BigDecimal)object72).divide(CGlobal.BIGDEC_100, 4, ROUNDING_MODE);
                    }
                }
                if ((object6 = taxCategoryType2.getTaxScheme().getID()) == null) {
                    errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("TaxTotal[" + n3 + "]/TaxSubtotal[" + n + "]/TaxCategory/TaxScheme/ID")).errorText(AbstractToEbInterfaceConverter.EText.MISSING_TAXCATEGORY_TAXSCHEME_ID.getDisplayText(this.m_aDisplayLocale))).build());
                    break;
                }
                ebi50UnitType = StringHelper.trim((String)object6.getSchemeID());
                object52 = StringHelper.trim((String)object6.getValue());
                if (StringHelper.hasNoText((String)object52)) {
                    errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("TaxTotal[" + n3 + "]/TaxSubtotal[" + n + "]/TaxCategory/TaxScheme/ID")).errorText(AbstractToEbInterfaceConverter.EText.MISSING_TAXCATEGORY_TAXSCHEME_ID_VALUE.getDisplayText(this.m_aDisplayLocale))).build());
                    break;
                }
                if (taxCategoryType2.getID() == null) {
                    errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("TaxTotal[" + n3 + "]/TaxSubtotal[" + n + "]/TaxCategory")).errorText(AbstractToEbInterfaceConverter.EText.MISSING_TAXCATEGORY_ID.getDisplayText(this.m_aDisplayLocale))).build());
                    break;
                }
                if (StringHelper.hasNoText((String)object8)) {
                    errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("TaxTotal[" + n3 + "]/TaxSubtotal[" + n + "]/TaxCategory")).errorText(AbstractToEbInterfaceConverter.EText.MISSING_TAXCATEGORY_ID_VALUE.getDisplayText(this.m_aDisplayLocale))).build());
                    break;
                }
                object4 = StringHelper.trim((String)taxCategoryType2.getID().getSchemeID());
                object132.put((Object)new TaxCategoryKey(new SchemedID((String)ebi50UnitType, (String)object52), new SchemedID((String)object4, (String)object8)), object72);
                if (CreditNoteToEbInterface50Converter.isVATSchemeID((String)object52)) {
                    if (object72 == null) {
                        errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("TaxTotal[" + n3 + "]/TaxSubtotal[" + n + "]/TaxCategory/Percent")).errorText(AbstractToEbInterfaceConverter.EText.TAX_PERCENT_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
                    } else if (ebi50TaxItemType == null) {
                        errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("TaxTotal[" + n3 + "]/TaxSubtotal[" + n + "]/TaxableAmount")).errorText(AbstractToEbInterfaceConverter.EText.TAXABLE_AMOUNT_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
                    } else {
                        object3 = new Ebi50TaxItemType();
                        object3.setTaxableAmount(ebi50TaxItemType.setScale(2, ROUNDING_MODE));
                        ebi50TaxPercentType = new Ebi50TaxPercentType();
                        ebi50TaxPercentType.setTaxCategoryCode((String)object8);
                        if (bl) {
                            ebi50TaxPercentType.setValue(BigDecimal.ZERO);
                            object2 = null;
                            if (taxCategoryType2.hasTaxExemptionReasonEntries()) {
                                object2 = taxCategoryType2.getTaxExemptionReasonAtIndex(0).getValue();
                            }
                            if (object2 == null && taxCategoryType2.getTaxExemptionReasonCode() != null) {
                                object2 = taxCategoryType2.getTaxExemptionReasonCode().getValue();
                            }
                            if (StringHelper.hasText(object2)) {
                                object3.setComment((String)object2);
                            }
                        } else {
                            ebi50TaxPercentType.setValue((BigDecimal)object72);
                        }
                        object3.setTaxPercent(ebi50TaxPercentType);
                        object3.setTaxAmount(bigDecimal.setScale(2, ROUNDING_MODE));
                        partyTaxSchemeType2.addTaxItem((Ebi50TaxItemType)object3);
                    }
                } else {
                    object3 = new Ebi50OtherTaxType();
                    object3.setComment((String)object52);
                    object3.setAmount(bigDecimal.setScale(2, ROUNDING_MODE));
                    partyTaxSchemeType2.addOtherTax(object3);
                }
                ++n;
            }
            ++n3;
        }
        ebi50InvoiceType.setTax((Ebi50TaxType)partyTaxSchemeType2);
        BigDecimal bigDecimal = BigDecimal.ZERO;
        object11 = new Ebi50DetailsType();
        object102 = new Ebi50ItemListType();
        n = 0;
        for (Object object92 : creditNoteType.getCreditNoteLine()) {
            Object object172;
            Object object18;
            Object object19;
            OrderLineReferenceType orderLineReferenceType2;
            boolean bl;
            taxCategoryType2 = (TaxCategoryType)CollectionHelper.getAtIndex((List)object92.getItem().getClassifiedTaxCategory(), (int)0);
            if (taxCategoryType2 == null) {
                taxCategoryType2 = CreditNoteToEbInterface50Converter.findTaxCategory(object92.getTaxTotal());
            }
            object8 = null;
            String string3 = null;
            if (taxCategoryType2 != null) {
                string3 = StringHelper.trim((String)taxCategoryType2.getIDValue());
                if (taxCategoryType2.getPercent() != null) {
                    object8 = taxCategoryType2.getPercentValue();
                }
                if (object8 == null && taxCategoryType2.getID() != null && taxCategoryType2.getTaxScheme() != null && taxCategoryType2.getTaxScheme().getID() != null) {
                    String string4 = StringHelper.trim((String)taxCategoryType2.getTaxScheme().getID().getSchemeID());
                    ebi50TaxItemType = StringHelper.trim((String)taxCategoryType2.getTaxScheme().getIDValue());
                    object72 = StringHelper.trim((String)taxCategoryType2.getID().getSchemeID());
                    if (StringHelper.hasText((String)ebi50TaxItemType) && StringHelper.hasText((String)string3)) {
                        object6 = new TaxCategoryKey(new SchemedID(string4, (String)ebi50TaxItemType), new SchemedID((String)object72, string3));
                        object8 = (BigDecimal)object132.get(object6);
                    }
                }
            }
            if ((bl = CreditNoteToEbInterface50Converter.isTaxExemptionCategoryID(string3)) && object8 == null) {
                object8 = BigDecimal.ZERO;
            }
            if (object8 == null) {
                object8 = BigDecimal.ZERO;
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("CreditNoteLine[" + n + "]/Item/ClassifiedTaxCategory")).errorText(AbstractToEbInterfaceConverter.EText.DETAILS_TAX_PERCENTAGE_NOT_FOUND.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{object8}))).build());
            }
            ebi50TaxItemType = new Ebi50ListLineItemType();
            object72 = StringHelper.trim((String)object92.getIDValue());
            object6 = StringParser.parseBigInteger((String)object72);
            if (object6 != null && MathHelper.isLT1((BigInteger)object6)) {
                if (this.m_aSettings.isErrorOnPositionNumber()) {
                    errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("CreditNoteLine[" + n + "]/ID")).errorText(AbstractToEbInterfaceConverter.EText.DETAILS_INVALID_POSITION.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{object72}))).build());
                } else {
                    object6 = null;
                }
            }
            if (object6 == null) {
                object6 = BigInteger.valueOf((long)n + 1L);
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("CreditNoteLine[" + n + "]/ID")).errorText(AbstractToEbInterfaceConverter.EText.DETAILS_INVALID_POSITION_SET_TO_INDEX.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{object72, object6}))).build());
            }
            ebi50TaxItemType.setPositionNumber((BigInteger)object6);
            ebi50UnitType = object92.getItem().getDescription().iterator();
            while (ebi50UnitType.hasNext()) {
                object52 = (DescriptionType)ebi50UnitType.next();
                object4 = StringHelper.trim((String)object52.getValue());
                if (!StringHelper.hasText((String)object4)) continue;
                ebi50TaxItemType.addDescription((String)object4);
            }
            if (ebi50TaxItemType.hasNoDescriptionEntries() && (ebi50UnitType = object92.getItem().getName()) != null && StringHelper.hasText((String)(object52 = StringHelper.trim((String)ebi50UnitType.getValue())))) {
                ebi50TaxItemType.addDescription((String)object52);
            }
            for (Object object52 : object92.getNote()) {
                object4 = StringHelper.trim((String)object52.getValue());
                if (!StringHelper.hasText((String)object4)) continue;
                ebi50TaxItemType.addDescription((String)object4);
            }
            ebi50UnitType = new Ebi50UnitType();
            if (object92.getCreditedQuantity() != null) {
                if (object92.getCreditedQuantity().getUnitCode() != null) {
                    ebi50UnitType.setUnit(StringHelper.trim((String)object92.getCreditedQuantity().getUnitCode()));
                }
                ebi50UnitType.setValue(object92.getCreditedQuantityValue());
            }
            if (ebi50UnitType.getUnit() == null) {
                ebi50UnitType.setUnit("C62");
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("CreditNoteLine[" + n + "]/CreditNotedQuantity/UnitCode")).errorText(AbstractToEbInterfaceConverter.EText.DETAILS_INVALID_UNIT.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{ebi50UnitType.getUnit()}))).build());
            }
            if (ebi50UnitType.getValue() == null) {
                ebi50UnitType.setValue(BigDecimal.ONE);
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("CreditNoteLine[" + n + "]/CreditNotedQuantity")).errorText(AbstractToEbInterfaceConverter.EText.DETAILS_INVALID_QUANTITY.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{ebi50UnitType.getValue()}))).build());
            }
            ebi50TaxItemType.setQuantity(ebi50UnitType);
            if (object92.getPrice() != null) {
                object52 = new Ebi50UnitPriceType();
                object4 = object92.getPrice().getPriceAmountValue();
                object52.setValue((BigDecimal)object4);
                object3 = object92.getPrice().getBaseQuantityValue();
                if (object3 != null) {
                    object52.setBaseQuantity((BigDecimal)object3);
                    if (MathHelper.isEQ0((BigDecimal)object3)) {
                        object52.setValue(BigDecimal.ZERO);
                    }
                }
                ebi50TaxItemType.setUnitPrice((Ebi50UnitPriceType)object52);
            } else {
                object52 = object92.getLineExtensionAmountValue();
                object4 = new Ebi50UnitPriceType();
                if (MathHelper.isEQ0((BigDecimal)ebi50UnitType.getValue())) {
                    object4.setValue(BigDecimal.ZERO);
                } else {
                    object4.setValue(((BigDecimal)object52).divide(ebi50UnitType.getValue(), 4, ROUNDING_MODE));
                }
                ebi50TaxItemType.setUnitPrice((Ebi50UnitPriceType)object4);
            }
            object52 = ebi50TaxItemType.getUnitPrice().getValue();
            object4 = ebi50TaxItemType.getUnitPrice().getBaseQuantity();
            if (object4 != null && MathHelper.isNE0((BigDecimal)object4)) {
                object52 = ((BigDecimal)object52).divide((BigDecimal)object4, 4, ROUNDING_MODE);
            }
            ebi50TaxItemType.setLineItemAmount(object92.getLineExtensionAmountValue().setScale(2, ROUNDING_MODE));
            object3 = new Ebi50TaxItemType();
            object3.setTaxableAmount(ebi50TaxItemType.getLineItemAmount());
            ebi50TaxPercentType = new Ebi50TaxPercentType();
            if (bl) {
                ebi50TaxPercentType.setTaxCategoryCode(string3);
                ebi50TaxPercentType.setValue(BigDecimal.ZERO);
                object2 = null;
                if (taxCategoryType2.hasTaxExemptionReasonEntries()) {
                    object2 = taxCategoryType2.getTaxExemptionReasonAtIndex(0).getValue();
                }
                if (object2 == null && taxCategoryType2.getTaxExemptionReasonCode() != null) {
                    object2 = taxCategoryType2.getTaxExemptionReasonCode().getValue();
                }
                if (StringHelper.hasText((String)object2)) {
                    object3.setComment((String)object2);
                }
            } else {
                ebi50TaxPercentType.setTaxCategoryCode(string3);
                ebi50TaxPercentType.setValue((BigDecimal)object8);
            }
            object3.setTaxPercent(ebi50TaxPercentType);
            if (bl) {
                object3.setTaxAmount(BigDecimal.ZERO);
            } else {
                object3.setTaxAmount(MathHelper.getPercentValue((BigDecimal)object3.getTaxableAmount(), (BigDecimal)object8, (int)2, (RoundingMode)ROUNDING_MODE));
            }
            ebi50TaxItemType.setTaxItem((Ebi50TaxItemType)object3);
            if (MathHelper.isEQ0((BigDecimal)object8)) {
                bigDecimal = bigDecimal.add(ebi50TaxItemType.getLineItemAmount());
            }
            object2 = object92.getOrderLineReference().iterator();
            while (object2.hasNext()) {
                orderLineReferenceType2 = (OrderLineReferenceType)object2.next();
                if (!StringHelper.hasText((String)orderLineReferenceType2.getLineIDValue())) continue;
                object19 = new Ebi50OrderReferenceDetailType();
                object18 = null;
                if (orderLineReferenceType2.getOrderReference() != null) {
                    object18 = StringHelper.trim((String)orderLineReferenceType2.getOrderReference().getIDValue());
                }
                if (StringHelper.hasNoText(object18)) {
                    object18 = object14;
                }
                object19.setOrderID((String)object18);
                object172 = StringHelper.trim((String)orderLineReferenceType2.getLineIDValue());
                if (object172 != null) {
                    if (((String)object172).length() == 0) {
                        errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("CreditNoteLine[" + n + "]/OrderLineReference/LineID")).errorText(AbstractToEbInterfaceConverter.EText.ORDERLINE_REF_ID_EMPTY.getDisplayText(this.m_aDisplayLocale))).build());
                    } else {
                        object19.setOrderPositionNumber((String)object172);
                    }
                }
                if (StringHelper.hasText((String)object19.getOrderPositionNumber()) && StringHelper.hasNoText((String)object18)) {
                    if (this.m_aSettings.isOrderReferenceIDMandatory()) {
                        errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("CreditNoteLine[" + n + "]/OrderLineReference/OrderReference/ID")).errorText(AbstractToEbInterfaceConverter.EText.ORDER_REFERENCE_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
                    } else {
                        object19.setOrderPositionNumber(null);
                        errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("CreditNoteLine[" + n + "]/OrderLineReference/OrderReference/ID")).errorText(AbstractToEbInterfaceConverter.EText.ORDER_REFERENCE_MISSING_IGNORE_ORDER_POS.getDisplayText(this.m_aDisplayLocale))).build());
                    }
                }
                if (!StringHelper.hasText((String)object18)) break;
                ebi50TaxItemType.setInvoiceRecipientsOrderReference(object19);
                break;
            }
            if (object92.hasAllowanceChargeEntries()) {
                object2 = ebi50TaxItemType.getQuantity().getValue().multiply((BigDecimal)object52);
                orderLineReferenceType2 = new Ebi50ReductionAndSurchargeListLineItemDetailsType();
                object19 = ETriState.UNDEFINED;
                for (Object object172 : object92.getAllowanceCharge()) {
                    boolean bl2 = object172.getChargeIndicator().isValue();
                    if (object19.isUndefined()) {
                        object19 = ETriState.valueOf((boolean)bl2);
                    }
                    boolean bl3 = bl2 != object19.isTrue();
                    Ebi50ReductionAndSurchargeBaseType ebi50ReductionAndSurchargeBaseType = new Ebi50ReductionAndSurchargeBaseType();
                    BigDecimal bigDecimal3 = object172.getAmountValue();
                    ebi50ReductionAndSurchargeBaseType.setAmount(bl3 ? bigDecimal3.negate() : bigDecimal3);
                    if (object172.getBaseAmount() != null) {
                        ebi50ReductionAndSurchargeBaseType.setBaseAmount(object172.getBaseAmountValue());
                    }
                    if (ebi50ReductionAndSurchargeBaseType.getBaseAmount() == null) {
                        ebi50ReductionAndSurchargeBaseType.setBaseAmount(object2);
                    }
                    if (object172.getMultiplierFactorNumeric() != null) {
                        BigDecimal bigDecimal4 = object172.getMultiplierFactorNumericValue().multiply(CGlobal.BIGDEC_100);
                        ebi50ReductionAndSurchargeBaseType.setPercentage(bigDecimal4);
                    }
                    if (object19.isTrue()) {
                        orderLineReferenceType2.addReductionListLineItemOrSurchargeListLineItemOrOtherVATableTaxListLineItem(new ObjectFactory().createSurchargeListLineItem(ebi50ReductionAndSurchargeBaseType));
                        object2 = ((BigDecimal)object2).add(ebi50ReductionAndSurchargeBaseType.getAmount());
                    } else {
                        orderLineReferenceType2.addReductionListLineItemOrSurchargeListLineItemOrOtherVATableTaxListLineItem(new ObjectFactory().createReductionListLineItem(ebi50ReductionAndSurchargeBaseType));
                        object2 = ((BigDecimal)object2).subtract(ebi50ReductionAndSurchargeBaseType.getAmount());
                    }
                    ebi50ReductionAndSurchargeBaseType.setComment(CreditNoteToEbInterface50Converter.getAllowanceChargeComment((AllowanceChargeType)object172));
                }
                ebi50TaxItemType.setReductionAndSurchargeListLineItemDetails((Ebi50ReductionAndSurchargeListLineItemDetailsType)orderLineReferenceType2);
            }
            if (object92.hasDeliveryEntries() && (object2 = object92.getDeliveryAtIndex(0)).getActualDeliveryDate() != null) {
                orderLineReferenceType2 = CreditNoteToEbInterface50Converter.convertDelivery(object2, "CreditNoteLine[" + n + "]/Delivery[0]", creditNoteType.getAccountingCustomerParty(), errorList, this.m_aContentLocale, this.m_aDisplayLocale);
                ebi50TaxItemType.setDelivery((Ebi50DeliveryType)orderLineReferenceType2);
            }
            for (OrderLineReferenceType orderLineReferenceType2 : object92.getItem().getAdditionalItemProperty()) {
                object19 = null;
                object18 = null;
                if (orderLineReferenceType2.getName() != null) {
                    object19 = orderLineReferenceType2.getName().getValue();
                }
                if (StringHelper.hasNoText((String)object19)) {
                    object19 = orderLineReferenceType2.getIDValue();
                }
                object18 = orderLineReferenceType2.getValueValue();
                if (!StringHelper.hasText((String)object19) || !StringHelper.hasText((String)object18)) continue;
                object172 = new Ebi50AdditionalInformationType();
                object172.setKey((String)object19);
                object172.setValue((String)object18);
                ebi50TaxItemType.addAdditionalInformation((Ebi50AdditionalInformationType)object172);
            }
            if (this.m_aCustomizer != null) {
                this.m_aCustomizer.additionalItemMapping((CreditNoteLineType)object92, ebi50TaxItemType);
            }
            object102.addListLineItem((Ebi50ListLineItemType)ebi50TaxItemType);
            ++n;
        }
        object11.addItemList((Ebi50ItemListType)object102);
        ebi50InvoiceType.setDetails((Ebi50DetailsType)object11);
        if (partyTaxSchemeType2.hasNoTaxItemEntries()) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("CreditNote")).errorText(AbstractToEbInterfaceConverter.EText.VAT_ITEM_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
        }
        if (creditNoteType.hasAllowanceChargeEntries()) {
            object11 = creditNoteType.getLegalMonetaryTotal().getLineExtensionAmountValue();
            if (object11 == null) {
                object102 = BigDecimal.ZERO;
                for (Object object20 : ebi50InvoiceType.getDetails().getItemList()) {
                    for (TaxCategoryType taxCategoryType2 : object20.getListLineItem()) {
                        object102 = ((BigDecimal)object102).add(taxCategoryType2.getLineItemAmount());
                    }
                }
                object11 = object102;
            }
            object102 = new Ebi50ReductionAndSurchargeDetailsType();
            n = 0;
            for (Object object92 : creditNoteType.getAllowanceCharge()) {
                BigDecimal bigDecimal5;
                boolean bl = object92.getChargeIndicator().isValue();
                object8 = new Ebi50ReductionAndSurchargeType();
                BigDecimal bigDecimal6 = object92.getAmountValue();
                object8.setAmount(bigDecimal6);
                if (object92.getBaseAmount() != null) {
                    object8.setBaseAmount(object92.getBaseAmountValue());
                }
                if (object8.getBaseAmount() == null) {
                    object8.setBaseAmount((BigDecimal)object11);
                }
                if (object92.getMultiplierFactorNumeric() != null) {
                    bigDecimal5 = object92.getMultiplierFactorNumericValue().multiply(CGlobal.BIGDEC_100);
                    object8.setPercentage(bigDecimal5);
                }
                object8.setComment(CreditNoteToEbInterface50Converter.getAllowanceChargeComment((AllowanceChargeType)object92));
                bigDecimal5 = null;
                for (Object object72 : object92.getTaxCategory()) {
                    if (object72.getPercent() == null) continue;
                    bigDecimal5 = new Ebi50TaxPercentType();
                    bigDecimal5.setValue(object72.getPercentValue());
                    bigDecimal5.setTaxCategoryCode(object72.getIDValue());
                    break;
                }
                if (bigDecimal5 == null) {
                    errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("CreditNote/AllowanceCharge[" + n + "]")).errorText(AbstractToEbInterfaceConverter.EText.ALLOWANCE_CHARGE_NO_TAXRATE.getDisplayText(this.m_aDisplayLocale))).build());
                } else {
                    ebi50TaxItemType = new Ebi50TaxItemType();
                    ebi50TaxItemType.setTaxableAmount(bigDecimal6);
                    ebi50TaxItemType.setTaxPercent((Ebi50TaxPercentType)bigDecimal5);
                    object8.setTaxItem(ebi50TaxItemType);
                }
                if (bl) {
                    object102.addReductionOrSurchargeOrOtherVATableTax(new ObjectFactory().createSurcharge((Ebi50ReductionAndSurchargeType)object8));
                    object11 = ((BigDecimal)object11).add(object8.getAmount());
                } else {
                    object102.addReductionOrSurchargeOrOtherVATableTax(new ObjectFactory().createReduction((Ebi50ReductionAndSurchargeType)object8));
                    object11 = ((BigDecimal)object11).subtract(object8.getAmount());
                }
                ebi50InvoiceType.setReductionAndSurchargeDetails((Ebi50ReductionAndSurchargeDetailsType)object102);
                ++n;
            }
        }
        if ((object11 = creditNoteType.getLegalMonetaryTotal()).getPrepaidAmount() != null && !MathHelper.isEQ0((BigDecimal)object11.getPrepaidAmountValue())) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("CreditNote/LegalMonetaryTotal/PrepaidAmount")).errorText(AbstractToEbInterfaceConverter.EText.PREPAID_NOT_SUPPORTED.getDisplayText(this.m_aDisplayLocale))).build());
        }
        if (object11.getTaxInclusiveAmountValue() != null) {
            ebi50InvoiceType.setTotalGrossAmount(object11.getTaxInclusiveAmountValue().setScale(2, ROUNDING_MODE));
        } else {
            ebi50InvoiceType.setTotalGrossAmount(object11.getPayableAmountValue().setScale(2, ROUNDING_MODE));
        }
        ebi50InvoiceType.setPayableAmount(object11.getPayableAmountValue().setScale(2, ROUNDING_MODE));
        this.convertPayment(() -> null, () -> ((CreditNoteType)creditNoteType).getPaymentMeans(), () -> ((CreditNoteType)creditNoteType).getPayeeParty(), () -> ((CreditNoteType)creditNoteType).getAccountingSupplierParty(), () -> ((CreditNoteType)creditNoteType).getPaymentTerms(), () -> ((CreditNoteType)creditNoteType).getLegalMonetaryTotal(), errorList, ebi50InvoiceType, true);
        object102 = null;
        n = 0;
        object20 = creditNoteType.getDelivery().iterator();
        while (object20.hasNext()) {
            object92 = (DeliveryType)object20.next();
            if (object92.getActualDeliveryDate() != null) {
                object102 = CreditNoteToEbInterface50Converter.convertDelivery((DeliveryType)object92, "/Delivery[" + n + "]", creditNoteType.getAccountingCustomerParty(), errorList, this.m_aContentLocale, this.m_aDisplayLocale);
                break;
            }
            ++n;
        }
        if (object102 == null) {
            object102 = new Ebi50DeliveryType();
        }
        if ((object20 = (PeriodType)CollectionHelper.getAtIndex((List)creditNoteType.getInvoicePeriod(), (int)0)) != null) {
            object92 = object20.getStartDateValue();
            XMLOffsetDate xMLOffsetDate = object20.getEndDateValue();
            if (object92 != null) {
                if (xMLOffsetDate == null) {
                    if (object102.getDate() == null) {
                        object102.setDate((XMLOffsetDate)object92);
                    }
                } else {
                    object8 = new Ebi50PeriodType();
                    object8.setFromDate((XMLOffsetDate)object92);
                    object8.setToDate(xMLOffsetDate);
                    object102.setPeriod((Ebi50PeriodType)object8);
                    object102.setDate((XMLOffsetDate)null);
                }
            }
        }
        if (this.m_aSettings.isDeliveryDateMandatory() && object102.getDate() == null && object102.getPeriod() == null) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("CreditNote")).errorText(AbstractToEbInterfaceConverter.EText.ERB_NO_DELIVERY_DATE.getDisplayText(this.m_aDisplayLocale))).build());
        }
        if (object102.getDate() != null || object102.getPeriod() != null) {
            ebi50InvoiceType.setDelivery((Ebi50DeliveryType)object102);
        }
        if (this.m_aCustomizer != null) {
            this.m_aCustomizer.additionalGlobalMapping(creditNoteType, ebi50InvoiceType);
        }
        return ebi50InvoiceType;
    }
}

