/*
 * Decompiled with CFR 0.152.
 */
package at.austriapro.ebinterface.ubl.from.invoice;

import at.austriapro.ebinterface.ubl.from.AbstractToEbInterface42Converter;
import at.austriapro.ebinterface.ubl.from.AbstractToEbInterfaceConverter;
import at.austriapro.ebinterface.ubl.from.IToEbinterfaceSettings;
import at.austriapro.ebinterface.ubl.from.helper.SchemedID;
import at.austriapro.ebinterface.ubl.from.helper.TaxCategoryKey;
import at.austriapro.ebinterface.ubl.from.invoice.ICustomInvoiceToEbInterface42Converter;
import com.helger.commons.CGlobal;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.datetime.XMLOffsetDate;
import com.helger.commons.error.SingleError;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.math.MathHelper;
import com.helger.commons.state.ETriState;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.StringParser;
import com.helger.ebinterface.v42.Ebi42BillerType;
import com.helger.ebinterface.v42.Ebi42DeliveryType;
import com.helger.ebinterface.v42.Ebi42DetailsType;
import com.helger.ebinterface.v42.Ebi42DocumentTypeType;
import com.helger.ebinterface.v42.Ebi42FurtherIdentificationType;
import com.helger.ebinterface.v42.Ebi42InvoiceRecipientType;
import com.helger.ebinterface.v42.Ebi42InvoiceType;
import com.helger.ebinterface.v42.Ebi42ItemListType;
import com.helger.ebinterface.v42.Ebi42ListLineItemType;
import com.helger.ebinterface.v42.Ebi42OrderReferenceDetailType;
import com.helger.ebinterface.v42.Ebi42OrderReferenceType;
import com.helger.ebinterface.v42.Ebi42OrderingPartyType;
import com.helger.ebinterface.v42.Ebi42OtherTaxType;
import com.helger.ebinterface.v42.Ebi42PeriodType;
import com.helger.ebinterface.v42.Ebi42ReductionAndSurchargeBaseType;
import com.helger.ebinterface.v42.Ebi42ReductionAndSurchargeDetailsType;
import com.helger.ebinterface.v42.Ebi42ReductionAndSurchargeListLineItemDetailsType;
import com.helger.ebinterface.v42.Ebi42ReductionAndSurchargeType;
import com.helger.ebinterface.v42.Ebi42TaxExemptionType;
import com.helger.ebinterface.v42.Ebi42TaxType;
import com.helger.ebinterface.v42.Ebi42UnitPriceType;
import com.helger.ebinterface.v42.Ebi42UnitType;
import com.helger.ebinterface.v42.Ebi42VATItemType;
import com.helger.ebinterface.v42.Ebi42VATRateType;
import com.helger.ebinterface.v42.Ebi42VATType;
import com.helger.ebinterface.v42.ObjectFactory;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.AllowanceChargeType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.DeliveryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.InvoiceLineType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.OrderLineReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyTaxSchemeType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PeriodType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.TaxCategoryType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.DescriptionType;
import oasis.names.specification.ubl.schema.xsd.invoice_21.InvoiceType;

@Immutable
public final class InvoiceToEbInterface42Converter
extends AbstractToEbInterface42Converter {
    private ICustomInvoiceToEbInterface42Converter m_aCustomizer;

    public InvoiceToEbInterface42Converter(@Nonnull Locale locale, @Nonnull Locale locale2, @Nonnull IToEbinterfaceSettings iToEbinterfaceSettings) {
        super(locale, locale2, iToEbinterfaceSettings);
    }

    @Nonnull
    public InvoiceToEbInterface42Converter setCustomizer(@Nullable ICustomInvoiceToEbInterface42Converter iCustomInvoiceToEbInterface42Converter) {
        this.m_aCustomizer = iCustomInvoiceToEbInterface42Converter;
        return this;
    }

    @Nullable
    public Ebi42InvoiceType convertToEbInterface(@Nonnull InvoiceType invoiceType, @Nonnull ErrorList errorList) {
        Object object19;
        Ebi42TaxExemptionType ebi42TaxExemptionType;
        Object object2;
        Object object3;
        Object object4;
        Object object52;
        Ebi42UnitType ebi42UnitType;
        Object object6;
        Object object72;
        Iterator iterator;
        Object object8;
        TaxCategoryType taxCategoryType2;
        Object object92;
        int n;
        Object object102;
        Object object11;
        PartyTaxSchemeType partyTaxSchemeType2;
        Object object122;
        ValueEnforcer.notNull((Object)invoiceType, (String)"UBLInvoice");
        ValueEnforcer.notNull((Object)errorList, (String)"TransformationErrorList");
        ValueEnforcer.isTrue((boolean)errorList.isEmpty(), (String)"TransformationErrorList must be empty!");
        this.checkInvoiceConsistency(invoiceType, errorList);
        if (errorList.containsAtLeastOneError()) {
            return null;
        }
        Ebi42InvoiceType ebi42InvoiceType = new Ebi42InvoiceType();
        ebi42InvoiceType.setGeneratingSystem("UBL 2.1 to ebInterface 4.2 converter");
        ebi42InvoiceType.setDocumentType(InvoiceToEbInterface42Converter.getAsDocumentTypeType(invoiceType.getInvoiceTypeCode() == null ? null : invoiceType.getInvoiceTypeCode().getName(), invoiceType.getInvoiceTypeCodeValue(), Ebi42DocumentTypeType.INVOICE.value()));
        String string = StringHelper.trim((String)invoiceType.getDocumentCurrencyCodeValue());
        ebi42InvoiceType.setInvoiceCurrency(string);
        String string2 = StringHelper.trim((String)invoiceType.getIDValue());
        if (StringHelper.hasNoText((String)string2)) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("ID")).errorText(AbstractToEbInterfaceConverter.EText.MISSING_INVOICE_NUMBER.getDisplayText(this.m_aDisplayLocale))).build());
        }
        ebi42InvoiceType.setInvoiceNumber(string2);
        ebi42InvoiceType.setInvoiceDate(invoiceType.getIssueDateValue());
        if (ebi42InvoiceType.getInvoiceDate() == null) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("IssueDate")).errorText(AbstractToEbInterfaceConverter.EText.MISSING_INVOICE_DATE.getDisplayText(this.m_aDisplayLocale))).build());
        }
        if (invoiceType.getCopyIndicator() != null) {
            ebi42InvoiceType.setIsDuplicate(Boolean.valueOf(invoiceType.getCopyIndicator().isValue()));
        }
        InvoiceToEbInterface42Converter.convertRelatedDocuments(invoiceType.getBillingReference(), ebi42InvoiceType);
        InvoiceToEbInterface42Converter.convertReferencedDocuments(invoiceType.getDespatchDocumentReference(), ebi42InvoiceType);
        InvoiceToEbInterface42Converter.convertReferencedDocuments(invoiceType.getReceiptDocumentReference(), ebi42InvoiceType);
        InvoiceToEbInterface42Converter.convertReferencedDocuments(invoiceType.getContractDocumentReference(), ebi42InvoiceType);
        InvoiceToEbInterface42Converter.convertReferencedDocuments(invoiceType.getAdditionalDocumentReference(), ebi42InvoiceType);
        InvoiceToEbInterface42Converter.convertReferencedDocuments(invoiceType.getStatementDocumentReference(), ebi42InvoiceType);
        InvoiceToEbInterface42Converter.convertReferencedDocuments(invoiceType.getOriginatorDocumentReference(), ebi42InvoiceType);
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        for (Object object122 : invoiceType.getNote()) {
            if (!StringHelper.hasText((String)object122.getValue())) continue;
            commonsArrayList.add((Object)object122.getValue());
        }
        if (!commonsArrayList.isEmpty()) {
            ebi42InvoiceType.setComment(StringHelper.getImplodedNonEmpty((char)'\n', (Iterable)commonsArrayList));
        }
        commonsArrayList = invoiceType.getAccountingSupplierParty();
        Object object13 = new Ebi42BillerType();
        if (commonsArrayList.getParty() != null) {
            for (PartyTaxSchemeType partyTaxSchemeType2 : commonsArrayList.getParty().getPartyTaxScheme()) {
                if (!InvoiceToEbInterface42Converter.isVATSchemeID(partyTaxSchemeType2.getTaxScheme().getIDValue())) continue;
                object13.setVATIdentificationNumber(StringHelper.trim((String)partyTaxSchemeType2.getCompanyIDValue()));
                break;
            }
        }
        if (StringHelper.hasNoText((String)object13.getVATIdentificationNumber())) {
            object13.setVATIdentificationNumber("ATU00000000");
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("AccountingSupplierParty/Party/PartyTaxScheme")).errorText(AbstractToEbInterfaceConverter.EText.BILLER_VAT_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
        }
        if (commonsArrayList.getCustomerAssignedAccountID() != null) {
            object13.setInvoiceRecipientsBillerID(StringHelper.trim((String)commonsArrayList.getCustomerAssignedAccountIDValue()));
        }
        if (StringHelper.hasNoText((String)object13.getInvoiceRecipientsBillerID()) && commonsArrayList.getParty() != null && commonsArrayList.getParty().hasPartyIdentificationEntries()) {
            object13.setInvoiceRecipientsBillerID(StringHelper.trim((String)commonsArrayList.getParty().getPartyIdentificationAtIndex(0).getIDValue()));
        }
        for (PartyTaxSchemeType partyTaxSchemeType2 : commonsArrayList.getAdditionalAccountID()) {
            object11 = new Ebi42FurtherIdentificationType();
            object11.setIdentificationType("Consolidator");
            object11.setValue(StringHelper.trim((String)partyTaxSchemeType2.getValue()));
            object13.addFurtherIdentification(object11);
        }
        if (commonsArrayList.getParty() != null) {
            object13.setAddress(InvoiceToEbInterface42Converter.convertParty(commonsArrayList.getParty(), "AccountingSupplierParty", errorList, this.m_aContentLocale, this.m_aDisplayLocale, true));
            if (StringHelper.hasNoText((String)object13.getAddress().getEmail()) && this.m_aSettings.isEnforceSupplierEmailAddress()) {
                object13.getAddress().setEmail(this.m_aSettings.getEnforcedSupplierEmailAddress());
            }
        }
        for (PartyTaxSchemeType partyTaxSchemeType2 : invoiceType.getContractDocumentReference()) {
            if (!StringHelper.hasTextAfterTrim((String)partyTaxSchemeType2.getIDValue())) continue;
            object11 = StringHelper.hasText((String)partyTaxSchemeType2.getID().getSchemeID()) ? partyTaxSchemeType2.getID().getSchemeID() : "Contract";
            Ebi42FurtherIdentificationType ebi42FurtherIdentificationType = new Ebi42FurtherIdentificationType();
            ebi42FurtherIdentificationType.setIdentificationType((String)object11);
            ebi42FurtherIdentificationType.setValue(StringHelper.trim((String)partyTaxSchemeType2.getIDValue()));
            object13.addFurtherIdentification(ebi42FurtherIdentificationType);
        }
        ebi42InvoiceType.setBiller((Ebi42BillerType)object13);
        commonsArrayList = invoiceType.getAccountingCustomerParty();
        object13 = new Ebi42InvoiceRecipientType();
        if (commonsArrayList.getParty() != null) {
            for (PartyTaxSchemeType partyTaxSchemeType2 : commonsArrayList.getParty().getPartyTaxScheme()) {
                if (!InvoiceToEbInterface42Converter.isVATSchemeID(partyTaxSchemeType2.getTaxScheme().getIDValue())) continue;
                object13.setVATIdentificationNumber(StringHelper.trim((String)partyTaxSchemeType2.getCompanyIDValue()));
                break;
            }
        }
        if (StringHelper.hasNoText((String)object13.getVATIdentificationNumber())) {
            object13.setVATIdentificationNumber("ATU00000000");
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("AccountingCustomerParty/PartyTaxScheme")).errorText(AbstractToEbInterfaceConverter.EText.INVOICE_RECIPIENT_VAT_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
        }
        if (commonsArrayList.getSupplierAssignedAccountID() != null) {
            object13.setBillersInvoiceRecipientID(StringHelper.trim((String)commonsArrayList.getSupplierAssignedAccountIDValue()));
        }
        for (PartyTaxSchemeType partyTaxSchemeType2 : commonsArrayList.getAdditionalAccountID()) {
            object11 = new Ebi42FurtherIdentificationType();
            object11.setIdentificationType("Consolidator");
            object11.setValue(StringHelper.trim((String)partyTaxSchemeType2.getValue()));
            object13.addFurtherIdentification(object11);
        }
        if (commonsArrayList.getParty() != null) {
            object13.setAddress(InvoiceToEbInterface42Converter.convertParty(commonsArrayList.getParty(), "AccountingCustomerParty", errorList, this.m_aContentLocale, this.m_aDisplayLocale, true));
        }
        if (object13.getAddress() == null) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("AccountingCustomerParty/Party")).errorText(AbstractToEbInterfaceConverter.EText.INVOICE_RECIPIENT_PARTY_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
        }
        ebi42InvoiceType.setInvoiceRecipient((Ebi42InvoiceRecipientType)object13);
        commonsArrayList = invoiceType.getBuyerCustomerParty();
        if (commonsArrayList != null) {
            object13 = new Ebi42OrderingPartyType();
            if (commonsArrayList.getParty() != null) {
                for (PartyTaxSchemeType partyTaxSchemeType2 : commonsArrayList.getParty().getPartyTaxScheme()) {
                    if (!InvoiceToEbInterface42Converter.isVATSchemeID(partyTaxSchemeType2.getTaxScheme().getIDValue())) continue;
                    object13.setVATIdentificationNumber(StringHelper.trim((String)partyTaxSchemeType2.getCompanyIDValue()));
                    break;
                }
            }
            if (StringHelper.hasNoText((String)object13.getVATIdentificationNumber())) {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("BuyerCustomerParty/PartyTaxScheme")).errorText(AbstractToEbInterfaceConverter.EText.ORDERING_PARTY_VAT_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
            }
            if (commonsArrayList.getParty() != null) {
                object13.setAddress(InvoiceToEbInterface42Converter.convertParty(commonsArrayList.getParty(), "BuyerCustomerParty", errorList, this.m_aContentLocale, this.m_aDisplayLocale, true));
            }
            if (object13.getAddress() == null) {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("BuyerCustomerParty/Party")).errorText(AbstractToEbInterfaceConverter.EText.ORDERING_PARTY_PARTY_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
            }
            if (commonsArrayList.getSupplierAssignedAccountID() != null) {
                object13.setBillersOrderingPartyID(StringHelper.trim((String)commonsArrayList.getSupplierAssignedAccountIDValue()));
            }
            if (StringHelper.hasNoText((String)object13.getBillersOrderingPartyID()) && commonsArrayList.getParty() != null && commonsArrayList.getParty().hasPartyIdentificationEntries()) {
                object13.setBillersOrderingPartyID(StringHelper.trim((String)commonsArrayList.getParty().getPartyIdentificationAtIndex(0).getIDValue()));
            }
            if (StringHelper.hasNoText((String)object13.getBillersOrderingPartyID()) && ebi42InvoiceType.getInvoiceRecipient() != null) {
                object13.setBillersOrderingPartyID(ebi42InvoiceType.getInvoiceRecipient().getBillersInvoiceRecipientID());
            }
            if (StringHelper.hasNoText((String)object13.getBillersOrderingPartyID())) {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("BuyerCustomerParty/SupplierAssignedAccountID")).errorText(AbstractToEbInterfaceConverter.EText.ORDERING_PARTY_SUPPLIER_ASSIGNED_ACCOUNT_ID_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
            }
            ebi42InvoiceType.setOrderingParty((Ebi42OrderingPartyType)object13);
        }
        object13 = null;
        object122 = invoiceType.getOrderReference();
        if (object122 != null) {
            object13 = StringHelper.trim((String)object122.getIDValue());
        }
        if (StringHelper.hasNoText((String)object13)) {
            if (this.m_aSettings.isOrderReferenceIDMandatory()) {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("OrderReference/ID")).errorText(AbstractToEbInterfaceConverter.EText.ORDER_REFERENCE_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
            }
        } else {
            if (this.m_aSettings.hasOrderReferenceMaxLength()) {
                int n2 = this.m_aSettings.getOrderReferenceMaxLength();
                if (((String)object13).length() > n2) {
                    errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("OrderReference/ID")).errorText(AbstractToEbInterfaceConverter.EText.ORDER_REFERENCE_TOO_LONG.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{object13, n2}))).build());
                    object13 = ((String)object13).substring(0, n2);
                }
            }
            partyTaxSchemeType2 = new Ebi42OrderReferenceType();
            partyTaxSchemeType2.setOrderID((String)object13);
            ebi42InvoiceType.getInvoiceRecipient().setOrderReference((Ebi42OrderReferenceType)partyTaxSchemeType2);
        }
        object122 = new CommonsHashMap();
        partyTaxSchemeType2 = new Ebi42TaxType();
        object11 = new Ebi42VATType();
        int n3 = 0;
        for (Object object102 : invoiceType.getTaxTotal()) {
            n = 0;
            for (Object object92 : object102.getTaxSubtotal()) {
                taxCategoryType2 = object92.getTaxCategory();
                object8 = StringHelper.trim((String)taxCategoryType2.getIDValue());
                boolean bl = InvoiceToEbInterface42Converter.isTaxExemptionCategoryID((String)object8);
                BigDecimal bigDecimal = object92.getTaxAmountValue();
                iterator = object92.getTaxableAmountValue();
                Object object14 = object72 = bl ? BigDecimal.ZERO : taxCategoryType2.getPercentValue();
                if (object72 == null && bigDecimal != null && iterator != null) {
                    Object object15 = object72 = MathHelper.isEQ0((BigDecimal)((Object)iterator)) ? BigDecimal.ZERO : bigDecimal.multiply(CGlobal.BIGDEC_100).divide((BigDecimal)((Object)iterator), 2, ROUNDING_MODE);
                }
                if (object72 != null) {
                    if (iterator == null && bigDecimal != null) {
                        if (MathHelper.isNE0((BigDecimal)object72)) {
                            iterator = bigDecimal.multiply(CGlobal.BIGDEC_100).divide((BigDecimal)object72, 4, ROUNDING_MODE);
                        }
                    } else if (iterator != null && bigDecimal == null) {
                        BigDecimal bigDecimal2 = bigDecimal = MathHelper.isEQ0((BigDecimal)object72) ? BigDecimal.ZERO : ((BigDecimal)((Object)iterator)).multiply((BigDecimal)object72).divide(CGlobal.BIGDEC_100, 4, ROUNDING_MODE);
                    }
                }
                if ((object6 = taxCategoryType2.getTaxScheme().getID()) == null) {
                    errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("TaxTotal[" + n3 + "]/TaxSubtotal[" + n + "]/TaxCategory/TaxScheme/ID")).errorText(AbstractToEbInterfaceConverter.EText.MISSING_TAXCATEGORY_TAXSCHEME_ID.getDisplayText(this.m_aDisplayLocale))).build());
                    break;
                }
                ebi42UnitType = StringHelper.trim((String)object6.getSchemeID());
                object52 = StringHelper.trim((String)object6.getValue());
                if (StringHelper.hasNoText((String)object52)) {
                    errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("TaxTotal[" + n3 + "]/TaxSubtotal[" + n + "]/TaxCategory/TaxScheme/ID")).errorText(AbstractToEbInterfaceConverter.EText.MISSING_TAXCATEGORY_TAXSCHEME_ID_VALUE.getDisplayText(this.m_aDisplayLocale))).build());
                    break;
                }
                if (taxCategoryType2.getID() == null) {
                    errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("TaxTotal[" + n3 + "]/TaxSubtotal[" + n + "]/TaxCategory")).errorText(AbstractToEbInterfaceConverter.EText.MISSING_TAXCATEGORY_ID.getDisplayText(this.m_aDisplayLocale))).build());
                    break;
                }
                if (StringHelper.hasNoText((String)object8)) {
                    errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("TaxTotal[" + n3 + "]/TaxSubtotal[" + n + "]/TaxCategory")).errorText(AbstractToEbInterfaceConverter.EText.MISSING_TAXCATEGORY_ID_VALUE.getDisplayText(this.m_aDisplayLocale))).build());
                    break;
                }
                object4 = StringHelper.trim((String)taxCategoryType2.getID().getSchemeID());
                object122.put((Object)new TaxCategoryKey(new SchemedID((String)ebi42UnitType, (String)object52), new SchemedID((String)object4, (String)object8)), object72);
                if (InvoiceToEbInterface42Converter.isVATSchemeID((String)object52)) {
                    if (object72 == null) {
                        errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("TaxTotal[" + n3 + "]/TaxSubtotal[" + n + "]/TaxCategory/Percent")).errorText(AbstractToEbInterfaceConverter.EText.TAX_PERCENT_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
                    } else if (iterator == null) {
                        errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("TaxTotal[" + n3 + "]/TaxSubtotal[" + n + "]/TaxableAmount")).errorText(AbstractToEbInterfaceConverter.EText.TAXABLE_AMOUNT_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
                    } else {
                        object3 = new Ebi42VATItemType();
                        object3.setTaxedAmount(((BigDecimal)((Object)iterator)).setScale(2, ROUNDING_MODE));
                        if (bl) {
                            object2 = null;
                            if (taxCategoryType2.hasTaxExemptionReasonEntries()) {
                                object2 = taxCategoryType2.getTaxExemptionReasonAtIndex(0).getValue();
                            }
                            if (object2 == null && taxCategoryType2.getTaxExemptionReasonCode() != null) {
                                object2 = taxCategoryType2.getTaxExemptionReasonCode().getValue();
                            }
                            if (StringHelper.hasNoText((String)object2)) {
                                object2 = "Tax Exemption";
                            }
                            ebi42TaxExemptionType = new Ebi42TaxExemptionType();
                            ebi42TaxExemptionType.setValue((String)object2);
                            object3.setTaxExemption(ebi42TaxExemptionType);
                        } else {
                            object2 = new Ebi42VATRateType();
                            object2.setValue((BigDecimal)object72);
                            object3.setVATRate(object2);
                        }
                        object3.setAmount(bigDecimal.setScale(2, ROUNDING_MODE));
                        object11.addVATItem((Ebi42VATItemType)object3);
                    }
                } else {
                    object3 = new Ebi42OtherTaxType();
                    object3.setComment((String)object52);
                    object3.setAmount(bigDecimal.setScale(2, ROUNDING_MODE));
                    partyTaxSchemeType2.addOtherTax((Ebi42OtherTaxType)object3);
                }
                ++n;
            }
            ++n3;
        }
        partyTaxSchemeType2.setVAT((Ebi42VATType)object11);
        ebi42InvoiceType.setTax((Ebi42TaxType)partyTaxSchemeType2);
        BigDecimal bigDecimal = BigDecimal.ZERO;
        Object object16 = new Ebi42DetailsType();
        object102 = new Ebi42ItemListType();
        n = 0;
        for (Object object92 : invoiceType.getInvoiceLine()) {
            boolean bl;
            taxCategoryType2 = (TaxCategoryType)CollectionHelper.getAtIndex((List)object92.getItem().getClassifiedTaxCategory(), (int)0);
            if (taxCategoryType2 == null) {
                taxCategoryType2 = InvoiceToEbInterface42Converter.findTaxCategory(object92.getTaxTotal());
            }
            object8 = null;
            String string3 = null;
            if (taxCategoryType2 != null) {
                string3 = StringHelper.trim((String)taxCategoryType2.getIDValue());
                if (taxCategoryType2.getPercent() != null) {
                    object8 = taxCategoryType2.getPercentValue();
                }
                if (object8 == null && taxCategoryType2.getID() != null && taxCategoryType2.getTaxScheme() != null && taxCategoryType2.getTaxScheme().getID() != null) {
                    String string4 = StringHelper.trim((String)taxCategoryType2.getTaxScheme().getID().getSchemeID());
                    iterator = StringHelper.trim((String)taxCategoryType2.getTaxScheme().getIDValue());
                    object72 = StringHelper.trim((String)taxCategoryType2.getID().getSchemeID());
                    if (StringHelper.hasText((String)((Object)iterator)) && StringHelper.hasText((String)string3)) {
                        object6 = new TaxCategoryKey(new SchemedID(string4, (String)((Object)iterator)), new SchemedID((String)object72, string3));
                        object8 = (BigDecimal)object122.get(object6);
                    }
                }
            }
            if ((bl = InvoiceToEbInterface42Converter.isTaxExemptionCategoryID(string3)) && object8 == null) {
                object8 = BigDecimal.ZERO;
            }
            if (object8 == null) {
                object8 = BigDecimal.ZERO;
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("InvoiceLine[" + n + "]/Item/ClassifiedTaxCategory")).errorText(AbstractToEbInterfaceConverter.EText.DETAILS_TAX_PERCENTAGE_NOT_FOUND.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{object8}))).build());
            }
            iterator = new Ebi42ListLineItemType();
            object72 = StringHelper.trim((String)object92.getIDValue());
            object6 = StringParser.parseBigInteger((String)object72);
            if (object6 != null && MathHelper.isLT1((BigInteger)object6)) {
                if (this.m_aSettings.isErrorOnPositionNumber()) {
                    errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("InvoiceLine[" + n + "]/ID")).errorText(AbstractToEbInterfaceConverter.EText.DETAILS_INVALID_POSITION.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{object72}))).build());
                } else {
                    object6 = null;
                }
            }
            if (object6 == null) {
                object6 = BigInteger.valueOf((long)n + 1L);
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("InvoiceLine[" + n + "]/ID")).errorText(AbstractToEbInterfaceConverter.EText.DETAILS_INVALID_POSITION_SET_TO_INDEX.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{object72, object6}))).build());
            }
            iterator.setPositionNumber((BigInteger)object6);
            ebi42UnitType = object92.getItem().getDescription().iterator();
            while (ebi42UnitType.hasNext()) {
                object52 = (DescriptionType)ebi42UnitType.next();
                object4 = StringHelper.trim((String)object52.getValue());
                if (!StringHelper.hasText((String)object4)) continue;
                iterator.addDescription((String)object4);
            }
            if (iterator.hasNoDescriptionEntries() && (ebi42UnitType = object92.getItem().getName()) != null && StringHelper.hasText((String)(object52 = StringHelper.trim((String)ebi42UnitType.getValue())))) {
                iterator.addDescription((String)object52);
            }
            for (Object object52 : object92.getNote()) {
                object4 = StringHelper.trim((String)object52.getValue());
                if (!StringHelper.hasText((String)object4)) continue;
                iterator.addDescription((String)object4);
            }
            ebi42UnitType = new Ebi42UnitType();
            if (object92.getInvoicedQuantity() != null) {
                if (object92.getInvoicedQuantity().getUnitCode() != null) {
                    ebi42UnitType.setUnit(StringHelper.trim((String)object92.getInvoicedQuantity().getUnitCode()));
                }
                ebi42UnitType.setValue(object92.getInvoicedQuantityValue());
            }
            if (ebi42UnitType.getUnit() == null) {
                ebi42UnitType.setUnit("C62");
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("InvoiceLine[" + n + "]/InvoicedQuantity/UnitCode")).errorText(AbstractToEbInterfaceConverter.EText.DETAILS_INVALID_UNIT.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{ebi42UnitType.getUnit()}))).build());
            }
            if (ebi42UnitType.getValue() == null) {
                ebi42UnitType.setValue(BigDecimal.ONE);
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("InvoiceLine[" + n + "]/InvoicedQuantity")).errorText(AbstractToEbInterfaceConverter.EText.DETAILS_INVALID_QUANTITY.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{ebi42UnitType.getValue()}))).build());
            }
            iterator.setQuantity(ebi42UnitType);
            if (object92.getPrice() != null) {
                object52 = new Ebi42UnitPriceType();
                object4 = object92.getPrice().getPriceAmountValue();
                object52.setValue((BigDecimal)object4);
                object3 = object92.getPrice().getBaseQuantityValue();
                if (object3 != null) {
                    object52.setBaseQuantity((BigDecimal)object3);
                    if (MathHelper.isEQ0((BigDecimal)object3)) {
                        object52.setValue(BigDecimal.ZERO);
                    }
                }
                iterator.setUnitPrice((Ebi42UnitPriceType)object52);
            } else {
                object52 = object92.getLineExtensionAmountValue();
                object4 = new Ebi42UnitPriceType();
                if (MathHelper.isEQ0((BigDecimal)ebi42UnitType.getValue())) {
                    object4.setValue(BigDecimal.ZERO);
                } else {
                    object4.setValue(((BigDecimal)object52).divide(ebi42UnitType.getValue(), 4, ROUNDING_MODE));
                }
                iterator.setUnitPrice((Ebi42UnitPriceType)object4);
            }
            object52 = iterator.getUnitPrice().getValue();
            object4 = iterator.getUnitPrice().getBaseQuantity();
            if (object4 != null && MathHelper.isNE0((BigDecimal)object4)) {
                object52 = ((BigDecimal)object52).divide((BigDecimal)object4, 4, ROUNDING_MODE);
            }
            if (bl) {
                object3 = null;
                if (taxCategoryType2.hasTaxExemptionReasonEntries()) {
                    object3 = taxCategoryType2.getTaxExemptionReasonAtIndex(0).getValue();
                }
                if (object3 == null && taxCategoryType2.getTaxExemptionReasonCode() != null) {
                    object3 = taxCategoryType2.getTaxExemptionReasonCode().getValue();
                }
                if (StringHelper.hasNoText((String)object3)) {
                    object3 = "Tax Exemption";
                }
                object2 = new Ebi42TaxExemptionType();
                object2.setValue((String)object3);
                iterator.setTaxExemption((Ebi42TaxExemptionType)object2);
            } else {
                object3 = new Ebi42VATRateType();
                object3.setValue((BigDecimal)object8);
                if (taxCategoryType2 != null) {
                    // empty if block
                }
                iterator.setVATRate((Ebi42VATRateType)object3);
            }
            iterator.setLineItemAmount(object92.getLineExtensionAmountValue().setScale(2, ROUNDING_MODE));
            if (MathHelper.isEQ0((BigDecimal)object8)) {
                bigDecimal = bigDecimal.add(iterator.getLineItemAmount());
            }
            object3 = object92.getOrderLineReference().iterator();
            while (object3.hasNext()) {
                object2 = (OrderLineReferenceType)object3.next();
                if (!StringHelper.hasText((String)object2.getLineIDValue())) continue;
                ebi42TaxExemptionType = new Ebi42OrderReferenceDetailType();
                Object object17 = null;
                if (object2.getOrderReference() != null) {
                    object17 = StringHelper.trim((String)object2.getOrderReference().getIDValue());
                }
                if (StringHelper.hasNoText(object17)) {
                    object17 = object13;
                }
                ebi42TaxExemptionType.setOrderID((String)object17);
                Object object18 = StringHelper.trim((String)object2.getLineIDValue());
                if (object18 != null) {
                    if (((String)object18).length() == 0) {
                        errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("InvoiceLine[" + n + "]/OrderLineReference/LineID")).errorText(AbstractToEbInterfaceConverter.EText.ORDERLINE_REF_ID_EMPTY.getDisplayText(this.m_aDisplayLocale))).build());
                    } else {
                        ebi42TaxExemptionType.setOrderPositionNumber((String)object18);
                    }
                }
                if (StringHelper.hasText((String)ebi42TaxExemptionType.getOrderPositionNumber()) && StringHelper.hasNoText((String)object17)) {
                    if (this.m_aSettings.isOrderReferenceIDMandatory()) {
                        errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("InvoiceLine[" + n + "]/OrderLineReference/OrderReference/ID")).errorText(AbstractToEbInterfaceConverter.EText.ORDER_REFERENCE_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
                    } else {
                        ebi42TaxExemptionType.setOrderPositionNumber(null);
                        errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("InvoiceLine[" + n + "]/OrderLineReference/OrderReference/ID")).errorText(AbstractToEbInterfaceConverter.EText.ORDER_REFERENCE_MISSING_IGNORE_ORDER_POS.getDisplayText(this.m_aDisplayLocale))).build());
                    }
                }
                if (!StringHelper.hasText((String)object17)) break;
                iterator.setInvoiceRecipientsOrderReference((Ebi42OrderReferenceDetailType)ebi42TaxExemptionType);
                break;
            }
            if (object92.hasAllowanceChargeEntries()) {
                object3 = iterator.getQuantity().getValue().multiply((BigDecimal)object52);
                object2 = new Ebi42ReductionAndSurchargeListLineItemDetailsType();
                ebi42TaxExemptionType = ETriState.UNDEFINED;
                for (Object object18 : object92.getAllowanceCharge()) {
                    boolean bl2 = object18.getChargeIndicator().isValue();
                    if (ebi42TaxExemptionType.isUndefined()) {
                        ebi42TaxExemptionType = ETriState.valueOf((boolean)bl2);
                    }
                    boolean bl3 = bl2 != ebi42TaxExemptionType.isTrue();
                    Ebi42ReductionAndSurchargeBaseType ebi42ReductionAndSurchargeBaseType = new Ebi42ReductionAndSurchargeBaseType();
                    BigDecimal bigDecimal3 = object18.getAmountValue();
                    ebi42ReductionAndSurchargeBaseType.setAmount(bl3 ? bigDecimal3.negate() : bigDecimal3);
                    if (object18.getBaseAmount() != null) {
                        ebi42ReductionAndSurchargeBaseType.setBaseAmount(object18.getBaseAmountValue());
                    }
                    if (ebi42ReductionAndSurchargeBaseType.getBaseAmount() == null) {
                        ebi42ReductionAndSurchargeBaseType.setBaseAmount((BigDecimal)object3);
                    }
                    if (object18.getMultiplierFactorNumeric() != null) {
                        BigDecimal bigDecimal4 = object18.getMultiplierFactorNumericValue().multiply(CGlobal.BIGDEC_100);
                        ebi42ReductionAndSurchargeBaseType.setPercentage(bigDecimal4);
                    }
                    if (ebi42TaxExemptionType.isTrue()) {
                        object2.addReductionListLineItemOrSurchargeListLineItemOrOtherVATableTaxListLineItem(new ObjectFactory().createSurchargeListLineItem(ebi42ReductionAndSurchargeBaseType));
                        object3 = ((BigDecimal)object3).add(ebi42ReductionAndSurchargeBaseType.getAmount());
                    } else {
                        object2.addReductionListLineItemOrSurchargeListLineItemOrOtherVATableTaxListLineItem(new ObjectFactory().createReductionListLineItem(ebi42ReductionAndSurchargeBaseType));
                        object3 = ((BigDecimal)object3).subtract(ebi42ReductionAndSurchargeBaseType.getAmount());
                    }
                    ebi42ReductionAndSurchargeBaseType.setComment(InvoiceToEbInterface42Converter.getAllowanceChargeComment((AllowanceChargeType)object18));
                }
                iterator.setReductionAndSurchargeListLineItemDetails((Ebi42ReductionAndSurchargeListLineItemDetailsType)object2);
            }
            if (object92.hasDeliveryEntries() && (object3 = object92.getDeliveryAtIndex(0)).getActualDeliveryDate() != null) {
                object2 = InvoiceToEbInterface42Converter.convertDelivery((DeliveryType)object3, "InvoiceLine[" + n + "]/Delivery[0]", invoiceType.getAccountingCustomerParty(), errorList, this.m_aContentLocale, this.m_aDisplayLocale);
                iterator.setDelivery((Ebi42DeliveryType)object2);
            }
            if (this.m_aCustomizer != null) {
                this.m_aCustomizer.additionalItemMapping((InvoiceLineType)object92, iterator);
            }
            object102.addListLineItem(iterator);
            ++n;
        }
        object16.addItemList((Ebi42ItemListType)object102);
        ebi42InvoiceType.setDetails((Ebi42DetailsType)object16);
        if (object11.hasNoVATItemEntries()) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("Invoice")).errorText(AbstractToEbInterfaceConverter.EText.VAT_ITEM_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
        }
        if (invoiceType.hasAllowanceChargeEntries()) {
            object16 = invoiceType.getLegalMonetaryTotal().getLineExtensionAmountValue();
            if (object16 == null) {
                object102 = BigDecimal.ZERO;
                for (Object object19 : ebi42InvoiceType.getDetails().getItemList()) {
                    for (TaxCategoryType taxCategoryType2 : object19.getListLineItem()) {
                        object102 = ((BigDecimal)object102).add(taxCategoryType2.getLineItemAmount());
                    }
                }
                object16 = object102;
            }
            object102 = new Ebi42ReductionAndSurchargeDetailsType();
            n = 0;
            for (Object object92 : invoiceType.getAllowanceCharge()) {
                BigDecimal bigDecimal5;
                boolean bl = object92.getChargeIndicator().isValue();
                object8 = new Ebi42ReductionAndSurchargeType();
                BigDecimal bigDecimal6 = object92.getAmountValue();
                object8.setAmount(bigDecimal6);
                if (object92.getBaseAmount() != null) {
                    object8.setBaseAmount(object92.getBaseAmountValue());
                }
                if (object8.getBaseAmount() == null) {
                    object8.setBaseAmount((BigDecimal)object16);
                }
                if (object92.getMultiplierFactorNumeric() != null) {
                    bigDecimal5 = object92.getMultiplierFactorNumericValue().multiply(CGlobal.BIGDEC_100);
                    object8.setPercentage(bigDecimal5);
                }
                object8.setComment(InvoiceToEbInterface42Converter.getAllowanceChargeComment((AllowanceChargeType)object92));
                bigDecimal5 = null;
                for (Object object72 : object92.getTaxCategory()) {
                    if (object72.getPercent() == null) continue;
                    bigDecimal5 = new Ebi42VATRateType();
                    bigDecimal5.setValue(object72.getPercentValue());
                    break;
                }
                if (bigDecimal5 == null) {
                    errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("Invoice/AllowanceCharge[" + n + "]")).errorText(AbstractToEbInterfaceConverter.EText.ALLOWANCE_CHARGE_NO_TAXRATE.getDisplayText(this.m_aDisplayLocale))).build());
                }
                object8.setVATRate((Ebi42VATRateType)bigDecimal5);
                if (bl) {
                    object102.addReductionOrSurchargeOrOtherVATableTax(new ObjectFactory().createSurcharge((Ebi42ReductionAndSurchargeType)object8));
                    object16 = ((BigDecimal)object16).add(object8.getAmount());
                } else {
                    object102.addReductionOrSurchargeOrOtherVATableTax(new ObjectFactory().createReduction((Ebi42ReductionAndSurchargeType)object8));
                    object16 = ((BigDecimal)object16).subtract(object8.getAmount());
                }
                ebi42InvoiceType.setReductionAndSurchargeDetails((Ebi42ReductionAndSurchargeDetailsType)object102);
                ++n;
            }
        }
        if ((object16 = invoiceType.getLegalMonetaryTotal()).getPrepaidAmount() != null && !MathHelper.isEQ0((BigDecimal)object16.getPrepaidAmountValue())) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("Invoice/LegalMonetaryTotal/PrepaidAmount")).errorText(AbstractToEbInterfaceConverter.EText.PREPAID_NOT_SUPPORTED.getDisplayText(this.m_aDisplayLocale))).build());
        }
        if (object16.getTaxInclusiveAmountValue() != null) {
            ebi42InvoiceType.setTotalGrossAmount(object16.getTaxInclusiveAmountValue().setScale(2, ROUNDING_MODE));
        } else {
            ebi42InvoiceType.setTotalGrossAmount(object16.getPayableAmountValue().setScale(2, ROUNDING_MODE));
        }
        ebi42InvoiceType.setPayableAmount(object16.getPayableAmountValue().setScale(2, ROUNDING_MODE));
        this.convertPayment(() -> ((InvoiceType)invoiceType).getDueDateValue(), () -> ((InvoiceType)invoiceType).getPaymentMeans(), () -> ((InvoiceType)invoiceType).getPayeeParty(), () -> ((InvoiceType)invoiceType).getAccountingSupplierParty(), () -> ((InvoiceType)invoiceType).getPaymentTerms(), () -> ((InvoiceType)invoiceType).getLegalMonetaryTotal(), errorList, ebi42InvoiceType, false);
        object102 = null;
        n = 0;
        object19 = invoiceType.getDelivery().iterator();
        while (object19.hasNext()) {
            object92 = (DeliveryType)object19.next();
            if (object92.getActualDeliveryDate() != null) {
                object102 = InvoiceToEbInterface42Converter.convertDelivery((DeliveryType)object92, "Delivery[" + n + "]", invoiceType.getAccountingCustomerParty(), errorList, this.m_aContentLocale, this.m_aDisplayLocale);
                break;
            }
            ++n;
        }
        if (object102 == null) {
            object102 = new Ebi42DeliveryType();
        }
        if ((object19 = (PeriodType)CollectionHelper.getAtIndex((List)invoiceType.getInvoicePeriod(), (int)0)) != null) {
            object92 = object19.getStartDateValue();
            XMLOffsetDate xMLOffsetDate = object19.getEndDateValue();
            if (object92 != null) {
                if (xMLOffsetDate == null) {
                    if (object102.getDate() == null) {
                        object102.setDate((XMLOffsetDate)object92);
                    }
                } else {
                    object8 = new Ebi42PeriodType();
                    object8.setFromDate((XMLOffsetDate)object92);
                    object8.setToDate(xMLOffsetDate);
                    object102.setPeriod((Ebi42PeriodType)object8);
                    object102.setDate((XMLOffsetDate)null);
                }
            }
        }
        if (this.m_aSettings.isDeliveryDateMandatory() && object102.getDate() == null && object102.getPeriod() == null) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("Invoice")).errorText(AbstractToEbInterfaceConverter.EText.ERB_NO_DELIVERY_DATE.getDisplayText(this.m_aDisplayLocale))).build());
        }
        if (object102.getDate() != null || object102.getPeriod() != null) {
            ebi42InvoiceType.setDelivery((Ebi42DeliveryType)object102);
        }
        if (this.m_aCustomizer != null) {
            this.m_aCustomizer.additionalGlobalMapping(invoiceType, ebi42InvoiceType);
        }
        return ebi42InvoiceType;
    }
}

