/*
 * Decompiled with CFR 0.152.
 */
package at.austriapro.ebinterface.ubl.from.invoice;

import at.austriapro.ebinterface.ubl.from.AbstractToEbInterface43Converter;
import at.austriapro.ebinterface.ubl.from.AbstractToEbInterfaceConverter;
import at.austriapro.ebinterface.ubl.from.IToEbinterfaceSettings;
import at.austriapro.ebinterface.ubl.from.helper.SchemedID;
import at.austriapro.ebinterface.ubl.from.helper.TaxCategoryKey;
import at.austriapro.ebinterface.ubl.from.invoice.ICustomInvoiceToEbInterface43Converter;
import com.helger.commons.CGlobal;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.datetime.XMLOffsetDate;
import com.helger.commons.error.SingleError;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.math.MathHelper;
import com.helger.commons.state.ETriState;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.StringParser;
import com.helger.ebinterface.v43.Ebi43BillerType;
import com.helger.ebinterface.v43.Ebi43DeliveryType;
import com.helger.ebinterface.v43.Ebi43DetailsType;
import com.helger.ebinterface.v43.Ebi43DocumentTypeType;
import com.helger.ebinterface.v43.Ebi43FurtherIdentificationType;
import com.helger.ebinterface.v43.Ebi43InvoiceRecipientType;
import com.helger.ebinterface.v43.Ebi43InvoiceType;
import com.helger.ebinterface.v43.Ebi43ItemListType;
import com.helger.ebinterface.v43.Ebi43ListLineItemType;
import com.helger.ebinterface.v43.Ebi43OrderReferenceDetailType;
import com.helger.ebinterface.v43.Ebi43OrderReferenceType;
import com.helger.ebinterface.v43.Ebi43OrderingPartyType;
import com.helger.ebinterface.v43.Ebi43OtherTaxType;
import com.helger.ebinterface.v43.Ebi43PeriodType;
import com.helger.ebinterface.v43.Ebi43ReductionAndSurchargeBaseType;
import com.helger.ebinterface.v43.Ebi43ReductionAndSurchargeDetailsType;
import com.helger.ebinterface.v43.Ebi43ReductionAndSurchargeListLineItemDetailsType;
import com.helger.ebinterface.v43.Ebi43ReductionAndSurchargeType;
import com.helger.ebinterface.v43.Ebi43TaxExemptionType;
import com.helger.ebinterface.v43.Ebi43TaxType;
import com.helger.ebinterface.v43.Ebi43UnitPriceType;
import com.helger.ebinterface.v43.Ebi43UnitType;
import com.helger.ebinterface.v43.Ebi43VATItemType;
import com.helger.ebinterface.v43.Ebi43VATRateType;
import com.helger.ebinterface.v43.Ebi43VATType;
import com.helger.ebinterface.v43.ObjectFactory;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.AllowanceChargeType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.DeliveryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.InvoiceLineType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.OrderLineReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyTaxSchemeType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PeriodType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.TaxCategoryType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.DescriptionType;
import oasis.names.specification.ubl.schema.xsd.invoice_21.InvoiceType;

@Immutable
public final class InvoiceToEbInterface43Converter
extends AbstractToEbInterface43Converter {
    private ICustomInvoiceToEbInterface43Converter m_aCustomizer;

    public InvoiceToEbInterface43Converter(@Nonnull Locale locale, @Nonnull Locale locale2, @Nonnull IToEbinterfaceSettings iToEbinterfaceSettings) {
        super(locale, locale2, iToEbinterfaceSettings);
    }

    @Nonnull
    public InvoiceToEbInterface43Converter setCustomizer(@Nullable ICustomInvoiceToEbInterface43Converter iCustomInvoiceToEbInterface43Converter) {
        this.m_aCustomizer = iCustomInvoiceToEbInterface43Converter;
        return this;
    }

    @Nullable
    public Ebi43InvoiceType convertToEbInterface(@Nonnull InvoiceType invoiceType, @Nonnull ErrorList errorList) {
        Object object19;
        Ebi43TaxExemptionType ebi43TaxExemptionType;
        Object object2;
        Object object3;
        Object object4;
        Object object52;
        Ebi43UnitType ebi43UnitType;
        Object object6;
        Object object72;
        Iterator iterator;
        Object object8;
        TaxCategoryType taxCategoryType2;
        Object object92;
        int n;
        Object object102;
        Object object11;
        PartyTaxSchemeType partyTaxSchemeType2;
        Object object122;
        ValueEnforcer.notNull((Object)invoiceType, (String)"UBLInvoice");
        ValueEnforcer.notNull((Object)errorList, (String)"TransformationErrorList");
        ValueEnforcer.isTrue((boolean)errorList.isEmpty(), (String)"TransformationErrorList must be empty!");
        this.checkInvoiceConsistency(invoiceType, errorList);
        if (errorList.containsAtLeastOneError()) {
            return null;
        }
        Ebi43InvoiceType ebi43InvoiceType = new Ebi43InvoiceType();
        ebi43InvoiceType.setGeneratingSystem("UBL 2.1 to ebInterface 4.3 converter");
        ebi43InvoiceType.setDocumentType(InvoiceToEbInterface43Converter.getAsDocumentTypeType(invoiceType.getInvoiceTypeCode() == null ? null : invoiceType.getInvoiceTypeCode().getName(), invoiceType.getInvoiceTypeCodeValue(), Ebi43DocumentTypeType.INVOICE.value()));
        String string = StringHelper.trim((String)invoiceType.getDocumentCurrencyCodeValue());
        ebi43InvoiceType.setInvoiceCurrency(string);
        String string2 = StringHelper.trim((String)invoiceType.getIDValue());
        if (StringHelper.hasNoText((String)string2)) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("ID")).errorText(AbstractToEbInterfaceConverter.EText.MISSING_INVOICE_NUMBER.getDisplayText(this.m_aDisplayLocale))).build());
        }
        ebi43InvoiceType.setInvoiceNumber(string2);
        ebi43InvoiceType.setInvoiceDate(invoiceType.getIssueDateValue());
        if (ebi43InvoiceType.getInvoiceDate() == null) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("IssueDate")).errorText(AbstractToEbInterfaceConverter.EText.MISSING_INVOICE_DATE.getDisplayText(this.m_aDisplayLocale))).build());
        }
        if (invoiceType.getCopyIndicator() != null) {
            ebi43InvoiceType.setIsDuplicate(Boolean.valueOf(invoiceType.getCopyIndicator().isValue()));
        }
        InvoiceToEbInterface43Converter.convertRelatedDocuments(invoiceType.getBillingReference(), ebi43InvoiceType);
        InvoiceToEbInterface43Converter.convertReferencedDocuments(invoiceType.getDespatchDocumentReference(), ebi43InvoiceType);
        InvoiceToEbInterface43Converter.convertReferencedDocuments(invoiceType.getReceiptDocumentReference(), ebi43InvoiceType);
        InvoiceToEbInterface43Converter.convertReferencedDocuments(invoiceType.getContractDocumentReference(), ebi43InvoiceType);
        InvoiceToEbInterface43Converter.convertReferencedDocuments(invoiceType.getAdditionalDocumentReference(), ebi43InvoiceType);
        InvoiceToEbInterface43Converter.convertReferencedDocuments(invoiceType.getStatementDocumentReference(), ebi43InvoiceType);
        InvoiceToEbInterface43Converter.convertReferencedDocuments(invoiceType.getOriginatorDocumentReference(), ebi43InvoiceType);
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        for (Object object122 : invoiceType.getNote()) {
            if (!StringHelper.hasText((String)object122.getValue())) continue;
            commonsArrayList.add((Object)object122.getValue());
        }
        if (!commonsArrayList.isEmpty()) {
            ebi43InvoiceType.setComment(StringHelper.getImplodedNonEmpty((char)'\n', (Iterable)commonsArrayList));
        }
        commonsArrayList = invoiceType.getAccountingSupplierParty();
        Object object13 = new Ebi43BillerType();
        if (commonsArrayList.getParty() != null) {
            for (PartyTaxSchemeType partyTaxSchemeType2 : commonsArrayList.getParty().getPartyTaxScheme()) {
                if (!InvoiceToEbInterface43Converter.isVATSchemeID(partyTaxSchemeType2.getTaxScheme().getIDValue())) continue;
                object13.setVATIdentificationNumber(StringHelper.trim((String)partyTaxSchemeType2.getCompanyIDValue()));
                break;
            }
        }
        if (StringHelper.hasNoText((String)object13.getVATIdentificationNumber())) {
            object13.setVATIdentificationNumber("ATU00000000");
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("AccountingSupplierParty/Party/PartyTaxScheme")).errorText(AbstractToEbInterfaceConverter.EText.BILLER_VAT_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
        }
        if (commonsArrayList.getCustomerAssignedAccountID() != null) {
            object13.setInvoiceRecipientsBillerID(StringHelper.trim((String)commonsArrayList.getCustomerAssignedAccountIDValue()));
        }
        if (StringHelper.hasNoText((String)object13.getInvoiceRecipientsBillerID()) && commonsArrayList.getParty() != null && commonsArrayList.getParty().hasPartyIdentificationEntries()) {
            object13.setInvoiceRecipientsBillerID(StringHelper.trim((String)commonsArrayList.getParty().getPartyIdentificationAtIndex(0).getIDValue()));
        }
        for (PartyTaxSchemeType partyTaxSchemeType2 : commonsArrayList.getAdditionalAccountID()) {
            object11 = new Ebi43FurtherIdentificationType();
            object11.setIdentificationType("Consolidator");
            object11.setValue(StringHelper.trim((String)partyTaxSchemeType2.getValue()));
            object13.addFurtherIdentification(object11);
        }
        if (commonsArrayList.getParty() != null) {
            object13.setAddress(InvoiceToEbInterface43Converter.convertParty(commonsArrayList.getParty(), "AccountingSupplierParty", errorList, this.m_aContentLocale, this.m_aDisplayLocale, true));
            if (StringHelper.hasNoText((String)object13.getAddress().getEmail()) && this.m_aSettings.isEnforceSupplierEmailAddress()) {
                object13.getAddress().setEmail(this.m_aSettings.getEnforcedSupplierEmailAddress());
            }
        }
        for (PartyTaxSchemeType partyTaxSchemeType2 : invoiceType.getContractDocumentReference()) {
            if (!StringHelper.hasTextAfterTrim((String)partyTaxSchemeType2.getIDValue())) continue;
            object11 = StringHelper.hasText((String)partyTaxSchemeType2.getID().getSchemeID()) ? partyTaxSchemeType2.getID().getSchemeID() : "Contract";
            Ebi43FurtherIdentificationType ebi43FurtherIdentificationType = new Ebi43FurtherIdentificationType();
            ebi43FurtherIdentificationType.setIdentificationType((String)object11);
            ebi43FurtherIdentificationType.setValue(StringHelper.trim((String)partyTaxSchemeType2.getIDValue()));
            object13.addFurtherIdentification(ebi43FurtherIdentificationType);
        }
        ebi43InvoiceType.setBiller((Ebi43BillerType)object13);
        commonsArrayList = invoiceType.getAccountingCustomerParty();
        object13 = new Ebi43InvoiceRecipientType();
        if (commonsArrayList.getParty() != null) {
            for (PartyTaxSchemeType partyTaxSchemeType2 : commonsArrayList.getParty().getPartyTaxScheme()) {
                if (!InvoiceToEbInterface43Converter.isVATSchemeID(partyTaxSchemeType2.getTaxScheme().getIDValue())) continue;
                object13.setVATIdentificationNumber(StringHelper.trim((String)partyTaxSchemeType2.getCompanyIDValue()));
                break;
            }
        }
        if (StringHelper.hasNoText((String)object13.getVATIdentificationNumber())) {
            object13.setVATIdentificationNumber("ATU00000000");
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("AccountingCustomerParty/PartyTaxScheme")).errorText(AbstractToEbInterfaceConverter.EText.INVOICE_RECIPIENT_VAT_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
        }
        if (commonsArrayList.getSupplierAssignedAccountID() != null) {
            object13.setBillersInvoiceRecipientID(StringHelper.trim((String)commonsArrayList.getSupplierAssignedAccountIDValue()));
        }
        for (PartyTaxSchemeType partyTaxSchemeType2 : commonsArrayList.getAdditionalAccountID()) {
            object11 = new Ebi43FurtherIdentificationType();
            object11.setIdentificationType("Consolidator");
            object11.setValue(StringHelper.trim((String)partyTaxSchemeType2.getValue()));
            object13.addFurtherIdentification(object11);
        }
        if (commonsArrayList.getParty() != null) {
            object13.setAddress(InvoiceToEbInterface43Converter.convertParty(commonsArrayList.getParty(), "AccountingCustomerParty", errorList, this.m_aContentLocale, this.m_aDisplayLocale, true));
        }
        if (object13.getAddress() == null) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("AccountingCustomerParty/Party")).errorText(AbstractToEbInterfaceConverter.EText.INVOICE_RECIPIENT_PARTY_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
        }
        ebi43InvoiceType.setInvoiceRecipient((Ebi43InvoiceRecipientType)object13);
        commonsArrayList = invoiceType.getBuyerCustomerParty();
        if (commonsArrayList != null) {
            object13 = new Ebi43OrderingPartyType();
            if (commonsArrayList.getParty() != null) {
                for (PartyTaxSchemeType partyTaxSchemeType2 : commonsArrayList.getParty().getPartyTaxScheme()) {
                    if (!InvoiceToEbInterface43Converter.isVATSchemeID(partyTaxSchemeType2.getTaxScheme().getIDValue())) continue;
                    object13.setVATIdentificationNumber(StringHelper.trim((String)partyTaxSchemeType2.getCompanyIDValue()));
                    break;
                }
            }
            if (StringHelper.hasNoText((String)object13.getVATIdentificationNumber())) {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("BuyerCustomerParty/PartyTaxScheme")).errorText(AbstractToEbInterfaceConverter.EText.ORDERING_PARTY_VAT_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
            }
            if (commonsArrayList.getParty() != null) {
                object13.setAddress(InvoiceToEbInterface43Converter.convertParty(commonsArrayList.getParty(), "BuyerCustomerParty", errorList, this.m_aContentLocale, this.m_aDisplayLocale, true));
            }
            if (object13.getAddress() == null) {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("BuyerCustomerParty/Party")).errorText(AbstractToEbInterfaceConverter.EText.ORDERING_PARTY_PARTY_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
            }
            if (commonsArrayList.getSupplierAssignedAccountID() != null) {
                object13.setBillersOrderingPartyID(StringHelper.trim((String)commonsArrayList.getSupplierAssignedAccountIDValue()));
            }
            if (StringHelper.hasNoText((String)object13.getBillersOrderingPartyID()) && commonsArrayList.getParty() != null && commonsArrayList.getParty().hasPartyIdentificationEntries()) {
                object13.setBillersOrderingPartyID(StringHelper.trim((String)commonsArrayList.getParty().getPartyIdentificationAtIndex(0).getIDValue()));
            }
            if (StringHelper.hasNoText((String)object13.getBillersOrderingPartyID()) && ebi43InvoiceType.getInvoiceRecipient() != null) {
                object13.setBillersOrderingPartyID(ebi43InvoiceType.getInvoiceRecipient().getBillersInvoiceRecipientID());
            }
            if (StringHelper.hasNoText((String)object13.getBillersOrderingPartyID())) {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("BuyerCustomerParty/SupplierAssignedAccountID")).errorText(AbstractToEbInterfaceConverter.EText.ORDERING_PARTY_SUPPLIER_ASSIGNED_ACCOUNT_ID_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
            }
            ebi43InvoiceType.setOrderingParty((Ebi43OrderingPartyType)object13);
        }
        object13 = null;
        object122 = invoiceType.getOrderReference();
        if (object122 != null) {
            object13 = StringHelper.trim((String)object122.getIDValue());
        }
        if (StringHelper.hasNoText((String)object13)) {
            if (this.m_aSettings.isOrderReferenceIDMandatory()) {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("OrderReference/ID")).errorText(AbstractToEbInterfaceConverter.EText.ORDER_REFERENCE_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
            }
        } else {
            if (this.m_aSettings.hasOrderReferenceMaxLength()) {
                int n2 = this.m_aSettings.getOrderReferenceMaxLength();
                if (((String)object13).length() > n2) {
                    errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("OrderReference/ID")).errorText(AbstractToEbInterfaceConverter.EText.ORDER_REFERENCE_TOO_LONG.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{object13, n2}))).build());
                    object13 = ((String)object13).substring(0, n2);
                }
            }
            partyTaxSchemeType2 = new Ebi43OrderReferenceType();
            partyTaxSchemeType2.setOrderID((String)object13);
            ebi43InvoiceType.getInvoiceRecipient().setOrderReference((Ebi43OrderReferenceType)partyTaxSchemeType2);
        }
        object122 = new CommonsHashMap();
        partyTaxSchemeType2 = new Ebi43TaxType();
        object11 = new Ebi43VATType();
        int n3 = 0;
        for (Object object102 : invoiceType.getTaxTotal()) {
            n = 0;
            for (Object object92 : object102.getTaxSubtotal()) {
                taxCategoryType2 = object92.getTaxCategory();
                object8 = StringHelper.trim((String)taxCategoryType2.getIDValue());
                boolean bl = InvoiceToEbInterface43Converter.isTaxExemptionCategoryID((String)object8);
                BigDecimal bigDecimal = object92.getTaxAmountValue();
                iterator = object92.getTaxableAmountValue();
                Object object14 = object72 = bl ? BigDecimal.ZERO : taxCategoryType2.getPercentValue();
                if (object72 == null && bigDecimal != null && iterator != null) {
                    Object object15 = object72 = MathHelper.isEQ0((BigDecimal)((Object)iterator)) ? BigDecimal.ZERO : bigDecimal.multiply(CGlobal.BIGDEC_100).divide((BigDecimal)((Object)iterator), 2, ROUNDING_MODE);
                }
                if (object72 != null) {
                    if (iterator == null && bigDecimal != null) {
                        if (MathHelper.isNE0((BigDecimal)object72)) {
                            iterator = bigDecimal.multiply(CGlobal.BIGDEC_100).divide((BigDecimal)object72, 4, ROUNDING_MODE);
                        }
                    } else if (iterator != null && bigDecimal == null) {
                        BigDecimal bigDecimal2 = bigDecimal = MathHelper.isEQ0((BigDecimal)object72) ? BigDecimal.ZERO : ((BigDecimal)((Object)iterator)).multiply((BigDecimal)object72).divide(CGlobal.BIGDEC_100, 4, ROUNDING_MODE);
                    }
                }
                if ((object6 = taxCategoryType2.getTaxScheme().getID()) == null) {
                    errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("TaxTotal[" + n3 + "]/TaxSubtotal[" + n + "]/TaxCategory/TaxScheme/ID")).errorText(AbstractToEbInterfaceConverter.EText.MISSING_TAXCATEGORY_TAXSCHEME_ID.getDisplayText(this.m_aDisplayLocale))).build());
                    break;
                }
                ebi43UnitType = StringHelper.trim((String)object6.getSchemeID());
                object52 = StringHelper.trim((String)object6.getValue());
                if (StringHelper.hasNoText((String)object52)) {
                    errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("TaxTotal[" + n3 + "]/TaxSubtotal[" + n + "]/TaxCategory/TaxScheme/ID")).errorText(AbstractToEbInterfaceConverter.EText.MISSING_TAXCATEGORY_TAXSCHEME_ID_VALUE.getDisplayText(this.m_aDisplayLocale))).build());
                    break;
                }
                if (taxCategoryType2.getID() == null) {
                    errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("TaxTotal[" + n3 + "]/TaxSubtotal[" + n + "]/TaxCategory")).errorText(AbstractToEbInterfaceConverter.EText.MISSING_TAXCATEGORY_ID.getDisplayText(this.m_aDisplayLocale))).build());
                    break;
                }
                if (StringHelper.hasNoText((String)object8)) {
                    errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("TaxTotal[" + n3 + "]/TaxSubtotal[" + n + "]/TaxCategory")).errorText(AbstractToEbInterfaceConverter.EText.MISSING_TAXCATEGORY_ID_VALUE.getDisplayText(this.m_aDisplayLocale))).build());
                    break;
                }
                object4 = StringHelper.trim((String)taxCategoryType2.getID().getSchemeID());
                object122.put((Object)new TaxCategoryKey(new SchemedID((String)ebi43UnitType, (String)object52), new SchemedID((String)object4, (String)object8)), object72);
                if (InvoiceToEbInterface43Converter.isVATSchemeID((String)object52)) {
                    if (object72 == null) {
                        errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("TaxTotal[" + n3 + "]/TaxSubtotal[" + n + "]/TaxCategory/Percent")).errorText(AbstractToEbInterfaceConverter.EText.TAX_PERCENT_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
                    } else if (iterator == null) {
                        errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("TaxTotal[" + n3 + "]/TaxSubtotal[" + n + "]/TaxableAmount")).errorText(AbstractToEbInterfaceConverter.EText.TAXABLE_AMOUNT_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
                    } else {
                        object3 = new Ebi43VATItemType();
                        object3.setTaxedAmount(((BigDecimal)((Object)iterator)).setScale(2, ROUNDING_MODE));
                        if (bl) {
                            object2 = null;
                            if (taxCategoryType2.hasTaxExemptionReasonEntries()) {
                                object2 = taxCategoryType2.getTaxExemptionReasonAtIndex(0).getValue();
                            }
                            if (object2 == null && taxCategoryType2.getTaxExemptionReasonCode() != null) {
                                object2 = taxCategoryType2.getTaxExemptionReasonCode().getValue();
                            }
                            if (StringHelper.hasNoText((String)object2)) {
                                object2 = "Tax Exemption";
                            }
                            ebi43TaxExemptionType = new Ebi43TaxExemptionType();
                            ebi43TaxExemptionType.setValue((String)object2);
                            object3.setTaxExemption(ebi43TaxExemptionType);
                        } else {
                            object2 = new Ebi43VATRateType();
                            object2.setValue((BigDecimal)object72);
                            object3.setVATRate(object2);
                        }
                        object3.setAmount(bigDecimal.setScale(2, ROUNDING_MODE));
                        object11.addVATItem((Ebi43VATItemType)object3);
                    }
                } else {
                    object3 = new Ebi43OtherTaxType();
                    object3.setComment((String)object52);
                    object3.setAmount(bigDecimal.setScale(2, ROUNDING_MODE));
                    partyTaxSchemeType2.addOtherTax((Ebi43OtherTaxType)object3);
                }
                ++n;
            }
            ++n3;
        }
        partyTaxSchemeType2.setVAT((Ebi43VATType)object11);
        ebi43InvoiceType.setTax((Ebi43TaxType)partyTaxSchemeType2);
        BigDecimal bigDecimal = BigDecimal.ZERO;
        Object object16 = new Ebi43DetailsType();
        object102 = new Ebi43ItemListType();
        n = 0;
        for (Object object92 : invoiceType.getInvoiceLine()) {
            boolean bl;
            taxCategoryType2 = (TaxCategoryType)CollectionHelper.getAtIndex((List)object92.getItem().getClassifiedTaxCategory(), (int)0);
            if (taxCategoryType2 == null) {
                taxCategoryType2 = InvoiceToEbInterface43Converter.findTaxCategory(object92.getTaxTotal());
            }
            object8 = null;
            String string3 = null;
            if (taxCategoryType2 != null) {
                string3 = StringHelper.trim((String)taxCategoryType2.getIDValue());
                if (taxCategoryType2.getPercent() != null) {
                    object8 = taxCategoryType2.getPercentValue();
                }
                if (object8 == null && taxCategoryType2.getID() != null && taxCategoryType2.getTaxScheme() != null && taxCategoryType2.getTaxScheme().getID() != null) {
                    String string4 = StringHelper.trim((String)taxCategoryType2.getTaxScheme().getID().getSchemeID());
                    iterator = StringHelper.trim((String)taxCategoryType2.getTaxScheme().getIDValue());
                    object72 = StringHelper.trim((String)taxCategoryType2.getID().getSchemeID());
                    if (StringHelper.hasText((String)((Object)iterator)) && StringHelper.hasText((String)string3)) {
                        object6 = new TaxCategoryKey(new SchemedID(string4, (String)((Object)iterator)), new SchemedID((String)object72, string3));
                        object8 = (BigDecimal)object122.get(object6);
                    }
                }
            }
            if ((bl = InvoiceToEbInterface43Converter.isTaxExemptionCategoryID(string3)) && object8 == null) {
                object8 = BigDecimal.ZERO;
            }
            if (object8 == null) {
                object8 = BigDecimal.ZERO;
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("InvoiceLine[" + n + "]/Item/ClassifiedTaxCategory")).errorText(AbstractToEbInterfaceConverter.EText.DETAILS_TAX_PERCENTAGE_NOT_FOUND.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{object8}))).build());
            }
            iterator = new Ebi43ListLineItemType();
            object72 = StringHelper.trim((String)object92.getIDValue());
            object6 = StringParser.parseBigInteger((String)object72);
            if (object6 != null && MathHelper.isLT1((BigInteger)object6)) {
                if (this.m_aSettings.isErrorOnPositionNumber()) {
                    errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("InvoiceLine[" + n + "]/ID")).errorText(AbstractToEbInterfaceConverter.EText.DETAILS_INVALID_POSITION.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{object72}))).build());
                } else {
                    object6 = null;
                }
            }
            if (object6 == null) {
                object6 = BigInteger.valueOf((long)n + 1L);
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("InvoiceLine[" + n + "]/ID")).errorText(AbstractToEbInterfaceConverter.EText.DETAILS_INVALID_POSITION_SET_TO_INDEX.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{object72, object6}))).build());
            }
            iterator.setPositionNumber((BigInteger)object6);
            ebi43UnitType = object92.getItem().getDescription().iterator();
            while (ebi43UnitType.hasNext()) {
                object52 = (DescriptionType)ebi43UnitType.next();
                object4 = StringHelper.trim((String)object52.getValue());
                if (!StringHelper.hasText((String)object4)) continue;
                iterator.addDescription((String)object4);
            }
            if (iterator.hasNoDescriptionEntries() && (ebi43UnitType = object92.getItem().getName()) != null && StringHelper.hasText((String)(object52 = StringHelper.trim((String)ebi43UnitType.getValue())))) {
                iterator.addDescription((String)object52);
            }
            for (Object object52 : object92.getNote()) {
                object4 = StringHelper.trim((String)object52.getValue());
                if (!StringHelper.hasText((String)object4)) continue;
                iterator.addDescription((String)object4);
            }
            ebi43UnitType = new Ebi43UnitType();
            if (object92.getInvoicedQuantity() != null) {
                if (object92.getInvoicedQuantity().getUnitCode() != null) {
                    ebi43UnitType.setUnit(StringHelper.trim((String)object92.getInvoicedQuantity().getUnitCode()));
                }
                ebi43UnitType.setValue(object92.getInvoicedQuantityValue());
            }
            if (ebi43UnitType.getUnit() == null) {
                ebi43UnitType.setUnit("C62");
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("InvoiceLine[" + n + "]/InvoicedQuantity/UnitCode")).errorText(AbstractToEbInterfaceConverter.EText.DETAILS_INVALID_UNIT.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{ebi43UnitType.getUnit()}))).build());
            }
            if (ebi43UnitType.getValue() == null) {
                ebi43UnitType.setValue(BigDecimal.ONE);
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("InvoiceLine[" + n + "]/InvoicedQuantity")).errorText(AbstractToEbInterfaceConverter.EText.DETAILS_INVALID_QUANTITY.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{ebi43UnitType.getValue()}))).build());
            }
            iterator.setQuantity(ebi43UnitType);
            if (object92.getPrice() != null) {
                object52 = new Ebi43UnitPriceType();
                object4 = object92.getPrice().getPriceAmountValue();
                object52.setValue((BigDecimal)object4);
                object3 = object92.getPrice().getBaseQuantityValue();
                if (object3 != null) {
                    object52.setBaseQuantity((BigDecimal)object3);
                    if (MathHelper.isEQ0((BigDecimal)object3)) {
                        object52.setValue(BigDecimal.ZERO);
                    }
                }
                iterator.setUnitPrice((Ebi43UnitPriceType)object52);
            } else {
                object52 = object92.getLineExtensionAmountValue();
                object4 = new Ebi43UnitPriceType();
                if (MathHelper.isEQ0((BigDecimal)ebi43UnitType.getValue())) {
                    object4.setValue(BigDecimal.ZERO);
                } else {
                    object4.setValue(((BigDecimal)object52).divide(ebi43UnitType.getValue(), 4, ROUNDING_MODE));
                }
                iterator.setUnitPrice((Ebi43UnitPriceType)object4);
            }
            object52 = iterator.getUnitPrice().getValue();
            object4 = iterator.getUnitPrice().getBaseQuantity();
            if (object4 != null && MathHelper.isNE0((BigDecimal)object4)) {
                object52 = ((BigDecimal)object52).divide((BigDecimal)object4, 4, ROUNDING_MODE);
            }
            if (bl) {
                object3 = null;
                if (taxCategoryType2.hasTaxExemptionReasonEntries()) {
                    object3 = taxCategoryType2.getTaxExemptionReasonAtIndex(0).getValue();
                }
                if (object3 == null && taxCategoryType2.getTaxExemptionReasonCode() != null) {
                    object3 = taxCategoryType2.getTaxExemptionReasonCode().getValue();
                }
                if (StringHelper.hasNoText((String)object3)) {
                    object3 = "Tax Exemption";
                }
                object2 = new Ebi43TaxExemptionType();
                object2.setValue((String)object3);
                iterator.setTaxExemption((Ebi43TaxExemptionType)object2);
            } else {
                object3 = new Ebi43VATRateType();
                object3.setValue((BigDecimal)object8);
                if (taxCategoryType2 != null) {
                    // empty if block
                }
                iterator.setVATRate((Ebi43VATRateType)object3);
            }
            iterator.setLineItemAmount(object92.getLineExtensionAmountValue().setScale(2, ROUNDING_MODE));
            if (MathHelper.isEQ0((BigDecimal)object8)) {
                bigDecimal = bigDecimal.add(iterator.getLineItemAmount());
            }
            object3 = object92.getOrderLineReference().iterator();
            while (object3.hasNext()) {
                object2 = (OrderLineReferenceType)object3.next();
                if (!StringHelper.hasText((String)object2.getLineIDValue())) continue;
                ebi43TaxExemptionType = new Ebi43OrderReferenceDetailType();
                Object object17 = null;
                if (object2.getOrderReference() != null) {
                    object17 = StringHelper.trim((String)object2.getOrderReference().getIDValue());
                }
                if (StringHelper.hasNoText(object17)) {
                    object17 = object13;
                }
                ebi43TaxExemptionType.setOrderID((String)object17);
                Object object18 = StringHelper.trim((String)object2.getLineIDValue());
                if (object18 != null) {
                    if (((String)object18).length() == 0) {
                        errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("InvoiceLine[" + n + "]/OrderLineReference/LineID")).errorText(AbstractToEbInterfaceConverter.EText.ORDERLINE_REF_ID_EMPTY.getDisplayText(this.m_aDisplayLocale))).build());
                    } else {
                        ebi43TaxExemptionType.setOrderPositionNumber((String)object18);
                    }
                }
                if (StringHelper.hasText((String)ebi43TaxExemptionType.getOrderPositionNumber()) && StringHelper.hasNoText((String)object17)) {
                    if (this.m_aSettings.isOrderReferenceIDMandatory()) {
                        errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("InvoiceLine[" + n + "]/OrderLineReference/OrderReference/ID")).errorText(AbstractToEbInterfaceConverter.EText.ORDER_REFERENCE_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
                    } else {
                        ebi43TaxExemptionType.setOrderPositionNumber(null);
                        errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("InvoiceLine[" + n + "]/OrderLineReference/OrderReference/ID")).errorText(AbstractToEbInterfaceConverter.EText.ORDER_REFERENCE_MISSING_IGNORE_ORDER_POS.getDisplayText(this.m_aDisplayLocale))).build());
                    }
                }
                if (!StringHelper.hasText((String)object17)) break;
                iterator.setInvoiceRecipientsOrderReference((Ebi43OrderReferenceDetailType)ebi43TaxExemptionType);
                break;
            }
            if (object92.hasAllowanceChargeEntries()) {
                object3 = iterator.getQuantity().getValue().multiply((BigDecimal)object52);
                object2 = new Ebi43ReductionAndSurchargeListLineItemDetailsType();
                ebi43TaxExemptionType = ETriState.UNDEFINED;
                for (Object object18 : object92.getAllowanceCharge()) {
                    boolean bl2 = object18.getChargeIndicator().isValue();
                    if (ebi43TaxExemptionType.isUndefined()) {
                        ebi43TaxExemptionType = ETriState.valueOf((boolean)bl2);
                    }
                    boolean bl3 = bl2 != ebi43TaxExemptionType.isTrue();
                    Ebi43ReductionAndSurchargeBaseType ebi43ReductionAndSurchargeBaseType = new Ebi43ReductionAndSurchargeBaseType();
                    BigDecimal bigDecimal3 = object18.getAmountValue();
                    ebi43ReductionAndSurchargeBaseType.setAmount(bl3 ? bigDecimal3.negate() : bigDecimal3);
                    if (object18.getBaseAmount() != null) {
                        ebi43ReductionAndSurchargeBaseType.setBaseAmount(object18.getBaseAmountValue());
                    }
                    if (ebi43ReductionAndSurchargeBaseType.getBaseAmount() == null) {
                        ebi43ReductionAndSurchargeBaseType.setBaseAmount((BigDecimal)object3);
                    }
                    if (object18.getMultiplierFactorNumeric() != null) {
                        BigDecimal bigDecimal4 = object18.getMultiplierFactorNumericValue().multiply(CGlobal.BIGDEC_100);
                        ebi43ReductionAndSurchargeBaseType.setPercentage(bigDecimal4);
                    }
                    if (ebi43TaxExemptionType.isTrue()) {
                        object2.addReductionListLineItemOrSurchargeListLineItemOrOtherVATableTaxListLineItem(new ObjectFactory().createSurchargeListLineItem(ebi43ReductionAndSurchargeBaseType));
                        object3 = ((BigDecimal)object3).add(ebi43ReductionAndSurchargeBaseType.getAmount());
                    } else {
                        object2.addReductionListLineItemOrSurchargeListLineItemOrOtherVATableTaxListLineItem(new ObjectFactory().createReductionListLineItem(ebi43ReductionAndSurchargeBaseType));
                        object3 = ((BigDecimal)object3).subtract(ebi43ReductionAndSurchargeBaseType.getAmount());
                    }
                    ebi43ReductionAndSurchargeBaseType.setComment(InvoiceToEbInterface43Converter.getAllowanceChargeComment((AllowanceChargeType)object18));
                }
                iterator.setReductionAndSurchargeListLineItemDetails((Ebi43ReductionAndSurchargeListLineItemDetailsType)object2);
            }
            if (object92.hasDeliveryEntries() && (object3 = object92.getDeliveryAtIndex(0)).getActualDeliveryDate() != null) {
                object2 = InvoiceToEbInterface43Converter.convertDelivery((DeliveryType)object3, "InvoiceLine[" + n + "]/Delivery[0]", invoiceType.getAccountingCustomerParty(), errorList, this.m_aContentLocale, this.m_aDisplayLocale);
                iterator.setDelivery((Ebi43DeliveryType)object2);
            }
            if (this.m_aCustomizer != null) {
                this.m_aCustomizer.additionalItemMapping((InvoiceLineType)object92, iterator);
            }
            object102.addListLineItem(iterator);
            ++n;
        }
        object16.addItemList((Ebi43ItemListType)object102);
        ebi43InvoiceType.setDetails((Ebi43DetailsType)object16);
        if (object11.hasNoVATItemEntries()) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("Invoice")).errorText(AbstractToEbInterfaceConverter.EText.VAT_ITEM_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
        }
        if (invoiceType.hasAllowanceChargeEntries()) {
            object16 = invoiceType.getLegalMonetaryTotal().getLineExtensionAmountValue();
            if (object16 == null) {
                object102 = BigDecimal.ZERO;
                for (Object object19 : ebi43InvoiceType.getDetails().getItemList()) {
                    for (TaxCategoryType taxCategoryType2 : object19.getListLineItem()) {
                        object102 = ((BigDecimal)object102).add(taxCategoryType2.getLineItemAmount());
                    }
                }
                object16 = object102;
            }
            object102 = new Ebi43ReductionAndSurchargeDetailsType();
            n = 0;
            for (Object object92 : invoiceType.getAllowanceCharge()) {
                BigDecimal bigDecimal5;
                boolean bl = object92.getChargeIndicator().isValue();
                object8 = new Ebi43ReductionAndSurchargeType();
                BigDecimal bigDecimal6 = object92.getAmountValue();
                object8.setAmount(bigDecimal6);
                if (object92.getBaseAmount() != null) {
                    object8.setBaseAmount(object92.getBaseAmountValue());
                }
                if (object8.getBaseAmount() == null) {
                    object8.setBaseAmount((BigDecimal)object16);
                }
                if (object92.getMultiplierFactorNumeric() != null) {
                    bigDecimal5 = object92.getMultiplierFactorNumericValue().multiply(CGlobal.BIGDEC_100);
                    object8.setPercentage(bigDecimal5);
                }
                object8.setComment(InvoiceToEbInterface43Converter.getAllowanceChargeComment((AllowanceChargeType)object92));
                bigDecimal5 = null;
                for (Object object72 : object92.getTaxCategory()) {
                    if (object72.getPercent() == null) continue;
                    bigDecimal5 = new Ebi43VATRateType();
                    bigDecimal5.setValue(object72.getPercentValue());
                    break;
                }
                if (bigDecimal5 == null) {
                    errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("Invoice/AllowanceCharge[" + n + "]")).errorText(AbstractToEbInterfaceConverter.EText.ALLOWANCE_CHARGE_NO_TAXRATE.getDisplayText(this.m_aDisplayLocale))).build());
                }
                object8.setVATRate((Ebi43VATRateType)bigDecimal5);
                if (bl) {
                    object102.addReductionOrSurchargeOrOtherVATableTax(new ObjectFactory().createSurcharge((Ebi43ReductionAndSurchargeType)object8));
                    object16 = ((BigDecimal)object16).add(object8.getAmount());
                } else {
                    object102.addReductionOrSurchargeOrOtherVATableTax(new ObjectFactory().createReduction((Ebi43ReductionAndSurchargeType)object8));
                    object16 = ((BigDecimal)object16).subtract(object8.getAmount());
                }
                ebi43InvoiceType.setReductionAndSurchargeDetails((Ebi43ReductionAndSurchargeDetailsType)object102);
                ++n;
            }
        }
        if ((object16 = invoiceType.getLegalMonetaryTotal()).getPrepaidAmount() != null && !MathHelper.isEQ0((BigDecimal)object16.getPrepaidAmountValue())) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("Invoice/LegalMonetaryTotal/PrepaidAmount")).errorText(AbstractToEbInterfaceConverter.EText.PREPAID_NOT_SUPPORTED.getDisplayText(this.m_aDisplayLocale))).build());
        }
        if (object16.getTaxInclusiveAmountValue() != null) {
            ebi43InvoiceType.setTotalGrossAmount(object16.getTaxInclusiveAmountValue().setScale(2, ROUNDING_MODE));
        } else {
            ebi43InvoiceType.setTotalGrossAmount(object16.getPayableAmountValue().setScale(2, ROUNDING_MODE));
        }
        ebi43InvoiceType.setPayableAmount(object16.getPayableAmountValue().setScale(2, ROUNDING_MODE));
        this.convertPayment(() -> ((InvoiceType)invoiceType).getDueDateValue(), () -> ((InvoiceType)invoiceType).getPaymentMeans(), () -> ((InvoiceType)invoiceType).getPayeeParty(), () -> ((InvoiceType)invoiceType).getAccountingSupplierParty(), () -> ((InvoiceType)invoiceType).getPaymentTerms(), () -> ((InvoiceType)invoiceType).getLegalMonetaryTotal(), errorList, ebi43InvoiceType, false);
        object102 = null;
        n = 0;
        object19 = invoiceType.getDelivery().iterator();
        while (object19.hasNext()) {
            object92 = (DeliveryType)object19.next();
            if (object92.getActualDeliveryDate() != null) {
                object102 = InvoiceToEbInterface43Converter.convertDelivery((DeliveryType)object92, "Delivery[" + n + "]", invoiceType.getAccountingCustomerParty(), errorList, this.m_aContentLocale, this.m_aDisplayLocale);
                break;
            }
            ++n;
        }
        if (object102 == null) {
            object102 = new Ebi43DeliveryType();
        }
        if ((object19 = (PeriodType)CollectionHelper.getAtIndex((List)invoiceType.getInvoicePeriod(), (int)0)) != null) {
            object92 = object19.getStartDateValue();
            XMLOffsetDate xMLOffsetDate = object19.getEndDateValue();
            if (object92 != null) {
                if (xMLOffsetDate == null) {
                    if (object102.getDate() == null) {
                        object102.setDate((XMLOffsetDate)object92);
                    }
                } else {
                    object8 = new Ebi43PeriodType();
                    object8.setFromDate((XMLOffsetDate)object92);
                    object8.setToDate(xMLOffsetDate);
                    object102.setPeriod((Ebi43PeriodType)object8);
                    object102.setDate((XMLOffsetDate)null);
                }
            }
        }
        if (this.m_aSettings.isDeliveryDateMandatory() && object102.getDate() == null && object102.getPeriod() == null) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("Invoice")).errorText(AbstractToEbInterfaceConverter.EText.ERB_NO_DELIVERY_DATE.getDisplayText(this.m_aDisplayLocale))).build());
        }
        if (object102.getDate() != null || object102.getPeriod() != null) {
            ebi43InvoiceType.setDelivery((Ebi43DeliveryType)object102);
        }
        if (this.m_aCustomizer != null) {
            this.m_aCustomizer.additionalGlobalMapping(invoiceType, ebi43InvoiceType);
        }
        return ebi43InvoiceType;
    }
}

