/*
 * Decompiled with CFR 0.152.
 */
package at.austriapro.ebinterface.ubl.from.invoice;

import at.austriapro.ebinterface.ubl.from.AbstractToEbInterface60Converter;
import at.austriapro.ebinterface.ubl.from.AbstractToEbInterfaceConverter;
import at.austriapro.ebinterface.ubl.from.IToEbinterfaceSettings;
import at.austriapro.ebinterface.ubl.from.helper.SchemedID;
import at.austriapro.ebinterface.ubl.from.helper.TaxCategoryKey;
import at.austriapro.ebinterface.ubl.from.invoice.ICustomInvoiceToEbInterface60Converter;
import com.helger.commons.CGlobal;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.datetime.XMLOffsetDate;
import com.helger.commons.error.SingleError;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.math.MathHelper;
import com.helger.commons.state.ETriState;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.StringParser;
import com.helger.ebinterface.v60.Ebi60AdditionalInformationType;
import com.helger.ebinterface.v60.Ebi60AddressType;
import com.helger.ebinterface.v60.Ebi60BillerType;
import com.helger.ebinterface.v60.Ebi60ContactType;
import com.helger.ebinterface.v60.Ebi60DeliveryType;
import com.helger.ebinterface.v60.Ebi60DetailsType;
import com.helger.ebinterface.v60.Ebi60DocumentTypeType;
import com.helger.ebinterface.v60.Ebi60FurtherIdentificationType;
import com.helger.ebinterface.v60.Ebi60InvoiceRecipientType;
import com.helger.ebinterface.v60.Ebi60InvoiceType;
import com.helger.ebinterface.v60.Ebi60ItemListType;
import com.helger.ebinterface.v60.Ebi60ListLineItemType;
import com.helger.ebinterface.v60.Ebi60OrderReferenceDetailType;
import com.helger.ebinterface.v60.Ebi60OrderReferenceType;
import com.helger.ebinterface.v60.Ebi60OrderingPartyType;
import com.helger.ebinterface.v60.Ebi60OtherTaxType;
import com.helger.ebinterface.v60.Ebi60PeriodType;
import com.helger.ebinterface.v60.Ebi60ReductionAndSurchargeBaseType;
import com.helger.ebinterface.v60.Ebi60ReductionAndSurchargeDetailsType;
import com.helger.ebinterface.v60.Ebi60ReductionAndSurchargeListLineItemDetailsType;
import com.helger.ebinterface.v60.Ebi60ReductionAndSurchargeType;
import com.helger.ebinterface.v60.Ebi60TaxItemType;
import com.helger.ebinterface.v60.Ebi60TaxPercentType;
import com.helger.ebinterface.v60.Ebi60TaxType;
import com.helger.ebinterface.v60.Ebi60UnitPriceType;
import com.helger.ebinterface.v60.Ebi60UnitType;
import com.helger.ebinterface.v60.ObjectFactory;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.AllowanceChargeType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.DeliveryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.InvoiceLineType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.OrderLineReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyTaxSchemeType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PeriodType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.TaxCategoryType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.DescriptionType;
import oasis.names.specification.ubl.schema.xsd.invoice_21.InvoiceType;

@Immutable
public final class InvoiceToEbInterface60Converter
extends AbstractToEbInterface60Converter {
    private ICustomInvoiceToEbInterface60Converter m_aCustomizer;

    public InvoiceToEbInterface60Converter(@Nonnull Locale locale, @Nonnull Locale locale2, @Nonnull IToEbinterfaceSettings iToEbinterfaceSettings) {
        super(locale, locale2, iToEbinterfaceSettings);
    }

    @Nonnull
    public InvoiceToEbInterface60Converter setCustomizer(@Nullable ICustomInvoiceToEbInterface60Converter iCustomInvoiceToEbInterface60Converter) {
        this.m_aCustomizer = iCustomInvoiceToEbInterface60Converter;
        return this;
    }

    @Nullable
    public Ebi60InvoiceType convertToEbInterface(@Nonnull InvoiceType invoiceType, @Nonnull ErrorList errorList) {
        Object object20;
        Object object2;
        Ebi60TaxPercentType ebi60TaxPercentType;
        Object object3;
        Object object4;
        Object object52;
        Ebi60UnitType ebi60UnitType;
        Object object6;
        Object object72;
        Ebi60TaxItemType ebi60TaxItemType;
        Object object8;
        TaxCategoryType taxCategoryType2;
        Object object92;
        int n;
        Object object102;
        Object object11;
        Object object12;
        PartyTaxSchemeType partyTaxSchemeType2;
        Object object132;
        ValueEnforcer.notNull((Object)invoiceType, (String)"UBLInvoice");
        ValueEnforcer.notNull((Object)errorList, (String)"TransformationErrorList");
        ValueEnforcer.isTrue((boolean)errorList.isEmpty(), (String)"TransformationErrorList must be empty!");
        this.checkInvoiceConsistency(invoiceType, errorList);
        if (errorList.containsAtLeastOneError()) {
            return null;
        }
        Ebi60InvoiceType ebi60InvoiceType = new Ebi60InvoiceType();
        ebi60InvoiceType.setGeneratingSystem("UBL 2.1 to ebInterface 6.0 converter");
        ebi60InvoiceType.setDocumentType(InvoiceToEbInterface60Converter.getAsDocumentTypeType(invoiceType.getInvoiceTypeCode() == null ? null : invoiceType.getInvoiceTypeCode().getName(), invoiceType.getInvoiceTypeCodeValue(), Ebi60DocumentTypeType.INVOICE.value()));
        String string = StringHelper.trim((String)invoiceType.getDocumentCurrencyCodeValue());
        ebi60InvoiceType.setInvoiceCurrency(string);
        String string2 = StringHelper.trim((String)invoiceType.getIDValue());
        if (StringHelper.hasNoText((String)string2)) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("ID")).errorText(AbstractToEbInterfaceConverter.EText.MISSING_INVOICE_NUMBER.getDisplayText(this.m_aDisplayLocale))).build());
        }
        ebi60InvoiceType.setInvoiceNumber(string2);
        ebi60InvoiceType.setInvoiceDate(invoiceType.getIssueDateValue());
        if (ebi60InvoiceType.getInvoiceDate() == null) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("IssueDate")).errorText(AbstractToEbInterfaceConverter.EText.MISSING_INVOICE_DATE.getDisplayText(this.m_aDisplayLocale))).build());
        }
        if (invoiceType.getCopyIndicator() != null) {
            ebi60InvoiceType.setIsDuplicate(Boolean.valueOf(invoiceType.getCopyIndicator().isValue()));
        }
        InvoiceToEbInterface60Converter.convertRelatedDocuments(invoiceType.getBillingReference(), ebi60InvoiceType);
        InvoiceToEbInterface60Converter.convertReferencedDocuments(invoiceType.getDespatchDocumentReference(), ebi60InvoiceType);
        InvoiceToEbInterface60Converter.convertReferencedDocuments(invoiceType.getReceiptDocumentReference(), ebi60InvoiceType);
        InvoiceToEbInterface60Converter.convertReferencedDocuments(invoiceType.getContractDocumentReference(), ebi60InvoiceType);
        InvoiceToEbInterface60Converter.convertReferencedDocuments(invoiceType.getAdditionalDocumentReference(), ebi60InvoiceType);
        InvoiceToEbInterface60Converter.convertReferencedDocuments(invoiceType.getStatementDocumentReference(), ebi60InvoiceType);
        InvoiceToEbInterface60Converter.convertReferencedDocuments(invoiceType.getOriginatorDocumentReference(), ebi60InvoiceType);
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        for (Object object132 : invoiceType.getNote()) {
            if (!StringHelper.hasText((String)object132.getValue())) continue;
            commonsArrayList.add((Object)object132.getValue());
        }
        if (!commonsArrayList.isEmpty()) {
            ebi60InvoiceType.setComment(StringHelper.getImplodedNonEmpty((char)'\n', (Iterable)commonsArrayList));
        }
        commonsArrayList = invoiceType.getAccountingSupplierParty();
        Object object14 = new Ebi60BillerType();
        if (commonsArrayList.getParty() != null) {
            for (PartyTaxSchemeType partyTaxSchemeType2 : commonsArrayList.getParty().getPartyTaxScheme()) {
                if (!InvoiceToEbInterface60Converter.isVATSchemeID(partyTaxSchemeType2.getTaxScheme().getIDValue())) continue;
                object14.setVATIdentificationNumber(StringHelper.trim((String)partyTaxSchemeType2.getCompanyIDValue()));
                break;
            }
        }
        if (StringHelper.hasNoText((String)object14.getVATIdentificationNumber())) {
            object14.setVATIdentificationNumber("ATU00000000");
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("AccountingSupplierParty/Party/PartyTaxScheme")).errorText(AbstractToEbInterfaceConverter.EText.BILLER_VAT_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
        }
        if (commonsArrayList.getCustomerAssignedAccountID() != null) {
            object14.setInvoiceRecipientsBillerID(StringHelper.trim((String)commonsArrayList.getCustomerAssignedAccountIDValue()));
        }
        if (StringHelper.hasNoText((String)object14.getInvoiceRecipientsBillerID()) && commonsArrayList.getParty() != null && commonsArrayList.getParty().hasPartyIdentificationEntries()) {
            object14.setInvoiceRecipientsBillerID(StringHelper.trim((String)commonsArrayList.getParty().getPartyIdentificationAtIndex(0).getIDValue()));
        }
        for (PartyTaxSchemeType partyTaxSchemeType2 : commonsArrayList.getAdditionalAccountID()) {
            object12 = new Ebi60FurtherIdentificationType();
            object12.setIdentificationType("Consolidator");
            object12.setValue(StringHelper.trim((String)partyTaxSchemeType2.getValue()));
            object14.addFurtherIdentification(object12);
        }
        if (commonsArrayList.getParty() != null) {
            object132 = InvoiceToEbInterface60Converter.convertParty(commonsArrayList.getParty(), "AccountingSupplierParty", errorList, this.m_aContentLocale, this.m_aDisplayLocale, true);
            object14.setAddress((Ebi60AddressType)object132);
            partyTaxSchemeType2 = InvoiceToEbInterface60Converter.convertContact(commonsArrayList.getParty(), "AccountingSupplierParty", object14.getAddress().getName(), errorList, this.m_aDisplayLocale, true);
            object14.setContact((Ebi60ContactType)partyTaxSchemeType2);
            if (object132.hasNoEmailEntries() && (partyTaxSchemeType2 == null || partyTaxSchemeType2.hasNoEmailEntries()) && this.m_aSettings.isEnforceSupplierEmailAddress()) {
                object132.addEmail(this.m_aSettings.getEnforcedSupplierEmailAddress());
            }
        }
        for (PartyTaxSchemeType partyTaxSchemeType2 : invoiceType.getContractDocumentReference()) {
            if (!StringHelper.hasTextAfterTrim((String)partyTaxSchemeType2.getIDValue())) continue;
            object12 = StringHelper.hasText((String)partyTaxSchemeType2.getID().getSchemeID()) ? partyTaxSchemeType2.getID().getSchemeID() : "Contract";
            object11 = new Ebi60FurtherIdentificationType();
            object11.setIdentificationType((String)object12);
            object11.setValue(StringHelper.trim((String)partyTaxSchemeType2.getIDValue()));
            object14.addFurtherIdentification((Ebi60FurtherIdentificationType)object11);
        }
        ebi60InvoiceType.setBiller((Ebi60BillerType)object14);
        commonsArrayList = invoiceType.getAccountingCustomerParty();
        object14 = new Ebi60InvoiceRecipientType();
        if (commonsArrayList.getParty() != null) {
            for (PartyTaxSchemeType partyTaxSchemeType2 : commonsArrayList.getParty().getPartyTaxScheme()) {
                if (!InvoiceToEbInterface60Converter.isVATSchemeID(partyTaxSchemeType2.getTaxScheme().getIDValue())) continue;
                object14.setVATIdentificationNumber(StringHelper.trim((String)partyTaxSchemeType2.getCompanyIDValue()));
                break;
            }
        }
        if (StringHelper.hasNoText((String)object14.getVATIdentificationNumber())) {
            object14.setVATIdentificationNumber("ATU00000000");
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("AccountingCustomerParty/PartyTaxScheme")).errorText(AbstractToEbInterfaceConverter.EText.INVOICE_RECIPIENT_VAT_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
        }
        if (commonsArrayList.getSupplierAssignedAccountID() != null) {
            object14.setBillersInvoiceRecipientID(StringHelper.trim((String)commonsArrayList.getSupplierAssignedAccountIDValue()));
        }
        for (PartyTaxSchemeType partyTaxSchemeType2 : commonsArrayList.getAdditionalAccountID()) {
            object12 = new Ebi60FurtherIdentificationType();
            object12.setIdentificationType("Consolidator");
            object12.setValue(StringHelper.trim((String)partyTaxSchemeType2.getValue()));
            object14.addFurtherIdentification(object12);
        }
        if (commonsArrayList.getParty() != null) {
            object14.setAddress(InvoiceToEbInterface60Converter.convertParty(commonsArrayList.getParty(), "AccountingCustomerParty", errorList, this.m_aContentLocale, this.m_aDisplayLocale, true));
            object14.setContact(InvoiceToEbInterface60Converter.convertContact(commonsArrayList.getParty(), "AccountingCustomerParty", object14.getAddress().getName(), errorList, this.m_aDisplayLocale, true));
        }
        ebi60InvoiceType.setInvoiceRecipient((Ebi60InvoiceRecipientType)object14);
        commonsArrayList = invoiceType.getBuyerCustomerParty();
        if (commonsArrayList != null) {
            object14 = new Ebi60OrderingPartyType();
            if (commonsArrayList.getParty() != null) {
                for (PartyTaxSchemeType partyTaxSchemeType2 : commonsArrayList.getParty().getPartyTaxScheme()) {
                    if (!InvoiceToEbInterface60Converter.isVATSchemeID(partyTaxSchemeType2.getTaxScheme().getIDValue())) continue;
                    object14.setVATIdentificationNumber(StringHelper.trim((String)partyTaxSchemeType2.getCompanyIDValue()));
                    break;
                }
            }
            if (StringHelper.hasNoText((String)object14.getVATIdentificationNumber())) {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("BuyerCustomerParty/PartyTaxScheme")).errorText(AbstractToEbInterfaceConverter.EText.ORDERING_PARTY_VAT_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
            }
            if (commonsArrayList.getParty() != null) {
                object14.setAddress(InvoiceToEbInterface60Converter.convertParty(commonsArrayList.getParty(), "BuyerCustomerParty", errorList, this.m_aContentLocale, this.m_aDisplayLocale, true));
                object14.setContact(InvoiceToEbInterface60Converter.convertContact(commonsArrayList.getParty(), "BuyerCustomerParty", object14.getAddress().getName(), errorList, this.m_aDisplayLocale, true));
            }
            if (commonsArrayList.getSupplierAssignedAccountID() != null) {
                object14.setBillersOrderingPartyID(StringHelper.trim((String)commonsArrayList.getSupplierAssignedAccountIDValue()));
            }
            if (StringHelper.hasNoText((String)object14.getBillersOrderingPartyID()) && commonsArrayList.getParty() != null && commonsArrayList.getParty().hasPartyIdentificationEntries()) {
                object14.setBillersOrderingPartyID(StringHelper.trim((String)commonsArrayList.getParty().getPartyIdentificationAtIndex(0).getIDValue()));
            }
            if (StringHelper.hasNoText((String)object14.getBillersOrderingPartyID()) && ebi60InvoiceType.getInvoiceRecipient() != null) {
                object14.setBillersOrderingPartyID(ebi60InvoiceType.getInvoiceRecipient().getBillersInvoiceRecipientID());
            }
            if (StringHelper.hasNoText((String)object14.getBillersOrderingPartyID())) {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("BuyerCustomerParty/SupplierAssignedAccountID")).errorText(AbstractToEbInterfaceConverter.EText.ORDERING_PARTY_SUPPLIER_ASSIGNED_ACCOUNT_ID_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
            }
            ebi60InvoiceType.setOrderingParty((Ebi60OrderingPartyType)object14);
        }
        object14 = null;
        object132 = invoiceType.getOrderReference();
        if (object132 != null) {
            object14 = StringHelper.trim((String)object132.getIDValue());
        }
        if (StringHelper.hasNoText((String)object14)) {
            if (this.m_aSettings.isOrderReferenceIDMandatory()) {
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("OrderReference/ID")).errorText(AbstractToEbInterfaceConverter.EText.ORDER_REFERENCE_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
            }
        } else {
            if (this.m_aSettings.hasOrderReferenceMaxLength()) {
                int n2 = this.m_aSettings.getOrderReferenceMaxLength();
                if (((String)object14).length() > n2) {
                    errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("OrderReference/ID")).errorText(AbstractToEbInterfaceConverter.EText.ORDER_REFERENCE_TOO_LONG.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{object14, n2}))).build());
                    object14 = ((String)object14).substring(0, n2);
                }
            }
            partyTaxSchemeType2 = new Ebi60OrderReferenceType();
            partyTaxSchemeType2.setOrderID((String)object14);
            ebi60InvoiceType.getInvoiceRecipient().setOrderReference((Ebi60OrderReferenceType)partyTaxSchemeType2);
        }
        object132 = new CommonsHashMap();
        partyTaxSchemeType2 = new Ebi60TaxType();
        int n3 = 0;
        for (Object object102 : invoiceType.getTaxTotal()) {
            n = 0;
            for (Object object92 : object102.getTaxSubtotal()) {
                taxCategoryType2 = object92.getTaxCategory();
                object8 = StringHelper.trim((String)taxCategoryType2.getIDValue());
                boolean bl = InvoiceToEbInterface60Converter.isTaxExemptionCategoryID((String)object8);
                BigDecimal bigDecimal = object92.getTaxAmountValue();
                ebi60TaxItemType = object92.getTaxableAmountValue();
                Object object15 = object72 = bl ? BigDecimal.ZERO : taxCategoryType2.getPercentValue();
                if (object72 == null && bigDecimal != null && ebi60TaxItemType != null) {
                    Object object16 = object72 = MathHelper.isEQ0((BigDecimal)ebi60TaxItemType) ? BigDecimal.ZERO : bigDecimal.multiply(CGlobal.BIGDEC_100).divide((BigDecimal)ebi60TaxItemType, 2, ROUNDING_MODE);
                }
                if (object72 != null) {
                    if (ebi60TaxItemType == null && bigDecimal != null) {
                        if (MathHelper.isNE0((BigDecimal)object72)) {
                            ebi60TaxItemType = bigDecimal.multiply(CGlobal.BIGDEC_100).divide((BigDecimal)object72, 4, ROUNDING_MODE);
                        }
                    } else if (ebi60TaxItemType != null && bigDecimal == null) {
                        BigDecimal bigDecimal2 = bigDecimal = MathHelper.isEQ0((BigDecimal)object72) ? BigDecimal.ZERO : ebi60TaxItemType.multiply((BigDecimal)object72).divide(CGlobal.BIGDEC_100, 4, ROUNDING_MODE);
                    }
                }
                if ((object6 = taxCategoryType2.getTaxScheme().getID()) == null) {
                    errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("TaxTotal[" + n3 + "]/TaxSubtotal[" + n + "]/TaxCategory/TaxScheme/ID")).errorText(AbstractToEbInterfaceConverter.EText.MISSING_TAXCATEGORY_TAXSCHEME_ID.getDisplayText(this.m_aDisplayLocale))).build());
                    break;
                }
                ebi60UnitType = StringHelper.trim((String)object6.getSchemeID());
                object52 = StringHelper.trim((String)object6.getValue());
                if (StringHelper.hasNoText((String)object52)) {
                    errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("TaxTotal[" + n3 + "]/TaxSubtotal[" + n + "]/TaxCategory/TaxScheme/ID")).errorText(AbstractToEbInterfaceConverter.EText.MISSING_TAXCATEGORY_TAXSCHEME_ID_VALUE.getDisplayText(this.m_aDisplayLocale))).build());
                    break;
                }
                if (taxCategoryType2.getID() == null) {
                    errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("TaxTotal[" + n3 + "]/TaxSubtotal[" + n + "]/TaxCategory")).errorText(AbstractToEbInterfaceConverter.EText.MISSING_TAXCATEGORY_ID.getDisplayText(this.m_aDisplayLocale))).build());
                    break;
                }
                if (StringHelper.hasNoText((String)object8)) {
                    errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("TaxTotal[" + n3 + "]/TaxSubtotal[" + n + "]/TaxCategory")).errorText(AbstractToEbInterfaceConverter.EText.MISSING_TAXCATEGORY_ID_VALUE.getDisplayText(this.m_aDisplayLocale))).build());
                    break;
                }
                object4 = StringHelper.trim((String)taxCategoryType2.getID().getSchemeID());
                object132.put((Object)new TaxCategoryKey(new SchemedID((String)ebi60UnitType, (String)object52), new SchemedID((String)object4, (String)object8)), object72);
                if (InvoiceToEbInterface60Converter.isVATSchemeID((String)object52)) {
                    if (object72 == null) {
                        errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("TaxTotal[" + n3 + "]/TaxSubtotal[" + n + "]/TaxCategory/Percent")).errorText(AbstractToEbInterfaceConverter.EText.TAX_PERCENT_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
                    } else if (ebi60TaxItemType == null) {
                        errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("TaxTotal[" + n3 + "]/TaxSubtotal[" + n + "]/TaxableAmount")).errorText(AbstractToEbInterfaceConverter.EText.TAXABLE_AMOUNT_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
                    } else {
                        object3 = new Ebi60TaxItemType();
                        object3.setTaxableAmount(ebi60TaxItemType.setScale(2, ROUNDING_MODE));
                        ebi60TaxPercentType = new Ebi60TaxPercentType();
                        ebi60TaxPercentType.setTaxCategoryCode((String)object8);
                        if (bl) {
                            ebi60TaxPercentType.setValue(BigDecimal.ZERO);
                            object2 = null;
                            if (taxCategoryType2.hasTaxExemptionReasonEntries()) {
                                object2 = taxCategoryType2.getTaxExemptionReasonAtIndex(0).getValue();
                            }
                            if (object2 == null && taxCategoryType2.getTaxExemptionReasonCode() != null) {
                                object2 = taxCategoryType2.getTaxExemptionReasonCode().getValue();
                            }
                            if (StringHelper.hasText(object2)) {
                                object3.setComment((String)object2);
                            }
                        } else {
                            ebi60TaxPercentType.setValue((BigDecimal)object72);
                        }
                        object3.setTaxPercent(ebi60TaxPercentType);
                        object3.setTaxAmount(bigDecimal.setScale(2, ROUNDING_MODE));
                        partyTaxSchemeType2.addTaxItem((Ebi60TaxItemType)object3);
                    }
                } else {
                    object3 = new Ebi60OtherTaxType();
                    if (object72 != null) {
                        ebi60TaxPercentType = new Ebi60TaxPercentType();
                        ebi60TaxPercentType.setTaxCategoryCode((String)object8);
                        ebi60TaxPercentType.setValue((BigDecimal)object72);
                        object3.setTaxPercent(ebi60TaxPercentType);
                    }
                    object3.setTaxAmount(bigDecimal.setScale(2, ROUNDING_MODE));
                    object3.setComment((String)object52);
                    partyTaxSchemeType2.addOtherTax(object3);
                }
                ++n;
            }
            ++n3;
        }
        ebi60InvoiceType.setTax((Ebi60TaxType)partyTaxSchemeType2);
        BigDecimal bigDecimal = BigDecimal.ZERO;
        object11 = new Ebi60DetailsType();
        object102 = new Ebi60ItemListType();
        n = 0;
        for (Object object92 : invoiceType.getInvoiceLine()) {
            Object object172;
            Object object18;
            Object object19;
            OrderLineReferenceType orderLineReferenceType2;
            boolean bl;
            taxCategoryType2 = (TaxCategoryType)CollectionHelper.getAtIndex((List)object92.getItem().getClassifiedTaxCategory(), (int)0);
            if (taxCategoryType2 == null) {
                taxCategoryType2 = InvoiceToEbInterface60Converter.findTaxCategory(object92.getTaxTotal());
            }
            object8 = null;
            String string3 = null;
            if (taxCategoryType2 != null) {
                string3 = StringHelper.trim((String)taxCategoryType2.getIDValue());
                if (taxCategoryType2.getPercent() != null) {
                    object8 = taxCategoryType2.getPercentValue();
                }
                if (object8 == null && taxCategoryType2.getID() != null && taxCategoryType2.getTaxScheme() != null && taxCategoryType2.getTaxScheme().getID() != null) {
                    String string4 = StringHelper.trim((String)taxCategoryType2.getTaxScheme().getID().getSchemeID());
                    ebi60TaxItemType = StringHelper.trim((String)taxCategoryType2.getTaxScheme().getIDValue());
                    object72 = StringHelper.trim((String)taxCategoryType2.getID().getSchemeID());
                    if (StringHelper.hasText((String)ebi60TaxItemType) && StringHelper.hasText((String)string3)) {
                        object6 = new TaxCategoryKey(new SchemedID(string4, (String)ebi60TaxItemType), new SchemedID((String)object72, string3));
                        object8 = (BigDecimal)object132.get(object6);
                    }
                }
            }
            if ((bl = InvoiceToEbInterface60Converter.isTaxExemptionCategoryID(string3)) && object8 == null) {
                object8 = BigDecimal.ZERO;
            }
            if (object8 == null) {
                object8 = BigDecimal.ZERO;
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("InvoiceLine[" + n + "]/Item/ClassifiedTaxCategory")).errorText(AbstractToEbInterfaceConverter.EText.DETAILS_TAX_PERCENTAGE_NOT_FOUND.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{object8}))).build());
            }
            ebi60TaxItemType = new Ebi60ListLineItemType();
            object72 = StringHelper.trim((String)object92.getIDValue());
            object6 = StringParser.parseBigInteger((String)object72);
            if (object6 != null && MathHelper.isLT1((BigInteger)object6)) {
                if (this.m_aSettings.isErrorOnPositionNumber()) {
                    errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("InvoiceLine[" + n + "]/ID")).errorText(AbstractToEbInterfaceConverter.EText.DETAILS_INVALID_POSITION.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{object72}))).build());
                } else {
                    object6 = null;
                }
            }
            if (object6 == null) {
                object6 = BigInteger.valueOf((long)n + 1L);
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("InvoiceLine[" + n + "]/ID")).errorText(AbstractToEbInterfaceConverter.EText.DETAILS_INVALID_POSITION_SET_TO_INDEX.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{object72, object6}))).build());
            }
            ebi60TaxItemType.setPositionNumber((BigInteger)object6);
            ebi60UnitType = object92.getItem().getDescription().iterator();
            while (ebi60UnitType.hasNext()) {
                object52 = (DescriptionType)ebi60UnitType.next();
                object4 = StringHelper.trim((String)object52.getValue());
                if (!StringHelper.hasText((String)object4)) continue;
                ebi60TaxItemType.addDescription((String)object4);
            }
            if (ebi60TaxItemType.hasNoDescriptionEntries() && (ebi60UnitType = object92.getItem().getName()) != null && StringHelper.hasText((String)(object52 = StringHelper.trim((String)ebi60UnitType.getValue())))) {
                ebi60TaxItemType.addDescription((String)object52);
            }
            for (Object object52 : object92.getNote()) {
                object4 = StringHelper.trim((String)object52.getValue());
                if (!StringHelper.hasText((String)object4)) continue;
                ebi60TaxItemType.addDescription((String)object4);
            }
            ebi60UnitType = new Ebi60UnitType();
            if (object92.getInvoicedQuantity() != null) {
                if (object92.getInvoicedQuantity().getUnitCode() != null) {
                    ebi60UnitType.setUnit(StringHelper.trim((String)object92.getInvoicedQuantity().getUnitCode()));
                }
                ebi60UnitType.setValue(object92.getInvoicedQuantityValue());
            }
            if (ebi60UnitType.getUnit() == null) {
                ebi60UnitType.setUnit("C62");
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("InvoiceLine[" + n + "]/InvoicedQuantity/UnitCode")).errorText(AbstractToEbInterfaceConverter.EText.DETAILS_INVALID_UNIT.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{ebi60UnitType.getUnit()}))).build());
            }
            if (ebi60UnitType.getValue() == null) {
                ebi60UnitType.setValue(BigDecimal.ONE);
                errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("InvoiceLine[" + n + "]/InvoicedQuantity")).errorText(AbstractToEbInterfaceConverter.EText.DETAILS_INVALID_QUANTITY.getDisplayTextWithArgs(this.m_aDisplayLocale, new Object[]{ebi60UnitType.getValue()}))).build());
            }
            ebi60TaxItemType.setQuantity(ebi60UnitType);
            if (object92.getPrice() != null) {
                object52 = new Ebi60UnitPriceType();
                object4 = object92.getPrice().getPriceAmountValue();
                object52.setValue((BigDecimal)object4);
                object3 = object92.getPrice().getBaseQuantityValue();
                if (object3 != null) {
                    object52.setBaseQuantity((BigDecimal)object3);
                    if (MathHelper.isEQ0((BigDecimal)object3)) {
                        object52.setValue(BigDecimal.ZERO);
                    }
                }
                ebi60TaxItemType.setUnitPrice((Ebi60UnitPriceType)object52);
            } else {
                object52 = object92.getLineExtensionAmountValue();
                object4 = new Ebi60UnitPriceType();
                if (MathHelper.isEQ0((BigDecimal)ebi60UnitType.getValue())) {
                    object4.setValue(BigDecimal.ZERO);
                } else {
                    object4.setValue(((BigDecimal)object52).divide(ebi60UnitType.getValue(), 4, ROUNDING_MODE));
                }
                ebi60TaxItemType.setUnitPrice((Ebi60UnitPriceType)object4);
            }
            object52 = ebi60TaxItemType.getUnitPrice().getValue();
            object4 = ebi60TaxItemType.getUnitPrice().getBaseQuantity();
            if (object4 != null && MathHelper.isNE0((BigDecimal)object4)) {
                object52 = ((BigDecimal)object52).divide((BigDecimal)object4, 4, ROUNDING_MODE);
            }
            ebi60TaxItemType.setLineItemAmount(object92.getLineExtensionAmountValue().setScale(2, ROUNDING_MODE));
            object3 = new Ebi60TaxItemType();
            object3.setTaxableAmount(ebi60TaxItemType.getLineItemAmount());
            ebi60TaxPercentType = new Ebi60TaxPercentType();
            if (bl) {
                ebi60TaxPercentType.setTaxCategoryCode(string3);
                ebi60TaxPercentType.setValue(BigDecimal.ZERO);
                object2 = null;
                if (taxCategoryType2.hasTaxExemptionReasonEntries()) {
                    object2 = taxCategoryType2.getTaxExemptionReasonAtIndex(0).getValue();
                }
                if (object2 == null && taxCategoryType2.getTaxExemptionReasonCode() != null) {
                    object2 = taxCategoryType2.getTaxExemptionReasonCode().getValue();
                }
                if (StringHelper.hasText((String)object2)) {
                    object3.setComment((String)object2);
                }
            } else {
                ebi60TaxPercentType.setTaxCategoryCode(string3);
                ebi60TaxPercentType.setValue((BigDecimal)object8);
            }
            object3.setTaxPercent(ebi60TaxPercentType);
            if (bl) {
                object3.setTaxAmount(BigDecimal.ZERO);
            } else {
                object3.setTaxAmount(MathHelper.getPercentValue((BigDecimal)object3.getTaxableAmount(), (BigDecimal)object8, (int)2, (RoundingMode)ROUNDING_MODE));
            }
            ebi60TaxItemType.setTaxItem((Ebi60TaxItemType)object3);
            if (MathHelper.isEQ0((BigDecimal)object8)) {
                bigDecimal = bigDecimal.add(ebi60TaxItemType.getLineItemAmount());
            }
            object2 = object92.getOrderLineReference().iterator();
            while (object2.hasNext()) {
                orderLineReferenceType2 = (OrderLineReferenceType)object2.next();
                if (!StringHelper.hasText((String)orderLineReferenceType2.getLineIDValue())) continue;
                object19 = new Ebi60OrderReferenceDetailType();
                object18 = null;
                if (orderLineReferenceType2.getOrderReference() != null) {
                    object18 = StringHelper.trim((String)orderLineReferenceType2.getOrderReference().getIDValue());
                }
                if (StringHelper.hasNoText(object18)) {
                    object18 = object14;
                }
                object19.setOrderID((String)object18);
                object172 = StringHelper.trim((String)orderLineReferenceType2.getLineIDValue());
                if (object172 != null) {
                    if (((String)object172).length() == 0) {
                        errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("InvoiceLine[" + n + "]/OrderLineReference/LineID")).errorText(AbstractToEbInterfaceConverter.EText.ORDERLINE_REF_ID_EMPTY.getDisplayText(this.m_aDisplayLocale))).build());
                    } else {
                        object19.setOrderPositionNumber((String)object172);
                    }
                }
                if (StringHelper.hasText((String)object19.getOrderPositionNumber()) && StringHelper.hasNoText((String)object18)) {
                    if (this.m_aSettings.isOrderReferenceIDMandatory()) {
                        errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("InvoiceLine[" + n + "]/OrderLineReference/OrderReference/ID")).errorText(AbstractToEbInterfaceConverter.EText.ORDER_REFERENCE_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
                    } else {
                        object19.setOrderPositionNumber(null);
                        errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("InvoiceLine[" + n + "]/OrderLineReference/OrderReference/ID")).errorText(AbstractToEbInterfaceConverter.EText.ORDER_REFERENCE_MISSING_IGNORE_ORDER_POS.getDisplayText(this.m_aDisplayLocale))).build());
                    }
                }
                if (!StringHelper.hasText((String)object18)) break;
                ebi60TaxItemType.setInvoiceRecipientsOrderReference(object19);
                break;
            }
            if (object92.hasAllowanceChargeEntries()) {
                object2 = ebi60TaxItemType.getQuantity().getValue().multiply((BigDecimal)object52);
                orderLineReferenceType2 = new Ebi60ReductionAndSurchargeListLineItemDetailsType();
                object19 = ETriState.UNDEFINED;
                for (Object object172 : object92.getAllowanceCharge()) {
                    boolean bl2 = object172.getChargeIndicator().isValue();
                    if (object19.isUndefined()) {
                        object19 = ETriState.valueOf((boolean)bl2);
                    }
                    boolean bl3 = bl2 != object19.isTrue();
                    Ebi60ReductionAndSurchargeBaseType ebi60ReductionAndSurchargeBaseType = new Ebi60ReductionAndSurchargeBaseType();
                    BigDecimal bigDecimal3 = object172.getAmountValue();
                    ebi60ReductionAndSurchargeBaseType.setAmount(bl3 ? bigDecimal3.negate() : bigDecimal3);
                    if (object172.getBaseAmount() != null) {
                        ebi60ReductionAndSurchargeBaseType.setBaseAmount(object172.getBaseAmountValue());
                    }
                    if (ebi60ReductionAndSurchargeBaseType.getBaseAmount() == null) {
                        ebi60ReductionAndSurchargeBaseType.setBaseAmount(object2);
                    }
                    if (object172.getMultiplierFactorNumeric() != null) {
                        BigDecimal bigDecimal4 = object172.getMultiplierFactorNumericValue().multiply(CGlobal.BIGDEC_100);
                        ebi60ReductionAndSurchargeBaseType.setPercentage(bigDecimal4);
                    }
                    if (object19.isTrue()) {
                        orderLineReferenceType2.addReductionListLineItemOrSurchargeListLineItemOrOtherVATableTaxListLineItem(new ObjectFactory().createSurchargeListLineItem(ebi60ReductionAndSurchargeBaseType));
                        object2 = ((BigDecimal)object2).add(ebi60ReductionAndSurchargeBaseType.getAmount());
                    } else {
                        orderLineReferenceType2.addReductionListLineItemOrSurchargeListLineItemOrOtherVATableTaxListLineItem(new ObjectFactory().createReductionListLineItem(ebi60ReductionAndSurchargeBaseType));
                        object2 = ((BigDecimal)object2).subtract(ebi60ReductionAndSurchargeBaseType.getAmount());
                    }
                    ebi60ReductionAndSurchargeBaseType.setComment(InvoiceToEbInterface60Converter.getAllowanceChargeComment((AllowanceChargeType)object172));
                }
                ebi60TaxItemType.setReductionAndSurchargeListLineItemDetails((Ebi60ReductionAndSurchargeListLineItemDetailsType)orderLineReferenceType2);
            }
            if (object92.hasDeliveryEntries() && (object2 = object92.getDeliveryAtIndex(0)).getActualDeliveryDate() != null) {
                orderLineReferenceType2 = InvoiceToEbInterface60Converter.convertDelivery(object2, "InvoiceLine[" + n + "]/Delivery[0]", invoiceType.getAccountingCustomerParty(), errorList, this.m_aContentLocale, this.m_aDisplayLocale);
                ebi60TaxItemType.setDelivery((Ebi60DeliveryType)orderLineReferenceType2);
            }
            for (OrderLineReferenceType orderLineReferenceType2 : object92.getItem().getAdditionalItemProperty()) {
                object19 = null;
                object18 = null;
                if (orderLineReferenceType2.getName() != null) {
                    object19 = orderLineReferenceType2.getName().getValue();
                }
                if (StringHelper.hasNoText((String)object19)) {
                    object19 = orderLineReferenceType2.getIDValue();
                }
                object18 = orderLineReferenceType2.getValueValue();
                if (!StringHelper.hasText((String)object19) || !StringHelper.hasText((String)object18)) continue;
                object172 = new Ebi60AdditionalInformationType();
                object172.setKey((String)object19);
                object172.setValue((String)object18);
                ebi60TaxItemType.addAdditionalInformation((Ebi60AdditionalInformationType)object172);
            }
            if (this.m_aCustomizer != null) {
                this.m_aCustomizer.additionalItemMapping((InvoiceLineType)object92, ebi60TaxItemType);
            }
            object102.addListLineItem((Ebi60ListLineItemType)ebi60TaxItemType);
            ++n;
        }
        object11.addItemList((Ebi60ItemListType)object102);
        ebi60InvoiceType.setDetails((Ebi60DetailsType)object11);
        if (partyTaxSchemeType2.hasNoTaxItemEntries()) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("Invoice")).errorText(AbstractToEbInterfaceConverter.EText.VAT_ITEM_MISSING.getDisplayText(this.m_aDisplayLocale))).build());
        }
        if (invoiceType.hasAllowanceChargeEntries()) {
            object11 = invoiceType.getLegalMonetaryTotal().getLineExtensionAmountValue();
            if (object11 == null) {
                object102 = BigDecimal.ZERO;
                for (Object object20 : ebi60InvoiceType.getDetails().getItemList()) {
                    for (TaxCategoryType taxCategoryType2 : object20.getListLineItem()) {
                        object102 = ((BigDecimal)object102).add(taxCategoryType2.getLineItemAmount());
                    }
                }
                object11 = object102;
            }
            object102 = new Ebi60ReductionAndSurchargeDetailsType();
            n = 0;
            for (Object object92 : invoiceType.getAllowanceCharge()) {
                BigDecimal bigDecimal5;
                boolean bl = object92.getChargeIndicator().isValue();
                object8 = new Ebi60ReductionAndSurchargeType();
                BigDecimal bigDecimal6 = object92.getAmountValue();
                object8.setAmount(bigDecimal6);
                if (object92.getBaseAmount() != null) {
                    object8.setBaseAmount(object92.getBaseAmountValue());
                }
                if (object8.getBaseAmount() == null) {
                    object8.setBaseAmount((BigDecimal)object11);
                }
                if (object92.getMultiplierFactorNumeric() != null) {
                    bigDecimal5 = object92.getMultiplierFactorNumericValue().multiply(CGlobal.BIGDEC_100);
                    object8.setPercentage(bigDecimal5);
                }
                object8.setComment(InvoiceToEbInterface60Converter.getAllowanceChargeComment((AllowanceChargeType)object92));
                bigDecimal5 = null;
                for (Object object72 : object92.getTaxCategory()) {
                    if (object72.getPercent() == null) continue;
                    bigDecimal5 = new Ebi60TaxPercentType();
                    bigDecimal5.setValue(object72.getPercentValue());
                    bigDecimal5.setTaxCategoryCode(object72.getIDValue());
                    break;
                }
                if (bigDecimal5 == null) {
                    errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("Invoice/AllowanceCharge[" + n + "]")).errorText(AbstractToEbInterfaceConverter.EText.ALLOWANCE_CHARGE_NO_TAXRATE.getDisplayText(this.m_aDisplayLocale))).build());
                } else {
                    ebi60TaxItemType = new Ebi60TaxItemType();
                    ebi60TaxItemType.setTaxableAmount(bigDecimal6);
                    ebi60TaxItemType.setTaxPercent((Ebi60TaxPercentType)bigDecimal5);
                    object8.setTaxItem(ebi60TaxItemType);
                }
                if (bl) {
                    object102.addReductionOrSurchargeOrOtherVATableTax(new ObjectFactory().createSurcharge((Ebi60ReductionAndSurchargeType)object8));
                    object11 = ((BigDecimal)object11).add(object8.getAmount());
                } else {
                    object102.addReductionOrSurchargeOrOtherVATableTax(new ObjectFactory().createReduction((Ebi60ReductionAndSurchargeType)object8));
                    object11 = ((BigDecimal)object11).subtract(object8.getAmount());
                }
                ebi60InvoiceType.setReductionAndSurchargeDetails((Ebi60ReductionAndSurchargeDetailsType)object102);
                ++n;
            }
        }
        if ((object11 = invoiceType.getLegalMonetaryTotal()).getPrepaidAmount() != null && !MathHelper.isEQ0((BigDecimal)object11.getPrepaidAmountValue())) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("Invoice/LegalMonetaryTotal/PrepaidAmount")).errorText(AbstractToEbInterfaceConverter.EText.PREPAID_NOT_SUPPORTED.getDisplayText(this.m_aDisplayLocale))).build());
        }
        if (object11.getTaxInclusiveAmountValue() != null) {
            ebi60InvoiceType.setTotalGrossAmount(object11.getTaxInclusiveAmountValue().setScale(2, ROUNDING_MODE));
        } else {
            ebi60InvoiceType.setTotalGrossAmount(object11.getPayableAmountValue().setScale(2, ROUNDING_MODE));
        }
        ebi60InvoiceType.setPayableAmount(object11.getPayableAmountValue().setScale(2, ROUNDING_MODE));
        this.convertPayment(() -> ((InvoiceType)invoiceType).getDueDateValue(), () -> ((InvoiceType)invoiceType).getPaymentMeans(), () -> ((InvoiceType)invoiceType).getPayeeParty(), () -> ((InvoiceType)invoiceType).getAccountingSupplierParty(), () -> ((InvoiceType)invoiceType).getPaymentTerms(), () -> ((InvoiceType)invoiceType).getLegalMonetaryTotal(), errorList, ebi60InvoiceType, false);
        object102 = null;
        n = 0;
        object20 = invoiceType.getDelivery().iterator();
        while (object20.hasNext()) {
            object92 = (DeliveryType)object20.next();
            if (object92.getActualDeliveryDate() != null) {
                object102 = InvoiceToEbInterface60Converter.convertDelivery((DeliveryType)object92, "/Delivery[" + n + "]", invoiceType.getAccountingCustomerParty(), errorList, this.m_aContentLocale, this.m_aDisplayLocale);
                break;
            }
            ++n;
        }
        if (object102 == null) {
            object102 = new Ebi60DeliveryType();
        }
        if ((object20 = (PeriodType)CollectionHelper.getAtIndex((List)invoiceType.getInvoicePeriod(), (int)0)) != null) {
            object92 = object20.getStartDateValue();
            XMLOffsetDate xMLOffsetDate = object20.getEndDateValue();
            if (object92 != null) {
                if (xMLOffsetDate == null) {
                    if (object102.getDate() == null) {
                        object102.setDate((XMLOffsetDate)object92);
                    }
                } else {
                    object8 = new Ebi60PeriodType();
                    object8.setFromDate((XMLOffsetDate)object92);
                    object8.setToDate(xMLOffsetDate);
                    object102.setPeriod((Ebi60PeriodType)object8);
                    object102.setDate((XMLOffsetDate)null);
                }
            }
        }
        if (this.m_aSettings.isDeliveryDateMandatory() && object102.getDate() == null && object102.getPeriod() == null) {
            errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName("Invoice")).errorText(AbstractToEbInterfaceConverter.EText.ERB_NO_DELIVERY_DATE.getDisplayText(this.m_aDisplayLocale))).build());
        }
        if (object102.getDate() != null || object102.getPeriod() != null) {
            ebi60InvoiceType.setDelivery((Ebi60DeliveryType)object102);
        }
        if (this.m_aCustomizer != null) {
            this.m_aCustomizer.additionalGlobalMapping(invoiceType, ebi60InvoiceType);
        }
        return ebi60InvoiceType;
    }
}

