/*
 * Decompiled with CFR 0.152.
 */
package at.austriapro.ebinterface.ubl.helper;

import com.helger.commons.collection.impl.CommonsTreeMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.locale.LocaleCache;
import com.helger.commons.locale.LocaleHelper;
import com.helger.commons.locale.country.CountryCache;
import com.helger.commons.string.StringHelper;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class MultilingualCountryCache {
    private static ICommonsMap<String, Locale> s_aNameToCodeMap = new CommonsTreeMap();

    @Nonnull
    private static String _unify(@Nonnull String string) {
        return string.toLowerCase(Locale.US);
    }

    private MultilingualCountryCache() {
    }

    @Nullable
    public static String getRealCountryCode(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return null;
        }
        String string2 = string.trim();
        if (string2.length() == 0) {
            return null;
        }
        if (CountryCache.getInstance().containsCountry(string2)) {
            return LocaleHelper.getValidCountryCode((String)string2);
        }
        Locale locale = (Locale)s_aNameToCodeMap.get((Object)MultilingualCountryCache._unify(string2));
        if (locale != null) {
            return locale.getCountry();
        }
        return null;
    }

    static {
        Locale locale = Locale.getDefault(Locale.Category.DISPLAY);
        ICommonsList iCommonsList = LocaleCache.getInstance().getAllLocales();
        for (Locale locale2 : iCommonsList) {
            s_aNameToCodeMap.put((Object)MultilingualCountryCache._unify(locale2.getDisplayCountry(locale)), (Object)locale2);
            for (Locale locale3 : iCommonsList) {
                s_aNameToCodeMap.put((Object)MultilingualCountryCache._unify(locale2.getDisplayCountry(locale3)), (Object)locale2);
            }
        }
    }
}

