/*
 * Decompiled with CFR 0.152.
 */
package at.austriapro.ebinterface.ubl.to;

import at.austriapro.ebinterface.ubl.to.AbstractEbInterfaceToUBLConverter;
import com.helger.commons.string.StringHelper;
import com.helger.ebinterface.v40.Ebi40AddressIdentifierType;
import com.helger.ebinterface.v40.Ebi40AddressType;
import com.helger.ebinterface.v40.Ebi40DeliveryType;
import com.helger.ebinterface.v40.Ebi40DocumentTypeType;
import com.helger.xsds.ccts.cct.schemamodule.CodeType;
import java.util.Locale;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.AddressType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.ContactType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.DeliveryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyNameType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PeriodType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PersonType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.IDType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public abstract class AbstractEbInterface40ToUBLConverter
extends AbstractEbInterfaceToUBLConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractEbInterface40ToUBLConverter.class);

    protected AbstractEbInterface40ToUBLConverter(@Nonnull Locale locale, @Nonnull Locale locale2) {
        super(locale, locale2);
    }

    @Nullable
    protected static <T extends CodeType> T getTypeCode(@Nullable Ebi40DocumentTypeType ebi40DocumentTypeType, @Nonnull Supplier<T> supplier) {
        String string = null;
        if (ebi40DocumentTypeType != null) {
            switch (ebi40DocumentTypeType) {
                case INVOICE: 
                case FINAL_SETTLEMENT: 
                case SUBSEQUENT_CREDIT: 
                case SUBSEQUENT_DEBIT: {
                    string = "380";
                    break;
                }
                case CREDIT_MEMO: {
                    string = "381";
                    break;
                }
                case INVOICE_FOR_PARTIAL_DELIVERY: {
                    string = "326";
                    break;
                }
                case INVOICE_FOR_ADVANCE_PAYMENT: {
                    string = "386";
                    break;
                }
                case SELF_BILLING: {
                    string = "389";
                }
            }
        }
        if (string == null) {
            LOGGER.warn("Failed to resolve document type " + ebi40DocumentTypeType);
            return null;
        }
        CodeType codeType = (CodeType)supplier.get();
        codeType.setValue(string);
        codeType.setListID("UNCL1001");
        codeType.setName(ebi40DocumentTypeType.value());
        return (T)codeType;
    }

    @Nullable
    protected static AddressType convertAddress(@Nullable Ebi40AddressType ebi40AddressType, @Nonnull Locale locale) {
        if (ebi40AddressType == null) {
            return null;
        }
        AddressType addressType = new AddressType();
        if (ebi40AddressType.getAddressIdentifier() != null) {
            Ebi40AddressIdentifierType ebi40AddressIdentifierType = ebi40AddressType.getAddressIdentifier();
            IDType iDType = new IDType();
            iDType.setValue(ebi40AddressIdentifierType.getContent());
            if (ebi40AddressIdentifierType.getAddressIdentifierType() != null) {
                iDType.setSchemeID(ebi40AddressIdentifierType.getAddressIdentifierType().value());
            }
            addressType.setID(iDType);
        }
        if (StringHelper.hasText((String)ebi40AddressType.getStreet())) {
            addressType.setStreetName(ebi40AddressType.getStreet());
        }
        if (StringHelper.hasText((String)ebi40AddressType.getPOBox())) {
            addressType.setPostbox(ebi40AddressType.getPOBox());
        }
        if (StringHelper.hasText((String)ebi40AddressType.getTown())) {
            addressType.setCityName(ebi40AddressType.getTown());
        }
        if (StringHelper.hasText((String)ebi40AddressType.getZIP())) {
            addressType.setPostalZone(ebi40AddressType.getZIP());
        }
        if (ebi40AddressType.getCountry() != null) {
            addressType.setCountry(AbstractEbInterface40ToUBLConverter.createCountry(ebi40AddressType.getCountry().getCountryCode() != null ? ebi40AddressType.getCountry().getCountryCode().value() : null, ebi40AddressType.getCountry().getContent(), locale));
        }
        return addressType;
    }

    @Nullable
    protected static PartyType convertParty(@Nullable Ebi40AddressType ebi40AddressType, @Nonnull Locale locale) {
        PartyNameType partyNameType;
        if (ebi40AddressType == null) {
            return null;
        }
        PartyType partyType = new PartyType();
        if (StringHelper.hasText((String)ebi40AddressType.getName())) {
            partyNameType = new PartyNameType();
            partyNameType.setName(ebi40AddressType.getName());
            partyType.addPartyName(partyNameType);
        }
        partyNameType = new ContactType();
        boolean bl = false;
        if (StringHelper.hasText((String)ebi40AddressType.getContact())) {
            partyNameType.setName(ebi40AddressType.getContact());
            bl = true;
        }
        if (StringHelper.hasText((String)ebi40AddressType.getEmail())) {
            partyNameType.setElectronicMail(ebi40AddressType.getEmail());
            bl = true;
        }
        if (StringHelper.hasText((String)ebi40AddressType.getPhone())) {
            partyNameType.setTelephone(ebi40AddressType.getPhone());
            bl = true;
        }
        if (bl) {
            partyType.setContact((ContactType)partyNameType);
        }
        partyType.setPostalAddress(AbstractEbInterface40ToUBLConverter.convertAddress(ebi40AddressType, locale));
        if (StringHelper.hasText((String)ebi40AddressType.getSalutation())) {
            PersonType personType = new PersonType();
            personType.setGenderCode(ebi40AddressType.getSalutation());
            partyType.addPerson(personType);
        }
        return partyType;
    }

    @Nullable
    protected static DeliveryType convertDelivery(@Nullable Ebi40DeliveryType ebi40DeliveryType, @Nonnull Locale locale) {
        if (ebi40DeliveryType == null) {
            return null;
        }
        DeliveryType deliveryType = new DeliveryType();
        if (ebi40DeliveryType.getDeliveryID() != null) {
            deliveryType.setID(ebi40DeliveryType.getDeliveryID());
        }
        if (ebi40DeliveryType.getDate() != null) {
            deliveryType.setActualDeliveryDate(ebi40DeliveryType.getDate());
        } else if (ebi40DeliveryType.getPeriod() != null) {
            PeriodType periodType = new PeriodType();
            periodType.setStartDate(ebi40DeliveryType.getPeriod().getFromDate());
            periodType.setEndDate(ebi40DeliveryType.getPeriod().getToDate());
            deliveryType.setRequestedDeliveryPeriod(periodType);
        }
        deliveryType.setDeliveryAddress(AbstractEbInterface40ToUBLConverter.convertAddress(ebi40DeliveryType.getAddress(), locale));
        deliveryType.setDeliveryParty(AbstractEbInterface40ToUBLConverter.convertParty(ebi40DeliveryType.getAddress(), locale));
        return deliveryType;
    }
}

