/*
 * Decompiled with CFR 0.152.
 */
package at.austriapro.ebinterface.ubl.to;

import at.austriapro.ebinterface.ubl.to.AbstractEbInterfaceToUBLConverter;
import com.helger.commons.string.StringHelper;
import com.helger.ebinterface.v41.Ebi41AddressIdentifierType;
import com.helger.ebinterface.v41.Ebi41AddressType;
import com.helger.ebinterface.v41.Ebi41DeliveryType;
import com.helger.ebinterface.v41.Ebi41DocumentTypeType;
import com.helger.xsds.ccts.cct.schemamodule.CodeType;
import java.util.Locale;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.AddressType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.ContactType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.DeliveryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyNameType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PeriodType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PersonType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.IDType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public abstract class AbstractEbInterface41ToUBLConverter
extends AbstractEbInterfaceToUBLConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractEbInterface41ToUBLConverter.class);

    protected AbstractEbInterface41ToUBLConverter(@Nonnull Locale locale, @Nonnull Locale locale2) {
        super(locale, locale2);
    }

    @Nullable
    protected static <T extends CodeType> T getTypeCode(@Nullable Ebi41DocumentTypeType ebi41DocumentTypeType, @Nonnull Supplier<T> supplier) {
        String string = null;
        if (ebi41DocumentTypeType != null) {
            switch (ebi41DocumentTypeType) {
                case INVOICE: 
                case FINAL_SETTLEMENT: 
                case SUBSEQUENT_CREDIT: 
                case SUBSEQUENT_DEBIT: {
                    string = "380";
                    break;
                }
                case CREDIT_MEMO: {
                    string = "381";
                    break;
                }
                case INVOICE_FOR_PARTIAL_DELIVERY: {
                    string = "326";
                    break;
                }
                case INVOICE_FOR_ADVANCE_PAYMENT: {
                    string = "386";
                    break;
                }
                case SELF_BILLING: {
                    string = "389";
                }
            }
        }
        if (string == null) {
            LOGGER.warn("Failed to resolve document type " + ebi41DocumentTypeType);
            return null;
        }
        CodeType codeType = (CodeType)supplier.get();
        codeType.setValue(string);
        codeType.setListID("UNCL1001");
        codeType.setName(ebi41DocumentTypeType.value());
        return (T)codeType;
    }

    @Nullable
    protected static AddressType convertAddress(@Nullable Ebi41AddressType ebi41AddressType, @Nonnull Locale locale) {
        if (ebi41AddressType == null) {
            return null;
        }
        AddressType addressType = new AddressType();
        if (ebi41AddressType.getAddressIdentifierCount() > 0) {
            Ebi41AddressIdentifierType ebi41AddressIdentifierType = ebi41AddressType.getAddressIdentifierAtIndex(0);
            IDType iDType = new IDType();
            iDType.setValue(ebi41AddressIdentifierType.getValue());
            if (ebi41AddressIdentifierType.getAddressIdentifierType() != null) {
                iDType.setSchemeID(ebi41AddressIdentifierType.getAddressIdentifierType().value());
            }
            addressType.setID(iDType);
        }
        if (StringHelper.hasText((String)ebi41AddressType.getStreet())) {
            addressType.setStreetName(ebi41AddressType.getStreet());
        }
        if (StringHelper.hasText((String)ebi41AddressType.getPOBox())) {
            addressType.setPostbox(ebi41AddressType.getPOBox());
        }
        if (StringHelper.hasText((String)ebi41AddressType.getTown())) {
            addressType.setCityName(ebi41AddressType.getTown());
        }
        if (StringHelper.hasText((String)ebi41AddressType.getZIP())) {
            addressType.setPostalZone(ebi41AddressType.getZIP());
        }
        if (ebi41AddressType.getCountry() != null) {
            addressType.setCountry(AbstractEbInterface41ToUBLConverter.createCountry(ebi41AddressType.getCountry().getCountryCode() != null ? ebi41AddressType.getCountry().getCountryCode().value() : null, ebi41AddressType.getCountry().getContent(), locale));
        }
        return addressType;
    }

    @Nullable
    protected static PartyType convertParty(@Nullable Ebi41AddressType ebi41AddressType, @Nonnull Locale locale) {
        PartyNameType partyNameType;
        if (ebi41AddressType == null) {
            return null;
        }
        PartyType partyType = new PartyType();
        if (StringHelper.hasText((String)ebi41AddressType.getName())) {
            partyNameType = new PartyNameType();
            partyNameType.setName(ebi41AddressType.getName());
            partyType.addPartyName(partyNameType);
        }
        partyNameType = new ContactType();
        boolean bl = false;
        if (StringHelper.hasText((String)ebi41AddressType.getContact())) {
            partyNameType.setName(ebi41AddressType.getContact());
            bl = true;
        }
        if (StringHelper.hasText((String)ebi41AddressType.getEmail())) {
            partyNameType.setElectronicMail(ebi41AddressType.getEmail());
            bl = true;
        }
        if (StringHelper.hasText((String)ebi41AddressType.getPhone())) {
            partyNameType.setTelephone(ebi41AddressType.getPhone());
            bl = true;
        }
        if (bl) {
            partyType.setContact((ContactType)partyNameType);
        }
        partyType.setPostalAddress(AbstractEbInterface41ToUBLConverter.convertAddress(ebi41AddressType, locale));
        if (StringHelper.hasText((String)ebi41AddressType.getSalutation())) {
            PersonType personType = new PersonType();
            personType.setGenderCode(ebi41AddressType.getSalutation());
            partyType.addPerson(personType);
        }
        return partyType;
    }

    @Nullable
    protected static DeliveryType convertDelivery(@Nullable Ebi41DeliveryType ebi41DeliveryType, @Nonnull Locale locale) {
        if (ebi41DeliveryType == null) {
            return null;
        }
        DeliveryType deliveryType = new DeliveryType();
        if (ebi41DeliveryType.getDeliveryID() != null) {
            deliveryType.setID(ebi41DeliveryType.getDeliveryID());
        }
        if (ebi41DeliveryType.getDate() != null) {
            deliveryType.setActualDeliveryDate(ebi41DeliveryType.getDate());
        } else if (ebi41DeliveryType.getPeriod() != null) {
            PeriodType periodType = new PeriodType();
            periodType.setStartDate(ebi41DeliveryType.getPeriod().getFromDate());
            periodType.setEndDate(ebi41DeliveryType.getPeriod().getToDate());
            deliveryType.setRequestedDeliveryPeriod(periodType);
        }
        deliveryType.setDeliveryAddress(AbstractEbInterface41ToUBLConverter.convertAddress(ebi41DeliveryType.getAddress(), locale));
        deliveryType.setDeliveryParty(AbstractEbInterface41ToUBLConverter.convertParty(ebi41DeliveryType.getAddress(), locale));
        return deliveryType;
    }
}

