/*
 * Decompiled with CFR 0.152.
 */
package at.austriapro.ebinterface.ubl.to;

import at.austriapro.ebinterface.ubl.to.AbstractEbInterfaceToUBLConverter;
import com.helger.commons.string.StringHelper;
import com.helger.ebinterface.v42.Ebi42AddressIdentifierType;
import com.helger.ebinterface.v42.Ebi42AddressType;
import com.helger.ebinterface.v42.Ebi42DeliveryType;
import com.helger.ebinterface.v42.Ebi42DocumentTypeType;
import com.helger.xsds.ccts.cct.schemamodule.CodeType;
import java.util.Locale;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.AddressType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.ContactType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.DeliveryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyNameType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PeriodType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PersonType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.IDType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public abstract class AbstractEbInterface42ToUBLConverter
extends AbstractEbInterfaceToUBLConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractEbInterface42ToUBLConverter.class);

    protected AbstractEbInterface42ToUBLConverter(@Nonnull Locale locale, @Nonnull Locale locale2) {
        super(locale, locale2);
    }

    @Nullable
    protected static <T extends CodeType> T getTypeCode(@Nullable Ebi42DocumentTypeType ebi42DocumentTypeType, @Nonnull Supplier<T> supplier) {
        String string = null;
        if (ebi42DocumentTypeType != null) {
            switch (ebi42DocumentTypeType) {
                case INVOICE: 
                case FINAL_SETTLEMENT: 
                case SUBSEQUENT_CREDIT: 
                case SUBSEQUENT_DEBIT: {
                    string = "380";
                    break;
                }
                case CREDIT_MEMO: {
                    string = "381";
                    break;
                }
                case INVOICE_FOR_PARTIAL_DELIVERY: {
                    string = "326";
                    break;
                }
                case INVOICE_FOR_ADVANCE_PAYMENT: {
                    string = "386";
                    break;
                }
                case SELF_BILLING: {
                    string = "389";
                }
            }
        }
        if (string == null) {
            LOGGER.warn("Failed to resolve document type " + ebi42DocumentTypeType);
            return null;
        }
        CodeType codeType = (CodeType)supplier.get();
        codeType.setValue(string);
        codeType.setListID("UNCL1001");
        codeType.setName(ebi42DocumentTypeType.value());
        return (T)codeType;
    }

    @Nullable
    protected static AddressType convertAddress(@Nullable Ebi42AddressType ebi42AddressType, @Nonnull Locale locale) {
        if (ebi42AddressType == null) {
            return null;
        }
        AddressType addressType = new AddressType();
        if (ebi42AddressType.getAddressIdentifierCount() > 0) {
            Ebi42AddressIdentifierType ebi42AddressIdentifierType = ebi42AddressType.getAddressIdentifierAtIndex(0);
            IDType iDType = new IDType();
            iDType.setValue(ebi42AddressIdentifierType.getValue());
            if (ebi42AddressIdentifierType.getAddressIdentifierType() != null) {
                iDType.setSchemeID(ebi42AddressIdentifierType.getAddressIdentifierType().value());
            }
            addressType.setID(iDType);
        }
        if (StringHelper.hasText((String)ebi42AddressType.getStreet())) {
            addressType.setStreetName(ebi42AddressType.getStreet());
        }
        if (StringHelper.hasText((String)ebi42AddressType.getPOBox())) {
            addressType.setPostbox(ebi42AddressType.getPOBox());
        }
        if (StringHelper.hasText((String)ebi42AddressType.getTown())) {
            addressType.setCityName(ebi42AddressType.getTown());
        }
        if (StringHelper.hasText((String)ebi42AddressType.getZIP())) {
            addressType.setPostalZone(ebi42AddressType.getZIP());
        }
        if (ebi42AddressType.getCountry() != null) {
            addressType.setCountry(AbstractEbInterface42ToUBLConverter.createCountry(ebi42AddressType.getCountry().getCountryCode(), ebi42AddressType.getCountry().getValue(), locale));
        }
        return addressType;
    }

    @Nullable
    protected static PartyType convertParty(@Nullable Ebi42AddressType ebi42AddressType, @Nonnull Locale locale) {
        PartyNameType partyNameType;
        if (ebi42AddressType == null) {
            return null;
        }
        PartyType partyType = new PartyType();
        if (StringHelper.hasText((String)ebi42AddressType.getName())) {
            partyNameType = new PartyNameType();
            partyNameType.setName(ebi42AddressType.getName());
            partyType.addPartyName(partyNameType);
        }
        partyNameType = new ContactType();
        boolean bl = false;
        if (StringHelper.hasText((String)ebi42AddressType.getContact())) {
            partyNameType.setName(ebi42AddressType.getContact());
            bl = true;
        }
        if (StringHelper.hasText((String)ebi42AddressType.getEmail())) {
            partyNameType.setElectronicMail(ebi42AddressType.getEmail());
            bl = true;
        }
        if (StringHelper.hasText((String)ebi42AddressType.getPhone())) {
            partyNameType.setTelephone(ebi42AddressType.getPhone());
            bl = true;
        }
        if (bl) {
            partyType.setContact((ContactType)partyNameType);
        }
        partyType.setPostalAddress(AbstractEbInterface42ToUBLConverter.convertAddress(ebi42AddressType, locale));
        if (StringHelper.hasText((String)ebi42AddressType.getSalutation())) {
            PersonType personType = new PersonType();
            personType.setGenderCode(ebi42AddressType.getSalutation());
            partyType.addPerson(personType);
        }
        return partyType;
    }

    @Nullable
    protected static DeliveryType convertDelivery(@Nullable Ebi42DeliveryType ebi42DeliveryType, @Nonnull Locale locale) {
        if (ebi42DeliveryType == null) {
            return null;
        }
        DeliveryType deliveryType = new DeliveryType();
        if (ebi42DeliveryType.getDeliveryID() != null) {
            deliveryType.setID(ebi42DeliveryType.getDeliveryID());
        }
        if (ebi42DeliveryType.getDate() != null) {
            deliveryType.setActualDeliveryDate(ebi42DeliveryType.getDate());
        } else if (ebi42DeliveryType.getPeriod() != null) {
            PeriodType periodType = new PeriodType();
            periodType.setStartDate(ebi42DeliveryType.getPeriod().getFromDate());
            periodType.setEndDate(ebi42DeliveryType.getPeriod().getToDate());
            deliveryType.setRequestedDeliveryPeriod(periodType);
        }
        deliveryType.setDeliveryAddress(AbstractEbInterface42ToUBLConverter.convertAddress(ebi42DeliveryType.getAddress(), locale));
        deliveryType.setDeliveryParty(AbstractEbInterface42ToUBLConverter.convertParty(ebi42DeliveryType.getAddress(), locale));
        return deliveryType;
    }
}

