/*
 * Decompiled with CFR 0.152.
 */
package at.austriapro.ebinterface.ubl.to;

import at.austriapro.ebinterface.ubl.to.AbstractEbInterfaceToUBLConverter;
import com.helger.commons.string.StringHelper;
import com.helger.ebinterface.v43.Ebi43AddressIdentifierType;
import com.helger.ebinterface.v43.Ebi43AddressType;
import com.helger.ebinterface.v43.Ebi43DeliveryType;
import com.helger.ebinterface.v43.Ebi43DocumentTypeType;
import com.helger.xsds.ccts.cct.schemamodule.CodeType;
import java.util.Locale;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.AddressType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.ContactType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.DeliveryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyNameType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PeriodType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PersonType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.IDType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public abstract class AbstractEbInterface43ToUBLConverter
extends AbstractEbInterfaceToUBLConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractEbInterface43ToUBLConverter.class);

    protected AbstractEbInterface43ToUBLConverter(@Nonnull Locale locale, @Nonnull Locale locale2) {
        super(locale, locale2);
    }

    @Nullable
    protected static <T extends CodeType> T getTypeCode(@Nullable Ebi43DocumentTypeType ebi43DocumentTypeType, @Nonnull Supplier<T> supplier) {
        String string = null;
        if (ebi43DocumentTypeType != null) {
            switch (ebi43DocumentTypeType) {
                case INVOICE: 
                case FINAL_SETTLEMENT: 
                case SUBSEQUENT_CREDIT: 
                case SUBSEQUENT_DEBIT: {
                    string = "380";
                    break;
                }
                case CREDIT_MEMO: {
                    string = "381";
                    break;
                }
                case INVOICE_FOR_PARTIAL_DELIVERY: {
                    string = "326";
                    break;
                }
                case INVOICE_FOR_ADVANCE_PAYMENT: {
                    string = "386";
                    break;
                }
                case SELF_BILLING: {
                    string = "389";
                }
            }
        }
        if (string == null) {
            LOGGER.warn("Failed to resolve document type " + ebi43DocumentTypeType);
            return null;
        }
        CodeType codeType = (CodeType)supplier.get();
        codeType.setValue(string);
        codeType.setListID("UNCL1001");
        codeType.setName(ebi43DocumentTypeType.value());
        return (T)codeType;
    }

    @Nullable
    protected static AddressType convertAddress(@Nullable Ebi43AddressType ebi43AddressType, @Nonnull Locale locale) {
        if (ebi43AddressType == null) {
            return null;
        }
        AddressType addressType = new AddressType();
        if (ebi43AddressType.getAddressIdentifierCount() > 0) {
            Ebi43AddressIdentifierType ebi43AddressIdentifierType = ebi43AddressType.getAddressIdentifierAtIndex(0);
            IDType iDType = new IDType();
            iDType.setValue(ebi43AddressIdentifierType.getValue());
            if (ebi43AddressIdentifierType.getAddressIdentifierType() != null) {
                iDType.setSchemeID(ebi43AddressIdentifierType.getAddressIdentifierType().value());
            }
            addressType.setID(iDType);
        }
        if (StringHelper.hasText((String)ebi43AddressType.getStreet())) {
            addressType.setStreetName(ebi43AddressType.getStreet());
        }
        if (StringHelper.hasText((String)ebi43AddressType.getPOBox())) {
            addressType.setPostbox(ebi43AddressType.getPOBox());
        }
        if (StringHelper.hasText((String)ebi43AddressType.getTown())) {
            addressType.setCityName(ebi43AddressType.getTown());
        }
        if (StringHelper.hasText((String)ebi43AddressType.getZIP())) {
            addressType.setPostalZone(ebi43AddressType.getZIP());
        }
        if (ebi43AddressType.getCountry() != null) {
            addressType.setCountry(AbstractEbInterface43ToUBLConverter.createCountry(ebi43AddressType.getCountry().getCountryCode(), ebi43AddressType.getCountry().getValue(), locale));
        }
        return addressType;
    }

    @Nullable
    protected static PartyType convertParty(@Nullable Ebi43AddressType ebi43AddressType, @Nonnull Locale locale) {
        PartyNameType partyNameType;
        if (ebi43AddressType == null) {
            return null;
        }
        PartyType partyType = new PartyType();
        if (StringHelper.hasText((String)ebi43AddressType.getName())) {
            partyNameType = new PartyNameType();
            partyNameType.setName(ebi43AddressType.getName());
            partyType.addPartyName(partyNameType);
        }
        partyNameType = new ContactType();
        boolean bl = false;
        if (StringHelper.hasText((String)ebi43AddressType.getContact())) {
            partyNameType.setName(ebi43AddressType.getContact());
            bl = true;
        }
        if (StringHelper.hasText((String)ebi43AddressType.getEmail())) {
            partyNameType.setElectronicMail(ebi43AddressType.getEmail());
            bl = true;
        }
        if (StringHelper.hasText((String)ebi43AddressType.getPhone())) {
            partyNameType.setTelephone(ebi43AddressType.getPhone());
            bl = true;
        }
        if (bl) {
            partyType.setContact((ContactType)partyNameType);
        }
        partyType.setPostalAddress(AbstractEbInterface43ToUBLConverter.convertAddress(ebi43AddressType, locale));
        if (StringHelper.hasText((String)ebi43AddressType.getSalutation())) {
            PersonType personType = new PersonType();
            personType.setGenderCode(ebi43AddressType.getSalutation());
            partyType.addPerson(personType);
        }
        return partyType;
    }

    @Nullable
    protected static DeliveryType convertDelivery(@Nullable Ebi43DeliveryType ebi43DeliveryType, @Nonnull Locale locale) {
        if (ebi43DeliveryType == null) {
            return null;
        }
        DeliveryType deliveryType = new DeliveryType();
        if (ebi43DeliveryType.getDeliveryID() != null) {
            deliveryType.setID(ebi43DeliveryType.getDeliveryID());
        }
        if (ebi43DeliveryType.getDate() != null) {
            deliveryType.setActualDeliveryDate(ebi43DeliveryType.getDate());
        } else if (ebi43DeliveryType.getPeriod() != null) {
            PeriodType periodType = new PeriodType();
            periodType.setStartDate(ebi43DeliveryType.getPeriod().getFromDate());
            periodType.setEndDate(ebi43DeliveryType.getPeriod().getToDate());
            deliveryType.setRequestedDeliveryPeriod(periodType);
        }
        deliveryType.setDeliveryAddress(AbstractEbInterface43ToUBLConverter.convertAddress(ebi43DeliveryType.getAddress(), locale));
        deliveryType.setDeliveryParty(AbstractEbInterface43ToUBLConverter.convertParty(ebi43DeliveryType.getAddress(), locale));
        return deliveryType;
    }
}

