/*
 * Decompiled with CFR 0.152.
 */
package at.austriapro.ebinterface.ubl.to;

import at.austriapro.ebinterface.ubl.to.AbstractEbInterfaceToUBLConverter;
import com.helger.commons.collection.impl.CommonsLinkedHashSet;
import com.helger.commons.string.StringHelper;
import com.helger.ebinterface.v50.Ebi50AddressIdentifierType;
import com.helger.ebinterface.v50.Ebi50AddressType;
import com.helger.ebinterface.v50.Ebi50ContactType;
import com.helger.ebinterface.v50.Ebi50DeliveryType;
import com.helger.ebinterface.v50.Ebi50DocumentTypeType;
import com.helger.xsds.ccts.cct.schemamodule.CodeType;
import java.util.Collection;
import java.util.Locale;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.AddressType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.ContactType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.DeliveryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyNameType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PeriodType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PersonType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.IDType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public abstract class AbstractEbInterface50ToUBLConverter
extends AbstractEbInterfaceToUBLConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractEbInterface50ToUBLConverter.class);

    protected AbstractEbInterface50ToUBLConverter(@Nonnull Locale locale, @Nonnull Locale locale2) {
        super(locale, locale2);
    }

    @Nullable
    protected static <T extends CodeType> T getTypeCode(@Nullable Ebi50DocumentTypeType ebi50DocumentTypeType, @Nonnull Supplier<T> supplier) {
        String string = null;
        if (ebi50DocumentTypeType != null) {
            switch (ebi50DocumentTypeType) {
                case INVOICE: 
                case FINAL_SETTLEMENT: 
                case SUBSEQUENT_CREDIT: 
                case SUBSEQUENT_DEBIT: {
                    string = "380";
                    break;
                }
                case CREDIT_MEMO: {
                    string = "381";
                    break;
                }
                case INVOICE_FOR_PARTIAL_DELIVERY: {
                    string = "326";
                    break;
                }
                case INVOICE_FOR_ADVANCE_PAYMENT: {
                    string = "386";
                    break;
                }
                case SELF_BILLING: {
                    string = "389";
                }
            }
        }
        if (string == null) {
            LOGGER.warn("Failed to resolve document type " + ebi50DocumentTypeType);
            return null;
        }
        CodeType codeType = (CodeType)supplier.get();
        codeType.setValue(string);
        codeType.setListID("UNCL1001");
        codeType.setName(ebi50DocumentTypeType.value());
        return (T)codeType;
    }

    @Nullable
    protected static AddressType convertAddress(@Nullable Ebi50AddressType ebi50AddressType, @Nonnull Locale locale) {
        if (ebi50AddressType == null) {
            return null;
        }
        AddressType addressType = new AddressType();
        if (ebi50AddressType.getAddressIdentifierCount() > 0) {
            Ebi50AddressIdentifierType ebi50AddressIdentifierType = ebi50AddressType.getAddressIdentifierAtIndex(0);
            IDType iDType = new IDType();
            iDType.setValue(ebi50AddressIdentifierType.getValue());
            if (ebi50AddressIdentifierType.getAddressIdentifierType() != null) {
                iDType.setSchemeID(ebi50AddressIdentifierType.getAddressIdentifierType());
            }
            addressType.setID(iDType);
        }
        if (StringHelper.hasText((String)ebi50AddressType.getStreet())) {
            addressType.setStreetName(ebi50AddressType.getStreet());
        }
        if (StringHelper.hasText((String)ebi50AddressType.getPOBox())) {
            addressType.setPostbox(ebi50AddressType.getPOBox());
        }
        if (StringHelper.hasText((String)ebi50AddressType.getTown())) {
            addressType.setCityName(ebi50AddressType.getTown());
        }
        if (StringHelper.hasText((String)ebi50AddressType.getZIP())) {
            addressType.setPostalZone(ebi50AddressType.getZIP());
        }
        if (ebi50AddressType.getCountry() != null) {
            addressType.setCountry(AbstractEbInterface50ToUBLConverter.createCountry(ebi50AddressType.getCountry().getCountryCode(), ebi50AddressType.getCountry().getValue(), locale));
        }
        return addressType;
    }

    @Nullable
    protected static PartyType convertParty(@Nullable Ebi50AddressType ebi50AddressType, @Nullable Ebi50ContactType ebi50ContactType, @Nonnull Locale locale) {
        ContactType contactType;
        if (ebi50AddressType == null && ebi50ContactType == null) {
            return null;
        }
        CommonsLinkedHashSet commonsLinkedHashSet = new CommonsLinkedHashSet();
        CommonsLinkedHashSet commonsLinkedHashSet2 = new CommonsLinkedHashSet();
        PartyType partyType = new PartyType();
        if (ebi50AddressType != null) {
            if (StringHelper.hasText((String)ebi50AddressType.getName())) {
                contactType = new PartyNameType();
                contactType.setName(ebi50AddressType.getName());
                partyType.addPartyName((PartyNameType)contactType);
            }
            partyType.setPostalAddress(AbstractEbInterface50ToUBLConverter.convertAddress(ebi50AddressType, locale));
            commonsLinkedHashSet.addAll((Collection)ebi50AddressType.getEmail());
            commonsLinkedHashSet2.addAll((Collection)ebi50AddressType.getPhone());
        }
        contactType = new ContactType();
        boolean bl = false;
        if (ebi50ContactType != null) {
            if (StringHelper.hasText((String)ebi50ContactType.getSalutation())) {
                PersonType personType = new PersonType();
                personType.setGenderCode(ebi50ContactType.getSalutation());
                partyType.addPerson(personType);
            }
            if (StringHelper.hasText((String)ebi50ContactType.getName())) {
                contactType.setName(ebi50ContactType.getName());
                bl = true;
            }
            commonsLinkedHashSet.addAll((Collection)ebi50ContactType.getEmail());
            commonsLinkedHashSet2.addAll((Collection)ebi50ContactType.getPhone());
        }
        if (commonsLinkedHashSet.isNotEmpty()) {
            contactType.setElectronicMail(StringHelper.getImploded((char)' ', (Iterable)commonsLinkedHashSet));
            bl = true;
        }
        if (commonsLinkedHashSet2.isNotEmpty()) {
            contactType.setTelephone(StringHelper.getImploded((char)' ', (Iterable)commonsLinkedHashSet2));
            bl = true;
        }
        if (bl) {
            partyType.setContact(contactType);
        }
        return partyType;
    }

    @Nullable
    protected static DeliveryType convertDelivery(@Nullable Ebi50DeliveryType ebi50DeliveryType, @Nonnull Locale locale) {
        if (ebi50DeliveryType == null) {
            return null;
        }
        DeliveryType deliveryType = new DeliveryType();
        if (ebi50DeliveryType.getDeliveryID() != null) {
            deliveryType.setID(ebi50DeliveryType.getDeliveryID());
        }
        if (ebi50DeliveryType.getDate() != null) {
            deliveryType.setActualDeliveryDate(ebi50DeliveryType.getDate());
        } else if (ebi50DeliveryType.getPeriod() != null) {
            PeriodType periodType = new PeriodType();
            periodType.setStartDate(ebi50DeliveryType.getPeriod().getFromDate());
            periodType.setEndDate(ebi50DeliveryType.getPeriod().getToDate());
            deliveryType.setRequestedDeliveryPeriod(periodType);
        }
        deliveryType.setDeliveryAddress(AbstractEbInterface50ToUBLConverter.convertAddress(ebi50DeliveryType.getAddress(), locale));
        deliveryType.setDeliveryParty(AbstractEbInterface50ToUBLConverter.convertParty(ebi50DeliveryType.getAddress(), ebi50DeliveryType.getContact(), locale));
        return deliveryType;
    }
}

